# -*- coding: utf-8 -*-
import sys
from netmiko import ConnectHandler
import multiprocessing
import base64
import re

p = open('pass64.txt')

def doRouter(connection_data):

    ip_address = connection_data[0].strip()
    username = connection_data[1]
    password = connection_data[2]

    ip_check = re.findall("^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$", ip_address)
    if ip_check == []:
        print("Invalid IP - " + str(ip_address))
        return ip_address

    device = {
        'device_type': 'cisco_ios',
        'ip': ip_address,
        'username': username,
        'password': password,
        'port': 22, }
    try:
        config_ok = True
        net_connect = ConnectHandler(**device)
        print(connection_data[0])

   
        config_file = open('log\\' + connection_data[0] + '.cisco', 'w')
        interfaces=[]
        cli_response = net_connect.send_command("sh int status | e Status|^Po[0-9]")
        list_interfaces = cli_response.splitlines()
        for i in list_interfaces:
            if i!="":
               interface=i.split(" ")
               interfaces.append(interface[0])
               
        config_commands=[]
        for interface in interfaces:
            cli_response = net_connect.send_command("sh cdp ne "+interface)
            cdp_list=cli_response.splitlines()
            if len(cdp_list)>7:
               cdp=cdp_list[5].split('.')[0]
               print(ip_address+'	'+interface+'	'+cdp)
               config_commands.append('interface '+interface)
               config_commands.append('description '+cdp)
        print(config_commands)
        cli_response=net_connect.send_config_set(config_commands)
        config_file.write(cli_response)

#------------------
        cli_response=net_connect.send_command_timing("write")
        print(cli_response)
        net_connect.disconnect()

    except:
        print(str(ip_address)+" Cannot connect to this device.")
        config_file = open('no_connect.txt', 'a')
        config_file.write(ip_address.strip()+"\n")
        return ip_address
#------------------

if __name__ == '__main__':

    # Enter valid username and password. Note password is blanked out using the getpass library

    filelines = p.read().splitlines()

    global_username_d=filelines[0].encode('utf-8')
    global_password_d=filelines[1].encode('utf-8')
    
    data_username=base64.b64decode(global_username_d)
    data_password=base64.b64decode(global_password_d)
    
    global_username=data_username.decode('utf-8')
    global_password=data_password.decode('utf-8')

    try:
        f = open('cisco.ini')
        connection_data=[]
        filelines = f.read().splitlines()
        for line in filelines:
            if line == "": continue
            if line[0] == "#": continue
            if line[0] == "!": continue
#            print(line)
            connection_data.append((line, global_username, global_password))
        f.close()
    except:
        print("no file cisco.ini")

    multiprocessing.set_start_method("spawn")
    with multiprocessing.Pool(maxtasksperchild=1) as process_pool:
        routers_with_issues = process_pool.map(doRouter, connection_data, 1)  # doRouter - function, iplist - argument
        process_pool.close()
        process_pool.join()
