#!/usr/bin/env python

## Tiny Syslog Server in Python.
##
## This is a tiny syslog server that is able to receive UDP based syslog
## entries on a specified port and save them to a file.
## Added saving to separate files based on the date

HOST, PORT = "0.0.0.0", 514
mpath = '%Y\\%m\\all_log'
mfile = '%d-%m-%Y.log'
#
# NO USER SERVICEABLE PARTS BELOW HERE...
#

import re
import os
import socketserver
from datetime import datetime, date, time
import ipaddress

err_level_str=['emergencies','alerts','critical','errors','warnings','notifications','informational','debugging']

filelines=[]
try:
    f = open('filter.ini')
    filelines = f.read().splitlines()
    f.close()
except:
    print("no file filter.ini")

    
def log_path_file(short_path,s_filename): 
    today = datetime.now()
    path=today.strftime(short_path)
    if not os.path.exists(path):
        os.makedirs(path)
        print("create  "+path)
    path+=today.strftime("\\"+s_filename)
    return path
    
def write_syslog(s_path,s_filename,s_msg):
    config_file_name = log_path_file(s_path,s_filename)
    config_file = open(config_file_name, 'a')
    config_file.write(s_msg+"\n")
    config_file.close()        

class SyslogUDPHandler(socketserver.BaseRequestHandler):

    def handle(self):
        data = bytes.decode(self.request[0].strip())
        err_level=int(re.findall("<(\d+)>", str(data))[0]) & 7
        syslog_ip=str(self.client_address[0])
        syslog_str=str(data)[str(data).find(":"):]
        write_msg=syslog_ip+"	: "+str(err_level)+syslog_str

        # write all datelog
        write_syslog(mpath,mfile,write_msg)
        print(write_msg)
        
        # Filters
        for line in filelines:
            if line.strip() == "": continue
            if line[0] == "#": continue
            if line[0] == "!": continue
            try:
                arg =line.split()[1]
                # Filter path
                path=line.split()[2].replace('%IP',syslog_ip).replace('%L',err_level_str[err_level]).replace('%l',str(err_level))
                # Filter file name
                filename=mfile
                if len(line.split())>3:
                   filename=line.split()[3].replace('%IP',syslog_ip).replace('%L',err_level_str[err_level]).replace('%l',str(err_level))
                # Filter on IP 
                if line.split()[0]=='ip':
                   if ipaddress.ip_address(syslog_ip) in ipaddress.ip_network(arg).hosts():
                      write_syslog(path,filename,write_msg)
                # Filter on MSG
                if line.split()[0]=='msg':
                   if arg in syslog_str: write_syslog(path,filename,write_msg)
                # Filter on level
                if line.split()[0]=='level':
                   if int(arg) == err_level: write_syslog(path,filename,write_msg)
            except:
                print('Error filter.ini\n'+line)
if __name__ == "__main__":
    try:
        server = socketserver.UDPServer((HOST,PORT), SyslogUDPHandler)
        server.serve_forever(poll_interval=0.5)
    except (IOError, SystemExit):
        raise
    except KeyboardInterrupt:
        print ("Crtl+C Pressed. Shutting down.")
        