# -*- coding: utf-8 -*-
from netmiko import ConnectHandler, NetmikoTimeoutException
from datetime import datetime, date, time
import msvcrt
import base64
import sys
from colorama import init , Fore
from colorama import Back
from colorama import Style
import re
import time
import getpass
import os


basecolor= '\033[37m'

flagout=False
dataout=""

init(autoreset=True)

if len(sys.argv)>1:
   ip_address=sys.argv[1].replace(',',".")
else:
   ip_address = input("Enter ip address: ")
if len(sys.argv)>2:
   username = sys.argv[2]
else:
   username = input("Enter Username: ")
if len(sys.argv)>3:
   password = sys.argv[3]
else:
   password = getpass.getpass("Enter Password: ")

dt=datetime.today()
fileout=dt.strftime(os.path.splitext(sys.argv[0])[0]+"_%Y.%m.%d_"+ip_address+".log")

MySSH = open(os.path.splitext(sys.argv[0])[0]+'.ini')
MySSHlines = MySSH.read().splitlines()

MyColor=[]
MyKey=[]
MyFlag=1
Mydevice_type='cisco_ios'

for line in MySSHlines:
    if line == "": continue
    if line[0] == "!": continue
    if line[0] == "#": continue
    if line=='end':
       MyFlag = 0
       continue
    if line=='color':
       MyFlag = 1
       continue
    if line=='fkey': 
       MyFlag = 2
       continue
    if line=='device_type': 
       MyFlag = 3
       continue
    if MyFlag==1:  MyColor.append(line)
    if MyFlag==2:  MyKey.append(line)
    if MyFlag==3:  Mydevice_type=line

print(Mydevice_type)
    
device = {
    'device_type': Mydevice_type,
    'ip': ip_address,
    'username': username,
    'password': password,
    'port': 22, }
    
def print_color(str_cli):
        for line in MyColor:
            if len(line.split("	"))<2: continue
            line0=line.split("	")[1]
            line1=line.split("	")[0]
            reg_exp=r''+line0+r''
            color='\033['+line1+'m'
            f_colors = re.findall(reg_exp,str_cli)
        
            for f_color in f_colors:
                str_cli=str_cli.replace(f_color,color+f_color+basecolor)
        if str_cli>"":
            if str_cli[0] == " ":
               str_cli=Style.DIM+str_cli+Style.RESET_ALL
            else:
               str_cli=Style.BRIGHT+str_cli+Style.RESET_ALL
        return str_cli
       

def print_color_str(data_cli):
    if flagout: dataout.write(data_cli)
    macc_cli=data_cli.split('\n')
    mass_color_cli=[]
    for str_cli in macc_cli:
        mass_color_cli.append(print_color(str_cli))
  
    sys.stdout.write('\n'.join(mass_color_cli))
    sys.stdout.flush()
    

def send_show_command_str():
      try:
          cli=ssh.read_channel()
          if cli>"":
#             if strlen(cli)sys.stdout.write('\n')
             print_color_str( cli )
      except NetmikoTimeoutException:
          return


def PRINT_HELP_STR(key,txt): 
    print(Back.CYAN+Fore.BLACK+key+Style.RESET_ALL+"\t"+txt)

def PRINT_HELP(): 
    PRINT_HELP_STR("F1","Список клавиш")
    PRINT_HELP_STR("F2","Начать/прекратить протоколирование в "+fileout)
    PRINT_HELP_STR("Ctrl F2","Продолжить/прекратить протоколирование в "+fileout)
    for line in MyKey:
        if len(line.split("	"))<3: continue
        PRINT_HELP_STR(line.split("	")[1],line.split("	")[2].replace('\\n',''))
 
with ConnectHandler(**device) as ssh:
   print("Connect")
   ssh.write_channel("\n")
#   time.sleep(0.1)
   flag=False
   while True:    
      try:
        if msvcrt.kbhit():
           n=ord(msvcrt.getch())
           if n==127: n=21   # CTRL BS Удалить до начала строки
           if n==224: flag=True
           if n==0: flag=True
           if flag:
              if n==75:       # Влево
                 ssh.write_channel(chr(2))
              if n==77:       # Вправо
                 ssh.write_channel(chr(6))
              if n==72:       # Вверх
                 ssh.write_channel(chr(16))
              if n==80:       # Вниз
                 ssh.write_channel(chr(14))
              if n==83:       # Delete
                 ssh.write_channel(chr(4))
              if n==147:      # CTRL Delete удалить до конца строки
                 ssh.write_channel(chr(11))
              if n==71:       # Home
                 ssh.write_channel(chr(1))
              if n==79:       # End
                 ssh.write_channel(chr(5))
              if n==73:       # PgUp  слово влево
                 ssh.write_channel(chr(27)+chr(98))
              if n==81:       # PgDn  слово вправо
                 ssh.write_channel(chr(27)+chr(102))
              if n==59:       # F1 ?
                 print("\n")
                 PRINT_HELP()
                 ssh.write_channel(chr(3))
#                 ssh.write_channel(chr(12))
              if (n==60) or (n==95):       # F2 ?
                 if flagout:
                    flagout = False
                    dataout.close()
                    print(Fore.RED+"\nЗапись в "+fileout+" окончена"+Style.RESET_ALL)
#                    ssh.write_channel(chr(12))
                    ssh.write_channel(chr(3))
                 else:
                    flagout = True
                    if n==60: dataout = open(fileout,'w')
                    else:  dataout = open(fileout,'a')
                    print(Fore.GREEN+"\nЗапись в "+fileout+" начата"+Style.RESET_ALL)
#                    ssh.write_channel(chr(12))
                    ssh.write_channel(chr(3))
                    
#	F key 
              for line in MyKey:
                  if len(line.split("	"))<3: continue
                  if n==int(line.split("	")[0]):
                     ssh.write_channel(chr(3))
                     cmd=line.split("	")[2]
                     ssh.write_channel(cmd.replace('\\n',chr(13)))

           else:
              if (n==10) or (n==13): 
                  ssh.write_channel(chr(10))
              else:
                  ssh.write_channel(chr(n))
 
           if (n!=224) and (n!=0): flag=False
        send_show_command_str()
      except:
        ssh.write_channel(chr(3))
  