# -*- coding: utf-8 -*-
import sys
from netmiko import ConnectHandler
import multiprocessing
import base64
import re

p = open('pass64.txt')

def doRouter(connection_data):

    ip_address = connection_data[0].strip()
    username = connection_data[1]
    password = connection_data[2]

    ip_check = re.findall("^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$", ip_address)
    if ip_check == []:
        print("Invalid IP - " + str(ip_address))
        return ip_address

    device = {
        'device_type': 'cisco_ios',
        'ip': ip_address.strip(),
        'username': username,
        'password': password,
        'port': 22, }
    try:
        net_connect = ConnectHandler(**device)
        config_file = open('log\\' + ip_address.strip() + '.cisco', 'a')
        f_cmd = open('config.cisco')
        cmd_list = f_cmd.read().splitlines()

        config_commands=[]
        for cmd in cmd_list:
            if cmd.strip() == "": continue
            if cmd[0] == "#": continue
            if cmd[0] == "!": continue
            if cmd[0:1] == "//": continue
            config_commands.append(cmd+"\n")
#        print(config_commands)

        cli_response=net_connect.send_config_set(config_commands)
        config_file.write(cli_response)
#        print(cli_response)

        cli_response = net_connect.send_command('write')
        print(str(ip_address)+" - Ok")
        config_file.write(cli_response)
        net_connect.disconnect()
    except:
        print(str(ip_address)+" Cannot connect to this device.")
        config_file = open('no_connect.txt', 'a')
        config_file.write(ip_address.strip()+"\n")
        return ip_address

if __name__ == '__main__':

    
    filelines = p.read().splitlines()

    global_username_d=filelines[0].encode('utf-8')
    global_password_d=filelines[1].encode('utf-8')
    
    data_username=base64.b64decode(global_username_d)
    data_password=base64.b64decode(global_password_d)
    
    global_username=data_username.decode('utf-8')
    global_password=data_password.decode('utf-8')

    try:
        f = open('cisco.ini')
        connection_data=[]
        filelines = f.read().splitlines()
        for line in filelines:
            if line == "": continue
            if line[0] == "#": continue
            if line[0] == "!": continue
            connection_data.append((line, global_username, global_password))
        f.close()
    except:
        print("no file cisco.ini")

    multiprocessing.set_start_method("spawn")
    with multiprocessing.Pool(maxtasksperchild=4) as process_pool:
        routers_with_issues = process_pool.map(doRouter, connection_data, 1)  # doRouter - function, iplist - argument
        process_pool.close()
        process_pool.join()
