#include <SoftwareSerial.h>
 
#define pin_TX       7         // artuinio TX mp3 player RX
#define pin_RX       8         // artuinio RX mp3 player TX
//#define pin_TX       12        // artuinio TX mp3 player RX
//#define pin_RX       11        // artuinio RX mp3 player TX
#define mp3_h 01
#define mp3_m 02

SoftwareSerial mp3(pin_RX, pin_TX);
 
static uint8_t cmdbuf[8] = {0};
static uint8_t ansbuf[10] = {0};
uint8_t playstatus;
static unsigned long timer_1 = 0;

uint16_t clock_delay[25]={0,1200,1176,1080,1320,1152,1296,1200,1248,1368,1488,1488,1632,1560,1584,1440,1560,1584,1656,1680,1416,1752,1656,1656,1056};

byte play_status(void)
{
 int pl=255; 
 command(0x42, 0, 0);
  while (not mp3.available()){ delay(5);}
  if (answer())
   if (ansbuf[3] == 0x42) { pl=ansbuf[6]; playstatus=ansbuf[6];}
   if (ansbuf[3] == 0x3D)  pl=0;
  return pl; 
}
 int8_t h;
 int8_t m;

void play_time(int8_t pt_h, int8_t pt_m)
{
  if (pt_h==0) pt_h=24;
  if (pt_m==0) pt_m=60;
  command(0x0F, mp3_h, pt_h);
  //delay(clock_delay[13]);
  delay(1000);
  while (play_status()==1) delay(100);
  command(0x0F, mp3_m, pt_m);
  delay(1000);
  while (play_status()==1) delay(100);
}
void play_time_ADVERT(int8_t pt_h, int8_t pt_m)
{
  if (pt_h==0) pt_h=24;
  command(0x13, 0, pt_h); 
  delay(clock_delay[13]);
  command(0x13, 0, pt_m+100); 
}

void setup() 
{
  Serial.begin(115200);
  mp3.begin(9600);
  delay(500); 
  command(0x09, 0, 2); // TF карта
  delay(200); 
  command(0x06, 0, 20); // громкость

  delay(1000); 
  play_time(7,0); //Произнести "семь часов ровно"
  command(0x03, 0, 1); //запустить мелодию с корневой папки
  delay(3000); 
  play_time_ADVERT(7,1); //Произнести "семь часов одна минута"
}
 
void loop() {
}
