/*
 * ps2.h - a library to interface with ps2 devices. See comments in
 * ps2.cpp.
 * Written by Chris J. Kiick, January 2008.
 * Release into public domain.
 * Supplemented by Dovgal A., Vitebsk Desember 2019.
 */

#ifndef ps2_h
#define ps2_h

#if defined(ARDUINO) && ARDUINO >= 100
  #include "Arduino.h"
#else
  #include "WProgram.h"
#endif 

class PS2
{
	public:
		PS2(int clk, int data);
		void write(unsigned char data);
		void init();
		void readall();
		unsigned char read(void);
		boolean available;
                char IM_flag;
                char x,y,s,stat;
	private:
		int _ps2clk;
		int _ps2data;
		void golo(int pin);
		void gohi(int pin);
		void whilelo(int pin);
		void whilehi(int pin);
                int tst;
};

#endif /* ps2_h */

