/*
 * ps2.cpp - an interface library for ps2 devices.  Common devices are
 * mice, keyboard, barcode scanners etc.  See the examples for mouse and
 * keyboard interfacing.
 * limitations:
 *      we do not handle parity errors.
 *      The timing constants are hard coded from the spec. Data rate is
 *         not impressive.
 *      probably lots of room for optimization.
 */

#include "ps2.h"

/*
 * the clock and data pins can be wired directly to the clk and data pins
 * of the PS2 connector.  No external parts are needed.
 */
PS2::PS2(int clk, int data)
{
	_ps2clk = clk;
	_ps2data = data;
	gohi(_ps2clk);
	gohi(_ps2data);
}

/*
 * according to some code I saw, these functions will
 * correctly set the clock and data pins for
 * various conditions.  It's done this way so you don't need
 * pullup resistors.
 */
void
PS2::init()
{
  write(0xff);  // reset
  read();  // ack byte
  read();  // blank */
  read();  // blank */
  write(0xf0);  // remote mode
  read();  // ack
  delayMicroseconds(100);
  write(0xF3); // set sample rate to...
  write(200);  // 200
  read();      // ignore ack
  write(0xF3); // set sample rate to...
  write(100);  // 100
  read();      // ignore ack
  write(0xF3); // set sample rate to...
  write(80);   // 80
  read();      // ignore ack
  write(0xF2); // get device ID
  read();      // ignore ack
  IM_flag = read(); // check Intellimouse mode
}

void
PS2::readall()
{
 if (available)
 {
  write(0xeb);  // give me data!
  read();      // ignore ack
  stat = read();
  x = read();
  y = read();
  if(IM_flag>0) s = read(); else s=0;
 } else {
   init();
   delayMicroseconds(100);
   if(IM_flag<1) init();
   if (not available) { x=0;y=0;s=0;stat=0;}
 }
}


void
PS2::gohi(int pin)
{
	pinMode(pin, INPUT);
	digitalWrite(pin, HIGH);
}


void
PS2::golo(int pin)
{
	pinMode(pin, OUTPUT);
	digitalWrite(pin, LOW);
}

void
PS2::whilehi(int pin)
{
        tst=0;
	while ((digitalRead(pin) == HIGH) && (tst<120)) tst++;
	if (tst>100) {available=false;}
}

void
PS2::whilelo(int pin)
{
        tst=0;
	while ((digitalRead(pin) == LOW) && (tst<120)) tst++;
	if (tst>100) {available=false;}
}

/* write a byte to the PS2 device */
void
PS2::write(unsigned char data)
{
        available=true;
	unsigned char i;
	unsigned char parity = 1;
	
	gohi(_ps2data);
	gohi(_ps2clk);
	delayMicroseconds(300);
	golo(_ps2clk);
	delayMicroseconds(300);
	golo(_ps2data);
	delayMicroseconds(10);
	gohi(_ps2clk);	// start bit
	/* wait for device to take control of clock */
	whilehi(_ps2clk);
		;	// this loop intentionally left blank
	// clear to send data
	for (i=0; i < 8; i++)
	{
		if (data & 0x01)
		{
			gohi(_ps2data);
		} else {
			golo(_ps2data);
		}
		// wait for clock
		whilelo(_ps2clk);
			;
		whilehi(_ps2clk);
			;
		parity = parity ^ (data & 0x01);
		data = data >> 1;
	}
	// parity bit
	if (parity)
	{
		gohi(_ps2data);
	} else {
		golo(_ps2data);
	}
	// clock cycle - like ack.
	whilelo(_ps2clk);
		;
	whilehi(_ps2clk);
		;
	// stop bit
	gohi(_ps2data);
	delayMicroseconds(50);
	whilehi(_ps2clk);
		;
	// mode switch
        tst=0;
	while (((digitalRead(_ps2clk) == LOW) || (digitalRead(_ps2data) == LOW)) && (tst<120)) tst++;
	if (tst>100) {available=false;}
	// hold up incoming data
	golo(_ps2clk);
}


/*
 * read a byte of data from the ps2 device.  Ignores parity.
 */
unsigned char
PS2::read(void)
{
	unsigned char data = 0x00;
	unsigned char i;
	unsigned char bit = 0x01;

	// start clock
	gohi(_ps2clk);
	gohi(_ps2data);
	delayMicroseconds(50);
	whilehi(_ps2clk);
		;
	delayMicroseconds(5);	// not sure why.
	whilelo(_ps2clk);
		;	// eat start bit
	for (i=0; i < 8; i++)
	{
		whilehi(_ps2clk);
			;
		if (digitalRead(_ps2data) == HIGH)
		{
			data = data | bit;
		}
		whilelo(_ps2clk);
			;
		bit = bit << 1;
	}
	// eat parity bit, ignore it.
	whilehi(_ps2clk);
		;
	whilelo(_ps2clk);
		;
	// eat stop bit
	whilehi(_ps2clk);
		;
	whilelo(_ps2clk);
		;
	golo(_ps2clk);	// hold incoming data

	return data;
}

