#include <ps2.h>

/*
 * an arduino sketch to interface with a ps/2 mouse.
 * Also uses serial protocol to talk back to the host
 * and report what it finds.
 */

/*
 * Pin 5 is the mouse data pin, pin 6 is the clock pin
 * Feel free to use whatever pins are convenient.
 */
PS2 mouse(6, 5);

/*
 * initialize the mouse. Reset it, and place it into remote
 * mode, so we can get the encoder data on demand.
 */


void setup()
{
  Serial.begin(9600);
  mouse.init();
  if (mouse.available) {
    Serial.println("Mouse init OK");
    if (mouse.IM_flag>0) Serial.println("Mouse IM scroll"); else Serial.println("Mouse simple, no scroll");
    } else {Serial.println("Mouse not fount");}
}

/*
 * get a reading from the mouse and report it back to the
 * host via the serial line.
 */
void loop()
{
  /* get a reading from the mouse */
  mouse.readall();
//  if (mouse.available) { 
    Serial.print(mouse.stat, BIN);
    Serial.print("\tX=");
    Serial.print(mouse.x, DEC);
    Serial.print("\tY=");
    Serial.print(mouse.y, DEC);
    Serial.print("\tscroll=");
    Serial.print(mouse.s, DEC);
    Serial.print("\ttype=");
    Serial.print(mouse.IM_flag, DEC);
  if (mouse.available)  Serial.print("\tMouse OK"); else Serial.print("\tMouse not found");

    Serial.println();
//  } else {Serial.println("Mouse not fount");}

//  delay(20);  /* twiddle */
}
