#!/bin/bash
export INPUT="IRtext.cpp"
export OUTPUT="IRtext.h"

if [[ ! -f ${INPUT} ]]; then
  echo "Can't read file '${INPUT}'. Aborting!"
  exit 1
fi
# Current year
export YEAR=$(date "+%Y")
# Header
cat >${OUTPUT} << EOF
// Copyright 2019-${YEAR} - David Conran (@crankyoldgit)
// This header file is to be included in files **other than** 'IRtext.cpp'.
//
// WARNING: Do not edit this file! This file is automatically generated by
//          '../tools/generate_irtext_h.sh'.

#ifndef IRTEXT_H_
#define IRTEXT_H_

#include "i18n.h"

// Constant text to be shared across all object files.
// This means there is only one copy of the character/string/text etc.

#ifdef ESP8266
class __FlashStringHelper;
#define IRTEXT_CONST_PTR_CAST(PTR)\\
    reinterpret_cast<const __FlashStringHelper*>(PTR)
#define IRTEXT_CONST_PTR(NAME) const __FlashStringHelper* const NAME
#else  // ESP8266
#define IRTEXT_CONST_PTR_CAST(PTR) PTR
#define IRTEXT_CONST_PTR(NAME) const char* const NAME
#endif  // ESP8266

EOF

# Parse and output contents of INPUT file.
sed 's/ PROGMEM//' ${INPUT} | egrep "^(const )?char" | cut -f1 -d= |
    sed 's/ $/;/;s/^/extern /' | sort -u >> ${OUTPUT}
egrep '^\s{,10}IRTEXT_CONST_STRING\(' ${INPUT} | cut -f2 -d\( | cut -f1 -d, |
    sed 's/^/extern IRTEXT_CONST_PTR\(/;s/$/\);/' | sort -u >> ${OUTPUT}
egrep '^\s{,10}IRTEXT_CONST_BLOB_DECL\(' ${INPUT} |
    cut -f2 -d\( | cut -f1 -d\) |
    sed 's/^/extern IRTEXT_CONST_PTR\(/;s/$/\);/' | sort -u >> ${OUTPUT}
# Footer
cat >> ${OUTPUT} << EOF

#endif  // IRTEXT_H_
EOF
