# "Приложение" GyverHub
Приложение написано на HTML/CSS/JS и представляет собой "сайт", для запуска которого нужен сервер. Сервером может быть сама плата на базе esp, локальный сервер может быть вшит в приложение и так далее. Исходный код приложения можно почитать [здесь](https://github.com/GyverLibs/GyverHub-web).

## Вариации приложения
GyverHub доступен в разных вариациях и на разных платформах. Приложение полностью автономное, для работы ему не нужен интернет, оно не зависит от каких-то серверов и вообще от разработчика, поэтому в системе даже нет таких понятий как "регистрация" и "личный кабинет". Приложение существует:
- Как онлайн версия на официальном сайте **hub.gyver.ru**: [HTTP](http://hub.gyver.ru/) и [HTTPS](https://hub.gyver.ru/) версия, есть [HTTPS](https://gyverlibs.github.io/GyverHub) зеркало на GitHub Pages
- Как веб-приложение (оффлайн PWA): официальный сайт можно установить на любое устройство (Android/iOS/Linux/Windows/Mac...) - [инструкция](https://github.com/GyverLibs/GyverHub/blob/main/docs/3.app.md#pwa-http)
- Как [телеграм-приложение](https://t.me/GyverHUB_bot)
- Как нативное приложение:
  - Android: [Google Play](https://play.google.com/store/apps/details?id=ru.alexgyver.GyverHub), [скачать APK](https://github.com/GyverLibs/GyverHub-app/releases/latest), [исходник](https://github.com/GyverLibs/GyverHub-app)
  - iOS: [App Store](https://apps.apple.com/kz/app/gyverhub/id6474273925), [исходник](https://github.com/GyverLibs/GyverHub-app)
  - Desktop (Windows/Linux/Mac): [скачать](https://github.com/neko-neko-nyan/gyverhub-desktop/releases/latest), [исходник](https://github.com/neko-neko-nyan/gyverhub-desktop)
- Как автономная вебморда из Flash памяти ESP8266/ESP32 - [инструкция](https://github.com/GyverLibs/GyverHub/blob/main/docs/3.app.md#%D0%B2%D0%B5%D0%B1%D0%BC%D0%BE%D1%80%D0%B4%D0%B0-esp)

> Примечание: все варианты приложения **за исключением вебморды ESP** автоматически обновляются: при выходе обновления приложение скачивает себе в память минифицированный HTML файл приложения [вот отсюда](https://github.com/GyverLibs/GyverHub-web/releases/latest/) (размер около 700кб)

## Способы связи
По техническим причинам в некоторых версиях приложения доступны не все способы связи. *Это не относится к устройству с библиотекой, речь идёт только о приложении!*

| Источник / режим | WiFi  | MQTT  | Serial/BT |  BLE  |  Telegram |
| ---------------- | :---: | :---: | :-------: | :---: |   :------: |
| Desktop          |   ✔   |   ✔   |     ✔     |   ✔   | dev    |
| Android          |   ✔   |   ✔   |    dev    |  dev  | dev    |
| iOS              |   ✔   |   ✔   |           |       | dev    |
| ESP              |   ✔   |       |           |       | |
| localhost        |   ✔   |   ✔   |     ✔     |   ✔   | dev    |
| Сайт HTTP        |  ✔*   |   ✔   |           |       | dev    |
| Сайт HTTPS       |       |   ✔   |   ✔***    |   ✔   | dev    |
| PWA HTTP**       |   ✔   |   ✔   |           |       | dev    |
| PWA HTTPS        |       |   ✔   |     ✔     |   ✔   | dev    |
| Telegram         |       |   ✔   |     ✔     |   ✔   | dev    |

- **dev** - В разработке TODO
- \* - Режим WiFi работает после [настройки браузера](https://github.com/GyverLibs/GyverHub/blob/main/docs/3.app.md#%D1%81%D0%B0%D0%B9%D1%82-http)
- \*\* - Для установки PWA с HTTP версии сайта нужно [добавить сайт в список доверенных](https://github.com/GyverLibs/GyverHub/blob/main/docs/3.app.md#pwa-http)
- \*\*\* - Только на десктопном Chrome/Edge/Opera, на других поддержки [нет](https://developer.mozilla.org/en-US/docs/Web/API/Web_Serial_API)

## Особенности и настройки
### Вебморда ESP
Сайт может работать из памяти ESP8266/32, в библиотеке для этого уже настроен веб-сервер. Файлы вебморды весят 55 кБ. Если зайти в браузере на IP адрес ESP в локальной сети - откроется вебморда. Также она автоматически откроется при подключении к AP (настроен MDNS). Код сильно оптимизирован и настроено кеширование, морда будет открываться очень быстро: вес главной страницы всего 300 байт. Чтобы это работало, нужно подключить нужную опцию.

#### Из программы
Необходимые файлы будут включены в программу в бинарном виде, для этого нужно объявить дефайн `GH_INCLUDE_PORTAL` перед подключением библиотеки:
```cpp
#define GH_INCLUDE_PORTAL
#include <GyverHub.h>
```

#### Из файлов
Нужно загрузить в файловую систему файлы приложения из [архива esp-gz.zip](https://github.com/GyverLibs/GyverHub-web/releases/latest/) - [скачать свежую версию](https://github.com/GyverLibs/GyverHub-web/releases/latest/download/esp-gz.zip). Это можно сделать через:
- Портал загрузки esp: `http://ip_еспшки/hub/upload_portal`, он автоматически загружает файлы в нужный каталог
- Файловый менеджер в приложении GyverHub (подключившись через отдельное приложение)
- Arduino IDE: [ESP8266](https://randomnerdtutorials.com/install-esp8266-nodemcu-littlefs-arduino/), [ESP32](https://randomnerdtutorials.com/install-esp32-filesystem-uploader-arduino-ide/)
- PlatformIO: [ESP8266](https://docs.platformio.org/en/latest/platforms/espressif8266.html#uploading-files-to-filesystem), [ESP32](https://docs.platformio.org/en/latest/platforms/espressif32.html#uploading-files-to-file-system)

Файлы должны располагаться в папке `/hub/`:
- `/hub/index.html.gz`
- `/hub/script.js.gz`
- `/hub/style.css.gz`

Также нужно объявить дефайн `GH_FILE_PORTAL` перед подключением библиотеки:
```cpp
#define GH_FILE_PORTAL
#include <GyverHub.h>
```

### Сайт HTTP (hub.gyver.ru)
Современные браузеры запрещают слать запросы на локальные адреса в целях безопасности, поэтому для работы **в режиме WiFi** нужно перейти по адресу `chrome://flags/#block-insecure-private-network-requests` (адрес настройки для вашей версии браузера будет указан в настройках GyverHub) и отключить настройку **Block insecure private network requests**. Затем перезапустить браузер.

|⚠️⚠️⚠️<br>**Эта настройка снижает безопасность браузера! По возможности используйте приложение GyverHub или MQTT связь**<br>⚠️⚠️⚠️|
| --- |

#### Если сайт hub.gyver.ru не открывается по http
- Chrome
  - Открыть `chrome://net-internals/#hsts`, пункт **Delete domain security policies**, ввести `hub.gyver.ru`, нажать **Delete**
  - Очистить кэш
    - `chrome://settings/clearBrowserData` выбрать *Изображения и другие файлы*
    - ИЛИ на сайте хаба в строке адреса нажать иконку со значком **i**, *Файлы cookie...* и очистить
- Firefox: нажать Ctrl + Shift + H, найти hub.gyver.ru, правой кнопкой - забыть сайт

### PWA HTTP
Для установки PWA приложения с [HTTP](http://hub.gyver.ru/) версии сайта (для работы в режиме WiFi) нужно включить настройку `chrome://flags/#unsafely-treat-insecure-origin-as-secure` (адрес настройки для вашего браузера указан в настройках GyverHub) и добавить `http://hub.gyver.ru` в список доверенных сайтов. После этого можно будет установить PWA приложение по кнопке HTTP и пользоваться им в локальном режиме.

## Настройка связи, поиск
Перед поиском устройства нужно ввести в настройках **имя сети**, которое указано в программе устройства.

### WiFi
В этом режиме устройство общается с приложением по протоколам HTTP/WS. Устройство должно находиться в одной сети с приложением (подключены к одному роутеру, телефон подключен к ESP).

#### Вручную
Если локальный адрес устройства известен - можно ввести его в поле "добавить по IP" и нажать `+` - устройство будет добавлено.

#### Поиск
Для поиска в этом режиме нужно указать:
- Локальный IP приложения (девайса с открытым приложением или сайтом) или IP роутера. Также можно определить автоматически, для этого нужно отключить **Anonymize local IPs exposed by WebRTC** вот тут `chrome://flags/#enable-webrtc-hide-local-ips-with-mdns`
- Маску подсети роутера. По умолчанию стоит стандартная для большинства роутеров
- HTTP порт (по умолч. 80, задаётся в библиотеке)

После этого можно нажать кнопку поиска ниже.

> Примечание: поиск в этом режиме работает на основе перебора всех адресов подсети, некоторые роутеры могут блокировать такие запросы и устройство не найдётся. Иногда поиск начинает работать после перезагрузки роутера.

### MQTT
MQTT позволяет управлять устройством через интернет из любой другой точки планеты. GyverHub работает с внешним MQTT брокером, это может быть бесплатный брокер, платный, а также можно поднять свой сервер на малинке или роутере - [инструкция](https://kotyara12.ru/iot/keenetic-mqtt/). Требования к брокеру:
- Наличие *Wildcards* (топики с `/#`)
- Наличие TCP соединения для устройства
- Наличие Websocket с TLS (WSS) для приложения
- [Список бесплатных брокеров](https://kotyara12.ru/iot/cloud_services/)

Для экспериментов можно использовать бесплатный публичный [mosquitto](https://test.mosquitto.org/), он настроен в примерах и в приложении по умолчанию:
- Хост: `test.mosquitto.org`
- Порт (ESP): `1883`
- Порт (приложение): `8081`

После успешного подключения к серверу (появится иконка в правом верхнем углу) можно запускать поиск устройства.

> Примечание: это публичный сервер, другие пользователи смогут найти ваше устройство, если случайно угадают имя сети. Это маловероятно, но реально, поэтому рекомендуется использовать сервер с авторизацией логин-пароль. Из платных брокеров могу порекомендовать [WQTT](https://www.wqtt.ru/) - 300 рублей в год + удобная интеграция устройств с Яндекс Алисой.

### Serial
Serial это не только проводная связь через USB, но и Bluetooth модули, которые создают виртуальный COM порт. Например HC-05, HC-06, JDY-21. Подключение к некоторым платам по аппаратному Serial приводит к перезагрузке устройства, поэтому в приложении предусмотрен таймаут - запрос на устройство будет отправлен через указанное кол-во миллисекунд, чтобы устройство успело загрузиться.

### Bluetooth
В рамках приложения GyverHub связь Bluetooth работает с **BLE модулями**, например HM-10, JDY-08, AT-09, CC41-A.

## Экраны приложения
TODO
