# Начало работы
## Платформы, версии
Библиотека должна работать на любой Arduino-совместимой платформе, тестировалась на AVR, ESP8266 v3.1.2, ESP32 v2.0.14 (dev, S2, S3, C3). **На старых версиях esp32 (ниже 2.x) не работает!**

### Arduino IDE
Ссылки для менеджера плат. Рекомендуются актуальные версии:
- ESP8266 v2.7+ https://arduino.esp8266.com/stable/package_esp8266com_index.json
- ESP32 v2+ https://raw.githubusercontent.com/espressif/arduino-esp32/gh-pages/package_esp32_index.json

### Platformio
Мой .ini файл для всех платформ. Указана платформа, файловая система и все нужные зависимости:

<details>
<summary>platformio.ini</summary>

```ini
[env:d1_mini]
framework = arduino
monitor_speed = 115200
platform = espressif8266
board = d1_mini
upload_speed = 921600
monitor_filters = esp8266_exception_decoder, default
build_type = debug
board_build.filesystem = littlefs
lib_deps =
    knolleary/PubSubClient
    links2004/WebSockets
    ;GyverLibs/GyverHub
    https://github.com/GyverLibs/GyverHub.git
    GyverLibs/StringUtils
    GyverLibs/Pairs
    GyverLibs/GSON

[env:esp32dev]
framework = arduino
monitor_speed = 115200
platform = espressif32
board = esp32dev
upload_speed = 921600
board_build.filesystem = littlefs
lib_deps =
    knolleary/PubSubClient
    links2004/WebSockets
    ;GyverLibs/GyverHub
    https://github.com/GyverLibs/GyverHub.git
    GyverLibs/StringUtils
    GyverLibs/Pairs
    GyverLibs/GSON

[env:esp32cam]
framework = arduino
monitor_speed = 115200
platform = espressif32
board = esp32cam
board_build.mcu = esp32
upload_speed = 921600
board_build.f_cpu = 240000000L
board_build.filesystem = littlefs
lib_deps =
    knolleary/PubSubClient
    links2004/WebSockets
    ;GyverLibs/GyverHub
    https://github.com/GyverLibs/GyverHub.git
    GyverLibs/StringUtils
    GyverLibs/Pairs
    GyverLibs/GSON

[env:esp32-c3]
framework = arduino
monitor_speed = 115200
platform = espressif32
board = esp32dev
board_build.mcu = esp32c3
upload_speed = 921600
board_build.f_cpu = 80000000L
lib_deps =
    knolleary/PubSubClient
    links2004/WebSockets
    ;GyverLibs/GyverHub
    https://github.com/GyverLibs/GyverHub.git
    GyverLibs/StringUtils
    GyverLibs/Pairs
    GyverLibs/GSON

[env:s2_mini]
framework = arduino
monitor_speed = 115200
platform = espressif32
board = lolin_s2_mini
board_build.mcu = esp32s2
board_build.f_cpu = 240000000L
lib_deps =
    knolleary/PubSubClient
    links2004/WebSockets
    ;GyverLibs/GyverHub
    https://github.com/GyverLibs/GyverHub.git
    GyverLibs/StringUtils
    GyverLibs/Pairs
    GyverLibs/GSON

[env:nano328]
framework = arduino
monitor_speed = 115200
platform = atmelavr
board = nanoatmega328new
lib_deps =
    ;GyverLibs/GyverHub
    https://github.com/GyverLibs/GyverHub.git
    GyverLibs/StringUtils
    GyverLibs/Pairs
    GyverLibs/GSON
```
</details>

## Зависимости
Для работы GyverHub необходимы библиотеки:
- [pubsubclient](https://github.com/knolleary/pubsubclient)
- [arduinoWebSockets](https://github.com/Links2004/arduinoWebSockets)
- [StringUtils](https://github.com/GyverLibs/StringUtils)
- [GSON](https://github.com/GyverLibs/GSON)
- [Pairs](https://github.com/GyverLibs/Pairs)

> При установке GyverHub из реестра все библиотеки установятся автоматически!

## Основные понятия
- **Устройство** - микроконтроллер (далее МК) с программой на базе библиотеки GyverHub. МК является сервером, к которому подключаются клиенты
- **Клиент** - сайт или приложение GyverHub, которое подключено к устройству
- **Имя сети** (префикс) - уникальное имя сети "клиент-устройство", используется клиентом для поиска устройств и по сути является паролем, без которого не получится обнаружить устройство

## Минимальный код
Библиотека имеет минималистичный API: для начала работы достаточно создать объект GyverHub, вызвать у него `begin()` в блоке setup и вызывать `tick()` в блоке loop. Также нужно создать функцию вида `void build(gh::Builder& b)` и подключить её через `hub.onBuild()` - в ней будет собираться панель управления.
```cpp
#include <GyverHub.h>
GyverHub hub("MyDevices", "ESP8266", "");  // имя сети, имя устройства, иконка

// билдер
void build(gh::Builder& b) {
}

void setup() {
    // подключение к WiFi..
    // настройка MQTT/Serial/Bluetooth..
    hub.onBuild(build); // подключаем билдер
    hub.begin();        // запускаем систему
}

void loop() {
    hub.tick();         // тикаем тут
}
```
Иконки *Font Awesome v5 Solid*, бесплатный пак:
- [Список иконок](https://fontawesome.com/v5/search?o=r&m=free&s=solid)
- Вставлять в "строку" сам символ (глиф) `""` или его код `"f6ad"`
- Пустая строка `""` - отключить иконку

### Настройка WiFi
Для подключения к WiFi роутеру можно использовать стандартный код для ESP:
```cpp
void setup() {
    WiFi.mode(WIFI_STA);
    WiFi.begin("SSID", "PASS");
    while (WiFi.status() != WL_CONNECTED) {
        delay(500);
        Serial.print(".");
    }
    // ...
}
```

Система может работать и с ESP в режиме точки доступа:
```cpp
void setup() {
    WiFi.mode(WIFI_AP);
    WiFi.softAP("My Device");
    // ...
}
```

### Настройка MQTT
Для работы через встроенный MQTT нужно указать хост (адрес или IP) и **TCP** порт, опционально логин-пароль и qos/retain:
```cpp
config(const String& host, uint16_t port, const String& login = "", const String& pass = "", uint8_t qos = 0, bool ret = 0)
```

```cpp
void setup() {
    // настройка на сервер, установленный в приложении по умолчанию
    hub.mqtt.config("test.mosquitto.org", 1883);

    // другие примеры
    hub.mqtt.config(IPAddress(12, 34, 56, 78), 1883);
    hub.mqtt.config("m8.wqtt.ru", 13448, "user", "pass");
}
```

### Настройка Serial/Bluetooth
Библиотека имеет встроенную поддержку Serial/Bluetooth в виде [Arduino Stream](https://www.arduino.cc/reference/en/language/functions/communication/stream/). К библиотеке можно подключить один Stream-объект, который обеспечивает связь. В большинстве случаев это будет `Serial` или `SoftwareSerial`, к которому в случае с Bluetooth подключен Bluetooth модуль по UART. В программе нужно указать его и тип связи, который обеспечивается подключением:
```cpp
void setup() {
    hub.stream.config(&Serial, gh::Connection::Serial);
    // ...
}
```
```cpp
SoftwareSerial bt(3, 4);

void setup() {
    hub.stream.config(&bt, gh::Connection::Bluetooth);
    // ...
}
```