#if defined (TX_IR_PIN)
// 
/*
 * Обрабатываются команды
 433 DEC_CODE
 433x HEX_CODE
 433X HEX_CODE
 433h HEX_CODE
 433H HEX_CODE
 IR DEC_CODE
 IRx HEX_CODE
 IRX HEX_CODE
 IRh HEX_CODE
 IRH HEX_CODE
 DEC_CODE
 */

#include <IRremoteESP8266.h>
#include <IRsend.h>

IRsend irsend(TX_IR_PIN);  // Set the GPIO to be used to sending the message.

//--------------------------------------------------------
void setup_TX_IR() {
  irsend.begin();       // Start up the IR sender.
}
//--------------------------------------------------------
void loop_TX_IR() {
}
//--------------------------------------------------------
// Парсит команды из Ararm,Сети,ИК
template<typename T>
void parsing_TX_IR(T act_chr) {
    String act=String(act_chr);
    act.toUpperCase();
    DEBUGLN("Module TX_IR");
    DEBUGLN(act);
    String strCommand=getValue(act,' ',0);
    String str_IR=getValue(act,' ',1);
//    DEBUGLN(strCommand);
    uint32_t cmd_IR=0;
    
    if (strCommand=="433X") cmd_IR=strtoul(str_IR.c_str(), 0, 16); else
    if (strCommand=="IRX")  cmd_IR=strtoul(str_IR.c_str(), 0, 16); else
    if (strCommand=="433H") cmd_IR=strtoul(str_IR.c_str(), 0, 16); else
    if (strCommand=="IR")   cmd_IR=str_to_int(str_IR); else
    if (strCommand=="433")  cmd_IR=str_to_int(str_IR); else
    cmd_IR=str_to_int(strCommand);
    if (cmd_IR!=0) irsend.sendNEC(cmd_IR);
}
//--------------------------------------------------------


#endif
