#if defined (PWM_PIN)
// Управление ШИМ на пинах
/*
 * Обрабатываются команды
 * P_ON       - включит ШИМ на максимум (1024)
 * P_OFF      - передает на ШИМ 0
 * PWM 0 xxx  - передает на ШИМ xxx
 * PWM 0 +    - увеличивает ШИМ на 1
 * PWM 0 -    - уменьшает ШИМ на 1
 * Если номер PWM больше или равен количеству действует на все
 */

// Для ESP-01 Пин 0 - GPIO0, 2 - GPIO2  {0} , {0,2}
uint8_t  pin_pwm[PWM_PIN+1]=PWM_PINS;
uint16_t signal_pwm[PWM_PIN+1]={0};
uint16_t real_pwm[PWM_PIN+1]={0};
uint16_t old_pwm[PWM_PIN+1]={false};
bool H_update=false; 

//--------------------------------------------------------
void PWM(uint8_t pin, uint16_t pwm) {
 FOR_i(0,PWM_PIN) {
   if ((i==pin) || (pin>=PWM_PIN)) {
     signal_pwm[i] = pwm;
     }
   }
 H_update=true; 
}
//--------------------------------------------------------
char P_MAX[]="PWM MAX";
char P_MIN[]="PWM MIN";
void PWM_inc(uint8_t pin, int8_t pwm) {
 DEBUGLN("PWM_inc");
 FOR_i(0,PWM_PIN) {
   if ((i==pin) || (pin>=PWM_PIN)) {
     if (pwm>0 && signal_pwm[i]<1023) signal_pwm[i]++; else module_parsig(8,P_MAX);
     if (pwm<0 && signal_pwm[i]>0) signal_pwm[i]--; else module_parsig(8,P_MIN);
     }
   }
 H_update=true; 
}
//--------------------------------------------------------
void setup_PWM() {
  FOR_i(0,PWM_PIN) pinMode(pin_pwm[i],OUTPUT);
}
//--------------------------------------------------------
void loop_PWM() {
  EVERY_MS(50) {
    FOR_i(0,PWM_PIN){
       if (real_pwm[i]>signal_pwm[i]) real_pwm[i]--;
       if (real_pwm[i]<signal_pwm[i]) real_pwm[i]++;
       analogWrite(pin_pwm[i],real_pwm[i]);
       if (old_pwm[i]!=signal_pwm[i]) { 
           #ifndef GH_NO_MQTT   // Отсылка значений на MQTT сервер
           hub.sendGet("PWM"+String(i), signal_pwm[i]);
           #endif
           if (hub.focused()) hub.sendUpdate("PWM"+String(i), String(signal_pwm[i]));
           old_pwm[i]=signal_pwm[i];
       }
//    memcpy(old_pwm, signal_pwm, PWM_PIN);
    }
  }
}
//--------------------------------------------------------
// Парсит команды из Ararm,Сети,ИК
template<typename T>
void parsing_PWM(T act_chr) {
    String act=String(act_chr);
    act.toUpperCase();
    DEBUGLN("parsing_PWM");
    DEBUGLN(act);
    String strCommand=getValue(act,' ',0);
    String param;
    H_update=false; 
    if ((strCommand=="PWM") || (strCommand=="ШИМ") || (strCommand=="Шим")) {
        if (getValue(act,' ',2)=="IS") return;
        param = getValue(act,' ',1);
        uint8_t pin=str_to_int(param);
        param = getValue(act,' ',2);
        
        if (param=="MIN") return; else
        if (param=="MAX") return; else
        if (param=="+") PWM_inc(pin,1);else
        if (param=="-") PWM_inc(pin,-1);else 
        if (param=="ON") PWM(pin,1023); else 
        if (param=="OFF") PWM(pin,0); else 
        {
           uint16_t pwm=constrain(str_to_int(param),0,1023);
           PWM(pin,pwm);
        }
    }
    // Для совместимости с приложениями GyverLamp
    if (strCommand=="P_ON") PWM(PWM_PIN,1023); else
    if (strCommand=="P_OFF") PWM(PWM_PIN,0); else
    if ((strCommand=="ON_OFF") || (strCommand=="SWITCH") || (strCommand=="P_SW")) {
      ON_OFF=!ON_OFF;
      PWM(PWM_PIN,(ON_OFF)?0:1023); 
    } else 
    if (!strncmp_P(act_chr, PSTR("BRI"), 3)) 
    { 
      param = act.substring(3);
      uint16_t pwm=constrain(param.toInt()<<2,0,1023);
      FOR_i(0,PWM_PIN) PWM(i,pwm);
    }

/*
    FOR_i(0,PWM_PIN) {
       char send_udp[25];
       sprintf_P(send_udp, (const char *)F("PWM %d IS %d"), i, real_pwm[i]);
       module_parsig(255,send_udp);
    }
*/    
    DEBUGLN("parsing_PWM");
}
//--------------------------------------------------------

void HUB_module_pult_PWM(gh::Builder& b) {
  DEBUGLN("HUB_module_pult_PWM");
  b.beginRow();  
  FOR_i(0,PWM_PIN) {
//     b.Display("ШИМ "+String(i)).label("PWM "+String(pin_pwm[i])+" пин").color(GH::Colors::Yellow).fontSize(18).rows(1);
     if (b.Slider_("PWM"+String(i),&signal_pwm[i]).label("ШИМ  "+String(i)+", PWM "+String(pin_pwm[i])+" пин").range(0, 1023, 1).color(GH::Colors::Yellow).click())  PWM(i, signal_pwm[i]) ;
  }
  b.endRow();  
}
//--------------------------------------------------------
void get_PWM() {
 char send_udp[25];
 FOR_i(0,PWM_PIN) {
    Udp.beginPacket(Udp.remoteIP(), Udp.remotePort());
    sprintf_P(send_udp, (const char *)F("PWM %d IS %d"), i, real_pwm[i]);
    Udp.print(send_udp);
    Udp.endPacket();
 }   
}  

#endif
