//Модуль упраление ИК пультом

//Если ИК отсутствует, отключите
#if defined (IR_PIN)

#include <IRremoteESP8266.h>
#include <IRrecv.h>
//#include <IRutils.h>
//--------------------------------------------------------
struct struct_IR_pult{
  bool on_off;
  char cmd[CMD_LEN]; // Посылаемая команда
  uint32_t code=0;
  GH::Flags lamp=0;
  GH::Flags modul=0;
  GH::Flags timers=0;
  bool repeat;
};

struct_IR_pult IR_pult[MAX_IR];
FS_(IR_pult);
//--------------------------------------------------------

IRrecv irrecv_ir(IR_PIN);
decode_results results_ir;
int64_t IR_last_press;
int64_t IR_press;
String IR_str="0xFFFFFFFF";
bool pressed;

//--------------------------------------------------------
void setup_IR(){
  irrecv_ir.enableIRIn();
  FS_LOAD(IR_pult); 
  main_menu+=IR_MENU;
  main_menu+=";";
}

//--------------------------------------------------------
char IR_Action[CMD_LEN];
void loop_IR() {
  FS_TICK(IR_pult); 
  if ( irrecv_ir.decode( &results_ir )) {   // если данные пришли
      IR_str=String(uint32_t(results_ir.value),HEX);
//      DEBUGLN(IR_str);
      if (results_ir.value != -1) {
         pressed=false;
         IR_press=results_ir.value;
         FOR_i(0,MAX_IR) {
          //Записать команду в свободную включенную ячейку
           if (IR_pult[i].on_off)
            if (IR_pult[i].code==0) {
              IR_pult[i].code=IR_press;
              FS_UPDATE(IR_pult);
              if (hub.focused()) {
                  hub.update("code"+String(i)).value(IR_str);
                  HUB_Update=false;
              }
            }
         }
      } else IR_press=-1;
      FOR_j(0,MAX_IR) {
           if (IR_pult[j].on_off) {
              if (IR_press==-1) IR_press=IR_last_press;
              if ((IR_pult[j].code==IR_press) || (IR_pult[j].code==0xFFFFFFFF)) {
                if (IR_pult[j].repeat) IR_last_press = IR_press; else IR_last_press = -1;

                  if (!strcmp(IR_Action,"IRx"))  sprintf_P(IR_Action,"IRx %x",IR_press); else
                  if (!strcmp(IR_Action,"IR"))   sprintf_P(IR_Action,"IR %u",IR_press); else
                  strcpy(IR_Action, IR_pult[j].cmd);

                  IP_parsig(IR_pult[j].lamp,IR_Action);
                  module_parsig(IR_pult[j].modul,IR_Action);
              }
           }   
      }
    irrecv_ir.resume();  // принимаем следующую команду
  }
}
//--------------------------------------------------------
void HUB_module_IR(gh::Builder& b) {
  static uint8_t plus_minus[MAX_IR];
  static uint8_t tab = 0;


 FOR(tab,0,MAX_IR) { 
  b.beginRow();  
  eeprom_flag |= b.Switch_("sw_IR"+String(tab),&IR_pult[tab].on_off).label(F("Active")).size(1).click();
  String IR_HEX=String(IR_pult[tab].code,HEX);
  if (b.Input_("code"+String(tab),&IR_HEX).label(F("HEX Code")).maxLen(8).regex(F("^[A-Fa-f0-9]+$")).size(2).click()) {
      IR_HEX="0x"+IR_HEX;
      DEBUG(IR_HEX + " : ");
      IR_pult[tab].code = strtoul(IR_HEX.c_str(), 0, 16);
      DEBUGLN(IR_pult[tab].code);
      eeprom_flag=true;
  }
  eeprom_flag |= b.Switch(&IR_pult[tab].repeat).label(F("Повтор 0xFFFFFF")).size(1).click();
  if (b.Tabs(&plus_minus[tab]).text(F("- ; +")).size(1).click()) b.refresh();
  b.endRow();  
  if (plus_minus[tab]) {
    eeprom_flag |= b.Input(IR_pult[tab].cmd).maxLen(HUB_LEN).label(F("Акция IR пульта")).click();
    eeprom_flag |= b.Flags(&IR_pult[tab].lamp).text(str_GHflags_IP).label(F("Устройства IP")).click();
    eeprom_flag |= b.Flags(&IR_pult[tab].modul).text(str_modul).label(F(hlp_modul)).click();
  }
 }  
     if (eeprom_flag) {
      FS_UPDATE(IR_pult);
      eeprom_flag=false;
   }
}
//--------------------------------------------------------
void load_IR(){
   String CONFIG="";
   FOR_i(0,MAX_IR) {
    CONFIG+="IR;"+String(i);
    if (IR_pult[i].on_off) CONFIG+=";1;";
                      else CONFIG+=";0;";
    CONFIG+=String(IR_pult[i].code,HEX)+";";
    CONFIG+=IR_pult[i].lamp.toString()+";"+IR_pult[i].modul.toString()+";"+IR_pult[i].repeat+";"+String(IR_pult[i].cmd)+char(10);
   }
   Udp.print(CONFIG.c_str());
   Udp.print(char(10));
}
#endif
