#if defined (BTN_PIN)

#include <GyverButton.h>

#define BTN_Menu "0 кликов;1 клик;2 клика;3 клика;4 клика;5 кликов;6 кликов;7 кликов;8 кликов;9 кликов"

// Сенсорная кнопка
//GButton touch(BTN_PIN, LOW_PULL, NORM_OPEN);
// кнопка подключена сюда (BTN_PIN --- КНОПКА --- GND)
GButton touch(BTN_PIN);
//--------------------------------------------------------
struct struct_G_Button{
  bool on_off;
  uint8_t choice; // 1,2..9 количество нажатий 
  char cmd[CMD_LEN];
  char cmd_rep[CMD_LEN];   // Посылаемая команда во время удержания
  uint32_t time_from=0;
  uint32_t time_to=0;
  GH::Flags week=0;
  GH::Flags lamp=0;
  GH::Flags modul=0;
  bool ok=true;
};
struct_G_Button G_Button[MAX_G_Button];
FS_(G_Button);

//--------------------------------------------------------
void setup_G_Button(){
  FS_LOAD(G_Button); 
  main_menu+=BTN_MENU;
  main_menu+=";";
}

//--------------------------------------------------------
void action_G_Button(uint8_t i, char act[]) {
   yield();
   if (strlen(act)) {
     if (G_Button[i].week.get(dayofweek)) {
          DEBUGLN("g_button week: " +String(act));
          bool on_time=false;
          if (G_Button[i].time_from==G_Button[i].time_to) on_time=true; else
          if (G_Button[i].time_from<G_Button[i].time_to) 
              on_time=(hour*60+minute>=round(G_Button[i].time_from/60)) && (hour*60+minute<=round(G_Button[i].time_to/60));
          else    
              on_time=(hour*60+minute>=round(G_Button[i].time_from/60)) || (hour*60+minute<=round(G_Button[i].time_to/60));
          if (on_time)  { 
              module_parsig(G_Button[i].modul,act);
              IP_parsig(G_Button[i].lamp,act);
          }
     }     
   }
}
//--------------------------------------------------------
void loop_G_Button(){
  FS_TICK(G_Button); 
  touch.tick();
  uint8_t clickCount = touch.hasClicks() ? touch.getClicks() : 0U;
  if (clickCount)
    DEBUGLN("Нажатий "+String(clickCount));
    FOR_i(0,MAX_G_Button)
     if (G_Button[i].on_off)
      if (clickCount==G_Button[i].choice) action_G_Button(i,G_Button[i].cmd);
  if (touch.isStep()) {
//    clickCount = touch.getHoldClicks();
    DEBUGLN("Удержание "+String(clickCount));
    FOR_i(0,MAX_G_Button)
     if (G_Button[i].on_off)
      if (clickCount==G_Button[i].choice) action_G_Button(i,G_Button[i].cmd_rep);
    
  }
}
//--------------------------------------------------------
template<typename T>
void parsing_G_Button(T act_chr){
    String act=String(act_chr);

}
//--------------------------------------------------------
void HUB_module_G_Button(gh::Builder& b) {
  static uint8_t plus_minus[MAX_G_Button];
  static uint8_t tab = 0;

  FOR(tab,0,MAX_G_Button) {
    b.beginRow();  
    eeprom_flag |= b.Switch_("sw_BTN"+String(tab),&G_Button[tab].on_off).label(F("Active")).size(1).click();
    eeprom_flag |= b.Select(&G_Button[tab].choice).text(BTN_Menu).size(3).click();
    if (b.Tabs(&plus_minus[tab]).text(F("- ; +")).size(1).click()) b.refresh();
    b.endRow();  

    if (plus_minus[tab]) {
       eeprom_flag |= b.Flags(&G_Button[tab].week).text(str_dayofweek).label(F("Дни недели")).click();
       b.beginRow();  
       eeprom_flag |= b.Time(&G_Button[tab].time_from).label(F("От")).size(1).click();
       eeprom_flag |= b.Time(&G_Button[tab].time_to).label(F("До")).click();
       b.endRow();  
       
       eeprom_flag |= b.Input(G_Button[tab].cmd).maxLen(HUB_LEN).label(F("Команда при сработке")).click();
       eeprom_flag |= b.Input(G_Button[tab].cmd_rep).maxLen(HUB_LEN).label(F("Команда при удержании")).click();

       eeprom_flag |= b.Flags(&G_Button[tab].lamp).text(str_GHflags_IP).label(F("Устройства IP")).click();
       eeprom_flag |= b.Flags(&G_Button[tab].modul).text(str_modul).label(F(hlp_modul)).click();
      
    }
  }
  if (eeprom_flag) {
      FS_UPDATE(G_Button);
      eeprom_flag=false;
   }
}
//--------------------------------------------------------
void load_G_Button(){

}
#endif
