#if defined (RELE_PIN)
// Управление РЕЛЕ на пинах
/*
 * Обрабатываются команды
 * P_ON       - включит все реле
 * P_OFF      - выключит все реле
 * RELE 0 ON  - включить реле 0
 * RELE 1 OFF - выключить реле 0
 * Если номер реле больше или равен количеству действует на все
 */

// Для ESP-01 Пин 0 - GPIO0, 2 - GPIO2  {0} , {0,2}

bool rele[RELE_PIN]={false};
bool old_rele[RELE_PIN]={false};
uint8_t pin_220[RELE_PIN]=RELE_PINS;

//--------------------------------------------------------
void RELE(uint8_t pin, bool offon) {
 FOR_i(0,RELE_PIN) {
   if ((i==pin) || (pin>=RELE_PIN)) {
     digitalWrite(pin_220[i],not offon);
     rele[i] = offon;
     #ifndef GH_NO_MQTT
     //---------------------------------
     // Отсылка значений на MQTT сервер
     if (rele[i]!=old_rele[i]) hub.sendGet("sw_rele"+String(i), rele[i]);
     //---------------------------------
     #endif
   }
 }
 memcpy(old_rele, rele, RELE_PIN);
}
//--------------------------------------------------------
void setup_G220() {
  FOR_i(0,RELE_PIN) pinMode(pin_220[i],OUTPUT);
}
//--------------------------------------------------------
void loop_G220() {
  FOR_i(0,RELE_PIN) digitalWrite(pin_220[i],not rele[i]);
}
//--------------------------------------------------------
// Парсит команды из Ararm,Сети,ИК
template<typename T>
void parsing_G220(T act_chr) {
    String act=String(act_chr);
//    DEBUGLN(act);
    String strCommand=getValue(act,' ',0);
    strCommand.toUpperCase();
//    DEBUGLN(strCommand);
    if ((strCommand=="RELE") || (strCommand=="РЕЛЕ") || (strCommand=="Реле")) {
        String pinstr = getValue(act,' ',1);
        uint8_t pin=str_to_int(pinstr);
        if (getValue(act,' ',2)=="ON") RELE(pin,true); 
        if (getValue(act,' ',2)=="OFF") RELE(pin,false);
        if (pin<RELE_PIN) if (getValue(act,' ',2)=="SW") RELE(pin,!rele[pin]);
    }
    if (strCommand=="P_ON") RELE(RELE_PIN,true);
    if (strCommand=="P_OFF") RELE(RELE_PIN,false);
    if ((strCommand=="ON_OFF") || (strCommand=="SWITCH") || (strCommand=="P_SW")) {
      ON_OFF=!ON_OFF;
      RELE(RELE_PIN,ON_OFF);  
    }
    

    FOR_i(0,RELE_PIN) {
       char send_udp[25];
       sprintf_P(send_udp, (const char *)F("RELE %d IS %s"), i, (rele[i]) ? "ON":"OFF");
       module_parsig(8,send_udp);
    }
}
//--------------------------------------------------------

void HUB_module_pult_G220(gh::Builder& b) {
  FOR_i(0,RELE_PIN) {
      b.beginRow();  // начать
      b.Display("rele 220V "+String(i)).label("Rele 220V "+String(i)).color(GH::Colors::Red).fontSize(16).rows(1).size(3);
  if (b.Switch_("sw_rele"+String(i),&rele[i]).label(F("Включить")).color(GH::Colors::Red).size(1).click()) RELE(i,rele[i]);
      b.endRow();  // ВАЖНО НЕ ЗАБЫТЬ ЕГО ЗАВЕРШИТЬ
  }
}

//--------------------------------------------------------
void get_G220() {
  char send_udp[25];
  FOR_i(0,RELE_PIN) {
     Udp.beginPacket(Udp.remoteIP(), Udp.remotePort());
     sprintf_P(send_udp, (const char *)F("RELE %d IS %s"), i, (rele[i]) ? "ON":"OFF");
     Udp.print(send_udp);
     Udp.endPacket();
  }
}  

#endif
