#if defined (DFPlayer)

#include <Arduino.h>
#include <SoftwareSerial.h>

SoftwareSerial mp3(MP3_RX_PIN, MP3_TX_PIN); // RX, TX

//буффер команд
//uint8_t cmdbuf[9] = {0x7E, 0xFF, 06, 00, 01, 00, 00, 0xEF, 0};
char cmdbuf[9] = {0x7E, 0xFF, 06, 00, 00, 00, 00, 0xEF, 0};
uint8_t ansbuf[10] = {0};
uint8_t mp3_folders=0;
uint8_t mp3_status=0;
uint8_t mp3_volume=1;
uint16_t mp3_files=0;
char chr_ansver[50];

void command(int8_t cmd, int8_t dat5, int8_t dat6)
{
  // Посылка команды MP3 плееру
  cmdbuf[3] = cmd;  // polecenie
  cmdbuf[5] = dat5; // parametr DAT1
  cmdbuf[6] = dat6; // parametr DAT2
  FOR_i(0,8) mp3.write(cmdbuf[i]);

  DEBUG("CMD : "+String(cmdbuf[0],HEX));
  FOR_i(1,8) DEBUG(" "+String(cmdbuf[i],HEX));
  DEBUGLN("");
}

boolean answer(void)
  // Ответ от MP3 плеера
{
  uint8_t i;
  uint8_t b = 0;
  while(mp3.available() && (b!=0x7E))
  {
    b = mp3.read();
    delay(5);
  }
  ansbuf[0] = b;
  i = 1;
  while(mp3.available() && (i < 10))
  {
    b = mp3.read();
    ansbuf[i] = b;
    i++;
    delay(5);
  }
  if ((ansbuf[0] == 0x7E) && (ansbuf[9] == 0xEF))
  {
    sprintf_P(chr_ansver, (const char *)F("%02X %02X %02X %02X %02X %02X %02X %02X %02X %02X"), 
    ansbuf[0],    ansbuf[1],    ansbuf[2],    ansbuf[3],    ansbuf[4],
    ansbuf[5],    ansbuf[6],    ansbuf[7],    ansbuf[8],    ansbuf[9]);
    if (hub.focused()) {
      hub.sendUpdate("DFP_ANS", String(chr_ansver));
    }
    DEBUG("ANS : ");
    DEBUGLN(String(chr_ansver));
    return true;
  }
 
  return false;
}

//--------------------------------------------------------
void WhiteAnswer() {
 uint32_t timer_1=millis();
 while ((not mp3.available()) && (millis()-timer_1<2000)) delay(5);
}

//--------------------------------------------------------
void setup_DFPlayer() {
  main_menu+=DFP_MENU;
  main_menu+=";";
  DEBUGLN("Start MP3 Player");
  mp3.begin(9600);
  delay(1000);
  command(0x0C, 0, 0);  // reset
  delay(1000);
  command(0x09, 0, 2);  // Выбор TF
  delay(1000);
  command(0x06, 0, mp3_volume);  // Громкость
  delay(300);
}
//--------------------------------------------------------
void loop_DFPlayer() {
static uint8_t sss=0;
bool ans=false;
 {EVERY_MS(10000) {
  switch (sss) {
//    case 0: command(0x42,0,0); break; // статус stop / play / pause
//    case 1: command(0x44,0,0); break; // эквалайзер
//    case 2: command(0x43,0,0); break; // громкость
//    case 3: if (!mp3_files) command(0x48,0,0); break; // количество файлов 
//    case 4: command(0x4c,0,0); break; //Текущий файл TF 
//    case 5: command(0x4f,0,0); break; //Общее количество папок 
  }
  sss = (sss+1) % 6;
 }} 
 {EVERY_MS(500) {
  ans=answer();
  if (ans) {
    
    if (ansbuf[4]==0x42) mp3_status=ansbuf[6];
    if (ansbuf[4]==0x4f) mp3_folders=256*ansbuf[5]+ansbuf[6];
    if (ansbuf[4]==0x43) {
      mp3_volume=ansbuf[6];
      DEBUGLN("mp3_volume = "+String(mp3_volume));
    }
    if (ansbuf[4]==0x48) mp3_files=256*ansbuf[5]+ansbuf[6];
  }
 }}
}
//--------------------------------------------------------
// Парсит команды из Ararm,Сети,ИК
template<typename T>
void parsing_DFPlayer(T act_chr[]) {
    String act=String(act_chr);
    act.toUpperCase();
    String strCommand=getValue(act,' ',0);
    String strParam1=getValue(act,' ',1);
    uint16_t intParam1=str_to_int(strParam1);
    String strParam2=getValue(act,' ',2);
    uint16_t intParam2=str_to_int(strParam2);
    DEBUGLN(act);
    if ((strCommand == "P_ON") || (strCommand=="PLAY")) {
      mp3_status=1;
      command(0x0D,0,0); 
    } else
    if ((strCommand == "P_OFF") || (strCommand=="STOP")) {
      mp3_status=0;
      command(0x16,0,0);
    } else
    if (strCommand == "PAUSE") {
      mp3_status=2;
      command(0x0E,0,0);
    } else
    if (strCommand  == "FOLDER") { // FOLDER folder volume
      if (strParam2>"") {
         mp3_volume=intParam1;
         command(0x06,0,intParam2); 
         delay(100);
      }
      if (strParam1>"") command(0x17,0,intParam1); 
    } else
    if (strCommand=="VOL") {
      if (strParam1 == "+") { (mp3_volume<30) ? mp3_volume++ : 30 ; command(0x06,0,mp3_volume);} else
      if (strParam1 == "-") { (mp3_volume>0) ? mp3_volume-- : 0 ; command(0x06,0,mp3_volume);} else
      if (strParam1 >  ""){
         mp3_volume=intParam1<31?intParam1:30;
         command(0x06,0,mp3_volume);
      } else command(0x43,0,0);
    } else
    if (strCommand == "NEXT") command(0x01,0,0); else
    if (strCommand == "PREV") command(0x02,0,0); else
    if (strCommand == "MP3") {  // MP3 file volume
      if (strParam2>"") {
         mp3_volume=intParam1;
         command(0x06,0,intParam2); 
         delay(100);
      }
      command(0x12,intParam1>>8 % 256,intParam1 % 256);
    }  else
    if (strCommand == "ADVERT") { // ADVERT file volume
      if (strParam2>"") {
         mp3_volume=intParam1;
         command(0x06,0,intParam2); 
         delay(100);
      }
      command(0x13,intParam1>>8 % 256,intParam1 % 256); 
    } else
    if (strCommand=="CMD") {
      command(strtoul(strParam1.c_str(), 0, 16),str_to_int(getValue(act,' ',2)),str_to_int(getValue(act,' ',3)));
    }
}
void show_player(gh::Builder& b) {
    b.beginRow(); 
    if (b.Button(0).icon(F("⏪")).label(F("Prev")).size(2).click()) parsing_DFPlayer(F("PREV"));    // ⏪ f048
    if (b.Button(0).icon(F("⏹")).label(F("Stop")).size(2).click()) parsing_DFPlayer(F("STOP"));    // ⏹ f04d или f0c8 или f45c
    if (b.Button(0).icon(F("▶")).label(F("Play")).size(3).click()) parsing_DFPlayer(F("PLAY"));    // ▶ f04b или f0da или f152
    if (b.Button(0).icon(F("⏸")).label(F("Pause")).size(2).click()) parsing_DFPlayer(F("PAUSE"));  // ⏸ f04c или f28b
    if (b.Button(0).icon(F("⏩")).label(F("Next")).size(2).click()) parsing_DFPlayer(F("NEXT"));    // ⏩ f051
    b.endRow();
    if (b.Slider(&mp3_volume).label(F("Громкость")).range(0,30,1).click()) command(0x06,0,mp3_volume);
}
//--------------------------------------------------------
void HUB_module_pult_DFPlayer(gh::Builder& b) {
  show_player(b);
}

//--------------------------------------------------------
void HUB_module_DFPlayer(gh::Builder& b) {
    static char cmd_mp3[CMD_LEN];
    show_player(b);
    if (b.Input(cmd_mp3).label(F("Команда для DFPlayer")).maxLen(HUB_LEN).click()) parsing_DFPlayer(cmd_mp3);
    b.Input_("DFP_ANS",chr_ansver).label(F("Ответ от DFPlayer"));
}

//--------------------------------------------------------
void get_DFPlayer() {
  char send_udp[25];
  Udp.beginPacket(Udp.remoteIP(), Udp.remotePort());
  sprintf_P(send_udp, (const char *)F("DFP IS %s"), mp3_status==0?"STOP":mp3_status==1?"PLAY":"PAUSE");
  Udp.print(send_udp);
  Udp.endPacket();
}  

#endif
