void module_setup() {
  /* Модули с меню 
   *  PULT - 0
   *  IP - 1
   *  Остальные номера задаются по порядку
   */
    #if defined (IR_PIN)
      setup_IR(); 
    #endif
    #if defined (TX_IR_PIN)
      setup_TX_IR(); 
    #endif
    #if defined (RX433_PIN)
      setupRX433(); 
    #endif
    #if defined (TX433_PIN)
      setup_TX433();
    #endif
    #if defined (SR501_PIN)
      setup_SR501();
    #endif
    #if defined (WS2812_PIN)
      setup_WS2812();
    #endif
    #if defined (MAX_TIMER)
      setup_TIMER();
      parsing_TIMER(F("STARTUP"));  // Запустить таймеры с  именем "STARTUP"
    #endif
    #if defined (DHT_PIN)
      setup_DHT_22();
    #endif
    #if defined (MAX_ALARMS)
      setup_Alarms();
    #endif
    #if defined (BTN_PIN)
      setup_G_Button();
    #endif
    #if defined (MAX_SENDS)
      setup_SENDS();
      main_menu+="Trans;";
    #endif
    #if defined (DFPlayer)
      setup_DFPlayer();
    #endif

//--------------------------------------------------------
    main_menu+="-?-";
  
  // Модули без меню
    #if defined (RELE_PIN)
      setup_G220();
    #endif
    #if defined (PWM_PIN)
      setup_PWM();
    #endif
    #if defined (GyverLamp)
      setup_GyverLamp();
    #endif
    
}
//--------------------------------------------------------
void module_loop() {
    #if defined (MAX_ALARMS)
      loop_Alarms();
      yield();
    #endif
    #if defined (IR_PIN)
      loop_IR();
    #endif
    #if defined (RX433_PIN)
      loopRX433();
    #endif
    #if defined (RELE_PIN)
      loop_G220();
    #endif
    #if defined (SR501_PIN)
      loop_SR501();
      yield();
    #endif
    #if defined (MAX_SENDS)
      loop_SENDS();
    #endif
    #if defined (GyverLamp)
      loop_GyverLamp();
    #endif
    #if defined (PWM_PIN)
      loop_PWM();
    #endif
    #if defined (MAX_TIMER)
      loop_TIMER();
      yield();
    #endif
    #if defined (WS2812_PIN)
      loop_WS2812();
      yield();
    #endif
    #if defined (DHT_PIN)
      loop_DHT_22();
      yield();
    #endif
    #if defined (BTN_PIN)
      loop_G_Button();
    #endif
    #if defined (DFPlayer)
      loop_DFPlayer();
    #endif
}
//--------------------------------------------------------
void module_get() {
    #if defined (RELE_PIN)
      get_G220();  
    #endif
    #if defined (PWM_PIN)
      get_PWM();  
    #endif
    #if defined (SR501_PIN)
      get_SR501();
    #endif
    #if defined (DFPlayer)
      get_DFPlayer();
    #endif
    #if defined (WS2812_PIN)
      get_WS2812();
    #endif
}
//--------------------------------------------------------
void IP_parsig(GH::Flags mod,char act1[]) {
  char act[CMD_LEN];
    strcpy(act, act1);
    String str_act = String(act);
    if (str_act.indexOf("@")!=-1) {
       String str_cmd=getValue(str_act,'@',0);
       DEBUGLN(getValue(str_act,'@',1));
       int16_t int_arg=str_to_int(getValue(str_act,'@',1));
       DEBUGLN(int_arg);
       sprintf_P(act, str_cmd.c_str(), int_arg);
    }
    FOR_i(0,MAX_IP)  
      if (mod.get(i))
       if (ip_addr[i].on_off) send_console(ip_addr[i].ipchr,act);
}
//--------------------------------------------------------
void module_parsig(GH::Flags mod,char act1[]) {
    char act[CMD_LEN];
    strcpy(act, act1);
    String str_act = String(act);
    if (str_act.indexOf("@")!=-1) {
       String str_cmd=getValue(str_act,'@',0);
       DEBUGLN(getValue(str_act,'@',1));
       int16_t int_arg=str_to_int(getValue(str_act,'@',1));
       DEBUGLN(int_arg);
       sprintf_P(act, str_cmd.c_str(), int_arg);
    }
    DEBUG("module_parsig : ");
    DEBUGLN(act); 
    //------------------------------ Виртуальные кнопки
    #ifndef GH_NO_MQTT // Отсылка значений на MQTT сервер
     if (!strncmp_P(act, PSTR("1BTN"), 4)) {
      hub.sendGet("BTN"+getValue(str_act,' ',1), 1); 
      delay(500);
      hub.sendGet("BTN"+getValue(str_act,' ',1), 0); 
      return;
     }
     if (!strncmp_P(act, PSTR("2BTN"), 4)) {
      hub.sendGet("BTN"+getValue(str_act,' ',1), 2); 
      delay(500);
      hub.sendGet("BTN"+getValue(str_act,' ',1), 0); 
      return;
     }
     if (!strncmp_P(act, PSTR("3BTN"), 4)) {
      hub.sendGet("BTN"+getValue(str_act,' ',1), 3); 
      delay(500);
      hub.sendGet("BTN"+getValue(str_act,' ',1), 0); 
      return;
     }
    #endif
     //
    #if defined (MAX_TIMER)
      if (mod.get(3)) parsing_TIMER(act);  
    #endif
    if (!strncmp_P(act, PSTR("WS2812 IS "), 10))  return;
    if (!strncmp_P(act, PSTR("CURR "), 5)) return; 
    #if defined (WS2812_PIN)
      if (mod.get(2)) parsing_WS2812(act);  
      if (!strncmp_P(act, PSTR("EFF"), 3)) return; 
    #endif
    #if defined (RELE_PIN)
      if (mod.get(0)) parsing_G220(act);  
      if (!strncmp_P(act, PSTR("RELE"), 4)) return; 
    #endif
    #if defined (PWM_PIN)
      if (mod.get(1)) parsing_PWM(act);  
      if (!strncmp_P(act, PSTR("PWM"), 3)) return; 
    #endif
    #if defined (TX_IR_PIN)
      if (mod.get(6)) parsing_TX_IR(act);
    #endif
    #if defined (TX433_PIN)
      if (mod.get(5)) parsing_TX433(act);
    #endif
    #if defined (TX433_PIN) || defined (TX_IR_PIN)
      if (!strncmp_P(act, PSTR("433"), 3)) return; 
      if (!strncmp_P(act, PSTR("IR"), 2)) return; 
    #endif
    #if defined (SR501_PIN)
      if (!strncmp_P(act, PSTR("SR501 IS"), 8)) return; 
      parsing_SR501(act);
    #endif
    #if defined (DFPlayer)
      if (mod.get(4)) parsing_DFPlayer(act);
    #endif
    #if defined (MAX_ALARMS)
      parsing_Alarm(act);
    #endif
    #if defined (MAX_SENDS)
      parsing_SENDS(act);
    #endif
}
//--------------------------------------------------------
void module_load(){
    Udp.beginPacket(Udp.remoteIP(), Udp.remotePort());
    //-------------
    load_IP();
    //-------------
    #if defined (MAX_ALARMS)
      load_Alarms();
    #endif
    #if defined (IR_PIN)
      load_IR();
    #endif
    #if defined (RX433_PIN)
      loadRX433();
    #endif
    #if defined (SR501_PIN)
      load_SR501();
    #endif
    #if defined (MAX_SENDS)
      load_SENDS();
    #endif
    #if defined (MAX_SENDS)
      load_TIMER();
    #endif
    //-------------
    Udp.endPacket();
}
//--------------------------------------------------------
void module_pult_HUB(gh::Builder& b) {
   #if defined (GyverLamp)
       HUB_module_Pult_GyverLamp(b);
   #endif
   #if defined (RELE_PIN)
       HUB_module_pult_G220(b);
   #endif
   #if defined (PWM_PIN)
       HUB_module_pult_PWM(b);
   #endif
   #if defined (WS2812_PIN)
       HUB_module_pult_WS2812(b);
   #endif
   #if defined (MAX_TIMER)
       HUB_module_pult_TIMER(b);
   #endif
   #if defined (DFPlayer)
       HUB_module_pult_DFPlayer(b);
   #endif
   #if defined (GyverLamp)
       HUB_module_Pult_GyverLamp(b); 
   #endif
}
//--------------------------------------------------------
void module_HUB(uint8_t tab,gh::Builder& b) {
//--------------------------------------------------
        #if defined (MAX_ALARMS)
        if (getValue(main_menu,';',tab)==ALARM_MENU)  HUB_module_Alarm(b);
        #endif
//--------------------------------------------------
        #if defined (IR_PIN)
        if (getValue(main_menu,';',tab)==IR_MENU)     HUB_module_IR(b);
        #endif
//--------------------------------------------------
        #if defined (RX433_PIN)
        if (getValue(main_menu,';',tab)==RX433_MENU)   HUB_moduleRX433(b);
        #endif
//--------------------------------------------------
        #if defined (SR501_PIN)
        if (getValue(main_menu,';',tab)==SR501_MENU)  HUB_module_SR501(b);
        #endif
//--------------------------------------------------
        #if defined (MAX_SENDS)
        if (getValue(main_menu,';',tab)=="Trans")     HUB_module_SENDS(b);
        #endif
//--------------------------------------------------
        #if defined (MAX_TIMER)
        if (getValue(main_menu,';',tab)==TIMER_MENU)  HUB_module_TIMER(b);
        #endif
//--------------------------------------------------
        #if defined (DHT_PIN)
        if (getValue(main_menu,';',tab)==DHT_MENU)    HUB_module_DHT_22(b);
        #endif
//--------------------------------------------------
        #if defined (WS2812_PIN)
        if (getValue(main_menu,';',tab)==WS2812_MENU) HUB_module_WS2812(b);
        #if (WS2812_D==2)  // Матрица
        if (getValue(main_menu,';',tab)==WS2812_PAINT) HUB_module_paint_WS2812(b);
        #endif
        #endif
//--------------------------------------------------
        #if defined (BTN_PIN)
        if (getValue(main_menu,';',tab)==BTN_MENU)    HUB_module_G_Button(b);
        #endif
//--------------------------------------------------
        #if defined (DFPlayer)
        if (getValue(main_menu,';',tab)==DFP_MENU)    HUB_module_DFPlayer(b);
        #endif
//--------------------------------------------------
}
