## Как это работает
Интеграция в системы умных домов (Яндекс Алиса, Home Assistant...) осуществляется через MQTT. Для этого система умного дома должна быть подключена к тому же MQTT брокеру, что и устройство, либо являться готовым сервисом. Например:
- [WQTT](https://www.wqtt.ru/) - MQTT брокер + панель управления + навык для Алисы
- [Домовёнок Кузя](https://alexstar.ru/) - панель управления + навык для Алисы

В общем случае это работает следующим образом:
- Библиотека GyverHub сама подписывается на топики для установки значений
- Из устройства можно отправлять данные на известные топики, на которые должен подписаться умный дом

### Список топиков
Список топиков с учётом префикса сети `PREFIX` и id устройства `ID` есть во вкладке Info в приложении GyverHub. Имена компонентов `NAME` отображаются во всплывающем окне при наведении курсора на компонент.

## Топики для подписки
### Получение значений
Чтобы получать данные с устройства, умный дом должен подписаться на топик

`PREFIX`/hub/`ID`/get/`NAME`

#### Отправка значений вручную
Чтобы отправить данные с устройства в умный дом, достаточно в программе вызвать команду `.sendGet(NAME, VALUE)`, где `NAME` - это имя компонента, `VALUE` - значение. В этом сценарии можно вообще не создавать в билдере компоненты для приложения. Отправлять данные можно из любого места в программе, например по какому то условию (сработал датчик, устройство включено кнопкой, закрыта дверь) или просто по таймеру, чтобы умный дом всегда знал актуальное значение (датчик температуры, заряд батареи).

#### Отправка значений авто
Вызвать `.sendGet(NAME)` - библиотека вызовет билдер, сама прочитает значение указанного компонента и отправит на get-топик. Имена компонентов можно передать списком через запятую без пробелов `.sendGet("cmp1,cmp2,slider")` - их значения будут отправлены на get-топик отдельными сообщениями.

> Данную функцию нельзя вызывать внутри билдера. 

#### Автоматическая отправка
Можно включить `.sendGetAuto(true)` - тогда при изменении компонентов с приложения библиотека автоматически отправит новое значение на get-топик.

#### Dummy
Если GyverHub используется исключительно для интеграции с умным домом, а интерфейс в приложении не нужен - есть специальный компонент `Dummy` - "пустышка". Он не создаёт в панели управления никаких компонентов, но позволяет привязать переменную для автоматизации отправки и принятия запросов из системы умного дома:

```cpp
int16_t var;

void build() {
  hub.Dummy_("comp", &var, GH_INT16);
}
```

### Статус
Чтобы получать статус устройства, умный дом должен подписаться на топик 

`PREFIX`/hub/`ID`/status

Устройство будет автоматически отправлять сообщение `online` при включении и `offline` при отключении (через Last Will). 

Также в программе можно вызвать
- `.turnOn()` для отправки состояния online
- `.turnOff()` для отправки состояния offline

## Топики для отправки
### Установка значения 
Отправить новое значение для компонента можно на топик  

`PREFIX`/`ID`/set/`NAME`  

### Запрос чтения
Для запроса значения нужно отправить пустое сообщение на топик:

`PREFIX`/`ID`/read/`NAME`

Получив это сообщение, библиотека ответит текущим значением на get-топик, значение компонента будет прочитано в билдере.