/* 
 *  см в Gyveramp файл MqttManager.h
 *  
 *  EFF71
 *  P_ON
 *  P_OFF
 *  BRI
 *  SPD
 *  SCA
 *  VOL
 *  
 *  TXT-fav on
 *  TXT-fav off
 *  
 *  ALM_SET1 ON - Включить будильник на Пн \n\
 *  ALM_SET1 OFF - Выключить будильник на Пн\n\
 *  ALM_SET1 60 - Будильник на Пн на час ночи \n\
 *  ALM_SET2 420 - Будильник на Вт на 7 часов\n\
 *  
 *  TMR_SET 1 2 300
 *  TMR_SET 0 0 0
 */

void send_console(char ip_char[], char send_udp[])
{
  IPAddress lamp(192,168,100,1);
  FOR_i(0,4) {
    String byte_str=getValue(String(ip_char),'.',i);
    lamp[i]=byte_str.toInt();
  }
    if (send_udp=="EFFRND") {
      sprintf_P(send_udp, (const char *)F("EFF%d"), random(MAX_EFF)+1);
    }
    
    Udp.beginPacket(lamp, ESP_UDP_PORT);
    delay(10);
    Udp.write(send_udp);
//    delay(50);
    Udp.endPacket();
    parseUDP();
//    DEBUG(ip_char);
//    DEBUGLN(send_udp);

}


String getValue(String data, char separator, int index)
{
    data.replace("\0"," ");
    data.trim();
    int found = 0;
    int strIndex[] = {0, -1};
    int maxIndex = data.length()-1;
    for(int i=0; i<=maxIndex && found<=index; i++){
      if(data.charAt(i)==separator || i==maxIndex){
          found++;
          strIndex[0] = strIndex[1]+1;
          strIndex[1] = (i == maxIndex) ? i+1 : i;
      }
    }
    return found>index ? data.substring(strIndex[0], strIndex[1]) : "";
}

void parseUDP()
{
  int32_t packetSize = Udp.parsePacket();

  if (packetSize)
  {
    int16_t n = Udp.read(packetBuffer, MAX_UDP_BUFFER_SIZE);
    packetBuffer[n] = '\0';
    strcpy(inputBuffer, packetBuffer);
    if (Udp.remoteIP() == WiFi.localIP()) return;  // не реагировать на свои же пакеты
//    DEBUG(F("Inbound UDP packet: "));
//    DEBUGLN(inputBuffer);
    String strBuffer=String(inputBuffer);
    String strCommand=getValue(strBuffer,';',0);
    IPAddress lamp=Udp.remoteIP();
    String str_ip_l=String(lamp[0])+"."+String(lamp[1])+"."+String(lamp[2])+"."+String(lamp[3]);

//----------------------------------
    if (strCommand=="DISCOVER") {
       Udp.beginPacket(Udp.remoteIP(), Udp.remotePort());
       char send_udp[25];
       sprintf_P(send_udp, (const char *)F(DISCOVER), WiFi.localIP()[0], WiFi.localIP()[1], WiFi.localIP()[2], WiFi.localIP()[3], ESP_UDP_PORT);
       Udp.write(send_udp);
       Udp.endPacket();
    }
//----------------------------------
    if (!strncmp_P(inputBuffer, PSTR("GET"), 3)) reply_GET_UDP();
//----------------------------------
    if (strCommand=="LOAD") load_config();
//----------------------------------
    if (strCommand=="SETIP") {
       String byte_str=getValue(strBuffer,';',1);
       int i = byte_str.toInt();
       if (i<MAX_IP) {
          String argBuffer=getValue(strBuffer,';',2);
          strcpy(ip_addr[i].ipchr,argBuffer.c_str());
          argBuffer=getValue(strBuffer,';',3); // 
          FOR_j(0,16) {
           if (argBuffer[j]=='1') ip_addr[i].copy_attr.set(j,1);
              else ip_addr[i].copy_attr.set(j,0);
          }
          FS_UPDATE(ip_addr);
       }
    }
//----------------------------------
    if (strCommand=="ALARM") {
       String byte_str=getValue(strBuffer,';',1);
       int i = byte_str.toInt();
       if (i<MAX_ALARMS) {
          String argBuffer=getValue(strBuffer,';',2);
          alarms[i].on_off=(argBuffer.toInt()==1);
          argBuffer=getValue(strBuffer,';',3);
          String strh=getValue(argBuffer,':',0);
          String strm=getValue(argBuffer,':',1);
          alarms[i].alarm_time=(strh.toInt()*60+strm.toInt())*60;
          argBuffer=getValue(strBuffer,';',4); // День недели
          FOR_j(0,7) {
           if (argBuffer[j]=='1') alarms[i].week.set(j,1);
              else alarms[i].week.set(j,0);
          }
          argBuffer=getValue(strBuffer,';',5); // IP лампы
          FOR_j(0,16) {
           if (argBuffer[j]=='1') alarms[i].lamp.set(j,1);
              else alarms[i].lamp.set(j,0);
          }
          argBuffer=getValue(strBuffer,';',6); // alarm_action
          strcpy(alarms[i].alarm_action,argBuffer.c_str());
          FS_UPDATE(alarms);
      }
   }
//--------------------------------------------------------------------         
    if (getValue(strBuffer,' ',0)!="CURR")
     FOR_i(0,MAX_SENDS) if (sends[i].on_off) 
       if (sends[i].week.get(dayofweek))
        if (String(sends[i].ipchr) == str_ip_l) 
           {
            bool on_time=false;
            if (sends[i].time_from<sends[i].time_to) 
                on_time=(hour*60+minute>=round(sends[i].time_from/60)) && (hour*60+minute<=round(sends[i].time_to/60));
            else    
                on_time=(hour*60+minute>=round(sends[i].time_from/60)) || (hour*60+minute<=round(sends[i].time_to/60));
            if (on_time) 
             FOR_j(0,MAX_IP)
               if (sends[i].lamp.get(j)) {
                 send_console(ip_addr[j].ipchr,inputBuffer);
                 DEBUGLN(String(ip_addr[j].ipchr)+":"+strBuffer);
               }
           } 
//--------------------------------------------------------------------         
    FOR_i(0,MAX_IP) if (ip_addr[i].on_off) {
      if (String(ip_addr[i].ipchr) == str_ip_l) {
         lamp_status[i].last_input_udp=millis();
         lamp_status[i].online=true;
   //--------------------------------------------------------------------         
         if (getValue(strBuffer,' ',0)=="CURR") { 
            if (getValue(strBuffer,' ',5)=="1") lamp_status[i].on_off=true;
            else lamp_status[i].on_off=false;  
         String byte_str=getValue(strBuffer,' ',1);
         lamp_status[i].eff=byte_str.toInt();
         byte_str=getValue(strBuffer,' ',2);
         lamp_status[i].BRI=byte_str.toInt();
         byte_str=getValue(strBuffer,' ',3);
         lamp_status[i].SPD=byte_str.toInt();
         byte_str=getValue(strBuffer,' ',4);
         lamp_status[i].SCA=byte_str.toInt();
         byte_str=getValue(strBuffer,' ',1);
         if (i==0) effect=byte_str.toInt();
         }
   //--------------------------------------------------------------------         
         if (getValue(String(inputBuffer),' ',0)=="IP") { 
            String str = getValue(String(inputBuffer),' ',1);
            lamp_status[i].name = getValue(str,':',2);
         }
   //--------------------------------------------------------------------         


//--------------------------------------------------------------------         
       }
      if (millis()-lamp_status[i].last_input_udp>60000)
       {
         hub.sendUpdate("led"+String(i), "0");
         lamp_status[i].online=false;
       }  
      if (hub.focused()) {
         hub.sendUpdate("led_on"+String(i), String(lamp_status[i].on_off));
         hub.sendUpdate("led"+String(i), String(lamp_status[i].online));
       }    
    }
  }
}
  
//----------------------------------
void Get_Name() {
  static uint8_t i;
  i++;
  if (i>=MAX_IP) i=0;
     if (ip_addr[i].on_off)
       if (lamp_status[i].name=="")
        send_console(ip_addr[i].ipchr,"DISCOVER");
}

//----------------------------------
void reply_GET_UDP() {
   Udp.beginPacket(Udp.remoteIP(), Udp.remotePort());
   char send_udp[25];
   sprintf_P(send_udp, (const char *)F("CURR 0 0 0 0 0 0 0 0 0 %d:%d:00 0"), hour,minute);
   Udp.write(send_udp);
   Udp.endPacket();
}
//----------------------------------
void load_config() {
   Udp.beginPacket(Udp.remoteIP(), Udp.remotePort());
   String CONFIG="";
   FOR_i(0,MAX_IP) {
    CONFIG+="SETIP;"+String(i)+";"+String(ip_addr[i].ipchr)+";"+ip_addr[i].copy_attr.toString()+";"+lamp_status[i].name+char(10);
   }
   FOR_i(0,MAX_ALARMS) {
    CONFIG+="ALARM;"+String(i);
    if (alarms[i].on_off) CONFIG+=";1;";
                     else CONFIG+=";0;";
    CONFIG+=String(alarms[i].alarm_time/3600)+":"+String((alarms[i].alarm_time/60)%60)+";";
    CONFIG+=alarms[i].week.toString()+";"+alarms[i].lamp.toString()+";"+String(alarms[i].alarm_action)+char(10);
   }
   Udp.write(CONFIG.c_str());
   Udp.endPacket();
}
