#include <WiFiUdp.h>
#include <NTPClient.h>
#include <GyverHub.h>
#include <Stamp.h>
#include <FSManager.h>
#include <SimplePortal.h>
//My
#include "macros.h"            //Список макросов
#include "define.h"            //Настройки и переменные

void setup() {
#ifdef DEBUG_SERIAL_GT
  Serial.begin(115200);
#endif

  SPIFFS.begin(); // подключаем файловую систему 
  IR_SETUP(); // запускаем прием
  Connect_WiFi_Portal();    // ищем сеть WiFi

  timeClient.begin();
  delay(500);
  timeClient.update(); 
  hour   = timeClient.getHours();
  minute = timeClient.getMinutes();
  Udp.begin(localPort);
  hub.onBuild(build);     // подключаем билдер
  hub.begin();            // запускаем систему
  byte stat;
  FS_LOAD(alarms); 
  FS_LOAD(ip_addr); 
  FS_LOAD(sends); 
  FS_LOAD(IR_pult); 
  Get_Name();
  
}


void loop() {
  hub.tick();  // обязательно тикаем тут
  IR_LOOP();
  // Разные таймеры
  usertimeClientupdate();
  userTimeRead();
  userWiFiReconect();
  userAutoSave();
  test_alarms();
  Get_Status();
  Get_Name_Evry_10_min();
  parseUDP();
}
