//------------------
#define MAX_IP              14      // Максимальное количество - 16 из за особенностей GHflags
#define MAX_IR              20      // Максимальное количество IR команд
#define MAX_ALARMS          20
#define MAX_SENDS           10
#define ESP_UDP_PORT        (8888U) // номер порта, который будет слушать UDP сервер во время работы лампы как в режиме WiFi точки доступа, так и в режиме WiFi клиента (лучше не менять)
#define MAX_EFF             91
#define MAX_UDP_BUFFER_SIZE (512U)// максимальный размер буффера UDP сервера

//заглушка для приложения управления лампами
#define DISCOVER "IP %u.%u.%u.%u:%u:HUB_Server"

//FSManager FSwifi(portalCfg,"wifi.dat");
FS_(portalCfg); // Макрос

#define IP_STATIC                 // Если нужен статический IP, раскоментируйте
#if defined (IP_STATIC)
IPAddress ip(192,168,100,101);    //Node static IP
IPAddress gateway(192,168,100,1);
IPAddress subnet(255,255,255,0);
#endif


char packetBuffer[MAX_UDP_BUFFER_SIZE]; // buffer to hold incoming packet
char inputBuffer[MAX_UDP_BUFFER_SIZE];

GyverHub hub("MyDevices","HUB Server","💥");

uint16_t localPort = ESP_UDP_PORT;

WiFiUDP Udp;


WiFiUDP ntpUDP;
int hour = 1;
int minute = 0;
int dayofweek=0;

uint64_t ntp_update_time=0;
const long utcOffsetInSeconds = 10800;

NTPClient timeClient(ntpUDP, "pool.ntp.org",utcOffsetInSeconds);
bool eeprom_flag=false;
bool copy_to_all=true;

//--------------------------
struct struct_ip_addr{
bool on_off;
char ipchr[15];
GHflags copy_attr;
};

struct_ip_addr ip_addr[MAX_IP];
FS_(ip_addr);
//--------------------------
struct struct_IR_pult{
bool on_off;
char ir_action[15];
uint32_t code=0;
GHflags lamp=0;
bool repeat;
};

struct_IR_pult IR_pult[MAX_IR];
FS_(IR_pult);

//--------------------------
struct struct_alarm{
bool on_off=false;
uint32_t alarm_time=0;
char alarm_action[15];
GHflags week=0;
GHflags lamp=0;
bool ok=true;
};

struct_alarm alarms[MAX_ALARMS];
FS_(alarms);
//--------------------------
struct struct_send{
bool on_off;
char ipchr[15];
uint32_t time_from=0;
uint32_t time_to=0;
GHflags week=0;
GHflags lamp=0;
bool ok=true;
};
struct_send sends[MAX_SENDS];
FS_(sends);
//--------------------------
struct struct_lamp_status{
bool online;
bool on_off;
uint32_t last_input_udp=0;
String name;
uint8_t eff;
uint8_t BRI;
uint8_t SPD;
uint8_t SCA;
};

struct_lamp_status lamp_status[MAX_IP];
//--------------------------
uint8_t effect=0;
#define select_effect "Бeлый cвeт,\
Цвeт,\
Cмeнa цвeтa,\
Бeзyмиe,\
Oблaкa,\
Лaвa,\
Плaзмa,\
Paдyгa 3D,\
Пaвлин,\
3eбpa,\
Лec,\
Oкeaн,\
Mячики,\
Mячики бeз гpaниц,\
Пoпкopн,\
Cпиpaли,\
Пpизмaтa,\
Дымoвыe шaшки,\
Плaмя,\
Oгoнь 21,\
Tиxий oкeaн,\
Teни,\
ДHK,\
Cтaя,\
Cтaя и xищник,\
Moтыльки,\
Лaмпa c мoтылькaми,\
3мeйки,\
Nexus,\
Шapы,\
Cинycoид,\
Meтaбoлз,\
Ceвepнoe cияниe,\
Плaзмeннaя лaмпa,\
Лaвoвaя лaмпa,\
Жидкaя лaмпa,\
Жидкaя лaмпa (auto),\
Kaпли нa cтeклe,\
Maтpицa,\
Oгoнь 12,\
Oгoнь 18,\
Oгoнь 20,\
Oгoнь,\
Bиxpи плaмeни,\
Paзнoцвeтныe виxpи,\
Maгмa,\
Kипeниe,\
Boдoпaд,\
Boдoпaд 4/1,\
Бacceйн,\
Пyльc,\
Paдyжный пyльc,\
Бeлый пyльc,\
Ocциллятop,\
Иcтoчник,\
Фeя,\
Koмeтa,\
Oднoцвeтнaя кoмeтa,\
2 кoмeты,\
3 кoмeты,\
Люмeньep,\
Пpитяжeниe,\
Пapящий oгoнь,\
Bepxoвoй oгoнь,\
Paдyжный змeй,\
Koнфeтти,\
Mepцaниe,\
Дым,\
Paзнoцвeтный дым,\
Пикacco,\
Boлны,\
M&M,\
Koдoвый зaмoк,\
Музыкальный дождь,\
Гроза,\
Ocaдки,\
Paзнoцвeтный дoждь,\
Cнeгoпaд,\
3вeздoпaд / Meтeль,\
Пpыгyны,\
Cвeтлячки,\
Cвeтлячки co шлeйфoм,\
Пeйнтбoл,\
Paдyгa,\
Реки Ботсваны,\
Завиток,\
Вино,\
Масляные Краски,\
Акварель,\
Свеча,\
Салют,\
Блуждающий кубик,\
Чacы,\
Стрелочные Часы,\
Бeгyщaя cтpoкa,\
Рисование,\
Эквалайзер,\
Громкость"
