//IR
#include <IRremoteESP8266.h>
#include <IRrecv.h>
#include <IRutils.h>


//------------------
#define IR_PIN              4       // D2 Пин, куда подключет IR 
IRrecv irrecv(IR_PIN);
decode_results results;
int64_t IR_last_press;
int64_t IR_press;
String IR_str="IR";
bool pressed;

void IR_SETUP(){
  irrecv.enableIRIn();
}

void IR_LOOP() {
  if ( irrecv.decode( &results )) {   // если данные пришли
      IR_str=String(uint32_t(results.value),HEX);
      DEBUGLN(IR_str);
      if (results.value != -1) {
         pressed=false;
         IR_press=results.value;
 
         FOR_i(0,MAX_IR) {
          //Записать команду в свободную включенную ячейку
           if (IR_pult[i].on_off)
            if (IR_pult[i].code==0) {
              IR_pult[i].code=IR_press;
              FS_UPDATE(IR_pult);
              hub.sendUpdate("code"+String(i), IR_str);
            }
         }
      } else IR_press=-1;
      FOR_j(0,MAX_IR) {
           if (IR_pult[j].on_off) {
              if (IR_press==-1) IR_press=IR_last_press;
              if ((IR_pult[j].code==IR_press) || (IR_pult[j].code==0xFFFFFFFF)) {
                if (IR_pult[j].repeat) IR_last_press = IR_press; else IR_last_press = -1;
//                DEBUG(String(uint32_t(IR_pult[j].code),HEX)); DEBUG(" ");  DEBUGLN(IR_pult[j].ir_action);
                FOR_i(0,MAX_IP) if (IR_pult[j].lamp.get(i)) if (ip_addr[i].on_off) {
                   char IR_Action[15];
                   strcpy(IR_Action, IR_pult[j].ir_action);
                   if (!strcmp(IR_Action,"ON_OFF")){
                      if (lamp_status[i].on_off) strcpy(IR_Action,"P_OFF"); else strcpy(IR_Action,"P_ON");
                      } else
                   if (!strcmp(IR_Action,"IRx"))   sprintf_P(IR_Action,"IR %x",IR_press); else
                   if (!strcmp(IR_Action,"IR"))   sprintf_P(IR_Action,"IR %u",IR_press); else
                   if (!strcmp(IR_Action,"EFF+")) sprintf_P(IR_Action,"EFF%u",lamp_status[i].eff++ % MAX_EFF); else
                   if (!strcmp(IR_Action,"EFF-")) sprintf_P(IR_Action,"EFF%u",(lamp_status[i].eff-- + MAX_EFF) % MAX_EFF); else
                   if (!strcmp(IR_Action,"BRI+")) sprintf_P(IR_Action,"BRI%u",lamp_status[i].BRI++); else
                   if (!strcmp(IR_Action,"BRI-")) sprintf_P(IR_Action,"BRI%u",lamp_status[i].BRI--); else
                   if (!strcmp(IR_Action,"SPD+")) sprintf_P(IR_Action,"SPD%u",lamp_status[i].SPD++); else
                   if (!strcmp(IR_Action,"SPD-")) sprintf_P(IR_Action,"SPD%u",lamp_status[i].SPD--); else
                   if (!strcmp(IR_Action,"SCA+")) sprintf_P(IR_Action,"SCA%u",lamp_status[i].SCA++ % 101); else
                   if (!strcmp(IR_Action,"SCA-")) sprintf_P(IR_Action,"SCA%u",(lamp_status[i].SCA-- + 101) % 101); else


                   DEBUGLN(IR_Action); // else
                   
                   send_console(ip_addr[i].ipchr,IR_Action);
                }
              }
           }   
      }

//           IR_last_press=IR_press;
    irrecv.resume();  // принимаем следующую команду
  }
}
