/*
 * Decompiled with CFR 0.152.
 */
package com.esp32.mkspiffs;

import com.esp32.mkspiffs.StreamGobbler;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JOptionPane;
import org.apache.commons.codec.digest.DigestUtils;
import processing.app.BaseNoGui;
import processing.app.Editor;
import processing.app.PreferencesData;
import processing.app.Sketch;
import processing.app.debug.TargetPlatform;
import processing.app.helpers.FileUtils;
import processing.app.helpers.PreferencesMap;
import processing.app.tools.Tool;

public class ESP32FS
implements Tool {
    Editor editor;
    private String typefs = "";

    public void init(Editor editor) {
        this.editor = editor;
    }

    public String getMenuTitle() {
        return "ESP32 Sketch Data Upload";
    }

    private int listenOnProcess(String[] stringArray) {
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(stringArray);
            StreamGobbler streamGobbler = new StreamGobbler(process.getErrorStream(), "_");
            StreamGobbler streamGobbler2 = new StreamGobbler(process.getInputStream(), "-");
            streamGobbler.start();
            streamGobbler2.start();
            int n = process.waitFor();
            return n;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private void sysExec(final String[] stringArray) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    if (ESP32FS.this.listenOnProcess(stringArray) != 0) {
                        ESP32FS.this.editor.statusError(ESP32FS.this.typefs + " Upload failed!");
                    } else {
                        ESP32FS.this.editor.statusNotice(ESP32FS.this.typefs + " Image Uploaded");
                    }
                }
                catch (Exception exception) {
                    ESP32FS.this.editor.statusError(ESP32FS.this.typefs + " Upload failed!");
                }
            }
        };
        thread.start();
    }

    private String getBuildFolderPath(Sketch sketch) {
        try {
            String string = sketch.getBuildPath().getAbsolutePath();
            return string;
        }
        catch (IOException iOException) {
            this.editor.statusError((Exception)iOException);
        }
        catch (Exception exception) {
            try {
                File file = FileUtils.createTempFolder((String)"build", (String)(DigestUtils.md5Hex((String)sketch.getMainFilePath()) + ".tmp"));
                return file.getAbsolutePath();
            }
            catch (IOException iOException) {
                this.editor.statusError((Exception)iOException);
            }
            catch (Exception exception2) {
                try {
                    Method method = BaseNoGui.class.getMethod("getBuildFolder", new Class[0]);
                    File file = (File)method.invoke(null, new Object[0]);
                    return file.getAbsolutePath();
                }
                catch (SecurityException securityException) {
                    this.editor.statusError((Exception)securityException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.editor.statusError((Exception)illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.editor.statusError((Exception)invocationTargetException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.editor.statusError((Exception)noSuchMethodException);
                }
            }
        }
        return "";
    }

    private long parseInt(String string) {
        if (string.endsWith("m") || string.endsWith("M")) {
            return 0x100000L * Long.decode(string.substring(0, string.length() - 1));
        }
        if (string.endsWith("k") || string.endsWith("K")) {
            return 1024L * Long.decode(string.substring(0, string.length() - 1));
        }
        return Long.decode(string);
    }

    private long getIntPref(String string) {
        String string2 = (String)BaseNoGui.getBoardPreferences().get((Object)string);
        if (string2 == null || string2.contentEquals("")) {
            return 0L;
        }
        return this.parseInt(string2);
    }

    private void createAndUpload() {
        File[] fileArray;
        String string;
        String string2;
        String string3;
        Object object2;
        long l = 0L;
        long l2 = 0L;
        long l3 = 256L;
        long l4 = 4096L;
        long l5 = 0L;
        String string4 = "";
        if (this.typefs == "FatFS") {
            l5 = 4096L;
        }
        System.out.println("Chip : " + this.getChip());
        if (!PreferencesData.get((String)"target_platform").contains("esp32")) {
            System.err.println();
            this.editor.statusError(this.typefs + " Not Supported on " + PreferencesData.get((String)"target_platform"));
            return;
        }
        TargetPlatform targetPlatform = BaseNoGui.getTargetPlatform();
        String string5 = ".py";
        if (PreferencesData.get((String)"runtime.os").contentEquals("windows")) {
            string5 = ".exe";
        }
        String string6 = PreferencesData.get((String)"runtime.os").contentEquals("windows") ? "python.exe" : "python3";
        String string7 = PreferencesData.get((String)"runtime.os").contentEquals("windows") ? (this.typefs == "LittleFS" ? "mklittlefs.exe" : (this.typefs == "FatFS" ? "mkfatfs.exe" : "mkspiffs.exe")) : (this.typefs == "LittleFS" ? "mklittlefs" : (this.typefs == "FatFS" ? "mkfatfs" : "mkspiffs"));
        String string8 = "espota.py";
        if (PreferencesData.get((String)"runtime.os").contentEquals("windows")) {
            string8 = "espota.exe";
        }
        Boolean bl = false;
        File file = new File(targetPlatform.getFolder() + "/tools");
        File file2 = new File(targetPlatform.getFolder() + "/tools");
        String string9 = PreferencesData.get((String)"serial.port");
        if (!BaseNoGui.getBoardPreferences().containsKey((Object)"build.partitions")) {
            System.err.println();
            this.editor.statusError("Partitions Not Defined for " + (String)BaseNoGui.getBoardPreferences().get((Object)"name"));
            return;
        }
        File file3 = new File(this.editor.getSketch().getFolder(), "partitions.csv");
        if (file3.exists() && file3.isFile()) {
            System.out.println("Using partitions.csv from sketch folder.");
        } else {
            System.out.println("Using partition scheme from Arduino IDE.");
            try {
                string4 = (String)BaseNoGui.getBoardPreferences().get((Object)"build.partitions");
                if (string4 == null || string4.contentEquals("")) {
                    this.editor.statusError("Partitions Not Found for " + (String)BaseNoGui.getBoardPreferences().get((Object)"name"));
                    return;
                }
            }
            catch (Exception exception) {
                this.editor.statusError(exception);
                return;
            }
            file3 = new File(targetPlatform.getFolder() + "/tools/partitions", string4 + ".csv");
            if (!file3.exists() || !file3.isFile()) {
                System.err.println();
                this.editor.statusError(this.typefs + " Error: partitions file " + string4 + ".csv not found!");
                return;
            }
        }
        try {
            object2 = new BufferedReader(new FileReader(file3));
            string3 = "";
            long l6 = 0L;
            boolean bl2 = false;
            while ((string3 = ((BufferedReader)object2).readLine()) != null) {
                if (string3.substring(0, 1).equals("#")) continue;
                if (this.typefs != "FatFS" && string3.contains("spiffs") || this.typefs == "FatFS" && string3.contains("ffat")) {
                    bl2 = true;
                }
                string3 = string3.substring(string3.indexOf(",") + 1);
                string3 = string3.substring(string3.indexOf(",") + 1);
                string3 = string3.substring(string3.indexOf(",") + 1);
                while (string3.startsWith(" ")) {
                    string3 = string3.substring(1);
                }
                string2 = string3.substring(0, string3.indexOf(","));
                string3 = string3.substring(string3.indexOf(",") + 1);
                while (string3.startsWith(" ")) {
                    string3 = string3.substring(1);
                }
                string = string3.substring(0, string3.indexOf(","));
                if (bl2) {
                    l = string2 == null || string2.trim().isEmpty() ? l6 + l5 : this.parseInt(string2) + l5;
                    l2 = this.parseInt(string) - l5;
                    break;
                }
                if (string != null && !string.trim().isEmpty()) {
                    l6 = string2 == null || string2.trim().isEmpty() ? (l6 += this.parseInt(string)) : this.parseInt(string2) + this.parseInt(string);
                }
                l2 = 0L;
            }
            if (l2 == 0L) {
                System.err.println();
                this.editor.statusError(this.typefs + " Error: partition size could not be found!");
                return;
            }
        }
        catch (Exception exception) {
            this.editor.statusError(exception);
            return;
        }
        System.out.println("Start: 0x" + String.format("%x", l));
        System.out.println("Size : 0x" + String.format("%x", l2));
        object2 = new File(targetPlatform.getFolder() + "/tools", string7);
        if (!(((File)object2).exists() && ((File)object2).isFile() || ((File)(object2 = new File(targetPlatform.getFolder() + "/tools/mk" + this.typefs.toLowerCase(), string7))).exists() || ((File)(object2 = new File(PreferencesData.get((String)("runtime.tools.mk" + this.typefs.toLowerCase() + ".path")), string7))).exists())) {
            System.err.println();
            this.editor.statusError(this.typefs + " Error: mk" + this.typefs.toLowerCase() + "not found!");
            return;
        }
        System.out.println("mk" + this.typefs.toLowerCase() + " : " + ((File)object2).getAbsolutePath());
        System.out.println();
        if (string9 == null || string9.isEmpty()) {
            System.err.println();
            this.editor.statusError(this.typefs + " Error: serial port not defined!");
            return;
        }
        if (string9.split("\\.").length == 4) {
            bl = true;
            file = new File(targetPlatform.getFolder() + "/tools", string8);
            if (!(file.exists() && file.isFile() || (file = new File(targetPlatform.getFolder() + "/tools", "espota.py")).exists() && file.isFile())) {
                System.err.println();
                this.editor.statusError(this.typefs + " Error: espota not found!");
                return;
            }
            System.out.println("espota : " + file.getAbsolutePath());
            System.out.println();
        } else {
            string3 = "esptool" + string5;
            file2 = new File(targetPlatform.getFolder() + "/tools", string3);
            if (!(file2.exists() && file2.isFile() || (file2 = new File(targetPlatform.getFolder() + "/tools/esptool_py", string3)).exists() && file2.isFile() || (file2 = new File(targetPlatform.getFolder() + "/tools/esptool", string3)).exists() && file2.isFile() || (file2 = new File(PreferencesData.get((String)"runtime.tools.esptool_py.path"), string3)).exists() && file2.isFile() || (file2 = new File(PreferencesData.get((String)"runtime.tools.esptool.path"), string3)).exists() && file2.isFile())) {
                System.err.println();
                this.editor.statusError("Error: esptool not found!");
                return;
            }
            System.out.println("esptool : " + file2.getAbsolutePath());
            System.out.println();
        }
        int n = 0;
        File file4 = new File(this.editor.getSketch().getFolder(), "data");
        if (!file4.exists()) {
            file4.mkdirs();
        }
        if (file4.exists() && file4.isDirectory() && (fileArray = file4.listFiles()).length > 0) {
            for (File object3 : fileArray) {
                if (!object3.isDirectory() && !object3.isFile() || object3.getName().startsWith(".")) continue;
                ++n;
            }
        }
        fileArray = file4.getAbsolutePath();
        String string10 = ((File)object2).getAbsolutePath();
        string2 = this.editor.getSketch().getName();
        string = this.getBuildFolderPath(this.editor.getSketch()) + "/" + string2 + "." + this.typefs.toLowerCase() + ".bin";
        String string11 = (String)BaseNoGui.getBoardPreferences().get((Object)"upload.speed");
        Object[] objectArray = new Object[]{"Yes", "No"};
        String string12 = this.typefs + " Create";
        String string13 = "No files have been found in your data folder!\nAre you sure you want to create an empty " + this.typefs + " image?";
        if (n == 0 && JOptionPane.showOptionDialog((Component)this.editor, string13, string12, 0, 3, null, objectArray, objectArray[1]) != 0) {
            System.err.println();
            this.editor.statusError(this.typefs + " Warning: mktool canceled!");
            return;
        }
        this.editor.statusNotice(this.typefs + " Creating Image...");
        System.out.println("[" + this.typefs + "] data   : " + (String)fileArray);
        System.out.println("[" + this.typefs + "] offset : " + l5);
        System.out.println("[" + this.typefs + "] start  : " + l);
        System.out.println("[" + this.typefs + "] size   : " + l2 / 1024L);
        if (this.typefs != "FatFS") {
            System.out.println("[" + this.typefs + "] page   : " + l3);
            System.out.println("[" + this.typefs + "] block  : " + l4);
        }
        try {
            if (this.typefs == "FatFS") {
                if (this.listenOnProcess(new String[]{string10, "-c", fileArray, "-s", l2 + "", string}) != 0) {
                    System.err.println();
                    this.editor.statusError(this.typefs + " Create Failed!");
                    return;
                }
            } else if (this.listenOnProcess(new String[]{string10, "-c", fileArray, "-p", l3 + "", "-b", l4 + "", "-s", l2 + "", string}) != 0) {
                System.err.println();
                this.editor.statusError(this.typefs + " Create Failed!");
                return;
            }
        }
        catch (Exception string132) {
            this.editor.statusError(string132);
            this.editor.statusError(this.typefs + " Create Failed!");
            return;
        }
        this.editor.statusNotice(this.typefs + " Uploading Image...");
        System.out.println("[" + this.typefs + "] upload : " + string);
        if (bl.booleanValue()) {
            System.out.println("[" + this.typefs + "] IP     : " + string9);
            System.out.println("Running: " + file.getAbsolutePath() + " -i " + string9 + " -p 3232 -s -f " + string);
            System.out.println();
            if (file.getAbsolutePath().endsWith(".py")) {
                this.sysExec(new String[]{string6, file.getAbsolutePath(), "-i", string9, "-p", "3232", "-s", "-f", string});
            } else {
                this.sysExec(new String[]{file.getAbsolutePath(), "-i", string9, "-p", "3232", "-s", "-f", string});
            }
        } else {
            String string14 = (String)BaseNoGui.getBoardPreferences().get((Object)"build.flash_mode");
            String string15 = (String)BaseNoGui.getBoardPreferences().get((Object)"build.flash_freq");
            System.out.println("[" + this.typefs + "] address: " + l);
            System.out.println("[" + this.typefs + "] port   : " + string9);
            System.out.println("[" + this.typefs + "] speed  : " + string11);
            System.out.println("[" + this.typefs + "] mode   : " + string14);
            System.out.println("[" + this.typefs + "] freq   : " + string15);
            System.out.println();
            if (file2.getAbsolutePath().endsWith(".py")) {
                this.sysExec(new String[]{string6, file2.getAbsolutePath(), "--chip", this.getChip(), "--baud", string11, "--port", string9, "--before", "default_reset", "--after", "hard_reset", "write_flash", "-z", "--flash_mode", string14, "--flash_freq", string15, "--flash_size", "detect", "" + l, string});
            } else {
                this.sysExec(new String[]{file2.getAbsolutePath(), "--chip", this.getChip(), "--baud", string11, "--port", string9, "--before", "default_reset", "--after", "hard_reset", "write_flash", "-z", "--flash_mode", string14, "--flash_freq", string15, "--flash_size", "detect", "" + l, string});
            }
        }
    }

    private void eraseFlash() {
        Object[] objectArray;
        System.out.println("Chip : " + this.getChip());
        if (!PreferencesData.get((String)"target_platform").contains("esp32")) {
            System.err.println();
            this.editor.statusError(this.typefs + " Not Supported on " + PreferencesData.get((String)"target_platform"));
            return;
        }
        TargetPlatform targetPlatform = BaseNoGui.getTargetPlatform();
        String string = ".py";
        if (PreferencesData.get((String)"runtime.os").contentEquals("windows")) {
            string = ".exe";
        } else if (PreferencesData.get((String)"runtime.os").contentEquals("macosx")) {
            string = "";
        }
        String string2 = PreferencesData.get((String)"runtime.os").contentEquals("windows") ? "python.exe" : "python";
        Boolean bl = false;
        File file = new File(targetPlatform.getFolder() + "/tools");
        String string3 = PreferencesData.get((String)"serial.port");
        if (string3 == null || string3.isEmpty()) {
            System.err.println();
            this.editor.statusError(this.typefs + " Error: serial port not defined!");
            return;
        }
        if (string3.split("\\.").length == 4) {
            bl = true;
        } else {
            objectArray = "esptool" + string;
            file = new File(targetPlatform.getFolder() + "/tools", (String)objectArray);
            if (!(file.exists() && file.isFile() || (file = new File(targetPlatform.getFolder() + "/tools/esptool_py", (String)objectArray)).exists() && file.isFile() || (file = new File(targetPlatform.getFolder() + "/tools/esptool", (String)objectArray)).exists() && file.isFile() || (file = new File(PreferencesData.get((String)"runtime.tools.esptool_py.path"), (String)objectArray)).exists() && file.isFile() || (file = new File(PreferencesData.get((String)"runtime.tools.esptool.path"), (String)objectArray)).exists() && file.isFile())) {
                System.err.println();
                this.editor.statusError("Error: esptool not found!");
                return;
            }
            System.out.println("esptool : " + file.getAbsolutePath());
            System.out.println();
        }
        objectArray = new Object[]{"Yes", "No"};
        String string4 = "Erase All Flash";
        String string5 = "Are you sure?";
        if (JOptionPane.showOptionDialog((Component)this.editor, string5, string4, 0, 3, null, objectArray, objectArray[1]) != 0) {
            System.err.println();
            this.editor.statusError("Warning: Erase All Flash canceled!");
            return;
        }
        this.editor.statusNotice("Erasing all Flash started...");
        System.out.println("Erasing all Flash started...");
        if (bl.booleanValue()) {
            System.out.println("Cannot be done through OTA, IP     : " + string3);
            System.out.println();
        } else {
            System.out.println("Port: " + string3);
            System.out.println();
            if (file.getAbsolutePath().endsWith(".py")) {
                this.sysExec(new String[]{string2, file.getAbsolutePath(), "--chip", this.getChip(), "--port", string3, "--before", "default_reset", "--after", "hard_reset", "erase_flash"});
            } else {
                this.sysExec(new String[]{file.getAbsolutePath(), "--chip", this.getChip(), "--port", string3, "--before", "default_reset", "--after", "hard_reset", "erase_flash"});
            }
        }
    }

    private String getChip() {
        PreferencesMap preferencesMap = BaseNoGui.getTargetBoard().getPreferences();
        String string = preferencesMap.get("build.mcu", "esp32");
        return string;
    }

    public void run() {
        String string = this.editor.getSketch().getName();
        Object[] objectArray = new Object[]{"LittleFS", "SPIFFS", "FatFS", "!Erase Flash!"};
        this.typefs = (String)JOptionPane.showInputDialog((Component)this.editor, "Select FS for " + string + " /data folder", "Filesystem", -1, null, objectArray, "LittleFS");
        if (this.typefs != null && this.typefs.length() > 0) {
            if (this.typefs == "!Erase Flash!") {
                this.eraseFlash();
            } else {
                this.createAndUpload();
            }
        } else {
            System.out.println("Tool Exit.");
            return;
        }
    }
}

