# Свой способ связи
Связь устройства с приложением называется `Bridge` - мост, все встроенные способы связи являются такими мостами. Можно добавить свою реализацию для любого способа связи и переопределить системный. Например можно сделать работу через MQTT или WS с использованием любой другой библиотеки. Делается это следующим образом:

1. Создать свой класс на базе `gh::Bridge` с наследованием конструктора
2. Реализовать методы `begin()` (необязательно), `end()` (необязательно), `tick()`, `send(BridgeData& data)`
3. Поступающие данные отправлять в `parse(AnyText url)` или `parse(AnyText url, AnyText data)`
4. Создать объект этого класса
5. Передать его адрес в `hub.addBridge()`

Теперь ваш мост работает наравне с системными!

### Возможности моста
У моста можно узнать тип подключения, а также выключить и включить его - отключенный мост пропускает данные. У моста можно вручную проверить, подключен ли сейчас через него клиент. В ручной реализации для websocket желательно ставить фокус при подключении клиента и снимать при отключении.
```cpp
Connection connection();    // тип подключения

void enable();              // включить
void disable();             // выключить
bool state();               // статус включен или выключен

void setFocus();            // установить focus
void clearFocus();          // снять focus
bool getFocus();            // получить focus
```

## Пример с Serial
```cpp
GyverHub hub;

class HubSerial : public gh::Bridge {
   public:
    using gh::Bridge::Bridge;  // наследуем конструктор

    void begin() {
        Serial.begin(115200);
    }

    void tick() {
        // приложение пришлёт строку команды, завершённую нулём
        // читем команду и отправляем в parse
        if (Serial.available()) {
            String str = Serial.readStringUntil('\0');
            parse(str);
        }
    }

    // это обработчик отправки, библиотека отправит в него данные
    // gh::BridgeData см. документацию
    void send(gh::BridgeData& data) {
        Serial.print(data.text);
    }
};

// наследованный конструктор требует указать экземпляр GyverHub, тип связи и функцию GyverHub::parseHook
HubSerial serial(&hub, gh::Connection::Serial, GyverHub::parseHook);

void setup() {
    hub.addBridge(&serial);     // подключаем мост
    hub.begin();
}
```

Ещё несколько примеров есть во встроенных примерах к библиотеке в папке /manual