#include <FastLED.h>

//--------------------------------------------------------

void send_console(char* T_ip, char T_udp[]) {
  IPAddress lamp_ip(192,168,100,1);
  int lamp[4];
  sscanf(T_ip, "%u.%u.%u.%u", lamp, lamp+1, lamp+2, lamp+3);
  FOR_i(0,4) lamp_ip[i]=lamp[i];
  Udp.beginPacket(lamp_ip, ESP_UDP_PORT);
  delay(10);
  Udp.print(T_udp);
  Udp.endPacket();
  parseUDP();
}
//--------------------------------------------------------
//#ifdef WS2812_PAINT
String getValue(String data, char separator, int index)
{
    data.replace("\0"," ");
    data.trim();
    int found = 0;
    int strIndex[] = {0, -1};
    int maxIndex = data.length()-1;
    for(int i=0; i<=maxIndex && found<=index; i++){
      if(data.charAt(i)==separator || i==maxIndex){
          found++;
          strIndex[0] = strIndex[1]+1;
          strIndex[1] = (i == maxIndex) ? i+1 : i;
      }
    }
    return found>index ? data.substring(strIndex[0], strIndex[1]) : "";
}
//#endif
//--------------------------------------------------------
// Позиция в списке -1 не найдено
int16_t split_position(char spisok[], char element[], char separator) {
  char * xvost = strstr(spisok, element);
  if (xvost == NULL) return -1;
  uint16_t pos=0;
  uint16_t len_golova = strlen(spisok)-strlen(xvost);
  FOR_i(0,len_golova) if (spisok[i] == separator) pos++;
  return pos;
  
}
//--------------------------------------------------------

void parseUDP()
{
  int32_t packetSize = Udp.parsePacket();

  if (packetSize)
  {
//    int16_t n = Udp.read(packetBuffer, MAX_UDP_BUFFER_SIZE);
//    packetBuffer[n] = '\0';
//    strcpy(inputBuffer, packetBuffer);

    int16_t n = Udp.read(inputBuffer, MAX_UDP_BUFFER_SIZE);
    inputBuffer[n] = '\0';

    if (Udp.remoteIP() == WiFi.localIP()) return;  // не реагировать на свои же пакеты

    IPAddress lamp=Udp.remoteIP();
    char chr_ip_l[16];
    sprintf_P(chr_ip_l, (const char *)F("%u.%u.%u.%u"), lamp[0], lamp[1], lamp[2], lamp[3]);
    //----------------------------------
    if (!strncmp_P(inputBuffer, PSTR("DISCOVER"),8)) {
       Udp.beginPacket(Udp.remoteIP(), Udp.remotePort());
       char send_udp[50];
       sprintf_P(send_udp, (const char *)F(DISCOVER), WiFi.localIP()[0], WiFi.localIP()[1], WiFi.localIP()[2], WiFi.localIP()[3], ESP_UDP_PORT);
       Udp.print(send_udp);
       Udp.endPacket();
       return;
    } 
    //----------------------------------
    if (!strncmp_P(inputBuffer, PSTR("GET"), 3)) {
       reply_GET_UDP();
       return;
    }
    //----------------------------------
//    if (strCommand=="LOAD") module_load();
    //----------------------------------
    module_parsig(255,inputBuffer);
  //--------------------------------------------------------------------         
    FOR_i(0,MAX_IP) if (ip_addr[i].on_off) {
      if (!strcmp(ip_addr[i].ipchr, chr_ip_l)) {
         lamp_status[i].last_input_udp=millis();
         lamp_status[i].online=true;
   //--------------------------------------------------------------------         
   // ответ на DICOVER
         if (!strncmp(inputBuffer, "IP ", 3)) {
            char mask[30]="";
            sprintf_P(mask, (const char *)F("IP %s:%u:"), ip_addr[i].ipchr, ESP_UDP_PORT);
            strcat(mask, "%s");
            sscanf(inputBuffer, mask, lamp_status[i].name);
         } else
   //--------------------------------------------------------------------
   // ответ на GET
         if (!strncmp_P(inputBuffer, PSTR("CURR"),4)) { //      if (getValue(strBuffer,' ',0)=="CURR") { 
            int param_s[6];
                             //        0  1  2  3  4  5 *
                             //  CURR  0 51  0  0  0  0 0 0 0 11:45:00 0
            sscanf(inputBuffer, "CURR %u %u %u %u %u %u ",
                   param_s,  param_s+1,  param_s+2,  param_s+3, param_s+4, param_s+5);
 
            if (lamp_status[i].on_off!=param_s[4]) HUB_Update=true;
 
            lamp_status[i].eff=param_s[0];        // 0
            lamp_status[i].BRI=param_s[1];        // 1
            lamp_status[i].SPD=param_s[2];        // 2
            lamp_status[i].SCA=param_s[3];        // 3 
            lamp_status[i].on_off=param_s[4];     // 4
            lamp_status[i].CLR=param_s[5];        // 5
         }
//--------------------------------------------------------------------         
       }
      if (millis()-lamp_status[i].last_input_udp>60000)
         if (lamp_status[i].online) {
            lamp_status[i].online=false;
            HUB_Update=true;
         }
      if (HUB_Update && hub.focused()) {
         char arg1[10];
         sprintf_P(arg1, (const char *)F("led_on%u"), i);
         hub.update(arg1).value(lamp_status[i].on_off);
         sprintf_P(arg1, (const char *)F("led%u"), i);
         hub.update(arg1).value(lamp_status[i].online);
         HUB_Update=false;
       }

    }
  }
}
  
//----------------------------------
void Get_Name() {
  static uint8_t i=0;
  if (ip_addr[i].on_off)
    if (strlen(lamp_status[i].name)==0)
       send_console(ip_addr[i].ipchr,(char *)F("DISCOVER"));
       
  i++;
  if (i>=MAX_IP) i=0;
}

//----------------------------------
void reply_GET_UDP() {
   Udp.beginPacket(Udp.remoteIP(), Udp.remotePort());
   char send_udp[50];
   uint8_t curr_power=ON_OFF;
   uint8_t curr_bri=0;
   uint8_t curr_eff=0;
   uint8_t curr_clr=0;
   uint8_t curr_spd=0;
   uint8_t curr_sca=0;
    #if defined (PWM_PIN)
      curr_bri=signal_pwm[0];
      curr_power = (curr_bri>0) ? 1:0;
    #endif
    #if defined (RELE_PIN)
      curr_power = rele[0];
    #endif
    #if defined (WS2812_PIN)
      curr_eff = Real_EFF;
      curr_bri=BRI;
      curr_clr=CLR;
      curr_spd=SPD;
      curr_sca=SCA;
    #endif
   sprintf_P(send_udp, (const char *)F("CURR %u %u %u %u %u %u 0 0 0 %u:%u:00 0"), curr_eff, curr_bri, curr_spd, curr_sca, curr_power, curr_clr, hour, minute);
   Udp.printf(send_udp);
   Udp.endPacket();
   module_get();
}

//--------------------------------------------------------
uint32_t bri_100_to_real(uint32_t b100,uint32_t breal) {
  if (b100<25) return b100;
  if (b100>100) return 100;
  return map(b100,25,100,25,breal);
}
void chr_toUpperCase(char c_str[]) {
 FOR_i(0,strlen(c_str)) c_str[i]=toupper(c_str[i]);
}
//----------------------------------
// Перенос String в Char
int32_t chr_to_int(char c_str[]) {
 DEBUGLN("chr_to_int");
 DEBUGLN(c_str);
 
 if (c_str[0]==0) return 0;
 if (!strcmp(c_str, " ")) return 0;
 if (!strcmp(c_str, "+")) return 0;
 if (!strcmp(c_str, "-")) return 0;
 if (!strcmp(c_str, "*")) return 0;
 if (!strcmp(c_str, "/")) return 0;
 if (!strcmp(c_str, "%")) return 0;
 if (!strcmp(c_str, ">")) return 0;
 if (!strcmp(c_str, "<")) return 0;
 if (!strcmp(c_str, "=")) return 0;

 char arg1[CMD_LEN]={0};
 char arg2[CMD_LEN]={0};
 uint8_t c_str_len=strlen(c_str);
// Сложение / Вычитание
 if (strchr(c_str,'+')!=NULL) {
     strncpy(arg1,c_str,strcspn(c_str, "+"));
     strcpy(arg2,strchr(c_str, '+')+1);
     return chr_to_int(arg1)+chr_to_int(arg2);
 }
 if (strchr(c_str,'-')!=NULL) {
     strncpy(arg1,c_str,c_str_len-strlen(strrchr(c_str, '-')));
     strcpy(arg2,strrchr(c_str, '-')+1);
     return chr_to_int(arg1)-chr_to_int(arg2);
 }
// Умножение / деление 
 if (strchr(c_str,'*')!=NULL) {
     strncpy(arg1,c_str,strcspn(c_str, "*"));
     strcpy(arg2,strchr(c_str, '*')+1);
     return chr_to_int(arg1)*chr_to_int(arg2);
 }
 if (strchr(c_str,'/')!=NULL) {
     strncpy(arg1,c_str,c_str_len-strlen(strrchr(c_str, '/')));
     strcpy(arg2,strrchr(c_str, '/')+1);
     return chr_to_int(arg1)/chr_to_int(arg2);
 }
// Сравнение 
 if (strchr(c_str,'>')!=NULL) {
     strncpy(arg1,c_str,strcspn(c_str, ">"));
     strcpy(arg2,strchr(c_str, '>')+1);
     return chr_to_int(arg1)>chr_to_int(arg2);
 }
 if (strchr(c_str,'<')!=NULL) {
     strncpy(arg1,c_str,strcspn(c_str, "<"));
     strcpy(arg2,strchr(c_str, '<')+1);
     return chr_to_int(arg1)<chr_to_int(arg2);
 }
 if (strchr(c_str,'=')!=NULL) {
     strncpy(arg1,c_str,strcspn(c_str, "="));
     strcpy(arg2,strchr(c_str, '=')+1);
     return chr_to_int(arg1)==chr_to_int(arg2);
 }

//***************
//Общие переменные
 chr_toUpperCase(c_str);
 if (!strcmp(c_str, "HH")) return hour;
 if (!strcmp(c_str, "MM")) return minute;
 if (!strcmp(c_str, "DY")) return dayofweek;
 if (!strcmp(c_str, "ON_OFF")) return ON_OFF;
 if (!strcmp(c_str, "DAWN")) return rassvet;
 if (!strcmp(c_str, "BRI")) return BRI;
 if (!strncmp(c_str, "RND",3)) {
  DEBUGLN("---------- RND --------------");
  char rnd1[CMD_LEN]={0};
  char rnd2[CMD_LEN]={0};
  uint8_t arg_rnd=0;
  FOR_i(0,strlen(c_str)) 
     if (c_str[i]==',') arg_rnd++; 
     else {
      char _sym[2]={0};
      _sym[0]=c_str[i];
      if (arg_rnd==1) strncat(rnd1,_sym,1);
      if (arg_rnd==2) strncat(rnd2,_sym,1);
    }  
     DEBUG("arg1:");
     DEBUGLN(rnd1);
     DEBUG("arg2:");
     DEBUGLN(rnd2);
     uint8_t i_rnd1 = atol(rnd1);
     uint8_t i_rnd2 = atol(rnd2);
     if (i_rnd2) return random8(i_rnd1,i_rnd2);
     else random8(i_rnd1);
 }   
//Модульные переменные
#if defined (DHT_PIN)
 if (!strcmp(c_str, "H")) return humidity;
 if (!strcmp(c_str, "T")) return temperature;
#endif
#if defined (WS2812_PIN)
 if (!strcmp(c_str, "EFF")) return Real_EFF;
 if (!strcmp(c_str, "SPD")) return SPD;
 if (!strcmp(c_str, "SCA")) return SCA;
 if (!strcmp(c_str, "CLR")) return CLR;
 if (!strcmp(c_str, "EFFRND")) return random8(MAX_EFF);
#endif
#if defined (DFPlayer)
 if (!strcmp(c_str, "VOL")) return mp3_volume;
#endif
#if defined (SR501_PIN)
 if (!strcmp(c_str, "SR501")) return int(sr501_s);
#endif
#if defined (PWM_PIN)
 if (!strcmp(c_str, "PWM")) return signal_pwm[0]; 
#endif

//****************
 return atol(c_str);
}

//----------------------------------
bool is_time(uint32_t time_from, uint32_t time_to) {
    if (time_from==time_to) 
      return true;
    if (time_from<time_to) 
      return (hour*60+minute>=round(time_from/60)) && (hour*60+minute<round(time_to/60));
    return (hour*60+minute>=round(time_from/60)) || (hour*60+minute<round(time_to/60));
}
//----------------------------------
