#if defined (WS2812_PIN)
#if (WS2812_D==2)  // Матрица

#include <FastLED.h>

#define MIN_WIDTH                 (5U)                          // ширина матрицы
#define MIN_HEIGHT                (5U)                          // высота матрицы
#define MAX_WIDTH                 (25U)                         // ширина матрицы
#define MAX_HEIGHT                (25U)                         // высота матрицы

/*
#define MAX_WIDTH                 (16U)                         // ширина матрицы
#define REG_WIDTH                 "^([5-9]|1[0-6]){1}$"  // Регулярное выражение от 5 до 16
#define MAX_HEIGHT                (16U)                         // высота матрицы
#define REG_HEIGHT                 "^([5-9]|1[0-6]){1}$" // Регулярное выражение от 5 до 16

#define MAX_WIDTH                 (25U)                         // ширина матрицы
#define REG_WIDTH                 "^([5-9]|1[0-9]|2[0-5]){1}$"  // Регулярное выражение от 5 до 25
#define MAX_HEIGHT                (25U)                         // высота матрицы
#define REG_HEIGHT                "^([5-9]|1[0-9]|2[0-5]){1}$"  // Регулярное выражение от 5 до 25

#define MAX_WIDTH                 (32U)                         // ширина матрицы
#define REG_WIDTH                 "^([5-9]|1[0-9]|2[0-9]|3[0-2]){1}$"  // Регулярное выражение от 5 до 32
#define MAX_HEIGHT                (32U)                         // высота матрицы
#define REG_HEIGHT                "^([5-9]|1[0-9]|2[0-9]|3[0-2]){1}$" // Регулярное выражение от 5 до 32
*/
// Значения по умолчанию
uint8_t WIDTH = 16;                                             // ширина матрицы
uint8_t HEIGHT = 16;                                            // высота матрицы

struct {
  uint8_t WIDTH = 16;           // ширина матрицы по умолчанию
  uint8_t HEIGHT = 16;          // высота матрицы по умолчанию
  uint8_t BRI=25;
  uint8_t SPD=128;
  uint8_t SCA=128;
  uint8_t CLR=0;
  uint8_t EOrder = 2;
  uint8_t DAWN_BRIGHT = 200;    // Яркость рассвета
  uint8_t length_rassvet = 10;  // Длительность рассвета 10 минут  
  uint8_t EFF_rassvet = 18;
  bool    flipX  = false;
  bool    flipY  = false;
  bool    rot    = false;   //Повернуть матрицу
  bool    zgz    = true;    //тип матрицы - зигзаг
  GH::Flags lamp = 0;       //кого синхронизировать
} Matrix;
FS_(Matrix);

GH::Color Canvas_Color=gh::Colors::Aqua;
static const uint8_t maxDim = max(MAX_WIDTH, MAX_HEIGHT);

uint16_t x;
uint16_t y;
uint16_t z;

#define MAX_DIMENSION (max(MAX_WIDTH, MAX_HEIGHT))
#if (MAX_WIDTH > MAX_HEIGHT)
uint8_t noise[MAX_WIDTH][MAX_WIDTH];
#else
uint8_t noise[MAX_HEIGHT][MAX_HEIGHT];
#endif

#define NUM_LEDS    MAX_WIDTH*MAX_HEIGHT // Количество светодиодов в матрице

//Список эффетов   (FSTR)  static PROGMEM
char NAME_EFF[] =  "цвет;цветоворот;радуга;камин;хаос;\
облака;лава;плазма;многоцветие;павлин;лес;океан;апельсин;огонь;пламя;литий;лимон;трава;небо;рубидий;калий;зебра;\
дождь;радождь;снег;дражже;цветочек;конфети;мерцание;дожди;звездопад;метель;люмeньep;\
нексус;иcтoчник;одуванчики;рыбки"
#ifdef WS2812_PAINT
";рисунки;рисование"
#endif
;

// 37 - рисование 253 - Рассвет  254 - Off 255 Поможь в навешивании кирлянды
#define MAX_EFF     37 //Количество эффектов. требуется для зацикливания EFF +/-


uint16_t speed = 20;     // speed is set dynamically once we've started up
uint16_t scale = 30;     // scale is set dynamically once we've started up

uint8_t colorLoop = 1;
uint8_t hue, hue2;                                 // постепенный сдвиг оттенка или какой-нибудь другой цикличный счётчик
uint8_t deltaHue, deltaHue2;                       // ещё пара таких же, когда нужно много
uint8_t step;                                      // какой-нибудь счётчик кадров или последовательностей операций
extern const TProgmemRGBPalette16 ZebraColors_p FL_PROGMEM = {CRGB::Black, CRGB::White, CRGB::Black, CRGB::Black, CRGB::Black, CRGB::White, CRGB::Black, CRGB::Black, CRGB::Black, CRGB::White, CRGB::Black, CRGB::Black, CRGB::Black, CRGB::White, CRGB::Black, CRGB::Black}; //* Zebra

extern const TProgmemRGBPalette16 WaterfallColors_p FL_PROGMEM = {CRGB::Black, 0x060707, 0x101110, 0x151717, 0x1C1D22, 0x242A28, 0x363B3A, 0x313634, 0x505552, 0x6B6C70, 0x98A4A1, 0xC1C2C1, 0xCACECF, 0xCDDEDD, 0xDEDFE0, 0xB2BAB9};
extern const TProgmemRGBPalette16 WoodFireColors_p FL_PROGMEM = {CRGB::Black, 0x330e00, 0x661c00, 0x992900, 0xcc3700, CRGB::OrangeRed, 0xff5800, 0xff6b00, 0xff7f00, 0xff9200, CRGB::Orange, 0xffaf00, 0xffb900, 0xffc300, 0xffcd00, CRGB::Gold};             //* Orange
extern const TProgmemRGBPalette16 NormalFire_p FL_PROGMEM = {CRGB::Black, 0x330000, 0x660000, 0x990000, 0xcc0000, CRGB::Red, 0xff0c00, 0xff1800, 0xff2400, 0xff3000, 0xff3c00, 0xff4800, 0xff5400, 0xff6000, 0xff6c00, 0xff7800};                             //* Огонь 
extern const TProgmemRGBPalette16 NormalFire2_p FL_PROGMEM = {CRGB::Black, 0x560000, 0x6b0000, 0x820000, 0x9a0011, CRGB::FireBrick, 0xc22520, 0xd12a1c, 0xe12f17, 0xf0350f, 0xff3c00, 0xff6400, 0xff8300, 0xffa000, 0xffba00, 0xffd400};                      //* Огонь с желтизной 
extern const TProgmemRGBPalette16 LithiumFireColors_p FL_PROGMEM = {CRGB::Black, 0x240707, 0x470e0e, 0x6b1414, 0x8e1b1b, CRGB::FireBrick, 0xc14244, 0xd16166, 0xe08187, 0xf0a0a9, CRGB::Pink, 0xff9ec0, 0xff7bb5, 0xff59a9, 0xff369e, CRGB::DeepPink};        //* Red
extern const TProgmemRGBPalette16 SodiumFireColors_p FL_PROGMEM = {CRGB::Black, 0x332100, 0x664200, 0x996300, 0xcc8400, CRGB::Orange, 0xffaf00, 0xffb900, 0xffc300, 0xffcd00, CRGB::Gold, 0xf8cd06, 0xf0c30d, 0xe9b913, 0xe1af1a, CRGB::Goldenrod};           //* Yellow
extern const TProgmemRGBPalette16 GrassFireColors_p FL_PROGMEM = {CRGB::Black, 0x001a00, 0x003300, 0x004d00, 0x006600, CRGB::Green, 0x239909, 0x45b313, 0x68cc1c, 0x8ae626, CRGB::GreenYellow, 0x94f530, 0x7ceb30, 0x63e131, 0x4bd731, CRGB::LimeGreen};     //* Green
extern const TProgmemRGBPalette16 SkyFireColors_p FL_PROGMEM = {CRGB::Black, 0x000033, 0x000066, 0x000099, 0x0000cc, CRGB::Blue, 0x0026ff, 0x004cff, 0x0073ff, 0x0099ff, CRGB::DeepSkyBlue, 0x1bc2fe, 0x36c5fd, 0x51c8fc, 0x6ccbfb, CRGB::LightSkyBlue};  //* Blue
extern const TProgmemRGBPalette16 RubidiumFireColors_p FL_PROGMEM = {CRGB::Black, 0x0f001a, 0x1e0034, 0x2d004e, 0x3c0068, CRGB::Indigo, CRGB::Indigo, CRGB::Indigo, CRGB::Indigo, CRGB::Indigo, CRGB::Indigo, 0x3c0084, 0x2d0086, 0x1e0087, 0x0f0089, CRGB::DarkBlue};        //* Indigo
extern const TProgmemRGBPalette16 PotassiumFireColors_p FL_PROGMEM = {CRGB::Black, 0x0f001a, 0x1e0034, 0x2d004e, 0x3c0068, CRGB::Indigo, 0x591694, 0x682da6, 0x7643b7, 0x855ac9, CRGB::MediumPurple, 0xa95ecd, 0xbe4bbe, 0xd439b0, 0xe926a1, CRGB::DeepPink}; //* Violet
extern const TProgmemRGBPalette16 FireOceanColors_p FL_PROGMEM ={CRGB::Black, CRGB::DarkBlue, CRGB::MidnightBlue, CRGB::Navy, CRGB::DarkBlue, CRGB::MediumBlue, CRGB::SeaGreen, CRGB::Teal, CRGB::CadetBlue, CRGB::Blue, CRGB::DarkCyan, CRGB::CornflowerBlue, CRGB::Aquamarine, CRGB::SeaGreen, CRGB::Aqua, CRGB::LightSkyBlue};
extern const TProgmemRGBPalette16 FireCloudColors_p FL_PROGMEM ={CRGB::Black, CRGB::DarkBlue, CRGB::DarkBlue, CRGB::DarkBlue, CRGB::DarkBlue, CRGB::DarkBlue, CRGB::DarkBlue, CRGB::DarkBlue, CRGB::Blue, CRGB::DarkBlue, CRGB::SkyBlue, CRGB::SkyBlue, CRGB::LightBlue, CRGB::White, CRGB::LightBlue, CRGB::SkyBlue};


//Раскраски стран
extern const TProgmemRGBPalette16 RBColors_p FL_PROGMEM = {CRGB::Black, CRGB::White, CRGB::Red, CRGB::Red, CRGB::Red, CRGB::Red, CRGB::Red, CRGB::Red, CRGB::Red, CRGB::Red, CRGB::Green, CRGB::Green, CRGB::Green, CRGB::Green, CRGB::Green, CRGB::Green  }; //* РБ
extern const TProgmemRGBPalette16 RUColors_p FL_PROGMEM = {CRGB::Black, CRGB::White, CRGB::White, CRGB::White, CRGB::White, CRGB::White, CRGB::Blue, CRGB::Blue, CRGB::Blue, CRGB::Blue, CRGB::Blue, CRGB::Red, CRGB::Red, CRGB::Red, CRGB::Red, CRGB::Red }; //* РФ

// Набор палитр для эффектов "Сияние" "Дожди"
const TProgmemRGBPalette16 *FullPalettes[] = {
  &NormalFire_p,
  &NormalFire2_p,
  &HeatColors_p,
  &LavaColors_p,
  &WoodFireColors_p,
  &SodiumFireColors_p,
  &ForestColors_p,
  &ForestColors_p,
  &ForestColors_p,
  &GrassFireColors_p,
  &GrassFireColors_p,
  &GrassFireColors_p,
  &OceanColors_p,
  &WaterfallColors_p,
  &SkyFireColors_p,
  &SkyFireColors_p,
  &CloudColors_p,
  &RubidiumFireColors_p,
  &PotassiumFireColors_p,
  &LithiumFireColors_p,
  &RainbowColors_p,
  &RainbowStripeColors_p,
  &PartyColors_p,
  &RBColors_p,
  &RUColors_p
};
// Набор палитр для эффекта "Камин". Для сомпещение с цветом HUE некоторые повторяются
const TProgmemRGBPalette16 *firePalettes[] = {
  &NormalFire2_p,
  &HeatColors_p,
  &WoodFireColors_p,
  &SodiumFireColors_p,
  &GrassFireColors_p,
  &GrassFireColors_p,
  &GrassFireColors_p,
  &GrassFireColors_p,
  &FireOceanColors_p,
  &SkyFireColors_p,
  &SkyFireColors_p,
  &FireCloudColors_p,
  &WaterfallColors_p,
  &RubidiumFireColors_p,
  &PotassiumFireColors_p,
  &LithiumFireColors_p,
  &NormalFire_p,
  &LavaColors_p
};

const TProgmemRGBPalette16 *curPalette = firePalettes[0];

CRGBPalette16 currentPalette(PartyColors_p);

uint8_t Real_EFF = 0;
uint8_t Pre_EFF=0;
uint8_t SPD=128;
uint8_t SCA=128;
uint8_t CLR=0;

uint8_t old_Real_EFF = 0;
uint8_t old_BRI=10;
uint8_t old_SPD=128;
uint8_t old_SCA=128;
uint8_t old_CLR=0;

CRGB leds[NUM_LEDS];  
CRGB ledsbuff[NUM_LEDS];                           // копия массива leds[] целиком

uint8_t CENTER_X_MINOR =  (WIDTH / 2) -  ((WIDTH - 1) & 0x01); // центр матрицы по ИКСУ, сдвинутый в меньшую сторону, если ширина чётная
uint8_t CENTER_Y_MINOR = (HEIGHT / 2) - ((HEIGHT - 1) & 0x01); // центр матрицы по ИГРЕКУ, сдвинутый в меньшую сторону, если высота чётная
uint8_t CENTER_X_MAJOR =   WIDTH / 2  + (WIDTH % 2);           // центр матрицы по ИКСУ, сдвинутый в большую сторону, если ширина чётная
uint8_t CENTER_Y_MAJOR =  HEIGHT / 2  + (HEIGHT % 2);          // центр матрицы по ИГРЕКУ, сдвинутый в большую сторону, если высота чётная
#define NUM_LAYERSMAX 2
uint8_t noise3d[NUM_LAYERSMAX][MAX_WIDTH][MAX_HEIGHT];     // двухслойная маска или хранилище свойств в размер всей матрицы


//--------------------------------------------------------
//Заготовка, если параметры нужны для каждого еффекта отдельно
struct struct_WS2812{
  bool on_off;
//  char cmd[15];
  uint8_t BRI=20;
  uint8_t SPD=128;
  uint8_t SCA=128;
  uint8_t CLR=0;
  bool    FAV=true;
  bool ok=true;
};
//--------------------------------------------------------
void from_Matrix() {
  WIDTH  =  Matrix.WIDTH;
  HEIGHT =  Matrix.HEIGHT;
  BRI    =  Matrix.BRI;
  SPD    =  Matrix.SPD;
  SCA    =  Matrix.SCA;
  CLR    =  Matrix.CLR;
}  
void to_Matrix() {
  Matrix.WIDTH  =  WIDTH;
  Matrix.HEIGHT =  HEIGHT;
  Matrix.BRI    =  BRI;
  Matrix.SPD    =  SPD;
  Matrix.SCA    =  SCA;
  Matrix.CLR    =  CLR;
}  
// Работа с BMP

struct mybgr {
  uint8_t g,r,b;
};
struct struct_BMP {
  uint16_t   bfType        = 0x4d42;
  uint16_t   bfSize;
  uint16_t   bfSize2;
  uint16_t   bfReserved1   =0; 
  uint16_t   bfReserved2   =0; 
  uint16_t   bfOffBits     = 0x36;
  uint16_t   bfOffBits2    = 0;
  uint16_t   bcSize        = 0x28;  //0E
  uint16_t   bcSize2       = 0;
  uint16_t   bcWidth;
  uint16_t   bcWidth2;
  uint16_t   bcHeight;  
  uint16_t   bcHeight2;  
  uint16_t   bcPlanes      = 1;     //1A  
  uint16_t   biBitCount    = 24;
  uint16_t   biCompression = 0;
  uint16_t   biCompression2= 0;
  uint16_t   biSizeImage;          // bcWidth * bcHeight * biBitCount/8
//Дальше нули
  uint64_t   zero0=0;
  uint64_t   zero1=0;

  uint16_t   biClrImportant2=0;
  mybgr      DATA[625];
};

struct_BMP BMP;


void setup_WS2812(){
SPIFFS.mkdir("/Picture");
FS_LOAD(Matrix);
from_Matrix();
FastLED.addLeds<WS2812, WS2812_PIN, COLOR_ORDER>(leds, NUM_LEDS);  // инициализация светодиодов (RGB,BRG - порядок цветов) 
#ifndef CURRENT_VOLT
#define CURRENT_VOLT         (5U)
#endif

#ifdef CURRENT_LIMIT
  if (CURRENT_LIMIT > 0)
  {
    FastLED.setMaxPowerInVoltsAndMilliamps(CURRENT_VOLT, CURRENT_LIMIT);
  }
#endif
CENTER_XY();
  strcat(main_menu, WS2812_MENU);
  strcat(main_menu, ";");
#ifdef WS2812_PAINT
  strcat(main_menu, WS2812_PAINT);
  strcat(main_menu, ";");
#endif
  Canvas_Color.setHSV(Matrix.CLR,Matrix.SCA,255);

}
//--------------------------------------------------------
#define EFFECT_N(x,clp) \
currentPalette=(x);\
colorLoop = (clp);\
fillNoiseLED();\

void loop_mqtt() {
  EVERY_MS(1000) {
  char arg1[CMD_LEN];
  //-------------------------
  if (old_Real_EFF != Real_EFF) { 
    if (hub.focused()) hub.update("EFF").value(Real_EFF); 
    #ifndef GH_NO_MQTT // Отсылка значений на MQTT сервер
    hub.sendGet("EFF", Real_EFF); 
//    hub._sendMQTT("MyDevices/9418bd3b/ID/set/sw_EFF", "{value="+Str ing(Real_EFF)+"}");
    #endif
    old_Real_EFF = Real_EFF; 
    sprintf_P(arg1, (const char *)F("EFF %u\0"), Real_EFF);
    all_parsig(Matrix.lamp,0, arg1);
  }
  //-------------------------
  if (old_BRI != BRI) { 
    if (hub.focused()) hub.update("BRI").value(BRI);
    old_BRI = BRI; 
    #ifndef GH_NO_MQTT // Отсылка значений на MQTT сервер
    hub.sendGet("BRI", BRI); 
    #endif
    sprintf_P(arg1, (const char *)F("BRI %u\0"), BRI);
    all_parsig(Matrix.lamp,0,arg1);
  }
  if (old_SPD != SPD) {
    if (hub.focused()) hub.update("SPD").value(SPD);
    #ifndef GH_NO_MQTT // Отсылка значений на MQTT сервер
    hub.sendGet("SPD", SPD); 
    #endif
    old_SPD = SPD;
    sprintf_P(arg1, (const char *)F("SPD %u\0"), SPD);
    all_parsig(Matrix.lamp,0,arg1);
  }
  if (old_SCA != SCA) {
    if (hub.focused()) hub.update("SCA").value(SCA);
    #ifndef GH_NO_MQTT // Отсылка значений на MQTT сервер
    hub.sendGet("SCA", SCA); 
    #endif
    old_SCA = SCA; 
    sprintf_P(arg1, (const char *)F("SCA %u\0"), SCA);
    all_parsig(Matrix.lamp,0,arg1);
  }
  if (old_CLR != CLR) {
    if (hub.focused()) hub.update("CLR").value(CLR);
    #ifndef GH_NO_MQTT // Отсылка значений на MQTT сервер
    hub.sendGet("CLR", CLR);
    #endif
    old_CLR = CLR;
    sprintf_P(arg1, (const char *)F("CLR %u\0"), CLR);
    all_parsig(Matrix.lamp,0,arg1);
  }
  }
}

void loop_WS2812(){
  FS_TICK(Matrix);

  EVERY_MS(map(SPD,0,255,240,5))
  if (rassvet) Rassvet(); else {
  if (ON_OFF) {
  FastLED.setBrightness(BRI*2.55);  //BRI_100
  switch (Real_EFF) {
    case 0: LEDS.showColor(CHSV(CLR,SCA,255));  break; // Цвет
    case 1: LEDS.showColor(CHSV(hue++,SCA,255));break; // Цветоворот
    case 2: effect_rainbow();                   break; // Радуга
    case 3: fire2020Routine2();                 break; // Камин
// ---------------Noise 
    case 4: NoiseRoutine();                     break; // Хаос
    case 5: EFFECT_N(CloudColors_p,0)           break; // Oблaкa
    case 6: EFFECT_N(LavaColors_p,0)            break; // Лaвa 
    case 7: EFFECT_N(PartyColors_p,1)           break; // Плазма 
    case 8: EFFECT_N(RainbowColors_p,1)         break; // Многоцветие
    case 9: EFFECT_N(RainbowStripeColors_p,1)   break; // Пaвлин
    case 10: EFFECT_N(ForestColors_p,0)         break; // Лес
    case 11: EFFECT_N(OceanColors_p,0)          break; // Океан
    case 12: EFFECT_N(WoodFireColors_p,0)       break; // Апельсин
    case 13: EFFECT_N(NormalFire_p,0)           break; // Огонь
    case 14: EFFECT_N(NormalFire2_p,0)          break; // Пламя
    case 15: EFFECT_N(LithiumFireColors_p,0)    break; // Литий
    case 16: EFFECT_N(SodiumFireColors_p,0)     break; // Лимон
    case 17: EFFECT_N(GrassFireColors_p,0)      break; // Трава
    case 18: EFFECT_N(SkyFireColors_p,0)        break; // Небо
    case 19: EFFECT_N(RubidiumFireColors_p,0)   break; // Рубидий
    case 20: EFFECT_N(PotassiumFireColors_p,0)  break; // Калий
    case 21: EFFECT_N(ZebraColors_p,0)          break; // Зебра
// -----------------------    
    case 22: RainRoutine(0);                    break; // Дождь
    case 23: RainRoutine(1);                    break; // Радождь
    case 24: RainRoutine(2);                    break; // Снег
    case 25: sandRoutine();                     break; // Дражже
    case 26: FlowerRuta();                      break; // Цветочек
    case 27: sparklesRoutine();                 break; // Конфети
    case 28: twinklesRoutine();                 break; // Мерцание
    case 29: RainRoutine(3);                    break; // Дожди (через палитру)
    case 30: stormRoutine(3);                   break; // Звездопад (через палитру)
    case 31: stormRoutine(2);                   break; // Метель
    case 32: lumenjerRoutine();                 break; // Люмeньep
    case 33: nexusRoutine();                    break; // Нексус
    case 34: starfield2Routine();               break; // Иcтoчник
    case 35: Dandelions();                      break; // Одуванчики
    case 36: ballsRoutine();                    break; // Goldfish
#ifdef WS2812_PAINT
    // Последняя команда
    case 37: ShowBMP("/Picture/");              break; // Рисунки
    case 38: FastLED.show();                    break; // Рисование
#endif
    // Разные служебные
    case 254: ON_OFF=false;Real_EFF=0;          break; // Эффект-выключение 
    case 255:Help_255();                        break;
    default:Real_EFF=0;
    }
    Pre_EFF=Real_EFF;
    } else {
    LEDS.showColor(CRGB(0,0,0));
    rassvet=0;
    if (Real_EFF>MAX_EFF) Real_EFF=0;
  }
  }
  //  hub.update("sw_EFF").value(ON_OFF);
  loop_mqtt();

}
//--------------------------------------------------------
void Help_255(){
      FOR_i(0,NUM_LEDS) leds[i]=0;
      FOR_i(0,WIDTH) {
       drawPixelXY(i, 0, CRGB::Red);
       drawPixelXY(i, HEIGHT/2, CRGB::Blue);
       drawPixelXY(i, HEIGHT-1, CRGB::Green);
      }
      FastLED.show();
}
//--------------------------------------------------------
void parsing_WS2812(char act_chr[]){
    old_Real_EFF = Real_EFF;
    old_BRI = BRI;
    old_SPD = SPD;
    old_SCA = SCA;
    old_CLR = CLR;
    DEBUGLN("parsing_WS2812");
    DEBUGLN(act_chr);
    bool Old_ON_OFF=ON_OFF;
    uint16_t intParam=chr_to_int(char_parsung[1].act);
    int8_t split_eff=split_position(NAME_EFF, char_parsung[0].act, ';');  //(FSTR)
    if (split_eff>=0) {
         Real_EFF = split_eff;
         ON_OFF = true;
         HUB_Update=true;
         if (char_parsung[1].len) BRI=chr_to_int(char_parsung[1].act);
         if (char_parsung[2].len) SPD=chr_to_int(char_parsung[2].act);
         if (char_parsung[3].len) SCA=chr_to_int(char_parsung[3].act);
         if (char_parsung[4].len) CLR=chr_to_int(char_parsung[4].act);
         goto metka_end;
       }
    if (!strncmp_P(char_parsung[0].act, PSTR("P_ON"),  4)) { ON_OFF = true; HUB_Update=true; goto metka_end;}
    if (!strncmp_P(char_parsung[0].act, PSTR("P_OFF"), 5)) { ON_OFF = false; rassvet=0; HUB_Update=true; goto metka_end;}
    if (!strncmp_P(char_parsung[0].act, PSTR("ON_OFF"),6) ||
        !strncmp_P(char_parsung[0].act, PSTR("SW"),    2) ||
        !strncmp_P(char_parsung[0].act, PSTR("P_SW"),  4)) { ON_OFF = !ON_OFF; rassvet=0; HUB_Update=true; goto metka_end;}
    if (!strcmp_P(char_parsung[0].act, PSTR("DAWN")) ||
       !strcmp_P(char_parsung[0].act, PSTR("Рассвет"))) {
      if (!strncmp_P(char_parsung[1].act, PSTR("OFF"), 3)) rassvet=0;
      else rassvet=1; 
      if (rassvet) { ON_OFF = true; BRI=Matrix.DAWN_BRIGHT; }
      goto metka_end;
    }

    if (!strncmp_P(char_parsung[0].act, PSTR("BRI"),  3)) {
      if (!strncmp_P(char_parsung[1].act, PSTR("+"),  1)) (BRI<100) ? BRI++ : 100 ; else 
      if (!strncmp_P(char_parsung[1].act, PSTR("-"),  1)) (BRI>0) ? BRI-- : 0 ; else
      BRI = intParam; 
      if (BRI) ON_OFF = true;
      HUB_Update=true;
      goto metka_end;
    }

    if (!strncmp_P(char_parsung[0].act, PSTR("SPD"),  3)) {
      if (!strncmp_P(char_parsung[1].act, PSTR("+"),  1)) (SPD<255) ? SPD++ : 255 ; else
      if (!strncmp_P(char_parsung[1].act, PSTR("-"),  1)) (SPD>0) ? SPD-- : 0 ; else
      SPD = intParam; 
      HUB_Update=true;
      goto metka_end;
    }
    
    if (!strncmp_P(char_parsung[0].act, PSTR("CLR"),  3)) {
      if (!strncmp_P(char_parsung[1].act, PSTR("+"),  1)) CLR++; else
      if (!strncmp_P(char_parsung[1].act, PSTR("-"),  1)) CLR--; else
      CLR = intParam; 
      HUB_Update=true;
      goto metka_end;
    }
    
    if (!strncmp_P(char_parsung[0].act, PSTR("SCA"),  3)) {
      if (!strncmp_P(char_parsung[1].act, PSTR("+"),  1)) SCA++; else
      if (!strncmp_P(char_parsung[1].act, PSTR("-"),  1)) SCA--; else
      SCA = intParam; 
      HUB_Update=true;
      goto metka_end;
    }

    if (!strncmp_P(char_parsung[0].act, PSTR("EFF"),  3) ||
        !strncmp_P(char_parsung[0].act, PSTR("SET"),  3)) {
      if (!strncmp_P(char_parsung[1].act, PSTR("+"),  1)) Real_EFF = (Real_EFF+1) % MAX_EFF; else
      if (!strncmp_P(char_parsung[1].act, PSTR("-"),  1)) Real_EFF = (MAX_EFF+Real_EFF-1) % MAX_EFF; else
      Real_EFF = intParam; 
      ON_OFF = true;
      if (char_parsung[2].len) BRI=chr_to_int(char_parsung[2].act);
      if (char_parsung[3].len) SPD=chr_to_int(char_parsung[3].act);
      if (char_parsung[4].len) SCA=chr_to_int(char_parsung[4].act);
      if (char_parsung[5].len) CLR=chr_to_int(char_parsung[5].act);
      HUB_Update=true;
      goto metka_end;
    }

//-------------------------------    
metka_end:

    if (BRI==0) ON_OFF = false; 
    to_Matrix();
    if (Old_ON_OFF!=ON_OFF) {
//       char send_udp[25];
//       sprintf_P(send_udp, (const char *)F("WS2812 IS %s"), (ON_OFF) ? "ON":"OFF");
//       module_parsig(255,send_udp);
       #ifndef GH_NO_MQTT // Отсылка значений на MQTT сервер
       hub.sendGet("sw_EFF",ON_OFF);
       #endif
       if (hub.focused()) hub.update("sw_EFF").value(ON_OFF);
    }
}
//--------------------------------------------------------
void get_WS2812() {
  char send_udp[25];
  Udp.beginPacket(Udp.remoteIP(), Udp.remotePort());
  sprintf_P(send_udp, (const char *)F("WS2812 IS %s"), (ON_OFF) ? "ON":"OFF");
  Udp.print(send_udp);
  Udp.endPacket();
}  
//--------------------------------------------------------
void Color_from_mqtt() {
      eeprom_flag=true;
      RgbToHsv(Canvas_Color.r,Canvas_Color.g,Canvas_Color.b, Matrix.CLR, Matrix.SCA);
      if (hub.focused()) {
        hub.update("CLR").value(Matrix.CLR);
        hub.update("SCA").value(Matrix.SCA);
      }
    #ifndef GH_NO_MQTT // Отсылка значений на MQTT сервер
      hub.sendGet("Color",Canvas_Color.getHEX());
    #endif
    #ifdef COLOR_NOISE_EFFECT
      if ((Real_EFF>4) && (Real_EFF<21)) Real_EFF = 4;
    #endif
}
//--------------------------------------------------------
void HUB_module_pult_WS2812(gh::Builder& b) {
//  Canvas_Color.setHSV(Matrix.CLR,Matrix.SCA,255);
  b.beginRow();  
    if (b.Select_("EFF",&Real_EFF).text(NAME_EFF).size(3).label(F("Эффект")).click()) {
      ON_OFF=true;
      if (hub.focused()) hub.sendUpdate("sw_EFF", ON_OFF);
    }
    if (b.Switch_("sw_EFF",&ON_OFF).label(F("Включить")).size(1).click()) {
      if (!ON_OFF) rassvet=0;
      char arg1[10];
      sprintf_P(arg1, (const char *)F("{value=%d}"), ON_OFF);
//      hub.sendGet("sw_EFF", "{value="+Str ing(ON_OFF)+"}"); 
      hub.sendGet("sw_EFF", arg1); 
    }
  b.endRow(); 
  b.beginRow();  
  eeprom_flag |= b.Slider_("BRI",&Matrix.BRI).label(F("Яркость")).range(0, 100, 1).size(3).click(); // BRI_100
  if (b.Color_(F("Color"),&Canvas_Color).size(1).click()) 
     if (Canvas_Color.getHEX()>0) Color_from_mqtt();
  b.endRow(); 
  b.beginRow();  
  eeprom_flag |= b.Slider_("SPD",&Matrix.SPD).label(F("Скорость")).range(0, 255, 1).click();
  eeprom_flag |= b.Slider_("SCA",&Matrix.SCA).label(F("Масштаб / Насыщенность цвета")).range(0, 255, 1).click();
  b.endRow(); 
   if (eeprom_flag) {
      FS_UPDATE(Matrix);
      from_Matrix();
      eeprom_flag=false;
   }
}
//--------------------------------------------------------
#ifdef WS2812_PAINT
#ifdef ESP32
String List_Folder(String folder) {
    String FilesBMP="";
    File root = SPIFFS.open(folder);
    File file = root.openNextFile();
    while(file) {
        if (FilesBMP>"") FilesBMP+=";";
        FilesBMP+=file.name();
        file = root.openNextFile();
    }
  return FilesBMP;
}
#endif

#ifdef ESP8266
String List_Folder(String folder) {
    String FilesBMP="";
    Dir root = SPIFFS.openDir(folder);
    while(root.next()) {
        if (FilesBMP>"") FilesBMP+=";";
        FilesBMP+=root.fileName();
    }
  return FilesBMP;
}
#endif
//--------------------------------------------------------
//void File2BMP(Str ing fn) {
void File2BMP(char fn[]) {   
   File FileBMP = SPIFFS.open(fn,"r");
   uint32_t fsize=min(FileBMP.size(),MAX_WIDTH*MAX_HEIGHT*3+54);
   if (FileBMP.read((uint8_t*)&BMP,fsize)) { 
         FOR_i(0,WIDTH)
          FOR_j(0,HEIGHT) 
          if (i+j*BMP.bcHeight < MAX_WIDTH*MAX_HEIGHT)
          {
           leds[XY(WIDTH-i-1,j)].r = BMP.DATA[i+j*BMP.bcHeight].r;
           leds[XY(WIDTH-i-1,j)].g = BMP.DATA[i+j*BMP.bcHeight].g;
           leds[XY(WIDTH-i-1,j)].b = BMP.DATA[i+j*BMP.bcHeight].b;
         }
         FileBMP.close();
   }      
}

void PathFile2BMP(char cpath[], char * fn) {   
  char arg1[50];
  strcpy(arg1,cpath);
  strcat(arg1,fn);
  DEBUGLN(arg1);
  File2BMP(arg1);
}
//--------------------------------------------------------
void Leds2HUB() {
      gh::CanvasUpdate cv3("cv3", &hub);
      FOR_i(0,Matrix.WIDTH) {
        FOR_j(0,Matrix.HEIGHT) {
            cv3.fill(getPixColorXY(i,j));
            cv3.circle((Matrix.WIDTH-i-1)*10+5,(Matrix.HEIGHT-j-1)*10+5, 5);
        }   
      }
      cv3.send();
}
//--------------------------------------------------------
void HUB_module_paint_WS2812(gh::Builder& b) {
  HUB_module_pult_WS2812(b);
  gh::Pos pos3;
  String FilesBMP=List_Folder("/Picture/");
  static uint8_t FileBMP;
  b.beginRow();  
  #ifdef GYVERHUB_DEV
        b.Canvas_(F("cv3"), Matrix.WIDTH*10, Matrix.HEIGHT*10, &pos3);
  #else
        b.Canvas_(F("cv3"), Matrix.WIDTH*10, Matrix.HEIGHT*10, nullptr, &pos3);
  #endif      
        // был клик
        if (pos3.changed()) {
            x=round(pos3.x/10);
            y=round(pos3.y/10);
            drawPixelXY(Matrix.WIDTH-x-1, Matrix.HEIGHT-y-1, CRGB(Canvas_Color.r,Canvas_Color.g,Canvas_Color.b)); 
            DEBUGLN("Color "+String(uint32_t(CRGB(Canvas_Color.r,Canvas_Color.g,Canvas_Color.b)),HEX));
            // рисуем кружок
            gh::CanvasUpdate cv3("cv3", &hub);
            cv3.fill(Canvas_Color);
            cv3.circle(x*10+5, y*10+5, 5);
            cv3.send();
        }
  
  b.endRow(); 
//  b.beginRow();b.endRow(); // Пропуск для удобства
  b.Select_("BMP",&FileBMP).text(FilesBMP).size(2).label(F("Список файлов"));
  b.beginRow();  
//    if (b.Color_(F("Color"),&Canvas_Color).size(2).click()) Color_from_mqtt();
   
    if (b.Button(0).size(1).color(CRGB::Yellow).label(F("Снимок")).icon("").click()) Leds2HUB();//f3fa
    if (b.Button(0).size(1).color(CRGB::Brown).label(F("Очистить")).icon("").click()) {//f51a || f46a
      FOR_i(0,NUM_LEDS) leds[i]=0;
      gh::CanvasUpdate cv3("cv3", &hub);
      cv3.fill(0);
      FOR_i(0,Matrix.WIDTH) 
        FOR_j(0,Matrix.HEIGHT) 
            cv3.circle((Matrix.WIDTH-i-1)*10+5,(Matrix.HEIGHT-j-1)*10+5, 5);
      cv3.send();
      }
    if (b.Button(0).size(1).color(CRGB::Blue).label(F("Создать")).icon("").click()) { // f477
         String fn = String(timeClient.getEpochTime());
         FOR_i(0,WIDTH)
          FOR_j(0,HEIGHT) {
            BMP.DATA[i+j*HEIGHT].r=leds[XY(WIDTH-i-1,j)].r;
            BMP.DATA[i+j*HEIGHT].g=leds[XY(WIDTH-i-1,j)].g;
            BMP.DATA[i+j*HEIGHT].b=leds[XY(WIDTH-i-1,j)].b;
         }
         BMP.bfType        = 0x4d42;
         BMP.bfSize        = 54+WIDTH*HEIGHT*3;
         BMP.bfSize2       = 0;
         BMP.bfReserved1    = 0;
         BMP.bfReserved2    = 0;
         BMP.bfOffBits     = 0x36;
         BMP.bcSize        = 0x28;  //0E
         BMP.bcWidth       = WIDTH;
         BMP.bcWidth2      = 0;
         BMP.bcHeight      = HEIGHT;
         BMP.bcHeight2     = 0;
         BMP.bcPlanes      = 1;
         BMP.biBitCount    = 24;
         BMP.biCompression = 0;
         BMP.biCompression2= 0;
         BMP.biSizeImage   = WIDTH*HEIGHT*3;
         BMP.zero0         = 0;
         BMP.zero1         = 0;
         BMP.biClrImportant2=0;

         File FileBMP = SPIFFS.open("/Picture/" + fn + ".bmp","w");
         FileBMP.write((uint8_t*)&BMP,BMP.bfSize);
         FileBMP.close();
         
         FilesBMP=List_Folder("/Picture/");
         if (hub.focused()) hub.update("BMP").text(FilesBMP);
    }

   
    if (b.Button(0).size(1).color(CRGB::Green).label(F("Прочитать")).icon("").click()) { //f574
      String fn=getValue(FilesBMP,';',FileBMP);

      char arg1[20];
      strcpy(arg1,fn.c_str());
//      sprintf_P(arg1, (const char *)F("/Picture/%s"), fn);
      PathFile2BMP("/Picture/",arg1);
      Leds2HUB();
    }
    if (b.Button(0).size(1).color(CRGB::Red).label(F("Удалить")).icon("").click()) { //f1c3
      String fn=getValue(FilesBMP,';',FileBMP);
      DEBUGLN("Delete "+fn);
      int rez = SPIFFS.remove("/Picture/" + fn);
      DEBUGLN("Delete "+String(rez));
      FilesBMP=List_Folder("/Picture/");
      if (hub.focused()) hub.update("BMP").text(FilesBMP);
    }
    
  b.endRow(); 
  
}
#endif
//--------------------------------------------------------
void HUB_module_WS2812(gh::Builder& b) {
//  String st_tab="0";
  char arg1[34];
  static uint8_t tab = 0;
  eeprom_flag=false;
  HUB_module_pult_WS2812(b);
  if (b.Slider_("CLR",&Matrix.CLR).label(F("Цвет")).range(0, 255, 1).click()) {
    eeprom_flag=true;
    Canvas_Color.setHue(Matrix.CLR);
    hub.sendGet("Color",Canvas_Color.getHEX());
    if (hub.focused()) hub.sendUpdate("Color", Canvas_Color.getHEX());
  }

// Параметры настройки
  b.Display(F("Настрока гирлянды")).label(F("Проверка цвета, размера, помощь в развешивании")).fontSize(16).rows(1);
  b.beginRow();  
    
    sprintf_P(arg1, (const char *)F("Ширина от %u  до %u"), MIN_WIDTH, MAX_WIDTH );
    eeprom_flag |= b.Input(&Matrix.WIDTH ).label(arg1).click();
    sprintf_P(arg1, (const char *)F("Высота от %u  до %u"), MIN_HEIGHT, MAX_HEIGHT);
    eeprom_flag |= b.Input(&Matrix.HEIGHT).label(arg1).click();
/*
    eeprom_flag |= b.Input(&Matrix.WIDTH ).label(F("Ширина от 5 до 25")).regex(F(REG_WIDTH )).click();
    eeprom_flag |= b.Input(&Matrix.HEIGHT).label(F("Высота от 5 до 25")).regex(F(REG_HEIGHT)).click();
MIN_WIDTH 
MIN_HEIGHT
MAX_WIDTH 
MAX_HEIGHT
*/
  b.endRow(); 
  b.beginRow();  
    eeprom_flag |= b.Switch(&Matrix.flipX).label(F("Flip X")).click(); 
    eeprom_flag |= b.Switch(&Matrix.flipY).label(F("Flip Y")).click(); 
    eeprom_flag |= b.Switch(&Matrix.rot).label(F("Повернуть")).click(); 
    eeprom_flag |= b.Switch(&Matrix.zgz).label(F("Зигзаг")).click(); 
  b.endRow();
  b.beginRow();  
    if (b.Button(0).size(1).color(gh::Colors::Green).label(F("Зеленый")).click()) {Real_EFF=0;CLR=80;SCA=255; ON_OFF=!ON_OFF; hub.sendGet("sw_EFF",ON_OFF);}
    if (b.Button(0).size(1).color(gh::Colors::Red).label(F("Красный")).click()) {Real_EFF=0;CLR=0;SCA=255; ON_OFF=!ON_OFF; hub.sendGet("sw_EFF",ON_OFF);}
    if (b.Button(0).size(1).color(gh::Colors::Blue).label(F("Синий")).click()) {Real_EFF=0;CLR=160;SCA=255; ON_OFF=!ON_OFF; hub.sendGet("sw_EFF",ON_OFF);}
    if (b.Button(0).size(1).color(CRGB::Black).label(F("Подсказка")).click()) {Real_EFF=255; ON_OFF=!ON_OFF;  hub.sendGet("sw_EFF",ON_OFF);}
  b.endRow(); 
  b.Display(F("Настрока будильника Рассвет.\nЗапуск командой \"Рассвет\" в модуль " WS2812_MENU)).label(F("Настрока будильника Рассвет")).fontSize(16).rows(3);
  b.beginRow();  
   eeprom_flag |= b.Slider(&Matrix.DAWN_BRIGHT).label(F("Яркость рассвета. ")).range(0, 100, 1).click();  //BRI_100
   eeprom_flag |= b.Slider(&Matrix.length_rassvet).label(F("Длительность рассвета (минут)")).range(1, 30, 1).click();
   eeprom_flag |= b.Select(&Matrix.EFF_rassvet).text(NAME_EFF).label(F("Эффект после рассвета")).click(); //.size(2)
  b.endRow();
   eeprom_flag |= b.Flags(&Matrix.lamp).text(str_GHflags_IP).label(F("Устройства IP для синхронизации")).click();

//  Matrix.DAWN_BRIGHT  uint8_t length_rassvet = 10; // 10 минут

  
   if (eeprom_flag) {
      if (Matrix.WIDTH  > MAX_WIDTH ) Matrix.WIDTH  = MAX_WIDTH;
      if (Matrix.HEIGHT > MAX_HEIGHT) Matrix.HEIGHT = MAX_HEIGHT;
      if (Matrix.WIDTH  < MIN_WIDTH ) Matrix.WIDTH  = MIN_WIDTH;
      if (Matrix.HEIGHT < MIN_HEIGHT) Matrix.HEIGHT = MIN_HEIGHT;
      FS_UPDATE(Matrix);
      from_Matrix();
      CENTER_XY();
      eeprom_flag=false;
   }
   
}
//--------------------------------------------------------
// Эффекты
// Переменные эффектов
uint8_t deltaValue;                                // просто повторно используемая переменная
float   speedfactor;                               // регулятор скорости в эффектах реального времени
#define enlargedOBJECT_MAX_COUNT   (MAX_WIDTH * 2) // максимальное количество сложных отслеживаемых объектов (меньше, чем trackingOBJECT_MAX_COUNT)
uint8_t enlargedObjectNUM;                         // используемое в эффекте количество объектов
#define trackingOBJECT_MAX_COUNT           (100U)   // максимальное количество отслеживаемых объектов (очень влияет на расход памяти)
float   trackingObjectPosX[trackingOBJECT_MAX_COUNT];
float   trackingObjectPosY[trackingOBJECT_MAX_COUNT];
float   trackingObjectSpeedX[trackingOBJECT_MAX_COUNT];
float   trackingObjectSpeedY[trackingOBJECT_MAX_COUNT];
float   trackingObjectShift[trackingOBJECT_MAX_COUNT];
uint8_t trackingObjectHue[trackingOBJECT_MAX_COUNT];
uint8_t trackingObjectState[trackingOBJECT_MAX_COUNT];
bool    trackingObjectIsShift[trackingOBJECT_MAX_COUNT];
#define SQRT_VARIANT sqrt3                         // выбор основной функции для вычисления квадратного корня sqrtf или sqrt3 для ускорения

//--------------------------------------------------------
// Будильник Рассвет
#define DAWN_STEP     6  
void Rassvet() {
 static CHSV dawnColor[DAWN_STEP] = {CHSV(0, 0, 0)};
 uint8_t dawnCounter = rassvet-1;
 if (rassvet==1) {
  FastLED.setBrightness(255);
  FOR_i(0,DAWN_STEP) dawnColor[i] = CHSV(0, 0, 0);
  delay(10);
  Real_EFF=Matrix.EFF_rassvet;
  BRI=Matrix.DAWN_BRIGHT;
}
 uint32_t step_rassvet=uint32_t(60000/255*Matrix.length_rassvet);
 EVERY_MS(step_rassvet) {
  uint8_t dawnPosition = rassvet++;
  
  for (uint16_t i = DAWN_STEP-1; i > 0; i--) dawnColor[i] = dawnColor[i-1];
  dawnColor[0] = CHSV(map(dawnPosition, 0, 255, 10, 35),
                   map(dawnPosition, 0, 255, 255, 170),
                   map(dawnPosition, 0, 255, 0, Matrix.DAWN_BRIGHT*2.55)); //BRI_100
  for (uint16_t i = 0U; i < WIDTH*HEIGHT; i++) leds[i] = dawnColor[i % DAWN_STEP];
 }
  FastLED.show();
 
}
// ============= Эффекты Noise в массиве палитр ===============
void NoiseRoutine() {
  SetPallete();
  currentPalette = *curPalette;
  colorLoop = SCA % 2;
  fillNoiseLED();
}
//--------------------------------------------------------
// Радуга по кругу
void rainbowHorVertRoutine(bool isVertical) {
  for (uint8_t i = 0U; i < (isVertical ? WIDTH : HEIGHT); i++) {
    CHSV thisColor = CHSV((uint8_t)(hue + i * (SCA % 86U)/2), 255U, 255U);

    for (uint8_t j = 0U; j < (isVertical ? HEIGHT : WIDTH); j++)
      leds[XY(isVertical ? i : j, isVertical ? j : i)] = thisColor;
  }
}

void effect_rainbow() {
  hue += 4U;
  if (SCA < 86U)           
    rainbowHorVertRoutine(true);
  else if (SCA > 172U)      
    rainbowHorVertRoutine(false);
  else                                          // для масштабов посередине
    for (uint8_t i = 0U; i < WIDTH; i++)
      for (uint8_t j = 0U; j < HEIGHT; j++)
      {
        float twirlFactor = 9.0F * ((SCA - 86) / 400.0F);    // на сколько оборотов будет закручена матрица, [0..3]

      CRGB thisColor = CHSV((uint8_t)(hue + ((float)WIDTH / (float)HEIGHT * i + j * twirlFactor) * ((float)255 / (float)maxDim)), 255U, 255U);
        
        leds[XY(i, j)] = thisColor;
      }
   FastLED.show();
}
#ifdef WS2812_PAINT
// ------------- Просмотр картинок BMP --------------
void ShowBMP(char pathBMP[]) {
  static uint8_t FileBMP=0;
  
//  { EVERY_MS(SQRT_VARIANT(256U-SPD)*31) { // Вращение
  { EVERY_MS(SQRT_VARIANT(256U-SPD)*15) { // Вращение
    FOR_j(0,HEIGHT)
     {
       uint32_t temp=getPixColorXY(0,j);
       FOR_i(0,WIDTH-1) drawPixelXY(i, j, getPixColorXY(i+1, j));
       drawPixelXY(WIDTH-1,j,temp);
     }
  }}
  { EVERY_MS(SQRT_VARIANT(256U-SPD)*512) {
//     pathBMP="/"+pathBMP+"/";
//     pathBMP.replace("//","/");
     String FilesBMP=List_Folder(String(pathBMP));
     String fn=getValue(FilesBMP,';',FileBMP);
     char arg1[20];
     strcpy(arg1,fn.c_str());
     PathFile2BMP(pathBMP, arg1);
//     Leds2HUB();
     FileBMP++;
     if (getValue(FilesBMP,';',FileBMP)=="") FileBMP=0;
  }}
   FastLED.show();
}
#endif
// ------------- Nexus --------------
// (c) kostyamat
// https://github.com/DmytroKorniienko/FireLamp_JeeUI/blob/master/src/effects.cpp
// Адаптировано Shaitan
void nexusReset(uint8_t i) {
  trackingObjectHue[i] = random8();
  trackingObjectState[i] = random8(4);
  trackingObjectSpeedX[i] = (float)random8(5, 11) / 70 + speedfactor; // делаем частицам немного разное ускорение и сразу пересчитываем под общую скорость
  switch (trackingObjectState[i]) {
    case B01:
      trackingObjectPosY[i] = HEIGHT;
      trackingObjectPosX[i] = random8(WIDTH);
      break;
    case B00:
      trackingObjectPosY[i] = -1;
      trackingObjectPosX[i] = random8(WIDTH);
      break;
    case B10:
      trackingObjectPosX[i] = WIDTH;
      trackingObjectPosY[i] = random8(HEIGHT);
      break;
    case B11:
      trackingObjectPosX[i] = -1;
      trackingObjectPosY[i] = random8(HEIGHT);
      break;
  }
}

void nexusRoutine() {
  enlargedObjectNUM = (float)SCA / 800.0 * (enlargedOBJECT_MAX_COUNT - 1U) + 1U;
  if (enlargedObjectNUM > trackingOBJECT_MAX_COUNT) enlargedObjectNUM = trackingOBJECT_MAX_COUNT;
//  speedfactor = fmap(SPD, 1, 255, 0.1, .33);//(float)SPD / 555.0f + 0.001f;
   speedfactor=0.33;
  if (Pre_EFF!=Real_EFF)
  {
    for (uint8_t i = 0; i < enlargedOBJECT_MAX_COUNT; i++) {
      trackingObjectPosX[i] = random8(WIDTH);
      trackingObjectPosY[i] = random8(HEIGHT);
      trackingObjectSpeedX[i] = (float)random8(5, 11) / 70 + speedfactor; // делаем частицам немного разное ускорение и сразу пересчитываем под общую скорость
      trackingObjectHue[i] = random8();
      trackingObjectState[i] = random8(4);
      //     B00           // задаем направление
      // B10     B11
      //     B01
    }
    deltaValue = 255U - map(SPD, 1, 255, 11, 33);
  }

  nscale8(leds, NUM_LEDS, deltaValue);

  for (uint8_t i = 0; i < enlargedObjectNUM; i++) {
    switch (trackingObjectState[i]) {
      case B01:
        trackingObjectPosY[i] -= trackingObjectSpeedX[i];
        if (trackingObjectPosY[i] <= -1)
          nexusReset(i);
        break;
      case B00:
        trackingObjectPosY[i] += trackingObjectSpeedX[i];
        if (trackingObjectPosY[i] >= HEIGHT)
          nexusReset(i);
        break;
      case B10:
        trackingObjectPosX[i] -= trackingObjectSpeedX[i];
        if (trackingObjectPosX[i] <= -1)
          nexusReset(i);
        break;
      case B11:
        trackingObjectPosX[i] += trackingObjectSpeedX[i];
        if (trackingObjectPosX[i] >= WIDTH)
          nexusReset(i);
        break;
    }
    drawPixelXYF(trackingObjectPosX[i], trackingObjectPosY[i],  CHSV(trackingObjectHue[i], 255U, 255));
  }
   FastLED.show();
}

// ============= Огонь 2020 ===============
// (c) SottNick Переработано Shaitan
#define SPARKLES_NUM  (WIDTH / 8U) // не более чем  enlargedOBJECT_MAX_COUNT (WIDTH * 2)
uint8_t shiftHue[MAX_HEIGHT];
uint16_t ff_x, ff_y, ff_z;                         // большие счётчики
//-----------------------------------------
void fire2020Routine2() {
  uint8_t deltaValue;
  
  deltaValue=map(CLR,0,255,0,sizeof(firePalettes)/sizeof(TProgmemRGBPalette16 *)-1);
  curPalette = firePalettes[deltaValue];
  
  deltaValue = (((SCA - 1U) % 11U + 1U) << 4U) - 8U; // ширина языков пламени (масштаб шума Перлина)
  deltaHue = map(deltaValue, 8U, 168U, 8U, 84U); // высота языков пламени должна уменьшаться не так быстро, как ширина
  step = map(255U - deltaValue, 87U, 247U, 4U, 32U); // вероятность смещения искорки по оси ИКС
  for (uint8_t j = 0; j < HEIGHT; j++) {
    shiftHue[j] = (HEIGHT - 1 - j) * 255 / (HEIGHT - 1); // init colorfade table
  }
  for (uint8_t i = 0; i < SPARKLES_NUM; i++) {
    trackingObjectPosY[i] = random8(HEIGHT);
    trackingObjectPosX[i] = random8(WIDTH);
  }
  for (uint8_t i = 0; i < WIDTH; i++) {
    for (uint8_t j = 0; j < HEIGHT; j++) {
      nblend(leds[XY(i, HEIGHT - 1U - j)], ColorFromPalette(*curPalette, qsub8(inoise8(i * deltaValue, (j + ff_y + random8(2)) * deltaHue, ff_z), shiftHue[j]), 255U), 160U);
    }
  }

  for (uint8_t i = 0; i < SPARKLES_NUM; i++) {
    if (trackingObjectPosY[i] > 3U) {
      leds[XY(trackingObjectPosX[i], trackingObjectPosY[i])] = leds[XY(trackingObjectPosX[i], 3U)];
      leds[XY(trackingObjectPosX[i], trackingObjectPosY[i])].fadeToBlackBy( trackingObjectPosY[i] * 2U );
    }
    trackingObjectPosY[i]++;
    if (trackingObjectPosY[i] >= HEIGHT) {
      trackingObjectPosY[i] = random8(4U);
      trackingObjectPosX[i] = random8(WIDTH);
    }
    if (!random8(step))
      trackingObjectPosX[i] = (WIDTH + (uint8_t)trackingObjectPosX[i] + 1U - random8(3U)) % WIDTH;
  }
  ff_y++;
  if (ff_y & 0x01)
    ff_z++;
  FastLED.show();
}
// ============= ЭФФЕКТ ДОЖДЬ ===============
// (c) @Shaitan
void RainRoutine(uint8_t eff_mode)
{
  SetPallete();
  FOR_i(0,WIDTH)
  {
    // заполняем случайно верхнюю строку
  CRGB thisColor;
    if (!getPixColorXY(wrapX(i), HEIGHT - 1U))
    {
      if (random8(0, 80-SCA/4) == 0U)
      {
        switch (eff_mode) {
           case 0: thisColor = CHSV(CLR + random(0, 16), 255, 255); break;// Цветной дождь
           case 1: thisColor = CHSV(random(0, 9) * 28, 255U, 255U); break;// Радужный дождь
           case 2: thisColor = 0xE0FFFF - 0x101010 * random(0, 4); break;// Снег
           case 3: thisColor = ColorFromPalette(*curPalette, random8(), 255);break; //Дожди
        }
        drawPixelXY(i, HEIGHT - 1U, thisColor); 
      }
    }
    else
      leds[XY(i, HEIGHT - 1U)] -= CHSV(0, 0, random(96, 128));
  }
  // сдвигаем всё вниз
  FOR_i(0,WIDTH) FOR_j(0,HEIGHT-1) drawPixelXY(i, j, getPixColorXY(i, j + 1U));
  FastLED.show();
}

// ============= Эффект Цветные драже ===============
// (c) SottNick
//по мотивам визуала эффекта by Yaroslaw Turbin 14.12.2020
//https://vk.com/ldirko программный код которого он запретил брать

void sandRoutine() {
  static uint8_t pcnt;                                      // какой-то счётчик какого-то прогресса
  // если насыпалось уже достаточно, бахаем рандомные песчинки
  uint8_t temp = map8(random8(), SCA, 255U);
  if (pcnt >= map8(temp, 2U, HEIGHT - 3U)) {
    temp = HEIGHT + 1U - pcnt;
    if (!random8(4U)) // иногда песка осыпается до половины разом
      if (random8(2U))
        temp = 2U;
      else
        temp = 3U;
    for (uint8_t y = 0; y < pcnt; y++)
      for (uint8_t x = 0; x < WIDTH; x++)
        if (!random8(temp))
          leds[XY(x, y)] = 0;
  }

  pcnt = 0U;
  // осыпаем всё, что есть на экране
  for (uint8_t y = 1; y < HEIGHT; y++)
    for (uint8_t x = 0; x < WIDTH; x++)
      if (leds[XY(x, y)])                                                          // проверяем для каждой песчинки
        if (!leds[XY(x, y - 1)]) {                                                 // если под нами пусто, просто падаем
          leds[XY(x, y - 1)] = leds[XY(x, y)];
          leds[XY(x, y)] = 0;
        }
        else if (x > 0U && !leds[XY(x - 1, y - 1)] && x < WIDTH - 1 && !leds[XY(x + 1, y - 1)]) { // если под нами пик
          if (random8(2U))
            leds[XY(x - 1, y - 1)] = leds[XY(x, y)];
          else
            leds[XY(x - 1, y - 1)] = leds[XY(x, y)];
          leds[XY(x, y)] = 0;
          pcnt = y - 1;
        }
        else if (x > 0U && !leds[XY(x - 1, y - 1)]) {                              // если под нами склон налево
          leds[XY(x - 1, y - 1)] = leds[XY(x, y)];
          leds[XY(x, y)] = 0;
          pcnt = y - 1;
        }
        else if (x < WIDTH - 1 && !leds[XY(x + 1, y - 1)]) {                       // если под нами склон направо
          leds[XY(x + 1, y - 1)] = leds[XY(x, y)];
          leds[XY(x, y)] = 0;
          pcnt = y - 1;
        }
        else                                                                       // если под нами плато
          pcnt = y;

  // эмиттер новых песчинок
  if (!leds[XY(CENTER_X_MINOR, HEIGHT - 2)] && !leds[XY(CENTER_X_MAJOR, HEIGHT - 2)] && !random8(3)) {
    temp = random8(2) ? CENTER_X_MINOR : CENTER_X_MAJOR;
    leds[XY(temp, HEIGHT - 1)] = CHSV(random8(), 255U, 255U);
  }
  FastLED.show();
}

// =====================================
//            Flower Ruta
//    © Stepko and © Sutaburosu
//     Adaptation © SlingMaster
//             22/05/22
// =====================================
/* --------------------------------- */
void FlowerRuta() {
  static uint8_t PETALS;
  static uint32_t t;
  PETALS = map(SCA, 1, 255, 2U, 8U);
  
    for (int8_t x = -CENTER_X_MAJOR; x < CENTER_X_MAJOR; x++)
      for (int8_t y = -CENTER_Y_MAJOR; y < CENTER_Y_MAJOR; y++) {
        noise3d[0][x + CENTER_X_MAJOR][y + CENTER_Y_MAJOR] = (atan2(x, y) / PI) * 128 + 127; // thanks ldirko
        noise3d[1][x + CENTER_X_MAJOR][y + CENTER_Y_MAJOR] = hypot(x, y);                    // thanks Sutaburosu
      }
  t++;
  for (uint8_t x = 0; x < WIDTH; x++) {
    for (uint8_t y = 0; y < HEIGHT; y++) {
      byte angle = noise3d[0][x][y];
      byte radius = noise3d[1][x][y];
      leds[XY(x, y)] = CHSV(t + radius * (255 / WIDTH), 255, sin8(sin8(t + angle * PETALS + ( radius * (255 / WIDTH))) + t * 4 + sin8(t * 4 - radius * (255 / WIDTH)) + angle * PETALS));
    }
  }
  FastLED.show();
}
// ------------- конфетти --------------
#define FADE_OUT_SPEED        (70U)                         // скорость затухания
void sparklesRoutine() {
  if (Pre_EFF!=Real_EFF) {
    FOR_i(0,NUM_LEDS) 
      if (random8(5)==0) {
        leds[i]=CHSV(random8(), 255U, random8(0,55));
      }
      else leds[i] = 0U;
    DEBUGLN("Start конфети");  
  }  
   
  for (uint8_t i = 0; i < SCA; i++)
  {
    uint8_t x = random8(WIDTH);
    uint8_t y = random8(HEIGHT);
    if (getPixColorXY(x, y) == 0U)
    {
      if (random8(5)==0) 
        leds[XY(x, y)] = CHSV(random8(), 255U, random8(150,255));
    }
  }
  dimAll(256U - FADE_OUT_SPEED);
  FastLED.show();
}
// ------------------------------ ЭФФЕКТ МЕРЦАНИЕ ----------------------
// (c) SottNick

#define MAX_twink 100
#define TWINKLES_SPEEDS 5     // скорость мерцания
struct {
  uint8_t x;
  uint8_t y;
  uint8_t col;
  uint8_t bri;
  int8_t dir;
} twink[MAX_twink];


void twinklesRoutine() {
  SetPallete();
  uint8_t deltaValue = (SCA / 20);  // вероятность пикселя загореться от 1/1 до 1/11
  uint8_t col_twink=map(SCA,0,255,1,MAX_twink);
  dimAll(240);
  FOR_i(0,col_twink)
    if (twink[i].bri == 0) {
      if (random8(5)==0) {
        uint8_t le_x=random8(WIDTH);
        uint8_t le_y=random8(HEIGHT);
        if (getPixColorXY(le_x,le_y)==0) {
          twink[i].x=le_x;
          twink[i].y=le_y;
          twink[i].bri = 1;
          twink[i].col=random8();
          twink[i].dir = random8(TWINKLES_SPEEDS)+5;
        }
      }
    } else {
    if (twink[i].dir>0) {
        if (255-twink[i].bri > twink[i].dir+20) twink[i].bri+=(twink[i].dir+20);
        else twink[i].dir=-twink[i].dir;
      } else {
        if (twink[i].bri > -twink[i].dir) twink[i].bri+=twink[i].dir;
        else twink[i].bri=0;
      }
    }

  FOR_i(0,col_twink)
      leds[XY(twink[i].x,twink[i].y)] = ColorFromPalette(*curPalette, twink[i].col, twink[i].bri);

  FastLED.show();
}
// ============= ЭФФЕКТ ИСТОЧНИК ===============
// (c) SottNick
// выглядит как https://github.com/fuse314/arduino-particle-sys/blob/master/examples/StarfieldFastLED/StarfieldFastLED.ino

void starfield2Emit(uint8_t i) {
  if (hue++ & 0x01) hue2++;

  trackingObjectPosX[i] = WIDTH * 0.5;//CENTER_X_MINOR;// * RENDERER_RESOLUTION; //  particle->x = source->x;
  trackingObjectPosY[i] = HEIGHT * 0.5;//CENTER_Y_MINOR;// * RENDERER_RESOLUTION; //  // particle->y = source->y;
  trackingObjectSpeedX[i] = ((float)random8() - 127.) / 512.; // random(_hVar)-_constVel; // particle->vx
  trackingObjectSpeedY[i] = SQRT_VARIANT(0.0626 - trackingObjectSpeedX[i] * trackingObjectSpeedX[i]); // SQRT_VARIANT(pow(_constVel,2)-pow(trackingObjectSpeedX[i],2)); // particle->vy зависит от particle->vx - не ошибка
  if (random8(2U)) trackingObjectSpeedY[i] = -trackingObjectSpeedY[i];
  trackingObjectState[i] = random8(50, 250); // random8(minLife, maxLife);// particle->ttl
  if (SPD & 0x01) trackingObjectHue[i] = hue2;// (counter/2)%255; // particle->hue
  else trackingObjectHue[i] = random8();
  trackingObjectIsShift[i] = true; // particle->isAlive
}

void starfield2Routine() {
  enlargedObjectNUM = (float) SCA / 255 * (trackingOBJECT_MAX_COUNT - 1U) + 1U;
  if (enlargedObjectNUM > trackingOBJECT_MAX_COUNT) enlargedObjectNUM = trackingOBJECT_MAX_COUNT;
  deltaValue = enlargedObjectNUM / (SQRT_VARIANT(CENTER_X_MAJOR * CENTER_X_MAJOR + CENTER_Y_MAJOR * CENTER_Y_MAJOR) * 4U) + 1U; // 4 - это потому что за 1 цикл частица пролетает ровно четверть расстояния между 2мя соседними пикселями
/*  if (Pre_EFF!=Real_EFF)
  {
    for (int i = 0; i < trackingOBJECT_MAX_COUNT; i++) trackingObjectIsShift[i] = false; 
  }
*/  
  step = deltaValue; //счётчик количества частиц в очереди на зарождение в этом цикле
  dimAll(127);
  //go over particles and update matrix cells on the way
  for (int i = 0; i < enlargedObjectNUM; i++) {
    if (!trackingObjectIsShift[i] && step) {
      starfield2Emit(i);
      step--;
    }
    if (trackingObjectIsShift[i]) { // particle->isAlive
      particlesUpdate2(i);

      //generate RGB values for particle
      CRGB baseRGB = CHSV(trackingObjectHue[i], 255, 255); // particles[i].hue

      //baseRGB.fadeToBlackBy(255-trackingObjectState[i]);
      baseRGB.nscale8(trackingObjectState[i]);//эквивалент
      drawPixelXYF(trackingObjectPosX[i], trackingObjectPosY[i], baseRGB);
    }
  }
  FastLED.show();
}

//-----------------------------------------------
// ------------- Звездопад -------------

void stormRoutine(uint8_t eff_mode) {
  SetPallete();
  FOR_i(0,WIDTH)
  {
    // заполняем случайно верхнюю строку
  CRGB thisColor = CHSV(CLR + random(0, 16), 255, 255); // Цветной дождь
    if (!getPixColorXY(wrapX(i), HEIGHT - 1U) &&
        !getPixColorXY(wrapX(i + 1U), HEIGHT - 1U) &&
        !getPixColorXY(wrapX(i - 1U), HEIGHT - 1U)) {
      if (random8(0, 80-SCA/4) == 0U)
      {
        if (eff_mode==1) thisColor = CHSV(random(0, 9) * 28, 255U, 255U); // Радужный дождь
        if (eff_mode==2) thisColor = 0xE0FFFF - 0x101010 * random(0, 4); // Снег
        if (eff_mode==3) thisColor = ColorFromPalette(*curPalette, random8(), 255);
        drawPixelXY(i, HEIGHT - 1U, thisColor); 
      }
    }
    else
      leds[XY(i, HEIGHT - 1U)] -= CHSV(0, 0, random(96, 128));
  }
  
  // сдвигаем по диагонали
  for (uint8_t y = 0U; y < HEIGHT - 1U; y++)
  {
    for (uint8_t x = 0; x < WIDTH; x++)
    {
      drawPixelXY(wrapX(x + 1U), y, getPixColorXY(x, y + 1U));
    }
  }

  // уменьшаем яркость верхней линии, формируем "хвосты"
  FOR_i(0,WIDTH) leds[XY(i, HEIGHT - 1U)] -= CHSV(0, 0, random(96, 128));    
  FastLED.show();
}

// =============== Эффект Lumenjer ================
// по мотивам (c) SottNick
#define MAX_DIAG 5
struct struct_dxdy{
  uint8_t x = random8(WIDTH);
  uint8_t y = random8(HEIGHT);
  int8_t dx = random(2)*2-1;
  int8_t dy = random(2)*2-1;
};
struct_dxdy dxdy[MAX_DIAG];

void lumenjerRoutine() {
  
  int16_t DIMSPEED = 254U - 1500U / WIDTH / HEIGHT;
  static uint8_t step;
  dimAll(DIMSPEED);
  SetPallete();
  FOR_i(0,MAX_DIAG) {
    dxdy[i].dx = random8(3) ? dxdy[i].dx : -dxdy[i].dx;
    dxdy[i].dy = random8(3) ? dxdy[i].dy : -dxdy[i].dy;
    if (WIDTH % 2 == 0 && HEIGHT % 2 == 0)
       dxdy[i].x = (WIDTH + dxdy[i].x + dxdy[i].dx * (bool)random8(64)) % WIDTH;
    else
       dxdy[i].x = (WIDTH + dxdy[i].x + dxdy[i].dx) % WIDTH;
    dxdy[i].y = (HEIGHT + dxdy[i].y + dxdy[i].dy) % HEIGHT;
    leds[XY(dxdy[i].x, dxdy[i].y)] += ColorFromPalette(*curPalette, i*SCA+step);
  }
  step++;
  FastLED.show();
}

// =====================================
//     Multicolored Dandelions
//      Base Code © Less Lam
//          © SlingMaster
//       Разноцветные одуванчики
// https://editor.soulmatelights.com/gallery/2007-amber-rain
// =====================================
class Circle {
  public:
    float thickness = 3.0;
//    long startTime;
    uint16_t offset;
    int16_t centerX;
    int16_t centerY;
    int hue;
    int bpm = 10;

    void move() {
      centerX = random(2, WIDTH-2);
      centerY = random(2, HEIGHT-2);
    }

    void scroll() {
      centerX--; // = random(0, WIDTH);
      if (centerX < 1) {
        centerX = WIDTH - 1;
      }
      centerY++;
      if (centerY > HEIGHT) {
        centerY = 0;
      }
    }
    void reset() {
//      startTime = millis();
      centerX = random(2, WIDTH-2);
      centerY = random(2, HEIGHT-2);
      hue = random(0, 255);
      offset = random(0, 60000 / bpm);
    }

    float radius() {
      float radius = beatsin16(SCA/2.55, 0, 500, offset) / 100.0;
      return radius;
    }
};

// -----------------------------------
namespace Circles {
#define NUMBER_OF_CIRCLES 6
Circle circles[NUMBER_OF_CIRCLES] = {};

void drawCircle(Circle circle) {
  int16_t centerX = circle.centerX;
  int16_t centerY = circle.centerY;
  int hue = circle.hue;
  float radius = circle.radius();

  int16_t startX = centerX - ceil(radius);
  int16_t endX = centerX + ceil(radius);
  int16_t startY = centerY - ceil(radius);
  int16_t endY = centerY + ceil(radius);

  for (int16_t x = startX; x < endX; x++) {
    for (int16_t y = startY; y < endY; y++) {
      int16_t index = XY(x, y);
      if (index < 0 || index > NUM_LEDS)
        continue;
      double distance = sqrt(sq(x - centerX) + sq(y - centerY));
      if (distance > radius)
        continue;

      uint16_t brightness;
      if (radius < 1) { // last pixel
        // brightness = 0; //255.0 * radius;
        deltaValue = 20;
        brightness = 180;
        // brightness = 0;
      } else {
        deltaValue = 200; // 155 + modes[currentMode].Scale;
        double percentage = distance / radius;
        double fraction = 1.0 - percentage;
        brightness = 255.0 * fraction;
      }
      leds[index] += CHSV(hue, deltaValue, brightness);
    }
  }
}

// -----------------------------
void draw(bool setup) {
  fadeToBlackBy(leds, NUM_LEDS, 100U);
  // fillAll(CRGB::Black);
//  for (int i = 0; i < map(SCA,0,255,0,NUMBER_OF_CIRCLES); i++) {
  for (int i = 0; i < NUMBER_OF_CIRCLES; i++) {
    if (setup) {
      circles[i].reset();
    } else {
      if (circles[i].radius() < 0.5) {
        circles[i].scroll();
      }
    }
    drawCircle(circles[i]);
  }
}
}; // namespace Circles

// ==============
void Dandelions() {
  if (Pre_EFF!=Real_EFF) {
    FastLED.clear();
    Circles::draw(true);
    deltaValue = 155 + SCA;
  }
  Circles::draw(false);
  FastLED.show();
}

// --------------------------- Золотые рыбки ---------------------
// Goldfish
#define BALLS_AMOUNT_MAX      (10U)                         // максимальное ное количество рыбок
#define TRACK_STEP            (70U)                         // длина хвоста шарика (чем больше цифра, тем хвост короче)
int16_t coord[BALLS_AMOUNT_MAX][2U];
int8_t vector[BALLS_AMOUNT_MAX][2U];
CRGB ballColors[BALLS_AMOUNT_MAX];

void ballsRoutine() 
{
  uint8_t BALLS_AMOUNT = map(SCA,0,255,1,BALLS_AMOUNT_MAX);
  if (Pre_EFF!=Real_EFF) 
  {
    for (uint8_t j = 0U; j < BALLS_AMOUNT; j++)
    {
      int8_t sign;
      // забиваем случайными данными
      coord[j][0U] = WIDTH / 2 * 10;
      random(0, 2) ? sign = 1 : sign = -1;
      vector[j][0U] = random(4, 15) * sign;
      coord[j][1U] = HEIGHT / 2 * 10;
      random(0, 2) ? sign = 1 : sign = -1;
      vector[j][1U] = random(4, 15) * sign;
      //ballColors[j] = CHSV(random(0, 9) * 28, 255U, 255U);
      // цвет зависит от масштаба
      ballColors[j] = CHSV((SCA * (j + 1)) % 256U, 255U, 255U);
    }
  }

  dimAll(256U - TRACK_STEP);

  // движение шариков
  for (uint8_t j = 0U; j < BALLS_AMOUNT; j++)
  {
    // движение шариков
    for (uint8_t i = 0U; i < 2U; i++)
    {
      coord[j][i] += vector[j][i];
      if (coord[j][i] < 0)
      {
        coord[j][i] = 0;
        vector[j][i] = -vector[j][i];
      }
    }

    if (coord[j][0U] > (int16_t)((WIDTH - 1) * 10))
    {
      coord[j][0U] = (WIDTH - 1) * 10;
      vector[j][0U] = -vector[j][0U];
    }
    if (coord[j][1U] > (int16_t)((HEIGHT - 1) * 10))
    {
      coord[j][1U] = (HEIGHT - 1) * 10;
      vector[j][1U] = -vector[j][1U];
    }
    //leds[XY(coord[j][0U] / 10, coord[j][1U] / 10)] =  ballColors[j];
    drawPixelXYF(coord[j][0U] / 10., coord[j][1U] / 10., ballColors[j]);
  }
  FastLED.show();
}

//--------------------------------------------------------
// ************* СЛУЖЕБНЫЕ *************
//--------------------------------------------------------
// Утилиты для эффектов
//--------------------------------------------------------
void CENTER_XY() {
  CENTER_X_MINOR =  (WIDTH / 2) -  ((WIDTH - 1) & 0x01); // центр матрицы по ИКСУ, сдвинутый в меньшую сторону, если ширина чётная
  CENTER_Y_MINOR = (HEIGHT / 2) - ((HEIGHT - 1) & 0x01); // центр матрицы по ИГРЕКУ, сдвинутый в меньшую сторону, если высота чётная
  CENTER_X_MAJOR =   WIDTH / 2  + (WIDTH % 2);           // центр матрицы по ИКСУ, сдвинутый в большую сторону, если ширина чётная
  CENTER_Y_MAJOR =  HEIGHT / 2  + (HEIGHT % 2);          // центр матрицы по ИГРЕКУ, сдвинутый в большую сторону, если высота чётная
}
void SaluteFadeAll(uint8_t val)
{ 
  FOR_i(0,NUM_LEDS) leds[i]-=CHSV(0,0,val);
}
//--------------------------------------------------------

void drawPixelXY(int8_t x, int8_t y, CRGB clr)
{
  if (x < 0 || x > (WIDTH - 1) || y < 0 || y > (HEIGHT - 1)) return;
  leds[XY(x, y)] = clr;
}

//--------------------------
uint16_t XY(uint8_t px, uint8_t py)
{
  uint8_t x=px;
  uint8_t y=py;
  if (Matrix.flipX) x=WIDTH-x-1;
  if (Matrix.flipY) y=HEIGHT-y-1;
  if (Matrix.rot) {
   if ((Matrix.zgz) && (y & 0x01))
      return (y * WIDTH + WIDTH - x - 1); 
   else                                                  
     return (y * WIDTH + x);
  } else {
   if ((Matrix.zgz) && (x & 0x01))
      return (x * HEIGHT + HEIGHT - y - 1); 
   else                                                  
      return (x * HEIGHT + y);
  }   
}

//--------------------------

void fillNoiseLED()
{
  uint8_t dataSmoothing = 0;
  if (speed < 50)
  {
    dataSmoothing = 200 - (speed * 4);
  }
  for (uint8_t i = 0; i < MAX_DIMENSION; i++)
  {
    int32_t ioffset = scale * i;
    for (uint8_t j = 0; j < MAX_DIMENSION; j++)
    {
      int32_t joffset = scale * j;

      uint8_t data = inoise8(x + ioffset, y + joffset, z);

      data = qsub8(data, 16);
      data = qadd8(data, scale8(data, 39));

      if (dataSmoothing)
      {
        uint8_t olddata = noise[i][j];
        uint8_t newdata = scale8( olddata, dataSmoothing) + scale8( data, 256 - dataSmoothing);
        data = newdata;
      }

      noise[i][j] = data;
    }
  }
  z += speed;

  // apply slow drift to X and Y, just for visual variation.
  x += speed / 8;
  y -= speed / 16;

  for (uint8_t i = 0; i < WIDTH; i++)
  {
    for (uint8_t j = 0; j < HEIGHT; j++)
    {
      uint8_t index = noise[j][i];
      uint8_t bri =   noise[i][j];
      // if this palette is a 'loop', add a slowly-changing base value
      if ( colorLoop)
      {
        index += hue;
      }
      // brighten up, as the color palette itself often contains the
      // light/dark dynamic range desired
      if ( bri > 127 )
      {
        bri = 255;
      }
      else
      {
        bri = dim8_raw( bri * 2);
      }
    CRGB color = ColorFromPalette( currentPalette, index, bri);      
      
//      drawPixelXY(i, j, color);                             //leds[getPixelNumber(i, j)] = color;
       if (!(i < 0 || i > (WIDTH - 1) || j < 0 || j > (HEIGHT - 1))) 
         leds[XY(i, j)] = color;

    }
  }
  hue += 1;
  FastLED.show();
}

void fillnoise8()
{
  for (uint8_t i = 0; i < MAX_DIMENSION; i++)
  {
    int32_t ioffset = scale * i;
    for (uint8_t j = 0; j < MAX_DIMENSION; j++)
    {
      int32_t joffset = scale * j;
      noise[i][j] = inoise8(x + ioffset, y + joffset, z);
    }
  }
  z += speed;
//  z ++; 
}
//--------------------------------
uint32_t getPixColorXY(uint8_t x, uint8_t y)
{
  return getPixColor(XY(x, y));
}
//--------------------------------
uint32_t getPixColor(uint32_t thisPixel)
{
  if (thisPixel > NUM_LEDS - 1) return 0;
  return (((uint32_t)leds[thisPixel].r << 16) | ((uint32_t)leds[thisPixel].g << 8 ) | (uint32_t)leds[thisPixel].b); // а почему не просто return (leds[thisPixel])?
//  return leds[thisPixel];
}

//--------------------------------
void SetPallete() { 
  uint8_t deltaValue=map(CLR,0,255,0,sizeof(FullPalettes)/sizeof(TProgmemRGBPalette16 *)-1);
  curPalette = FullPalettes[deltaValue];
}  
//--------------------------------
uint8_t wrapX(int8_t x) {
  return (x + WIDTH) % WIDTH;
}
//--------------------------------
uint8_t wrapY(int8_t y) {
  return (y + HEIGHT) % HEIGHT;
}

//--------------------------------
void RgbToHsv(uint8_t red, uint8_t green, uint8_t blue, uint8_t& hue, uint8_t& saturation)
{
  float f_hue;
  float f_saturation;
  auto rd = static_cast<float>(red) / 255;
  auto gd = static_cast<float>(green) / 255;
  auto bd = static_cast<float>(blue) / 255;
  auto color_max = max(rd, max(gd, bd)), color_min = min(rd, min(gd, bd));
   
//  value = int(max*255);

  auto d = color_max - color_min;
  saturation = color_max == 0 ? 0 : int(d / color_max * 255);

  f_hue = 0;
  if (color_max != color_min)
  {
    if (color_max == rd)
    {
      f_hue = (gd - bd) / d + (gd < bd ? 6 : 0);
    }
    else if (color_max == gd)
    {
      f_hue = (bd - rd) / d + 2;
    }
    else if (color_max == bd)
    {
      f_hue = (rd - gd) / d + 4;
    }
    f_hue /= 6;
  }
  hue=int(f_hue*255);
}
//----------------
float fmap(const float x, const float in_min, const float in_max, const float out_min, const float out_max) {
  return (out_max - out_min) * (x - in_min) / (in_max - in_min) + out_min;
}
//----------------
void drawPixelXYF(float x, float y, CRGB color) //, uint8_t darklevel = 0U)
{
  //  if (x<0 || y<0) return; //не похоже, чтобы отрицательные значения хоть как-нибудь учитывались тут // зато с этой строчкой пропадает нижний ряд
  // extract the fractional parts and derive their inverses
  uint8_t xx = (x - (int)x) * 255, yy = (y - (int)y) * 255, ix = 255 - xx, iy = 255 - yy;
  // calculate the intensities for each affected pixel
#define WU_WEIGHT(a,b) ((uint8_t) (((a)*(b)+(a)+(b))>>8))
  uint8_t wu[4] = {WU_WEIGHT(ix, iy), WU_WEIGHT(xx, iy),
                   WU_WEIGHT(ix, yy), WU_WEIGHT(xx, yy)
                  };
  // multiply the intensities by the colour, and saturating-add them to the pixels
  for (uint8_t i = 0; i < 4; i++) {
    int16_t xn = x + (i & 1), yn = y + ((i >> 1) & 1);
    CRGB clr = getPixColorXY(xn, yn);
    clr.r = qadd8(clr.r, (color.r * wu[i]) >> 8);
    clr.g = qadd8(clr.g, (color.g * wu[i]) >> 8);
    clr.b = qadd8(clr.b, (color.b * wu[i]) >> 8);
    //if (darklevel) drawPixelXY(xn, yn, makeDarker(clr, darklevel));
    //else
    drawPixelXY(xn, yn, clr);
  }
}

//--------------------------------
void dimAll(uint8_t value) {
  nscale8(leds, NUM_LEDS, value);
}
//--------------------------------
// неточный, зато более быстрый квадратный корень
float sqrt3(const float x)
{
  union
  {
    int i;
    float x;
  } u;

  u.x = x;
  u.i = (1<<29) + (u.i >> 1) - (1<<22);
  return u.x;
}
//----------------------
void particlesUpdate2(uint8_t i) {
  trackingObjectState[i]--; 
  trackingObjectPosX[i] += trackingObjectSpeedX[i];
  trackingObjectPosY[i] += trackingObjectSpeedY[i];
  if (trackingObjectState[i] == 0 || trackingObjectPosX[i] <= -1 || trackingObjectPosX[i] >= WIDTH || trackingObjectPosY[i] <= -1 || trackingObjectPosY[i] >= HEIGHT)
    trackingObjectIsShift[i] = false;
}

// -------------------------
void DrawLine(int x1, int y1, int x2, int y2, CRGB color)
{
  int deltaX = abs(x2 - x1);
  int deltaY = abs(y2 - y1);
  int signX = x1 < x2 ? 1 : -1;
  int signY = y1 < y2 ? 1 : -1;
  int error = deltaX - deltaY;

  drawPixelXY(x2, y2, color);
  while (x1 != x2 || y1 != y2) {
    drawPixelXY(x1, y1, color);
    int error2 = error * 2;
    if (error2 > -deltaY) {
      error -= deltaY;
      x1 += signX;
    }
    if (error2 < deltaX) {
      error += deltaX;
      y1 += signY;
    }
  }
}

#endif
#endif
