#if defined (SR501_PIN)

//--------------------------------------------------------
struct struct_sr501{
  bool on_off;
  bool alarm;
  bool repeat;
  char cmd_on[CMD_LEN];       // Посылаемая команда при сработке
  char cmd_on_rep[CMD_LEN];   // Посылаемая команда во время сработки
  char cmd_off[CMD_LEN];      // Посылаемая команда после сработки
  char cmd_off_rep[CMD_LEN];  // Посылаемая команда во время пассива
  uint32_t time_from=0;
  uint32_t time_to=0;
  GH::Flags week=255;
  GH::Flags lamp=0;
  GH::Flags modul=0;
  GH::Flags timers=0;
  bool ok_on=true;
  bool ok_off=true;
};
struct_sr501 sr501[MAX_SR501];
FS_(sr501);

bool sr501_s;
bool old_sr501_s;
//--------------------------------------------------------
void setup_SR501(){
  pinMode(SR501_PIN,INPUT);     
  FS_LOAD(sr501); 
  strcat(main_menu, SR501_MENU);
  strcat(main_menu, ";");
}
//--------------------------------------------------------
void get_SR501() {
    char send_udp[25];
    Udp.beginPacket(Udp.remoteIP(), Udp.remotePort());
    sprintf_P(send_udp, (const char *)F("SR501 IS %s"), (sr501_s) ? "ON":"OFF");
    Udp.print(send_udp);
    Udp.endPacket();
}  
//--------------------------------------------------------
void SR501_send(uint8_t i, char cmd[]) {
  all_parsig(sr501[i].lamp,sr501[i].modul,cmd);
}
//--------------------------------------------------------
void loop_SR501(){
  EVERY_MS(1000) {
  old_sr501_s=sr501_s;
  sr501_s=digitalRead(SR501_PIN);
  FS_TICK(sr501); 
  FOR_i(0,MAX_SR501)
   if (sr501[i].on_off) 
     if (sr501[i].week.get(dayofweek)) {
          if (is_time(sr501[i].time_from,sr501[i].time_to)) {
             if (sr501_s) {
               if (sr501[i].ok_on) if (strlen(sr501[i].cmd_on)) { SR501_send(i,sr501[i].cmd_on); sr501[i].ok_on=false;}
               if (strlen(sr501[i].cmd_on_rep)) SR501_send(i,sr501[i].cmd_on_rep);
               sr501[i].ok_off=true;
             } else {
               if (sr501[i].ok_off) if (strlen(sr501[i].cmd_off)) { SR501_send(i,sr501[i].cmd_off); sr501[i].ok_off=false;}
               if (strlen(sr501[i].cmd_off_rep)) SR501_send(i,sr501[i].cmd_off_rep);
               sr501[i].ok_on=true;
             }
          } else {
             sr501[i].ok_on=true;
             sr501[i].ok_off=true;
          }
     }
  if (sr501_s!=old_sr501_s) {
  #ifndef GH_NO_MQTT // Отсылка значений на MQTT сервер
    if (sr501_s) hub.sendGet("led", true);
    else hub.sendGet("led", false);
  #endif
    if (hub.focused()) hub.update("led").value(sr501_s);  // обновляем светодиод датчика движения sr501
    }
  } //1000 мс
 old_sr501_s=sr501_s;
}
//--------------------------------------------------------
void HUB_module_SR501(gh::Builder& b) {
  static uint8_t plus_minus[MAX_SR501];
  static uint8_t tab = 0;
  b.LED_(F("led"), &sr501_s).label(F("Датчик движения"));
  char arg1[15];
  FOR(tab,0,MAX_SR501) {
     b.beginRow();  
      eeprom_flag |= b.Time(&sr501[tab].time_from).label(F("От")).size(2).color(sr501[tab].on_off ?  gh::Colors::Green : gh::Colors::Yellow).click();
      eeprom_flag |= b.Time(&sr501[tab].time_to).label(F("До")).size(2).color(sr501[tab].on_off ?  gh::Colors::Green : gh::Colors::Yellow).click();
      if (b.Tabs(&plus_minus[tab]).text(F("- ; +")).size(1).click()) b.refresh();
     b.endRow();  
    if (plus_minus[tab]) {
      eeprom_flag |= b.Flags(&sr501[tab].week).text(str_dayofweek).label(F("Дни недели")).click();
      {
        gh::Row r(b);
        sprintf_P(arg1, (const char *)F("sr501_sw%d"), tab);
        eeprom_flag |= b.Switch_(arg1,&sr501[tab].on_off).label(F("Active")).size(1).click();
         {   
            gh::Col c(b,4);
            eeprom_flag |= b.Input(sr501[tab].cmd_on     ).maxLen(HUB_LEN).label(F("Команда при сработке")).color(gh::Colors::Green).click();
            eeprom_flag |= b.Input(sr501[tab].cmd_on_rep ).maxLen(HUB_LEN).label(F("Команда во время сработки")).color(gh::Colors::Green).click();
            eeprom_flag |= b.Input(sr501[tab].cmd_off    ).maxLen(HUB_LEN).label(F("Команда после сработки")).color(gh::Colors::Red).click();
            eeprom_flag |= b.Input(sr501[tab].cmd_off_rep).maxLen(HUB_LEN).label(F("Команда во время пассива")).color(gh::Colors::Red).click();
         }//Row
      }
      eeprom_flag |= b.Flags(&sr501[tab].lamp).text(str_GHflags_IP).label(F("Устройства IP")).click();
      eeprom_flag |= b.Flags(&sr501[tab].modul).text(str_modul).label(hlp_modul).click();
   }
  } // FOR
   if (eeprom_flag) {
      FS_UPDATE(sr501);
      eeprom_flag=false;
   }
}

//--------------------------------------------------------
void parsing_SR501(){
 if (strncmp_P(char_parsung[0].act, PSTR("SR501"), 5) !=0) return; 
 uint16_t intNum=atol(char_parsung[1].act);
 if (intNum < MAX_SR501) sr501_on_off(intNum);
 else
    FOR_i(0,MAX_SR501) sr501_on_off(i);
}

void sr501_on_off(uint16_t i) {
    if (!strncmp_P(char_parsung[2].act, PSTR("ON"),2)) sr501[i].on_off=true;
    if (!strncmp_P(char_parsung[2].act, PSTR("OF"),2)) sr501[i].on_off=false;
}
#endif
