//Модуль упраление приемя радиокоманд 433
#if defined (RX433_PIN)

#include <RCSwitch.h>
RCSwitch RX_433_Switch = RCSwitch();
//--------------------------------------------------------
struct structRX433_pult{
  bool on_off;
  char cmd[CMD_LEN]; // Посылаемая команда
  uint32_t code=0;
  GH::Flags lamp=0;
  GH::Flags modul=0;
  GH::Flags timers=0;
  bool repeat;
};

structRX433_pult RX433_pult[MAX_RX433];
FS_(RX433_pult);
//--------------------------------------------------------
char RX433_Action[CMD_LEN];
char RX433_str[]="0xFFFFFFFF";
int32_t RX433_press;

//--------------------------------------------------------

void setupRX433(){
  RX_433_Switch.enableReceive(RX433_PIN); 
  FS_LOAD(RX433_pult); 
  strcat(main_menu, RX433_MENU);
  strcat(main_menu, ";");
}

//--------------------------------------------------------

void loopRX433() {
  static uint32_t RX433_rep=0;
  static uint32_t RX433_mils=0;
  
  FS_TICK(RX433_pult); 
  if (RX_433_Switch.available()) {
      char arg1[10]; 
      RX433_press=RX_433_Switch.getReceivedValue();
      ultoa(RX433_press,RX433_str,16);
      FOR_i(0,MAX_RX433) {
          //Записать команду в свободную включенную ячейку
          if (RX433_pult[i].on_off)
            if (RX433_pult[i].code==0) {
              RX433_pult[i].code=RX433_press;
              FS_UPDATE(RX433_pult);
              if (hub.focused()) {
                  sprintf_P(arg1, (const char *)F("code433%d"), i);
                  hub.update(arg1).value(RX433_str);
                  HUB_Update=false;
              }
            }
         }

      FOR_j(0,MAX_RX433) {
           if (RX433_pult[j].on_off) {
              if (RX433_pult[j].code==RX433_press) {
                 if ((RX433_rep != RX433_press) || (millis()-RX433_mils>RX433_delay) || (RX433_pult[j].repeat)) {
                     RX433_mils = millis();
                     RX433_rep = RX433_press;

                     if (!strcmp(IR_Action,"IRx"))   sprintf_P(RX433_Action,"IRx %x",RX433_press); else
                     if (!strcmp(IR_Action,"IR"))    sprintf_P(RX433_Action,"IR %u", RX433_press); else
                     if (!strcmp(IR_Action,"433x"))  sprintf_P(RX433_Action,"433x %x",RX433_press); else
                     if (!strcmp(IR_Action,"433"))   sprintf_P(RX433_Action,"433 %u", RX433_press); else
                     strcpy(RX433_Action, RX433_pult[j].cmd);

                     all_parsig(RX433_pult[j].lamp,RX433_pult[j].modul,RX433_Action);
                     DEBUGLN(RX433_str);
                  }   
              }
           }   
        }
    RX_433_Switch.resetAvailable(); // принимаем следующую команду
  }
}
//--------------------------------------------------------
void HUB_moduleRX433(gh::Builder& b) {
  static uint8_t plus_minus[MAX_RX433];
  static uint8_t tab = 0;
  

 FOR(tab,0,MAX_RX433) { 
  b.beginRow();  
  char arg1[10]; 
  sprintf_P(arg1, (const char *)F("swRX433%d"), tab);
  eeprom_flag |= b.Switch_(arg1,&RX433_pult[tab].on_off).label(F("Active")).size(1).click();
  char RX433_HEX[15];
  ultoa(RX433_pult[tab].code,RX433_HEX,16);
  sprintf_P(arg1, (const char *)F("code433%d"), tab);
  if (b.Input_(arg1,&RX433_HEX).label(F("HEX Code")).maxLen(8).regex(F("^[A-Fa-f0-9]+$")).size(2).click()) {
      RX433_pult[tab].code = strtoul(RX433_HEX.c_str(), 0, 16);
      eeprom_flag=true;                                                  }
  eeprom_flag |= b.Switch(&RX433_pult[tab].repeat).label(F("Повтор")).size(1).click();
  if (b.Tabs(&plus_minus[tab]).text(F("- ; +")).size(1).click()) b.refresh();
  b.endRow();  
  if (plus_minus[tab]) {
    eeprom_flag |= b.Input(RX433_pult[tab].cmd).maxLen(HUB_LEN).label(F("Акция 433 пульта")).click();
    eeprom_flag |= b.Flags(&RX433_pult[tab].lamp).text(str_GHflags_IP).label(F("Устройства IP")).click();
    eeprom_flag |= b.Flags(&RX433_pult[tab].modul).text(str_modul).label(hlp_modul).click();
  }
 }  
     if (eeprom_flag) {
      FS_UPDATE(RX433_pult);
      eeprom_flag=false;
   }
}
//--------------------------------------------------------
#endif
