#if defined (MAX_ALARMS)

//--------------------------
struct struct_alarm{
  bool on_off=false;
  uint32_t alarm_time=0;
  char cmd[CMD_LEN];  // Посылаемая команда
  GH::Flags week=0;
  GH::Flags lamp=0;
  GH::Flags modul=0;
  GH::Flags timers=0;
  bool ok=true;
};

struct_alarm alarms[MAX_ALARMS];
FS_(alarms);


//--------------------------------------------------------
void setup_Alarms(){
  FS_LOAD(alarms); 
  strcat(main_menu, ALARM_MENU);
  strcat(main_menu, ";");
}
//--------------------------------------------------------
void loop_Alarms(){        
  FS_TICK(alarms); 
  EVERY_MS(1000)
  {
      FOR_j(0,MAX_ALARMS) 
        if (alarms[j].on_off)
         if (alarms[j].week.get(dayofweek))
          if (hour*60+minute==round(alarms[j].alarm_time/60)) {
               if (alarms[j].ok) {
                    // Рассылка сообщений
                    all_parsig(alarms[j].lamp,alarms[j].modul,alarms[j].cmd);
                    alarms[j].ok=false;
               }
          } else alarms[j].ok=true;
  }
}
//--------------------------------------------------------
/*
void load_Alarms(){
   String CONFIG="";
   FOR_i(0,MAX_ALARMS) {
    CONFIG+="ALARM;"+String(i);
    if (alarms[i].on_off) CONFIG+=";1;";
                     else CONFIG+=";0;";
    CONFIG+=String(alarms[i].alarm_time/3600)+":"+String((alarms[i].alarm_time/60)%60)+";";
    CONFIG+=alarms[i].week.toString()+";"+alarms[i].lamp.toString()+";"+alarms[i].modul.toString()+";"+String(alarms[i].cmd)+char(10);
   }
   Udp.print(CONFIG.c_str());
   Udp.print(char(10));
}
*/
//--------------------------------------------------------
void HUB_module_Alarm(gh::Builder& b) {
  static uint8_t tab = 0;
  static uint8_t plus_minus[MAX_ALARMS];
  FOR(tab,0,MAX_ALARMS) { 
    b.beginRow();  
    eeprom_flag |= b.Switch(&alarms[tab].on_off).label(F("Включить")).size(3).click();
    eeprom_flag |= b.Time(&alarms[tab].alarm_time).label(F("Alarm")).size(4).color(alarms[tab].on_off ?  gh::Colors::Green : gh::Colors::Yellow).click();
    if (b.Tabs(&plus_minus[tab]).text(F("- ; +")).size(3).click()) b.refresh();
    b.endRow();  

    if (plus_minus[tab]) {
      eeprom_flag |= b.Flags(&alarms[tab].week).text(str_dayofweek).label(F("Дни недели")).click();
      b.beginRow();  // начать
      eeprom_flag |= b.Input(alarms[tab].cmd).maxLen(HUB_LEN).size(3).label(F("Акция будильника")).click();
      if (b.Button(0).text(F("👉")).size(1).click()) {
                    all_parsig(alarms[tab].lamp,alarms[tab].modul,alarms[tab].cmd);
      }
      b.endRow();  // ВАЖНО НЕ ЗАБЫТЬ ЕГО ЗАВЕРШИТЬ
      eeprom_flag |= b.Flags(&alarms[tab].lamp).text(str_GHflags_IP).label(F("Устройства IP")).click();
      eeprom_flag |= b.Flags(&alarms[tab].modul).text(str_modul).label(hlp_modul).click();
    }
  }
  if (eeprom_flag) {
      FS_UPDATE(alarms);
      eeprom_flag=false;
   }
}
//----------------------------------
void parsing_Alarm(){
 if (strncmp_P(char_parsung[0].act, PSTR("ALARM"), 5) !=0) return; 
 uint16_t intNum=atol(char_parsung[1].act);
 if (intNum < MAX_ALARMS) {
    if (!strncmp_P(char_parsung[2].act, PSTR("ON"),2)) alarms[intNum].on_off=true;
    if (!strncmp_P(char_parsung[2].act, PSTR("OF"),2)) alarms[intNum].on_off=false;
 }
}
//----------------------------------
#endif
