#define FORMAT_LITTLEFS_IF_FAILED true


#include <WiFiUdp.h>
#include <NTPClient.h>
//#define GH_INCLUDE_PORTAL  // включить сайт в память программы, ~50кБ (не нужно загружать файлы в память) (для esp)
#define GH_FILE_PORTAL     // включить сайт c flash памяти папка /hub/
//#define GH_NO_MQTT
#include <GyverHub.h>
#include <Stamp.h>
#include <FSManager.h>
#include <SimplePortal.h>
//My
#include "macros.h"            //Список макросов
#include "_user.h"             //Пользовательские настройки
#include "define.h"            //Переменные
#ifdef WS2812_PIN
#include <FastLED.h>
#endif
#ifdef CORE0
void Task0code( void * pvParameters ){
  while (true) {
   loop_0();
   delay(10);
  }
}
void Task1code( void * pvParameters ){
  while (true) {
   loop_1();
   delay(10);
  }
}
#endif
void setup() {
#ifdef DEBUG_SERIAL_GT
  Serial.begin(115200);
#endif

#ifdef ESP8266
  SPIFFS.begin(); // подключаем файловую систему 
#endif
#ifdef ESP32
  SPIFFS.begin(FORMAT_LITTLEFS_IF_FAILED); // подключаем файловую систему 
#endif
  delay(500);
  SPIFFS.mkdir("/var");
// Инициализация модулей
  module_setup();

  Connect_WiFi_Portal();    // ищем сеть WiFi

  timeClient.begin();
  delay(500);
  timeClient.update(); 
  hour   = timeClient.getHours();
  minute = timeClient.getMinutes();
  #ifndef GH_NO_MQTT
  hub.mqtt.config(MQTT_SERVER, MQTT_PORT, MQTT_USER, MQTT_PASSWORD);
  #endif

  Udp.begin(localPort);
  hub.onBuild(build);     // подключаем билдер
  hub.begin();            // запускаем систему
  FS_LOAD(ip_addr);
  
//----------------------
  Get_Name();
  char arg1[10];
  FOR_i(1,MAX_IP) {
    sprintf_P(arg1, (const char *)F(";%d"), i);
    strcat(str_GHflags_IP, arg1);
  }
 strcat(str_GHflags_IP, "\0");
 DEBUGLN(str_GHflags_IP);
 // Распределение ядер
#ifdef CORE0
  xTaskCreatePinnedToCore(
                    Task0code,   /* Функция задачи */
                    "TaskCore0", /* Название задачи */
                    10000,       /* Размер стека задачи */
                    NULL,        /* Параметр задачи */
                    1,           /* Приоритет задачи */
                    &Task0,      /* Идентификатор задачи,
                                    чтобы ее можно было отслеживать */
                    0);          /* Ядро для выполнения задачи (0) */                  
  delay(500); 
  xTaskCreatePinnedToCore(
                    Task1code,   /* Функция задачи */
                    "TaskCore1", /* Название задачи */
                    10000,       /* Размер стека задачи */
                    NULL,        /* Параметр задачи */
                    1,           /* Приоритет задачи */
                    &Task1,      /* Идентификатор задачи,
                                    чтобы ее можно было отслеживать */
                    0);          /* Ядро для выполнения задачи (0) */                  
  delay(500); 
#endif

}

//Запуск на одном ядре
void loop() {
#ifndef CORE0
  hub.tick();
  // Разные модули
  module_loop();
  // Разные таймеры
  usertimeClientupdate();
  userTimeRead();
  userAutoSave();
  userWiFiReconect();
  Get_Status();
  Get_Name_Evry_10_min();
  parseUDP();
#endif
}


//распределение по двум ядрам
#ifdef CORE0
void loop_0() {
  module_loop();
}
void loop_1() {
  hub.tick();
  usertimeClientupdate();
  userTimeRead();
  userWiFiReconect();
  userAutoSave();
  Get_Status();
  Get_Name_Evry_10_min();
  parseUDP();
}
#endif
