# API reference

#### AsyncMqttClient()

Instantiate a new AsyncMqttClient object.

### Configuration

#### AsyncMqttClient& setKeepAlive(uint16_t `keepAlive`)

Set the keep alive. Defaults to 15 seconds.

* **`keepAlive`**: Keep alive in seconds

#### AsyncMqttClient& setClientId(const char\* `clientId`)

Set the client ID. Defaults to `esp8266<chip ID on 6 hex caracters>`.

* **`clientId`**: Client ID

#### AsyncMqttClient& setCleanSession(bool `cleanSession`)

Whether or not to set the CleanSession flag. Defaults to `true`.

* **`cleanSession`**: clean session wanted or not

#### AsyncMqttClient& setMaxTopicLength(uint16_t `maxTopicLength`)

Set the maximum allowed topic length to receive. If an MQTT packet is received
with a topic longer than this maximum, the packet will be ignored. Defaults to `128`.

* **`maxTopicLength`**: Maximum allowed topic length to receive

#### AsyncMqttClient& setCredentials(const char\* `username`, const char\* `password` = nullptr)

Set the username/password. Defaults to non-auth.

* **`username`**: Username
* **`password`**: Password

#### AsyncMqttClient& setWill(const char\* `topic`, uint8_t `qos`, bool `retain`, const char\* `payload` = nullptr, size_t `length` = 0)

Set the Last Will Testament. Defaults to none.

* **`topic`**: Topic of the LWT
* **`qos`**: QoS of the LWT
* **`retain`**: Retain flag of the LWT
* **`payload`**: Payload of the LWT. If unset, the payload will be empty
* **`length`**: Payload length. If unset or set to 0, the payload will be considered as a string and its size will be calculated using `strlen(payload)`

#### AsyncMqttClient& setServer(IPAddress `ip`, uint16_t `port`)

Set the server.

* **`ip`**: IP of the server
* **`port`**: Port of the server

#### AsyncMqttClient& setServer(const char\* `host`, uint16_t `port`)

Set the server.

* **`host`**: Host of the server
* **`port`**: Port of the server

#### AsyncMqttClient& setSecure(bool `secure`)

Whether or not to use SSL. Defaults to `false`.

* **`secure`**: SSL wanted or not.

#### AsyncMqttClient& addServerFingerprint(const uint8_t\* `fingerprint`)

Adds an acceptable server fingerprint (SHA1). This may be called multiple times to permit any one of the specified fingerprints. By default, if no fingerprint is added, any fingerprint is accepted.

* **`fingerprint`**: Fingerprint to add

### Events handlers

#### AsyncMqttClient& onConnect(AsyncMqttClientInternals::OnConnectUserCallback `callback`)

Add a connect event handler.

* **`callback`**: Function to call

#### AsyncMqttClient& onDisconnect(AsyncMqttClientInternals::OnDisconnectUserCallback `callback`)

Add a disconnect event handler.

* **`callback`**: Function to call

#### AsyncMqttClient& onSubscribe(AsyncMqttClientInternals::OnSubscribeUserCallback `callback`)

Add a subscribe acknowledged event handler.

* **`callback`**: Function to call

#### AsyncMqttClient& onUnsubscribe(AsyncMqttClientInternals::OnUnsubscribeUserCallback `callback`)

Add an unsubscribe acknowledged event handler.

* **`callback`**: Function to call

#### AsyncMqttClient& onMessage(AsyncMqttClientInternals::OnMessageUserCallback `callback`)

Add a publish received event handler.

* **`callback`**: Function to call

#### AsyncMqttClient& onPublish(AsyncMqttClientInternals::OnPublishUserCallback `callback`)

Add a publish acknowledged event handler.

* **`callback`**: Function to call

### Operation functions

#### bool connected()

Return if the client is currently connected to the broker or not.

#### void connect()

Connect to the server.

#### void disconnect(bool `force` = false)

Disconnect from the server.

* **`force`**: Whether to force the disconnection. Defaults to `false` (clean disconnection).

#### uint16_t subscribe(const char\* `topic`, uint8_t `qos`)

Subscribe to the given topic at the given QoS.

Return the packet ID or 0 if failed.

* **`topic`**: Topic
* **`qos`**: QoS

#### uint16_t unsubscribe(const char\* `topic`)

Unsubscribe from the given topic.

Return the packet ID or 0 if failed.

* **`topic`**: Topic

#### uint16_t publish(const char\* `topic`, uint8_t `qos`, bool `retain`, const char\* `payload` = nullptr, size_t `length` = 0, bool dup = false, uint16_t message_id = 0)

Publish a packet.

Return the packet ID (or 1 if QoS 0) or 0 if failed.

* **`topic`**: Topic
* **`qos`**: QoS
* **`retain`**: Retain flag
* **`payload`**: Payload. If unset, the payload will be empty
* **`length`**: Payload length. If unset or set to 0, the payload will be considered as a string and its size will be calculated using `strlen(payload)`
* **`dup`**: Duplicate flag. If set or set to 1, the payload will be flagged as a duplicate
* **`message_id`**: The message ID. If unset or set to 0, the message ID will be automtaically assigned. Use this with the DUP flag to identify which message is being duplicated
