# Getting started

To use AsyncMqttClient, you need:

* An ESP8266
* The Arduino IDE for ESP8266 (version 2.2.0 minimum)
* Basic knowledge of the Arduino environment (upload a sketch, import libraries, ...)

## Installing AsyncMqttClient

There are two ways to install AsyncMqttClient.

### 1a. For the Arduino IDE

1. Download the [corresponding release](https://github.com/marvinroger/async-mqtt-client/releases/latest)
2. Load the `.zip` with **Sketch → Include Library → Add .ZIP Library**

AsyncMqttClient has 1 dependency: [ESPAsyncTCP](https://github.com/me-no-dev/ESPAsyncTCP). Download the [.zip](https://github.com/me-no-dev/ESPAsyncTCP/archive/master.zip) and install it with the same method as above.

## Fully-featured sketch

See [examples/FullyFeatured-ESP8266.ino](../examples/FullyFeatured-ESP8266/FullyFeatured-ESP8266.ino)

**<u>Very important:</u> As a rule of thumb, never use blocking functions in the callbacks (don't use `delay()` or `yield()`).** Otherwise, you may very probably experience unexpected behaviors.

You can go to the [API reference](2.-API-reference.md).
