/*
   Пример использования библиотеки GyverButton, управляем переменной value при помощи двух кнопок
   Конструкция с isIncr делает увеличение/уменьшение переменной при нажатой кнопке с шагом по времени
*/

#define BTN1 2		// кнопка подключена сюда (PIN --- КНОПКА --- GND)
#define BTN2 3      // кнопка подключена сюда (PIN --- КНОПКА --- GND)

#include "GyverButton.h"
GButton butt1(BTN1);
GButton butt2(BTN2);
int value = 0;

void setup() {
  Serial.begin(9600);
}

void loop() {
  butt1.tick();  // обязательная функция отработки. Должна постоянно опрашиваться
  butt2.tick();  // обязательная функция отработки. Должна постоянно опрашиваться

  if (butt1.isClick()) {           // одиночное нажатие
    value++;                       // инкремент
    Serial.println(value);         // для примера выведем в порт
  }

  if (butt2.isClick()) {           // одиночное нажатие
    value--;                       // декремент
    Serial.println(value);         // для примера выведем в порт
  }

  if (butt1.isStep()) {            // обработчик удержания с шагами
    value++;                       // увеличивать/уменьшать переменную value с шагом и интервалом!
    Serial.println(value);         // для примера выведем в порт
  }

  if (butt2.isStep()) {            // обработчик удержания с шагами
    value--;                       // увеличивать/уменьшать переменную value с шагом и интервалом!
    Serial.println(value);         // для примера выведем в порт
  }
}
