/*
// При наступлении ночи NIGHT_HOURS_START MP3 отключается
// При наступлении время будильника - подключаются (включен или нет, не важно)

// Переменные, которые были использованиы в модуле для анализа

// dawnFlag - Идет рассвет
// dawnPosition - Яркость рассвета
// ONflag - включена/выключена лампа
// currentMode - текущий эффект

*/

//Костыль (из за неточного определения количества файлов)
 uint8_t kostyl[count_mp3_folders+1]={0};//{0,29,19,2,4,2,176};

//буффер команд
 uint8_t cmdbuf[8] = {0x7E, 0xFF, 06, 00, 00, 00, 00, 0xEF};
 uint8_t ansbuf[10] = {0};
 

void command(int8_t cmd, int8_t dat5, int8_t dat6)
{
#ifdef MP3_TX_PIN
  // Посылка команды MP3 плееру
//  cmdbuf[0] = 0x7e; 
//  cmdbuf[1] = 0xFF; 
//  cmdbuf[2] = 0x06; 
  cmdbuf[3] = cmd;  // polecenie
  cmdbuf[4] = 0x00; // 0x00 = no feedback, 0x01 = feedback
  cmdbuf[5] = dat5; // parametr DAT1
  cmdbuf[6] = dat6; // parametr DAT2
  for (uint8_t i = 0; i < 8; i++)
  {
    mp3.write(cmdbuf[i]);
    delay(3);
  }
#endif
}
//------------------------------- 
boolean answer(void)
  // Ответ от MP3 плеера
{
#ifdef MP3_TX_PIN
  uint8_t i;
  uint8_t b = 0;
  while(mp3.available() && (b!=0x7E))
  {
    b = mp3.read();
    delay(3);
  }
  ansbuf[0] = b;
  i = 1;
  while(mp3.available() && (i < 10))
  {
    b = mp3.read();
    ansbuf[i] = b;
    i++;
    delay(3);
  }

  if ((ansbuf[0] == 0x7E) && (ansbuf[9] == 0xEF))
  {
    return true;
  }
 
  return false;
#endif
}
//-------------------------------
byte play_status(bool ans)
{
#ifdef MP3_TX_PIN
 int pl=255; 
 if (ans)
  {
   answer();
   command(0x42, 0, 2);
  }
 uint32_t timer_1=millis();
 while ((not mp3.available()) && (millis()-timer_1<1000)) delay(5);
  if (answer())
   {
   if (ansbuf[3] == 0x42)  pl=ansbuf[6];  // Состояние 0 - Stop, 1 - Play, 2 - Pause 
   if (ansbuf[3] == 0x3D)  pl=0;          // Неожиданно пришел ответ об окончании проигрывания файла
   }
  
  return pl; 
#endif
}
//-------------------------------

void playFolder(int8_t p_path,int8_t p_file)
{
#ifdef MP3_TX_PIN
//  Проигрывание файлов 001, 002 - 255 из папок 01-99
  command(0x0f, p_path,p_file); 
  mp3_play_now=true;
  delay(200);
#endif
}

void playFolderbig(int8_t p_path,int16_t p_file)
{
#ifdef MP3_TX_PIN
//  Проигрывание файлов 0001, 0002 - 4095 из папок 01-15
  int8_t Para_MSB=p_path*16 + p_file/256;
  int8_t Para_LSB=p_file;
  command(0x14, Para_MSB,Para_LSB); 
#endif
}

void mp3_read_max_file()
{
#ifdef MP3_TX_PIN
  uint32_t timefilecout=millis();
  //Считываем количество файлов из папок
  delay(500);
  for (byte i=1;i<count_mp3_folders+1;i++) {
    command(0x4E, 0, i);
    delay(1000);
    timefilecout=millis();
    while (not mp3.available() && millis()-timefilecout>10000) delay(5);// Ожидаем ответа до 10 сек
    if (mp3.available())
     {
       answer();
       count_mp3_files[i]=ansbuf[5]*256+ansbuf[6];
     } else  count_mp3_files[i]=kostyl[i]; //Если ответа нет, берем данные из таблицы
     #if defined(GENERAL_DEBUG)
        LOG.println("count_mp3_files["+String(i)+"]="+String(count_mp3_files[i]));
     #endif
   }
#endif
}   

void mp3_stop()
{
#ifdef MP3_TX_PIN
  command(0x16,0,0); 
  mp3_play_now=false;
#endif
}


void mp3_setup()
{
#ifdef MP3_TX_PIN
  mp3.begin(9600);
  delay(500); 
  command(0x09, 0, 2);  // Выбор TF
  
//  while (!fillString("Определяем количество MP3 файлов", CHSV(modes[EFF_TEXT].Scale, 255U, 255U))) {delay(1); }
  delay(300);
  mp3_read_max_file();
  mp3_timer=millis();
#ifdef BTN_PIN_PLAY
  touch_mp3_play.setStepTimeout(BUTTON_STEP_TIMEOUT);
  touch_mp3_play.setClickTimeout(BUTTON_CLICK_TIMEOUT);
  touch_mp3_stop.setStepTimeout(BUTTON_STEP_TIMEOUT);
  touch_mp3_stop.setClickTimeout(BUTTON_CLICK_TIMEOUT);
  touch_mp3_play.setTimeout(BUTTON_TIMEOUT);
  touch_mp3_stop.setTimeout(BUTTON_TIMEOUT);
#endif
  dawnFlagEnd=false;
  mp3_folder=(modes[EFF_VOICE].Brightness % count_mp3_folders) + 1;
  set_mp3_volume=modes[EFF_VOICE].Speed;
  set_adv_volume=modes[EFF_VOICE].Scale;
  pinMode(MIC_PIN,INPUT);
  
#endif
  for (uint8_t x = 0U; x < MAX_WIDTH; x++) width_music[x]=x;
}


void play_time_ADVERT()
{
#ifdef MP3_TX_PIN
 int pt_h=(uint8_t)((thisTime - thisTime % 60U) / 60U);
 int pt_m=(uint8_t)(thisTime % 60U);
 
 if (pt_h==0) pt_h=24;
 if (mp3_play_time_adv) {
  if (mp3_play_time==1 || mp3_play_time==3) 
    {
      command(0x06, 0,set_adv_volume); // Передать на плеер изменеие громкости
      command(0x13, 0, pt_h); 
      mp3_play_time=(mp3_play_time==1)?2:0;
      mp3_time_timer=millis();
    } else 
  if (mp3_play_time==2) 
   {
    if (millis()-mp3_time_timer>clock_delay[pt_h]+250)
    {
      command(0x13, 0, pt_m+100); 
      mp3_play_time=5;
      mp3_time_timer=millis();
    }
   } else  
  if (mp3_play_time==5) 
   { 
     if (millis()-mp3_time_timer>3000)
      {
        command(0x06, 0,set_mp3_volume); // Передать на плеер изменеие громкости
        mp3_play_time=0;
        loadingFlag=true;
      }
   } 
 }
#endif
}

bool StopDirection;
bool PlayDirection;

static bool startStopHolding = false;     
static bool startPlayHolding = false;     

//Обработка дополнительных клавиш
void touch_mp3()
{
#ifdef BTN_PIN_PLAY
  if (!buttonEnabled)                                       // события кнопки не обрабатываются, если она заблокирована
  {
    return;
  }

  touch_mp3_play.tick();
  touch_mp3_stop.tick();

  uint8_t clickCount_mp3_play = touch_mp3_play.hasClicks() ? touch_mp3_play.getClicks() : 0U;
  uint8_t clickCount_mp3_stop = touch_mp3_stop.hasClicks() ? touch_mp3_stop.getClicks() : 0U;

  if (ONflag && touch_mp3_play.isHolded())
  {
      PlayDirection = !PlayDirection;
  }
  if (ONflag && touch_mp3_stop.isHolded())
  {
      StopDirection = !StopDirection;
  }

      //Удержание одной кнопки меняет громкость
   if (ONflag && touch_mp3_play.isStep())
    {
        modes[EFF_VOICE].Scale = constrain(PlayDirection?modes[EFF_VOICE].Scale+1:modes[EFF_VOICE].Scale-1, 1, 100);
        set_adv_volume=constrain(modes[EFF_VOICE].Scale,0,MP3_MAX_VOLUME); 
        IR_BTN.set_br_sp_sc(5);
    }
    
   if (touch_mp3_stop.isStep())
    {
        modes[EFF_VOICE].Speed = constrain(StopDirection?modes[EFF_VOICE].Speed + 1:modes[EFF_VOICE].Speed - 1, 1, 255);
        set_mp3_volume=constrain(modes[EFF_VOICE].Speed,0,MP3_MAX_VOLUME); 
        IR_BTN.set_br_sp_sc(2);
    }

    // однократное нажатие play смена режима stop / play / auto
  if (clickCount_mp3_play == 1U) { 
     mp3_mode=(mp3_mode+1) % 3; 
     IR_BTN.set_br_sp_sc(7);

  }
// Воспроизвелене времени и включение для будильника (воспроизведение времени только при воспроизведении мелодии)
  if (clickCount_mp3_stop == 1U) {
    mp3_play_time_adv=true;
    mp3_play_time=1;
  }

  // Двухкратное нажатие play смена папки
  if (clickCount_mp3_play == 2U) {
    if (modes[EFF_VOICE].Brightness%count_mp3_folders==count_mp3_folders-1) modes[EFF_VOICE].Brightness-=count_mp3_folders;
    if (modes[EFF_VOICE].Brightness+count_mp3_folders>255) modes[EFF_VOICE].Brightness-=count_mp3_folders;
    modes[EFF_VOICE].Brightness++;
    mp3_folder=modes[EFF_VOICE].Brightness;
//    if (mp3_folder>count_mp3_folders)  mp3_folder=((mp3_folder-1) % count_mp3_folders)+1;
//    while(!fillString(String(mp3_folder).c_str(), CRGB::White)) { delay(1); ESP.wdtFeed(); }
    IR_BTN.set_br_sp_sc(6);
  }
  // Двухкратное нажатие stop смена папки
  if (clickCount_mp3_stop == 2U) {
    if (modes[EFF_VOICE].Brightness%count_mp3_folders==0) modes[EFF_VOICE].Brightness+=count_mp3_folders;
    modes[EFF_VOICE].Brightness--;
    mp3_folder=modes[EFF_VOICE].Brightness;
//    if (mp3_folder>count_mp3_folders)  mp3_folder=((mp3_folder-1) % count_mp3_folders)+1;
//    while(!fillString(String(mp3_folder).c_str(), CRGB::White)) { delay(1); ESP.wdtFeed(); }
    IR_BTN.set_br_sp_sc(6);
  }
  
#endif
}
// end touch_mp3()

// dawnFlag - Идет рассвет
// dawnPosition - Яркость рассвета
// ONflag - включена/выключена лампа
// currentMode - текущий эффект

void mp3_loop()
{
#ifdef MP3_TX_PIN
  if ((millis() - mp3_timer >5000) && mp3_time_test_play_now) { // Раз в 5 секунд в промежуток между прорисовками послать запрос на состояние MP3 
      mp3_play_now=(play_status(true)>0);
      mp3_timer=millis();
      mp3_time_test_play_now=false;
 }
  if (mp3_folder>count_mp3_folders)  mp3_folder=((mp3_folder-1) % count_mp3_folders)+1;
  
  if (mp3_folder_last != mp3_folder) {
     mp3_play_next=true;
     mp3_folder_last=mp3_folder;
  }
  touch_mp3();

  if (mp3_time_test_play_now) play_time_ADVERT();
  switch (mp3_mode)
    {
     case 0: set_mp3_play_now=false;  break;
     case 1: set_mp3_play_now=true;   break;
     case 2: set_mp3_play_now=ONflag; break;
    }
  if (dawnFlag) set_mp3_play_now=true;
  if (mp3_time_test_play_now)
   if (set_mp3_volume!=mp3_volume && !dawnFlag) {
      command(0x06, 0,set_mp3_volume); // Передать на плеер изменеие громкости
      mp3_volume=set_mp3_volume;       // При изменении и без будильника
      mp3_time_test_play_now=false;
   }


  if (mp3_time_test_play_now && mp3_folder>0)
  {
//   time_t currentLocalTime = localTimeZone.toLocal(timeClient.getEpochTime());
   //time_t currentLocalTime = getCurrentLocalTime();
   time_t currentLocalTime = now();
   uint8_t thisDay = dayOfWeek(currentLocalTime);
   thisDay=(thisDay+5) % 7;
   //if ((thisTime < NIGHT_HOURS_START && thisTime > alarms[thisDay].Time) || dawnFlag || !ntpServerAddressResolved) // В дневное время или при будильнике или при отсутствии интернета
     if (mp3_play_now!=set_mp3_play_now || mp3_play_next) {
       if (set_mp3_play_now) {
         mp3_file=random(1,count_mp3_files[mp3_folder]+1);
         playFolder(mp3_folder,mp3_file);
         mp3_play_next=false;
 
       }  else  mp3_stop();
       mp3_time_test_play_now=false;
     }
  }   
  if (mp3_play_now && mp3_folder==0) mp3_stop();
#endif
}


void MP3Routine()
{
 
#ifdef MP3_TX_PIN
  set_mp3_volume=modes[EFF_VOICE].Speed;
  if (set_adv_volume!=modes[EFF_VOICE].Scale)  
  {
    mp3_play_time_adv=true;
    mp3_play_time=1;
    set_adv_volume=modes[EFF_VOICE].Scale;
  }
  if (set_adv_volume==0) mp3_play_time_adv=false;
  for (uint8_t i = 0; i < map(set_mp3_volume,0,30,0,HEIGHT-1); i++)
   {
    for (uint8_t j = 3; j<6; j++)
     leds[getPixelNumber(j, i)]=CHSV(80-i*6+set_mp3_volume*8,255,64); 
   }
  for (uint8_t i = 0; i < map(set_adv_volume,0,30,0,HEIGHT-1); i++)
   {   
    for (uint8_t j = 9; j<12; j++)
     leds[getPixelNumber(j, i)]=CHSV(80-i*6+set_adv_volume*8,255,64); 
   }     
#endif
}


//Кличество разных эквалайзеров
#define MAX_E  8

void FFT_READ_A0()
{
  system_adc_read_fast(adc_addr, adc_num, adc_clk_div);
  for (int i = 0; i < FFT_SIZE; i++) raw[i]=adc_addr[i];
  FFT(raw, spectr);
  for (int i = 0; i < FFT_SIZE / 2; i++) {
    spectr[i] = (spectr[i] * (i + 2)) >> 1;
  }
}

void EqualizerRoutine()
{
//  for (int i = 0; i < FFT_SIZE; i++) raw[i] = analogRead(MIC_PIN);
  
  SaluteFadeAll(1);
  FFT_READ_A0();
   for (int i = 0; i < WIDTH; i++) {
    int rez=spectr[i];
    if (i<4) rez=rez/4*(i+1);
    if (rez > 10000) rez = 10000;
    if (rez>max_vol) max_vol=rez;
    data_a[i]=rez;
   }
//Вывод на матрицу
   Serial.println(String(max_vol)+" ");
   for (int i = 0; i < WIDTH; i++) 
   {
    Serial.print(String(data_a[i])+" ");
    int vol_16=map(int(data_a[i]),0,max_vol,0,HEIGHT);
    int rnd_h=random(vol_16/5,HEIGHT-vol_16/5);
    int rnd_w=random(vol_16/5,WIDTH-vol_16/5);
    switch (modes[currentMode].Speed % MAX_E)
    {
      case 6: 
        for (int yy = 0; yy < vol_16/4; yy++)   
          drawCircle((i+hue/WIDTH) % WIDTH,vol_16*4/5, yy, CHSV(i*12,255,128-yy*2)); //DrawCircleCylinder
      break;
      case 7: 
        for (int yy = 0; yy < vol_16/4; yy++)   
          drawCircle(rnd_w,rnd_h, yy, CHSV(i*18+hue*5+yy*7+rnd_h*11,255,128-yy*2)); 
      break;
      case 8: 
      break;
      default:

      for (int yy = 0; yy < vol_16; yy++)  
       switch (modes[currentMode].Speed % MAX_E)
        {
//         Варинты эквалайзера
         case 0: leds[getPixelNumber(i, yy)]=CHSV(i*12,128+yy*8,128-yy*2); break; 
         case 1: leds[getPixelNumber(i, yy)]=CHSV(yy*6+i*15,255,128-random(10)); break;
         case 2: leds[getPixelNumber(i, yy)]=CHSV(yy*6+i*15,255,128-yy*2); break;
         case 3: leds[getPixelNumber((i+hue/WIDTH) % WIDTH, yy)]=CHSV(yy*6+i*15,255,160-yy*4); break;
         case 4: 
           leds[getPixelNumber(i, 8+yy/2)]=CHSV(i*12,128+yy*8,128-yy*2);
           leds[getPixelNumber(i, 7-yy/2)]=CHSV(i*12,128+yy*8,128-yy*2);
           break;
         case 5: 
           leds[getPixelNumber(8+yy/2, i)]=CHSV(i*12,128+yy*8,128-yy*2);
           leds[getPixelNumber(7-yy/2, i)]=CHSV(i*12,128+yy*8,128-yy*2);
           break;
        }
    } 
   }  
  if (max_vol>200) max_vol=max_vol*0.99;
  else 
  if (max_vol>HEIGHT*2) max_vol--;
  hue++;
}

#define FFT_SIZE_FLASH 128  // 32/64/128/256/512
uint8_t FlashSoundRoutine()
{
  uint8_t rez_ret=0;
  max_now=0;
  SaluteFadeAll(1);
  FFT_READ_A0();

  for (int i = 0; i < FFT_SIZE / 2; i++) {
    int rez=spectr[i];
    if (rez > 10000) rez = 10000;
    if (rez>max_now)  max_now=rez; 
    data_a[i]=rez;
//    Serial.print(String(rez)+" ");
   }
  if (max_now>max_vol) {
    rez_ret=map(max_now-max_vol,0,10000,0,4);
    max_vol=max_now;
  }
  if (max_vol>200) max_vol=max_vol*0.99;
  else 
  if (max_vol>HEIGHT*2) max_vol--;
 // Serial.println(String(max_vol)+' '+String(rez_ret*250));
  return rez_ret;
}


// ============= ЭФФЕКТ МУЗЫКАЛЬНЫЙ ДОЖДЬ ==============
// от @Shaitan
void MusicRainRoutine()
{
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
  if (selectedSettings) {
    setModeSettings(random8(10U) ? 2U + random8(99U) : 1U , 185U + random8(52U));
  }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
  int Flash_RND=FlashSoundRoutine();
  CRGB thisColor;
  for (uint8_t x = 0U; x < WIDTH; x++)
  {
    // Яркость точки (чустивительность к звуку)
    uint16_t cll_rain=map(spectr[x],0,max_vol,0,255 + modes[currentMode].Scale*20);
    if (cll_rain>255) cll_rain=255;
    thisColor=CHSV(x*16, 255U, cll_rain);
    
    switch (modes[currentMode].Speed % 4)
    {
    case 0:
       drawPixelXY(x, HEIGHT - 1U, thisColor); 
       break;
    case 1:
       drawPixelXY((x+hue) % WIDTH, HEIGHT - 1U, thisColor); 
       break;
    case 2:
       drawPixelXY((x+WIDTH-hue) % WIDTH, HEIGHT - 1U, thisColor); 
       break;
    case 3:
       drawPixelXY(width_music[x], HEIGHT - 1U, thisColor); 
       break;
    }   
  }
     uint8_t x1=random(WIDTH);
     uint8_t x2=random(WIDTH);
     uint8_t tmp_x=width_music[x1];
     width_music[x1]=width_music[x2];
     width_music[x2]=tmp_x;
    
  for (uint8_t x = 0U; x < WIDTH; x++)
  {
    for (uint8_t y = 0U; y < HEIGHT - 1U; y++)
    {
      drawPixelXY(x, y, getPixColorXY(x, y + 1U));
    }
  }
  hue=(hue+1) % WIDTH;
}
