// ============= ЭФФЕКТЫ ===============
// несколько общих переменных и буферов, которые могут использоваться в любом эффекте
#define SQRT_VARIANT sqrt3                         // выбор основной функции для вычисления квадратного корня sqrtf или sqrt3 для ускорения
uint8_t hue, hue2;                                 // постепенный сдвиг оттенка или какой-нибудь другой цикличный счётчик
uint8_t deltaHue, deltaHue2;                       // ещё пара таких же, когда нужно много
uint8_t step;                                      // какой-нибудь счётчик кадров или последовательностей операций
uint8_t pcnt;                                      // какой-то счётчик какого-то прогресса
uint8_t deltaValue;                                // просто повторно используемая переменная
float speedfactor;                                 // регулятор скорости в эффектах реального времени
float emitterX, emitterY;                          // какие-то динамичные координаты
CRGB ledsbuff[NUM_LEDS];                           // копия массива leds[] целиком
#define NUM_LAYERSMAX 2
uint8_t noise3d[NUM_LAYERSMAX][MAX_WIDTH][MAX_HEIGHT];     // двухслойная маска или хранилище свойств в размер всей матрицы
uint8_t line[MAX_WIDTH];                               // свойство пикселей в размер строки матрицы
uint8_t shiftHue[MAX_HEIGHT];                          // свойство пикселей в размер столбца матрицы
uint8_t shiftValue[MAX_HEIGHT];                        // свойство пикселей в размер столбца матрицы ещё одно
uint16_t ff_x, ff_y, ff_z;                         // большие счётчики


//массивы состояния объектов, которые могут использоваться в любом эффекте
#define trackingOBJECT_MAX_COUNT                         (100U)  // максимальное количество отслеживаемых объектов (очень влияет на расход памяти)
float   trackingObjectPosX[trackingOBJECT_MAX_COUNT];
float   trackingObjectPosY[trackingOBJECT_MAX_COUNT];
float   trackingObjectSpeedX[trackingOBJECT_MAX_COUNT];
float   trackingObjectSpeedY[trackingOBJECT_MAX_COUNT];
float   trackingObjectShift[trackingOBJECT_MAX_COUNT];
uint8_t trackingObjectHue[trackingOBJECT_MAX_COUNT];
uint8_t trackingObjectState[trackingOBJECT_MAX_COUNT];
bool    trackingObjectIsShift[trackingOBJECT_MAX_COUNT];
#define enlargedOBJECT_MAX_COUNT                     (MAX_WIDTH * 2) // максимальное количество сложных отслеживаемых объектов (меньше, чем trackingOBJECT_MAX_COUNT)
uint8_t enlargedObjectNUM;                                       // используемое в эффекте количество объектов
long    enlargedObjectTime[enlargedOBJECT_MAX_COUNT];
float    liquidLampHot[enlargedOBJECT_MAX_COUNT];
float    liquidLampSpf[enlargedOBJECT_MAX_COUNT];
unsigned liquidLampMX[enlargedOBJECT_MAX_COUNT];
unsigned liquidLampSC[enlargedOBJECT_MAX_COUNT];
unsigned liquidLampTR[enlargedOBJECT_MAX_COUNT];

// стандартные функции библиотеки LEDraw от @Palpalych (для адаптаций его эффектов)
void blurScreen(fract8 blur_amount, CRGB *LEDarray = leds)
{
  blur2d(LEDarray, WIDTH, HEIGHT, blur_amount);
}

void dimAll(uint8_t value, CRGB *LEDarray = leds) {
  //for (uint16_t i = 0; i < NUM_LEDS; i++) {
  //  leds[i].nscale8(value); //fadeToBlackBy
  //}
  // теперь короткий вариант
  nscale8(LEDarray, NUM_LEDS, value);
  //fadeToBlackBy(LEDarray, NUM_LEDS, 255U - value); // эквивалент
}

//константы размера матрицы вычисляется только здесь и не меняется в эффектах
const uint8_t CENTER_X_MINOR =  (WIDTH / 2) -  ((WIDTH - 1) & 0x01); // центр матрицы по ИКСУ, сдвинутый в меньшую сторону, если ширина чётная
const uint8_t CENTER_Y_MINOR = (HEIGHT / 2) - ((HEIGHT - 1) & 0x01); // центр матрицы по ИГРЕКУ, сдвинутый в меньшую сторону, если высота чётная
const uint8_t CENTER_X_MAJOR =   WIDTH / 2  + (WIDTH % 2);           // центр матрицы по ИКСУ, сдвинутый в большую сторону, если ширина чётная
const uint8_t CENTER_Y_MAJOR =  HEIGHT / 2  + (HEIGHT % 2);          // центр матрицы по ИГРЕКУ, сдвинутый в большую сторону, если высота чётная

#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
void setModeSettings(uint8_t Scale = 0U, uint8_t Speed = 0U) {
  modes[currentMode].Scale = Scale ? Scale : pgm_read_byte(&defaultSettings[currentMode][2]);
  modes[currentMode].Speed = Speed ? Speed : pgm_read_byte(&defaultSettings[currentMode][1]);
  jsonWrite(configSetup, "sp", modes[currentMode].Speed);
  jsonWrite(configSetup, "sc", modes[currentMode].Scale);  
  selectedSettings = 0U;
#ifdef USE_BLYNK
  updateRemoteBlynkParams();
#endif
}
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)


// ------------------------------ Дополнительные функции рисования ----------------------
void DrawLine(int x1, int y1, int x2, int y2, CRGB color)
{
  int deltaX = abs(x2 - x1);
  int deltaY = abs(y2 - y1);
  int signX = x1 < x2 ? 1 : -1;
  int signY = y1 < y2 ? 1 : -1;
  int error = deltaX - deltaY;

  drawPixelXY(x2, y2, color);
  while (x1 != x2 || y1 != y2) {
    drawPixelXY(x1, y1, color);
    int error2 = error * 2;
    if (error2 > -deltaY) {
      error -= deltaY;
      x1 += signX;
    }
    if (error2 < deltaX) {
      error += deltaX;
      y1 += signY;
    }
  }
}

void DrawLineF(float x1, float y1, float x2, float y2, CRGB color) {
  float deltaX = std::fabs(x2 - x1);
  float deltaY = std::fabs(y2 - y1);
  float error = deltaX - deltaY;

  float signX = x1 < x2 ? 0.5 : -0.5;
  float signY = y1 < y2 ? 0.5 : -0.5;

  while (x1 != x2 || y1 != y2) { // (true) - а я то думаю - "почему функция часто вызывает вылет по вачдогу?" А оно вон оно чё, Михалычь!
    if ((signX > 0 && x1 > x2 + signX) || (signX < 0 && x1 < x2 + signX)) break;
    if ((signY > 0 && y1 > y2 + signY) || (signY < 0 && y1 < y2 + signY)) break;
    drawPixelXYF(x1, y1, color); // интересно, почему тут было обычное drawPixelXY() ???
    float error2 = error;
    if (error2 > -deltaY) {
      error -= deltaY;
      x1 += signX;
    }
    if (error2 < deltaX) {
      error += deltaX;
      y1 += signY;
    }
  }
}

/* kostyamat добавил
  функция уменьшения яркости */
CRGB makeDarker( const CRGB& color, fract8 howMuchDarker)
{
  CRGB newcolor = color;
  //newcolor.nscale8( 255 - howMuchDarker);
  newcolor.fadeToBlackBy(howMuchDarker);//эквивалент
  return newcolor;
}

//по мотивам
//https://gist.github.com/sutaburosu/32a203c2efa2bb584f4b846a91066583
void drawPixelXYF(float x, float y, CRGB color) //, uint8_t darklevel = 0U)
{
  //  if (x<0 || y<0) return; //не похоже, чтобы отрицательные значения хоть как-нибудь учитывались тут // зато с этой строчкой пропадает нижний ряд
  // extract the fractional parts and derive their inverses
  uint8_t xx = (x - (int)x) * 255, yy = (y - (int)y) * 255, ix = 255 - xx, iy = 255 - yy;
  // calculate the intensities for each affected pixel
#define WU_WEIGHT(a,b) ((uint8_t) (((a)*(b)+(a)+(b))>>8))
  uint8_t wu[4] = {WU_WEIGHT(ix, iy), WU_WEIGHT(xx, iy),
                   WU_WEIGHT(ix, yy), WU_WEIGHT(xx, yy)
                  };
  // multiply the intensities by the colour, and saturating-add them to the pixels
  for (uint8_t i = 0; i < 4; i++) {
    int16_t xn = x + (i & 1), yn = y + ((i >> 1) & 1);
    CRGB clr = getPixColorXY(xn, yn);
    clr.r = qadd8(clr.r, (color.r * wu[i]) >> 8);
    clr.g = qadd8(clr.g, (color.g * wu[i]) >> 8);
    clr.b = qadd8(clr.b, (color.b * wu[i]) >> 8);
    //if (darklevel) drawPixelXY(xn, yn, makeDarker(clr, darklevel));
    //else
    drawPixelXY(xn, yn, clr);
  }
}

/*
  //исправленная от SottNick для поддержки значений -1
  void drawPixelXYF(float x, float y, CRGB color)//, uint8_t darklevel = 0U)
  {
  float xt = x + 1.0, yt = y + 1.0;
  if (xt<0 || yt<0) return; //не похоже, чтобы отрицательные значения хоть как-нибудь учитывались тут
  // extract the fractional parts and derive their inverses
  uint8_t xx = (xt - (int)xt) * 255, yy = (yt - (int)yt) * 255, ix = 255 - xx, iy = 255 - yy;
  // calculate the intensities for each affected pixel
  #define WU_WEIGHT(a,b) ((uint8_t) (((a)*(b)+(a)+(b))>>8))
  uint8_t wu[4] = {WU_WEIGHT(ix, iy), WU_WEIGHT(xx, iy),
                   WU_WEIGHT(ix, yy), WU_WEIGHT(xx, yy)};
  // multiply the intensities by the colour, and saturating-add them to the pixels
  for (uint8_t i = 0; i < 4; i++) {
    int16_t xn = x + (i & 1), yn = y + ((i >> 1) & 1);
    CRGB clr = getPixColorXY(xn, yn);
    clr.r = qadd8(clr.r, (color.r * wu[i]) >> 8);
    clr.g = qadd8(clr.g, (color.g * wu[i]) >> 8);
    clr.b = qadd8(clr.b, (color.b * wu[i]) >> 8);
    drawPixelXY(xn, yn, clr);
  }
  }
*/

/* что-то мне эта доработка не понравилась...
  void drawCircleF(float x0, float y0, float radius, const CRGB &color, bool fill = false, float step = 0.25){
  float a = radius, b = 0.;
  float radiusError = step - a;

  if (radius <= step*2) {
    drawPixelXYF(x0, y0, color);
    return;
  }

  while (a >= b)  {
    if (fill) {
      //  С этим нужно еще подумать. Как зарисовывать круг. Приспичит, - сделаю
    }
    else {
      drawPixelXYF(a + x0, b + y0, color, 50);
      drawPixelXYF(b + x0, a + y0, color, 50);
      drawPixelXYF(-a + x0, b + y0, color, 50);
      drawPixelXYF(-b + x0, a + y0, color, 50);
      drawPixelXYF(-a + x0, -b + y0, color, 50);
      drawPixelXYF(-b + x0, -a + y0, color, 50);
      drawPixelXYF(a + x0, -b + y0, color, 50);
      drawPixelXYF(b + x0, -a + y0, color, 50);
    }
    b+= step;
    if (radiusError < 0.)
      radiusError += 2. * b + step;
    else
    {
      a-= step;
      radiusError += 2 * (b - a + step);
    }
  }
  }
*/

void drawCircleF(float x0, float y0, float radius, CRGB color) {
  float x = 0, y = radius, error = 0;
  float delta = 1. - 2. * radius;

  while (y >= 0) {
    //    drawPixelXYF(x0 + x, y0 + y, color);
    //    drawPixelXYF(x0 + x, y0 - y, color);
    //    drawPixelXYF(x0 - x, y0 + y, color);
    //    drawPixelXYF(x0 - x, y0 - y, color);
    drawPixelXYF(fmod(x0 + x + WIDTH, WIDTH), y0 + y, color); // сделал, чтобы круги были бесшовными по оси х
    drawPixelXYF(fmod(x0 + x + WIDTH, WIDTH), y0 - y, color);
    drawPixelXYF(fmod(x0 - x + WIDTH, WIDTH), y0 + y, color);
    drawPixelXYF(fmod(x0 - x + WIDTH, WIDTH), y0 - y, color);
    error = 2. * (delta + y) - 1.;
    if (delta < 0 && error <= 0) {
      ++x;
      delta += 2. * x + 1.;
      continue;
    }
    error = 2. * (delta - x) - 1.;
    if (delta > 0 && error > 0) {
      --y;
      delta += 1. - 2. * y;
      continue;
    }
    ++x;
    delta += 2. * (x - y);
    --y;
  }
}


// палитра для типа реалистичного водопада (если ползунок Масштаб выставить на 100)
extern const TProgmemRGBPalette16 WaterfallColors_p FL_PROGMEM = {0x000000, 0x060707, 0x101110, 0x151717, 0x1C1D22, 0x242A28, 0x363B3A, 0x313634, 0x505552, 0x6B6C70, 0x98A4A1, 0xC1C2C1, 0xCACECF, 0xCDDEDD, 0xDEDFE0, 0xB2BAB9};

// добавлено изменение текущей палитры (используется во многих эффектах ниже для бегунка Масштаб)
const TProgmemRGBPalette16 *palette_arr[] = {
  &PartyColors_p,
  &OceanColors_p,
  &LavaColors_p,
  &HeatColors_p,
  &WaterfallColors_p,
  &CloudColors_p,
  &ForestColors_p,
  &RainbowColors_p,
  &RainbowStripeColors_p
};
const TProgmemRGBPalette16 *curPalette = palette_arr[0];
void setCurrentPalette() {
  if (modes[currentMode].Scale > 100U) modes[currentMode].Scale = 100U; // чтобы не было проблем при прошивке без очистки памяти
  curPalette = palette_arr[(uint8_t)(modes[currentMode].Scale / 100.0F * ((sizeof(palette_arr) / sizeof(TProgmemRGBPalette16 *)) - 0.01F))];
}
// при таком количестве палитр (9шт) каждый диапазон Масштаба (от 1 до 100) можно разбить на участки по 11 значений
// значения от 0 до 10 = ((modes[currentMode].Scale - 1U) % 11U)
// значения от 1 до 11 = ((modes[currentMode].Scale - 1U) % 11U + 1U)
// а 100е значение Масштаба можно использовать для белого цвета


// дополнительные палитры для пламени
// для записи в PROGMEM преобразовывал из 4 цветов в 16 на сайте https://colordesigner.io/gradient-generator, но не уверен, что это эквивалент CRGBPalette16()
// значения цветовых констант тут: https://github.com/FastLED/FastLED/wiki/Pixel-reference
extern const TProgmemRGBPalette16 WoodFireColors_p FL_PROGMEM = {CRGB::Black, 0x330e00, 0x661c00, 0x992900, 0xcc3700, CRGB::OrangeRed, 0xff5800, 0xff6b00, 0xff7f00, 0xff9200, CRGB::Orange, 0xffaf00, 0xffb900, 0xffc300, 0xffcd00, CRGB::Gold};             //* Orange
extern const TProgmemRGBPalette16 NormalFire_p FL_PROGMEM = {CRGB::Black, 0x330000, 0x660000, 0x990000, 0xcc0000, CRGB::Red, 0xff0c00, 0xff1800, 0xff2400, 0xff3000, 0xff3c00, 0xff4800, 0xff5400, 0xff6000, 0xff6c00, 0xff7800};                             // пытаюсь сделать что-то более приличное
extern const TProgmemRGBPalette16 NormalFire2_p FL_PROGMEM = {CRGB::Black, 0x560000, 0x6b0000, 0x820000, 0x9a0011, CRGB::FireBrick, 0xc22520, 0xd12a1c, 0xe12f17, 0xf0350f, 0xff3c00, 0xff6400, 0xff8300, 0xffa000, 0xffba00, 0xffd400};                      // пытаюсь сделать что-то более приличное
extern const TProgmemRGBPalette16 LithiumFireColors_p FL_PROGMEM = {CRGB::Black, 0x240707, 0x470e0e, 0x6b1414, 0x8e1b1b, CRGB::FireBrick, 0xc14244, 0xd16166, 0xe08187, 0xf0a0a9, CRGB::Pink, 0xff9ec0, 0xff7bb5, 0xff59a9, 0xff369e, CRGB::DeepPink};        //* Red
extern const TProgmemRGBPalette16 SodiumFireColors_p FL_PROGMEM = {CRGB::Black, 0x332100, 0x664200, 0x996300, 0xcc8400, CRGB::Orange, 0xffaf00, 0xffb900, 0xffc300, 0xffcd00, CRGB::Gold, 0xf8cd06, 0xf0c30d, 0xe9b913, 0xe1af1a, CRGB::Goldenrod};           //* Yellow
extern const TProgmemRGBPalette16 CopperFireColors_p FL_PROGMEM = {CRGB::Black, 0x001a00, 0x003300, 0x004d00, 0x006600, CRGB::Green, 0x239909, 0x45b313, 0x68cc1c, 0x8ae626, CRGB::GreenYellow, 0x94f530, 0x7ceb30, 0x63e131, 0x4bd731, CRGB::LimeGreen};     //* Green
extern const TProgmemRGBPalette16 AlcoholFireColors_p FL_PROGMEM = {CRGB::Black, 0x000033, 0x000066, 0x000099, 0x0000cc, CRGB::Blue, 0x0026ff, 0x004cff, 0x0073ff, 0x0099ff, CRGB::DeepSkyBlue, 0x1bc2fe, 0x36c5fd, 0x51c8fc, 0x6ccbfb, CRGB::LightSkyBlue};  //* Blue
extern const TProgmemRGBPalette16 RubidiumFireColors_p FL_PROGMEM = {CRGB::Black, 0x0f001a, 0x1e0034, 0x2d004e, 0x3c0068, CRGB::Indigo, CRGB::Indigo, CRGB::Indigo, CRGB::Indigo, CRGB::Indigo, CRGB::Indigo, 0x3c0084, 0x2d0086, 0x1e0087, 0x0f0089, CRGB::DarkBlue};        //* Indigo
extern const TProgmemRGBPalette16 PotassiumFireColors_p FL_PROGMEM = {CRGB::Black, 0x0f001a, 0x1e0034, 0x2d004e, 0x3c0068, CRGB::Indigo, 0x591694, 0x682da6, 0x7643b7, 0x855ac9, CRGB::MediumPurple, 0xa95ecd, 0xbe4bbe, 0xd439b0, 0xe926a1, CRGB::DeepPink}; //* Violet
const TProgmemRGBPalette16 *firePalettes[] = {
  //    &HeatColors_p, // эта палитра уже есть в основном наборе. если в эффекте подключены оба набора палитр, тогда копия не нужна
  &WoodFireColors_p,
  &NormalFire_p,
  &NormalFire2_p,
  &LithiumFireColors_p,
  &SodiumFireColors_p,
  &CopperFireColors_p,
  &AlcoholFireColors_p,
  &RubidiumFireColors_p,
  &PotassiumFireColors_p
};


// ------------- конфетти --------------
#define FADE_OUT_SPEED        (70U)                         // скорость затухания
void sparklesRoutine()
{
  if (loadingFlag) {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      setModeSettings(4U + random8(97U), 99U + random8(125U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    for (uint16_t i = 0; i < NUM_LEDS; i++)
      if (random8(3U))
        leds[i].nscale8(random8());
      else
        leds[i] = 0U;
  }

  for (uint8_t i = 0; i < modes[currentMode].Scale; i++)
  {
    uint8_t x = random8(WIDTH);
    uint8_t y = random8(HEIGHT);
    if (getPixColorXY(x, y) == 0U)
    {
      leds[XY(x, y)] = CHSV(random8(), 255U, 255U);
    }
  }
  //fader(FADE_OUT_SPEED);
  dimAll(256U - FADE_OUT_SPEED);
}

/* убираем, т.к. есть копия dimAll()
  // функция плавного угасания цвета для всех пикселей
  void fader(uint8_t step)
  {
  for (uint8_t i = 0U; i < WIDTH; i++)
  {
    for (uint8_t j = 0U; j < HEIGHT; j++)
    {
      fadePixel(i, j, step);
    }
  }
  }
*/
void fadePixel(uint8_t i, uint8_t j, uint8_t step)          // новый фейдер
{
  int32_t pixelNum = XY(i, j);
  if (getPixColor(pixelNum) == 0U) return;

  if (leds[pixelNum].r >= 30U ||
      leds[pixelNum].g >= 30U ||
      leds[pixelNum].b >= 30U)
  {
    leds[pixelNum].fadeToBlackBy(step);
  }
  else
  {
    leds[pixelNum] = 0U;
  }
}


// =============- новый огонь / водопад -===============
// COOLING: How much does the air cool as it rises?
// Less cooling = taller flames.  More cooling = shorter flames.
// Default 55, suggested range 20-100
#define COOLINGNEW 32
// 8  практически сплошной поток красивой подсвеченной воды ровным потоком сверху донизу. будто бы на столе стоит маленький "родничок"
// 20 ровный водопад с верщиной на свету, где потоки летящей воды наверху разбиваются ветром в белую пену
// 32 уже не ровный водопад, у которого струи воды долетают до земли неравномерно
// чем больше параметр, тем больше тени снизу
// 55 такое, как на видео

// SPARKING: What chance (out of 255) is there that a new spark will be lit?
// Higher chance = more roaring fire.  Lower chance = more flickery fire.
// Default 120, suggested range 50-200.
#define SPARKINGNEW 80 // 30 // 120 // 90 // 60
// 80 почти все белые струи сверху будут долетать до низа - хорошо при выбранном ползунке Масштаб = 100 (белая вода без подкрашивания)
// 50 чуть больше половины будет долетать. для цветных вариантов жидкости так более эффектно

void fire2012WithPalette() {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
  if (selectedSettings) {
    setModeSettings(random8(7U) ? 46U + random8(26U) : 100U, 195U + random8(40U));
  }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

  //    bool fire_water = modes[currentMode].Scale <= 50;
  //    uint8_t COOLINGNEW = fire_water ? modes[currentMode].Scale * 2  + 20 : (100 - modes[currentMode].Scale ) *  2 + 20 ;
  //    uint8_t COOLINGNEW = modes[currentMode].Scale * 2  + 20 ;
  // Array of temperature readings at each simulation cell
  //static byte heat[WIDTH][HEIGHT]; будет noise3d[0][WIDTH][HEIGHT]

  for (uint8_t x = 0; x < WIDTH; x++) {
    // Step 1.  Cool down every cell a little
    for (uint8_t i = 0; i < HEIGHT; i++) {
      noise3d[0][x][i] = qsub8(noise3d[0][x][i], random8(0, ((COOLINGNEW * 10) / HEIGHT) + 2));
    }

    // Step 2.  Heat from each cell drifts 'up' and diffuses a little
    for (uint8_t k = HEIGHT - 1; k >= 2; k--) {
      noise3d[0][x][k] = (noise3d[0][x][k - 1] + noise3d[0][x][k - 2] + noise3d[0][x][k - 2]) / 3;
    }

    // Step 3.  Randomly ignite new 'sparks' of heat near the bottom
    if (random8() < SPARKINGNEW) {
      uint8_t y = random8(2);
      noise3d[0][x][y] = qadd8(noise3d[0][x][y], random8(160, 255));
    }

    // Step 4.  Map from heat cells to LED colors
    for (uint8_t j = 0; j < HEIGHT; j++) {
      // Scale the heat value from 0-255 down to 0-240
      // for best results with color palettes.
      byte colorindex = scale8(noise3d[0][x][j], 240);
      if (modes[currentMode].Scale == 100)
        leds[XY(x, (HEIGHT - 1) - j)] = ColorFromPalette(WaterfallColors_p, colorindex);
      else
        leds[XY(x, (HEIGHT - 1) - j)] = ColorFromPalette(CRGBPalette16( CRGB::Black, CHSV(modes[currentMode].Scale * 2.57, 255U, 255U) , CHSV(modes[currentMode].Scale * 2.57, 128U, 255U) , CRGB::White), colorindex);// 2.57 вместо 2.55, потому что 100 для белого цвета
      //leds[XY(x, (HEIGHT - 1) - j)] = ColorFromPalette(fire_water ? HeatColors_p : OceanColors_p, colorindex);
    }
  }
}

// ------------- огонь -----------------
#define SPARKLES              (1U)                     // вылетающие угольки вкл выкл
#define UNIVERSE_FIRE                                  // универсальный огонь 2-в-1 Цветной+Белый

//uint8_t pcnt = 0U;                                     // внутренний делитель кадров для поднимающегося пламени - переменная вынесена в общий пул, чтобы использовать повторно
//uint8_t deltaHue = 16U;                                // текущее смещение пламени (hueMask) - переменная вынесена в общий пул, чтобы использовать повторно
//uint8_t shiftHue[HEIGHT];                              // массив дороожки горизонтального смещения пламени (hueMask) - вынесен в общий пул массивов переменных
//uint8_t deltaValue = 16U;                              // текущее смещение пламени (hueValue) - переменная вынесена в общий пул, чтобы использовать повторно
//uint8_t shiftValue[HEIGHT];                            // массив дороожки горизонтального смещения пламени (hueValue) - вынесен в общий пул массивов переменных

//these values are substracetd from the generated values to give a shape to the animation
static const uint8_t valueMask[8][16] PROGMEM =
{
  {0  , 0  , 0  , 32 , 32 , 0  , 0  , 0  , 0  , 0  , 0  , 32 , 32 , 0  , 0  , 0  },
  {0  , 0  , 0  , 64 , 64 , 0  , 0  , 0  , 0  , 0  , 0  , 64 , 64 , 0  , 0  , 0  },
  {0  , 0  , 32 , 96 , 96 , 32 , 0  , 0  , 0  , 0  , 32 , 96 , 96 , 32 , 0  , 0  },
  {0  , 32 , 64 , 128, 128, 64 , 32 , 0  , 0  , 32 , 64 , 128, 128, 64 , 32 , 0  },
  {32 , 64 , 96 , 160, 160, 96 , 64 , 32 , 32 , 64 , 96 , 160, 160, 96 , 64 , 32 },
  {64 , 96 , 128, 192, 192, 128, 96 , 64 , 64 , 96 , 128, 192, 192, 128, 96 , 64 },
  {96 , 128, 160, 255, 255, 160, 128, 96 , 96 , 128, 160, 255, 255, 160, 128, 96 },
  {128, 160, 192, 255, 255, 192, 160, 128, 128, 160, 192, 255, 255, 192, 160, 128}
};

//these are the hues for the fire,
//should be between 0 (red) to about 25 (yellow)
static const uint8_t hueMask[8][16] PROGMEM =
{
  {25, 22, 11, 1 , 1 , 11, 19, 25, 25, 22, 11, 1 , 1 , 11, 19, 25 },
  {25, 19, 8 , 1 , 1 , 8 , 13, 19, 25, 19, 8 , 1 , 1 , 8 , 13, 19 },
  {19, 16, 8 , 1 , 1 , 8 , 13, 16, 19, 16, 8 , 1 , 1 , 8 , 13, 16 },
  {13, 13, 5 , 1 , 1 , 5 , 11, 13, 13, 13, 5 , 1 , 1 , 5 , 11, 13 },
  {11, 11, 5 , 1 , 1 , 5 , 11, 11, 11, 11, 5 , 1 , 1 , 5 , 11, 11 },
  {8 , 5 , 1 , 0 , 0 , 1 , 5 , 8 , 8 , 5 , 1 , 0 , 0 , 1 , 5 , 8  },
  {5 , 1 , 0 , 0 , 0 , 0 , 1 , 5 , 5 , 1 , 0 , 0 , 0 , 0 , 1 , 5  },
  {1 , 0 , 0 , 0 , 0 , 0 , 0 , 1 , 1 , 0 , 0 , 0 , 0 , 0 , 0 , 1  }
};

void fireRoutine(bool isColored) // <- ******* для оригинальной прошивки Gunner47 ******* (раскомментить/закоментить)
{
  if (loadingFlag) {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      setModeSettings(random8(30U) ? 1U + random8(100U) : 100U, 200U + random8(35U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    //FastLED.clear();
    generateLine();
    //memset(matrixValue, 0, sizeof(matrixValue)); без очистки
    pcnt = 0;
  }
  if (pcnt >= 30) {                                         // внутренний делитель кадров для поднимающегося пламени
    shiftUp();                                              // смещение кадра вверх
    generateLine();                                         // перерисовать новую нижнюю линию случайным образом
    pcnt = 0;
  }
  //  drawFrame(pcnt, (strcmp(isColored, "C") == 0));           // прорисовка экрана
  drawFrame(pcnt, isColored);                              // для прошивки где стоит логический параметр
  pcnt += 25;  // делитель кадров: задает скорость подъема пламени 25/100 = 1/4
}

// Randomly generate the next line (matrix row)
void generateLine() {
  for (uint8_t x = 0U; x < WIDTH; x++) {
    line[x] = random(127, 255);                             // заполнение случайным образом нижней линии (127, 255) - менее контрастное, (64, 255) - оригинал
  }
}

void shiftUp() {                                            //подъем кадра
  for (uint8_t y = HEIGHT - 1U; y > 0U; y--) {
    for (uint8_t x = 0U; x < WIDTH; x++) {
      uint8_t newX = x % 16U;                               // сократил формулу без доп. проверок
      if (y > 7U) continue;
      matrixValue[y][newX] = matrixValue[y - 1U][newX];     //смещение пламени (только для зоны очага)
    }
  }

  for (uint8_t x = 0U; x < WIDTH; x++) {                    // прорисовка новой нижней линии
    uint8_t newX = x % 16U;                                 // сократил формулу без доп. проверок
    matrixValue[0U][newX] = line[newX];
  }
}

// draw a frame, interpolating between 2 "key frames"
// @param pcnt percentage of interpolation

void drawFrame(uint8_t pcnt, bool isColored) {                  // прорисовка нового кадра
  int32_t nextv;
#ifdef UNIVERSE_FIRE                                            // если определен универсальный огонь  
  //  uint8_t baseHue = (float)modes[currentMode].Scale * 2.55;
  uint8_t baseHue = (float)(modes[currentMode].Scale - 1U) * 2.6;
#else
  uint8_t baseHue = isColored ? 255U : 0U;
#endif
  uint8_t baseSat = (modes[currentMode].Scale < 100) ? 255U : 0U;  // вычисление базового оттенка


  //first row interpolates with the "next" line
  deltaHue = random(0U, 2U) ? constrain (shiftHue[0] + random(0U, 2U) - random(0U, 2U), 15U, 17U) : shiftHue[0]; // random(0U, 2U)= скорость смещения языков чем больше 2U - тем медленнее
  // 15U, 17U - амплитуда качания -1...+1 относительно 16U
  // высчитываем плавную дорожку смещения всполохов для нижней строки
  // так как в последствии координаты точки будут исчисляться из остатка, то за базу можем принять кратную ширину матрицы hueMask
  // ширина матрицы hueMask = 16, поэтому нам нужно получить диапазон чисел от 15 до 17
  // далее к предыдущему значению прибавляем случайную 1 и отнимаем случайную 1 - это позволит плавным образом менять значение смещения
  shiftHue[0] = deltaHue;                                   // заносим это значение в стэк

  deltaValue = random(0U, 3U) ? constrain (shiftValue[0] + random(0U, 2U) - random(0U, 2U), 15U, 17U) : shiftValue[0]; // random(0U, 3U)= скорость смещения очага чем больше 3U - тем медленнее
  // 15U, 17U - амплитуда качания -1...+1 относительно 16U
  shiftValue[0] = deltaValue;


  for (uint8_t x = 0U; x < WIDTH; x++) {                                          // прорисовка нижней строки (сначала делаем ее, так как потом будем пользоваться ее значением смещения)
    uint8_t newX = x % 16;                                                        // сократил формулу без доп. проверок
    nextv =                                                               // расчет значения яркости относительно valueMask и нижерасположенной строки.
      (((100.0 - pcnt) * matrixValue[0][newX] + pcnt * line[newX]) / 100.0)
      - pgm_read_byte(&valueMask[0][(x + deltaValue) % 16U]);
    CRGB color = CHSV(                                                            // вычисление цвета и яркости пикселя
                   baseHue + pgm_read_byte(&hueMask[0][(x + deltaHue) % 16U]),    // H - смещение всполохов
                   baseSat,                                                       // S - когда колесо масштаба =100 - белый огонь (экономим на 1 эффекте)
                   (uint8_t)max(0, nextv)                                         // V
                 );
    leds[XY(x, 0)] = color;                                            // прорисовка цвета очага
  }

  //each row interpolates with the one before it
  for (uint8_t y = HEIGHT - 1U; y > 0U; y--) {                                      // прорисовка остальных строк с учетом значения низлежащих
    deltaHue = shiftHue[y];                                                         // извлекаем положение
    shiftHue[y] = shiftHue[y - 1];                                                  // подготавлеваем значение смешения для следующего кадра основываясь на предыдущем
    deltaValue = shiftValue[y];                                                     // извлекаем положение
    shiftValue[y] = shiftValue[y - 1];                                              // подготавлеваем значение смешения для следующего кадра основываясь на предыдущем


    if (y > 8U) {                                                                   // цикл стирания текущей строоки для искр
      for (uint8_t _x = 0U; _x < WIDTH; _x++) {                                     // стираем строчку с искрами (очень не оптимально)
        drawPixelXY(_x, y, 0U);
      }
    }
    for (uint8_t x = 0U; x < WIDTH; x++) {                                          // пересчет координаты x для текущей строки
      uint8_t newX = x % 16U;                                                       // функция поиска позиции значения яркости для матрицы valueMask
      if (y < 8U) {                                                                 // если строка представляет очаг
        nextv =                                                                     // расчет значения яркости относительно valueMask и нижерасположенной строки.
          (((100.0 - pcnt) * matrixValue[y][newX]
            + pcnt * matrixValue[y - 1][newX]) / 100.0)
          - pgm_read_byte(&valueMask[y][(x + deltaValue) % 16U]);

        CRGB color = CHSV(                                                                  // определение цвета пикселя
                       baseHue + pgm_read_byte(&hueMask[y][(x + deltaHue) % 16U ]),         // H - смещение всполохов
                       baseSat,                                                             // S - когда колесо масштаба =100 - белый огонь (экономим на 1 эффекте)
                       (uint8_t)max(0, nextv)                                               // V
                     );
        leds[XY(x, y)] = color;
      }
      else if (y == 8U && SPARKLES) {                                               // если это самая нижняя строка искр - формитуем искорку из пламени
        if (random(0, 20) == 0 && getPixColorXY(x, y - 1U) != 0U) drawPixelXY(x, y, getPixColorXY(x, y - 2U));  // 20 = обратная величина количества искр
        else drawPixelXY(x, y, 0U);
      }
      else if (SPARKLES) {                                                          // если это не самая нижняя строка искр - перемещаем искорку выше
        // старая версия для яркости
        newX = (random(0, 4)) ? x : (x + WIDTH + random(0U, 2U) - random(0U, 2U)) % WIDTH ;   // с вероятностью 1/3 смещаем искорку влево или вправо
        if (getPixColorXY(x, y - 1U) > 0U) drawPixelXY(newX, y, getPixColorXY(x, y - 1U));    // рисуем искорку на новой строчке
      }
    }
  }
}

// ------------- радуга три в одной -------------
void rainbowHorVertRoutine(bool isVertical) {
  for (uint8_t i = 0U; i < (isVertical ? WIDTH : HEIGHT); i++) {
    CHSV thisColor = CHSV((uint8_t)(hue + i * (modes[currentMode].Scale % 67U) * 2U), 255U, 255U);

    for (uint8_t j = 0U; j < (isVertical ? HEIGHT : WIDTH); j++)
      drawPixelXY((isVertical ? i : j), (isVertical ? j : i), thisColor);
  }
}
void rainbowRoutine() {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
  if (selectedSettings) {
    uint8_t tmp = 7U + random8(50U);
    if (tmp > 14) tmp += 19U;
    if (tmp > 67) tmp += 6U;
    setModeSettings(tmp , 150U + random8(86U));
  }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

  hue += 4U;
  if (modes[currentMode].Scale < 34U)           // если масштаб до 34
    rainbowHorVertRoutine(false);
  else if (modes[currentMode].Scale > 67U)      // если масштаб больше 67
    rainbowHorVertRoutine(true);
  else                                          // для масштабов посередине
    for (uint8_t i = 0U; i < WIDTH; i++)
      for (uint8_t j = 0U; j < HEIGHT; j++)
      {
        float twirlFactor = 9.0F * ((modes[currentMode].Scale - 33) / 100.0F);    // на сколько оборотов будет закручена матрица, [0..3]
        CRGB thisColor = CHSV((uint8_t)(hue + ((float)WIDTH / (float)HEIGHT * i + j * twirlFactor) * ((float)255 / (float)maxDim)), 255U, 255U);
        drawPixelXY(i, j, thisColor);
      }
}

// -------------- эффект пульс ------------
// Stefan Petrick's PULSE Effect mod by PalPalych for GyverLamp

//void drawCircle(int16_t x0, int16_t y0, uint16_t radius, const CRGB & color) {
void drawCircle(int x0, int y0, int radius, const CRGB &color) {
  int a = radius, b = 0;
  int radiusError = 1 - a;

  if (radius == 0) {
    drawPixelXY(x0, y0, color);
    return;
  }

  while (a >= b)  {
    drawPixelXY(a + x0, b + y0, color);
    drawPixelXY(b + x0, a + y0, color);
    drawPixelXY(-a + x0, b + y0, color);
    drawPixelXY(-b + x0, a + y0, color);
    drawPixelXY(-a + x0, -b + y0, color);
    drawPixelXY(-b + x0, -a + y0, color);
    drawPixelXY(a + x0, -b + y0, color);
    drawPixelXY(b + x0, -a + y0, color);
    b++;
    if (radiusError < 0)
      radiusError += 2 * b + 1;
    else
    {
      a--;
      radiusError += 2 * (b - a + 1);
    }
  }
}


void pulseRoutine(uint8_t PMode) {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
  if (selectedSettings) {
    setModeSettings(1U + random8(100U), 170U + random8(62U));
  }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

  CRGB _pulse_color;


  dimAll(248U);
  uint8_t _sat;
  if (step <= pcnt) {
    for (uint8_t i = 0; i < step; i++ ) {
      uint8_t _dark = qmul8( 2U, cos8 (128U / (step + 1U) * (i + 1U))) ;
      switch (PMode) {
        case 1U:                    // 1 - случайные диски
          deltaHue = hue;
          _pulse_color = CHSV(deltaHue, 255U, _dark);
          break;
        case 2U:                    // 2...17 - перелив цвета дисков
          deltaHue2 = modes[currentMode].Scale;
          _pulse_color = CHSV(hue2, 255U, _dark);
          break;
        case 3U:                    // 18...33 - выбор цвета дисков
          deltaHue = modes[currentMode].Scale * 2.55;
          _pulse_color = CHSV(deltaHue, 255U, _dark);
          break;
        case 4U:                    // 34...50 - дискоцветы
          deltaHue += modes[currentMode].Scale;
          _pulse_color = CHSV(deltaHue, 255U, _dark);
          break;
        case 5U:                    // 51...67 - пузыри цветы
          _sat =  qsub8( 255U, cos8 (128U / (step + 1U) * (i + 1U))) ;
          deltaHue += modes[currentMode].Scale;
          _pulse_color = CHSV(deltaHue, _sat, _dark);
          break;
        case 6U:                    // 68...83 - выбор цвета пузырей
          _sat =  qsub8( 255U, cos8 (128U / (step + 1U) * (i + 1U))) ;
          deltaHue = modes[currentMode].Scale * 2.55;
          _pulse_color = CHSV(deltaHue, _sat, _dark);
          break;
        case 7U:                    // 84...99 - перелив цвета пузырей
          _sat =  qsub8( 255U, cos8 (128U / (step + 1U) * (i + 1U))) ;
          deltaHue2 = modes[currentMode].Scale;
          _pulse_color = CHSV(hue2, _sat, _dark);
          break;
        case 8U:                    // 100 - случайные пузыри
          _sat =  qsub8( 255U, cos8 (128U / (step + 1U) * (i + 1U))) ;
          //deltaHue = hue; // вместо этого будет решулировка сдвига оттенка
          //_pulse_color = CHSV(deltaHue, _sat, _dark);
          deltaHue2 = modes[currentMode].Scale;
          _pulse_color = CHSV(hue2, _sat, _dark);
          break;
      }
      drawCircle(emitterX, emitterY, i, _pulse_color  );
    }
  } else {
    emitterX = random8(WIDTH - 5U) + 3U;
    emitterY = random8(HEIGHT - 5U) + 3U;
    hue2 += deltaHue2;
    hue = random8(0U, 255U);
    pcnt = random8(WIDTH >> 2U, (WIDTH >> 1U) + 1U);
    step = 0;
  }
  step++;
  //if (modes[currentMode].Speed & 0x01) blurScreen(10U);// убираем квадратики внутри кругов пульса
}

// ------------- цвет + вода в бассейне ------------------
// (с) SottNick. 03.2020
// эффект иммеет шов на стыке краёв матрицы (сзади лампы, как и у других эффектов), зато адаптирован для нестандартных размеров матриц.
// можно было бы сделать абсолютно бесшовный вариант для конкретной матрицы (16х16), но уже была бы заметна зацикленность анимации.

// далее идёт массив из 25 кадров анимации с маской бликов на воде (размер картинки больше размера матрицы, чтобы повторяемость картинки была незаметной)
// бесшовную анимированную текстуру бликов делал в программе Substance Designer (30 дней бесплатно работает) при помощи плагина Bruno Caustics Generator
// но сразу под такой мелкий размер текстура выходит нечёткой, поэтому пришлось делать крупную и потом в фотошопе доводить её до ума
// конвертировал в массив через сервис https://littlevgl.com/image-to-c-array,
// чтобы из ч/б картинки получить массив для коррекции параметра насыщенности цвета, использовал настройки True color -> C array
// последовательность замен полученных блоков массива в ворде: "^p  0x"->"^p  {0x"  ...  ", ^p"->"},^p" ... "},^p#endif"->"}^p },^p {"
static const uint8_t aquariumGIF[25][32][32] PROGMEM =
{
  {
    {0x00, 0x00, 0x00, 0x00, 0x34, 0x8f, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x89, 0xe1, 0x77, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x37, 0x9b, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x7f, 0xdd, 0x77, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x37, 0x94, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x88, 0x78, 0x7a, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x4a, 0x71, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x17, 0x38, 0x87, 0x62, 0x00, 0x21, 0x67, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x77, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x20, 0x1b, 0x19, 0x46, 0x2e, 0x00, 0x00, 0x3e, 0x73, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x02, 0x55, 0xc7, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x1f, 0x07, 0x00, 0x00, 0x02, 0x14, 0x00, 0x00, 0x1a, 0xa6, 0x8f, 0x4c, 0x22, 0x04, 0x00, 0x00, 0x00},
    {0x0d, 0x20, 0x62, 0xb3, 0xc8, 0x97, 0x47, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x47, 0x74, 0x6a, 0x70, 0x77, 0x6c, 0x4d, 0x29, 0x11},
    {0x7b, 0x95, 0x9b, 0x60, 0x31, 0x42, 0x61, 0x67, 0x5d, 0x28, 0x00, 0x00, 0x02, 0x23, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0x59, 0x4a, 0x3e, 0x0e, 0x01, 0x0a, 0x27, 0x4d, 0x6a, 0x79, 0x7c},
    {0xc5, 0xb1, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x69, 0x82, 0x44, 0x0f, 0x2e, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xb6, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x25, 0x6c},
    {0x82, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0x82, 0x83, 0x79, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xc2, 0x83, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e},
    {0x5e, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xab, 0xec, 0x8f, 0x31, 0x21, 0x28, 0x39, 0x59, 0xa2, 0xc4, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x5d, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6d, 0xed, 0xb9, 0x7d, 0x6e, 0x6d, 0x65, 0x55, 0x43, 0x66, 0x5e, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x5c, 0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6d, 0x99, 0x3d, 0x1d, 0x18, 0x10, 0x02, 0x00, 0x00, 0x13, 0x5a, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x56, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x83, 0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x50, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x4d, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x98, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x41, 0x5d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xb4, 0x97, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x54, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x31, 0x61, 0x07, 0x00, 0x00, 0x00, 0x00, 0x12, 0x5b, 0x90, 0x77, 0x60, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x38, 0x78, 0x2d, 0x00, 0x00, 0x0b, 0x43, 0x7e, 0x79, 0x35, 0x06, 0x0d, 0x35, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x54, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x70, 0xc3, 0x96, 0x48, 0x4d, 0x79, 0x81, 0x4c, 0x0b, 0x00, 0x00, 0x00, 0x02, 0x2f, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x7b, 0x54, 0x2f, 0x27, 0x22, 0x1f, 0x30},
    {0xbf, 0xc9, 0xa6, 0xad, 0xae, 0x72, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x33, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0xa3, 0xac, 0x81, 0x7a, 0x78, 0x78, 0x8e},
    {0x92, 0x5a, 0x22, 0x5b, 0x83, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x35, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x74, 0x71, 0x3a, 0x27, 0x27, 0x2d, 0x37, 0x61},
    {0x46, 0x18, 0x00, 0x00, 0x4d, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x34, 0x07, 0x00, 0x00, 0x00, 0x00, 0x26, 0x62, 0x51, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10},
    {0x2f, 0x09, 0x00, 0x00, 0x32, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x33, 0x03, 0x00, 0x04, 0x30, 0x50, 0x3a, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01},
    {0x2f, 0x0d, 0x00, 0x00, 0x1e, 0x48, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x3b, 0x22, 0x3d, 0x39, 0x1e, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03},
    {0x46, 0x1f, 0x00, 0x00, 0x0f, 0x4f, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x65, 0x6c, 0x2f, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01},
    {0x74, 0x5f, 0x10, 0x00, 0x16, 0x69, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19},
    {0x4b, 0x42, 0x3a, 0x39, 0x5b, 0x91, 0x6f, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x5b, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x4e},
    {0x00, 0x00, 0x09, 0x2e, 0x79, 0x81, 0x75, 0x72, 0x53, 0x43, 0x3d, 0x37, 0x2f, 0x29, 0x24, 0x1e, 0x20, 0x4e, 0x7b, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x2f, 0x3f, 0x1f},
    {0x00, 0x00, 0x00, 0x00, 0x37, 0x65, 0x60, 0x81, 0x72, 0x67, 0x69, 0x6b, 0x6d, 0x6f, 0x6f, 0x6c, 0x71, 0x98, 0xb2, 0x55, 0x17, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x3e, 0x30, 0x06, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x11, 0x6c, 0x75, 0x32, 0x0a, 0x08, 0x0a, 0x0d, 0x12, 0x18, 0x1f, 0x24, 0x2d, 0x4a, 0x8e, 0x93, 0x4a, 0x16, 0x00, 0x00, 0x00, 0x16, 0x36, 0x39, 0x16, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x0e, 0x7d, 0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x88, 0x9c, 0x45, 0x11, 0x18, 0x32, 0x3a, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x1f, 0x84, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0xb1, 0xa5, 0x60, 0x46, 0x26, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
  },
  {
    {0x00, 0x00, 0x00, 0x00, 0x38, 0x59, 0x0a, 0x00, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x93, 0x8d, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x46, 0x73, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xa5, 0xa1, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x5f, 0x75, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x22, 0x30, 0x58, 0xc6, 0xd3, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x70, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x32, 0x28, 0x18, 0x19, 0x6d, 0xd7, 0x8b, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x1b, 0x7f, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x34, 0x28, 0x08, 0x00, 0x00, 0x00, 0x09, 0x8d, 0xc3, 0x7f, 0x2a, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x6d, 0xc6, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x50, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 0xca, 0xa2, 0x7a, 0x6e, 0x54, 0x2c, 0x08, 0x00, 0x00, 0x00},
    {0x0b, 0x24, 0x70, 0xba, 0xc5, 0x95, 0x44, 0x07, 0x00, 0x00, 0x00, 0x00, 0x53, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7b, 0xa6, 0x36, 0x2c, 0x4e, 0x70, 0x7f, 0x76, 0x57, 0x2f, 0x13},
    {0x8e, 0xa8, 0x9b, 0x51, 0x28, 0x44, 0x68, 0x67, 0x43, 0x12, 0x00, 0x26, 0x71, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x91, 0x5c, 0x00, 0x00, 0x00, 0x05, 0x24, 0x4c, 0x6c, 0x80, 0x88},
    {0xd6, 0xac, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x2b, 0x58, 0x64, 0x66, 0x9e, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x9c, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x74},
    {0x8b, 0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x6c, 0xeb, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0xb7, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15},
    {0x6b, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x92, 0xef, 0x77, 0x1e, 0x15, 0x1d, 0x30, 0x53, 0xab, 0xd5, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03},
    {0x6b, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xea, 0xd1, 0x7f, 0x73, 0x76, 0x72, 0x68, 0x5f, 0x7f, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    {0x6a, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xaf, 0x5d, 0x2d, 0x26, 0x1e, 0x0c, 0x00, 0x00, 0x23, 0x62, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02},
    {0x65, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x76, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3d, 0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x5d, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2b, 0x94, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x59, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x50, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x8a, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x54, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x43, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xc3, 0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x4c, 0x90, 0x34, 0x00, 0x00, 0x00, 0x00, 0x20, 0x6a, 0x9b, 0x8b, 0x5a, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x57, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x8f, 0xe2, 0xac, 0x63, 0x43, 0x3e, 0x65, 0x8b, 0x73, 0x31, 0x11, 0x30, 0x32, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x5b, 0x12, 0x00, 0x00, 0x00, 0x00, 0x20},
    {0xb5, 0x93, 0x7f, 0x84, 0xa4, 0xc5, 0xa5, 0x52, 0x06, 0x00, 0x00, 0x00, 0x21, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x69, 0x80, 0x4c, 0x3a, 0x41, 0x5a, 0x99},
    {0x3d, 0x03, 0x00, 0x07, 0x39, 0x9d, 0x6e, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x75, 0xaa, 0x82, 0x73, 0x88, 0xba, 0xab},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0x58, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x55, 0x6e, 0x34, 0x15, 0x14, 0x34, 0x7a, 0x4a},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x55, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x2f, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x4f, 0x5d, 0x12, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x21},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x52, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x32, 0x08, 0x00, 0x00, 0x00, 0x03, 0x4e, 0x5a, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x20},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x30, 0x02, 0x00, 0x06, 0x4a, 0x5c, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0x49},
    {0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0x32, 0x1c, 0x4b, 0x5f, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x71, 0x7c},
    {0x4a, 0x3a, 0x1e, 0x04, 0x00, 0x01, 0x6b, 0x94, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x5d, 0x6d, 0x5d, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x46, 0x36, 0x34},
    {0x02, 0x21, 0x39, 0x41, 0x45, 0x6a, 0xa9, 0xac, 0x84, 0x63, 0x4d, 0x3f, 0x36, 0x30, 0x2c, 0x29, 0x2d, 0x41, 0x81, 0x81, 0x3a, 0x03, 0x00, 0x00, 0x00, 0x00, 0x18, 0x35, 0x30, 0x0e, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x1c, 0x5d, 0xa5, 0x7b, 0x33, 0x4e, 0x7a, 0x72, 0x60, 0x5f, 0x63, 0x65, 0x64, 0x65, 0x73, 0xa6, 0x94, 0x42, 0x07, 0x00, 0x00, 0x13, 0x30, 0x35, 0x1a, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x24, 0x67, 0x23, 0x00, 0x00, 0x1d, 0x13, 0x05, 0x07, 0x0d, 0x12, 0x17, 0x1c, 0x29, 0x5c, 0xa7, 0x7e, 0x28, 0x1c, 0x2f, 0x37, 0x22, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x1e, 0x4b, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x69, 0xb7, 0x80, 0x50, 0x28, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x2a, 0x4d, 0x01, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0xb0, 0xa5, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
  },
  {
    {0x00, 0x00, 0x00, 0x0a, 0x54, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00, 0x02, 0x50, 0x9c, 0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x0f, 0x5c, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x0c, 0x25, 0x42, 0x85, 0xd7, 0x81, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x13, 0x67, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x2f, 0x41, 0x40, 0x34, 0x2b, 0x40, 0xb6, 0xbe, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x17, 0x7b, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x7a, 0x47, 0x0f, 0x00, 0x00, 0x00, 0x37, 0xcd, 0x8b, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x33, 0x8b, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4d, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x95, 0xed, 0x7b, 0x2d, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x0b, 0x8a, 0xc9, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x5f, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x69, 0xe5, 0x9d, 0x75, 0x6f, 0x59, 0x31, 0x0c, 0x00, 0x00, 0x00},
    {0x11, 0x33, 0x84, 0xbe, 0xbc, 0x8e, 0x41, 0x07, 0x00, 0x00, 0x00, 0x00, 0x46, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x73, 0x9d, 0x32, 0x25, 0x47, 0x6c, 0x7e, 0x77, 0x5b, 0x35, 0x19},
    {0x9c, 0xb1, 0x8f, 0x40, 0x21, 0x43, 0x68, 0x68, 0x44, 0x11, 0x00, 0x18, 0x6b, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x8d, 0x5c, 0x00, 0x00, 0x00, 0x02, 0x1e, 0x45, 0x67, 0x7f, 0x8d},
    {0xd8, 0x99, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x5a, 0x65, 0x62, 0x96, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x9c, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x76},
    {0x8a, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x69, 0xe8, 0xab, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xac, 0x7b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c},
    {0x70, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xea, 0x72, 0x14, 0x0a, 0x11, 0x23, 0x47, 0xaa, 0xd6, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b},
    {0x71, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xe3, 0xe0, 0x80, 0x6f, 0x75, 0x75, 0x73, 0x75, 0x8e, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c},
    {0x71, 0x3d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xb6, 0x7c, 0x3e, 0x34, 0x2b, 0x17, 0x04, 0x01, 0x34, 0x62, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a},
    {0x6d, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6d, 0x8a, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05},
    {0x65, 0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x90, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x5b, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x58, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x8f, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x52, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x90, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x51, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x6c, 0xaf, 0x48, 0x05, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x83, 0xa6, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x57, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0xba, 0xe8, 0xb8, 0x85, 0x62, 0x45, 0x2f, 0x44, 0x81, 0xa7, 0x82, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x47},
    {0x93, 0x5e, 0x5a, 0x6b, 0x83, 0x9f, 0xbd, 0xb7, 0x7f, 0x37, 0x2f, 0x3b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x57, 0x40, 0x06, 0x03, 0x1b, 0x68, 0xaa},
    {0x07, 0x00, 0x00, 0x00, 0x04, 0x2d, 0x97, 0x9e, 0x2c, 0x00, 0x00, 0x17, 0x2a, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x7e, 0x72, 0x6a, 0x9b, 0xa8, 0x52},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x68, 0x20, 0x00, 0x00, 0x00, 0x16, 0x26, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x88, 0x8e, 0xa5, 0xb2, 0x3e, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0x30, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x61, 0x3b, 0x1d, 0x55, 0x5c, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x5a, 0x29, 0x00, 0x00, 0x2e, 0x47, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x2c, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x59, 0x28, 0x00, 0x00, 0x00, 0x44, 0x7a, 0x1c, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x89, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x2d, 0x04, 0x00, 0x00, 0x00, 0x20, 0x59, 0x30, 0x00, 0x00, 0x02, 0x28, 0x51, 0x67, 0x5e, 0x1d},
    {0x38, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x7d, 0xb8, 0x84, 0x43, 0x17, 0x00, 0x00, 0x00, 0x02, 0x32, 0x37, 0x0d, 0x03, 0x24, 0x5a, 0x3b, 0x04, 0x01, 0x1a, 0x2f, 0x2c, 0x13, 0x0b, 0x31, 0x4f},
    {0x36, 0x45, 0x38, 0x23, 0x14, 0x33, 0x79, 0x7b, 0x50, 0x50, 0x64, 0x6f, 0x5e, 0x43, 0x38, 0x3d, 0x4e, 0x72, 0x6a, 0x54, 0x6e, 0x50, 0x1c, 0x22, 0x35, 0x2f, 0x14, 0x00, 0x00, 0x00, 0x00, 0x0c},
    {0x00, 0x0d, 0x32, 0x5c, 0x8a, 0xa1, 0x5c, 0x0c, 0x00, 0x00, 0x07, 0x38, 0x74, 0x6f, 0x58, 0x57, 0x5f, 0x74, 0xa0, 0xbf, 0x8b, 0x4a, 0x42, 0x38, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x19, 0x82, 0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x0a, 0x0b, 0x12, 0x1d, 0x4a, 0xa9, 0xb1, 0x6c, 0x33, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x51, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x5d, 0xa9, 0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x03, 0x4d, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x85, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
  },
  {
    {0x00, 0x00, 0x00, 0x36, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x3f, 0x7a, 0x28, 0x00, 0x00, 0x00, 0x0b, 0x70, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x3a, 0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x9c, 0x94, 0x2a, 0x0f, 0x07, 0x33, 0x8c, 0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x3d, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x97, 0x69, 0x3a, 0x2c, 0x3f, 0x95, 0xcb, 0x5d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x40, 0x53, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x65, 0x37, 0x00, 0x00, 0x00, 0x10, 0x62, 0xe5, 0xa0, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x54, 0x78, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0xf4, 0x84, 0x31, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x1f, 0xa9, 0xcf, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5c, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xe1, 0x9d, 0x74, 0x70, 0x5c, 0x36, 0x10, 0x00, 0x00, 0x00},
    {0x18, 0x45, 0x97, 0xbf, 0xb6, 0x8b, 0x42, 0x07, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0x9d, 0x30, 0x21, 0x41, 0x66, 0x7b, 0x78, 0x5e, 0x3b, 0x1f},
    {0xa8, 0xb5, 0x80, 0x2f, 0x1b, 0x42, 0x68, 0x69, 0x44, 0x11, 0x00, 0x11, 0x6a, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x8a, 0x5f, 0x00, 0x00, 0x00, 0x00, 0x19, 0x3f, 0x61, 0x7e, 0x92},
    {0xd7, 0x83, 0x02, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x5b, 0x66, 0x60, 0x8e, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x9b, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x78},
    {0x88, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x66, 0xe4, 0xb1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xa2, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24},
    {0x73, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x81, 0xe5, 0x6d, 0x0b, 0x01, 0x07, 0x16, 0x3a, 0xa4, 0xd5, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14},
    {0x75, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xd9, 0xea, 0x80, 0x6a, 0x70, 0x74, 0x7a, 0x8a, 0x99, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15},
    {0x76, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0xbc, 0x9e, 0x55, 0x42, 0x39, 0x23, 0x0d, 0x09, 0x44, 0x5d, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12},
    {0x73, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x9c, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x52, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d},
    {0x6c, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x85, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x58, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06},
    {0x60, 0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x63, 0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x7f, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x55, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x96, 0xd0, 0x65, 0x1e, 0x03, 0x00, 0x00, 0x00, 0x05, 0x6d, 0x5d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0x51, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12},
    {0xd1, 0xd9, 0xb6, 0x9d, 0x88, 0x66, 0x40, 0x2d, 0x65, 0x91, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x47, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x18, 0x7d},
    {0x64, 0x2e, 0x33, 0x4b, 0x6e, 0x8c, 0x9e, 0xb9, 0xe2, 0x94, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x55, 0x2e, 0x01, 0x06, 0x3b, 0x94, 0xa7},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x2e, 0x8d, 0xd7, 0x95, 0x3b, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x65, 0x47, 0x68, 0xa6, 0x7d, 0x1f},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x78, 0x74, 0x44, 0x32, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x66, 0xba, 0xbc, 0x61, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x47, 0x5e, 0x15, 0x20, 0x27, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x7a, 0xda, 0x7e, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0x5f, 0x0e, 0x00, 0x1a, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x50, 0x8d, 0xac, 0x51, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2b, 0x7d, 0x33, 0x00, 0x00, 0x29, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x55, 0x7f, 0x76, 0x7d, 0x6b, 0x13, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xb8, 0x84, 0x3b, 0x17, 0x1f, 0x39, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x69, 0x94, 0x6a, 0x3a, 0x23, 0x46, 0x58, 0x1c, 0x00},
    {0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4b, 0x8e, 0x75, 0x63, 0x68, 0x66, 0x54, 0x52, 0x54, 0x27, 0x0a, 0x01, 0x02, 0x0a, 0x2d, 0x81, 0xa2, 0x61, 0x1b, 0x00, 0x00, 0x01, 0x2e, 0x57, 0x39},
    {0x4e, 0x2e, 0x0b, 0x00, 0x00, 0x20, 0x68, 0x77, 0x34, 0x05, 0x02, 0x13, 0x3a, 0x6a, 0x87, 0x9c, 0x9c, 0x7c, 0x66, 0x65, 0x76, 0xa6, 0xab, 0x51, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x47},
    {0x1f, 0x43, 0x55, 0x5a, 0x74, 0x92, 0x5d, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x5f, 0xa7, 0xb6, 0x8a, 0x6d, 0x85, 0xcd, 0xcb, 0x55, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x20, 0x79, 0xb9, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x6b, 0x53, 0x0a, 0x00, 0x0d, 0x71, 0x93, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x37, 0x6d, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x4f, 0x17, 0x00, 0x00, 0x00, 0x1f, 0x74, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x2d, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x56, 0x0c, 0x00, 0x00, 0x00, 0x0c, 0x69, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
  },
  {
    {0x00, 0x00, 0x07, 0x51, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x68, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x7b, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x0c, 0x53, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x7c, 0x7b, 0x01, 0x00, 0x00, 0x00, 0x00, 0x29, 0x7e, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x0e, 0x51, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xc2, 0x61, 0x23, 0x16, 0x0a, 0x05, 0x56, 0x90, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x0d, 0x51, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x74, 0x6d, 0x33, 0x29, 0x2d, 0x33, 0x5c, 0xc1, 0xbf, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x15, 0x64, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x06, 0x30, 0xbf, 0xfe, 0x91, 0x38, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x45, 0xb2, 0x96, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x56, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xdb, 0x99, 0x6e, 0x69, 0x5b, 0x38, 0x14, 0x00, 0x00, 0x00},
    {0x1f, 0x57, 0xa3, 0xb8, 0xad, 0x8f, 0x49, 0x09, 0x00, 0x00, 0x00, 0x00, 0x33, 0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x94, 0x2c, 0x1b, 0x37, 0x5b, 0x72, 0x72, 0x5c, 0x3d, 0x23},
    {0xaa, 0xad, 0x6a, 0x25, 0x1e, 0x40, 0x68, 0x68, 0x40, 0x0f, 0x00, 0x0a, 0x63, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x13, 0x35, 0x56, 0x76, 0x90},
    {0xc7, 0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x58, 0x61, 0x58, 0x7f, 0x7c, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x92, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x75},
    {0x7e, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x61, 0xd6, 0xb2, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x90, 0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a},
    {0x6d, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xe7, 0x80, 0x11, 0x00, 0x00, 0x0b, 0x2b, 0x93, 0xc6, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d},
    {0x70, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xdc, 0xe1, 0x91, 0x7c, 0x73, 0x71, 0x79, 0x96, 0x98, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e},
    {0x72, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xa0, 0x58, 0x50, 0x70, 0x68, 0x3a, 0x1a, 0x13, 0x50, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b},
    {0x70, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x83, 0x41, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x0a, 0x52, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15},
    {0x6a, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x59, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x4d, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c},
    {0x63, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x80, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    {0x72, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x50, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05},
    {0xba, 0xdc, 0x7e, 0x3f, 0x1c, 0x03, 0x00, 0x00, 0x3c, 0x84, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31},
    {0xc1, 0xae, 0xa0, 0x9d, 0x99, 0x84, 0x65, 0x62, 0x9d, 0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x4a, 0x2e, 0x00, 0x00, 0x00, 0x01, 0x42, 0xa3},
    {0x2f, 0x0d, 0x12, 0x27, 0x4b, 0x70, 0x93, 0xd7, 0xe2, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x53, 0x25, 0x05, 0x1b, 0x6a, 0xa6, 0x7e},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x68, 0xd2, 0x7b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x63, 0x55, 0x8c, 0x9e, 0x48, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xae, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x78, 0xc5, 0x9d, 0x27, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0xa2, 0x7d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x92, 0xc5, 0x36, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xc6, 0x61, 0x14, 0x0c, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x4e, 0xcb, 0x9a, 0x09, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xe1, 0xd8, 0x7d, 0x31, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x4f, 0x9e, 0xa7, 0x84, 0x2d, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x8c, 0x95, 0x9b, 0xb0, 0x8b, 0x40, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x1c, 0x67, 0x9c, 0x70, 0x33, 0x44, 0x5f, 0x23, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x7e, 0x56, 0x1c, 0x18, 0x48, 0x99, 0xad, 0x7c, 0x57, 0x48, 0x3f, 0x38, 0x39, 0x55, 0x8c, 0xa1, 0x58, 0x0f, 0x00, 0x01, 0x2a, 0x59, 0x3a, 0x03},
    {0x25, 0x00, 0x00, 0x00, 0x00, 0x12, 0x5e, 0x7b, 0x36, 0x00, 0x00, 0x00, 0x00, 0x28, 0x98, 0xdd, 0xb7, 0x91, 0x8c, 0x99, 0xa2, 0xa0, 0xa8, 0x5a, 0x05, 0x00, 0x00, 0x00, 0x00, 0x16, 0x4e, 0x52},
    {0x4e, 0x4b, 0x36, 0x27, 0x4d, 0x84, 0x64, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0x9f, 0x5b, 0x23, 0x23, 0x38, 0x6e, 0x89, 0x6e, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2b},
    {0x02, 0x2c, 0x66, 0xa5, 0xae, 0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3d, 0x59, 0x00, 0x00, 0x00, 0x00, 0x03, 0x67, 0x6c, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x17, 0x89, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x7a, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x01, 0x56, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x7d, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
  },
  {
    {0x00, 0x00, 0x30, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x61, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x20, 0x2b, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x36, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x81, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x24, 0x32, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x38, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0xaa, 0x5f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x2e, 0x35, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x36, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0xad, 0xac, 0x3e, 0x27, 0x20, 0x16, 0x16, 0x43, 0x46, 0x46, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x41, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x7b, 0x2a, 0x19, 0x20, 0x2b, 0x3a, 0x75, 0xa0, 0x76, 0x84, 0x71, 0x25, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x10, 0x78, 0xa1, 0x45, 0x14, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0xa5, 0xce, 0xa2, 0x83, 0x72, 0x5e, 0x40, 0x26, 0x12, 0x02, 0x00},
    {0x47, 0x78, 0xb7, 0xb4, 0x94, 0x89, 0x60, 0x10, 0x00, 0x00, 0x00, 0x00, 0x29, 0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xb5, 0x43, 0x1f, 0x36, 0x5b, 0x7c, 0x7a, 0x63, 0x5b, 0x54},
    {0xbe, 0xbc, 0x62, 0x26, 0x2e, 0x4c, 0x6d, 0x6e, 0x40, 0x0e, 0x00, 0x03, 0x5a, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0x5f, 0x00, 0x00, 0x00, 0x01, 0x20, 0x24, 0x1e, 0x33, 0x72},
    {0x98, 0x72, 0x00, 0x00, 0x00, 0x00, 0x02, 0x2d, 0x56, 0x5e, 0x53, 0x72, 0x7d, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x8a, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d},
    {0x5a, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x61, 0xd0, 0xc2, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x81, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x67, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x86, 0xfd, 0xad, 0x42, 0x22, 0x14, 0x0d, 0x24, 0x88, 0xb8, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08},
    {0x81, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xcd, 0xa5, 0x83, 0x7e, 0x83, 0x8f, 0x94, 0xaa, 0x98, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31},
    {0x7d, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x89, 0x5e, 0x0e, 0x0e, 0x1d, 0x32, 0x54, 0x5a, 0x3b, 0x5f, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37},
    {0x70, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x53, 0x75, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0c, 0x21, 0x50, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20},
    {0x67, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x81, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13},
    {0x66, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x4b, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b},
    {0x87, 0x76, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x81, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x48, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14},
    {0xd5, 0xdd, 0x94, 0x63, 0x3e, 0x1a, 0x07, 0x18, 0x7d, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x5e},
    {0x9c, 0x7d, 0x82, 0x90, 0x9c, 0x97, 0x8d, 0xac, 0xaf, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x4b, 0x20, 0x00, 0x00, 0x00, 0x1b, 0x75, 0xb2},
    {0x0b, 0x00, 0x00, 0x0a, 0x27, 0x4e, 0x86, 0xee, 0xcf, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x4e, 0x1e, 0x0d, 0x3e, 0x93, 0x99, 0x49},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5d, 0xcc, 0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x65, 0x6f, 0xa5, 0x7b, 0x19, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x81, 0xab, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x96, 0xca, 0x6c, 0x03, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0xb0, 0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2b, 0xad, 0x99, 0x08, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc4, 0x43, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x6d, 0xc7, 0x58, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5d, 0xf2, 0xdb, 0x6b, 0x26, 0x10, 0x18, 0x13, 0x00, 0x00, 0x00, 0x00, 0x03, 0x14, 0x31, 0x69, 0xb0, 0xb7, 0x5b, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x8e, 0xa8, 0xad, 0xbc, 0xb7, 0x8e, 0x5b, 0x3b, 0x29, 0x27, 0x34, 0x46, 0x56, 0x63, 0x77, 0x9f, 0x84, 0x55, 0x67, 0x36, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x7f, 0x64, 0x24, 0x1a, 0x43, 0x9c, 0xdc, 0xce, 0xa6, 0x9b, 0x99, 0x84, 0x6e, 0x55, 0x3d, 0x44, 0x60, 0x3d, 0x0f, 0x24, 0x59, 0x3f, 0x03, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x56, 0x81, 0x42, 0x01, 0x00, 0x00, 0x00, 0x24, 0xa0, 0xce, 0x7b, 0x62, 0x72, 0x69, 0x33, 0x07, 0x00, 0x11, 0x3d, 0x1b, 0x00, 0x00, 0x14, 0x50, 0x55, 0x21},
    {0x47, 0x20, 0x03, 0x03, 0x38, 0x7b, 0x6f, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x71, 0x59, 0x00, 0x00, 0x00, 0x1e, 0x28, 0x00, 0x00, 0x0a, 0x34, 0x0c, 0x00, 0x00, 0x00, 0x02, 0x34, 0x59},
    {0x39, 0x5e, 0x73, 0x90, 0x99, 0x4d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x64, 0x23, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x00, 0x12, 0x34, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c},
    {0x00, 0x12, 0x79, 0xb5, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x61, 0x13, 0x00, 0x00, 0x00, 0x00, 0x01, 0x19, 0x04, 0x1a, 0x33, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x37, 0x62, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x5e, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x17, 0x22, 0x32, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
  },
  {
    {0x00, 0x05, 0x4e, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x59, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x11, 0x30, 0x04, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x09, 0x4b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x02, 0x00, 0x00, 0x13, 0x2d, 0x01, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x0c, 0x4c, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x6f, 0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x01, 0x00, 0x00, 0x19, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x0b, 0x49, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x71, 0xb2, 0x3c, 0x03, 0x00, 0x00, 0x00, 0x09, 0x24, 0x00, 0x00, 0x00, 0x45, 0x57, 0x0a, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x1b, 0x57, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xb6, 0x6e, 0x2f, 0x28, 0x29, 0x37, 0x5b, 0x44, 0x17, 0x20, 0x4d, 0x86, 0x91, 0x5d, 0x27, 0x0d, 0x00, 0x00},
    {0x30, 0x4c, 0x94, 0x65, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x61, 0x43, 0x04, 0x0a, 0x16, 0x26, 0x5f, 0xa0, 0x82, 0x6d, 0x5e, 0x4d, 0x40, 0x4f, 0x7c, 0x87, 0x6d, 0x5b, 0x45},
    {0x93, 0xb8, 0xca, 0xa0, 0x70, 0x5c, 0x4f, 0x25, 0x00, 0x00, 0x00, 0x00, 0x20, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x75, 0xc1, 0x67, 0x16, 0x00, 0x00, 0x00, 0x2b, 0x38, 0x30, 0x40, 0x61},
    {0x5e, 0xcc, 0x86, 0x3b, 0x3d, 0x57, 0x76, 0x74, 0x43, 0x0e, 0x00, 0x00, 0x4b, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x85, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x13, 0x7a, 0x34, 0x00, 0x00, 0x00, 0x08, 0x2d, 0x51, 0x57, 0x4b, 0x61, 0x78, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x12, 0x62, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x5e, 0xbf, 0xd1, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x82, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x1f, 0x63, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x97, 0xee, 0xa9, 0x6a, 0x50, 0x41, 0x35, 0x46, 0xab, 0xa2, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x31, 0x61, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x89, 0x81, 0x4a, 0x4e, 0x5e, 0x67, 0x6a, 0x87, 0xd6, 0xb9, 0x34, 0x00, 0x00, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x4f, 0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x78, 0x12, 0x00, 0x00, 0x00, 0x00, 0x05, 0x13, 0x57, 0xa5, 0x68, 0x0b, 0x00, 0x00, 0x02, 0x07, 0x01, 0x00, 0x00, 0x00, 0x00},
    {0x80, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x79, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x63, 0x75, 0x19, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x02, 0x1c},
    {0x88, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0x6d, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x4c},
    {0x72, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x7a, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x48, 0x52, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a},
    {0x99, 0x81, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x5f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x24, 0x3f, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a},
    {0xcb, 0xc0, 0x97, 0x79, 0x5c, 0x39, 0x25, 0x55, 0x8b, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x13, 0x10, 0x3f, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x83},
    {0x5f, 0x46, 0x55, 0x6d, 0x85, 0x92, 0xa9, 0xd6, 0x89, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0a, 0x00, 0x17, 0x42, 0x11, 0x00, 0x00, 0x05, 0x42, 0x90, 0x95},
    {0x00, 0x00, 0x00, 0x00, 0x08, 0x28, 0x6e, 0xdd, 0xa4, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x06, 0x00, 0x00, 0x2c, 0x43, 0x18, 0x1e, 0x64, 0x98, 0x67, 0x17},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x59, 0xbd, 0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x03, 0x00, 0x00, 0x06, 0x4a, 0x64, 0x84, 0x95, 0x41, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8b, 0x9b, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x3b, 0xaa, 0xab, 0x31, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0xb0, 0x5b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0c, 0x00, 0x00, 0x00, 0x13, 0x62, 0xba, 0x60, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x86, 0xb3, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x32, 0x22, 0x24, 0x31, 0x40, 0x5c, 0xad, 0xb8, 0x30, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xec, 0xc4, 0x51, 0x17, 0x04, 0x01, 0x0c, 0x3b, 0x71, 0x70, 0x68, 0x67, 0x61, 0x53, 0x52, 0x84, 0xaa, 0x41, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x86, 0xb1, 0xb8, 0xb9, 0xa6, 0x7e, 0x74, 0x8a, 0x9c, 0x8c, 0x69, 0x4b, 0x2d, 0x16, 0x06, 0x06, 0x2f, 0x8f, 0x7b, 0x05, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x76, 0x6a, 0x2d, 0x25, 0x5b, 0xae, 0xf4, 0xeb, 0xb2, 0x77, 0x3d, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x61, 0x87, 0x4e, 0x04, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x7b, 0x49, 0x06, 0x00, 0x00, 0x01, 0x4b, 0xb8, 0x8e, 0x39, 0x2f, 0x2b, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x45, 0x4e, 0x56, 0x4f, 0x1b, 0x00},
    {0x10, 0x00, 0x00, 0x00, 0x25, 0x6b, 0x71, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x75, 0x17, 0x00, 0x00, 0x0e, 0x1b, 0x05, 0x00, 0x00, 0x00, 0x00, 0x07, 0x3b, 0x27, 0x0c, 0x34, 0x58, 0x3f},
    {0x55, 0x4b, 0x41, 0x65, 0x85, 0x51, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x5b, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x14, 0x00, 0x00, 0x00, 0x00, 0x09, 0x35, 0x11, 0x00, 0x00, 0x15, 0x43},
    {0x1a, 0x5f, 0xa8, 0x9e, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x09, 0x00, 0x00, 0x00, 0x0c, 0x31, 0x08, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x12, 0x75, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x0d, 0x00, 0x00, 0x00, 0x0f, 0x30, 0x06, 0x00, 0x00, 0x00, 0x00}
  },
  {
    {0x00, 0x36, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x70, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x2f, 0x06, 0x00, 0x00},
    {0x00, 0x30, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x72, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x2d, 0x02, 0x00, 0x00},
    {0x00, 0x33, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x76, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x3e, 0x02, 0x00, 0x00},
    {0x00, 0x40, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x8c, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x03, 0x00, 0x00, 0x00, 0x02, 0x24, 0x71, 0x87, 0x31, 0x00, 0x00},
    {0x32, 0x61, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0xa1, 0xac, 0x2d, 0x0a, 0x00, 0x00, 0x14, 0x2d, 0x04, 0x00, 0x14, 0x3f, 0x5f, 0x73, 0x86, 0x98, 0x94, 0x68, 0x3d},
    {0x94, 0xbc, 0x9c, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x8c, 0x9a, 0x48, 0x2b, 0x30, 0x57, 0x71, 0x45, 0x35, 0x52, 0x68, 0x5e, 0x40, 0x27, 0x21, 0x43, 0x65, 0x64, 0x6f},
    {0x4d, 0xd7, 0xf3, 0x95, 0x55, 0x38, 0x24, 0x10, 0x03, 0x00, 0x00, 0x00, 0x23, 0x5e, 0x10, 0x00, 0x02, 0x11, 0x47, 0x93, 0x94, 0x84, 0x5a, 0x26, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x09},
    {0x00, 0x6c, 0xc0, 0x79, 0x55, 0x5f, 0x6e, 0x74, 0x57, 0x17, 0x00, 0x00, 0x45, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0xb6, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x39, 0x7b, 0x1b, 0x00, 0x04, 0x1c, 0x3a, 0x54, 0x5b, 0x4c, 0x5c, 0x80, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x38, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x62, 0xc1, 0xe4, 0x7c, 0x2e, 0x10, 0x02, 0x00, 0x30, 0x8d, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x45, 0x5d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xad, 0xba, 0x82, 0x72, 0x68, 0x60, 0x67, 0xbf, 0xc5, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x57, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x82, 0x2b, 0x0c, 0x14, 0x24, 0x33, 0x46, 0x8a, 0xcb, 0x5f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x68, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x74, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x71, 0xa4, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x1a, 0x72, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x90, 0x7d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x55, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x78, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xa8, 0x55, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00},
    {0x9e, 0x5d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x59, 0x5f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xa9, 0x42, 0x0a, 0x06, 0x0d, 0x2a, 0x27, 0x13, 0x13, 0x43},
    {0xdc, 0xa2, 0x49, 0x17, 0x01, 0x00, 0x00, 0x33, 0x7c, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x93, 0x86, 0x24, 0x08, 0x09, 0x0b, 0x18, 0x26, 0x3c, 0x8a},
    {0xbc, 0xa8, 0x96, 0x89, 0x76, 0x5e, 0x5b, 0x93, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x51, 0x78, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x62, 0xab},
    {0x2a, 0x1e, 0x2d, 0x48, 0x66, 0x85, 0xc8, 0xdc, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x4f, 0x3f, 0x07, 0x00, 0x00, 0x23, 0x6e, 0x91, 0x65},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x59, 0xcc, 0x87, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x20, 0x36, 0x35, 0x17, 0x3b, 0x83, 0x80, 0x2f, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xb7, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x22, 0x0b, 0x1d, 0x56, 0x76, 0x97, 0x71, 0x13, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x99, 0x8f, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x37, 0x20, 0x33, 0x83, 0xcf, 0x84, 0x0f, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xb4, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x82, 0x77, 0x64, 0x6b, 0xaa, 0xc8, 0x49, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x93, 0xa6, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x2d, 0x73, 0xa7, 0x96, 0x67, 0x45, 0x37, 0x5c, 0x9f, 0x55, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xec, 0xb1, 0x3f, 0x13, 0x0b, 0x18, 0x3f, 0x77, 0x9c, 0x95, 0x5f, 0x25, 0x09, 0x00, 0x00, 0x10, 0x76, 0x7a, 0x04, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x83, 0xc0, 0xc6, 0xbe, 0xa4, 0x90, 0x97, 0x9b, 0x89, 0x59, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x92, 0x33, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x70, 0x72, 0x37, 0x37, 0x7d, 0xdf, 0xf4, 0xa9, 0x5f, 0x26, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x82, 0x78, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x78, 0x52, 0x0c, 0x00, 0x00, 0x19, 0x8c, 0xb9, 0x57, 0x2b, 0x1d, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xa6, 0x4d, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x18, 0x61, 0x75, 0x32, 0x00, 0x00, 0x00, 0x00, 0x04, 0x73, 0x67, 0x03, 0x00, 0x0c, 0x15, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x89, 0x99, 0x40, 0x06},
    {0x33, 0x14, 0x16, 0x4d, 0x7b, 0x5a, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x73, 0x34, 0x00, 0x00, 0x00, 0x04, 0x0f, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x56, 0x62, 0x5a, 0x4f},
    {0x59, 0x7d, 0x97, 0x84, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x71, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x05, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x40, 0x25, 0x07, 0x26},
    {0x09, 0x6e, 0x91, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x6f, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x34, 0x0d, 0x00, 0x00}
  },
  {
    {0x2b, 0x60, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x39, 0x24},
    {0x1b, 0x42, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x31, 0x13},
    {0x29, 0x48, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x59, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x4f, 0x20},
    {0x58, 0x65, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x32, 0x55, 0x88, 0x9f, 0x69},
    {0xbc, 0xb4, 0x3d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x92, 0x27, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x0a, 0x38, 0x62, 0x75, 0x75, 0x71, 0x78, 0x93, 0xa6},
    {0x7c, 0xe9, 0xa7, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xb4, 0x97, 0x2a, 0x13, 0x12, 0x29, 0x24, 0x05, 0x13, 0x46, 0x72, 0x72, 0x54, 0x32, 0x19, 0x14, 0x24, 0x23, 0x30},
    {0x00, 0x71, 0xef, 0xa5, 0x41, 0x18, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x93, 0x70, 0x39, 0x3c, 0x6a, 0x59, 0x35, 0x51, 0x75, 0x6d, 0x3c, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x07, 0xad, 0xce, 0x7a, 0x60, 0x5b, 0x4e, 0x3a, 0x24, 0x0d, 0x12, 0x57, 0x51, 0x00, 0x00, 0x01, 0x33, 0x7a, 0x8e, 0x7e, 0x3f, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x6c, 0x80, 0x24, 0x1d, 0x34, 0x4b, 0x60, 0x6c, 0x5d, 0x67, 0x9e, 0x5a, 0x00, 0x00, 0x00, 0x03, 0x8e, 0x9b, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x5d, 0x58, 0x00, 0x00, 0x00, 0x00, 0x07, 0x31, 0x74, 0xc7, 0xcb, 0x8b, 0x60, 0x40, 0x39, 0x71, 0xb1, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x64, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5d, 0x9e, 0x58, 0x3b, 0x44, 0x4d, 0x5e, 0xa2, 0xd9, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x09, 0x72, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x71, 0x44, 0x00, 0x00, 0x00, 0x00, 0x03, 0x21, 0x93, 0xa6, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x21, 0x79, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xa4, 0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x42, 0x6e, 0x02, 0x00, 0x00, 0x00, 0x00, 0x18, 0x74, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0xb1, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x6b, 0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7b, 0xa0, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x4e, 0xa1, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x26, 0x72, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x9f, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0xed, 0xe4, 0x84, 0x44, 0x19, 0x09, 0x1a, 0x72, 0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xa5, 0x49, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x2c, 0x34, 0x77},
    {0xc3, 0x9b, 0x8e, 0x88, 0x80, 0x7f, 0xa2, 0x9d, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x69, 0x95, 0x2b, 0x00, 0x00, 0x14, 0x45, 0x93, 0xd1, 0xdd},
    {0x1b, 0x0d, 0x11, 0x21, 0x3c, 0x6c, 0xd0, 0xbd, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x86, 0x86, 0x3b, 0x33, 0x51, 0x91, 0xc2, 0xa0, 0x50},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xba, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x5a, 0x9b, 0x70, 0x57, 0x86, 0x9f, 0x5a, 0x0d, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xac, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x73, 0x9b, 0xa8, 0xad, 0x9c, 0x44, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0xa3, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x88, 0xa8, 0x8f, 0xaa, 0xd3, 0x6f, 0x04, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0xb0, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x75, 0xa4, 0x92, 0x55, 0x30, 0x43, 0x94, 0x6e, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x9b, 0x94, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x06, 0x36, 0x79, 0xa6, 0x9c, 0x5e, 0x1c, 0x00, 0x00, 0x05, 0x5e, 0x86, 0x15, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xe4, 0x9a, 0x33, 0x1a, 0x29, 0x51, 0x84, 0xa4, 0x99, 0x60, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x8f, 0x4b, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x7d, 0xca, 0xd2, 0xc2, 0xae, 0xa5, 0x9c, 0x83, 0x51, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x70, 0x87, 0x07, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x66, 0x77, 0x44, 0x53, 0xb6, 0xe7, 0x98, 0x48, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x9b, 0x4a, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x71, 0x59, 0x13, 0x00, 0x05, 0x53, 0xad, 0x77, 0x29, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x70, 0x91, 0x0d, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x0d, 0x54, 0x75, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x3d, 0x9a, 0x4d, 0x0b, 0x0a, 0x0d, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x9b, 0x65, 0x00},
    {0x02, 0x00, 0x05, 0x39, 0x71, 0x61, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x7d, 0x05, 0x00, 0x00, 0x04, 0x09, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5d, 0xac, 0x4f},
    {0x60, 0x53, 0x70, 0x76, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x8c, 0x99},
    {0x69, 0x9c, 0x74, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x53, 0x58}
  },
  {
    {0x00, 0x39, 0x6e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x7a, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x09, 0x00, 0x00},
    {0x00, 0x36, 0x5d, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x7c, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00},
    {0x00, 0x47, 0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x7c, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x23, 0x00, 0x00},
    {0x1d, 0x74, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x77, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x2f, 0x70, 0x8c, 0x48, 0x15},
    {0xa1, 0xd8, 0x8c, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x69, 0x5d, 0x00, 0x00, 0x00, 0x00, 0x05, 0x01, 0x00, 0x00, 0x00, 0x01, 0x2c, 0x5a, 0x74, 0x80, 0x88, 0x92, 0x97, 0x92},
    {0x77, 0xdb, 0xd8, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x8c, 0x22, 0x00, 0x02, 0x0c, 0x07, 0x00, 0x00, 0x05, 0x39, 0x70, 0x7c, 0x64, 0x41, 0x25, 0x18, 0x27, 0x45, 0x54},
    {0x00, 0x34, 0xca, 0xba, 0x38, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xa4, 0x73, 0x24, 0x14, 0x10, 0x05, 0x0a, 0x34, 0x6f, 0x7b, 0x4f, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x53, 0xd9, 0xa5, 0x55, 0x37, 0x25, 0x13, 0x06, 0x02, 0x1a, 0x70, 0x9f, 0x6e, 0x49, 0x2d, 0x1d, 0x30, 0x62, 0x7b, 0x53, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x16, 0x99, 0x8b, 0x46, 0x43, 0x50, 0x57, 0x59, 0x60, 0x8a, 0xc1, 0xa4, 0x6e, 0x6b, 0x7c, 0x80, 0x8b, 0x73, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x0e, 0x75, 0x48, 0x00, 0x00, 0x0a, 0x26, 0x54, 0x9d, 0xbd, 0x86, 0x65, 0x64, 0x70, 0xaf, 0xee, 0x99, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x14, 0x6f, 0x27, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x7f, 0x57, 0x11, 0x04, 0x08, 0x17, 0x45, 0xb1, 0xa3, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x27, 0x73, 0x15, 0x00, 0x00, 0x00, 0x00, 0x4a, 0x59, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xa8, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x43, 0x6d, 0x03, 0x00, 0x00, 0x00, 0x1d, 0x68, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0xaa, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x63, 0x58, 0x00, 0x00, 0x00, 0x01, 0x5c, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x8c, 0x90, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x17, 0x83, 0x40, 0x00, 0x00, 0x07, 0x43, 0x73, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0xac, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x06, 0x80, 0xa7, 0x49, 0x1c, 0x0e, 0x1a, 0x55, 0x54, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0xad, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x9f, 0xfa, 0xcb, 0x67, 0x29, 0x04, 0x01, 0x2f, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x82, 0x90, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x23, 0x41},
    {0xcc, 0xa2, 0x82, 0x6e, 0x3e, 0x06, 0x00, 0x28, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x93, 0x63, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x51, 0xb1, 0xd6},
    {0x2f, 0x0d, 0x0b, 0x21, 0x41, 0x43, 0x25, 0x39, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x93, 0x44, 0x0a, 0x0b, 0x28, 0x7a, 0xc3, 0xc2, 0x7b},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x59, 0x76, 0x5d, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x88, 0xb9, 0x85, 0x7f, 0xb2, 0xc9, 0x87, 0x29, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x89, 0x9b, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x4e, 0xab, 0xe4, 0xe0, 0xfa, 0xd8, 0x62, 0x09, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0xa9, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x75, 0xa3, 0x95, 0x6b, 0x6d, 0xb0, 0x98, 0x21, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xa0, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x73, 0xa2, 0x96, 0x59, 0x1e, 0x08, 0x0b, 0x49, 0x86, 0x2d, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x98, 0x7a, 0x08, 0x00, 0x00, 0x00, 0x0f, 0x3f, 0x7d, 0xa5, 0x9b, 0x62, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x13, 0x7a, 0x5d, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xcd, 0x7c, 0x33, 0x3b, 0x60, 0x89, 0xa0, 0x90, 0x59, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x53, 0x89, 0x18, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x6f, 0xca, 0xd7, 0xc1, 0xa9, 0x93, 0x72, 0x40, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x8a, 0x5c, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x55, 0x72, 0x54, 0x84, 0xcb, 0x89, 0x33, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0x95, 0x1c, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x60, 0x59, 0x18, 0x03, 0x30, 0x86, 0x68, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x95, 0x84, 0x04},
    {0x0d, 0x00, 0x00, 0x00, 0x05, 0x41, 0x6a, 0x41, 0x04, 0x00, 0x00, 0x11, 0x83, 0x84, 0x22, 0x06, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x62, 0xa0, 0x61},
    {0x66, 0x32, 0x11, 0x32, 0x62, 0x5e, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x11, 0x89, 0x63, 0x02, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x38, 0x3b, 0x56},
    {0x3d, 0x89, 0x95, 0x81, 0x43, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x80, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x1d, 0x00, 0x00},
    {0x00, 0x62, 0xac, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x7a, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x0d, 0x00, 0x00}
  },
  {
    {0x00, 0x00, 0x11, 0x6c, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x0a, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x18, 0x6e, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x07, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x1f, 0x6d, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x0c, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x37, 0x6e, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x70, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x63, 0x61, 0x0b, 0x00, 0x00},
    {0x28, 0x28, 0x71, 0x7e, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x87, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x4f, 0x80, 0xa9, 0xb3, 0x88, 0x5e, 0x40},
    {0x90, 0x9d, 0xda, 0xab, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x82, 0x61, 0x0f, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x68, 0x81, 0x72, 0x57, 0x3d, 0x41, 0x68, 0x91, 0x9d},
    {0x2c, 0x55, 0xbb, 0xdd, 0x60, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x6d, 0x56, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x66, 0x83, 0x60, 0x28, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1c, 0x21},
    {0x00, 0x00, 0x1d, 0xa7, 0xbc, 0x4f, 0x16, 0x05, 0x00, 0x00, 0x05, 0x3e, 0x8e, 0x67, 0x21, 0x07, 0x03, 0x04, 0x18, 0x52, 0x7f, 0x65, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x49, 0xb8, 0x8b, 0x55, 0x4e, 0x53, 0x56, 0x69, 0x9e, 0xc8, 0xae, 0x84, 0x64, 0x4a, 0x51, 0x7c, 0x78, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x2f, 0x8e, 0x64, 0x44, 0x58, 0x70, 0x81, 0xa7, 0xa9, 0x78, 0x70, 0x86, 0xa1, 0xc6, 0xcc, 0x83, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x3f, 0x9b, 0x57, 0x1e, 0x14, 0x17, 0x30, 0x63, 0x4d, 0x10, 0x05, 0x0f, 0x30, 0x88, 0xd5, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x78, 0x9d, 0x27, 0x00, 0x00, 0x00, 0x07, 0x3a, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x04, 0x72, 0xa3, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x2c, 0xad, 0x5b, 0x00, 0x00, 0x00, 0x00, 0x06, 0x33, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x94, 0x7b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x8b, 0x97, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x33, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0xac, 0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x55, 0xb4, 0x3d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x31, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0xa4, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x37, 0xb2, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x30, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x98, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0xaf, 0x8d, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x30, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xa5, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x4c},
    {0xc6, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x30, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0x94, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x72, 0xe2},
    {0x85, 0x59, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x30, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x80, 0x7e, 0x1d, 0x03, 0x04, 0x10, 0x3e, 0x93, 0xca, 0xbd},
    {0x1b, 0x30, 0x43, 0x33, 0x08, 0x00, 0x00, 0x00, 0x00, 0x08, 0x30, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xc3, 0xb1, 0x77, 0x70, 0x8f, 0xc1, 0xb5, 0x68, 0x25},
    {0x00, 0x00, 0x09, 0x30, 0x40, 0x1b, 0x00, 0x00, 0x00, 0x06, 0x31, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x91, 0xd5, 0xde, 0xc9, 0xe1, 0xfa, 0xab, 0x3a, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x19, 0x42, 0x2d, 0x00, 0x00, 0x05, 0x35, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x6e, 0x9d, 0x96, 0x6a, 0x4e, 0x56, 0x81, 0xb6, 0x69, 0x04, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x3b, 0x39, 0x09, 0x09, 0x3a, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x06, 0x35, 0x76, 0x9f, 0x95, 0x5c, 0x20, 0x06, 0x00, 0x00, 0x11, 0x66, 0x70, 0x07, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x43, 0x28, 0x46, 0x3d, 0x05, 0x01, 0x1a, 0x4d, 0x83, 0xa0, 0x92, 0x5b, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x7e, 0x31, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x61, 0x76, 0x82, 0x65, 0x6e, 0x89, 0x95, 0x7f, 0x4a, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x70, 0x70, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x80, 0xc4, 0xdd, 0xb9, 0x87, 0x5b, 0x2e, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xa0, 0x51, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x46, 0x77, 0x8b, 0xb9, 0x86, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x85, 0x90, 0x40},
    {0x52, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x11, 0x4f, 0x56, 0x24, 0x28, 0x73, 0x61, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x3c, 0x31, 0x63},
    {0x4c, 0x65, 0x2c, 0x01, 0x08, 0x33, 0x5b, 0x43, 0x09, 0x00, 0x04, 0x60, 0x72, 0x23, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x2a, 0x08, 0x00, 0x08},
    {0x00, 0x38, 0x7a, 0x71, 0x6f, 0x63, 0x25, 0x00, 0x00, 0x00, 0x00, 0x5d, 0x90, 0x31, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x1c, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x3f, 0xae, 0x87, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x7f, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x13, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x12, 0x7c, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x0d, 0x00, 0x00, 0x00}
  },
  {
    {0x00, 0x00, 0x00, 0x00, 0x5b, 0x5d, 0x00, 0x00, 0x00, 0x00, 0x2f, 0x7c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x0b, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x01, 0x66, 0x56, 0x00, 0x00, 0x00, 0x00, 0x2b, 0x74, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x0a, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x08, 0x6e, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x24, 0x78, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x07, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x13, 0x76, 0x3d, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x7e, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x34, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x3a, 0x86, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x10, 0x71, 0x5c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x59, 0xb8, 0xbc, 0x5d, 0x26, 0x07, 0x00},
    {0x60, 0x47, 0x47, 0x7d, 0x8d, 0x37, 0x00, 0x00, 0x00, 0x00, 0x10, 0x62, 0x4b, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x5c, 0x85, 0x8d, 0x84, 0x86, 0x92, 0x96, 0x8f, 0x7c},
    {0x87, 0x8f, 0xb5, 0xbc, 0x85, 0x64, 0x28, 0x0f, 0x0a, 0x0b, 0x31, 0x6f, 0x4a, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x5b, 0x89, 0x72, 0x3b, 0x0e, 0x00, 0x00, 0x0a, 0x35, 0x74, 0x8d},
    {0x02, 0x19, 0x5a, 0xab, 0xba, 0xaa, 0x84, 0x6d, 0x69, 0x6c, 0x8b, 0xb8, 0x79, 0x23, 0x01, 0x00, 0x00, 0x00, 0x0b, 0x45, 0x81, 0x76, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x69, 0xd1, 0x90, 0x56, 0x50, 0x56, 0x60, 0x7c, 0xb6, 0xcb, 0x92, 0x54, 0x2e, 0x21, 0x38, 0x6f, 0x80, 0x44, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x6d, 0xa0, 0x2e, 0x02, 0x00, 0x00, 0x04, 0x12, 0x42, 0xa2, 0xc3, 0xa5, 0xa0, 0xa6, 0xa7, 0x7f, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x11, 0x9b, 0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x4e, 0x64, 0x50, 0x71, 0xcd, 0xd1, 0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x5a, 0xb0, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x31, 0x00, 0x00, 0x3b, 0xac, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x0d, 0xad, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x1e, 0x00, 0x00, 0x00, 0x51, 0xa6, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x77, 0xb4, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x82, 0x90, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x47, 0xc2, 0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x16, 0x00, 0x00, 0x00, 0x00, 0x21, 0xa6, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0xbe, 0x84, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x53, 0xaa, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x49},
    {0xa1, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x80, 0x8f, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0xbf},
    {0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x93, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x8b, 0xb1},
    {0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0x9c, 0x50, 0x0f, 0x02, 0x00, 0x06, 0x1c, 0x7c, 0xbe, 0x60},
    {0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xae, 0xe3, 0xa2, 0x7c, 0x70, 0x77, 0xa6, 0xe1, 0xad, 0x4b},
    {0x3f, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x87, 0xc1, 0xda, 0xd1, 0xca, 0xd1, 0xf4, 0xf1, 0x97, 0x5c, 0x4e},
    {0x24, 0x3e, 0x31, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x25, 0x00, 0x00, 0x00, 0x03, 0x33, 0x74, 0x9a, 0x92, 0x65, 0x41, 0x40, 0x4d, 0x63, 0x99, 0xac, 0x4f, 0x10, 0x0a},
    {0x00, 0x08, 0x2d, 0x3b, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x43, 0x0e, 0x14, 0x46, 0x80, 0x9e, 0x8d, 0x55, 0x1c, 0x03, 0x00, 0x00, 0x00, 0x01, 0x24, 0x74, 0x5b, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x17, 0x3c, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x85, 0x80, 0x8a, 0x96, 0x81, 0x4a, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x50, 0x8a, 0x2e, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x08, 0x38, 0x33, 0x04, 0x00, 0x00, 0x00, 0x18, 0x8b, 0xd0, 0x9f, 0x67, 0x32, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x42, 0x91, 0x83, 0x28},
    {0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x3f, 0x12, 0x08, 0x1d, 0x79, 0xc4, 0x82, 0x2a, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x48, 0x42, 0x4e, 0x72},
    {0x68, 0x59, 0x0f, 0x00, 0x00, 0x00, 0x06, 0x52, 0x70, 0x6a, 0x96, 0xc7, 0x7c, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x36, 0x00, 0x00, 0x23},
    {0x09, 0x53, 0x6a, 0x2e, 0x00, 0x00, 0x1c, 0x61, 0x88, 0x87, 0xbe, 0xa3, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x33, 0x12, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x38, 0x75, 0x5e, 0x4a, 0x62, 0x4f, 0x22, 0x23, 0x6e, 0x79, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x2f, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x2d, 0x91, 0x9f, 0x49, 0x02, 0x00, 0x00, 0x47, 0x73, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x22, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x65, 0x80, 0x0d, 0x00, 0x00, 0x00, 0x36, 0x80, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x15, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x53, 0x63, 0x00, 0x00, 0x00, 0x00, 0x31, 0x89, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x0d, 0x00, 0x00, 0x00, 0x00}
  },
  {
    {0x00, 0x00, 0x00, 0x00, 0x11, 0x45, 0x2f, 0x39, 0x40, 0x16, 0x00, 0x2f, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x30, 0x3a, 0x0e, 0x3b, 0x50, 0x0b, 0x00, 0x15, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x0d, 0x44, 0x13, 0x00, 0x35, 0x54, 0x09, 0x00, 0x01, 0x2a, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x36, 0x2f, 0x00, 0x00, 0x26, 0x52, 0x0d, 0x00, 0x00, 0x24, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x23, 0x3e, 0x04, 0x00, 0x00, 0x15, 0x52, 0x16, 0x00, 0x00, 0x1b, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x92, 0x98, 0x23, 0x00, 0x00, 0x00, 0x00},
    {0x0d, 0x30, 0x52, 0x15, 0x00, 0x00, 0x00, 0x13, 0x61, 0x3b, 0x00, 0x00, 0x1d, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x49, 0x8c, 0xb8, 0xc5, 0xa2, 0x7b, 0x58, 0x32, 0x15},
    {0xa2, 0x99, 0x46, 0x03, 0x00, 0x00, 0x07, 0x43, 0x9d, 0x9d, 0x3b, 0x16, 0x38, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x47, 0x7e, 0x79, 0x51, 0x27, 0x1e, 0x3d, 0x63, 0x89, 0x9d, 0x9e},
    {0x7c, 0xa2, 0x66, 0x23, 0x18, 0x37, 0x67, 0x86, 0x93, 0x9f, 0x9b, 0x90, 0x93, 0x5e, 0x15, 0x00, 0x00, 0x00, 0x03, 0x33, 0x75, 0x7c, 0x43, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x37, 0x5e},
    {0x00, 0x34, 0x8e, 0x8a, 0x85, 0x83, 0x6a, 0x44, 0x28, 0x2b, 0x50, 0x88, 0xc7, 0xc2, 0x63, 0x21, 0x12, 0x21, 0x5a, 0x7d, 0x53, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x7e, 0xdf, 0x8a, 0x33, 0x09, 0x00, 0x00, 0x00, 0x00, 0x12, 0x4d, 0xaf, 0xd1, 0x9a, 0x71, 0x80, 0x78, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x97, 0xa6, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xa0, 0xdf, 0xe3, 0xa3, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x39, 0xb6, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x7f, 0xab, 0xa3, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x98, 0x92, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x46, 0x3f, 0x8e, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x63, 0xbb, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x35, 0x0d, 0x40, 0x97, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0xc5, 0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x2d, 0x00, 0x00, 0x6b, 0x8f, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x59},
    {0x98, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x25, 0x00, 0x00, 0x14, 0x90, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3d, 0xce},
    {0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x22, 0x00, 0x00, 0x00, 0x3d, 0x98, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x96, 0xb9},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x22, 0x00, 0x00, 0x00, 0x00, 0x63, 0x85, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5d, 0xb9, 0x57},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x23, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x89, 0x7f, 0x2a, 0x0d, 0x03, 0x01, 0x09, 0x42, 0xac, 0x7c, 0x0e},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x27, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x89, 0xe5, 0xc5, 0x97, 0x7f, 0x71, 0x7f, 0xba, 0xa2, 0x32, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x38, 0x05, 0x00, 0x05, 0x3a, 0x7e, 0xa4, 0xb5, 0xba, 0xbc, 0xc2, 0xc7, 0xea, 0xff, 0x8c, 0x25, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x5a, 0x43, 0x4b, 0x75, 0x8b, 0x79, 0x4e, 0x2d, 0x28, 0x32, 0x43, 0x59, 0x7f, 0xc4, 0xca, 0x64, 0x14},
    {0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4b, 0xb1, 0xab, 0x8c, 0x6c, 0x3a, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1f, 0x61, 0xcd, 0xd0, 0x7d},
    {0xa8, 0x55, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xaf, 0xcd, 0x77, 0x2c, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x4e, 0x6c, 0x9f, 0xcc},
    {0xbd, 0xc3, 0x7a, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xa4, 0xc1, 0x56, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0x3d, 0x12, 0x1f, 0x69},
    {0x3b, 0x9e, 0xca, 0x9a, 0x3e, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x9d, 0xbd, 0x52, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x41, 0x0e, 0x00, 0x00, 0x00},
    {0x00, 0x1a, 0x79, 0xc2, 0xb3, 0x59, 0x14, 0x00, 0x00, 0x03, 0x2b, 0x96, 0xba, 0x53, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x30, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x05, 0x53, 0xb1, 0xc2, 0x7c, 0x41, 0x31, 0x48, 0x99, 0xba, 0x57, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x3f, 0x11, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x3b, 0xa9, 0xc1, 0x81, 0x72, 0xa4, 0xc7, 0x69, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x51, 0x97, 0x6c, 0x51, 0x8c, 0x98, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2b, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x6e, 0x4b, 0x26, 0x48, 0x64, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x4f, 0x37, 0x29, 0x28, 0x29, 0x3e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00}
  },
  {
    {0x00, 0x00, 0x00, 0x21, 0x3b, 0x02, 0x0a, 0x65, 0x78, 0x0b, 0x00, 0x00, 0x00, 0x17, 0x3c, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x01, 0x38, 0x17, 0x00, 0x00, 0x53, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x21, 0x2f, 0x00, 0x00, 0x00, 0x45, 0x61, 0x02, 0x00, 0x00, 0x00, 0x00, 0x29, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x0c, 0x35, 0x08, 0x00, 0x00, 0x00, 0x3a, 0x65, 0x08, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x05, 0x35, 0x14, 0x00, 0x00, 0x00, 0x00, 0x28, 0x68, 0x12, 0x00, 0x00, 0x00, 0x00, 0x16, 0x39, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5d, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x6f, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x44, 0xac, 0xd4, 0x88, 0x43, 0x1a, 0x01, 0x00, 0x12},
    {0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x99, 0x86, 0x0c, 0x00, 0x00, 0x00, 0x12, 0x3a, 0x06, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x6a, 0x81, 0x6f, 0x68, 0x7b, 0x89, 0x8c, 0x84, 0x7b, 0x72},
    {0x24, 0x00, 0x00, 0x00, 0x00, 0x07, 0x3b, 0x86, 0xcc, 0xdc, 0x9b, 0x50, 0x1a, 0x07, 0x34, 0x4b, 0x10, 0x00, 0x00, 0x20, 0x5f, 0x77, 0x4e, 0x15, 0x00, 0x00, 0x00, 0x0a, 0x2e, 0x60, 0xad, 0x9c},
    {0x5d, 0x11, 0x00, 0x0e, 0x42, 0x7f, 0x97, 0x8c, 0x70, 0x78, 0x9f, 0xb0, 0xa5, 0x92, 0x9c, 0x79, 0x32, 0x1e, 0x44, 0x71, 0x5a, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x72},
    {0x5c, 0x69, 0x61, 0x8c, 0x9f, 0x80, 0x43, 0x15, 0x06, 0x08, 0x17, 0x3d, 0x73, 0xa7, 0xe1, 0xde, 0x8c, 0x79, 0x75, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c},
    {0x20, 0xb8, 0xd8, 0x8c, 0x3d, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x60, 0xcc, 0xff, 0xaf, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x39, 0xcb, 0x87, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xdf, 0xbf, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x95, 0x9a, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x7e, 0xd2, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a},
    {0xbe, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0xc6, 0x9c, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x7e},
    {0x7b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x8c, 0xc7, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xd0},
    {0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x52, 0xa3, 0x8d, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x9f, 0xae},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x5e, 0x87, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xbe, 0x4f},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2b, 0x37, 0x47, 0x7c, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xaa, 0x7d, 0x0a},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0x33, 0x22, 0x69, 0x92, 0x4e, 0x1f, 0x0e, 0x06, 0x08, 0x26, 0x8f, 0x97, 0x28, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x54, 0x5a, 0x45, 0x7a, 0xca, 0xc9, 0xa4, 0x8f, 0x7d, 0x7a, 0xa7, 0xb5, 0x54, 0x05, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x73, 0x66, 0x7f, 0x8e, 0x82, 0x89, 0x99, 0xa7, 0xb1, 0xc6, 0xfe, 0xc3, 0x46, 0x0a, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x67, 0x45, 0x55, 0x68, 0x37, 0x18, 0x13, 0x19, 0x26, 0x3b, 0x5d, 0x9d, 0xe3, 0xac, 0x40, 0x06},
    {0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x61, 0x32, 0x3b, 0x57, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x51, 0xa4, 0xd9, 0xc9, 0x72},
    {0xb2, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0x62, 0x2f, 0x32, 0x56, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x4d, 0x41, 0x56, 0xb6, 0xed},
    {0xec, 0xe3, 0x6c, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x66, 0x3c, 0x37, 0x58, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x3b, 0x35, 0x02, 0x01, 0x1f, 0x81},
    {0x46, 0xca, 0xfc, 0xa2, 0x35, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x6d, 0x5c, 0x4b, 0x5a, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x48, 0x0a, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x1c, 0x9b, 0xff, 0xd0, 0x7a, 0x50, 0x3c, 0x34, 0x33, 0x4b, 0x85, 0x8e, 0x71, 0x5c, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x09, 0x84, 0xe2, 0xa5, 0x73, 0x64, 0x63, 0x6a, 0x88, 0xc3, 0xaf, 0x64, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x48, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x17, 0x85, 0x76, 0x25, 0x14, 0x1a, 0x2b, 0x5b, 0xb7, 0x9e, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x57, 0x79, 0x18, 0x00, 0x00, 0x1a, 0x51, 0x5f, 0x69, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x44, 0x69, 0x3e, 0x0e, 0x15, 0x42, 0x24, 0x00, 0x2a, 0x45, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x09, 0x45, 0x2f, 0x37, 0x4e, 0x5c, 0x34, 0x00, 0x00, 0x00, 0x3a, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
  },
  {
    {0x00, 0x00, 0x28, 0x18, 0x00, 0x00, 0x35, 0x60, 0x6c, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x49, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x10, 0x24, 0x00, 0x00, 0x00, 0x07, 0x7b, 0x7e, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x48, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x02, 0x23, 0x09, 0x00, 0x00, 0x00, 0x00, 0x60, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x1e, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x6c, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x73, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x78, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x47, 0x02, 0x00, 0x00, 0x00, 0x03, 0x60, 0xa4, 0x4e, 0x0a, 0x00, 0x00, 0x09, 0x2c, 0x1e},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x8b, 0x5f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x47, 0x07, 0x00, 0x00, 0x17, 0x56, 0x87, 0x9d, 0x96, 0x7c, 0x6a, 0x5c, 0x53, 0x2c, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x5b, 0xd0, 0xde, 0x68, 0x19, 0x00, 0x00, 0x00, 0x00, 0x32, 0x4d, 0x15, 0x0f, 0x3d, 0x61, 0x53, 0x2a, 0x0e, 0x1c, 0x3d, 0x6c, 0xa4, 0x6e, 0x06, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x0d, 0x45, 0x85, 0xa8, 0xb2, 0xc0, 0xc6, 0xaf, 0x84, 0x4c, 0x21, 0x22, 0x63, 0x65, 0x47, 0x58, 0x52, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x64, 0x26, 0x00},
    {0x00, 0x00, 0x0d, 0x4b, 0x8f, 0xa3, 0x82, 0x4c, 0x27, 0x26, 0x49, 0x7f, 0xaa, 0xb6, 0xaa, 0xb1, 0xc8, 0xa5, 0x7a, 0x3e, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x52, 0x0f},
    {0x2a, 0x4b, 0x8d, 0xa8, 0x84, 0x3c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x01, 0x1a, 0x45, 0x75, 0xaf, 0xff, 0xe0, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x59},
    {0xb7, 0xaf, 0x86, 0x3c, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x25, 0x91, 0xd4, 0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x8d},
    {0xd7, 0x53, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xac, 0x8e, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xb5},
    {0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x74, 0xb3, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xbf},
    {0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0xac, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x9d, 0x8c},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x7f, 0xa9, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xaa, 0x38},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x51, 0xc0, 0x90, 0x22, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0xa2, 0x6a, 0x03},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x59, 0xbc, 0xc1, 0x79, 0x52, 0x3c, 0x2b, 0x1c, 0x19, 0x33, 0x91, 0x90, 0x21, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x45, 0x66, 0x73, 0x80, 0x63, 0x58, 0x5e, 0x65, 0x64, 0x6a, 0x9f, 0xb5, 0x53, 0x06, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x4f, 0x4f, 0x1f, 0x28, 0x4f, 0x2d, 0x0b, 0x0f, 0x20, 0x2e, 0x42, 0x83, 0x9b, 0x3f, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x56, 0x48, 0x08, 0x00, 0x06, 0x3c, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0x7d, 0x5c, 0x07, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x54, 0x40, 0x00, 0x00, 0x00, 0x00, 0x41, 0x45, 0x08, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x7d, 0xa4, 0x41, 0x03},
    {0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x50, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x05, 0x5e, 0x66, 0x34, 0x21, 0x20, 0x20, 0x33, 0x5c, 0x94, 0xde, 0xc6, 0x5d},
    {0x98, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x5e, 0x2e, 0x1b, 0x21, 0x38, 0x5b, 0x76, 0x63, 0x54, 0x74, 0xc6, 0xe3},
    {0xed, 0xd1, 0x63, 0x1e, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x57, 0x03, 0x00, 0x00, 0x00, 0x00, 0x26, 0x5a, 0x20, 0x00, 0x00, 0x00, 0x19, 0x5b, 0x4f, 0x0d, 0x01, 0x08, 0x2f, 0x94},
    {0x5a, 0xe2, 0xf5, 0xa2, 0x6e, 0x52, 0x44, 0x3b, 0x34, 0x37, 0x5d, 0x76, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x25, 0x5c, 0x23, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x4b, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x05},
    {0x00, 0x3e, 0xc9, 0xbd, 0x7d, 0x6e, 0x6a, 0x6d, 0x6c, 0x74, 0x9e, 0x7d, 0x0c, 0x00, 0x00, 0x00, 0x2e, 0x5c, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x56, 0x8a, 0x37, 0x10, 0x0c, 0x11, 0x16, 0x23, 0x4a, 0x77, 0x5a, 0x1e, 0x1c, 0x4c, 0x5d, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x49, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x15, 0x79, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x65, 0xa1, 0x97, 0x98, 0x6e, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x43, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x69, 0x70, 0x08, 0x00, 0x00, 0x00, 0x00, 0x32, 0x57, 0x42, 0x55, 0x8d, 0x54, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x07, 0x4f, 0x60, 0x39, 0x03, 0x00, 0x00, 0x27, 0x44, 0x0e, 0x00, 0x00, 0x26, 0x58, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x18, 0x3b, 0x15, 0x2d, 0x35, 0x11, 0x28, 0x4b, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x42, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
  },
  {
    {0x08, 0x1a, 0x00, 0x00, 0x00, 0x24, 0x42, 0x1f, 0x42, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x46, 0x00, 0x00, 0x00, 0x38, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x15, 0x07, 0x00, 0x00, 0x00, 0x00, 0x36, 0x77, 0x78, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x56, 0x05, 0x00, 0x00, 0x38, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x88, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x5e, 0x23, 0x00, 0x00, 0x44, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x69, 0x56, 0x0d, 0x16, 0x6a, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x12},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x7b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x81, 0x6b, 0x0f, 0x10, 0x53, 0x7c, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x16, 0x16, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x81, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x7b, 0x1e, 0x00, 0x00, 0x00, 0x64, 0x65, 0x05, 0x00, 0x0e, 0x21, 0x17, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x89, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x51, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xa4, 0x83, 0x43, 0x34, 0x14, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0xbb, 0xc0, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5b, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x8a, 0xa1, 0x71, 0x1f, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x51, 0x9d, 0xd9, 0xf0, 0xc9, 0x8b, 0x4f, 0x1e, 0x01, 0x00, 0x2f, 0x72, 0x1c, 0x00, 0x00, 0x00, 0x0c, 0x39, 0x22, 0x1b, 0x47, 0x39, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x14, 0x57, 0x95, 0xa3, 0x89, 0x5f, 0x5c, 0x89, 0xb2, 0xc2, 0xb3, 0x8f, 0x76, 0x9d, 0x96, 0x24, 0x00, 0x00, 0x18, 0x26, 0x0d, 0x00, 0x00, 0x02, 0x39, 0x29, 0x00, 0x00, 0x00},
    {0x00, 0x11, 0x56, 0x9b, 0xaa, 0x7c, 0x35, 0x09, 0x00, 0x00, 0x03, 0x1b, 0x4a, 0x7e, 0xa0, 0xba, 0xf6, 0xdb, 0x5f, 0x2e, 0x2a, 0x20, 0x05, 0x00, 0x00, 0x00, 0x00, 0x06, 0x40, 0x1d, 0x00, 0x00},
    {0x4b, 0x92, 0xaa, 0x7e, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x3f, 0x88, 0xe0, 0xbe, 0x59, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x4e, 0x24, 0x1a},
    {0xa5, 0x81, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x7a, 0xbf, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0x83, 0x95},
    {0x46, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x95, 0x79, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x47, 0xc6, 0xac},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x6b, 0xa9, 0x4d, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x79, 0xa2, 0x33},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x50, 0xb4, 0x9c, 0x55, 0x37, 0x24, 0x12, 0x06, 0x00, 0x05, 0x4a, 0x9d, 0x51, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x70, 0xa2, 0x6f, 0x55, 0x57, 0x60, 0x5f, 0x55, 0x4e, 0x67, 0xa9, 0x84, 0x1a, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x4f, 0x7e, 0x7c, 0x3b, 0x0f, 0x0c, 0x1f, 0x33, 0x41, 0x4e, 0x80, 0xb7, 0x66, 0x0b, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x58, 0x51, 0x35, 0x51, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x27, 0x83, 0x6f, 0x0d, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x63, 0x40, 0x06, 0x00, 0x38, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0x80, 0x22, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x64, 0x34, 0x00, 0x00, 0x00, 0x20, 0x42, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x84, 0x4e, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x63, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x12, 0x44, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x70, 0x80, 0x16},
    {0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x61, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x41, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x61, 0xbf, 0x73},
    {0x8f, 0x3a, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x5e, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x3e, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x4f, 0x83, 0xd9, 0xf0},
    {0xf3, 0xb8, 0x81, 0x61, 0x4d, 0x41, 0x35, 0x2c, 0x27, 0x36, 0x71, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x4b, 0x1a, 0x00, 0x00, 0x00, 0x18, 0x4c, 0x64, 0x5a, 0x50, 0x60, 0xb8},
    {0x94, 0xbb, 0x80, 0x6f, 0x6d, 0x73, 0x77, 0x76, 0x76, 0x93, 0xb0, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x77, 0x45, 0x16, 0x16, 0x45, 0x6e, 0x57, 0x26, 0x04, 0x00, 0x00, 0x1e},
    {0x1e, 0x82, 0x55, 0x16, 0x0b, 0x11, 0x1a, 0x20, 0x26, 0x3c, 0x74, 0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x65, 0x6f, 0x45, 0x44, 0x71, 0x82, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x4e, 0x67, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x68, 0x4c, 0x07, 0x00, 0x00, 0x00, 0x14, 0x5e, 0x5b, 0x16, 0x08, 0x2e, 0x73, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x21, 0x80, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0xa6, 0x8e, 0x5f, 0x51, 0x5c, 0x7b, 0x5d, 0x0a, 0x00, 0x00, 0x21, 0x49, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x0e, 0x73, 0x68, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x5e, 0x6e, 0x64, 0x65, 0x86, 0xbf, 0x88, 0x17, 0x00, 0x00, 0x00, 0x2a, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x17, 0x44, 0x43, 0x3f, 0x07, 0x00, 0x00, 0x00, 0x07, 0x48, 0x33, 0x00, 0x00, 0x00, 0x0c, 0x5f, 0x71, 0x0e, 0x00, 0x00, 0x00, 0x33, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x20, 0x18, 0x00, 0x27, 0x38, 0x09, 0x00, 0x03, 0x40, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x5c, 0x27, 0x00, 0x00, 0x00, 0x37, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
  },
  {
    {0x03, 0x00, 0x00, 0x00, 0x17, 0x40, 0x16, 0x00, 0x17, 0x4c, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x76, 0x6a, 0x69, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x4c, 0x36, 0x58, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x92, 0xa7, 0x94, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2b, 0x89, 0x7c, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x95, 0x49, 0x31, 0x77, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x09, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0x59, 0x00, 0x00, 0x13, 0x75, 0x3a, 0x00, 0x00, 0x00, 0x0b, 0x0b, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0x7f, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x72, 0x14, 0x00, 0x00, 0x00, 0x21, 0x80, 0x33, 0x12, 0x14, 0x0b, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x86, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x5d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0x9a, 0x42, 0x0b, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x89, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x65, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x95, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x9f, 0x91, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x6c, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x75, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x71, 0xda, 0xfb, 0xa6, 0x52, 0x1d, 0x00, 0x00, 0x00, 0x4d, 0x6a, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0x72, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x1d, 0x5e, 0x95, 0xa6, 0x97, 0x9a, 0xb7, 0xc2, 0xb4, 0x8f, 0x63, 0x5b, 0x9a, 0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x81, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x1d, 0x64, 0x9e, 0x9f, 0x6d, 0x31, 0x11, 0x0d, 0x1e, 0x48, 0x7e, 0xa4, 0xb5, 0xce, 0xfd, 0x9c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x6e, 0x70, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x18, 0x5d, 0x9c, 0xa2, 0x6c, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x38, 0x72, 0xc1, 0xd7, 0x69, 0x0b, 0x00, 0x10, 0x2e, 0x46, 0x2b, 0x25, 0x3d, 0x16, 0x00, 0x00, 0x00, 0x00},
    {0x90, 0x9f, 0x6d, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x33, 0x94, 0xc5, 0x8c, 0x64, 0x59, 0x42, 0x15, 0x00, 0x00, 0x18, 0x39, 0x1c, 0x0b, 0x1a, 0x4f},
    {0x74, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x97, 0xdf, 0xaf, 0x6f, 0x41, 0x22, 0x0b, 0x00, 0x08, 0x3d, 0x5f, 0x63, 0x86, 0x98},
    {0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x68, 0x99, 0x6a, 0x56, 0x57, 0x56, 0x4f, 0x46, 0x44, 0x5e, 0xa6, 0xbe, 0x88, 0x3d},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x78, 0x68, 0x1e, 0x0b, 0x15, 0x29, 0x39, 0x44, 0x4f, 0x70, 0xba, 0x9b, 0x2e, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x5d, 0x92, 0x52, 0x07, 0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x26, 0x7c, 0x7b, 0x19, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x5a, 0x63, 0x67, 0x4f, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0x80, 0x2a, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x65, 0x41, 0x11, 0x2d, 0x50, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x83, 0x52, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0x68, 0x30, 0x00, 0x00, 0x08, 0x49, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x71, 0x7b, 0x0f},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x68, 0x25, 0x00, 0x00, 0x00, 0x00, 0x3d, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x90, 0x38},
    {0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x69, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x86, 0x71},
    {0x53, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x6b, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xa8},
    {0xb7, 0x70, 0x53, 0x43, 0x34, 0x27, 0x1c, 0x15, 0x15, 0x2f, 0x78, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x56, 0xcb},
    {0x95, 0x67, 0x63, 0x6b, 0x74, 0x78, 0x77, 0x73, 0x79, 0xad, 0x98, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x3d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x47, 0x90, 0xcb},
    {0x72, 0x23, 0x0b, 0x0d, 0x19, 0x26, 0x2f, 0x35, 0x41, 0x73, 0x86, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x49, 0x5d, 0x55, 0x5b, 0x8d},
    {0x6f, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x4d, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x34, 0x00, 0x00, 0x00, 0x03, 0x3c, 0x65, 0x4f, 0x21, 0x02, 0x00, 0x2c},
    {0x54, 0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x60, 0x4c, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x32, 0x00, 0x00, 0x17, 0x58, 0x5e, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x2e, 0x81, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x9b, 0x92, 0x56, 0x36, 0x20, 0x17, 0x3f, 0x78, 0x43, 0x12, 0x2f, 0x68, 0x47, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x1e, 0x62, 0x57, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x86, 0x8b, 0x7f, 0x81, 0x82, 0x92, 0xb8, 0xa3, 0x62, 0x5d, 0x76, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x1e, 0x1c, 0x22, 0x42, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0x4e, 0x19, 0x00, 0x03, 0x12, 0x29, 0x5d, 0xb4, 0x8d, 0x4c, 0x6e, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x13, 0x00, 0x00, 0x17, 0x40, 0x13, 0x00, 0x00, 0x00, 0x21, 0x46, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x47, 0x74, 0x38, 0x4d, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06}
  },
  {
    {0x00, 0x00, 0x00, 0x07, 0x3e, 0x24, 0x00, 0x00, 0x00, 0x3c, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x98, 0xf8, 0xd9, 0xa2, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x01, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x09, 0x3f, 0x28, 0x03, 0x31, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x95, 0x6c, 0x34, 0x72, 0x74, 0x0b, 0x00, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x4c, 0x53, 0x65, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0x74, 0x00, 0x00, 0x02, 0x68, 0x6d, 0x0b, 0x03, 0x07, 0x03, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x90, 0x80, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x79, 0x2d, 0x00, 0x00, 0x00, 0x07, 0x86, 0x7d, 0x2e, 0x06, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x89, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3d, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xaa, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x8a, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x84, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x8a, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x77, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x75, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x90, 0x6d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x72, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0xc1, 0xe8, 0x71, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x68, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x74, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x66, 0xa0, 0xbc, 0xcd, 0xcb, 0xb3, 0x8f, 0x5e, 0x39, 0x4d, 0x9a, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x75, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x29, 0x6e, 0x9a, 0x92, 0x66, 0x37, 0x2b, 0x4a, 0x7a, 0xa3, 0xb4, 0xb5, 0xd8, 0xeb, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x71, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x27, 0x6d, 0x9d, 0x94, 0x5a, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x35, 0x64, 0xa6, 0xed, 0xb9, 0x32, 0x00, 0x00, 0x00, 0x00, 0x16, 0x78, 0x70, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x63, 0x97, 0x93, 0x58, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x66, 0xc7, 0xb7, 0x70, 0x5b, 0x61, 0x76, 0xae, 0xda, 0x97, 0x44, 0x13, 0x04, 0x02, 0x06, 0x23},
    {0x90, 0x5c, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x69, 0xd5, 0xd1, 0xab, 0xa8, 0xa8, 0xab, 0xaa, 0xa8, 0x99, 0x78, 0x53, 0x45, 0x65, 0x8d},
    {0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x4d, 0x97, 0x75, 0x44, 0x32, 0x29, 0x23, 0x27, 0x40, 0x68, 0x90, 0xb3, 0xbe, 0xa4, 0x6d},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x77, 0x81, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x26, 0x7d, 0xc1, 0x6e, 0x13},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x5b, 0x86, 0x70, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x7f, 0x5e, 0x03},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x63, 0x4f, 0x39, 0x59, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x66, 0x75, 0x10},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x6a, 0x35, 0x00, 0x00, 0x3f, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x8b, 0x33},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0x6b, 0x25, 0x00, 0x00, 0x00, 0x21, 0x4c, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x88, 0x63},
    {0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x6c, 0x20, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x4d, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x67, 0x8c},
    {0x64, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x6f, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x49, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xa1},
    {0xbe, 0x68, 0x38, 0x26, 0x18, 0x0e, 0x06, 0x02, 0x05, 0x2c, 0x7b, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x98},
    {0xaf, 0x7d, 0x68, 0x6d, 0x70, 0x6e, 0x69, 0x65, 0x77, 0xaf, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x7e},
    {0x65, 0x1e, 0x13, 0x21, 0x31, 0x3e, 0x46, 0x4d, 0x67, 0xa6, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x73},
    {0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0x6d, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x50, 0x80},
    {0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x49, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x44, 0x56, 0x7e, 0x92},
    {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x5d, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x4f, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x04, 0x39, 0x5c, 0x46, 0x29, 0x3a, 0x7b},
    {0x71, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x8b, 0x8d, 0x4b, 0x26, 0x11, 0x10, 0x50, 0x5b, 0x06, 0x00, 0x00, 0x00, 0x16, 0x52, 0x51, 0x1f, 0x00, 0x00, 0x00, 0x49},
    {0x2f, 0x46, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x85, 0xaa, 0x95, 0x89, 0x84, 0x94, 0xb9, 0x70, 0x0f, 0x00, 0x00, 0x25, 0x5a, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20},
    {0x00, 0x0c, 0x3c, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x53, 0x39, 0x10, 0x11, 0x24, 0x3e, 0x71, 0xc8, 0xaf, 0x41, 0x16, 0x37, 0x5f, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x0b},
    {0x00, 0x00, 0x06, 0x3d, 0x27, 0x00, 0x00, 0x00, 0x00, 0x07, 0x45, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xc1, 0xc3, 0x95, 0x83, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00}
  },
  {
    {0x00, 0x00, 0x00, 0x2d, 0x38, 0x01, 0x00, 0x00, 0x00, 0x1f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0xd2, 0xf3, 0xa4, 0xb2, 0xd1, 0x77, 0x17, 0x06, 0x03, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x2f, 0x36, 0x02, 0x00, 0x0d, 0x45, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xaa, 0x52, 0x1d, 0x34, 0x8b, 0xa6, 0x55, 0x1c, 0x01, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x3b, 0x15, 0x45, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x73, 0x5b, 0x00, 0x00, 0x00, 0x00, 0x8f, 0x95, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x6a, 0x6a, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x82, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x33, 0x94, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x86, 0x87, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x5f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x81, 0x47, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5b, 0x90, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x7f, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6d, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x8b, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x75, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x88, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0x73, 0x01, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x9c, 0xbc, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x09, 0x7a, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x6b, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x2d, 0x79, 0xc1, 0xe5, 0xc2, 0x8b, 0x5a, 0x2e, 0x1a, 0x50, 0x95, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0x59, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x04, 0x31, 0x6e, 0x90, 0x8a, 0x69, 0x5a, 0x7a, 0x9d, 0xaf, 0xaa, 0xa3, 0xd3, 0xc8, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x78, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x05, 0x32, 0x73, 0x96, 0x83, 0x49, 0x14, 0x00, 0x00, 0x01, 0x12, 0x34, 0x5e, 0x8a, 0xd2, 0xf4, 0x83, 0x12, 0x00, 0x00, 0x00, 0x00, 0x10, 0x70, 0x92, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x2f, 0x6e, 0x94, 0x82, 0x45, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x3d, 0xa1, 0xd9, 0x9b, 0x68, 0x64, 0x71, 0x84, 0xad, 0xea, 0xca, 0x6e, 0x2c, 0x09, 0x02, 0x01, 0x09},
    {0x8c, 0x7f, 0x44, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x3c, 0xb3, 0xe4, 0xb8, 0xb1, 0xb3, 0xb0, 0xaa, 0xa3, 0xa5, 0xa7, 0x93, 0x70, 0x4a, 0x48, 0x6f},
    {0x51, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x8d, 0x86, 0x4f, 0x3b, 0x31, 0x26, 0x1d, 0x1c, 0x29, 0x4b, 0x78, 0xa0, 0xbc, 0xb7, 0x91},
    {0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x67, 0x92, 0x4b, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x3b, 0xa1, 0xb4, 0x47},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x5e, 0x68, 0x6d, 0x49, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x85, 0x3b},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0x68, 0x41, 0x12, 0x32, 0x53, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x7b, 0x5a},
    {0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x6b, 0x2b, 0x00, 0x00, 0x06, 0x4b, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x66, 0x7f},
    {0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x6c, 0x20, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3d, 0x91},
    {0x83, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x6e, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x4a, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x8e},
    {0xae, 0x73, 0x26, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x78, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x4d, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x66},
    {0xa0, 0xb1, 0x71, 0x61, 0x5e, 0x58, 0x51, 0x4f, 0x6d, 0xa0, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x4b, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x35},
    {0x82, 0x67, 0x31, 0x34, 0x44, 0x50, 0x57, 0x60, 0x91, 0xae, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x49, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c},
    {0x6e, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x17, 0x6a, 0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x49, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39},
    {0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x64, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x4b, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x51},
    {0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0x5e, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x49, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x6f},
    {0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x63, 0x9a},
    {0x51, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x7c, 0x81, 0x3e, 0x16, 0x07, 0x17, 0x63, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x1e, 0x2e, 0x60, 0x8a, 0x81},
    {0x40, 0x3d, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x6f, 0xb9, 0xa5, 0x89, 0x82, 0xa6, 0xaf, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x4d, 0x52, 0x56, 0x62, 0x32, 0x1c},
    {0x00, 0x2e, 0x3a, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x52, 0x2b, 0x25, 0x37, 0x54, 0x9b, 0xdb, 0x87, 0x1b, 0x00, 0x00, 0x00, 0x22, 0x54, 0x43, 0x1e, 0x22, 0x13, 0x00, 0x00},
    {0x00, 0x00, 0x2b, 0x3a, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x7b, 0xd7, 0xa1, 0x5f, 0x4c, 0x5a, 0x6c, 0x38, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00}
  },
  {
    {0x00, 0x00, 0x15, 0x3f, 0x11, 0x00, 0x00, 0x00, 0x00, 0x07, 0x3c, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x51, 0xf1, 0xdd, 0x9e, 0x9e, 0xb4, 0xcf, 0xb2, 0x5e, 0x0a, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x17, 0x3e, 0x0f, 0x00, 0x00, 0x00, 0x32, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0xa9, 0x42, 0x21, 0x31, 0x6d, 0xdf, 0xa2, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x1a, 0x3d, 0x10, 0x00, 0x1e, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x85, 0x37, 0x00, 0x00, 0x00, 0x00, 0x55, 0x99, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x42, 0x28, 0x4b, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x85, 0x47, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0x6d, 0x6b, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x79, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x6d, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6b, 0x89, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x7c, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4d, 0x81, 0x07, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x8a, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x86, 0x14, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x7f, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x73, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x85, 0x18, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x7c, 0x87, 0x18, 0x00, 0x00, 0x00, 0x00, 0x20, 0x7f, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x80, 0x15, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x43, 0xa2, 0xce, 0x94, 0x52, 0x29, 0x0f, 0x11, 0x63, 0x89, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4d, 0x72, 0x0b, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x07, 0x30, 0x66, 0x87, 0x8a, 0x87, 0x95, 0xa0, 0x9a, 0x83, 0x76, 0xa3, 0x98, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x69, 0x5f, 0x02, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x09, 0x35, 0x6c, 0x83, 0x6e, 0x3f, 0x18, 0x0e, 0x19, 0x34, 0x5b, 0x7b, 0x96, 0xc2, 0xd0, 0x64, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x5e, 0xa5, 0x59, 0x0d, 0x00, 0x00, 0x00, 0x00},
    {0x0c, 0x35, 0x6c, 0x84, 0x6d, 0x36, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x3c, 0x87, 0xd3, 0xc9, 0x90, 0x70, 0x6f, 0x7a, 0x8c, 0xaa, 0xe2, 0xe3, 0x95, 0x4c, 0x17, 0x04, 0x00, 0x00},
    {0x6d, 0x7f, 0x69, 0x32, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x43, 0x65, 0x9b, 0xcb, 0xbd, 0xb3, 0xb3, 0xad, 0xa2, 0x93, 0x91, 0x9f, 0x9c, 0x84, 0x5d, 0x3d, 0x47},
    {0x77, 0x36, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x2a, 0x20, 0x49, 0x6c, 0x4f, 0x37, 0x2c, 0x21, 0x17, 0x14, 0x19, 0x2e, 0x56, 0x83, 0xa5, 0xb3, 0xa0},
    {0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x2a, 0x0c, 0x0a, 0x3c, 0x40, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x17, 0x53, 0xaf, 0x91},
    {0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x32, 0x1b, 0x09, 0x20, 0x55, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x5d, 0x76},
    {0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x35, 0x30, 0x18, 0x11, 0x1c, 0x55, 0x4d, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x7b},
    {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x36, 0x3d, 0x1c, 0x0a, 0x00, 0x00, 0x25, 0x53, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x7b},
    {0x8f, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x32, 0x43, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x03, 0x4b, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x66},
    {0x88, 0x7f, 0x22, 0x02, 0x00, 0x00, 0x00, 0x00, 0x09, 0x34, 0x40, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x36},
    {0x5c, 0xb0, 0x83, 0x51, 0x44, 0x3e, 0x39, 0x45, 0x54, 0x42, 0x26, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c},
    {0x4d, 0x91, 0x63, 0x42, 0x49, 0x54, 0x5d, 0x79, 0x7a, 0x4d, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x57, 0x67, 0x11, 0x00, 0x00, 0x03, 0x09, 0x17, 0x4c, 0x79, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x67, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x58, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c},
    {0x6f, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x61, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0x3d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26},
    {0x65, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x5f, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48},
    {0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0x58, 0x02, 0x00, 0x00, 0x00, 0x00, 0x47, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x75},
    {0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x6b, 0x71, 0x2e, 0x08, 0x00, 0x29, 0x64, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x64, 0xa6},
    {0x5b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xaf, 0xa9, 0x7f, 0x7c, 0xab, 0x8e, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x63, 0x7c, 0x6b},
    {0x26, 0x43, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x56, 0x46, 0x3a, 0x47, 0x68, 0xbb, 0xc7, 0x56, 0x07, 0x00, 0x00, 0x00, 0x00, 0x12, 0x20, 0x4e, 0x6f, 0x51, 0x1a, 0x07},
    {0x00, 0x16, 0x3e, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x40, 0x14, 0x00, 0x00, 0x00, 0x00, 0x23, 0xa5, 0xc9, 0x7e, 0x4d, 0x37, 0x2d, 0x40, 0x6b, 0x7b, 0x64, 0x27, 0x00, 0x00, 0x00}
  },
  {
    {0x00, 0x04, 0x36, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8b, 0xff, 0xc9, 0xa3, 0xa6, 0xb8, 0xb4, 0x94, 0x88, 0x5c, 0x16, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x04, 0x37, 0x22, 0x00, 0x00, 0x00, 0x00, 0x19, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8b, 0xa3, 0x3b, 0x2a, 0x3d, 0x70, 0xdc, 0xe5, 0x65, 0x07, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x06, 0x39, 0x20, 0x00, 0x00, 0x03, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x8d, 0x17, 0x00, 0x00, 0x00, 0x00, 0x3b, 0xb2, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x08, 0x3b, 0x23, 0x02, 0x30, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x69, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x71, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x46, 0x43, 0x56, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x83, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x88, 0x0f, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x75, 0x58, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2b, 0x8f, 0x26, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x60, 0x4b, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x8c, 0x36, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x8c, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x88, 0x3b, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x58, 0x8c, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x86, 0x35, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x4e, 0x68, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x47, 0x7a, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x7f, 0x24, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x3b, 0x87, 0xa5, 0x77, 0x4a, 0x2b, 0x14, 0x06, 0x0d, 0x41, 0x80, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x78, 0x15, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x0a, 0x32, 0x62, 0x7b, 0x73, 0x64, 0x66, 0x6e, 0x74, 0x70, 0x63, 0x63, 0x82, 0xbf, 0x8e, 0x22, 0x00, 0x00, 0x00, 0x00, 0x10, 0x4e, 0xb3, 0x82, 0x21, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x0d, 0x36, 0x66, 0x77, 0x60, 0x32, 0x0e, 0x02, 0x05, 0x16, 0x3b, 0x6a, 0x95, 0x98, 0x9a, 0xbf, 0xcb, 0xa0, 0x82, 0x7f, 0x87, 0x98, 0xb0, 0xdc, 0xed, 0xb9, 0x72, 0x31, 0x0c, 0x00, 0x00},
    {0x45, 0x67, 0x74, 0x5c, 0x2a, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x37, 0x48, 0x34, 0x32, 0x49, 0x80, 0xaf, 0xc3, 0xc2, 0xb9, 0xb0, 0xa0, 0x8b, 0x7d, 0x8e, 0x9d, 0x94, 0x76, 0x4b, 0x33},
    {0x8d, 0x64, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x23, 0x04, 0x00, 0x00, 0x04, 0x34, 0x72, 0x64, 0x3b, 0x2a, 0x1e, 0x13, 0x0f, 0x10, 0x1b, 0x38, 0x66, 0x8e, 0xa6, 0xa6},
    {0x71, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x20, 0x02, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x4c, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x25, 0x6e, 0xb3},
    {0x61, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x1f, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x49, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x6f},
    {0x7a, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1e, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x52, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x53},
    {0x89, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1d, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x5a, 0x5a, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x3e},
    {0x5e, 0x89, 0x37, 0x01, 0x00, 0x00, 0x12, 0x24, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x35, 0x5a, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x1d},
    {0x27, 0x8b, 0x97, 0x50, 0x3b, 0x45, 0x3f, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x51, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x12, 0x77, 0x92, 0x56, 0x52, 0x6f, 0x52, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x18, 0x72, 0x52, 0x0b, 0x06, 0x1e, 0x49, 0x3c, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x2e, 0x72, 0x25, 0x00, 0x00, 0x00, 0x09, 0x39, 0x3e, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x4d, 0x69, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x50, 0x3c, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x69, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x74, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03},
    {0x76, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x69, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x01, 0x46, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d},
    {0x71, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x47, 0x5d, 0x05, 0x00, 0x00, 0x00, 0x0f, 0x4c, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x47},
    {0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x60, 0x6a, 0x22, 0x00, 0x00, 0x41, 0x59, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x85},
    {0x63, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0x9c, 0xab, 0x7a, 0x7e, 0xa9, 0x68, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x70, 0xac},
    {0x54, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x49, 0x5b, 0x53, 0x5a, 0x84, 0xd2, 0xa5, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x37, 0x71, 0x70, 0x4f},
    {0x0c, 0x3a, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x34, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x51, 0xc3, 0xad, 0x64, 0x42, 0x32, 0x31, 0x31, 0x1c, 0x2d, 0x5e, 0x6f, 0x3f, 0x0b, 0x00}
  },
  {
    {0x00, 0x00, 0x0f, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xee, 0xe7, 0xb7, 0xbe, 0xc6, 0x90, 0x4e, 0x63, 0x9f, 0x5d, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x32, 0x21, 0x00, 0x00, 0x00, 0x06, 0x21, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x81, 0xa7, 0x51, 0x3a, 0x52, 0x88, 0xd6, 0xf0, 0xbd, 0x7b, 0x13, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x2d, 0x56, 0x07, 0x00, 0x04, 0x23, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x8d, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x34, 0xdb, 0xac, 0x2f, 0x05, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x10, 0x49, 0x45, 0x18, 0x2f, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x7a, 0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0xa1, 0x25, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x04, 0x4c, 0x6d, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x83, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x98, 0x3a, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x79, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x8e, 0x54, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x5c, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x71, 0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x84, 0x62, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x50, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x77, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x64, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x75, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x81, 0x5f, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x4e, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x77, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0xa6, 0x61, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x46, 0x71, 0x33, 0x06, 0x00, 0x00, 0x00, 0x00, 0x03, 0x33, 0x9f, 0x90, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x7f, 0xb5, 0x73, 0x1f, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x07, 0x36, 0x7b, 0xa5, 0x89, 0x67, 0x56, 0x52, 0x53, 0x59, 0x6a, 0x8c, 0xbb, 0xc4, 0x88, 0x4a, 0x2b, 0x1d, 0x1f, 0x46, 0x7e, 0x7e, 0x4c, 0x4b, 0x4d, 0x25, 0x00, 0x00},
    {0x02, 0x02, 0x0e, 0x30, 0x5b, 0x72, 0x6d, 0x61, 0x6c, 0x8d, 0xaf, 0xaf, 0xa8, 0xa9, 0xb2, 0x9f, 0x6b, 0x63, 0x7e, 0x8d, 0x96, 0xa1, 0xbb, 0xb5, 0x72, 0x2a, 0x09, 0x06, 0x25, 0x47, 0x3b, 0x14},
    {0x46, 0x47, 0x62, 0x6d, 0x58, 0x2f, 0x10, 0x0c, 0x25, 0x53, 0x5e, 0x4c, 0x41, 0x3f, 0x47, 0x55, 0x41, 0x1c, 0x17, 0x2d, 0x52, 0x87, 0xb8, 0xa0, 0x67, 0x41, 0x22, 0x0f, 0x0b, 0x20, 0x47, 0x57},
    {0x8b, 0x90, 0x5f, 0x26, 0x02, 0x00, 0x00, 0x00, 0x25, 0x1e, 0x01, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x31, 0x29, 0x08, 0x0e, 0x31, 0x4c, 0x47, 0x42, 0x48, 0x4d, 0x4e, 0x4b, 0x43, 0x3a, 0x3b, 0x5b},
    {0x9c, 0x6b, 0x11, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x3c, 0x41, 0x3f, 0x34, 0x11, 0x00, 0x00, 0x00, 0x09, 0x1a, 0x2d, 0x3c, 0x47, 0x51, 0x6c},
    {0x95, 0x5c, 0x02, 0x00, 0x00, 0x01, 0x1a, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0x72, 0x4f, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x21, 0x52},
    {0x77, 0x7e, 0x22, 0x00, 0x05, 0x1d, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x65, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29},
    {0x3a, 0x82, 0x68, 0x2b, 0x2c, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x5f, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x17},
    {0x0a, 0x59, 0xa9, 0x84, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3d, 0x67, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00},
    {0x00, 0x3c, 0xa3, 0x98, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4d, 0x6b, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x44, 0x81, 0x56, 0x51, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x5e, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x5a, 0x70, 0x1c, 0x18, 0x47, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x4e, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x0c, 0x72, 0x56, 0x00, 0x00, 0x0f, 0x46, 0x3d, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x45, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x28, 0x81, 0x31, 0x00, 0x00, 0x00, 0x06, 0x3d, 0x49, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x46, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x4b, 0x7b, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x4f, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x49, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x6c, 0x5f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x50, 0x48, 0x16, 0x00, 0x00, 0x00, 0x00, 0x18, 0x49, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x87, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x5c, 0x73, 0x1b, 0x00, 0x00, 0x00, 0x33, 0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d},
    {0xab, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x73, 0x93, 0x4a, 0x1f, 0x28, 0x73, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f},
    {0x9c, 0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x8a, 0x80, 0x72, 0x97, 0xc3, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x6b, 0xb2},
    {0x1b, 0x48, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x34, 0x15, 0x0e, 0x20, 0x4a, 0x9a, 0xa1, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x7b, 0x74, 0x28},
    {0x00, 0x02, 0x3a, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x21, 0x02, 0x00, 0x00, 0x00, 0x00, 0x25, 0x97, 0xad, 0x68, 0x42, 0x39, 0x38, 0x13, 0x00, 0x00, 0x2f, 0x86, 0x56, 0x00, 0x00}
  },
  {
    {0x00, 0x00, 0x00, 0x27, 0x30, 0x00, 0x00, 0x00, 0x1c, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xa5, 0xe8, 0xb8, 0xb7, 0x9d, 0x55, 0x26, 0x46, 0x89, 0x3a, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x06, 0x3e, 0x10, 0x00, 0x1a, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0x9c, 0x74, 0x49, 0x5c, 0x8b, 0xb8, 0xc2, 0xc0, 0x68, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x36, 0x3e, 0x26, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x70, 0x51, 0x00, 0x00, 0x00, 0x00, 0x38, 0xdd, 0xf6, 0x3a, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x35, 0x76, 0x45, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0xd4, 0x63, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x01, 0x55, 0x9a, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x6a, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9a, 0x94, 0x14, 0x00, 0x00, 0x00},
    {0x01, 0x02, 0x03, 0x11, 0x4f, 0x7c, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x71, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x91, 0x31, 0x08, 0x03, 0x01},
    {0x04, 0x04, 0x03, 0x05, 0x1d, 0x5e, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0x86, 0x1f, 0x05, 0x04, 0x05},
    {0x00, 0x00, 0x00, 0x00, 0x06, 0x4e, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x47, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0x98, 0x1e, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x03, 0x53, 0x51, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4d, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x94, 0x9a, 0x4a, 0x07, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x24, 0x6c, 0x79, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x68, 0x84, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x6f, 0x6a, 0x3c, 0x49, 0x41, 0x15, 0x00},
    {0x08, 0x00, 0x0c, 0x2a, 0x3d, 0x35, 0x3f, 0x56, 0x42, 0x16, 0x00, 0x00, 0x00, 0x03, 0x19, 0x51, 0xa2, 0xc8, 0x7c, 0x28, 0x08, 0x00, 0x0b, 0x3c, 0x6d, 0x4e, 0x0c, 0x00, 0x04, 0x29, 0x46, 0x2b},
    {0x48, 0x3b, 0x42, 0x2b, 0x09, 0x00, 0x00, 0x15, 0x4e, 0x66, 0x57, 0x4c, 0x53, 0x67, 0x7c, 0x82, 0x79, 0x78, 0x8b, 0x88, 0x7c, 0x81, 0x86, 0x76, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x45},
    {0x51, 0x6d, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x81, 0xb8, 0xae, 0xb2, 0xa3, 0x6a, 0x35, 0x14, 0x0a, 0x16, 0x33, 0x57, 0x8a, 0x88, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b},
    {0x24, 0x4d, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x51, 0x74, 0x67, 0x53, 0x53, 0x5b, 0x42, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x47, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x12, 0x3d, 0x0e, 0x00, 0x00, 0x01, 0x29, 0x57, 0x53, 0x23, 0x03, 0x00, 0x00, 0x0a, 0x2e, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x60, 0x38, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x1f, 0x4e, 0x2a, 0x06, 0x1c, 0x48, 0x58, 0x36, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x29, 0x23, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x42, 0x61, 0x5f, 0x52, 0x45, 0x34, 0x20, 0x0d, 0x00, 0x00},
    {0x5b, 0x85, 0x6d, 0x54, 0x55, 0x3f, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x2d, 0x22, 0x00, 0x00, 0x15, 0x36, 0x2c, 0x14, 0x14, 0x25, 0x39, 0x4b, 0x52, 0x4f, 0x45, 0x42},
    {0x75, 0xaf, 0xb7, 0x6b, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x3d, 0x36, 0x33, 0x38, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x1c, 0x38, 0x54, 0x63},
    {0x27, 0x71, 0xa8, 0x4f, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x71, 0x59, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x18, 0x16},
    {0x00, 0x34, 0x8f, 0x5b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x6a, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x1e, 0x91, 0x81, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x5d, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x22, 0x89, 0x90, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x5d, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x33, 0x7c, 0x5a, 0x4e, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x5d, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x4b, 0x71, 0x21, 0x17, 0x42, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x52, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x03, 0x65, 0x59, 0x01, 0x00, 0x0b, 0x3f, 0x3f, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x19, 0x75, 0x34, 0x00, 0x00, 0x00, 0x02, 0x34, 0x48, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x3b, 0x73, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x4c, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x71, 0x6b, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x52, 0x48, 0x1e, 0x0d, 0x0e, 0x0b, 0x12, 0x57, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0xbf, 0x72, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x6e, 0x86, 0x6c, 0x69, 0x6d, 0x86, 0x9b, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5d},
    {0x71, 0x68, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x4b, 0x48, 0x3b, 0x3e, 0x4e, 0x7b, 0xb0, 0x74, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x6b, 0x89},
    {0x00, 0x11, 0x47, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x28, 0x12, 0x00, 0x00, 0x00, 0x00, 0x07, 0x4a, 0x97, 0x59, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2b, 0x7c, 0x5d, 0x12},
    {0x00, 0x00, 0x0c, 0x40, 0x0a, 0x00, 0x00, 0x00, 0x01, 0x1e, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0xa3, 0x73, 0x42, 0x3e, 0x20, 0x00, 0x00, 0x00, 0x32, 0x7f, 0x3f, 0x00, 0x00}
  },
  {
    {0x00, 0x00, 0x00, 0x00, 0x53, 0x3e, 0x25, 0x2c, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x6a, 0xf4, 0xf3, 0xc5, 0x8c, 0x4c, 0x45, 0x64, 0x86, 0x41, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x37, 0x89, 0x58, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x7f, 0xae, 0x77, 0x7e, 0xba, 0xdd, 0x9b, 0x5d, 0x42, 0x02, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x25, 0xaa, 0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x83, 0x17, 0x00, 0x00, 0x14, 0x8f, 0xa9, 0x4e, 0x2c, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x2c, 0x9d, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x76, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x7f, 0x34, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x43, 0x90, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x9d, 0x5b, 0x06, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x70, 0x83, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x69, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xa2, 0xa6, 0x3b, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x33, 0xb4, 0x78, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x86, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xac, 0xd8, 0xa8, 0x56, 0x07, 0x00},
    {0x2e, 0x2b, 0x42, 0x92, 0xd5, 0x98, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x61, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x94, 0x71, 0x84, 0xab, 0x8d, 0x4c},
    {0x77, 0x67, 0x7f, 0x7d, 0x6c, 0x75, 0x72, 0x3c, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x04, 0x20, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x77, 0x33, 0x04, 0x08, 0x32, 0x7d, 0x99},
    {0x87, 0x89, 0x54, 0x14, 0x00, 0x05, 0x30, 0x62, 0x5d, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x10, 0x26, 0x03, 0x26, 0x77, 0x34, 0x00, 0x00, 0x0d, 0x4a, 0x6d, 0x26, 0x00, 0x00, 0x00, 0x00, 0x04, 0x47},
    {0x5f, 0x73, 0x07, 0x00, 0x00, 0x00, 0x00, 0x09, 0x48, 0x6e, 0x45, 0x16, 0x12, 0x34, 0x7b, 0x80, 0x5e, 0x76, 0xb5, 0xb4, 0x80, 0x74, 0x7b, 0x64, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x3b, 0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x81, 0x8f, 0x91, 0x9d, 0x9a, 0x7b, 0x5e, 0x53, 0x4e, 0x66, 0x99, 0xb9, 0x6b, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x35, 0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xe0, 0xb8, 0x65, 0x2e, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x50, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x30, 0x4f, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x8d, 0xa4, 0x72, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x46, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x27, 0x4f, 0x05, 0x00, 0x00, 0x00, 0x00, 0x07, 0x4a, 0x7b, 0x58, 0x29, 0x38, 0x3d, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x1f, 0x53, 0x10, 0x00, 0x00, 0x00, 0x2e, 0x6b, 0x6f, 0x30, 0x00, 0x00, 0x00, 0x24, 0x38, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x54, 0x3e, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x33, 0x6e, 0x39, 0x08, 0x20, 0x58, 0x74, 0x4e, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x34, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x5b, 0x8f, 0x63, 0x3e, 0x26, 0x11, 0x04, 0x00, 0x02},
    {0x80, 0xb9, 0x92, 0x6b, 0x6f, 0x59, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x02, 0x36, 0x50, 0x4a, 0x53, 0x64, 0x6f, 0x73, 0x6e, 0x5f, 0x5e},
    {0x7f, 0xca, 0xea, 0x96, 0x3b, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0x2a, 0x00, 0x00, 0x0f, 0x35, 0x2f, 0x0a, 0x00, 0x00, 0x0f, 0x37, 0x5f, 0x68, 0x63, 0x66},
    {0x18, 0x69, 0xcb, 0x75, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x45, 0x3e, 0x34, 0x44, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x09, 0x00, 0x01, 0x06},
    {0x00, 0x29, 0xa3, 0x7c, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x81, 0x75, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x15, 0xa0, 0xa5, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x77, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x1a, 0x99, 0xb3, 0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x68, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x2c, 0x8e, 0x73, 0x5d, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x68, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x48, 0x84, 0x2e, 0x19, 0x49, 0x3f, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x64, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x65, 0x6a, 0x04, 0x00, 0x08, 0x43, 0x4c, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x11, 0x80, 0x46, 0x00, 0x00, 0x00, 0x00, 0x33, 0x55, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x65, 0xa9, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x66, 0x55, 0x2e, 0x1c, 0x14, 0x0f, 0x0f, 0x32, 0x84, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0xc4, 0xc0, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x9b, 0x94, 0x7a, 0x76, 0x73, 0x74, 0x9b, 0xcf, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x5f},
    {0x4d, 0x46, 0x6a, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x4c, 0x31, 0x2b, 0x31, 0x38, 0x41, 0x60, 0xa9, 0xab, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0x84, 0x87},
    {0x00, 0x00, 0x1b, 0x56, 0x12, 0x00, 0x00, 0x00, 0x1c, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x8d, 0x90, 0x25, 0x08, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x97, 0x5b, 0x06},
    {0x00, 0x00, 0x00, 0x29, 0x4d, 0x02, 0x00, 0x17, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0x9f, 0xa0, 0x64, 0x3e, 0x08, 0x00, 0x00, 0x0c, 0x58, 0x9a, 0x3e, 0x00, 0x00}
  },
  {
    {0x00, 0x00, 0x00, 0x00, 0x34, 0xaf, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xb9, 0xff, 0xbb, 0x7e, 0x5c, 0x30, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x23, 0xa0, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0xa3, 0xae, 0xbc, 0xb6, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x25, 0x91, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x6a, 0x57, 0x00, 0x0d, 0x6d, 0x73, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x32, 0x8d, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x6b, 0x00, 0x00, 0x00, 0x03, 0x71, 0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x4d, 0x89, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x8d, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x31, 0x7d, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x00, 0x00, 0x00, 0x92, 0x8c, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0e, 0x2f, 0x69, 0x23, 0x00, 0x00, 0x00, 0x00, 0x03, 0x98, 0x8b, 0x25, 0x0d, 0x17, 0x03, 0x00},
    {0x00, 0x00, 0x18, 0x80, 0xf2, 0xb1, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0f, 0x0a, 0x00, 0x13, 0x18, 0x00, 0x00, 0x00, 0x00, 0x16, 0xa0, 0xa4, 0x7a, 0x6e, 0x68, 0x53, 0x1f},
    {0x88, 0x8a, 0xa7, 0xad, 0x93, 0x8c, 0x82, 0x41, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x08, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x06, 0x61, 0x5b, 0x27, 0x31, 0x51, 0x75, 0x93, 0x9f},
    {0xd5, 0xd9, 0x72, 0x1d, 0x01, 0x0e, 0x3d, 0x70, 0x67, 0x22, 0x00, 0x00, 0x00, 0x04, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x18, 0x00, 0x1d, 0x52, 0x41, 0x02, 0x00, 0x00, 0x00, 0x0a, 0x32, 0x7b},
    {0x7e, 0x77, 0x01, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x51, 0x78, 0x45, 0x0c, 0x09, 0x37, 0x1a, 0x00, 0x00, 0x00, 0x08, 0x8a, 0xb3, 0x6f, 0x5e, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d},
    {0x4e, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x7f, 0x7a, 0x77, 0xa2, 0x72, 0x39, 0x32, 0x43, 0x73, 0xae, 0xdc, 0x99, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x4b, 0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0xac, 0xdf, 0xb3, 0x88, 0x70, 0x61, 0x56, 0x47, 0x34, 0x59, 0x6a, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x4b, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x8f, 0x9d, 0x38, 0x16, 0x0e, 0x05, 0x00, 0x00, 0x00, 0x05, 0x4c, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x45, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x9d, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x50, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x3d, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x99, 0xa3, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x2f, 0x59, 0x04, 0x00, 0x00, 0x00, 0x00, 0x09, 0x50, 0x88, 0x69, 0x45, 0x4f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x4f, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x28, 0x62, 0x16, 0x00, 0x00, 0x00, 0x36, 0x76, 0x7a, 0x36, 0x04, 0x00, 0x16, 0x3c, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x50, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x47, 0x86, 0x4b, 0x10, 0x29, 0x63, 0x7f, 0x54, 0x10, 0x00, 0x00, 0x00, 0x00, 0x11, 0x39, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x6f, 0x79, 0x36, 0x1c, 0x15, 0x0f, 0x0b, 0x11},
    {0x93, 0xd4, 0xb1, 0x7d, 0x7b, 0x5e, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x37, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0x71, 0x8d, 0x8c, 0x8b, 0x7f, 0x77, 0x70, 0x72},
    {0x6f, 0xbb, 0xfa, 0xaa, 0x40, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x34, 0x01, 0x00, 0x00, 0x00, 0x00, 0x27, 0x47, 0x33, 0x2f, 0x4d, 0x4d, 0x45, 0x49, 0x4e, 0x54},
    {0x08, 0x4e, 0xc3, 0x86, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x32, 0x00, 0x00, 0x0a, 0x33, 0x33, 0x0c, 0x00, 0x09, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x1c, 0x93, 0x84, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x40, 0x2e, 0x44, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x13, 0x80, 0x94, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x77, 0x78, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x14, 0x7e, 0xa9, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x70, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x1d, 0x89, 0x82, 0x62, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x63, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x00, 0x47, 0x90, 0x41, 0x22, 0x47, 0x3e, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x61, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x18, 0x7a, 0x81, 0x23, 0x00, 0x07, 0x3e, 0x4e, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x64, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
    {0x4e, 0x4f, 0x5b, 0x27, 0x00, 0x00, 0x00, 0x3c, 0x6a, 0x58, 0x3b, 0x2e, 0x26, 0x1f, 0x1a, 0x16, 0x23, 0x71, 0x75, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26},
    {0x23, 0x15, 0x4f, 0x46, 0x00, 0x00, 0x00, 0x03, 0x65, 0x9a, 0x80, 0x77, 0x77, 0x77, 0x76, 0x73, 0x84, 0xc3, 0xa2, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x42, 0x4b},
    {0x05, 0x0c, 0x37, 0x6e, 0x23, 0x00, 0x00, 0x19, 0x44, 0x2a, 0x18, 0x18, 0x1d, 0x26, 0x2d, 0x33, 0x44, 0x7b, 0xb2, 0x6a, 0x0f, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x2f, 0x51, 0x40, 0x15},
    {0x02, 0x00, 0x00, 0x3c, 0x65, 0x15, 0x16, 0x30, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x55, 0x9f, 0x60, 0x28, 0x02, 0x00, 0x00, 0x00, 0x20, 0x42, 0x41, 0x1d, 0x05, 0x03},
    {0x00, 0x00, 0x00, 0x00, 0x5e, 0x74, 0x4e, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xb5, 0x7f, 0x31, 0x12, 0x23, 0x3d, 0x3d, 0x1d, 0x00, 0x00, 0x00, 0x00}
  }
};
//uint8_t step = 0U;  // GIFframe = 0U; текущий кадр анимации (не важно, какой в начале)
//uint8_t deltaHue = 0U; // GIFshiftx = 0U; какой-то там сдвиг текстуры по радиусу лампы
//uint8_t deltaHue2 = 0U; // GIFshifty = 0U; какой-то там сдвиг текстуры по высоте

#define CAUSTICS_BR                     (100U)                // яркость бликов в процентах (от чистого белого света)

void poolRoutine()
{
  if (loadingFlag) {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      setModeSettings(47U + random8(28U), 201U + random8(38U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    hue = modes[currentMode].Scale * 2.55;
    //for (int16_t i = 0U; i < NUM_LEDS; i++)
    //  leds[i] = CHSV(hue, 255U, 255U);
    fillAll(CHSV(hue, 255U, 255U));
    deltaHue = 0U;
    deltaHue2 = 0U;
  }
  if (modes[currentMode].Speed != 255U) // если регулятор скорости на максимуме, то будет работать старый эффект "цвет" (без анимации бликов воды)
  {
    if (step > 24U) // количество кадров в анимации -1 (отсчёт с нуля)
      step = 0U;
    if (step > 0U && step < 3U) // пару раз за цикл анимации двигаем текстуру по радиусу лампы. а может и не двигаем. как повезёт
    {
      if (random(2U) == 0U)
      {
        deltaHue++;
        if (deltaHue > 31U) deltaHue = 0U;
      }
    }
    if (step > 11U && step < 14U) // пару раз за цикл анимации двигаем текстуру по вертикали. а может и не двигаем. как повезёт
    {
      if (random(2U) == 0U)
      {
        deltaHue2++;
        if (deltaHue2 > 31U) deltaHue2 = 0U;
      }
    }

    for (uint8_t x = 0U; x < WIDTH ; x++) {
      for (uint8_t y = 0U; y < HEIGHT; y++) {
        // y%32, x%32 - это для масштабирования эффекта на лампы размером большим, чем размер анимации 32х32, а также для произвольного сдвига текстуры
        leds[XY(x, y)] = CHSV(hue, 255U - pgm_read_byte(&aquariumGIF[step][(y + deltaHue2) % 32U][(x + deltaHue) % 32U]) * CAUSTICS_BR / 100U, 255U);
        // чтобы регулятор Масштаб начал вместо цвета регулировать яркость бликов, нужно закомментировать предыдущую строчку и раскоментировать следующую
        //        leds[XY(x, y)] = CHSV(158U, 255U - pgm_read_byte(&aquariumGIF[step][(y+deltaHue2)%32U][(x+deltaHue)%32U]) * modes[currentMode].Scale / 100U, 255U);
      }
    }
    step++;
  }
}

// ------------- цвета - 2 -----------------
//#define SECONDS_DELAY (1U) // растягиваем задержку, регулируемую бегунком "Скорость" в указанное количество времени
#define DELAY_MULTIPLIER (20U) //при задержке между кадрами примерно в 50 мс с этим множителем получится 1 с на единицу бегунка Скорость
void colorsRoutine2()
{
  if (loadingFlag) {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      setModeSettings(1U + random8(255U), 210U + random8(46U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    deltaValue = 255U - modes[currentMode].Speed + 1U;
    step = deltaValue; // чтообы при старте эффекта сразу покрасить лампу (для бугунка Масштаб от 246 до 9)
    deltaHue = 1U;     // чтообы при старте эффекта сразу покрасить лампу (для бегунка Масштаб от 10 до 245)
    hue2 = 0U;
  }

  if (modes[currentMode].Scale < 10U || modes[currentMode].Scale > 245U) // если Масштаб небольшой, меняем цвет на это значение регулярно (каждый цикл кратный значению Скорость)
    if (step >= deltaValue) {
      hue += modes[currentMode].Scale;
      step = 0U;
      //for (uint16_t i = 0U; i < NUM_LEDS; i++)
      //  leds[i] = CHSV(hue, 255U, 255U);
      fillAll(CHSV(hue, 255U, 255U));
    }
    else
      step++;
  else                                                                   // если Масштаб большой, тогда смену цвета делаем как бы пульсацией (поменяли, пауза, поменяли, пауза)
    if (deltaHue != 0) {
      if (deltaHue > 127U) {
        hue--;
        deltaHue++;
      }
      else {
        hue++;
        deltaHue--;
      }
      //for (uint16_t i = 0U; i < NUM_LEDS; i++)
      //  leds[i] = CHSV(hue, 255U, 255U);
      fillAll(CHSV(hue, 255U, 255U));
    }
    else if (step >= deltaValue) {
      deltaHue = modes[currentMode].Scale;
#ifdef USE_BLYNK
      if (modes[currentMode].Scale > 100U) modes[currentMode].Scale = 100U;
      deltaHue = modes[currentMode].Scale * 2.55;
#endif

      step = 0U;
    }
    else
      //        EVERY_N_SECONDS(SECONDS_DELAY){   // не компилируется такое, блин
      //        EVERY_N_MILLIS(12) {              // и такое тоже
      if (hue2 >= DELAY_MULTIPLIER) {
        step++;
        hue2 = 0U;
      }
      else
        hue2++;
}

// ------------- цвет ------------------
void colorRoutine()
{
  if (loadingFlag)
  {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      setModeSettings(1U + random8(100U), 96U + random8(160));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    //FastLED.clear(); нафига тут это было?!

    //for (int16_t i = 0U; i < NUM_LEDS; i++)
    //  leds[i] = CHSV(modes[currentMode].Scale * 2.55, modes[currentMode].Speed, 255U);
    fillAll(CHSV(modes[currentMode].Scale * 2.55, modes[currentMode].Speed, 255U));
  }
}

// ------------- снегопад ----------
void snowRoutine()
{
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
  if (selectedSettings) {
    setModeSettings(88U + random8(9U), 170U + random8(36U));
  }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

  // сдвигаем всё вниз
  for (uint8_t x = 0U; x < WIDTH; x++)
  {
    for (uint8_t y = 0U; y < HEIGHT - 1; y++)
    {
      drawPixelXY(x, y, getPixColorXY(x, y + 1U));
    }
  }

  for (uint8_t x = 0U; x < WIDTH; x++)
  {
    // заполняем случайно верхнюю строку
    // а также не даём двум блокам по вертикали вместе быть
    if (getPixColorXY(x, HEIGHT - 2U) == 0U && (random(0, 100 - modes[currentMode].Scale) == 0U))
      drawPixelXY(x, HEIGHT - 1U, 0xE0FFFF - 0x101010 * random(0, 4));
    else
      drawPixelXY(x, HEIGHT - 1U, 0x000000);
  }
}


// ------------- метель - 2 -------------
//SNOWSTORM / МЕТЕЛЬ # STARFALL / ЗВЕЗДОПАД ***** V1.2
// v1.0 - Updating for GuverLamp v1.7 by PalPalych 12.03.2020
// v1.1 - Fix wrong math & full screen drawing by PalPalych 14.03.2020
// v1.2 - Code optimisation + pseudo 3d by PalPalych 21.04.2020
#define e_sns_DENSE (32U) // плотность снега - меньше = плотнее

void stormRoutine2()// (bool isColored) // сворачиваем 2 эффекта в 1
{
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
  if (selectedSettings) {
    uint8_t tmp = 175U + random8(39U);
    if (tmp & 0x01)
      setModeSettings(50U + random8(51U), tmp);
    else
      setModeSettings(50U + random8(24U), tmp);
  }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

  bool isColored = modes[currentMode].Speed & 0x01; // сворачиваем 2 эффекта в 1
  // заполняем головами комет
  uint8_t Saturation = 0U;    // цвет хвостов
  uint8_t e_TAIL_STEP = 127U; // длина хвоста
  if (isColored)
    Saturation = modes[currentMode].Scale * 2.55;
  else
  {
    e_TAIL_STEP = 255U - modes[currentMode].Scale * 2.5;
  }
  for (uint8_t x = 0U; x < WIDTH - 1U; x++) // fix error i != 0U
  {
    if (!random8(e_sns_DENSE) &&
        !getPixColorXY(wrapX(x), HEIGHT - 1U) &&
        !getPixColorXY(wrapX(x + 1U), HEIGHT - 1U) &&
        !getPixColorXY(wrapX(x - 1U), HEIGHT - 1U))
    {
      drawPixelXY(x, HEIGHT - 1U, CHSV(random8(), Saturation, random8(64U, 255U)));
    }
  }

  // сдвигаем по диагонали
  for (uint8_t y = 0U; y < HEIGHT - 1U; y++)
  {
    for (uint8_t x = 0; x < WIDTH; x++)
    {
      drawPixelXY(wrapX(x + 1U), y, getPixColorXY(x, y + 1U));
    }
  }

  // уменьшаем яркость верхней линии, формируем "хвосты"
  for (uint8_t i = 0U; i < WIDTH; i++)
  {
    fadePixel(i, HEIGHT - 1U, e_TAIL_STEP);
  }
}


// ------------- матрица ---------------
void matrixRoutine()
{
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
  if (selectedSettings) {
    setModeSettings(1U + random8(90U), 165U + random8(66U));
  }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

  for (uint8_t x = 0U; x < WIDTH; x++)
  {
    // обрабатываем нашу матрицу снизу вверх до второй сверху строчки
    for (uint8_t y = 0U; y < HEIGHT - 1U; y++)
    {
      uint32_t thisColor = getPixColorXY(x, y);                                              // берём цвет нашего пикселя
      uint32_t upperColor = getPixColorXY(x, y + 1U);                                        // берём цвет пикселя над нашим
      if (upperColor >= 0x900000 && random(7 * HEIGHT) != 0U)                  // если выше нас максимальная яркость, игнорим этот факт с некой вероятностью или опускаем цепочку ниже
        drawPixelXY(x, y, upperColor);
      else if (thisColor == 0U && random((100 - modes[currentMode].Scale) * HEIGHT) == 0U)  // если наш пиксель ещё не горит, иногда зажигаем новые цепочки
        //else if (thisColor == 0U && random((100 - modes[currentMode].Scale) * HEIGHT*3) == 0U)  // для длинных хвостов
        drawPixelXY(x, y, 0x9bf800);
      else if (thisColor <= 0x050800)                                                        // если наш пиксель почти погас, стараемся сделать затухание медленней
      {
        if (thisColor >= 0x030000)
          drawPixelXY(x, y, 0x020300);
        else if (thisColor != 0U)
          drawPixelXY(x, y, 0U);
      }
      else if (thisColor >= 0x900000)                                                        // если наш пиксель максимальной яркости, резко снижаем яркость
        drawPixelXY(x, y, 0x558800);
      else
        drawPixelXY(x, y, thisColor - 0x0a1000);                                             // в остальных случаях снижаем яркость на 1 уровень
      //drawPixelXY(x, y, thisColor - 0x050800);                                             // для длинных хвостов
    }
    // аналогично обрабатываем верхний ряд пикселей матрицы
    uint32_t thisColor = getPixColorXY(x, HEIGHT - 1U);
    if (thisColor == 0U)                                                                     // если наш верхний пиксель не горит, заполняем его с вероятностью .Scale
    {
      if (random(100 - modes[currentMode].Scale) == 0U)
        drawPixelXY(x, HEIGHT - 1U, 0x9bf800);
    }
    else if (thisColor <= 0x050800)                                                          // если наш верхний пиксель почти погас, стараемся сделать затухание медленней
    {
      if (thisColor >= 0x030000)
        drawPixelXY(x, HEIGHT - 1U, 0x020300);
      else
        drawPixelXY(x, HEIGHT - 1U, 0U);
    }
    else if (thisColor >= 0x900000)                                                          // если наш верхний пиксель максимальной яркости, резко снижаем яркость
      drawPixelXY(x, HEIGHT - 1U, 0x558800);
    else
      drawPixelXY(x, HEIGHT - 1U, thisColor - 0x0a1000);                                     // в остальных случаях снижаем яркость на 1 уровень
    //drawPixelXY(x, HEIGHT - 1U, thisColor - 0x050800);                                     // для длинных хвостов
  }
}

// ------------- Светлячки 2 - Светлячки в банке - Мотыльки - Лампа с мотыльками --------------
// (c) SottNick

//#define trackingOBJECT_MAX_COUNT           (100U) // максимальное количество мотыльков
#define BUTTERFLY_FIX_COUNT               (20U) // количество мотыльков для режима, когда бегунок Масштаб регулирует цвет
//float trackingObjectPosX[trackingOBJECT_MAX_COUNT];
//float trackingObjectPosY[trackingOBJECT_MAX_COUNT];
//float trackingObjectSpeedX[trackingOBJECT_MAX_COUNT];
//float trackingObjectSpeedY[trackingOBJECT_MAX_COUNT];
//float trackingObjectShift[trackingOBJECT_MAX_COUNT];
//uint8_t trackingObjectHue[trackingOBJECT_MAX_COUNT];
//uint8_t trackingObjectState[trackingOBJECT_MAX_COUNT];

void butterflysRoutine(bool isColored)
{
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
  if (selectedSettings) {
    if (isColored) {
      uint8_t tmp = 66U + random8(83U);
      setModeSettings((tmp & 0x01) ? 65U + random8(36U) : 15U + random8(26U), tmp);
    }
    else
      setModeSettings(random8(21U) ? (random8(3U) ? 2U + random8(98U) : 1U) : 100U, 20U + random8(155U));
  }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

  bool isWings = modes[currentMode].Speed & 0x01;
  if (loadingFlag)
  {
    loadingFlag = false;
    speedfactor = (float)modes[currentMode].Speed / 2048.0f + 0.001f;
    if (isColored) // для режима смены цвета фона фиксируем количество мотыльков
      deltaValue = (modes[currentMode].Scale > trackingOBJECT_MAX_COUNT) ? trackingOBJECT_MAX_COUNT : modes[currentMode].Scale;
    else
      deltaValue = BUTTERFLY_FIX_COUNT;
    for (uint8_t i = 0U; i < trackingOBJECT_MAX_COUNT; i++)
    {
      trackingObjectPosX[i] = random8(WIDTH);
      trackingObjectPosY[i] = random8(HEIGHT);
      trackingObjectSpeedX[i] = 0;
      trackingObjectSpeedY[i] = 0;
      trackingObjectShift[i] = 0;
      trackingObjectHue[i] = (isColored) ? random8() : 255U;
      trackingObjectState[i] = 255U;
    }
    //для инверсии, чтобы сто раз не пересчитывать
    if (modes[currentMode].Scale != 1U)
      hue = (float)(modes[currentMode].Scale - 1U) * 2.6;
    else
      hue = random8();
    //hue2 = (modes[currentMode].Scale == 100U) ? 0U : 255U;  // белый или цветной фон
    if (modes[currentMode].Scale == 100U) { // вместо белого будет желтоватая лампа
      hue2 = 170U;
      hue = 31U;
    }
    else
      hue2 = 255U;
  }
  if (isWings && isColored)
    dimAll(35U); // для крылышков
  else
    FastLED.clear();

  float maxspeed;
  uint8_t tmp;
  if (++step >= deltaValue)
    step = 0U;
  for (uint8_t i = 0U; i < deltaValue; i++)
  {
    trackingObjectPosX[i] += trackingObjectSpeedX[i] * speedfactor;
    trackingObjectPosY[i] += trackingObjectSpeedY[i] * speedfactor;

    if (trackingObjectPosX[i] < 0)
      trackingObjectPosX[i] = (float)(WIDTH - 1) + trackingObjectPosX[i];
    if (trackingObjectPosX[i] > WIDTH - 1)
      trackingObjectPosX[i] = trackingObjectPosX[i] + 1 - WIDTH;

    if (trackingObjectPosY[i] < 0)
    {
      trackingObjectPosY[i] = -trackingObjectPosY[i];
      trackingObjectSpeedY[i] = -trackingObjectSpeedY[i];
      //trackingObjectSpeedX[i] = -trackingObjectSpeedX[i];
    }
    if (trackingObjectPosY[i] > HEIGHT - 1U)
    {
      trackingObjectPosY[i] = (HEIGHT << 1U) - 2U - trackingObjectPosY[i];
      trackingObjectSpeedY[i] = -trackingObjectSpeedY[i];
      //trackingObjectSpeedX[i] = -trackingObjectSpeedX[i];
    }

    //проворот траектории
    maxspeed = fabs(trackingObjectSpeedX[i]) + fabs(trackingObjectSpeedY[i]); // максимальная суммарная скорость
    if (maxspeed == fabs(trackingObjectSpeedX[i] + trackingObjectSpeedY[i]))
    {
      if (trackingObjectSpeedX[i] > 0) // правый верхний сектор вектора
      {
        trackingObjectSpeedX[i] += trackingObjectShift[i];
        if (trackingObjectSpeedX[i] > maxspeed) // если вектор переехал вниз
        {
          trackingObjectSpeedX[i] = maxspeed + maxspeed - trackingObjectSpeedX[i];
          trackingObjectSpeedY[i] = trackingObjectSpeedX[i] - maxspeed;
        }
        else
          trackingObjectSpeedY[i] = maxspeed - fabs(trackingObjectSpeedX[i]);
      }
      else                           // левый нижний сектор
      {
        trackingObjectSpeedX[i] -= trackingObjectShift[i];
        if (trackingObjectSpeedX[i] + maxspeed < 0) // если вектор переехал вверх
        {
          trackingObjectSpeedX[i] = 0 - trackingObjectSpeedX[i] - maxspeed - maxspeed;
          trackingObjectSpeedY[i] = maxspeed - fabs(trackingObjectSpeedX[i]);
        }
        else
          trackingObjectSpeedY[i] = fabs(trackingObjectSpeedX[i]) - maxspeed;
      }
    }
    else //левый верхний и правый нижний секторы вектора
    {
      if (trackingObjectSpeedX[i] > 0) // правый нижний сектор
      {
        trackingObjectSpeedX[i] -= trackingObjectShift[i];
        if (trackingObjectSpeedX[i] > maxspeed) // если вектор переехал наверх
        {
          trackingObjectSpeedX[i] = maxspeed + maxspeed - trackingObjectSpeedX[i];
          trackingObjectSpeedY[i] = maxspeed - trackingObjectSpeedX[i];
        }
        else
          trackingObjectSpeedY[i] = fabs(trackingObjectSpeedX[i]) - maxspeed;
      }
      else                           // левый верхний сектор
      {
        trackingObjectSpeedX[i] += trackingObjectShift[i];
        if (trackingObjectSpeedX[i] + maxspeed < 0) // если вектор переехал вниз
        {
          trackingObjectSpeedX[i] = 0 - trackingObjectSpeedX[i] - maxspeed - maxspeed;
          trackingObjectSpeedY[i] = 0 - trackingObjectSpeedX[i] - maxspeed;
        }
        else
          trackingObjectSpeedY[i] = maxspeed - fabs(trackingObjectSpeedX[i]);
      }
    }

    if (trackingObjectState[i] == 255U)
    {
      if (step == i && random8(2U) == 0U)//(step == 0U && ((pcnt + i) & 0x01))
      {
        trackingObjectState[i] = random8(220U, 244U);
        trackingObjectSpeedX[i] = (float)random8(101U) / 20.0f + 1.0f;
        if (random8(2U) == 0U) trackingObjectSpeedX[i] = -trackingObjectSpeedX[i];
        trackingObjectSpeedY[i] = (float)random8(101U) / 20.0f + 1.0f;
        if (random8(2U) == 0U) trackingObjectSpeedY[i] = -trackingObjectSpeedY[i];
        // проворот траектории
        //trackingObjectShift[i] = (float)random8((fabs(trackingObjectSpeedX[i])+fabs(trackingObjectSpeedY[i]))*2.0+2.0) / 40.0f;
        trackingObjectShift[i] = (float)random8((fabs(trackingObjectSpeedX[i]) + fabs(trackingObjectSpeedY[i])) * 20.0f + 2.0f) / 200.0f;
        if (random8(2U) == 0U) trackingObjectShift[i] = -trackingObjectShift[i];
      }
    }
    else
    {
      if (step == i)
        trackingObjectState[i]++;
      tmp = 255U - trackingObjectState[i];
      if (tmp == 0U || ((uint16_t)(trackingObjectPosX[i] * tmp) % tmp == 0U && (uint16_t)(trackingObjectPosY[i] * tmp) % tmp == 0U))
      {
        trackingObjectPosX[i] = round(trackingObjectPosX[i]);
        trackingObjectPosY[i] = round(trackingObjectPosY[i]);
        trackingObjectSpeedX[i] = 0;
        trackingObjectSpeedY[i] = 0;
        trackingObjectShift[i] = 0;
        trackingObjectState[i] = 255U;
      }
    }

    if (isWings)
      drawPixelXYF(trackingObjectPosX[i], trackingObjectPosY[i], CHSV(trackingObjectHue[i], 255U, (trackingObjectState[i] == 255U) ? 255U : 128U + random8(2U) * 111U)); // это процедура рисования с нецелочисленными координатами. ищите её в прошивке
    else
      drawPixelXYF(trackingObjectPosX[i], trackingObjectPosY[i], CHSV(trackingObjectHue[i], 255U, trackingObjectState[i])); // это процедура рисования с нецелочисленными координатами. ищите её в прошивке
  }

  // постобработка кадра
  if (isColored) {
    for (uint8_t i = 0U; i < deltaValue; i++) // ещё раз рисуем всех Мотыльков, которые "сидят на стекле"
      if (trackingObjectState[i] == 255U)
        drawPixelXY(trackingObjectPosX[i], trackingObjectPosY[i], CHSV(trackingObjectHue[i], 255U, trackingObjectState[i]));
  }
  else {
    //теперь инверсия всей матрицы
    if (modes[currentMode].Scale == 1U)
      if (++deltaHue == 0U) hue++;
    for (uint16_t i = 0U; i < NUM_LEDS; i++)
      leds[i] = CHSV(hue, hue2, 255U - leds[i].r);
  }
}


// ------------- светлячки --------------
//#define LIGHTERS_AM           (100U)  // для экономии памяти берём trackingOBJECT_MAX_COUNT
///////#define trackingOBJECT_MAX_COUNT
//int32_t lightersPos[2U][LIGHTERS_AM];
///////float trackingObjectPosX[trackingOBJECT_MAX_COUNT];
///////float trackingObjectPosY[trackingOBJECT_MAX_COUNT];
//int8_t lightersSpeed[2U][LIGHTERS_AM];
///////float trackingObjectSpeedX[trackingOBJECT_MAX_COUNT];
///////float trackingObjectSpeedY[trackingOBJECT_MAX_COUNT];
//CHSV lightersColor[LIGHTERS_AM];
///////uint8_t trackingObjectHue[trackingOBJECT_MAX_COUNT];
//uint8_t step; // раньше называлось uint8_t loopCounter;
//int32_t angle[LIGHTERS_AM];она нигде не используется. нафига она тут?!
//int32_t speedV[LIGHTERS_AM]; она нигде не используется. нафига она тут?!
//int8_t angleSpeed[LIGHTERS_AM]; она нигде не используется. нафига она тут?!
void lightersRoutine()
{
  if (loadingFlag)
  {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      setModeSettings(14U + random8(43U), 100U + random8(81U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    //randomSeed(millis());
    if (modes[currentMode].Scale > trackingOBJECT_MAX_COUNT) modes[currentMode].Scale = trackingOBJECT_MAX_COUNT;
    for (uint8_t i = 0U; i < trackingOBJECT_MAX_COUNT; i++)
    {
      trackingObjectPosX[i] = random(0, WIDTH * 10);
      trackingObjectPosY[i] = random(0, HEIGHT * 10);
      trackingObjectSpeedX[i] = random(-10, 10);
      trackingObjectSpeedY[i] = random(-10, 10);
      //lightersColor[i] = CHSV(random(0U, 255U), 255U, 255U);
      trackingObjectHue[i] = random8();
    }
  }
  FastLED.clear();
  if (++step > 20U) step = 0U;
  for (uint8_t i = 0U; i < modes[currentMode].Scale; i++)
  {
    if (step == 0U)                                  // меняем скорость каждые 255 отрисовок
    {
      trackingObjectSpeedX[i] += random(-3, 4);
      trackingObjectSpeedY[i] += random(-3, 4);
      trackingObjectSpeedX[i] = constrain(trackingObjectSpeedX[i], -20, 20);
      trackingObjectSpeedY[i] = constrain(trackingObjectSpeedY[i], -20, 20);
    }

    trackingObjectPosX[i] += trackingObjectSpeedX[i];
    trackingObjectPosY[i] += trackingObjectSpeedY[i];

    if (trackingObjectPosX[i] < 0) trackingObjectPosX[i] = (WIDTH - 1) * 10;
    if (trackingObjectPosX[i] >= (int32_t)(WIDTH * 10)) trackingObjectPosX[i] = 0;

    if (trackingObjectPosY[i] < 0)
    {
      trackingObjectPosY[i] = 0;
      trackingObjectSpeedY[i] = -trackingObjectSpeedY[i];
    }
    if (trackingObjectPosY[i] >= (int32_t)(HEIGHT - 1) * 10)
    {
      trackingObjectPosY[i] = (HEIGHT - 1U) * 10;
      trackingObjectSpeedY[i] = -trackingObjectSpeedY[i];
    }
    //drawPixelXY(trackingObjectPosX[i] / 10, trackingObjectPosY[i] / 10, lightersColor[i]);
    drawPixelXY(trackingObjectPosX[i] / 10, trackingObjectPosY[i] / 10, CHSV(trackingObjectHue[i], 255U, 255U));
  }
}


// --------------------------- светлячки со шлейфом ---------------------
#define BALLS_AMOUNT          (3U)                          // количество "шариков"
#define CLEAR_PATH            (1U)                          // очищать путь
#define BALL_TRACK            (1U)                          // (0 / 1) - вкл/выкл следы шариков
#define TRACK_STEP            (70U)                         // длина хвоста шарика (чем больше цифра, тем хвост короче)
int16_t coord[BALLS_AMOUNT][2U];
int8_t vector[BALLS_AMOUNT][2U];
CRGB ballColors[BALLS_AMOUNT];
void ballsRoutine()
{
  if (loadingFlag)
  {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      setModeSettings(1U + random8(100U) , 190U + random8(31U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;

    for (uint8_t j = 0U; j < BALLS_AMOUNT; j++)
    {
      int8_t sign;
      // забиваем случайными данными
      coord[j][0U] = WIDTH / 2 * 10;
      random(0, 2) ? sign = 1 : sign = -1;
      vector[j][0U] = random(4, 15) * sign;
      coord[j][1U] = HEIGHT / 2 * 10;
      random(0, 2) ? sign = 1 : sign = -1;
      vector[j][1U] = random(4, 15) * sign;
      //ballColors[j] = CHSV(random(0, 9) * 28, 255U, 255U);
      // цвет зависит от масштаба
      ballColors[j] = CHSV((modes[currentMode].Scale * (j + 1)) % 256U, 255U, 255U);
    }
  }

  if (!BALL_TRACK)                                          // режим без следов шариков
  {
    FastLED.clear();
  }
  else                                                      // режим со следами
  {
    //fader(TRACK_STEP);
    dimAll(256U - TRACK_STEP);
  }

  // движение шариков
  for (uint8_t j = 0U; j < BALLS_AMOUNT; j++)
  {
    // движение шариков
    for (uint8_t i = 0U; i < 2U; i++)
    {
      coord[j][i] += vector[j][i];
      if (coord[j][i] < 0)
      {
        coord[j][i] = 0;
        vector[j][i] = -vector[j][i];
      }
    }

    if (coord[j][0U] > (int16_t)((WIDTH - 1) * 10))
    {
      coord[j][0U] = (WIDTH - 1) * 10;
      vector[j][0U] = -vector[j][0U];
    }
    if (coord[j][1U] > (int16_t)((HEIGHT - 1) * 10))
    {
      coord[j][1U] = (HEIGHT - 1) * 10;
      vector[j][1U] = -vector[j][1U];
    }
    //leds[XY(coord[j][0U] / 10, coord[j][1U] / 10)] =  ballColors[j];
    drawPixelXYF(coord[j][0U] / 10., coord[j][1U] / 10., ballColors[j]);
  }
}

// ------------- пейнтбол -------------
#define BORDERTHICKNESS (1U) // глубина бордюра для размытия яркой частицы: 0U - без границы (резкие края); 1U - 1 пиксель (среднее размытие) ; 2U - 2 пикселя (глубокое размытие)
const uint8_t paintWidth = WIDTH - BORDERTHICKNESS * 2;
const uint8_t paintHeight = HEIGHT - BORDERTHICKNESS * 2;

void lightBallsRoutine()
{
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
  if (selectedSettings) {
    setModeSettings(1U + random8(100U) , 230U + random8(16U));
  }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

  // Apply some blurring to whatever's already on the matrix
  // Note that we never actually clear the matrix, we just constantly
  // blur it repeatedly. Since the blurring is 'lossy', there's
  // an automatic trend toward black -- by design.
  //uint8_t blurAmount = dim8_raw(beatsin8(3, 64, 100));
  //blur2d(leds, WIDTH, HEIGHT, blurAmount);
  blurScreen(dim8_raw(beatsin8(3, 64, 100)));

  // Use two out-of-sync sine waves
  uint16_t i = beatsin16( 79, 0, 255); //91
  uint16_t j = beatsin16( 67, 0, 255); //109
  uint16_t k = beatsin16( 53, 0, 255); //73
  uint16_t m = beatsin16( 97, 0, 255); //123

  // The color of each point shifts over time, each at a different speed.
  uint32_t ms = millis() / (modes[currentMode].Scale / 4 + 1);
  leds[XY( highByte(i * paintWidth) + BORDERTHICKNESS, highByte(j * paintHeight) + BORDERTHICKNESS)] += CHSV( ms / 29, 200U, 255U);
  leds[XY( highByte(j * paintWidth) + BORDERTHICKNESS, highByte(k * paintHeight) + BORDERTHICKNESS)] += CHSV( ms / 41, 200U, 255U);
  leds[XY( highByte(k * paintWidth) + BORDERTHICKNESS, highByte(m * paintHeight) + BORDERTHICKNESS)] += CHSV( ms / 37, 200U, 255U);
  leds[XY( highByte(m * paintWidth) + BORDERTHICKNESS, highByte(i * paintHeight) + BORDERTHICKNESS)] += CHSV( ms / 53, 200U, 255U);
}

// ------------- блуждающий кубик -------------
// Отскакивает от нарисованных препятствий     
#define RANDOM_COLOR          (1U)                          // случайный цвет при отскоке
int16_t coordB[2U];
int16_t coordBold[2U];
int8_t vectorB[2U];
CRGB ballColor;
int8_t ballSize;
bool boom;
void ballRoutine()
{
  if (loadingFlag)
  {
    loadingFlag = false;
    //FastLED.clear();

    for (uint8_t i = 0U; i < 2U; i++)
    {
      coordB[i] = WIDTH / 2 * 10;
      vectorB[i] = random(8, 20);
      boom=false;
    }
  }
  uint8_t x;
  uint8_t y;
  boom=true;
  for (x =0; x<WIDTH; x++)
    for (y =0; y<HEIGHT; y++)
      if (paint[x][y].r+paint[x][y].g+paint[x][y].b>0)  boom=false;  

  if (boom)
   {
    #ifdef GENERAL_DEBUG
    LOG.println(F("Picure_all CRGB(0,0,0) "));
    #endif
    
    loadingFlag=true;
    PaintRoutine(true);
    boom=true; // проверяем, если рисунка нет, то создаем
    for (x =0; x<WIDTH; x++)
      for (y =0; y<HEIGHT; y++)
        if (paint[x][y].r+paint[x][y].g+paint[x][y].b>0)  boom=false;  
     if (boom) {
      #ifdef GENERAL_DEBUG
        LOG.println(F("Picure from EEPROM all CRGB(0,0,0) "));
      #endif
      for (y =0; y<HEIGHT/2; y++)
       {
        paint[0][y]        =CHSV(map(y,0,HEIGHT,0,255) , 255, 255 );
        paint[WIDTH-1][y]  =CHSV(map(y,0,HEIGHT,0,255) , 255, 255 );
       } 
      for (y = HEIGHT/2; y<HEIGHT; y++)
       {
        paint[WIDTH/2][y]  =CHSV(map(y,0,HEIGHT,0,255) , 255, 255 );
        paint[WIDTH/2+1][y]=CHSV(map(y,0,HEIGHT,0,255) , 255, 255 );
       } 
      
     }

    boom=false;       
   }
  ballColor = CHSV(modes[currentMode].Scale * 2.55, 255U, 255U); //CHSV(random(0, 9) * 28, 255U, 255U);
  ballSize = map(modes[EFF_CUBE].Scale, 0U, 255U, 2U, max((uint8_t)min(WIDTH,HEIGHT) / 3, 2));
  for (uint8_t i = 0U; i < 2U; i++)  coordB[i] += vectorB[i];
    if (coordB[1] < 0)
    {
      coordB[1] = 0;
      vectorB[1] = -vectorB[1];
      if (RANDOM_COLOR) ballColor = CHSV(random(0, 9) * 28, 255U, 255U);
    }
  //Движение шарика по цилиндру
  if (coordB[0] < 0) coordB[0]+=WIDTH*10;
  if (coordB[0] >WIDTH*10) coordB[0]-=WIDTH*10;

  if (coordB[1U] > (int16_t)((HEIGHT - ballSize) * 10))
  {
    coordB[1U] = (HEIGHT - ballSize) * 10;
    vectorB[1U] = -vectorB[1U];
    if (RANDOM_COLOR) ballColor = CHSV(random(0, 9) * 28, 255U, 255U);
    // vectorB[1] += random(0, 6) - 3;
  }
//Проверить отскоки
  x=coordB[0U]/10;
  y=coordB[1U]/10;
  if (vectorB[0U]>0)
   {
     if ((getPixColorXYCylinder(x+2,y)>0) || (getPixColorXYCylinder(x+2,y+1)>0))
     {
       vectorB[0U] = Change_Vector(vectorB[0U],x+2,y,0);
       if (RANDOM_COLOR) ballColor = CHSV(random(0, 9) * 28, 255U, 255U);
     }
   } else
   {
     if ((getPixColorXYCylinder(x-1,y)>0) || (getPixColorXYCylinder(x-1,y+1)>0))
     {
       vectorB[0U] = Change_Vector(vectorB[0U],x-1,y,0);
      if (RANDOM_COLOR) ballColor = CHSV(random(0, 9) * 28, 255U, 255U);
     }
   }   
  if (vectorB[1U]>0)
   {
     if (y<HEIGHT-ballSize && getPixColorXYCylinder(x,y+2)>0)
     {
       vectorB[1U] = Change_Vector(vectorB[0U],x,y+2,1);
       if (RANDOM_COLOR) ballColor = CHSV(random(0, 9) * 28, 255U, 255U);
     }
   } else
   {
     if (y>1 && getPixColorXYCylinder(x,y-1)>0) 
     {
       vectorB[1U] = Change_Vector(vectorB[0U],x,y-1,1);
       if (RANDOM_COLOR) ballColor = CHSV(random(0, 9) * 28, 255U, 255U);
     }
   }   


//  FastLED.clear();
//  SaluteFadeAll(64);
//  Кубик на рисованном поле
  loadingFlag=true;
  PaintRoutine(false);
//
  for (uint8_t i = 0U; i < ballSize; i++)
  {
    for (uint8_t j = 0U; j < ballSize; j++)
    {
      drawPixelXYCylinder(coordB[0U] / 10 + i, coordB[1U] / 10 + j,ballColor);
    }
  }
}

int16_t Change_Vector(int8_t vector, int8_t x, int8_t y, uint8_t dxy)
{
  int8_t new_vector=vector;
  uint8_t dx=(dxy==0)?1:0;
  uint8_t dy=(dxy==0)?0:1;
  if (random(0, 9) ==0) paint[x][y]=CRGB(0,0,0);
  if (random(0, 9) ==0) paint[x+dx][y+dy]=CRGB(0,0,0);
  if (vector<0) if (random(0, 9) ==0) paint[x-dx][y-dy]=CRGB(0,0,0);
  if (vector>0) if (random(0, 9) ==0) paint[x+2*dx][y+2*dy]=CRGB(0,0,0);
  new_vector += random(0, 7) - 3;
  if (new_vector==0) new_vector=vector;
  if (abs(new_vector)>25) new_vector=vector;
  
  return -vector;
}

// ------------- ещё более белый свет (с вертикальным вариантом) -------------
// (c) SottNick
#define BORDERLAND   2 // две дополнительные единицы бегунка Масштаб на границе вертикального и горизонтального варианта эффекта (с каждой стороны границы) будут для света всеми светодиодами в полную силу
void whiteColorStripeRoutine()
{
  if (loadingFlag)
  {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      setModeSettings(11U + random8(83U), 1U + random8(255U / WIDTH + 1U) * WIDTH);
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    FastLED.clear();

    uint8_t thisSize = HEIGHT;
    uint8_t halfScale = modes[currentMode].Scale;
    if (halfScale > 50U)
    {
      thisSize = WIDTH;
      halfScale = 101U - halfScale;
    }
    halfScale = constrain(halfScale, 0U, 50U - BORDERLAND);

    uint8_t center =  (uint8_t)round(thisSize / 2.0F) - 1U;
    uint8_t offset = (uint8_t)(!(thisSize & 0x01));

    uint8_t fullFill =  center / (50.0 - BORDERLAND) * halfScale;
    uint8_t iPol = (center / (50.0 - BORDERLAND) * halfScale - fullFill) * 255;

    for (int16_t i = center; i >= 0; i--)
    {
      CRGB color = CHSV(
                     45U,                                                                              // определяем тон
                     map(modes[currentMode].Speed, 0U, 255U, 0U, 170U),                                // определяем насыщенность
                     i > (center - fullFill - 1)                                                       // определяем яркость
                     ? 255U                                                                            // для центральных горизонтальных полос
                     : iPol * (i > center - fullFill - 2));  // для остальных горизонтальных полос яркость равна либо 255, либо 0 в зависимости от масштаба

      if (modes[currentMode].Scale <= 50U)
        for (uint8_t x = 0U; x < WIDTH; x++)
        {
          drawPixelXY(x, i, color);                         // при чётной высоте матрицы максимально яркими отрисуются 2 центральных горизонтальных полосы
          drawPixelXY(x, HEIGHT + offset - i - 2U, color);  // при нечётной - одна, но дважды
        }
      else
        for (uint8_t y = 0U; y < HEIGHT; y++)
        {
          drawPixelXY((i + modes[currentMode].Speed - 1U) % WIDTH, y, color);                    // при чётной ширине матрицы максимально яркими отрисуются 2 центральных вертикальных полосы
          drawPixelXY((WIDTH + offset - i + modes[currentMode].Speed - 3U) % WIDTH, y, color);   // при нечётной - одна, но дважды
        }
    }
  }
}

// ------------- мигающий цвет (не эффект! используется для отображения краткосрочного предупреждения; блокирующий код!) -------------
#define WARNING_BRIGHTNESS    (10U)                         // яркость вспышки
void showWarning(
  CRGB color,                                               /* цвет вспышки                                                 */
  uint32_t duration,                                        /* продолжительность отображения предупреждения (общее время)   */
  uint16_t blinkHalfPeriod)                                 /* продолжительность одной вспышки в миллисекундах (полупериод) */
{
#if defined(MOSFET_PIN) && defined(MOSFET_LEVEL)      // установка сигнала в пин, управляющий MOSFET транзистором, матрица должна быть включена на время вывода текста
  digitalWrite(MOSFET_PIN, MOSFET_LEVEL);
#endif

  uint32_t blinkTimer = millis();
  enum BlinkState { OFF = 0, ON = 1 } blinkState = BlinkState::OFF;
  FastLED.setBrightness(WARNING_BRIGHTNESS);                // установка яркости для предупреждения
  FastLED.clear();
  delay(2);
  FastLED.show();

  //for (uint16_t i = 0U; i < NUM_LEDS; i++)                  // установка цвета всех диодов в WARNING_COLOR
  //  leds[i] = color;
  fillAll(color);

  uint32_t startTime = millis();
  while (millis() - startTime <= (duration + 5))            // блокировка дальнейшего выполнения циклом на время отображения предупреждения
  {
    if (millis() - blinkTimer >= blinkHalfPeriod)           // переключение вспышка/темнота
    {
      blinkTimer = millis();
      blinkState = (BlinkState)!blinkState;
      FastLED.setBrightness(blinkState == BlinkState::OFF ? 0 : WARNING_BRIGHTNESS);
      delay(1);
      FastLED.show();
    }
    delay(50);
  }

  FastLED.clear();
  FastLED.setBrightness(ONflag ? modes[currentMode].Brightness : 0);  // установка яркости, которая была выставлена до вызова предупреждения
  delay(1);
  FastLED.show();

#if defined(MOSFET_PIN) && defined(MOSFET_LEVEL)      // установка сигнала в пин, управляющий MOSFET транзистором, соответственно состоянию вкл/выкл матрицы или будильника
  digitalWrite(MOSFET_PIN, ONflag || (dawnFlag && !manualOff) ? MOSFET_LEVEL : !MOSFET_LEVEL);
#endif

  loadingFlag = true;                                       // принудительное отображение текущего эффекта (того, что был активен перед предупреждением)
}

// --------------------------- эффект кометы ----------------------

// далее идут общие процедуры для эффектов от Stefan Petrick, а непосредственно Комета - в самом низу
//const uint8_t CENTER_X_MINOR =  (WIDTH / 2) -  ((WIDTH - 1) & 0x01);
//const uint8_t CENTER_Y_MINOR = (HEIGHT / 2) - ((HEIGHT - 1) & 0x01);
int8_t zD;
int8_t zF;
// The coordinates for 3 16-bit noise spaces.
#define NUM_LAYERS 1 // в кометах используется 1 слой, но для огня 2018 нужно 2

uint32_t noise32_x[NUM_LAYERSMAX];
uint32_t noise32_y[NUM_LAYERSMAX];
uint32_t noise32_z[NUM_LAYERSMAX];
uint32_t scale32_x[NUM_LAYERSMAX];
uint32_t scale32_y[NUM_LAYERSMAX];

uint8_t noisesmooth;
bool eNs_isSetupped;

void eNs_setup() {
  noisesmooth = 200;
  for (uint8_t i = 0; i < NUM_LAYERS; i++) {
    noise32_x[i] = random16();
    noise32_y[i] = random16();
    noise32_z[i] = random16();
    scale32_x[i] = 6000;
    scale32_y[i] = 6000;
  }
  eNs_isSetupped = true;
}

void FillNoise(int8_t layer) {
  for (uint8_t i = 0; i < WIDTH; i++) {
    int32_t ioffset = scale32_x[layer] * (i - CENTER_X_MINOR);
    for (uint8_t j = 0; j < HEIGHT; j++) {
      int32_t joffset = scale32_y[layer] * (j - CENTER_Y_MINOR);
      int8_t data = inoise16(noise32_x[layer] + ioffset, noise32_y[layer] + joffset, noise32_z[layer]) >> 8;
      int8_t olddata = noise3d[layer][i][j];
      int8_t newdata = scale8( olddata, noisesmooth ) + scale8( data, 255 - noisesmooth );
      data = newdata;
      noise3d[layer][i][j] = data;
    }
  }
}
/* эти функции в данных эффектах не используются, но на всякий случай уже адаптированы
  void MoveX(int8_t delta) {
  //CLS2();
  for (uint8_t y = 0; y < HEIGHT; y++) {
    for (uint8_t x = 0; x < WIDTH - delta; x++) {
      ledsbuff[XY(x, y)] = leds[XY(x + delta, y)];
    }
    for (uint8_t x = WIDTH - delta; x < WIDTH; x++) {
      ledsbuff[XY(x, y)] = leds[XY(x + delta - WIDTH, y)];
    }
  }
  //CLS();
  // write back to leds
  memcpy(leds, ledsbuff, sizeof(CRGB)* NUM_LEDS);
  //какого хера тут было поштучное копирование - я хз
  //for (uint8_t y = 0; y < HEIGHT; y++) {
  //  for (uint8_t x = 0; x < WIDTH; x++) {
  //    leds[XY(x, y)] = ledsbuff[XY(x, y)];
  //  }
  //}
  }

  void MoveY(int8_t delta) {
  //CLS2();
  for (uint8_t x = 0; x < WIDTH; x++) {
    for (uint8_t y = 0; y < HEIGHT - delta; y++) {
      ledsbuff[XY(x, y)] = leds[XY(x, y + delta)];
    }
    for (uint8_t y = HEIGHT - delta; y < HEIGHT; y++) {
      ledsbuff[XY(x, y)] = leds[XY(x, y + delta - HEIGHT)];
    }
  }
  //CLS();
  // write back to leds
  memcpy(leds, ledsbuff, sizeof(CRGB)* NUM_LEDS);
  //какого хера тут было поштучное копирование - я хз
  //for (uint8_t y = 0; y < HEIGHT; y++) {
  //  for (uint8_t x = 0; x < WIDTH; x++) {
  //    leds[XY(x, y)] = ledsbuff[XY(x, y)];
  //  }
  //}
  }
*/

void MoveFractionalNoiseX(int8_t amplitude = 1, float shift = 0) {
  for (uint8_t y = 0; y < HEIGHT; y++) {
    int16_t amount = ((int16_t)noise3d[0][0][y] - 128) * 2 * amplitude + shift * 256  ;
    int8_t delta = abs(amount) >> 8 ;
    int8_t fraction = abs(amount) & 255;
    for (uint8_t x = 0 ; x < WIDTH; x++) {
      if (amount < 0) {
        zD = x - delta; zF = zD - 1;
      } else {
        zD = x + delta; zF = zD + 1;
      }
      CRGB PixelA = CRGB::Black  ;
      if ((zD >= 0) && (zD < WIDTH)) PixelA = leds[XY(zD, y)];
      CRGB PixelB = CRGB::Black ;
      if ((zF >= 0) && (zF < WIDTH)) PixelB = leds[XY(zF, y)];
      ledsbuff[XY(x, y)] = (PixelA.nscale8(ease8InOutApprox(255 - fraction))) + (PixelB.nscale8(ease8InOutApprox(fraction)));   // lerp8by8(PixelA, PixelB, fraction );
    }
  }
  memcpy(leds, ledsbuff, sizeof(CRGB)* NUM_LEDS);
}

void MoveFractionalNoiseY(int8_t amplitude = 1, float shift = 0) {
  for (uint8_t x = 0; x < WIDTH; x++) {
    int16_t amount = ((int16_t)noise3d[0][x][0] - 128) * 2 * amplitude + shift * 256 ;
    int8_t delta = abs(amount) >> 8 ;
    int8_t fraction = abs(amount) & 255;
    for (uint8_t y = 0 ; y < HEIGHT; y++) {
      if (amount < 0) {
        zD = y - delta; zF = zD - 1;
      } else {
        zD = y + delta; zF = zD + 1;
      }
      CRGB PixelA = CRGB::Black ;
      if ((zD >= 0) && (zD < HEIGHT)) PixelA = leds[XY(x, zD)];
      CRGB PixelB = CRGB::Black ;
      if ((zF >= 0) && (zF < HEIGHT)) PixelB = leds[XY(x, zF)];
      ledsbuff[XY(x, y)] = (PixelA.nscale8(ease8InOutApprox(255 - fraction))) + (PixelB.nscale8(ease8InOutApprox(fraction)));
    }
  }
  memcpy(leds, ledsbuff, sizeof(CRGB)* NUM_LEDS);
}

// NoiseSmearing(by StefanPetrick) Effect mod for GyverLamp by PalPalych
void MultipleStream() { // 2 comets
  if (loadingFlag)
  {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      hue = random8();
      hue2 = hue + 85U;
      setModeSettings(1U + random8(25U), 185U + random8(36U));
    }
    else {
      hue = 0U; // 0xFF0000
      hue2 = 43U; // 0xFFFF00
    }
#else
    hue = 0U; // 0xFF0000
    hue2 = 43U; // 0xFFFF00
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    trackingObjectState[0] = WIDTH / 8;
    trackingObjectState[1] = HEIGHT / 8;
    trackingObjectShift[0] = 255. / (WIDTH - 1. - trackingObjectState[0] - trackingObjectState[0]);
    trackingObjectShift[1] = 255. / (HEIGHT - 1. - trackingObjectState[1] - trackingObjectState[1]);
    trackingObjectState[2] = WIDTH / 4;
    trackingObjectState[3] = HEIGHT / 4;
    trackingObjectShift[2] = 255. / (WIDTH - 1. - trackingObjectState[2] - trackingObjectState[2]); // ((WIDTH>10)?9.:5.));
    trackingObjectShift[3] = 255. / (HEIGHT - 1. - trackingObjectState[3] - trackingObjectState[3]); //- ((HEIGHT>10)?9.:5.));
  }

  //dimAll(192); // < -- затухание эффекта для последующего кадрв
  dimAll(255U - modes[currentMode].Scale * 2);


  // gelb im Kreis
  byte xx = trackingObjectState[0] + sin8( millis() / 10) / trackingObjectShift[0];// / 22;
  byte yy = trackingObjectState[1] + cos8( millis() / 10) / trackingObjectShift[1];// / 22;
  if (xx < WIDTH && yy < HEIGHT)
    leds[XY( xx, yy)] = CHSV(hue2 , 255, 255);//0xFFFF00;

  // rot in einer Acht
  xx = trackingObjectState[2] + sin8( millis() / 46) / trackingObjectShift[2];// / 32;
  yy = trackingObjectState[3] + cos8( millis() / 15) / trackingObjectShift[3];// / 32;
  if (xx < WIDTH && yy < HEIGHT)
    leds[XY( xx, yy)] = CHSV(hue , 255, 255);//0xFF0000;

  // Noise
  noise32_x[0] += 3000;
  noise32_y[0] += 3000;
  noise32_z[0] += 3000;
  scale32_x[0] = 8000;
  scale32_y[0] = 8000;
  FillNoise(0);
  MoveFractionalNoiseX(3, 0.33);
  MoveFractionalNoiseY(3);
}

void MultipleStream2() { // 3 comets
  if (loadingFlag)
  {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      hue = random8();
      hue2 = hue + 85U;
      deltaHue = hue2 + 85U;
      setModeSettings(1U + random8(25U), 185U + random8(36U));
    }
    else {
      hue = 0U; // 0xFF0000
      hue2 = 43U; // 0xFFFF00
      deltaHue = 171U; //0x0000FF;
    }
#else
    hue = 0U; // 0xFF0000
    hue2 = 43U; // 0xFFFF00
    deltaHue = 171U; //0x0000FF;
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    trackingObjectState[0] = WIDTH / 8;
    trackingObjectState[1] = HEIGHT / 8;
    trackingObjectShift[0] = 255. / (WIDTH - 1. - trackingObjectState[0] - trackingObjectState[0]);
    trackingObjectShift[1] = 255. / (HEIGHT - 1. - trackingObjectState[1] - trackingObjectState[1]);
    trackingObjectState[2] = WIDTH / 4;
    trackingObjectState[3] = HEIGHT / 4;
    trackingObjectShift[2] = 255. / (WIDTH - 1. - trackingObjectState[2] - trackingObjectState[2]); // ((WIDTH>10)?9.:5.));
    trackingObjectShift[3] = 255. / (HEIGHT - 1. - trackingObjectState[3] - trackingObjectState[3]); //- ((HEIGHT>10)?9.:5.));
  }
  //dimAll(220); // < -- затухание эффекта для последующего кадрв
  dimAll(255U - modes[currentMode].Scale * 2);

  //byte xx = 2 + sin8( millis() / 10) / 22;
  //byte yy = 2 + cos8( millis() / 9) / 22;
  byte xx = trackingObjectState[0] + sin8( millis() / 10) / trackingObjectShift[0];// / 22;
  byte yy = trackingObjectState[1] + cos8( millis() / 9) / trackingObjectShift[1];// / 22;

  if (xx < WIDTH && yy < HEIGHT)
    leds[XY( xx, yy)] += CHSV(deltaHue , 255, 255);//0x0000FF;

  //xx = 4 + sin8( millis() / 10) / 32;
  //yy = 4 + cos8( millis() / 7) / 32;
  xx = trackingObjectState[2] + sin8( millis() / 10) / trackingObjectShift[2];// / 32;
  yy = trackingObjectState[3] + cos8( millis() / 7) / trackingObjectShift[3];// / 32;
  if (xx < WIDTH && yy < HEIGHT)
    leds[XY( xx, yy)] += CHSV(hue , 255, 255);//0xFF0000;
  leds[XY( CENTER_X_MINOR, CENTER_Y_MINOR)] += CHSV(hue2 , 255, 255);//0xFFFF00;

  noise32_x[0] += 3000;
  noise32_y[0] += 3000;
  noise32_z[0] += 3000;
  scale32_x[0] = 8000;
  scale32_y[0] = 8000;
  FillNoise(0);
  MoveFractionalNoiseX(2);
  MoveFractionalNoiseY(2, 0.33);
}

void MultipleStream3() { // Fireline
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
  if (selectedSettings) {
    setModeSettings(1U + random8(26U), 180U + random8(45U));
  }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

  blurScreen(20); // без размытия как-то пиксельно, по-моему...
  //dimAll(160); // < -- затухание эффекта для последующего кадров
  dimAll(255U - modes[currentMode].Scale * 2);
  for (uint8_t i = 1; i < WIDTH; i += 3) {
    leds[XY( i, CENTER_Y_MINOR)] += CHSV(i * 2 , 255, 255);
  }
  // Noise
  noise32_x[0] += 3000;
  noise32_y[0] += 3000;
  noise32_z[0] += 3000;
  scale32_x[0] = 8000;
  scale32_y[0] = 8000;
  FillNoise(0);
  MoveFractionalNoiseY(3);
  MoveFractionalNoiseX(3);
}

void MultipleStream5() { // Fractorial Fire
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
  if (selectedSettings) {
    setModeSettings(1U + random8(26U), 180U + random8(45U));
  }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

  blurScreen(20); // без размытия как-то пиксельно, по-моему...
  //dimAll(140); // < -- затухание эффекта для последующего кадрв
  dimAll(255U - modes[currentMode].Scale * 2);
  for (uint8_t i = 1; i < WIDTH; i += 2) {
    leds[XY( i, HEIGHT - 1)] += CHSV(i * 2, 255, 255);
  }
  // Noise
  noise32_x[0] += 3000;
  noise32_y[0] += 3000;
  noise32_z[0] += 3000;
  scale32_x[0] = 8000;
  scale32_y[0] = 8000;
  FillNoise(0);
  //MoveX(1);
  //MoveY(1);
  MoveFractionalNoiseY(2, 1);
  MoveFractionalNoiseX(2);
}

void MultipleStream4() { // Comet
  //dimAll(184); // < -- затухание эффекта для последующего кадрв
  dimAll(255U - modes[currentMode].Scale * 2);

  CRGB _eNs_color = CHSV(millis(), 255, 255);
  leds[XY( CENTER_X_MINOR, CENTER_Y_MINOR)] += _eNs_color;
  // Noise
  noise32_x[0] += 2000;
  noise32_y[0] += 2000;
  noise32_z[0] += 2000;
  scale32_x[0] = 4000;
  scale32_y[0] = 4000;
  FillNoise(0);
  MoveFractionalNoiseX(6);
  MoveFractionalNoiseY(5, -0.5);
}

// ============= Эффект Paдyжный змeй | EFF_SNAKE ===============
void MultipleStream8() { // Windows ))
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
  if (selectedSettings) {
    setModeSettings(random8(2U) ? 1U : 2U + random8(99U), 155U + random8(76U));
  }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
  if (loadingFlag) {
    loadingFlag = false;
    if (modes[currentMode].Scale > 1U)
      hue = (modes[currentMode].Scale - 2U) * 2.6;
    else
      hue = random8();
  }
  if (modes[currentMode].Scale <= 1U)
    hue++;
  dimAll(96); // < -- затухание эффекта для последующего кадра на 96/255*100=37%
  //dimAll(255U - modes[currentMode].Scale * 2); // так какая-то хрень получается
  for (uint8_t y = 2; y < HEIGHT - 1; y += 5) {
    for (uint8_t x = 2; x < WIDTH - 1; x += 5) {
      leds[XY(x, y)]  += CHSV(x * y + hue, 255, 255);
      leds[XY(x + 1, y)] += CHSV((x + 4) * y + hue, 255, 255);
      leds[XY(x, y + 1)] += CHSV(x * (y + 4) + hue, 255, 255);
      leds[XY(x + 1, y + 1)] += CHSV((x + 4) * (y + 4) + hue, 255, 255);
    }
  }
  // Noise
  noise32_x[0] += 3000;
  noise32_y[0] += 3000;
  noise32_z[0] += 3000;
  scale32_x[0] = 8000;
  scale32_y[0] = 8000;
  FillNoise(0);

  MoveFractionalNoiseX(3);
  MoveFractionalNoiseY(3);
}

//  Follow the Rainbow Comet by Palpalych (Effect for GyverLamp 02/03/2020) //

// Кометы обычные
void RainbowCometRoutine() {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
  if (selectedSettings) {
    setModeSettings(10U + random8(91U), 185U + random8(51U));
  }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

  dimAll(254U); // < -- затухание эффекта для последующего кадра
  CRGB _eNs_color = CHSV(millis() / modes[currentMode].Scale * 2, 255, 255);
  leds[XY(CENTER_X_MINOR, CENTER_Y_MINOR)] += _eNs_color;
  leds[XY(CENTER_X_MINOR + 1, CENTER_Y_MINOR)] += _eNs_color;
  leds[XY(CENTER_X_MINOR, CENTER_Y_MINOR + 1)] += _eNs_color;
  leds[XY(CENTER_X_MINOR + 1, CENTER_Y_MINOR + 1)] += _eNs_color;

  // Noise
  noise32_x[0] += 1500;
  noise32_y[0] += 1500;
  noise32_z[0] += 1500;
  scale32_x[0] = 8000;
  scale32_y[0] = 8000;
  FillNoise(0);
  MoveFractionalNoiseX(WIDTH / 2U - 1U);
  MoveFractionalNoiseY(HEIGHT / 2U - 1U);
}

// Кометы белые и одноцветные
void ColorCometRoutine() {      // <- ******* для оригинальной прошивки Gunner47 ******* (раскомментить/закоментить)
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
  if (selectedSettings) {
    setModeSettings(random8(20U) ? 1U + random8(99U) : 100U, 185U + random8(51U));
  }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

  dimAll(254U); // < -- затухание эффекта для последующего кадра
  CRGB _eNs_color = CRGB::White;

  if (modes[currentMode].Scale < 100) _eNs_color = CHSV((modes[currentMode].Scale) * 2.57, 255, 255); // 2.57 вместо 2.55, потому что при 100 будет белый цвет
  leds[XY(CENTER_X_MINOR, CENTER_Y_MINOR)] += _eNs_color;
  leds[XY(CENTER_X_MINOR + 1, CENTER_Y_MINOR)] += _eNs_color;
  leds[XY(CENTER_X_MINOR, CENTER_Y_MINOR + 1)] += _eNs_color;
  leds[XY(CENTER_X_MINOR + 1, CENTER_Y_MINOR + 1)] += _eNs_color;

  // Noise
  noise32_x[0] += 1500;
  noise32_y[0] += 1500;
  noise32_z[0] += 1500;
  scale32_x[0] = 8000;
  scale32_y[0] = 8000;
  FillNoise(0);
  MoveFractionalNoiseX(WIDTH / 2U - 1U);
  MoveFractionalNoiseY(HEIGHT / 2U - 1U);
}

// --------------------------- эффект мячики ----------------------
//  BouncingBalls2014 is a program that lets you animate an LED strip
//  to look like a group of bouncing balls
//  Daniel Wilson, 2014
//  https://github.com/githubcdr/Arduino/blob/master/bouncingballs/bouncingballs.ino
//  With BIG thanks to the FastLED community!
//  адаптация от SottNick
#define bballsGRAVITY           (-9.81)              // Downward (negative) acceleration of gravity in m/s^2
#define bballsH0                (1)                  // Starting height, in meters, of the ball (strip length)
//#define enlargedOBJECT_MAX_COUNT            (WIDTH * 2)          // максимальное количество мячиков прикручено при адаптации для бегунка Масштаб
//uint8_t enlargedObjectNUM;                                   // Number of bouncing balls you want (recommend < 7, but 20 is fun in its own way) ... количество мячиков теперь задаётся бегунком, а не константой
//uint8_t bballsCOLOR[enlargedOBJECT_MAX_COUNT] ;                   // прикручено при адаптации для разноцветных мячиков
//будем использовать uint8_t trackingObjectHue[trackingOBJECT_MAX_COUNT];
//uint8_t bballsX[enlargedOBJECT_MAX_COUNT] ;                       // прикручено при адаптации для распределения мячиков по радиусу лампы
//будем использовать uint8_t trackingObjectState[trackingOBJECT_MAX_COUNT];
//bool trackingObjectIsShift[enlargedOBJECT_MAX_COUNT] ;                      // прикручено при адаптации для того, чтобы мячики не стояли на месте
float bballsVImpact0 = SQRT_VARIANT( -2 * bballsGRAVITY * bballsH0 );  // Impact velocity of the ball when it hits the ground if "dropped" from the top of the strip
//float bballsVImpact[enlargedOBJECT_MAX_COUNT] ;                   // As time goes on the impact velocity will change, so make an array to store those values
//будем использовать float trackingObjectSpeedY[trackingOBJECT_MAX_COUNT];
//uint16_t   bballsPos[enlargedOBJECT_MAX_COUNT] ;                       // The integer position of the dot on the strip (LED index)
//будем использовать float trackingObjectPosY[trackingOBJECT_MAX_COUNT];
//long  enlargedObjectTime[enlargedOBJECT_MAX_COUNT] ;                     // The clock time of the last ground strike
//float bballsCOR[enlargedOBJECT_MAX_COUNT] ;                       // Coefficient of Restitution (bounce damping)
//будем использовать float trackingObjectShift[trackingOBJECT_MAX_COUNT];

void BBallsRoutine() {
  if (loadingFlag)
  {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      setModeSettings(26U + random8(32U), random8(3U) ? ((random8(4U) ? 127U : 0U) + 9U + random8(12U)) : (random8(4U) ? 255U : 127U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    //FastLED.clear();
    enlargedObjectNUM = (modes[currentMode].Scale - 1U) / 99.0 * (enlargedOBJECT_MAX_COUNT - 1U) + 1U;
    if (enlargedObjectNUM > enlargedOBJECT_MAX_COUNT) enlargedObjectNUM = enlargedOBJECT_MAX_COUNT;
    for (uint8_t i = 0 ; i < enlargedObjectNUM ; i++) {             // Initialize variables
      trackingObjectHue[i] = random8();
      trackingObjectState[i] = random8(0U, WIDTH);
      enlargedObjectTime[i] = millis();
      trackingObjectPosY[i] = 0U;                                // Balls start on the ground
      trackingObjectSpeedY[i] = bballsVImpact0;                // And "pop" up at vImpact0
      trackingObjectShift[i] = 0.90 - float(i) / pow(enlargedObjectNUM, 2); // это, видимо, прыгучесть. для каждого мячика уникальная изначально
      trackingObjectIsShift[i] = false;
      hue2 = (modes[currentMode].Speed > 127U) ? 255U : 0U;                                           // цветные или белые мячики
      hue = (modes[currentMode].Speed == 128U) ? 255U : 254U - modes[currentMode].Speed % 128U * 2U;  // скорость угасания хвостов 0 = моментально
    }
  }

  float bballsHi;
  float bballsTCycle;
  if (deltaValue++ & 0x01) deltaHue++; // постепенное изменение оттенка мячиков (закомментировать строчку, если не нужно)
  dimAll(hue);
  for (uint8_t i = 0 ; i < enlargedObjectNUM ; i++) {
    //leds[XY(trackingObjectState[i], trackingObjectPosY[i])] = CRGB::Black; // off for the next loop around  // теперь пиксели гасятся в dimAll()

    bballsTCycle =  (millis() - enlargedObjectTime[i]) / 1000. ; // Calculate the time since the last time the ball was on the ground

    // A little kinematics equation calculates positon as a function of time, acceleration (gravity) and intial velocity
    //bballsHi = 0.5 * bballsGRAVITY * pow(bballsTCycle, 2) + trackingObjectSpeedY[i] * bballsTCycle;
    bballsHi = 0.5 * bballsGRAVITY * bballsTCycle * bballsTCycle + trackingObjectSpeedY[i] * bballsTCycle;

    if ( bballsHi < 0 ) {
      enlargedObjectTime[i] = millis();
      bballsHi = 0; // If the ball crossed the threshold of the "ground," put it back on the ground
      trackingObjectSpeedY[i] = trackingObjectShift[i] * trackingObjectSpeedY[i] ; // and recalculate its new upward velocity as it's old velocity * COR

      if ( trackingObjectSpeedY[i] < 0.01 ) // If the ball is barely moving, "pop" it back up at vImpact0
      {
        trackingObjectShift[i] = 0.90 - float(random8(9U)) / pow(random8(4U, 9U), 2); // сделал, чтобы мячики меняли свою прыгучесть каждый цикл
        trackingObjectIsShift[i] = trackingObjectShift[i] >= 0.89;                             // если мячик максимальной прыгучести, то разрешаем ему сдвинуться
        trackingObjectSpeedY[i] = bballsVImpact0;
      }
    }

    //trackingObjectPosY[i] = round( bballsHi * (HEIGHT - 1) / bballsH0); были жалобы, что эффект вылетает
    trackingObjectPosY[i] = constrain(round( bballsHi * (HEIGHT - 1) / bballsH0), 0, HEIGHT - 1);             // Map "h" to a "pos" integer index position on the LED strip
    if (trackingObjectIsShift[i] && (trackingObjectPosY[i] == HEIGHT - 1)) {                  // если мячик получил право, то пускай сдвинется на максимальной высоте 1 раз
      trackingObjectIsShift[i] = false;
      if (trackingObjectHue[i] & 0x01) {                                       // нечётные налево, чётные направо
        if (trackingObjectState[i] == 0U) trackingObjectState[i] = WIDTH - 1U;
        else --trackingObjectState[i];
      } else {
        if (trackingObjectState[i] == WIDTH - 1U) trackingObjectState[i] = 0U;
        else ++trackingObjectState[i];
      }
    }
    leds[XY(trackingObjectState[i], trackingObjectPosY[i])] = CHSV(trackingObjectHue[i] + deltaHue, hue2, 255U);
    //drawPixelXY(trackingObjectState[i], trackingObjectPosY[i], CHSV(trackingObjectHue[i] + deltaHue, hue2, 255U));  //на случай, если останутся жалобы, что эффект вылетает
  }
}

// --------------------------- эффект спирали ----------------------
/*
   Aurora: https://github.com/pixelmatix/aurora
   https://github.com/pixelmatix/aurora/blob/sm3.0-64x64/PatternSpiro.h
   Copyright (c) 2014 Jason Coon
   Неполная адаптация SottNick
*/
byte spirotheta1 = 0;
byte spirotheta2 = 0;
//    byte spirohueoffset = 0; // будем использовать переменную сдвига оттенка hue из эффектов Радуга


const uint8_t spiroradiusx = WIDTH / 4;// - 1;
const uint8_t spiroradiusy = HEIGHT / 4;// - 1;

const uint8_t spirocenterX = WIDTH / 2;
const uint8_t spirocenterY = HEIGHT / 2;

const uint8_t spirominx = spirocenterX - spiroradiusx;
const uint8_t spiromaxx = spirocenterX + spiroradiusx - (WIDTH % 2 == 0 ? 1 : 0); //+ 1;
const uint8_t spirominy = spirocenterY - spiroradiusy;
const uint8_t spiromaxy = spirocenterY + spiroradiusy - (HEIGHT % 2 == 0 ? 1 : 0); //+ 1;

uint8_t spirocount = 1;
uint8_t spirooffset = 256 / spirocount;
boolean spiroincrement = false;

boolean spirohandledChange = false;

uint8_t mapsin8(uint8_t theta, uint8_t lowest = 0, uint8_t highest = 255) {
  uint8_t beatsin = sin8(theta);
  uint8_t rangewidth = highest - lowest;
  uint8_t scaledbeat = scale8(beatsin, rangewidth);
  uint8_t result = lowest + scaledbeat;
  return result;
}

uint8_t mapcos8(uint8_t theta, uint8_t lowest = 0, uint8_t highest = 255) {
  uint8_t beatcos = cos8(theta);
  uint8_t rangewidth = highest - lowest;
  uint8_t scaledbeat = scale8(beatcos, rangewidth);
  uint8_t result = lowest + scaledbeat;
  return result;
}

void spiroRoutine() {
  if (loadingFlag)
  {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      uint8_t rnd = random8(6U);
      if (rnd > 1U) rnd++;
      if (rnd > 3U) rnd++;
      setModeSettings(rnd * 11U + 3U, random8(10U) ? 2U + random8(26U) : 255U);
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    setCurrentPalette();
  }

  blurScreen(20); // @Palpalych советует делать размытие
  dimAll(255U - modes[currentMode].Speed / 10);

  boolean change = false;

  for (uint8_t i = 0; i < spirocount; i++) {
    uint8_t x = mapsin8(spirotheta1 + i * spirooffset, spirominx, spiromaxx);
    uint8_t y = mapcos8(spirotheta1 + i * spirooffset, spirominy, spiromaxy);

    uint8_t x2 = mapsin8(spirotheta2 + i * spirooffset, x - spiroradiusx, x + spiroradiusx);
    uint8_t y2 = mapcos8(spirotheta2 + i * spirooffset, y - spiroradiusy, y + spiroradiusy);


    //CRGB color = ColorFromPalette( PartyColors_p, (hue + i * spirooffset), 128U); // вообще-то палитра должна постоянно меняться, но до адаптации этого руки уже не дошли
    //CRGB color = ColorFromPalette(*curPalette, hue + i * spirooffset, 128U); // вот так уже прикручена к бегунку Масштаба. за
    //leds[XY(x2, y2)] += color;
    if (x2 < WIDTH && y2 < HEIGHT) // добавил проверки. не знаю, почему эффект подвисает без них
      leds[XY(x2, y2)] += (CRGB)ColorFromPalette(*curPalette, hue + i * spirooffset);

    if ((x2 == spirocenterX && y2 == spirocenterY) ||
        (x2 == spirocenterX && y2 == spirocenterY)) change = true;
  }

  spirotheta2 += 2;

  //      EVERY_N_MILLIS(12) { маловата задержочка
  spirotheta1 += 1;
  //      }

  EVERY_N_MILLIS(75) {
    if (change && !spirohandledChange) {
      spirohandledChange = true;

      if (spirocount >= WIDTH || spirocount == 1) spiroincrement = !spiroincrement;

      if (spiroincrement) {
        if (spirocount >= 4)
          spirocount *= 2;
        else
          spirocount += 1;
      }
      else {
        if (spirocount > 4)
          spirocount /= 2;
        else
          spirocount -= 1;
      }

      spirooffset = 256 / spirocount;
    }

    if (!change) spirohandledChange = false;
  }

  //      EVERY_N_MILLIS(33) { маловата задержочка
  hue += 1;
  //      }
}

// --------------------------- эффект МетаБолз ----------------------
// https://gist.github.com/StefanPetrick/170fbf141390fafb9c0c76b8a0d34e54
// Stefan Petrick's MetaBalls Effect mod by PalPalych for GyverLamp
/*
  Metaballs proof of concept by Stefan Petrick (mod by Palpalych for GyverLamp 27/02/2020)
  ...very rough 8bit math here...
  read more about the concept of isosurfaces and metaballs:
  https://www.gamedev.net/articles/programming/graphics/exploring-metaballs-and-isosurfaces-in-2d-r2556
*/
void MetaBallsRoutine() {
  if (loadingFlag)
  {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      setModeSettings(random8(8U) * 11U + 1U + random8(11U), 50U + random8(121U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    setCurrentPalette();
    speedfactor = modes[currentMode].Speed / 127.0;
  }


  // get some 2 random moving points
  uint16_t param1 = millis() * speedfactor;
  uint8_t x2 = inoise8(param1, 25355, 685 ) / WIDTH;
  uint8_t y2 = inoise8(param1, 355, 11685 ) / HEIGHT;

  uint8_t x3 = inoise8(param1, 55355, 6685 ) / WIDTH;
  uint8_t y3 = inoise8(param1, 25355, 22685 ) / HEIGHT;

  // and one Lissajou function
  uint8_t x1 = beatsin8(23 * speedfactor, 0, WIDTH - 1U);
  uint8_t y1 = beatsin8(28 * speedfactor, 0, HEIGHT - 1U);

  for (uint8_t y = 0; y < HEIGHT; y++) {
    for (uint8_t x = 0; x < WIDTH; x++) {

      // calculate distances of the 3 points from actual pixel
      // and add them together with weightening
      uint8_t  dx =  abs(x - x1);
      uint8_t  dy =  abs(y - y1);
      uint8_t dist = 2 * SQRT_VARIANT((dx * dx) + (dy * dy));

      dx =  abs(x - x2);
      dy =  abs(y - y2);
      dist += SQRT_VARIANT((dx * dx) + (dy * dy));

      dx =  abs(x - x3);
      dy =  abs(y - y3);
      dist += SQRT_VARIANT((dx * dx) + (dy * dy));

      // inverse result
      //byte color = modes[currentMode].Speed * 10 / dist;
      //byte color = 1000U / dist; кажется, проблема была именно тут в делении на ноль
      byte color = (dist == 0) ? 255U : 1000U / dist;

      // map color between thresholds
      if (color > 0 && color < 60) {
        if (modes[currentMode].Scale == 100U)
          drawPixelXY(x, y, CHSV(color * 9, 255, 255));// это оригинальный цвет эффекта
        else
          drawPixelXY(x, y, ColorFromPalette(*curPalette, color * 9));
      } else {
        if (modes[currentMode].Scale == 100U)
          drawPixelXY(x, y, CHSV(0, 255, 255)); // в оригинале центральный глаз почему-то красный
        else
          drawPixelXY(x, y, ColorFromPalette(*curPalette, 0U));
      }
      // show the 3 points, too
      drawPixelXY(x1, y1, CRGB(255, 255, 255));
      drawPixelXY(x2, y2, CRGB(255, 255, 255));
      drawPixelXY(x3, y3, CRGB(255, 255, 255));
    }
  }
}

// ***** SINUSOID3 / СИНУСОИД3 ***** + попытка повторить все остальные версии

/*
  Sinusoid3 by Stefan Petrick (mod by Palpalych for GyverLamp 27/02/2020)
  read more about the concept: https://www.youtube.com/watch?v=mubH-w_gwdA
  https://gist.github.com/StefanPetrick/dc666c1b4851d5fb8139b73719b70149
*/
// v1.7.0 - Updating for GuverLamp v1.7 by PalPalych 12.03.2020
// 2nd upd by Stepko https://wokwi.com/arduino/projects/287675911209222664
// 3rd proper by SottNick

void Sinusoid3Routine()
{
  if (loadingFlag)
  {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      uint8_t tmp = random8(100U);
      setModeSettings(tmp + 1U, 4U + random8(183U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;

    //deltaHue = (modes[currentMode].Scale - 1U) % ... + 1U;
    deltaValue = (modes[currentMode].Speed - 1U) % 9U; // количество режимов

    emitterX = WIDTH * 0.5;
    emitterY = HEIGHT * 0.5;
    //speedfactor = 0.004 * modes[currentMode].Speed + 0.015; // speed of the movement along the Lissajous curves //const float speedfactor =
    speedfactor = 0.00145 * modes[currentMode].Speed + 0.015;
  }
  float e_s3_size = 3. * modes[currentMode].Scale / 100.0 + 2;    // amplitude of the curves

  //float time_shift = float(millis()%(uint32_t)(30000*(1.0/((float)modes[currentMode].Speed/255))));
  uint32_t time_shift = millis() & 0xFFFFFF; // overflow protection

  uint16_t _scale = (((modes[currentMode].Scale - 1U) % 9U) * 10U + 80U) << 7U; // = fmap(scale, 1, 255, 0.1, 3);
  float _scale2 = (float)((modes[currentMode].Scale - 1U) % 9U) * 0.2 + 0.4; // для спиралей на sinf
  uint16_t _scale3 = ((modes[currentMode].Scale - 1U) % 9U) * 1638U + 3276U; // для спиралей на sin16


  CRGB color;

  float center1x = float(e_s3_size * sin16(speedfactor * 72.0874 * time_shift)) / 0x7FFF - emitterX;
  float center1y = float(e_s3_size * cos16(speedfactor * 98.301  * time_shift)) / 0x7FFF - emitterY;
  float center2x = float(e_s3_size * sin16(speedfactor * 68.8107 * time_shift)) / 0x7FFF - emitterX;
  float center2y = float(e_s3_size * cos16(speedfactor * 65.534  * time_shift)) / 0x7FFF - emitterY;
  float center3x = float(e_s3_size * sin16(speedfactor * 134.3447 * time_shift)) / 0x7FFF - emitterX;
  float center3y = float(e_s3_size * cos16(speedfactor * 170.3884 * time_shift)) / 0x7FFF - emitterY;

  switch (deltaValue) {
    case 0://Sinusoid I
      for (uint8_t y = 0; y < HEIGHT; y++) {
        for (uint8_t x = 0; x < WIDTH; x++) {
          float cx = x + center1x;
          float cy = y + center1y;
          int8_t v = 127 * (1 + float(sin16(_scale * SQRT_VARIANT(cx * cx + cy * cy))) / 0x7FFF);
          color.r = v;
          cx = x + center3x;
          cy = y + center3y;
          v = 127 * (1 + float(sin16(_scale * SQRT_VARIANT(cx * cx + cy * cy))) / 0x7FFF);
          color.b = v;
          drawPixelXY(x, y, color);
        }
      }
      break;
    case 1: //Sinusoid II ???
      for (uint8_t y = 0; y < HEIGHT; y++) {
        for (uint8_t x = 0; x < WIDTH; x++) {
          float cx = x + center1x;
          float cy = y + center1y;
          //int8_t v = 127 * (0.001 * time_shift * speedfactor + float(sin16(_scale * SQRT_VARIANT(cx * cx + cy * cy))) / 32767.0);
          uint8_t v = 127 * (1 + float(sin16(_scale * SQRT_VARIANT(cx * cx + cy * cy))) / 0x7FFF);
          color.r = v;

          cx = x + center2x;
          cy = y + center2y;
          //v = 127 * (float(0.001 * time_shift * speedfactor) + float(sin16(_scale * SQRT_VARIANT(cx * cx + cy * cy))) / 32767.0);
          v = 127 * (1 + float(sin16(_scale * SQRT_VARIANT(cx * cx + cy * cy))) / 0x7FFF);
          //color.g = (uint8_t)v >> 1;
          color.g = (v - (min(v, color.r) >> 1)) >> 1;
          //color.b = (uint8_t)v >> 2;
          color.b = color.g >> 2;
          color.r = max(v, color.r);
          drawPixelXY(x, y, color);
        }
      }
      break;
    case 2://Sinusoid III
      for (uint8_t y = 0; y < HEIGHT; y++) {
        for (uint8_t x = 0; x < WIDTH; x++) {
          float cx = x + center1x;
          float cy = y + center1y;
          int8_t v = 127 * (1 + float(sin16(_scale * SQRT_VARIANT(cx * cx + cy * cy))) / 0x7FFF);
          color.r = v;

          cx = x + center2x;
          cy = y + center2y;
          v = 127 * (1 + float(sin16(_scale * SQRT_VARIANT(cx * cx + cy * cy))) / 0x7FFF);
          color.b = v;

          cx = x + center3x;
          cy = y + center3y;
          v = 127 * (1 + float(sin16(_scale * SQRT_VARIANT(cx * cx + cy * cy))) / 0x7FFF);
          color.g = v;
          drawPixelXY(x, y, color);
        }
      }
      break;
    case 3: //Sinusoid IV
      for (uint8_t y = 0; y < HEIGHT; y++) {
        for (uint8_t x = 0; x < WIDTH; x++) {
          float cx = x + center1x;
          float cy = y + center1y;
          int8_t v = 127 * (1 + float(sin16(_scale * SQRT_VARIANT(cx * cx + cy * cy) + time_shift * speedfactor * 100)) / 0x7FFF);
          color.r = ~v;

          cx = x + center2x;
          cy = y + center2y;
          v = 127 * (1 + float(sin16(_scale * SQRT_VARIANT(cx * cx + cy * cy) + time_shift * speedfactor * 100)) / 0x7FFF);
          color.g = ~v;

          cx = x + center3x;
          cy = y + center3y;
          v = 127 * (1 + float(sin16(_scale * SQRT_VARIANT(cx * cx + cy * cy) + time_shift * speedfactor * 100)) / 0x7FFF);
          color.b = ~v;
          drawPixelXY(x, y, color);
        }
      }

      break;
    case 4: //changed by stepko //colored sinusoid
      for (uint8_t y = 0; y < HEIGHT; y++) {
        for (uint8_t x = 0; x < WIDTH; x++) {
          float cx = x + center1x;
          float cy = y + center1y;
          int8_t v = 127 * (1 + float(sin16(_scale * (beatsin16(2, 1000, 1750) / 2550.) * SQRT_VARIANT(cx * cx + cy * cy))) / 0x7FFF); // + time_shift * speedfactor * 5 // mass colors plus by SottNick
          color.r = v;

          //v = 127 * (1 + float(sin16(_scale * SQRT_VARIANT(cx * cx + cy * cy) + time_shift * speedfactor * 7)) / 0x7FFF);
          //v = 127 * (1 + sinf (_scale2 * SQRT_VARIANT(((cx * cx) + (cy * cy)))  + 0.001 * time_shift * speedfactor));
          v = 127 * (1 + float(sin16(_scale * (beatsin16(1, 570, 1050) / 2250.) * SQRT_VARIANT(((cx * cx) + (cy * cy)))  + 13 * time_shift * speedfactor)) / 0x7FFF); // вместо beatsin сперва ставил просто * 0.41
          color.b = v;

          //v = 127 * (1 + float(sin16(_scale * SQRT_VARIANT(cx * cx + cy * cy) + time_shift * speedfactor * 19)) / 0x7FFF);
          //v = 127 * (1 + sinf (_scale2 * SQRT_VARIANT(((cx * cx) + (cy * cy)))  + 0.0025 * time_shift * speedfactor));
          v = 127 * (1 + float(cos16(_scale * (beatsin16(3, 1900, 2550) / 2550.) * SQRT_VARIANT(((cx * cx) + (cy * cy)))  + 41 * time_shift * speedfactor)) / 0x7FFF); // вместо beatsin сперва ставил просто * 0.53
          color.g = v;
          drawPixelXY(x, y, color);
        }
      }
      break;
    case 5: //changed by stepko //sinusoid in net
      for (uint8_t y = 0; y < HEIGHT; y++) {
        for (uint8_t x = 0; x < WIDTH; x++) {
          float cx = x + center1x;
          float cy = y + center1y;
          int8_t v = 127 * (1 + float(sin16(_scale * SQRT_VARIANT(cx * cx + cy * cy) + time_shift * speedfactor * 5)) / 0x7FFF);
          color.g = ~v;

          //v = 127 * (1 + float(sin16(_scale * x) + 0.01 * time_shift * speedfactor) / 0x7FFF);
          v = 127 * (1 + float(sin16(_scale * (x + 0.005 * time_shift * speedfactor))) / 0x7FFF); // proper by SottNick

          color.b = ~v;

          //v = 127 * (1 + float(sin16(_scale * y * 127 + float(0.011 * time_shift * speedfactor))) / 0x7FFF);
          v = 127 * (1 + float(sin16(_scale * (y + 0.0055 * time_shift * speedfactor))) / 0x7FFF); // proper by SottNick
          color.r = ~v;
          drawPixelXY(x, y, color);
        }
      }
      break;
    case 6: //changed by stepko //spiral
      for (uint8_t y = 0; y < HEIGHT; y++) {
        for (uint8_t x = 0; x < WIDTH; x++) {
          float cx = x + center1x;
          float cy = y + center1y;
          //uint8_t v = 127 * (1 + float(sin16(_scale * (2 * atan2(cy, cx) + hypot(cy, cx)) + time_shift * speedfactor * 5)) / 0x7FFF);
          uint8_t v = 127 * (1 + sinf (3 * atan2(cy, cx)  + _scale2 *  hypot(cy, cx))); // proper by SottNick
          //uint8_t v = 127 * (1 + float(sin16(atan2(cy, cx) * 31255  + _scale3 *  hypot(cy, cx))) / 0x7FFF); // proper by SottNick
          //вырезаем центр спирали - proper by SottNick
          float d = SQRT_VARIANT(cx * cx + cy * cy) / 10.; // 10 - это радиус вырезаемого центра в каких-то условных величинах. 10 = 1 пиксель, 20 = 2 пикселя. как-то так
          if (d < 0.06) d = 0.06;
          if (d < 1) // просто для ускорения расчётов
            v = constrain(v - int16_t(1 / d / d), 0, 255);
          //вырезали
          color.r = v;

          cx = x + center2x;
          cy = y + center2y;
          //v = 127 * (1 + float(sin16(_scale * (2 * atan2(cy, cx) + hypot(cy, cx)) + time_shift * speedfactor * 5)) / 0x7FFF);
          v = 127 * (1 + sinf (3 * atan2(cy, cx)  + _scale2 *  hypot(cy, cx))); // proper by SottNick
          //v = 127 * (1 + float(sin16(atan2(cy, cx) * 31255  + _scale3 *  hypot(cy, cx))) / 0x7FFF); // proper by SottNick
          //вырезаем центр спирали
          d = SQRT_VARIANT(cx * cx + cy * cy) / 10.; // 10 - это радиус вырезаемого центра в каких-то условных величинах. 10 = 1 пиксель, 20 = 2 пикселя. как-то так
          if (d < 0.06) d = 0.06;
          if (d < 1) // просто для ускорения расчётов
            v = constrain(v - int16_t(1 / d / d), 0, 255);
          //вырезали
          color.b = v;

          cx = x + center3x;
          cy = y + center3y;
          //v = 127 * (1 + float(sin16(_scale * (2 * atan2(cy, cx) + hypot(cy, cx)) + time_shift * speedfactor * 5)) / 0x7FFF);
          //v = 127 * (1 + sinf (3* atan2(cy, cx)  + _scale2 *  hypot(cy, cx))); // proper by SottNick
          v = 127 * (1 + float(sin16(atan2(cy, cx) * 31255  + _scale3 *  hypot(cy, cx))) / 0x7FFF); // proper by SottNick
          //вырезаем центр спирали
          d = SQRT_VARIANT(cx * cx + cy * cy) / 10.; // 10 - это радиус вырезаемого центра в каких-то условных величинах. 10 = 1 пиксель, 20 = 2 пикселя. как-то так
          if (d < 0.06) d = 0.06;
          if (d < 1) // просто для ускорения расчётов
            v = constrain(v - int16_t(1 / d / d), 0, 255);
          //вырезали
          color.g = v;
          drawPixelXY(x, y, color);
        }
      }
      break;
    case 7: //variant by SottNick
      for (uint8_t y = 0; y < HEIGHT; y++) {
        for (uint8_t x = 0; x < WIDTH; x++) {
          float cx = x + center1x;
          float cy = y + center1y;
          //uint8_t v = 127 * (1 + float(sin16(_scale * (2 * atan2(cy, cx) + hypot(cy, cx)) + time_shift * speedfactor * 5)) / 0x7FFF);
          //uint8_t v = 127 * (1 + float(sin16(3* atan2(cy, cx) + _scale *  hypot(cy, cx) + time_shift * speedfactor * 5)) / 0x7FFF);
          //uint8_t v = 127 * (1 + sinf (3* atan2(cy, cx)  + _scale2 *  hypot(cy, cx))); // proper by SottNick
          uint8_t v = 127 * (1 + float(sin16(atan2(cy, cx) * 31255  + _scale3 *  hypot(cy, cx))) / 0x7FFF); // proper by SottNick
          //вырезаем центр спирали
          float d = SQRT_VARIANT(cx * cx + cy * cy) / 10.; // 10 - это радиус вырезаемого центра в каких-то условных величинах. 10 = 1 пиксель, 20 = 2 пикселя. как-то так
          if (d < 0.06) d = 0.06;
          if (d < 1) // просто для ускорения расчётов
            v = constrain(v - int16_t(1 / d / d), 0, 255);
          //вырезали
          color.g = v;

          cx = x + center3x;
          cy = y + center3y;
          //v = 127 * (1 + sinf (3* atan2(cy, cx)  + _scale2 *  hypot(cy, cx))); // proper by SottNick
          v = 127 * (1 + float(sin16(atan2(cy, cx) * 31255  + _scale3 *  hypot(cy, cx))) / 0x7FFF); // proper by SottNick
          //вырезаем центр спирали
          d = SQRT_VARIANT(cx * cx + cy * cy) / 10.; // 10 - это радиус вырезаемого центра в каких-то условных величинах. 10 = 1 пиксель, 20 = 2 пикселя. как-то так
          if (d < 0.06) d = 0.06;
          if (d < 1) // просто для ускорения расчётов
            v = constrain(v - int16_t(1 / d / d), 0, 255);
          //вырезали
          color.r = v;

          drawPixelXY(x, y, color);
          //nblend(leds[XY(x, y)], color, 150);
        }
      }
      break;
    case 8: //variant by SottNick
      for (uint8_t y = 0; y < HEIGHT; y++) {
        for (uint8_t x = 0; x < WIDTH; x++) {
          float cx = x + center1x;
          float cy = y + center1y;
          //uint8_t v = 127 * (1 + float(sin16(_scale * (2 * atan2(cy, cx) + hypot(cy, cx)) + time_shift * speedfactor * 5)) / 0x7FFF);
          //uint8_t v = 127 * (1 + sinf (3* atan2(cy, cx)  + _scale2 *  hypot(cy, cx))); // proper by SottNick
          //uint8_t v = 127 * (1 + float(sin16(atan2(cy, cx) * 31255  + _scale3 *  hypot(cy, cx))) / 0x7FFF); // proper by SottNick
          uint8_t v = 127 * (1 + float(sin16(_scale * SQRT_VARIANT(cx * cx + cy * cy))) / 0x7FFF);
          color.g = v;

          cx = x + center2x;
          cy = y + center2y;
          //v = 127 * (1 + float(sin16(_scale * (2 * atan2(cy, cx) + hypot(cy, cx)) + time_shift * speedfactor * 5)) / 0x7FFF);
          //v = 127 * (1 + sinf (3* atan2(cy, cx)  + _scale2 *  hypot(cy, cx))); // proper by SottNick
          v = 127 * (1 + float(sin16(atan2(cy, cx) * 31255  + _scale3 *  hypot(cy, cx))) / 0x7FFF); // proper by SottNick
          //вырезаем центр спирали
          float d = SQRT_VARIANT(cx * cx + cy * cy) / 16.; // 16 - это радиус вырезаемого центра в каких-то условных величинах. 10 = 1 пиксель, 20 = 2 пикселя. как-то так
          if (d < 0.06) d = 0.06;
          if (d < 1) // просто для ускорения расчётов
            v = constrain(v - int16_t(1 / d / d), 0, 255);
          //вырезали
          color.g = max(v, color.g);
          color.b = v;// >> 1;
          //color.r = v >> 1;

          drawPixelXY(x, y, color);
          //nblend(leds[XY(x, y)], color, 150);
        }
      }
      break;
  }
}

// ============= водо/огне/лава/радуга/хренопад ===============
// SPARKING: What chance (out of 255) is there that a new spark will be lit?
// Higher chance = more roaring fire.  Lower chance = more flickery fire.
// Default 120, suggested range 50-200.
extern const TProgmemRGBPalette16 WaterfallColors4in1_p FL_PROGMEM = {
  CRGB::Black,
  CRGB::DarkSlateGray,
  CRGB::DimGray,
  CRGB::LightSlateGray,

  CRGB::DimGray,
  CRGB::DarkSlateGray,
  CRGB::Silver,
  CRGB::DarkCyan,

  CRGB::Lavender,
  CRGB::Silver,
  CRGB::Azure,
  CRGB::LightGrey,

  CRGB::GhostWhite,
  CRGB::Silver,
  CRGB::White,
  CRGB::RoyalBlue
};

void fire2012WithPalette4in1() {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
  if (selectedSettings) {
    uint8_t tmp = random(3U);
    if (tmp == 0U)
      tmp = 16U + random8(16U);
    else if (tmp == 1U)
      tmp = 48U;
    else
      tmp = 80U + random8(4U);
    setModeSettings(tmp, 185U + random8(40U)); // 16-31, 48, 80-83 - остальное отстой
  }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

  uint8_t rCOOLINGNEW = constrain((uint16_t)(modes[currentMode].Scale % 16) * 32 / HEIGHT + 16, 1, 255) ;
  // Array of temperature readings at each simulation cell
  //static byte heat[WIDTH][HEIGHT]; будет noise3d[0][WIDTH][HEIGHT]

  for (uint8_t x = 0; x < WIDTH; x++) {
    // Step 1.  Cool down every cell a little
    for (uint8_t i = 0; i < HEIGHT; i++) {
      //noise3d[0][x][i] = qsub8(noise3d[0][x][i], random8(0, ((rCOOLINGNEW * 10) / HEIGHT) + 2));
      noise3d[0][x][i] = qsub8(noise3d[0][x][i], random8(0, rCOOLINGNEW));
    }

    // Step 2.  Heat from each cell drifts 'up' and diffuses a little
    for (uint8_t k = HEIGHT - 1; k >= 2; k--) {
      noise3d[0][x][k] = (noise3d[0][x][k - 1] + noise3d[0][x][k - 2] + noise3d[0][x][k - 2]) / 3;
    }

    // Step 3.  Randomly ignite new 'sparks' of heat near the bottom
    if (random8() < SPARKINGNEW) {
      uint8_t y = random8(2);
      noise3d[0][x][y] = qadd8(noise3d[0][x][y], random8(160, 255));
    }

    // Step 4.  Map from heat cells to LED colors
    for (uint8_t j = 0; j < HEIGHT; j++) {
      // Scale the heat value from 0-255 down to 0-240
      // for best results with color palettes.
      byte colorindex = scale8(noise3d[0][x][j], 240);
      if  (modes[currentMode].Scale < 16) {            // Lavafall
        leds[XY(x, (HEIGHT - 1) - j)] = ColorFromPalette(LavaColors_p, colorindex);
      } else if (modes[currentMode].Scale < 32) {      // Firefall
        leds[XY(x, (HEIGHT - 1) - j)] = ColorFromPalette(HeatColors_p, colorindex);
      } else if (modes[currentMode].Scale < 48) {      // Waterfall
        leds[XY(x, (HEIGHT - 1) - j)] = ColorFromPalette(WaterfallColors4in1_p, colorindex);
      } else if (modes[currentMode].Scale < 64) {      // Skyfall
        leds[XY(x, (HEIGHT - 1) - j)] = ColorFromPalette(CloudColors_p, colorindex);
      } else if (modes[currentMode].Scale < 80) {      // Forestfall
        leds[XY(x, (HEIGHT - 1) - j)] = ColorFromPalette(ForestColors_p, colorindex);
      } else if (modes[currentMode].Scale < 96) {      // Rainbowfall
        leds[XY(x, (HEIGHT - 1) - j)] = ColorFromPalette(RainbowColors_p, colorindex);
      } else {                      // Aurora
        leds[XY(x, (HEIGHT - 1) - j)] = ColorFromPalette(RainbowStripeColors_p, colorindex);
      }
    }
  }
}

// ============= ЭФФЕКТ ДОЖДЬ ===============
// от @Shaitan
void RainRoutine()
{
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
  if (selectedSettings) {
    setModeSettings(random8(10U) ? 2U + random8(99U) : 1U , 185U + random8(52U));
  }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
  for (uint8_t x = 0U; x < WIDTH; x++)
  {
    // заполняем случайно верхнюю строку
    CRGB thisColor = getPixColorXY(x, HEIGHT - 1U);
    if ((uint32_t)thisColor == 0U)
    {
      if (random8(0, 50) == 0U)
      {
        if (modes[currentMode].Scale == 1) thisColor = CHSV(random(0, 9) * 28, 255U, 255U); // Радужный дождь
        else if (modes[currentMode].Scale == 100) thisColor = 0xE0FFFF - 0x101010 * random(0, 4); // Снег
        else
          thisColor = CHSV(modes[currentMode].Scale * 2.4 + random(0, 16), 255, 255); // Цветной дождь
 
        drawPixelXY(x, HEIGHT - 1U, thisColor); // Цветной дождь
      }
    }
    else
      leds[XY(x, HEIGHT - 1U)] -= CHSV(0, 0, random(96, 128));
  }
  // сдвигаем всё вниз
  for (uint8_t x = 0U; x < WIDTH; x++)
  {
    for (uint8_t y = 0U; y < HEIGHT - 1U; y++)
    {
      drawPixelXY(x, y, getPixColorXY(x, y + 1U));
    }
  }
}

// ============= ЭФФЕКТ ПРИЗМАТА ===============
// Prismata Loading Animation
// https://github.com/pixelmatix/aurora/blob/master/PatternPendulumWave.h
// Адаптация от (c) SottNick

void PrismataRoutine() {
  if (loadingFlag)
  {
    loadingFlag = false;
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      setModeSettings(1U + random8(100U), 35U + random8(100U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    setCurrentPalette();

  }

  //  EVERY_N_MILLIS(33) { маловата задержочка
  hue++; // используем переменную сдвига оттенка из функций радуги, чтобы не занимать память
  //  }
  blurScreen(20); // @Palpalych посоветовал делать размытие
  dimAll(255U - (modes[currentMode].Scale - 1U) % 11U * 3U);

  for (uint8_t x = 0; x < WIDTH; x++)
  {
    //uint8_t y = beatsin8(x + 1, 0, HEIGHT-1); // это я попытался распотрошить данную функцию до исходного кода и вставить в неё регулятор скорости
    // вместо 28 в оригинале было 280, умножения на .Speed не было, а вместо >>17 было (<<8)>>24. короче, оригинальная скорость достигается при бегунке .Speed=20
    uint8_t beat = (GET_MILLIS() * (accum88(x + 1)) * 28 * modes[currentMode].Speed) >> 17;
    uint8_t y = scale8(sin8(beat), HEIGHT - 1);
    //и получилось!!!

    drawPixelXY(x, y, ColorFromPalette(*curPalette, x * 7 + hue));
  }
}

// ============= ЭФФЕКТ БЕГУЩАЯ СТРОКА ===============
void text_running() {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
  if (selectedSettings) {
    setModeSettings(1U + random8(100U), 50U + random8(100U));
  }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

//  while (!fillString(TextTicker, CHSV(modes[EFF_TEXT].Scale * 2.55, 255U, 255U)) && currentMode == EFF_TEXT) {
    while (!fillString(TextTicker, CHSV(modes[EFF_TEXT].Scale, 255U, 255U))) {
    parseUDP();
    delay (5);
#ifdef ESP_USE_BUTTON
    //if (buttonEnabled) в процедуре ведь есть эта проверка
    buttonTick();
#endif
  }
}

// ============= ЭФФЕКТ СТАЯ ===============
// https://github.com/pixelmatix/aurora/blob/master/PatternFlock.h
// Адаптация от (c) SottNick и @kDn

template <class T>
class Vector2 {
  public:
    T x, y;

    Vector2() : x(0), y(0) {}
    Vector2(T x, T y) : x(x), y(y) {}
    Vector2(const Vector2& v) : x(v.x), y(v.y) {}

    Vector2& operator=(const Vector2& v) {
      x = v.x;
      y = v.y;
      return *this;
    }

    bool isEmpty() {
      return x == 0 && y == 0;
    }

    bool operator==(Vector2& v) {
      return x == v.x && y == v.y;
    }

    bool operator!=(Vector2& v) {
      return !(x == y);
    }

    Vector2 operator+(Vector2& v) {
      return Vector2(x + v.x, y + v.y);
    }
    Vector2 operator-(Vector2& v) {
      return Vector2(x - v.x, y - v.y);
    }

    Vector2& operator+=(Vector2& v) {
      x += v.x;
      y += v.y;
      return *this;
    }
    Vector2& operator-=(Vector2& v) {
      x -= v.x;
      y -= v.y;
      return *this;
    }

    Vector2 operator+(double s) {
      return Vector2(x + s, y + s);
    }
    Vector2 operator-(double s) {
      return Vector2(x - s, y - s);
    }
    Vector2 operator*(double s) {
      return Vector2(x * s, y * s);
    }
    Vector2 operator/(double s) {
      return Vector2(x / s, y / s);
    }

    Vector2& operator+=(double s) {
      x += s;
      y += s;
      return *this;
    }
    Vector2& operator-=(double s) {
      x -= s;
      y -= s;
      return *this;
    }
    Vector2& operator*=(double s) {
      x *= s;
      y *= s;
      return *this;
    }
    Vector2& operator/=(double s) {
      x /= s;
      y /= s;
      return *this;
    }

    void set(T x, T y) {
      this->x = x;
      this->y = y;
    }

    void rotate(double deg) {
      double theta = deg / 180.0 * M_PI;
      double c = cos(theta);
      double s = sin(theta);
      double tx = x * c - y * s;
      double ty = x * s + y * c;
      x = tx;
      y = ty;
    }

    Vector2& normalize() {
      if (length() == 0) return *this;
      *this *= (1.0 / length());
      return *this;
    }

    float dist(Vector2 v) const {
      Vector2 d(v.x - x, v.y - y);
      return d.length();
    }
    float length() const {
      return sqrt(x * x + y * y);
    }

    float mag() const {
      return length();
    }

    float magSq() {
      return (x * x + y * y);
    }

    void truncate(double length) {
      double angle = atan2f(y, x);
      x = length * cos(angle);
      y = length * sin(angle);
    }

    Vector2 ortho() const {
      return Vector2(y, -x);
    }

    static float dot(Vector2 v1, Vector2 v2) {
      return v1.x * v2.x + v1.y * v2.y;
    }
    static float cross(Vector2 v1, Vector2 v2) {
      return (v1.x * v2.y) - (v1.y * v2.x);
    }

    void limit(float max) {
      if (magSq() > max * max) {
        normalize();
        *this *= max;
      }
    }
};

typedef Vector2<float> PVector;

// Flocking
// Daniel Shiffman <http://www.shiffman.net>
// The Nature of Code, Spring 2009

// Boid class
// Methods for Separation, Cohesion, Alignment added

class Boid {
  public:

    PVector location;
    PVector velocity;
    PVector acceleration;
    float maxforce;    // Maximum steering force
    float maxspeed;    // Maximum speed

    float desiredseparation = 4;
    float neighbordist = 8;
    byte colorIndex = 0;
    float mass;

    boolean enabled = true;

    Boid() {}

    Boid(float x, float y) {
      acceleration = PVector(0, 0);
      velocity = PVector(randomf(), randomf());
      location = PVector(x, y);
      maxspeed = 1.5;
      maxforce = 0.05;
    }

    static float randomf() {
      return mapfloat(random(0, 255), 0, 255, -.5, .5);
    }

    static float mapfloat(float x, float in_min, float in_max, float out_min, float out_max) {
      return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
    }

    void run(Boid boids [], uint8_t boidCount) {
      flock(boids, boidCount);
      update();
      // wrapAroundBorders();
      // render();
    }

    // Method to update location
    void update() {
      // Update velocity
      velocity += acceleration;
      // Limit speed
      velocity.limit(maxspeed);
      location += velocity;
      // Reset acceleration to 0 each cycle
      acceleration *= 0;
    }

    void applyForce(PVector force) {
      // We could add mass here if we want A = F / M
      acceleration += force;
    }

    void repelForce(PVector obstacle, float radius) {
      //Force that drives boid away from obstacle.

      PVector futPos = location + velocity; //Calculate future position for more effective behavior.
      PVector dist = obstacle - futPos;
      float d = dist.mag();

      if (d <= radius) {
        PVector repelVec = location - obstacle;
        repelVec.normalize();
        if (d != 0) { //Don't divide by zero.
          // float scale = 1.0 / d; //The closer to the obstacle, the stronger the force.
          repelVec.normalize();
          repelVec *= (maxforce * 7);
          if (repelVec.mag() < 0) { //Don't let the boids turn around to avoid the obstacle.
            repelVec.y = 0;
          }
        }
        applyForce(repelVec);
      }
    }

    // We accumulate a new acceleration each time based on three rules
    void flock(Boid boids [], uint8_t boidCount) {
      PVector sep = separate(boids, boidCount);   // Separation
      PVector ali = align(boids, boidCount);      // Alignment
      PVector coh = cohesion(boids, boidCount);   // Cohesion
      // Arbitrarily weight these forces
      sep *= 1.5;
      ali *= 1.0;
      coh *= 1.0;
      // Add the force vectors to acceleration
      applyForce(sep);
      applyForce(ali);
      applyForce(coh);
    }

    // Separation
    // Method checks for nearby boids and steers away
    PVector separate(Boid boids [], uint8_t boidCount) {
      PVector steer = PVector(0, 0);
      int count = 0;
      // For every boid in the system, check if it's too close
      for (int i = 0; i < boidCount; i++) {
        Boid other = boids[i];
        if (!other.enabled)
          continue;
        float d = location.dist(other.location);
        // If the distance is greater than 0 and less than an arbitrary amount (0 when you are yourself)
        if ((d > 0) && (d < desiredseparation)) {
          // Calculate vector pointing away from neighbor
          PVector diff = location - other.location;
          diff.normalize();
          diff /= d;        // Weight by distance
          steer += diff;
          count++;            // Keep track of how many
        }
      }
      // Average -- divide by how many
      if (count > 0) {
        steer /= (float) count;
      }

      // As long as the vector is greater than 0
      if (steer.mag() > 0) {
        // Implement Reynolds: Steering = Desired - Velocity
        steer.normalize();
        steer *= maxspeed;
        steer -= velocity;
        steer.limit(maxforce);
      }
      return steer;
    }

    // Alignment
    // For every nearby boid in the system, calculate the average velocity
    PVector align(Boid boids [], uint8_t boidCount) {
      PVector sum = PVector(0, 0);
      int count = 0;
      for (int i = 0; i < boidCount; i++) {
        Boid other = boids[i];
        if (!other.enabled)
          continue;
        float d = location.dist(other.location);
        if ((d > 0) && (d < neighbordist)) {
          sum += other.velocity;
          count++;
        }
      }
      if (count > 0) {
        sum /= (float) count;
        sum.normalize();
        sum *= maxspeed;
        PVector steer = sum - velocity;
        steer.limit(maxforce);
        return steer;
      }
      else {
        return PVector(0, 0);
      }
    }

    // Cohesion
    // For the average location (i.e. center) of all nearby boids, calculate steering vector towards that location
    PVector cohesion(Boid boids [], uint8_t boidCount) {
      PVector sum = PVector(0, 0);   // Start with empty vector to accumulate all locations
      int count = 0;
      for (int i = 0; i < boidCount; i++) {
        Boid other = boids[i];
        if (!other.enabled)
          continue;
        float d = location.dist(other.location);
        if ((d > 0) && (d < neighbordist)) {
          sum += other.location; // Add location
          count++;
        }
      }
      if (count > 0) {
        sum /= count;
        return seek(sum);  // Steer towards the location
      }
      else {
        return PVector(0, 0);
      }
    }

    // A method that calculates and applies a steering force towards a target
    // STEER = DESIRED MINUS VELOCITY
    PVector seek(PVector target) {
      PVector desired = target - location;  // A vector pointing from the location to the target
      // Normalize desired and scale to maximum speed
      desired.normalize();
      desired *= maxspeed;
      // Steering = Desired minus Velocity
      PVector steer = desired - velocity;
      steer.limit(maxforce);  // Limit to maximum steering force
      return steer;
    }

    // A method that calculates a steering force towards a target
    // STEER = DESIRED MINUS VELOCITY
    void arrive(PVector target) {
      PVector desired = target - location;  // A vector pointing from the location to the target
      float d = desired.mag();
      // Normalize desired and scale with arbitrary damping within 100 pixels
      desired.normalize();
      if (d < 4) {
        float m = map(d, 0, 100, 0, maxspeed);
        desired *= m;
      }
      else {
        desired *= maxspeed;
      }

      // Steering = Desired minus Velocity
      PVector steer = desired - velocity;
      steer.limit(maxforce);  // Limit to maximum steering force
      applyForce(steer);
    }

    void wrapAroundBorders() {
      if (location.x < 0) location.x = WIDTH - 1;
      if (location.y < 0) location.y = HEIGHT - 1;
      if (location.x >= WIDTH) location.x = 0;
      if (location.y >= HEIGHT) location.y = 0;
    }

    void avoidBorders() {
      PVector desired = velocity;

      if (location.x < 8) desired = PVector(maxspeed, velocity.y);
      if (location.x >= WIDTH - 8) desired = PVector(-maxspeed, velocity.y);
      if (location.y < 8) desired = PVector(velocity.x, maxspeed);
      if (location.y >= HEIGHT - 8) desired = PVector(velocity.x, -maxspeed);

      if (desired != velocity) {
        PVector steer = desired - velocity;
        steer.limit(maxforce);
        applyForce(steer);
      }

      if (location.x < 0) location.x = 0;
      if (location.y < 0) location.y = 0;
      if (location.x >= WIDTH) location.x = WIDTH - 1;
      if (location.y >= HEIGHT) location.y = HEIGHT - 1;
    }

    bool bounceOffBorders(float bounce) {
      bool bounced = false;

      if (location.x >= WIDTH) {
        location.x = WIDTH - 1;
        velocity.x *= -bounce;
        bounced = true;
      }
      else if (location.x < 0) {
        location.x = 0;
        velocity.x *= -bounce;
        bounced = true;
      }

      if (location.y >= HEIGHT) {
        location.y = HEIGHT - 1;
        velocity.y *= -bounce;
        bounced = true;
      }
      else if (location.y < 0) {
        location.y = 0;
        velocity.y *= -bounce;
        bounced = true;
      }

      return bounced;
    }

    void render() {
      // // Draw a triangle rotated in the direction of velocity
      // float theta = velocity.heading2D() + radians(90);
      // fill(175);
      // stroke(0);
      // pushMatrix();
      // translate(location.x,location.y);
      // rotate(theta);
      // beginShape(TRIANGLES);
      // vertex(0, -r*2);
      // vertex(-r, r*2);
      // vertex(r, r*2);
      // endShape();
      // popMatrix();
      // backgroundLayer.drawPixel(location.x, location.y, CRGB::Blue);
    }
};

static const uint8_t AVAILABLE_BOID_COUNT = 20U;
Boid boids[AVAILABLE_BOID_COUNT];

static const uint8_t boidCount = 10;
Boid predator;
PVector wind;
bool predatorPresent = true;

void flockRoutine(bool predatorIs) {
  if (loadingFlag)
  {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      //setModeSettings(random8(8U)*11U+1U+random8(11U), 1U+random8(255U));
      uint8_t tmp = random8(5U);// 0, 1, 5, 6, 7 - остальные 4 палитры с чёрным цветом - стая будет исчезать периодически (2, 3, 4, 8)
      if (tmp > 1U) tmp += 3U;
      setModeSettings(tmp * 11U + 2U + random8(10U), 1U + random8(255U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    setCurrentPalette();

    for (int i = 0; i < boidCount; i++) {
      boids[i] = Boid(0, 0);//WIDTH - 1U, HEIGHT - 1U);
      boids[i].maxspeed = 0.380 * modes[currentMode].Speed / 127.0 + 0.380 / 2;
      boids[i].maxforce = 0.015 * modes[currentMode].Speed / 127.0 + 0.015 / 2;
    }
    predatorPresent = predatorIs && random8(2U);
    //if (predatorPresent) { нужно присвоить ему значения при первом запуске, иначе он с нулями будет жить
    predator = Boid(0, 0);//WIDTH + WIDTH - 1, HEIGHT + HEIGHT - 1);
    predator.maxspeed = 0.385 * modes[currentMode].Speed / 127.0 + 0.385 / 2;
    predator.maxforce = 0.020 * modes[currentMode].Speed / 127.0 + 0.020 / 2;
    predator.neighbordist = 8.0; // было 16.0 и хищник гонял по одной линии всегда
    predator.desiredseparation = 0.0;
    //}
  }

  blurScreen(15); // @Palpalych советует делать размытие
  //myLamp.dimAll(254U - (31-(myLamp.effects.getScale()%32))*8);
  dimAll(255U - (modes[currentMode].Scale - 1U) % 11U * 3);

  bool applyWind = random(0, 255) > 240;
  if (applyWind) {
    wind.x = Boid::randomf() * .015 * modes[currentMode].Speed / 127.0 + .015 / 2;
    wind.y = Boid::randomf() * .015 * modes[currentMode].Speed / 127.0 + .015 / 2;
  }

  CRGB color = ColorFromPalette(*curPalette, hue);


  for (int i = 0; i < boidCount; i++) {
    Boid * boid = &boids[i];

    if (predatorPresent) {
      // flee from predator
      boid->repelForce(predator.location, 10);
    }

    boid->run(boids, boidCount);
    boid->wrapAroundBorders();
    PVector location = boid->location;
    // PVector velocity = boid->velocity;
    // backgroundLayer.drawLine(location.x, location.y, location.x - velocity.x, location.y - velocity.y, color);
    // effects.leds[XY(location.x, location.y)] += color;
    //drawPixelXY(location.x, location.y, color);
    drawPixelXYF(location.x, location.y, color);

    if (applyWind) {
      boid->applyForce(wind);
      applyWind = false;
    }
  }

  if (predatorPresent) {
    predator.run(boids, boidCount);
    predator.wrapAroundBorders();
    color = ColorFromPalette(*curPalette, hue + 128);
    PVector location = predator.location;
    // PVector velocity = predator.velocity;
    // backgroundLayer.drawLine(location.x, location.y, location.x - velocity.x, location.y - velocity.y, color);
    // effects.leds[XY(location.x, location.y)] += color;

    //drawPixelXY(location.x, location.y, color);
    drawPixelXYF(location.x, location.y, color);
  }

  EVERY_N_MILLIS(333) {
    hue++;
  }

  EVERY_N_SECONDS(30) {
    predatorPresent = predatorIs && !predatorPresent;
  }
}


// ============= ЭФФЕКТ ВИХРИ ===============
// https://github.com/pixelmatix/aurora/blob/master/PatternFlowField.h
// Адаптация (c) SottNick
// используются переменные эффекта Стая. Без него работать не будет.

//uint16_t ff_x; вынесены в общий пул
//uint16_t ff_y;
//uint16_t ff_z;

static const uint8_t ff_speed = 1; // чем выше этот параметр, тем короче переходы (градиенты) между цветами. 1 - это самое красивое
static const uint8_t ff_scale = 26; // чем больше этот параметр, тем больше "языков пламени" или как-то так. 26 - это норм

void whirlRoutine(bool oneColor) {
  if (loadingFlag)
  {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      if (oneColor)
        setModeSettings(random8(30U) ? 1U + random8(99U) : 100U, 221U + random8(32U));
      else {
        uint8_t tmp = random8(5U);
        if (tmp > 1U) tmp += 3U;
        setModeSettings(tmp * 11U + 3U, 221U + random8(32U));
      }
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    setCurrentPalette();

    ff_x = random16();
    ff_y = random16();
    ff_z = random16();

    for (uint8_t i = 0; i < AVAILABLE_BOID_COUNT; i++) {
      boids[i] = Boid(random8(WIDTH), 0);
    }
  }
  dimAll(240);

  for (uint8_t i = 0; i < AVAILABLE_BOID_COUNT; i++) {
    Boid * boid = &boids[i];

    int ioffset = ff_scale * boid->location.x;
    int joffset = ff_scale * boid->location.y;

    byte angle = inoise8(ff_x + ioffset, ff_y + joffset, ff_z);

    boid->velocity.x = (float) sin8(angle) * 0.0078125 - 1.0;
    boid->velocity.y = -((float)cos8(angle) * 0.0078125 - 1.0);
    boid->update();

    if (oneColor)
      //drawPixelXY(boid->location.x, boid->location.y, CHSV(modes[currentMode].Scale * 2.55, (modes[currentMode].Scale == 100) ? 0U : 255U, 255U)); // цвет белый для .Scale=100
      drawPixelXYF(boid->location.x, boid->location.y, CHSV(modes[currentMode].Scale * 2.55, (modes[currentMode].Scale == 100) ? 0U : 255U, 255U)); // цвет белый для .Scale=100
    else
      //drawPixelXY(boid->location.x, boid->location.y, ColorFromPalette(*curPalette, angle + hue)); // + hue постепенно сдвигает палитру по кругу
      drawPixelXYF(boid->location.x, boid->location.y, ColorFromPalette(*curPalette, angle + hue)); // + hue постепенно сдвигает палитру по кругу

    if (boid->location.x < 0 || boid->location.x >= WIDTH || boid->location.y < 0 || boid->location.y >= HEIGHT) {
      boid->location.x = random(WIDTH);
      boid->location.y = 0;
    }
  }

  EVERY_N_MILLIS(200) {
    hue++;
  }

  ff_x += ff_speed;
  ff_y += ff_speed;
  ff_z += ff_speed;
}

// ============= ЭФФЕКТ ВОЛНЫ ===============
// https://github.com/pixelmatix/aurora/blob/master/PatternWave.h
// Адаптация от (c) SottNick

byte waveThetaUpdate = 0;
byte waveThetaUpdateFrequency = 0;
byte waveTheta = 0;

byte hueUpdate = 0;
byte hueUpdateFrequency = 0;
//    byte hue = 0; будем использовать сдвиг от эффектов Радуга

byte waveRotation = 0;
uint8_t waveScale = 256 / WIDTH;
uint8_t waveCount = 1;

void WaveRoutine() {
  if (loadingFlag)
  {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      uint8_t tmp = random8(5U);// 0, 1, 5, 6, 7 - остальные 4 палитры с чёрным цветом - будет мерцать (2, 3, 4, 8)
      if (tmp > 1U) tmp += 3U;
      setModeSettings(tmp * 11U + 1U + random8(4U), 220U + random8(17U) * 2U);
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    setCurrentPalette();//а вот тут явно накосячено. палитры наложены на угол поворота несинхронно, но исправлять особого смысла нет

    //waveRotation = random(0, 4);// теперь вместо этого регулятор Масштаб
    waveRotation = (modes[currentMode].Scale % 11U) % 4U;//(modes[currentMode].Scale - 1) / 25U;
    //waveCount = random(1, 3);// теперь вместо этого чётное/нечётное у регулятора Скорость
    waveCount = modes[currentMode].Speed & 0x01;//% 2;
    //waveThetaUpdateFrequency = random(1, 2);
    //hueUpdateFrequency = random(1, 6);
  }

  dimAll(254);

  int n = 0;

  switch (waveRotation) {
    case 0:
      for (uint8_t x = 0; x < WIDTH; x++) {
        n = quadwave8(x * 2 + waveTheta) / waveScale;
        drawPixelXY(x, n, ColorFromPalette(*curPalette, hue + x));
        if (waveCount != 1)
          drawPixelXY(x, HEIGHT - 1 - n, ColorFromPalette(*curPalette, hue + x));
      }
      break;

    case 1:
      for (uint8_t y = 0; y < HEIGHT; y++) {
        n = quadwave8(y * 2 + waveTheta) / waveScale;
        drawPixelXY(n, y, ColorFromPalette(*curPalette, hue + y));
        if (waveCount != 1)
          drawPixelXY(WIDTH - 1 - n, y, ColorFromPalette(*curPalette, hue + y));
      }
      break;

    case 2:
      for (uint8_t x = 0; x < WIDTH; x++) {
        n = quadwave8(x * 2 - waveTheta) / waveScale;
        drawPixelXY(x, n, ColorFromPalette(*curPalette, hue + x));
        if (waveCount != 1)
          drawPixelXY(x, HEIGHT - 1 - n, ColorFromPalette(*curPalette, hue + x));
      }
      break;

    case 3:
      for (uint8_t y = 0; y < HEIGHT; y++) {
        n = quadwave8(y * 2 - waveTheta) / waveScale;
        drawPixelXY(n, y, ColorFromPalette(*curPalette, hue + y));
        if (waveCount != 1)
          drawPixelXY(WIDTH - 1 - n, y, ColorFromPalette(*curPalette, hue + y));
      }
      break;
  }


  if (waveThetaUpdate >= waveThetaUpdateFrequency) {
    waveThetaUpdate = 0;
    waveTheta++;
  }
  else {
    waveThetaUpdate++;
  }

  if (hueUpdate >= hueUpdateFrequency) {
    hueUpdate = 0;
    hue++;
  }
  else {
    hueUpdate++;
  }

  blurScreen(20); // @Palpalych советует делать размытие. вот в этом эффекте его явно не хватает...
}

// ============= ЭФФЕКТ ОГОНЬ 2018 ===============
// https://gist.github.com/StefanPetrick/819e873492f344ebebac5bcd2fdd8aa8
// https://gist.github.com/StefanPetrick/1ba4584e534ba99ca259c1103754e4c5
// Адаптация от (c) SottNick

// parameters and buffer for the noise array
// (вместо закомментированных строк используются массивы и переменные от эффекта Кометы для экономии памяти)
//define NUM_LAYERS 2 // менять бесполезно, так как в коде чётко использовано 2 слоя
//uint32_t noise32_x[NUM_LAYERSMAX];
//uint32_t noise32_y[NUM_LAYERSMAX];
//uint32_t noise32_z[NUM_LAYERSMAX];
//uint32_t scale32_x[NUM_LAYERSMAX];
//uint32_t scale32_y[NUM_LAYERSMAX];
//uint8_t noise3d[NUM_LAYERSMAX][WIDTH][HEIGHT];
//uint8_t fire18heat[NUM_LEDS]; будем использовать вместо него ledsbuff[NUM_LEDS].r
// this finds the right index within a serpentine matrix

void Fire2018_2() {
  //  const uint8_t CENTER_Y_MAJOR =  HEIGHT / 2 + (HEIGHT % 2);
  //  const uint8_t CENTER_X_MAJOR =  WIDTH / 2  + (WIDTH % 2) ;

#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
  if (selectedSettings) {
    setModeSettings(1U + random8(50U), 195U + random8(44U));
  }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)


  // some changing values
  uint16_t ctrl1 = inoise16(11 * millis(), 0, 0);
  uint16_t ctrl2 = inoise16(13 * millis(), 100000, 100000);
  uint16_t  ctrl = ((ctrl1 + ctrl2) / 2);

  // parameters for the heatmap
  uint16_t speed = 25;
  noise32_x[0] = 3 * ctrl * speed;
  noise32_y[0] = 20 * millis() * speed;
  noise32_z[0] = 5 * millis() * speed ;
  scale32_x[0] = ctrl1 / 2;
  scale32_y[0] = ctrl2 / 2;

  //calculate the noise data
  uint8_t layer = 0;

  for (uint8_t i = 0; i < WIDTH; i++) {
    uint32_t ioffset = scale32_x[layer] * (i - CENTER_X_MAJOR);
    for (uint8_t j = 0; j < HEIGHT; j++) {
      uint32_t joffset = scale32_y[layer] * (j - CENTER_Y_MAJOR);
      uint16_t data = ((inoise16(noise32_x[layer] + ioffset, noise32_y[layer] + joffset, noise32_z[layer])) + 1);
      noise3d[layer][i][j] = data >> 8;
    }
  }

  // parameters for te brightness mask
  speed = 20;
  noise32_x[1] = 3 * ctrl * speed;
  noise32_y[1] = 20 * millis() * speed;
  noise32_z[1] = 5 * millis() * speed ;
  scale32_x[1] = ctrl1 / 2;
  scale32_y[1] = ctrl2 / 2;

  //calculate the noise data
  layer = 1;
  for (uint8_t i = 0; i < WIDTH; i++) {
    uint32_t ioffset = scale32_x[layer] * (i - CENTER_X_MAJOR);
    for (uint8_t j = 0; j < HEIGHT; j++) {
      uint32_t joffset = scale32_y[layer] * (j - CENTER_Y_MAJOR);
      uint16_t data = ((inoise16(noise32_x[layer] + ioffset, noise32_y[layer] + joffset, noise32_z[layer])) + 1);
      noise3d[layer][i][j] = data >> 8;
    }
  }

  // draw lowest line - seed the fire
  for (uint8_t x = 0; x < WIDTH; x++) {
    ledsbuff[XY(x, HEIGHT - 1)].r =  noise3d[0][WIDTH - 1 - x][CENTER_Y_MAJOR - 1]; // хз, почему взято с середины. вожможно, нужно просто с 7 строки вне зависимости от высоты матрицы
  }


  //copy everything one line up
  for (uint8_t y = 0; y < HEIGHT - 1; y++) {
    for (uint8_t x = 0; x < WIDTH; x++) {
      ledsbuff[XY(x, y)].r = ledsbuff[XY(x, y + 1)].r;
    }
  }

  //dim
  for (uint8_t y = 0; y < HEIGHT - 1; y++) {
    for (uint8_t x = 0; x < WIDTH; x++) {
      uint8_t dim = noise3d[0][x][y];
      // high value = high flames
      dim = dim / 1.7;
      dim = 255 - dim;
      ledsbuff[XY(x, y)].r = scale8(ledsbuff[XY(x, y)].r , dim);
    }
  }

  for (uint8_t y = 0; y < HEIGHT; y++) {
    for (uint8_t x = 0; x < WIDTH; x++) {
      // map the colors based on heatmap
      //leds[XY(x, HEIGHT - 1 - y)] = CRGB( ledsbuff[XY(x, y)].r, 1 , 0);
      //leds[XY(x, HEIGHT - 1 - y)] = CRGB( ledsbuff[XY(x, y)].r, ledsbuff[XY(x, y)].r * 0.153, 0);// * 0.153 - лучший оттенок
      leds[XY(x, HEIGHT - 1 - y)] = CRGB( ledsbuff[XY(x, y)].r, (float)ledsbuff[XY(x, y)].r * modes[currentMode].Scale * 0.01, 0);


      //пытался понять, как регулировать оттенок пламени...
      //  if (modes[currentMode].Scale > 50)
      //    leds[XY(x, HEIGHT - 1 - y)] = CRGB( ledsbuff[XY(x, y)].r, ledsbuff[XY(x, y)].r * (modes[currentMode].Scale % 50)  * 0.051, 0);
      //  else
      //    leds[XY(x, HEIGHT - 1 - y)] = CRGB( ledsbuff[XY(x, y)].r, 1 , ledsbuff[XY(x, y)].r * modes[currentMode].Scale * 0.051);
      //примерно понял

      // dim the result based on 2nd noise layer
      leds[XY(x, HEIGHT - 1 - y)].nscale8(noise3d[1][x][y]);
    }
  }

}

// ============= ЭФФЕКТ ОГОНЬ 2012 ===============
// там выше есть его копии для эффектов Водопад и Водопад 4 в 1
// по идее, надо бы объединить и оптимизировать, но мелких отличий довольно много
// based on FastLED example Fire2012WithPalette: https://github.com/FastLED/FastLED/blob/master/examples/Fire2012WithPalette/Fire2012WithPalette.ino

void fire2012again()
{
  if (loadingFlag)
  {
    loadingFlag = false;
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      uint8_t tmp = 17U + random8(55U);
      if (tmp > 22) tmp += 28;
      setModeSettings(tmp, 185U + random8(50U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    if (modes[currentMode].Scale > 100) modes[currentMode].Scale = 100; // чтобы не было проблем при прошивке без очистки памяти
    if (modes[currentMode].Scale > 50)
      //fire_p = firePalettes[(int)((float)modes[currentMode].Scale/12)];
      //fire_p = firePalettes[(uint8_t)((modes[currentMode].Scale % 50)/5.56F)];
      curPalette = firePalettes[(uint8_t)((modes[currentMode].Scale - 50) / 50.0F * ((sizeof(firePalettes) / sizeof(TProgmemRGBPalette16 *)) - 0.01F))];
    else
      curPalette = palette_arr[(uint8_t)(modes[currentMode].Scale / 50.0F * ((sizeof(palette_arr) / sizeof(TProgmemRGBPalette16 *)) - 0.01F))];
  }

#if HEIGHT/6 > 6
#define FIRE_BASE 6
#else
#define FIRE_BASE HEIGHT/6+1
#endif
  // COOLING: How much does the air cool as it rises?
  // Less cooling = taller flames.  More cooling = shorter flames.
#define cooling 70U
  // SPARKING: What chance (out of 255) is there that a new spark will be lit?
  // Higher chance = more roaring fire.  Lower chance = more flickery fire.
#define sparking 130U
  // SMOOTHING; How much blending should be done between frames
  // Lower = more blending and smoother flames. Higher = less blending and flickery flames
#define fireSmoothing 80U
  // Add entropy to random number generator; we use a lot of it.
  random16_add_entropy(random(256));

  // Loop for each column individually
  for (uint8_t x = 0; x < WIDTH; x++) {
    // Step 1.  Cool down every cell a little
    for (uint8_t i = 0; i < HEIGHT; i++) {
      noise3d[0][x][i] = qsub8(noise3d[0][x][i], random(0, ((cooling * 10) / HEIGHT) + 2));
    }

    // Step 2.  Heat from each cell drifts 'up' and diffuses a little
    for (uint8_t k = HEIGHT - 1; k > 0; k--) { // fixed by SottNick
      noise3d[0][x][k] = (noise3d[0][x][k - 1] + noise3d[0][x][k - 1] + noise3d[0][x][wrapY(k - 2)]) / 3; // fixed by SottNick
    }

    // Step 3.  Randomly ignite new 'sparks' of heat near the bottom
    if (random8() < sparking) {
      uint8_t j = random8(FIRE_BASE);
      noise3d[0][x][j] = qadd8(noise3d[0][x][j], random(160, 255));
    }

    // Step 4.  Map from heat cells to LED colors
    // Blend new data with previous frame. Average data between neighbouring pixels
    for (uint8_t y = 0; y < HEIGHT; y++)
      nblend(leds[XY(x, y)], ColorFromPalette(*curPalette, ((noise3d[0][x][y] * 0.7) + (noise3d[0][wrapX(x + 1)][y] * 0.3))), fireSmoothing);
  }
}

// ============= ЭФФЕКТЫ ОСАДКИ / ТУЧКА В БАНКЕ / ГРОЗА В БАНКЕ ===============
// https://github.com/marcmerlin/FastLED_NeoMatrix_SmartMatrix_LEDMatrix_GFX_Demos/blob/master/FastLED/Sublime_Demos/Sublime_Demos.ino
// там по ссылке ещё остались эффекты с 3 по 9 (в SimplePatternList перечислены)

//прикольная процедура добавляет блеск почти к любому эффекту после его отрисовки https://www.youtube.com/watch?v=aobtR1gIyIo
//void addGlitter( uint8_t chanceOfGlitter){
//  if ( random8() < chanceOfGlitter) leds[ random16(NUM_LEDS) ] += CRGB::White;
//}

//static uint8_t intensity = 42;  // будет бегунок масштаба

// Array of temp cells (used by fire, theMatrix, coloredRain, stormyRain)
// uint8_t **tempMatrix; = noise3d[0][WIDTH][HEIGHT]
// uint8_t *splashArray; = line[WIDTH] из эффекта Огонь

CRGB solidRainColor = CRGB(60, 80, 90);

uint8_t wrapX(int8_t x) {
  return (x + WIDTH) % WIDTH;
}
uint8_t wrapY(int8_t y) {
  return (y + HEIGHT) % HEIGHT;
}

void rain(byte backgroundDepth, byte maxBrightness, byte spawnFreq, byte tailLength, CRGB rainColor, bool splashes, bool clouds, bool storm)
{
  ff_x = random16();
  ff_y = random16();
  ff_z = random16();

  CRGB lightningColor = CRGB(72, 72, 80);
  CRGBPalette16 rain_p( CRGB::Black, rainColor );
#ifdef SMARTMATRIX
  CRGBPalette16 rainClouds_p( CRGB::Black, CRGB(75, 84, 84), CRGB(49, 75, 75), CRGB::Black );
#else
  CRGBPalette16 rainClouds_p( CRGB::Black, CRGB(15, 24, 24), CRGB(9, 15, 15), CRGB::Black );
#endif

  //fadeToBlackBy( leds, NUM_LEDS, 255-tailLength);
  dimAll(tailLength);

  // Loop for each column individually
  for (uint8_t x = 0; x < WIDTH; x++) {
    // Step 1.  Move each dot down one cell
    for (uint8_t i = 0; i < HEIGHT; i++) {
      if (noise3d[0][x][i] >= backgroundDepth) {  // Don't move empty cells
        if (i > 0) noise3d[0][x][wrapY(i - 1)] = noise3d[0][x][i];
        noise3d[0][x][i] = 0;
      }
    }

    // Step 2.  Randomly spawn new dots at top
    if (random8() < spawnFreq) {
      noise3d[0][x][HEIGHT - 1] = random(backgroundDepth, maxBrightness);
    }

    // Step 3. Map from tempMatrix cells to LED colors
    for (uint8_t y = 0; y < HEIGHT; y++) {
      if (noise3d[0][x][y] >= backgroundDepth) {  // Don't write out empty cells
        leds[XY(x, y)] = ColorFromPalette(rain_p, noise3d[0][x][y]);
      }
    }

    // Step 4. Add splash if called for
    if (splashes) {
      // FIXME, this is broken
      byte j = line[x];
      byte v = noise3d[0][x][0];

      if (j >= backgroundDepth) {
        leds[XY(wrapX(x - 2), 0)] = ColorFromPalette(rain_p, j / 3);
        leds[XY(wrapX(x + 2), 0)] = ColorFromPalette(rain_p, j / 3);
        line[x] = 0;   // Reset splash
      }

      if (v >= backgroundDepth) {
        leds[XY(wrapX(x - 1), 1)] = ColorFromPalette(rain_p, v / 2);
        leds[XY(wrapX(x + 1), 1)] = ColorFromPalette(rain_p, v / 2);
        line[x] = v; // Prep splash for next frame
      }
    }

    // Step 5. Add lightning if called for
    if (storm) {
      //uint8_t lightning[WIDTH][HEIGHT];
      // ESP32 does not like static arrays  https://github.com/espressif/arduino-esp32/issues/2567
      uint8_t *lightning = (uint8_t *) malloc(WIDTH * HEIGHT);
      while (lightning == NULL) {
        #if defined(GENERAL_DEBUG)
          LOG.println("lightning malloc failed");
        #endif
      }


//      if (random16() < 72) {    // Odds of a lightning bolt
      uint8_t dir_l = FlashSoundRoutine();
      if (dir_l>0) {    // Odds of a lightning bolt
        lightning[scale8(random8(), WIDTH - 1) + (HEIGHT - 1) * WIDTH] = 255; // Random starting location
        for (uint8_t ly = HEIGHT - 1; ly > 1; ly--) {
          for (uint8_t lx = 1; lx < WIDTH - 1; lx++) {
            if (lightning[lx + ly * WIDTH] == 255) {
              lightning[lx + ly * WIDTH] = 0;
              uint8_t dir = random8(4);
              if (dir_l>1) {dir=3;dir_l--;}
//              uint8_t dir = random8(4);
              switch (dir) {
                case 0:
                  leds[XY(lx + 1, ly - 1)] = lightningColor;
                  lightning[(lx + 1) + (ly - 1) * WIDTH] = 255; // move down and right
                  break;
                case 1:
                  leds[XY(lx, ly - 1)] = CRGB(128, 128, 128); // я без понятия, почему у верхней молнии один оттенок, а у остальных - другой
                  lightning[lx + (ly - 1) * WIDTH] = 255;  // move down
                  break;
                case 2:
                  leds[XY(lx - 1, ly - 1)] = CRGB(128, 128, 128);
                  lightning[(lx - 1) + (ly - 1) * WIDTH] = 255; // move down and left
                  break;
                case 3:
                  leds[XY(lx - 1, ly - 1)] = CRGB(128, 128, 128);
                  lightning[(lx - 1) + (ly - 1) * WIDTH] = 255; // fork down and left
                  leds[XY(lx - 1, ly - 1)] = CRGB(128, 128, 128);
                  lightning[(lx + 1) + (ly - 1) * WIDTH] = 255; // fork down and right
                  break;
              }
            }
          }
        }
      }
      free(lightning);
    }

    // Step 6. Add clouds if called for
    if (clouds) {
      uint16_t noiseScale = 250;  // A value of 1 will be so zoomed in, you'll mostly see solid colors. A value of 4011 will be very zoomed out and shimmery
      //const uint16_t cloudHeight = (HEIGHT*0.2)+1;
      const uint8_t cloudHeight = HEIGHT * 0.4 + 1; // это уже 40% c лишеним, но на высоких матрицах будет чуть меньше

      // This is the array that we keep our computed noise values in
      //static uint8_t noise[WIDTH][cloudHeight];
      static uint8_t *noise = (uint8_t *) malloc(WIDTH * cloudHeight);

      while (noise == NULL) {
        #if defined(GENERAL_DEBUG)
        LOG.println("noise malloc failed");
        #endif
      }
      int xoffset = noiseScale * x + hue;

      for (uint8_t z = 0; z < cloudHeight; z++) {
        int yoffset = noiseScale * z - hue;
        uint8_t dataSmoothing = 192;
        uint8_t noiseData = qsub8(inoise8(ff_x + xoffset, ff_y + yoffset, ff_z), 16);
        noiseData = qadd8(noiseData, scale8(noiseData, 39));
        noise[x * cloudHeight + z] = scale8( noise[x * cloudHeight + z], dataSmoothing) + scale8( noiseData, 256 - dataSmoothing);
        nblend(leds[XY(x, HEIGHT - z - 1)], ColorFromPalette(rainClouds_p, noise[x * cloudHeight + z]), (cloudHeight - z) * (250 / cloudHeight));
      }
      ff_z ++;
    }
  }
}

uint8_t myScale8(uint8_t x) { // даёт масштабировать каждые 8 градаций (от 0 до 7) бегунка Масштаб в значения от 0 до 255 по типа синусоиде
  uint8_t x8 = x % 8U;
  uint8_t x4 = x8 % 4U;
  if (x4 == 0U)
    if (x8 == 0U)       return 0U;
    else                return 255U;
  else if (x8 < 4U)     return (1U   + x4 * 72U); // всего 7шт по 36U + 3U лишних = 255U (чтобы восхождение по синусоиде не было зеркально спуску)
  //else
  return (253U - x4 * 72U); // 253U = 255U - 2U
}

#ifdef USE_BLYNK
void coloredRain() // внимание! этот эффект заточен на работу бегунка Масштаб в диапазоне от 0 до 255. пока что единственный, поэтому для Блинка всё пересчитываем.
{
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
  if (selectedSettings) {
    setModeSettings(1U + random8(100U) , 165U + random8(76U));
  }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
  if (modes[currentMode].Scale > 100U) modes[currentMode].Scale = 100U;
  if (modes[currentMode].Scale * 2.55 > 247U)
    rain(60, 200, map8(42, 5, 100), myScale8(modes[currentMode].Scale * 2.55), solidRainColor, false, false, false);
  else
    rain(60, 200, map8(42, 5, 100), myScale8(modes[currentMode].Scale * 2.55), CHSV(modes[currentMode].Scale * 2.55, 255U, 255U), false, false, false);
}

void simpleRain()
{
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
  if (selectedSettings) {
    setModeSettings(random8(2U) ? 2U + random8(7U) : 8U + random8(70U), 220U + random8(22U));
  }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

  if (modes[currentMode].Scale > 100U) modes[currentMode].Scale = 100U;
  rain(60, 180, (modes[currentMode].Scale * 2.55 - 1) * 2.58, 30, solidRainColor, true, true, false);
}

void stormyRain()
{
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
  if (selectedSettings) {
    setModeSettings(random8(2U) ? 2U + random8(15U) : 17U + random8(64U), 220U + random8(22U));
  }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

  if (modes[currentMode].Scale > 100U) modes[currentMode].Scale = 100U;
  rain(60, 160, (modes[currentMode].Scale * 2.55 - 1) * 2.58, 30, solidRainColor, true, true, true);
}
#else

void coloredRain() // внимание! этот эффект заточен на работу бегунка Масштаб в диапазоне от 0 до 100. пока что единственный.
{
  if (modes[currentMode].Scale > 247U)
    rain(60, 200, map8(42,5,100), myScale8(modes[currentMode].Scale*2.55), solidRainColor, false, false, false);
  else
    rain(60, 200, map8(42,5,100), myScale8(modes[currentMode].Scale*2.55), CHSV(modes[currentMode].Scale*2.55, 255U, 255U), false, false, false);
}

void simpleRain()
{
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
  if (selectedSettings) {
    setModeSettings(random8(2U) ? 2U + random8(7U) : 9U + random8(70U), 220U + random8(22U));
  }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

  // ( Depth of dots, maximum brightness, frequency of new dots, length of tails, color, splashes, clouds, ligthening )
  //rain(60, 200, map8(intensity,2,60), 10, solidRainColor, true, true, false);
  rain(60, 180, (modes[currentMode].Scale - 1) * 2.58, 30, solidRainColor, true, true, false);
}

void stormyRain()
{
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
  if (selectedSettings) {
    setModeSettings(random8(2U) ? 2U + random8(15U) : 17U + random8(64U), 220U + random8(22U));
  }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

  // ( Depth of dots, maximum brightness, frequency of new dots, length of tails, color, splashes, clouds, ligthening )
  //rain(0, 90, map8(intensity,0,150)+60, 10, solidRainColor, true, true, true);
  rain(60, 160, (modes[currentMode].Scale - 1) * 2.58, 30, solidRainColor, true, true, true);
}
#endif // ifdef USE_BLYNK


// ------------------------------ ЭФФЕКТ МЕРЦАНИЕ ----------------------
// (c) SottNick

#define TWINKLES_SPEEDS 4     // всего 4 варианта скоростей мерцания
#define TWINKLES_MULTIPLIER 6 // слишком медленно, если на самой медленной просто по единичке к яркости добавлять

void twinklesRoutine() {
  if (loadingFlag)
  {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      setModeSettings(random8(8U) * 11U + 2U + random8(9U) , 180U + random8(69U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    setCurrentPalette();
    hue = 0U;
    deltaValue = (modes[currentMode].Scale - 1U) % 11U + 1U;  // вероятность пикселя загореться от 1/1 до 1/11
    for (uint32_t idx = 0; idx < NUM_LEDS; idx++) {
      if (random8(deltaValue) == 0) {
        ledsbuff[idx].r = random8();                          // оттенок пикселя
        ledsbuff[idx].g = random8(1, TWINKLES_SPEEDS * 2 + 1); // скорость и направление (нарастает 1-4 или угасает 5-8)
        ledsbuff[idx].b = random8();                          // яркость
      }
      else
        ledsbuff[idx] = 0;                                    // всё выкл
    }
  }
  for (uint32_t idx = 0; idx < NUM_LEDS; idx++) {
    if (ledsbuff[idx].b == 0) {
      if (random8(deltaValue) == 0 && hue > 0) { // если пиксель ещё не горит, зажигаем каждый ХЗй
        ledsbuff[idx].r = random8();                          // оттенок пикселя
        ledsbuff[idx].g = random8(1, TWINKLES_SPEEDS + 1);    // скорость и направление (нарастает 1-4, но не угасает 5-8)
        ledsbuff[idx].b = ledsbuff[idx].g;                    // яркость
        hue--; // уменьшаем количество погасших пикселей
      }
    }
    else if (ledsbuff[idx].g <= TWINKLES_SPEEDS) {            // если нарастание яркости
      if (ledsbuff[idx].b > 255U - ledsbuff[idx].g - TWINKLES_MULTIPLIER) {           // если досигнут максимум
        ledsbuff[idx].b = 255U;
        ledsbuff[idx].g = ledsbuff[idx].g + TWINKLES_SPEEDS;
      }
      else
        ledsbuff[idx].b = ledsbuff[idx].b + ledsbuff[idx].g + TWINKLES_MULTIPLIER;
    }
    else {                                                    // если угасание яркости
      if (ledsbuff[idx].b <= ledsbuff[idx].g - TWINKLES_SPEEDS + TWINKLES_MULTIPLIER) { // если досигнут минимум
        ledsbuff[idx].b = 0;                                  // всё выкл
        hue++; // считаем количество погасших пикселей
      }
      else
        ledsbuff[idx].b = ledsbuff[idx].b - ledsbuff[idx].g + TWINKLES_SPEEDS - TWINKLES_MULTIPLIER;
    }
    if (ledsbuff[idx].b == 0)
      leds[idx] = 0U;
    else
      leds[idx] = ColorFromPalette(*curPalette, ledsbuff[idx].r, ledsbuff[idx].b);
  }
}

// ============= BOUNCE / ПРЫЖКИ / МЯЧИКИ БЕЗ ГРАНИЦ ===============
// Aurora : https://github.com/pixelmatix/aurora/blob/master/PatternBounce.h
// Copyright(c) 2014 Jason Coon
// v1.0 - Updating for GuverLamp v1.7 by Palpalych 14.04.2020
//#define e_bnc_COUNT (WIDTH) // теперь enlargedObjectNUM. хз, почему использовалась ширина матрицы тут, если по параметру идёт обращение к массиву boids, у которого может быть меньший размер
#define e_bnc_SIDEJUMP (true)
PVector gravity = PVector(0, -0.0125);
void bounceRoutine()
{
  if (loadingFlag) {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      setModeSettings(random8(9U) * 11U + 3U + random8(9U), random8(4U) ? 3U + random8(26U) : 255U);
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    setCurrentPalette();
    //hue2 = 255U - scale8(64U, myScale8(modes[currentMode].Scale * 2.55));
    //hue2 = 254U - ((modes[currentMode].Scale - 1U) % 11U) * 3;
    enlargedObjectNUM = (modes[currentMode].Scale - 1U) % 11U / 10.0 * (AVAILABLE_BOID_COUNT - 1U) + 1U;
    uint8_t colorWidth = 256U / enlargedObjectNUM;
    for (uint8_t i = 0; i < enlargedObjectNUM; i++)
    {
      Boid boid = Boid(i % WIDTH, 0);//random8(HEIGHT));//HEIGHT / 8
      boid.velocity.x = 0;
      //boid.location.y = 0;//(HEIGHT -1) / 4;
      boid.velocity.y = i * -0.01;
      boid.colorIndex = colorWidth * i;
      boid.maxforce = 10;
      boid.maxspeed = 10;
      boids[i] = boid;
    }
  }
  blurScreen(beatsin8(5U, 1U, 5U));
  dimAll(255U - modes[currentMode].Speed); // dimAll(hue2);
  for (uint8_t i = 0; i < enlargedObjectNUM; i++)
  {
    Boid boid = boids[i];
    boid.applyForce(gravity);
    boid.update();
    if (boid.location.x >= WIDTH) boid.location.x = boid.location.x - WIDTH; // это только
    else if (boid.location.x < 0) boid.location.x = boid.location.x + WIDTH; // для субпиксельной версии
    CRGB color = ColorFromPalette(*curPalette, boid.colorIndex); // boid.colorIndex + hue
    //drawPixelXY((uint32_t)(boid.location.x) % WIDTH, boid.location.y, color);
    //drawPixelXYFseamless(boid.location.x, boid.location.y, color); вот это я тупанул
    drawPixelXYF(boid.location.x, boid.location.y, color);

    if (boid.location.y <= 0)
    {
      boid.location.y = 0;
      boid.velocity.y = -boid.velocity.y;
      boid.velocity.x *= 0.9;
      if (!random8() || boid.velocity.y < 0.01)
      {
#if e_bnc_SIDEJUMP
        boid.applyForce(PVector((float)random(127) / 255 - 0.25, (float)random(255) / 255));
#else
        boid.applyForce(PVector(0, (float)random(255) / 255));
#endif
      }
    }
    boids[i] = boid;
  }
  //  EVERY_N_MILLIS(20)
  //  {
  //  hue++;
  //  }
}

// ------------------------------ ЭФФЕКТ КОЛЬЦА / КОДОВЫЙ ЗАМОК ----------------------
// (c) SottNick
// из-за повторного использоваия переменных от других эффектов теперь в этом коде невозможно что-то понять.
// поэтому для понимания придётся сперва заменить названия переменных на человеческие. но всё равно это песец, конечно.
//uint8_t deltaHue2; // максимальне количество пикселей в кольце (толщина кольца) от 1 до HEIGHT / 2 + 1
//uint8_t deltaHue; // количество колец от 2 до HEIGHT
//uint8_t noise3d[1][1][HEIGHT]; // начальный оттенок каждого кольца (оттенка из палитры) 0-255
//uint8_t shiftValue[HEIGHT]; // местоположение начального оттенка кольца 0-WIDTH-1
//uint8_t shiftHue[HEIGHT]; // 4 бита на ringHueShift, 4 на ringHueShift2
////ringHueShift[ringsCount]; // шаг градиета оттенка внутри кольца -8 - +8 случайное число
////ringHueShift2[ringsCount]; // обычная скорость переливания оттенка всего кольца -8 - +8 случайное число
//uint8_t deltaValue; // кольцо, которое в настоящий момент нужно провернуть
//uint8_t step; // оставшееся количество шагов, на которое нужно провернуть активное кольцо - случайное от WIDTH/5 до WIDTH-3
//uint8_t hue, hue2; // количество пикселей в нижнем (hue) и верхнем (hue2) кольцах

void ringsRoutine() {
  uint8_t h, x, y;
  if (loadingFlag)
  {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      setModeSettings(90U + random8(6U), 175U + random8(61U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    setCurrentPalette();

    //deltaHue2 = (modes[currentMode].Scale - 1U) / 99.0 * (HEIGHT / 2 - 1U) + 1U; // толщина кольца в пикселях. если на весь бегунок масштаба (от 1 до HEIGHT / 2 + 1)
    deltaHue2 = (modes[currentMode].Scale - 1U) % 11U + 1U; // толщина кольца от 1 до 11 для каждой из палитр
    deltaHue = HEIGHT / deltaHue2 + ((HEIGHT % deltaHue2 == 0U) ? 0U : 1U); // количество колец
    hue2 = deltaHue2 - (deltaHue2 * deltaHue - HEIGHT) / 2U; // толщина верхнего кольца. может быть меньше нижнего
    hue = HEIGHT - hue2 - (deltaHue - 2U) * deltaHue2; // толщина нижнего кольца = всё оставшееся
    for (uint8_t i = 0; i < deltaHue; i++)
    {
      noise3d[0][0][i] = random8(257U - WIDTH / 2U); // начальный оттенок кольца из палитры 0-255 за минусом длины кольца, делённой пополам
      shiftHue[i] = random8();
      shiftValue[i] = 0U; //random8(WIDTH); само прокрутится постепенно
      step = 0U;
      //do { // песец конструкцию придумал бредовую
      //  step = WIDTH - 3U - random8((WIDTH - 3U) * 2U); само присвоится при первом цикле
      //} while (step < WIDTH / 5U || step > 255U - WIDTH / 5U);
      deltaValue = random8(deltaHue);
    }

  }
  for (uint8_t i = 0; i < deltaHue; i++)
  {
    if (i != deltaValue) // если это не активное кольцо
    {
      h = shiftHue[i] & 0x0F; // сдвигаем оттенок внутри кольца
      if (h > 8U)
        //noise3d[0][0][i] += (uint8_t)(7U - h); // с такой скоростью сдвиг оттенка от вращения кольца не отличается
        noise3d[0][0][i]--;
      else
        //noise3d[0][0][i] += h;
        noise3d[0][0][i]++;
    }
    else
    {
      if (step == 0) // если сдвиг активного кольца завершён, выбираем следующее
      {
        deltaValue = random8(deltaHue);
        do {
          step = WIDTH - 3U - random8((WIDTH - 3U) * 2U); // проворот кольца от хз до хз
        } while (step < WIDTH / 5U || step > 255U - WIDTH / 5U);
      }
      else
      {
        if (step > 127U)
        {
          step++;
          shiftValue[i] = (shiftValue[i] + 1U) % WIDTH;
        }
        else
        {
          step--;
          shiftValue[i] = (shiftValue[i] - 1U + WIDTH) % WIDTH;
        }
      }
    }
    // отрисовываем кольца
    h = (shiftHue[i] >> 4) & 0x0F; // берём шаг для градиента вутри кольца
    if (h > 8U)
      h = 7U - h;
    for (uint8_t j = 0U; j < ((i == 0U) ? hue : ((i == deltaHue - 1U) ? hue2 : deltaHue2)); j++) // от 0 до (толщина кольца - 1)
    {
      y = i * deltaHue2 + j - ((i == 0U) ? 0U : deltaHue2 - hue);
      // mod для чётных скоростей by @kostyamat - получается какая-то другая фигня. не стоит того
      //for (uint8_t k = 0; k < WIDTH / ((modes[currentMode].Speed & 0x01) ? 2U : 4U); k++) // полукольцо для нечётных скоростей и четверть кольца для чётных
      for (uint8_t k = 0; k < WIDTH / 2U; k++) // полукольцо
      {
        x = (shiftValue[i] + k) % WIDTH; // первая половина кольца
        leds[XY(x, y)] = ColorFromPalette(*curPalette, noise3d[0][0][i] + k * h);
        x = (WIDTH - 1 + shiftValue[i] - k) % WIDTH; // вторая половина кольца (зеркальная первой)
        leds[XY(x, y)] = ColorFromPalette(*curPalette, noise3d[0][0][i] + k * h);
      }
      if (WIDTH & 0x01) //(WIDTH % 2U > 0U) // если число пикселей по ширине матрицы нечётное, тогда не забываем и про среднее значение
      {
        x = (shiftValue[i] + WIDTH / 2U) % WIDTH;
        leds[XY(x, y)] = ColorFromPalette(*curPalette, noise3d[0][0][i] + WIDTH / 2U * h);
      }
    }
  }
}

// ------------------------------ ЭФФЕКТ КУБИК РУБИКА 2D ----------------------
// (c) SottNick

#define PAUSE_MAX 7 // пропустить 7 кадров после завершения анимации сдвига ячеек

//uint8_t noise3d[1][WIDTH][HEIGHT]; // тут используем только нулевую колонку и нулевую строку. просто для экономии памяти взяли существующий трёхмерный массив
//uint8_t hue2; // осталось шагов паузы
//uint8_t step; // текущий шаг сдвига (от 0 до deltaValue-1)
//uint8_t deltaValue; // всего шагов сдвига (до razmer? до (razmer?+1)*shtuk?)
//uint8_t deltaHue, deltaHue2; // глобальный X и глобальный Y нашего "кубика"
uint8_t razmerX, razmerY; // размеры ячеек по горизонтали / вертикали
uint8_t shtukX, shtukY; // количество ячеек по горизонтали / вертикали
uint8_t poleX, poleY; // размер всего поля по горизонтали / вертикали (в том числе 1 дополнительная пустая дорожка-разделитель с какой-то из сторон)
int8_t globalShiftX, globalShiftY; // нужно ли сдвинуть всё поле по окончаии цикла и в каком из направлений (-1, 0, +1)
bool seamlessX; // получилось ли сделать поле по Х бесшовным
bool krutimVertikalno; // направление вращения в данный момент

void cube2dRoutine() {
  uint8_t x, y;
  uint8_t anim0; // будем считать тут начальный пиксель для анимации сдвига строки/колонки
  int8_t shift, kudaVse; // какое-то расчётное направление сдвига (-1, 0, +1)
  CRGB color, color2;

  if (loadingFlag)
  {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      uint8_t tmp = random8(9U) * 11U + random8(8U); // масштаб 1-7, палитры все 9
      if (tmp == 45U) tmp = 100U; //+ белый цвет
      setModeSettings(tmp, 175U + random8(66U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    setCurrentPalette();
    FastLED.clear();

    razmerX = (modes[currentMode].Scale - 1U) % 11U + 1U; // размер ячейки от 1 до 11 пикселей для каждой из 9 палитр
    razmerY = razmerX;
    if (modes[currentMode].Speed & 0x01) // по идее, ячейки не обязательно должны быть квадратными, поэтому можно тут поизвращаться
      razmerY = (razmerY << 1U) + 1U;

    shtukY = HEIGHT / (razmerY + 1U);
    if (shtukY < 2U)
      shtukY = 2U;
    y = HEIGHT / shtukY - 1U;
    if (razmerY > y)
      razmerY = y;
    poleY = (razmerY + 1U) * shtukY;
    shtukX = WIDTH / (razmerX + 1U);
    if (shtukX < 2U)
      shtukX = 2U;
    x = WIDTH / shtukX - 1U;
    if (razmerX > x)
      razmerX = x;
    poleX = (razmerX + 1U) * shtukX;
    seamlessX = (poleX == WIDTH);
    deltaHue = 0U;
    deltaHue2 = 0U;
    globalShiftX = 0;
    globalShiftY = 0;

    for (uint8_t j = 0U; j < shtukY; j++)
    {
      y = j * (razmerY + 1U); // + deltaHue2 т.к. оно =0U
      for (uint8_t i = 0U; i < shtukX; i++)
      {
        x = i * (razmerX + 1U); // + deltaHue т.к. оно =0U
        if (modes[currentMode].Scale == 100U)
          color = CHSV(45U, 0U, 128U + random8(128U));
        else
          color = ColorFromPalette(*curPalette, random8());
        for (uint8_t k = 0U; k < razmerY; k++)
          for (uint8_t m = 0U; m < razmerX; m++)
            leds[XY(x + m, y + k)] = color;
      }
    }
    step = 4U; // текущий шаг сдвига первоначально с перебором (от 0 до deltaValue-1)
    deltaValue = 4U; // всего шагов сдвига (от razmer? до (razmer?+1) * shtuk?)
    hue2 = 0U; // осталось шагов паузы

    //это лишнее обнуление
    //krutimVertikalno = true;
    //for (uint8_t i = 0U; i < shtukX; i++)
    //  noise3d[0][i][0] = 0U;
  }

  //двигаем, что получилось...
  if (hue2 == 0 && step < deltaValue) // если пауза закончилась, а цикл вращения ещё не завершён
  {
    step++;
    if (krutimVertikalno)
    {
      for (uint8_t i = 0U; i < shtukX; i++)
      {
        x = (deltaHue + i * (razmerX + 1U)) % WIDTH;
        if (noise3d[0][i][0] > 0) // в нулевой ячейке храним оставшееся количество ходов прокрутки
        {
          noise3d[0][i][0]--;
          shift = noise3d[0][i][1] - 1; // в первой ячейке храним направление прокрутки

          if (globalShiftY == 0)
            anim0 = (deltaHue2 == 0U) ? 0U : deltaHue2 - 1U;
          else if (globalShiftY > 0)
            anim0 = deltaHue2;
          else
            anim0 = deltaHue2 - 1U;

          if (shift < 0) // если крутим столбец вниз
          {
            color = leds[XY(x, anim0)];                                   // берём цвет от нижней строчки
            for (uint8_t k = anim0; k < anim0 + poleY - 1; k++)
            {
              color2 = leds[XY(x, k + 1)];                                // берём цвет от строчки над нашей
              for (uint8_t m = x; m < x + razmerX; m++)
                leds[XY(m % WIDTH, k)] = color2;                          // копируем его на всю нашу строку
            }
            for   (uint8_t m = x; m < x + razmerX; m++)
              leds[XY(m % WIDTH, anim0 + poleY - 1)] = color;             // цвет нижней строчки копируем на всю верхнюю
          }
          else if (shift > 0) // если крутим столбец вверх
          {
            color = leds[XY(x, anim0 + poleY - 1)];                       // берём цвет от верхней строчки
            for (uint8_t k = anim0 + poleY - 1; k > anim0 ; k--)
            {
              color2 = leds[XY(x, k - 1)];                                // берём цвет от строчки под нашей
              for (uint8_t m = x; m < x + razmerX; m++)
                leds[XY(m % WIDTH, k)] = color2;                          // копируем его на всю нашу строку
            }
            for   (uint8_t m = x; m < x + razmerX; m++)
              leds[XY(m % WIDTH, anim0)] = color;                         // цвет верхней строчки копируем на всю нижнюю
          }
        }
      }
    }
    else
    {
      for (uint8_t j = 0U; j < shtukY; j++)
      {
        y = deltaHue2 + j * (razmerY + 1U);
        if (noise3d[0][0][j] > 0) // в нулевой ячейке храним оставшееся количество ходов прокрутки
        {
          noise3d[0][0][j]--;
          shift = noise3d[0][1][j] - 1; // в первой ячейке храним направление прокрутки

          if (seamlessX)
            anim0 = 0U;
          else if (globalShiftX == 0)
            anim0 = (deltaHue == 0U) ? 0U : deltaHue - 1U;
          else if (globalShiftX > 0)
            anim0 = deltaHue;
          else
            anim0 = deltaHue - 1U;

          if (shift < 0) // если крутим строку влево
          {
            color = leds[XY(anim0, y)];                            // берём цвет от левой колонки (левого пикселя)
            for (uint8_t k = anim0; k < anim0 + poleX - 1; k++)
            {
              color2 = leds[XY(k + 1, y)];                         // берём цвет от колонки (пикселя) правее
              for (uint8_t m = y; m < y + razmerY; m++)
                leds[XY(k, m)] = color2;                           // копируем его на всю нашу колонку
            }
            for   (uint8_t m = y; m < y + razmerY; m++)
              leds[XY(anim0 + poleX - 1, m)] = color;              // цвет левой колонки копируем на всю правую
          }
          else if (shift > 0) // если крутим столбец вверх
          {
            color = leds[XY(anim0 + poleX - 1, y)];                // берём цвет от правой колонки
            for (uint8_t k = anim0 + poleX - 1; k > anim0 ; k--)
            {
              color2 = leds[XY(k - 1, y)];                         // берём цвет от колонки левее
              for (uint8_t m = y; m < y + razmerY; m++)
                leds[XY(k, m)] = color2;                           // копируем его на всю нашу колонку
            }
            for   (uint8_t m = y; m < y + razmerY; m++)
              leds[XY(anim0, m)] = color;                          // цвет правой колонки копируем на всю левую
          }
        }
      }
    }

  }
  else if (hue2 != 0U) // пропускаем кадры после прокрутки кубика (делаем паузу)
    hue2--;

  if (step >= deltaValue) // если цикл вращения завершён, меняем местами соответствующие ячейки (цвет в них) и точку первой ячейки
  {
    step = 0U;
    hue2 = PAUSE_MAX;
    //если часть ячеек двигалась на 1 пиксель, пододвигаем глобальные координаты начала
    deltaHue2 = deltaHue2 + globalShiftY; //+= globalShiftY;
    globalShiftY = 0;
    //deltaHue += globalShiftX; для бесшовной не годится
    deltaHue = (WIDTH + deltaHue + globalShiftX) % WIDTH;
    globalShiftX = 0;

    //пришла пора выбрать следующие параметры вращения
    kudaVse = 0;
    krutimVertikalno = random8(2U);
    if (krutimVertikalno) // идём по горизонтали, крутим по вертикали (столбцы двигаются)
    {
      for (uint8_t i = 0U; i < shtukX; i++)
      {
        noise3d[0][i][1] = random8(3);
        shift = noise3d[0][i][1] - 1; // в первой ячейке храним направление прокрутки
        if (kudaVse == 0)
          kudaVse = shift;
        else if (shift != 0 && kudaVse != shift)
          kudaVse = 50;
      }
      deltaValue = razmerY + ((deltaHue2 - kudaVse >= 0 && deltaHue2 - kudaVse + poleY < (int)HEIGHT) ? random8(2U) : 1U);

      /*        if (kudaVse == 0) // пытался сделать, чтобы при совпадении "весь кубик стоит" сдвинуть его весь на пиксель, но заколебался
              {
                deltaValue = razmerY;
                kudaVse = (random8(2)) ? 1 : -1;
                if (deltaHue2 - kudaVse < 0 || deltaHue2 - kudaVse + poleY >= (int)HEIGHT)
                  kudaVse = 0 - kudaVse;
              }
      */
      if (deltaValue == razmerY) // значит полюбому kudaVse было = (-1, 0, +1) - и для нуля в том числе мы двигаем весь куб на 1 пиксель
      {
        globalShiftY = 1 - kudaVse; //временно на единичку больше, чем надо
        for (uint8_t i = 0U; i < shtukX; i++)
          if (noise3d[0][i][1] == 1U) // если ячейка никуда не планировала двигаться
          {
            noise3d[0][i][1] = globalShiftY;
            noise3d[0][i][0] = 1U; // в нулевой ячейке храним количество ходов сдвига
          }
          else
            noise3d[0][i][0] = deltaValue; // в нулевой ячейке храним количество ходов сдвига
        globalShiftY--;
      }
      else
      {
        x = 0;
        for (uint8_t i = 0U; i < shtukX; i++)
          if (noise3d[0][i][1] != 1U)
          {
            y = random8(shtukY);
            if (y > x)
              x = y;
            noise3d[0][i][0] = deltaValue * (x + 1U); // в нулевой ячейке храним количество ходов сдвига
          }
        deltaValue = deltaValue * (x + 1U);
      }

    }
    else // идём по вертикали, крутим по горизонтали (строки двигаются)
    {
      for (uint8_t j = 0U; j < shtukY; j++)
      {
        noise3d[0][1][j] = random8(3);
        shift = noise3d[0][1][j] - 1; // в первой ячейке храним направление прокрутки
        if (kudaVse == 0)
          kudaVse = shift;
        else if (shift != 0 && kudaVse != shift)
          kudaVse = 50;
      }
      if (seamlessX)
        deltaValue = razmerX + ((kudaVse < 50) ? random8(2U) : 1U);
      else
        deltaValue = razmerX + ((deltaHue - kudaVse >= 0 && deltaHue - kudaVse + poleX < (int)WIDTH) ? random8(2U) : 1U);

      /*        if (kudaVse == 0) // пытался сделать, чтобы при совпадении "весь кубик стоит" сдвинуть его весь на пиксель, но заколебался
              {
                deltaValue = razmerX;
                kudaVse = (random8(2)) ? 1 : -1;
                if (deltaHue - kudaVse < 0 || deltaHue - kudaVse + poleX >= (int)WIDTH)
                  kudaVse = 0 - kudaVse;
              }
      */
      if (deltaValue == razmerX) // значит полюбому kudaVse было = (-1, 0, +1) - и для нуля в том числе мы двигаем весь куб на 1 пиксель
      {
        globalShiftX = 1 - kudaVse; //временно на единичку больше, чем надо
        for (uint8_t j = 0U; j < shtukY; j++)
          if (noise3d[0][1][j] == 1U) // если ячейка никуда не планировала двигаться
          {
            noise3d[0][1][j] = globalShiftX;
            noise3d[0][0][j] = 1U; // в нулевой ячейке храним количество ходов сдвига
          }
          else
            noise3d[0][0][j] = deltaValue; // в нулевой ячейке храним количество ходов сдвига
        globalShiftX--;
      }
      else
      {
        y = 0;
        for (uint8_t j = 0U; j < shtukY; j++)
          if (noise3d[0][1][j] != 1U)
          {
            x = random8(shtukX);
            if (x > y)
              y = x;
            noise3d[0][0][j] = deltaValue * (x + 1U); // в нулевой ячейке храним количество ходов сдвига
          }
        deltaValue = deltaValue * (y + 1U);
      }
    }
  }
}

// ------------------------------ РЕЖИМ / ЭФФЕКТ ЧАСЫ ----------------------
// (c) SottNick

#define CLOCK_SAVE_MODE     // удалите или закомментируйте эту строчку, чтобы цифры всегда оставались на одном месте, не двигались по вертикали (не хорошо для светодиодов. выгорают зря)
#if (HEIGHT > 12) || (HEIGHT < 11)
#define CLOCK_BLINKING      // удалите или закомментируйте эту строчку, чтобы точки не мигали
#endif
//uint8_t hue, hue2; // храним тут часы и минуты
//uint8_t deltaHue, deltaHue2; // храним здесь задержки мигания точек
//uint8_t deltaValue; // счётчик цикла / яркости точек на часах
//uint8_t poleX, poleY; // храним здесь сдвиг циферблата по горизонтали и вертикали (переменные объявлены в эффекте Кубик Рубика)
static const uint8_t clockFont3x5[10][3] PROGMEM = { // цифры зеркально и на левом боку (так проще рисовать в циклах и экономнее для памяти)
  { B11111,
    B10001,
    B11111
  },
  { B01001,
    B11111,
    B00001
  },
  { B10011,
    B10101,
    B01001
  },
  { B10001,
    B10101,
    B01010
  },
  { B11100,
    B00100,
    B11111
  },
  { B11101,
    B10101,
    B10010
  },
  { B01111,
    B10101,
    B10111
  },
  { B10011,
    B10100,
    B11000
  },
  { B11111,
    B10101,
    B11111
  },
  { B11101,
    B10101,
    B11110
  }
};
void drawDig3x5(uint8_t x, uint8_t y, uint8_t num, CRGB color) { // uint8_t hue, uint8_t sat, uint8_t bri = 255U
  for (uint8_t i = 0U; i < 3U; i++)
  {
    uint8_t m = pgm_read_byte(&clockFont3x5[num][i]);
    for (uint8_t j = 0U; j < 5U; j++)
      if ((m >> j) & 0x01)
        drawPixelXY((x + i) % WIDTH, (y + j) % HEIGHT, color);
  }
}

#if HEIGHT > 10 // часы в столбик будут только если высота 11 пикселей и больше
void clockRoutine() {
  if (loadingFlag)
  {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      setModeSettings(random8(20) ? 7U + random8(86U) : 100U, modes[currentMode].Speed);
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    poleX = (modes[currentMode].Speed - 1U) % WIDTH; //смещение цифр по горизонтали
#ifdef CLOCK_BLINKING
#if HEIGHT > 13
    poleY = (modes[currentMode].Speed - 1U) / WIDTH % (HEIGHT - 13U);  //смещение цифр по вертикали (для режима CLOCK_SAVE_MODE будет меняться само)
#else
    poleY = 0U;
#endif
#else
#if HEIGHT > 12
    poleY = (modes[currentMode].Speed - 1U) / WIDTH % (HEIGHT - 12U);  //смещение цифр по вертикали (для режима CLOCK_SAVE_MODE будет меняться само)
#else // и для 12 и для 11 смещаться некуда. всё впритык
    poleY = 0U;
#endif
#endif
    hue2 = 255U; // количество минут в данный момент (первоначально запредельое значение)
    deltaHue2 = 0; // яркость точки в данный момент
    deltaValue = modes[currentMode].Scale * 2.55; // выбранный оттенок цифр
  }
  /*
    #ifdef USE_NTP
    time_t currentLocalTime = localTimeZone.toLocal(timeClient.getEpochTime());
    #else
    time_t currentLocalTime = millis() / 1000UL;
    #endif
  */
  time_t currentLocalTime = getCurrentLocalTime();

  if (minute(currentLocalTime) != hue2)
  {
#ifdef CLOCK_SAVE_MODE
#ifdef CLOCK_BLINKING
#if HEIGHT > 13
    poleY = (poleY + 1U) % (HEIGHT - 13U);
#endif
#else
#if HEIGHT > 12
    poleY = (poleY + 1U) % (HEIGHT - 12U);
#endif
#endif
#endif
    step = 1U; // = CLOCK_REFRESH_DELAY; раньше делал постепенное затухание. получалось хуже
    hue = hour(currentLocalTime);
    hue2 = minute(currentLocalTime);
  }
  if (step > 0) // тут меняются цифры на часах
  {
    step--;
    //uint8_t bri = (CLOCK_REFRESH_DELAY - step) * 255.0 / CLOCK_REFRESH_DELAY;
    uint8_t sat = (modes[currentMode].Scale == 100) ? 0U : 255U;

    FastLED.clear();
    // рисуем цифры
#ifdef CLOCK_BLINKING
    drawDig3x5(   poleX,               (poleY + 8U), hue  / 10U % 10U, CHSV(deltaValue, sat, 255U));
    drawDig3x5(  (poleX + 4U) % WIDTH, (poleY + 8U), hue        % 10U, CHSV(deltaValue, sat, 255U));
#else
#if HEIGHT > 11
    drawDig3x5( poleX,               (poleY + 7U), hue  / 10U % 10U, CHSV(deltaValue, sat, 255U));
    drawDig3x5((poleX + 4U) % WIDTH, (poleY + 7U), hue        % 10U, CHSV(deltaValue, sat, 255U));
#else // если матрица всего 11 пикселей в высоту, можно сэкономить 1 и впихнуть часы в неё. но если меньше, нужно брать код эффекта с высотой цифр 4 пикселя, а не 5
    drawDig3x5( poleX,               (poleY + 6U), hue  / 10U % 10U, CHSV(deltaValue, sat, 255U));
    drawDig3x5((poleX + 4U) % WIDTH, (poleY + 6U), hue        % 10U, CHSV(deltaValue, sat, 255U));
#endif
#endif
    drawDig3x5(     poleX, poleY,                      hue2 / 10U % 10U, CHSV(deltaValue, sat, 255U));
    drawDig3x5(    (poleX + 4U) % WIDTH, poleY,        hue2       % 10U, CHSV(deltaValue, sat, 255U));
  }

#ifdef CLOCK_BLINKING
  // тут мигают точки
  //  if (deltaHue != 0U)
  //    deltaHue--;
  //  else
  //  {
  //    deltaHue = 4U; // множитель задержки 50 мс * 4+1U = 250 мс
  if (deltaHue2 & 0x01)
    deltaHue2 = deltaHue2 - ((deltaHue2 >  15U) ? 16U : 15U);//- ((deltaHue2 >  63U) ? 64U : 63U);
  else
    deltaHue2 = deltaHue2 + ((deltaHue2 < 240U) ? 16U : 15U);//+ ((deltaHue2 < 192U) ? 64U : 63U);

  drawPixelXY((poleX + 2U) % WIDTH, poleY + 6U, CHSV(deltaValue, (modes[currentMode].Scale == 100) ? 0U : 255U, deltaHue2)); // цвет белый для .Scale=100
  drawPixelXY((poleX + 4U) % WIDTH, poleY + 6U, CHSV(deltaValue, (modes[currentMode].Scale == 100) ? 0U : 255U, deltaHue2)); // цвет белый для .Scale=100
  //  }
#endif //#ifdef CLOCK_BLINKING
}
#else // для матриц и гирлянд от 6 до 10 пикселей в высоту #if HEIGHT > 10
void clockRoutine() { // чтобы цифры были не в столбик, а в строчку
  if (loadingFlag)
  {
    loadingFlag = false;
    poleX = (modes[currentMode].Speed - 1U) % WIDTH; //смещение цифр по горизонтали
    poleY = (modes[currentMode].Speed - 1U) / WIDTH % (HEIGHT - 5U);  //смещение цифр по вертикали (для режима CLOCK_SAVE_MODE будет меняться само)
    hue2 = 255U; // количество минут в данный момент (первоначально запредельое значение)
    deltaHue2 = 0; // яркость точки в данный момент
    deltaValue = modes[currentMode].Scale * 2.55; // выбранный оттенок цифр
  }
  time_t currentLocalTime = getCurrentLocalTime();

  if (minute(currentLocalTime) != hue2)
  {
#ifdef CLOCK_SAVE_MODE
    poleY = (poleY + 1U) % (HEIGHT - 5U);
#endif
    step = 1U; // = CLOCK_REFRESH_DELAY; раньше делал постепенное затухание. получалось хуже
    hue = hour(currentLocalTime);
    hue2 = minute(currentLocalTime);
  }
  if (step > 0) // тут меняются цифры на часах
  {
    step--;
    //uint8_t bri = (CLOCK_REFRESH_DELAY - step) * 255.0 / CLOCK_REFRESH_DELAY;
    uint8_t sat = (modes[currentMode].Scale == 100) ? 0U : 255U;

    FastLED.clear();
    // рисуем цифры
    drawDig3x5( poleX               , poleY, hue  / 10U % 10U, CHSV(deltaValue, sat, 255U));
    drawDig3x5((poleX +  4U) % WIDTH, poleY, hue        % 10U, CHSV(deltaValue, sat, 255U));
    drawDig3x5((poleX +  9U) % WIDTH, poleY, hue2 / 10U % 10U, CHSV(deltaValue, sat, 255U));
    drawDig3x5((poleX + 13U) % WIDTH, poleY, hue2       % 10U, CHSV(deltaValue, sat, 255U));
  }

#ifdef CLOCK_BLINKING
  // тут мигают точки
  if (deltaHue2 & 0x01)
    deltaHue2 = deltaHue2 - ((deltaHue2 >  15U) ? 16U : 15U);//- ((deltaHue2 >  63U) ? 64U : 63U);
  else
    deltaHue2 = deltaHue2 + ((deltaHue2 < 240U) ? 16U : 15U);//+ ((deltaHue2 < 192U) ? 64U : 63U);

  drawPixelXY((poleX + 8U) % WIDTH, poleY + 1U, CHSV(deltaValue, (modes[currentMode].Scale == 100) ? 0U : 255U, deltaHue2)); // цвет белый для .Scale=100
  drawPixelXY((poleX + 8U) % WIDTH, poleY + 3U, CHSV(deltaValue, (modes[currentMode].Scale == 100) ? 0U : 255U, deltaHue2)); // цвет белый для .Scale=100
  //  }
#endif //#ifdef CLOCK_BLINKING
}
#endif //#if HEIGHT > 10

// ------------------------------ ЭФФЕКТ ДЫМ ----------------------
// (c) SottNick

void MultipleStreamSmoke(bool isColored) {
  if (loadingFlag)
  {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      uint8_t tmp = random8(9U);
      setModeSettings(isColored ? 1U + tmp*tmp : (random8(10U) ? 1U + random8(99U) : 100U), 145U + random8(56U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    hue2 = 0U;
  }
  //if (modes[currentMode].Brightness & 0x01) // для проверки движения источника дыма можно включить
  dimAll(254U);//(255U - modes[currentMode].Scale * 2);
  //else     FastLED.clear();

  deltaHue++;
  CRGB color;//, color2;
  if (isColored)
  {
    if (hue2 == modes[currentMode].Scale)
    {
      hue2 = 0U;
      hue = random8();
    }
    if (deltaHue & 0x01)//((deltaHue >> 2U) == 0U) // какой-то умножитель охота подключить к задержке смены цвета, но хз какой...
      hue2++;

    //color = CHSV(hue, 255U, 255U);
    hsv2rgb_spectrum(CHSV(hue, 255U, 127U), color);
    //hsv2rgb_spectrum(CHSV(hue, 255U, 88U), color2);
  }
  else {
    //color = CHSV((modes[currentMode].Scale - 1U) * 2.6, (modes[currentMode].Scale > 98U) ? 0U : 255U, 255U);
    hsv2rgb_spectrum(CHSV((modes[currentMode].Scale - 1U) * 2.6, (modes[currentMode].Scale > 98U) ? 0U : 255U, 127U), color);
    //hsv2rgb_spectrum(CHSV((modes[currentMode].Scale - 1U) * 2.6, (modes[currentMode].Scale > 98U) ? 0U : 255U,  88U), color2);
  }

  //deltaHue2--;
  if (random8(WIDTH) != 0U) // встречная спираль движется не всегда синхронно основной
    deltaHue2--;

  for (uint8_t y = 0; y < HEIGHT; y++) {
    leds[XY((deltaHue  + y + 1U) % WIDTH, HEIGHT - 1U - y)] += color;
    leds[XY((deltaHue  + y     ) % WIDTH, HEIGHT - 1U - y)] += color; //color2
    leds[XY((deltaHue2 + y     ) % WIDTH,               y)] += color;
    leds[XY((deltaHue2 + y + 1U) % WIDTH,               y)] += color; //color2
  }

  //if (modes[currentMode].Brightness & 0x01) { // для проверки движения источника дыма можно включить эту опцию
  // Noise

  // скорость движения по массиву noise
  //uint32_t mult = 500U * ((modes[currentMode].Scale - 1U) % 10U);
  noise32_x[0] += 1500;//1000;
  noise32_y[0] += 1500;//1000;
  noise32_z[0] += 1500;//1000;

  // хрен знает что
  //mult = 1000U * ((modes[currentMode].Speed - 1U) % 10U);
  scale32_x[0] = 4000;
  scale32_y[0] = 4000;
  FillNoise(0);
  //MoveX(3);
  //MoveY(3);

  // допустимый отлёт зажжённого пикселя от изначально присвоенного местоположения (от 0 до указанного значения. дробное)
  //mult = (modes[currentMode].Brightness - 1U) % 10U;
  MoveFractionalNoiseX(3);//4
  MoveFractionalNoiseY(3);//4

  blurScreen(20); // без размытия как-то пиксельно, наверное...
  //} endif (modes[currentMode].Brightness & 0x01)
}

// ============ ЭФФЕКТЫ ПИКАССО =============
// взято откуда-то by @obliterator или им написано
// https://github.com/DmytroKorniienko/FireLamp_JeeUI/blob/templ/src/effects.cpp

//вместо класса Particle будем повторно использовать переменные из эффекта мячики и мотыльки
//        float position_x = 0;
//float trackingObjectPosX[enlargedOBJECT_MAX_COUNT];
//        float position_y = 0;
//float trackingObjectPosY[enlargedOBJECT_MAX_COUNT];
//        float speed_x = 0;
////float trackingObjectSpeedY[enlargedOBJECT_MAX_COUNT];                   // As time goes on the impact velocity will change, so make an array to store those values
//        float speed_y = 0;
////float trackingObjectShift[enlargedOBJECT_MAX_COUNT];                       // Coefficient of Restitution (bounce damping)
//        CHSV color;
////uint8_t trackingObjectHue[enlargedOBJECT_MAX_COUNT];
//        uint8_t hue_next = 0;
//uint8_t trackingObjectState[enlargedOBJECT_MAX_COUNT] ;                       // прикручено при адаптации для распределения мячиков по радиусу лампы
//        int8_t hue_step = 0;
//float   trackingObjectSpeedX[trackingOBJECT_MAX_COUNT];                       // The integer position of the dot on the strip (LED index)

void PicassoGenerate(bool reset) {
  if (loadingFlag)
  {
    loadingFlag = false;
    //setCurrentPalette();
    //FastLED.clear();
    // not for 3in1
    //    enlargedObjectNUM = (modes[currentMode].Scale - 1U) / 99.0 * (enlargedOBJECT_MAX_COUNT - 1U) + 1U;
    //enlargedObjectNUM = (modes[currentMode].Scale - 1U) % 11U / 10.0 * (enlargedOBJECT_MAX_COUNT - 1U) + 1U;
    if (enlargedObjectNUM > enlargedOBJECT_MAX_COUNT) enlargedObjectNUM = enlargedOBJECT_MAX_COUNT;
    if (enlargedObjectNUM < 2U) enlargedObjectNUM = 2U;

    double minSpeed = 0.2, maxSpeed = 0.8;

    for (uint8_t i = 0 ; i < enlargedObjectNUM ; i++) {
      trackingObjectPosX[i] = random8(WIDTH);
      trackingObjectPosY[i] = random8(HEIGHT);

      //curr->color = CHSV(random(1U, 255U), 255U, 255U);
      trackingObjectHue[i] = random8();

      trackingObjectSpeedY[i] = +((-maxSpeed / 3) + (maxSpeed * (float)random8(1, 100) / 100));
      trackingObjectSpeedY[i] += trackingObjectSpeedY[i] > 0 ? minSpeed : -minSpeed;

      trackingObjectShift[i] = +((-maxSpeed / 2) + (maxSpeed * (float)random8(1, 100) / 100));
      trackingObjectShift[i] += trackingObjectShift[i] > 0 ? minSpeed : -minSpeed;

      trackingObjectState[i] = trackingObjectHue[i];

    }
  }
  for (uint8_t i = 0 ; i < enlargedObjectNUM ; i++) {
    if (reset) {
      trackingObjectState[i] = random8();
      trackingObjectSpeedX[i] = (trackingObjectState[i] - trackingObjectHue[i]) / 25;
    }
    if (trackingObjectState[i] != trackingObjectHue[i] && trackingObjectSpeedX[i]) {
      trackingObjectHue[i] += trackingObjectSpeedX[i];
    }
  }

}

void PicassoPosition() {
  for (uint8_t i = 0 ; i < enlargedObjectNUM ; i++) {
    if (trackingObjectPosX[i] + trackingObjectSpeedY[i] > WIDTH || trackingObjectPosX[i] + trackingObjectSpeedY[i] < 0) {
      trackingObjectSpeedY[i] = -trackingObjectSpeedY[i];
    }

    if (trackingObjectPosY[i] + trackingObjectShift[i] > HEIGHT || trackingObjectPosY[i] + trackingObjectShift[i] < 0) {
      trackingObjectShift[i] = -trackingObjectShift[i];
    }

    trackingObjectPosX[i] += trackingObjectSpeedY[i];
    trackingObjectPosY[i] += trackingObjectShift[i];
  };
}

void PicassoRoutine() {
#if false  //defined(singleUSE_RANDOM_SETS_IN_APP) || defined(singleRANDOM_SETTINGS_IN_CYCLE_MODE)
  if (selectedSettings) {
    setModeSettings(17U + random8(64U) , 190U + random8(41U));
  }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

  PicassoGenerate(false);
  PicassoPosition();

  //  for (unsigned i = 0; i < numParticles - 2; i+=2) {
  //    Particle *p1 = (Particle *)&particles[i];
  //    Particle *p2 = (Particle *)&particles[i + 1];
  //    DrawLine(p1->position_x, p1->position_y, p2->position_x, p2->position_y, p1->color);
  //  }
  for (uint8_t i = 0 ; i < enlargedObjectNUM - 2U ; i += 2)
    DrawLine(trackingObjectPosX[i], trackingObjectPosY[i], trackingObjectPosX[i + 1U], trackingObjectPosY[i + 1U], CHSV(trackingObjectHue[i], 255U, 255U));
  //DrawLine(trackingObjectPosX[i], trackingObjectPosY[i], trackingObjectPosX[i+1U], trackingObjectPosY[i+1U], ColorFromPalette(*curPalette, trackingObjectHue[i]));


  EVERY_N_MILLIS(20000) {
    PicassoGenerate(true);
  }

  blurScreen(80);
}

void PicassoRoutine2() {
#if false //defined(singleUSE_RANDOM_SETS_IN_APP) || defined(singleRANDOM_SETTINGS_IN_CYCLE_MODE)
  if (selectedSettings) {
    setModeSettings(17U + random8(27U) , 185U + random8(46U));
  }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

  PicassoGenerate(false);
  PicassoPosition();
  dimAll(180);

  //  for (unsigned i = 0; i < numParticles - 1; i++) {
  //    Particle *p1 = (Particle *)&particles[i];
  //    Particle *p2 = (Particle *)&particles[i + 1];
  //    DrawLineF(p1->position_x, p1->position_y, p2->position_x, p2->position_y, p1->color);
  //  }
  for (uint8_t i = 0 ; i < enlargedObjectNUM - 1U ; i++)
    DrawLineF(trackingObjectPosX[i], trackingObjectPosY[i], trackingObjectPosX[i + 1U], trackingObjectPosY[i + 1U], CHSV(trackingObjectHue[i], 255U, 255U));
  //DrawLineF(trackingObjectPosX[i], trackingObjectPosY[i], trackingObjectPosX[i+1U], trackingObjectPosY[i+1U], ColorFromPalette(*curPalette, trackingObjectHue[i]));

  EVERY_N_MILLIS(20000) {
    PicassoGenerate(true);
  }

  blurScreen(80);

}

void PicassoRoutine3() {
#if false //defined(singleUSE_RANDOM_SETS_IN_APP) || defined(singleRANDOM_SETTINGS_IN_CYCLE_MODE)
  if (selectedSettings) {
    setModeSettings(19U + random8(31U) , 150U + random8(63U));
  }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

  PicassoGenerate(false);
  PicassoPosition();
  dimAll(180);

  //  for (unsigned i = 0; i < numParticles - 2; i+=2) {
  //    Particle *p1 = (Particle *)&particles[i];
  //    Particle *p2 = (Particle *)&particles[i + 1];
  //    drawCircleF(std::fabs(p1->position_x - p2->position_x), std::fabs(p1->position_y - p2->position_y), std::fabs(p1->position_x - p1->position_y), p1->color);
  //  }
  for (uint8_t i = 0 ; i < enlargedObjectNUM - 2U ; i += 2)
    drawCircleF(fabs(trackingObjectPosX[i] - trackingObjectPosX[i + 1U]), fabs(trackingObjectPosY[i] - trackingObjectPosX[i + 1U]), fabs(trackingObjectPosX[i] - trackingObjectPosY[i]), CHSV(trackingObjectHue[i], 255U, 255U));
  //drawCircleF(fabs(trackingObjectPosX[i] - trackingObjectPosX[i+1U]), fabs(trackingObjectPosY[i] - trackingObjectPosX[i+1U]), fabs(trackingObjectPosX[i] - trackingObjectPosY[i]), ColorFromPalette(*curPalette, trackingObjectHue[i]));

  EVERY_N_MILLIS(20000) {
    PicassoGenerate(true);
  }

  blurScreen(80);

}

void picassoSelector() {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
  if (selectedSettings) {
    uint8_t tmp = random8(3U);
    if (tmp == 2U)
      setModeSettings(4U + random8(42U) , 190U + random8(41U));
    else if (tmp)
      setModeSettings(39U + random8(8U) , 185U + random8(46U));
    else
      setModeSettings(73U + random8(10U) , 150U + random8(63U));
  }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)


  if (loadingFlag)
  {
    if (modes[currentMode].Scale < 34U)           // если масштаб до 34
      enlargedObjectNUM = (modes[currentMode].Scale - 1U) / 32.0 * (enlargedOBJECT_MAX_COUNT - 3U) + 3U;
    else if (modes[currentMode].Scale >= 68U)      // если масштаб больше 67
      enlargedObjectNUM = (modes[currentMode].Scale - 68U) / 32.0 * (enlargedOBJECT_MAX_COUNT - 3U) + 3U;
    else                                          // для масштабов посередине
      enlargedObjectNUM = (modes[currentMode].Scale - 34U) / 33.0 * (enlargedOBJECT_MAX_COUNT - 1U) + 1U;
  }

  if (modes[currentMode].Scale < 34U)           // если масштаб до 34
    PicassoRoutine();
  else if (modes[currentMode].Scale > 67U)      // если масштаб больше 67
    PicassoRoutine3();
  else                                          // для масштабов посередине
    PicassoRoutine2();
}

















// ------------------------------ ЭФФЕКТ ПРЫГУНЫ ----------------------
// взято откуда-то by @obliterator
// https://github.com/DmytroKorniienko/FireLamp_JeeUI/blob/templ/src/effects.cpp

//Leaper leapers[20];
//вместо класса Leaper будем повторно использовать переменные из эффекта мячики и мотыльки
//float x, y; будет:
//float trackingObjectPosX[enlargedOBJECT_MAX_COUNT];
//float trackingObjectPosY[enlargedOBJECT_MAX_COUNT];
//float xd, yd; будет:
////float trackingObjectSpeedX[enlargedOBJECT_MAX_COUNT];                   // As time goes on the impact velocity will change, so make an array to store those values
////float trackingObjectSpeedY[enlargedOBJECT_MAX_COUNT];                       // Coefficient of Restitution (bounce damping)
//CHSV color; будет:
////uint8_t trackingObjectHue[enlargedOBJECT_MAX_COUNT];

void LeapersRestart_leaper(uint8_t l) {
  // leap up and to the side with some random component
  trackingObjectSpeedX[l] = (1 * (float)random8(1, 100) / 100);
  trackingObjectSpeedY[l] = (2 * (float)random8(1, 100) / 100);

  // for variety, sometimes go 50% faster
  if (random8() < 12) {
    trackingObjectSpeedX[l] += trackingObjectSpeedX[l] * 0.5;
    trackingObjectSpeedY[l] += trackingObjectSpeedY[l] * 0.5;
  }

  // leap towards the centre of the screen
  if (trackingObjectPosX[l] > (WIDTH / 2)) {
    trackingObjectSpeedX[l] = -trackingObjectSpeedX[l];
  }
}

void LeapersMove_leaper(uint8_t l) {
#define GRAVITY            0.06
#define SETTLED_THRESHOLD  0.1
#define WALL_FRICTION      0.95
#define WIND               0.95    // wind resistance

  trackingObjectPosX[l] += trackingObjectSpeedX[l];
  trackingObjectPosY[l] += trackingObjectSpeedY[l];

  // bounce off the floor and ceiling?
  if (trackingObjectPosY[l] < 0 || trackingObjectPosY[l] > HEIGHT - 1) {
    trackingObjectSpeedY[l] = (-trackingObjectSpeedY[l] * WALL_FRICTION);
    trackingObjectSpeedX[l] = ( trackingObjectSpeedX[l] * WALL_FRICTION);
    trackingObjectPosY[l] += trackingObjectSpeedY[l];
    if (trackingObjectPosY[l] < 0)
      trackingObjectPosY[l] = 0; // settled on the floor?
    if (trackingObjectPosY[l] <= SETTLED_THRESHOLD && fabs(trackingObjectSpeedY[l]) <= SETTLED_THRESHOLD) {
      LeapersRestart_leaper(l);
    }
  }

  // bounce off the sides of the screen?
  if (trackingObjectPosX[l] <= 0 || trackingObjectPosX[l] >= WIDTH - 1) {
    trackingObjectSpeedX[l] = (-trackingObjectSpeedX[l] * WALL_FRICTION);
    if (trackingObjectPosX[l] <= 0) {
      //trackingObjectPosX[l] = trackingObjectSpeedX[l]; // the bug?
      trackingObjectPosX[l] = -trackingObjectPosX[l];
    } else {
      //trackingObjectPosX[l] = WIDTH - 1 - trackingObjectSpeedX[l]; // the bug?
      trackingObjectPosX[l] = WIDTH + WIDTH - 2 - trackingObjectPosX[l];
    }
  }

  trackingObjectSpeedY[l] -= GRAVITY;
  trackingObjectSpeedX[l] *= WIND;
  trackingObjectSpeedY[l] *= WIND;
}


void LeapersRoutine() {
  //unsigned num = map(scale, 0U, 255U, 6U, sizeof(boids) / sizeof(*boids));
  if (loadingFlag)
  {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      setModeSettings(random8(8U) * 11U + 5U + random8(7U) , 185U + random8(56U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    setCurrentPalette();
    //FastLED.clear();
    //enlargedObjectNUM = (modes[currentMode].Scale - 1U) / 99.0 * (enlargedOBJECT_MAX_COUNT - 1U) + 1U;
    enlargedObjectNUM = (modes[currentMode].Scale - 1U) % 11U / 10.0 * (enlargedOBJECT_MAX_COUNT - 1U) + 1U;
    if (enlargedObjectNUM > enlargedOBJECT_MAX_COUNT) enlargedObjectNUM = enlargedOBJECT_MAX_COUNT;
    //if (enlargedObjectNUM < 2U) enlargedObjectNUM = 2U;

    for (uint8_t i = 0 ; i < enlargedObjectNUM ; i++) {
      trackingObjectPosX[i] = random8(WIDTH);
      trackingObjectPosY[i] = random8(HEIGHT);

      //curr->color = CHSV(random(1U, 255U), 255U, 255U);
      trackingObjectHue[i] = random8();
    }
  }

  //myLamp.dimAll(0); накой хрен делать затухание на 100%?
  FastLED.clear();

  for (uint8_t i = 0; i < enlargedObjectNUM; i++) {
    LeapersMove_leaper(i);
    //drawPixelXYF(trackingObjectPosX[i], trackingObjectPosY[i], CHSV(trackingObjectHue[i], 255U, 255U));
    drawPixelXYF(trackingObjectPosX[i], trackingObjectPosY[i], ColorFromPalette(*curPalette, trackingObjectHue[i]));
  };

  blurScreen(20);
}

// ------------------------------ ЭФФЕКТ ЛАВОВАЯ ЛАМПА ----------------------
// (c) SottNick

//float trackingObjectPosX[enlargedOBJECT_MAX_COUNT];                         // координата по Х
//float trackingObjectPosY[enlargedOBJECT_MAX_COUNT];                         // координата по Y
//float trackingObjectSpeedY[enlargedOBJECT_MAX_COUNT];                   // скорость движения пузыря
//float trackingObjectShift[enlargedOBJECT_MAX_COUNT];                       // радиус пузыря ... мог бы быть, если бы круги рисовались нормально

void LavaLampGetspeed(uint8_t l) {
  //trackingObjectSpeedY[l] = (float)random8(1, 11) / 10.0; // скорость пузырей 10 градаций?
  trackingObjectSpeedY[l] = (float)random8(5, 11) / (257U - modes[currentMode].Speed) / 4.0; // если скорость кадров фиксированная
}
void drawBlob(uint8_t l, CRGB color) { //раз круги нарисовать не получается, будем попиксельно вырисовывать 2 варианта пузырей
  if (trackingObjectShift[l] == 2)
  {
    for (int8_t x = -2; x < 3; x++)
      for (int8_t y = -2; y < 3; y++)
        if (abs(x) + abs(y) < 4)
          drawPixelXYF(fmod(trackingObjectPosX[l] + x + WIDTH, WIDTH), trackingObjectPosY[l] + y, color);
  }
  else
  {
    for (int8_t x = -1; x < 3; x++)
      for (int8_t y = -1; y < 3; y++)
        if (!(x == -1 && (y == -1 || y == 2) || x == 2 && (y == -1 || y == 2)))
          drawPixelXYF(fmod(trackingObjectPosX[l] + x + WIDTH, WIDTH), trackingObjectPosY[l] + y, color);
  }
}

void LavaLampRoutine() {
  //unsigned num = map(scale, 0U, 255U, 6U, sizeof(boids) / sizeof(*boids));
  if (loadingFlag)
  {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      setModeSettings(random8(30U) ? (random8(3U) ? 2U + random8(98U) : 1U) : 100U, 50U + random8(196U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    //enlargedObjectNUM = (modes[currentMode].Scale - 1U) / 99.0 * (enlargedOBJECT_MAX_COUNT - 1U) + 1U;
    //if (enlargedObjectNUM > enlargedOBJECT_MAX_COUNT)
    //  enlargedObjectNUM = enlargedOBJECT_MAX_COUNT;
    //if (enlargedObjectNUM < 2U) enlargedObjectNUM = 2U;
    enlargedObjectNUM = (WIDTH / 2) -  ((WIDTH - 1) & 0x01);

    uint8_t shift = random8(2);
    for (uint8_t i = 0; i < enlargedObjectNUM; i++) {
      //LavaLampRestart_leaper(i);
      trackingObjectPosY[i] = 0;//random8(HEIGHT);
      trackingObjectPosX[i] = i * 2U + shift;
      LavaLampGetspeed(i);
      //trackingObjectShift[i] = 1.0 + 0.2 * random8(8); // присваивается случайный радиус пузырям от 1 до 2,5
      trackingObjectShift[i] = random8(1, 3); // присваивается случайный целочисленный радиус пузырям от 1 до 2
    }
    if (modes[currentMode].Scale != 1U)
      hue = modes[currentMode].Scale * 2.57;
  }
  if (modes[currentMode].Scale == 1U)
  {
    hue2++;
    if (hue2 % 0x10 == 0U)
      hue++;
  }
  CRGB color = CHSV(hue, (modes[currentMode].Scale < 100U) ? 255U : 0U, 255U);
  //CRGB halfcolor = CHSV(hue, 255U, 1275U);

  FastLED.clear();

  for (uint8_t i = 0; i < enlargedObjectNUM; i++) { //двигаем по аналогии с https://jiwonk.im/lavalamp/
    //LavaLampMove_leaper(i);
    if (trackingObjectPosY[i] + trackingObjectShift[i] >= HEIGHT - 1)
      trackingObjectPosY[i] += (trackingObjectSpeedY[i] * ((HEIGHT - 1 - trackingObjectPosY[i]) / trackingObjectShift[i] + 0.005));
    else if (trackingObjectPosY[i] - trackingObjectShift[i] <= 0)
      trackingObjectPosY[i] += (trackingObjectSpeedY[i] * (trackingObjectPosY[i] / trackingObjectShift[i] + 0.005));
    else
      trackingObjectPosY[i] += trackingObjectSpeedY[i];

    // bounce off the floor and ceiling?
    if (trackingObjectPosY[i] < 0.01) {                  // почему-то при нуле появляется мерцание (один кадр, еле заметно)
      LavaLampGetspeed(i);
      //trackingObjectShift[i] = 1+2*trackingObjectSpeedY[i]; менять радиус после отскока - плохая идея
      trackingObjectPosY[i] = 0.01;
    }
    else if (trackingObjectPosY[i] > HEIGHT - 1.01) {    // тоже на всякий пожарный
      LavaLampGetspeed(i);
      //trackingObjectShift[i] = 1+2*trackingObjectSpeedY[i]; менять радиус после отскока - плохая идея
      trackingObjectSpeedY[i] = -trackingObjectSpeedY[i];
      trackingObjectPosY[i] = HEIGHT - 1.01;
    }

    /*
        // рисуем пузыри откружностями - получаются не круги, а неопознанные объекты
        for (uint8_t r = 1; r < trackingObjectShift[i]; r++)
          drawCircleF(trackingObjectPosX[i], trackingObjectPosY[i], r, color);
        drawCircleF(trackingObjectPosX[i], trackingObjectPosY[i], trackingObjectShift[i], color);
        drawPixelXYF(trackingObjectPosX[i], trackingObjectPosY[i], color); // центральная точка
    */
    drawBlob(i, color); // раз круги выглядят убого, рисуем попиксельно 2 размера пузырей
  };

  /*
    // инвертируем всё (получается какая-то хрень)
    uint8_t tsue = (modes[currentMode].Scale < 100U) ? 255U : 0U;
    if (modes[currentMode].Brightness & 0x01)
    for (uint16_t i = 0U; i < NUM_LEDS; i++)
      leds[i] = CHSV(hue, tsue, 255U - leds[i].getLuma());
    else
    for (uint16_t i = 0U; i < NUM_LEDS; i++)
      leds[i] = CHSV(hue, tsue, 255U - leds[i].getAverageLight());
  */

  blurScreen(20);
}

// ********************** SHADOWS ***********************
// https://github.com/vvip-68/GyverPanelWiFi/blob/master/firmware/GyverPanelWiFi_v1.04/effects.ino
// (c) vvip-68
void shadowsRoutine() {
  /*  if (loadingFlag) {
      // modeCode = MC_SHADOWS;
      loadingFlag = false;
    }
  */
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
  if (selectedSettings) {
    setModeSettings(1U, 1U + random8(255U));
  }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

  static uint16_t sPseudotime = 0;
  static uint16_t sLastMillis = 0;
  static uint16_t sHue16 = 0;

  uint8_t sat8 = beatsin88( 87, 220, 250);
  uint8_t brightdepth = beatsin88( 341, 96, 224);
  uint16_t brightnessthetainc16 = beatsin88( 203, (25 * 256), (40 * 256));
  uint8_t msmultiplier = beatsin88(map(modes[currentMode].Speed, 1, 255, 100, 255), 32, map(modes[currentMode].Speed, 1, 255, 60, 255));//beatsin88(147, 23, 60);

  uint16_t hue16 = sHue16;//gHue * 256;
  uint16_t hueinc16 = beatsin88(113, 1, 3000);

  uint16_t ms = millis();
  uint16_t deltams = ms - sLastMillis ;

  byte effectBrightness = modes[currentMode].Scale * 2.55; //getBrightnessCalculated(globalBrightness, effectContrast[thisMode]);


  sLastMillis  = ms;
  sPseudotime += deltams * msmultiplier;
  sHue16 += deltams * beatsin88( 400, 5, 9);
  uint16_t brightnesstheta16 = sPseudotime;

  //byte bri_dx = map8(255-effectSpeed, 50, 100);

  for ( uint16_t i = 0 ; i < NUM_LEDS; i++) {
    hue16 += hueinc16;
    uint8_t hue8 = hue16 / 256;

    brightnesstheta16  += brightnessthetainc16;
    uint16_t b16 = sin16( brightnesstheta16  ) + 32768;

    uint16_t bri16 = (uint32_t)((uint32_t)b16 * (uint32_t)b16) / 65536;
    uint8_t bri8 = (uint32_t)(((uint32_t)bri16) * brightdepth) / 65536;
    bri8 += (255 - brightdepth);

    CRGB newcolor = CHSV( hue8, sat8, map8(bri8, map(effectBrightness, 32, 255, 32, 125), map(effectBrightness, 32, 255, 125, 250)));

    uint16_t pixelnumber = i;
    pixelnumber = (NUM_LEDS - 1) - pixelnumber;

    nblend( leds[pixelnumber], newcolor, 64);
  }
}

// ----------- Эффект "ДНК"
// База https://pastebin.com/jwvC1sNF адаптация и доработки kostyamat
// нормальные копирайты:
// https://pastebin.com/jwvC1sNF
//2 DNA spiral with subpixel
//16x16 rgb led matrix demo
//Yaroslaw Turbin 04.09.2020
//https://vk.com/ldirko
//https://www.reddit.com/user/ldirko/
//https://www.reddit.com/r/FastLED/comments/gogs4n/i_made_7x11_matrix_for_my_ntp_clock_project_then/

//this is update for DNA procedure https://pastebin.com/Qa8A5NvW
//add subpixel render foк nice smooth look

void wu_pixel(uint32_t x, uint32_t y, CRGB * col) {      //awesome wu_pixel procedure by reddit u/sutaburosu
  // extract the fractional parts and derive their inverses
  uint8_t xx = x & 0xff, yy = y & 0xff, ix = 255 - xx, iy = 255 - yy;
  // calculate the intensities for each affected pixel
#define WU_WEIGHT(a,b) ((uint8_t) (((a)*(b)+(a)+(b))>>8))
  uint8_t wu[4] = {WU_WEIGHT(ix, iy), WU_WEIGHT(xx, iy),
                   WU_WEIGHT(ix, yy), WU_WEIGHT(xx, yy)
                  };
  // multiply the intensities by the colour, and saturating-add them to the pixels
  for (uint8_t i = 0; i < 4; i++) {
    uint16_t xy = XY((x >> 8) + (i & 1), (y >> 8) + ((i >> 1) & 1));
    if (xy < NUM_LEDS) {
      leds[xy].r = qadd8(leds[xy].r, col->r * wu[i] >> 8);
      leds[xy].g = qadd8(leds[xy].g, col->g * wu[i] >> 8);
      leds[xy].b = qadd8(leds[xy].b, col->b * wu[i] >> 8);
    }
  }
}

void DNARoutine()
{
  if (loadingFlag)
  {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      setModeSettings(1U + random8(100U), 1U + random8(200U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    loadingFlag = false;
    step = map8(modes[currentMode].Speed, 10U, 60U);
    hue = modes[currentMode].Scale;
    deltaHue = hue > 50U;
    if (deltaHue)
      hue = 101U - hue;
    hue = 255U - map( 51U - hue, 1U, 50U, 0, 255U);
  }
  double freq = 3000;
  float mn = 255.0 / 13.8;

  fadeToBlackBy(leds, NUM_LEDS, step);
  uint16_t ms = millis();

  if (deltaHue)
    for (uint8_t i = 0; i < WIDTH; i++)
    {
      uint32_t x = beatsin16(step, 0, (HEIGHT - 1) * 256, 0, i * freq);
      uint32_t y = i * 256;
      uint32_t x1 = beatsin16(step, 0, (HEIGHT - 1) * 256, 0, i * freq + 32768);

      CRGB col = CHSV(ms / 29 + i * 255 / (WIDTH - 1), 255, qadd8(hue, beatsin8(step, 60, 255U, 0, i * mn)));
      CRGB col1 = CHSV(ms / 29 + i * 255 / (WIDTH - 1) + 128, 255, qadd8(hue, beatsin8(step, 60, 255U, 0, i * mn + 128)));
      wu_pixel (y , x, &col);
      wu_pixel (y , x1, &col1);
    }
  else
    for (uint8_t i = 0; i < HEIGHT; i++)
    {
      uint32_t x = beatsin16(step, 0, (WIDTH - 1) * 256, 0, i * freq);
      uint32_t y = i * 256;
      uint32_t x1 = beatsin16(step, 0, (WIDTH - 1) * 256, 0, i * freq + 32768);

      CRGB col = CHSV(ms / 29 + i * 255 / (HEIGHT - 1), 255, qadd8(hue, beatsin8(step, 60, 255U, 0, i * mn)));
      CRGB col1 = CHSV(ms / 29 + i * 255 / (HEIGHT - 1) + 128, 255, qadd8(hue, beatsin8(step, 60, 255U, 0, i * mn + 128)));
      wu_pixel (x , y, &col);
      wu_pixel (x1 , y, &col1);
    }

  blurScreen(16);
}



// ------------- Змейки --------------
// (c) SottNick

//#define enlargedOBJECT_MAX_COUNT            (WIDTH * 2)          // максимальное количество червяков
//uint8_t enlargedObjectNUM;                                   // выбранное количество червяков
//long  enlargedObjectTime[enlargedOBJECT_MAX_COUNT] ;  // тут будет траектория тела червяка
//float trackingObjectPosX[trackingOBJECT_MAX_COUNT]; // тут будет позиция головы
//float trackingObjectPosY[trackingOBJECT_MAX_COUNT]; // тут будет позиция головы
//float trackingObjectSpeedX[trackingOBJECT_MAX_COUNT]; // тут будет скорость червяка
//float trackingObjectSpeedY[trackingOBJECT_MAX_COUNT]; // тут будет дробная часть позиции головы
//float trackingObjectShift[trackingOBJECT_MAX_COUNT]; не пригодилось пока что
//uint8_t trackingObjectHue[trackingOBJECT_MAX_COUNT]; // тут будет начальный цвет червяка
//uint8_t trackingObjectState[trackingOBJECT_MAX_COUNT]; тут будет направление червяка

#define SNAKES_LENGTH (8U) // длина червяка от 2 до 15 (+ 1 пиксель голова/хвостик), ограничена размером переменной для хранения трактории тела червяка

void snakesRoutine() {
  if (loadingFlag)
  {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      uint8_t tmp = random8(8U);
      setModeSettings(8U + tmp * tmp, 20U + random8(120U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    speedfactor = (float)modes[currentMode].Speed / 555.0f + 0.001f;

    enlargedObjectNUM = (modes[currentMode].Scale - 1U) / 99.0 * (enlargedOBJECT_MAX_COUNT - 1U) + 1U;
    if (enlargedObjectNUM > enlargedOBJECT_MAX_COUNT) enlargedObjectNUM = enlargedOBJECT_MAX_COUNT;
    for (uint8_t i = 0; i < enlargedObjectNUM; i++) {
      enlargedObjectTime[i] = 0;
      trackingObjectPosX[i] = random8(WIDTH);
      trackingObjectPosY[i] = random8(HEIGHT);
      trackingObjectSpeedX[i] = (255. + random8()) / 255.;
      trackingObjectSpeedY[i] = 0;
      //trackingObjectShift[i] = 0;
      trackingObjectHue[i] = random8();
      trackingObjectState[i] = random8(4);//     B00           направление головы змейки
      // B10     B11
      //     B01
    }

  }
  //hue++;
  //dimAll(220);
  FastLED.clear();

  int8_t dx, dy;
  for (uint8_t i = 0; i < enlargedObjectNUM; i++) {
    trackingObjectSpeedY[i] += trackingObjectSpeedX[i] * speedfactor;
    if (trackingObjectSpeedY[i] >= 1)
    {
      trackingObjectSpeedY[i] = trackingObjectSpeedY[i] - (int)trackingObjectSpeedY[i];
      if (random8(9U) == 0U) // вероятность поворота
        if (random8(2U)) { // <- поворот налево
          enlargedObjectTime[i] = (enlargedObjectTime[i] << 2) | B01; // младший бит = поворот
          switch (trackingObjectState[i]) {
            case B10:
              trackingObjectState[i] = B01;
              if (trackingObjectPosY[i] == 0U)
                trackingObjectPosY[i] = HEIGHT - 1U;
              else
                trackingObjectPosY[i]--;
              break;
            case B11:
              trackingObjectState[i] = B00;
              if (trackingObjectPosY[i] >= HEIGHT - 1U)
                trackingObjectPosY[i] = 0U;
              else
                trackingObjectPosY[i]++;
              break;
            case B00:
              trackingObjectState[i] = B10;
              if (trackingObjectPosX[i] == 0U)
                trackingObjectPosX[i] = WIDTH - 1U;
              else
                trackingObjectPosX[i]--;
              break;
            case B01:
              trackingObjectState[i] = B11;
              if (trackingObjectPosX[i] >= WIDTH - 1U)
                trackingObjectPosX[i] = 0U;
              else
                trackingObjectPosX[i]++;
              break;
          }
        }
        else { // -> поворот направо
          enlargedObjectTime[i] = (enlargedObjectTime[i] << 2) | B11; // младший бит = поворот, старший = направо
          switch (trackingObjectState[i]) {
            case B11:
              trackingObjectState[i] = B01;
              if (trackingObjectPosY[i] == 0U)
                trackingObjectPosY[i] = HEIGHT - 1U;
              else
                trackingObjectPosY[i]--;
              break;
            case B10:
              trackingObjectState[i] = B00;
              if (trackingObjectPosY[i] >= HEIGHT - 1U)
                trackingObjectPosY[i] = 0U;
              else
                trackingObjectPosY[i]++;
              break;
            case B01:
              trackingObjectState[i] = B10;
              if (trackingObjectPosX[i] == 0U)
                trackingObjectPosX[i] = WIDTH - 1U;
              else
                trackingObjectPosX[i]--;
              break;
            case B00:
              trackingObjectState[i] = B11;
              if (trackingObjectPosX[i] >= WIDTH - 1U)
                trackingObjectPosX[i] = 0U;
              else
                trackingObjectPosX[i]++;
              break;
          }
        }
      else { // двигаем без поворота
        enlargedObjectTime[i] = (enlargedObjectTime[i] << 2);
        switch (trackingObjectState[i]) {
          case B01:
            if (trackingObjectPosY[i] == 0U)
              trackingObjectPosY[i] = HEIGHT - 1U;
            else
              trackingObjectPosY[i]--;
            break;
          case B00:
            if (trackingObjectPosY[i] >= HEIGHT - 1U)
              trackingObjectPosY[i] = 0U;
            else
              trackingObjectPosY[i]++;
            break;
          case B10:
            if (trackingObjectPosX[i] == 0U)
              trackingObjectPosX[i] = WIDTH - 1U;
            else
              trackingObjectPosX[i]--;
            break;
          case B11:
            if (trackingObjectPosX[i] >= WIDTH - 1U)
              trackingObjectPosX[i] = 0U;
            else
              trackingObjectPosX[i]++;
            break;
        }

      }
    }

    switch (trackingObjectState[i]) {
      case B01:
        dy = 1;
        dx = 0;
        break;
      case B00:
        dy = -1;
        dx = 0;
        break;
      case B10:
        dy = 0;
        dx = 1;
        break;
      case B11:
        dy = 0;
        dx = -1;
        break;
    }
    long temp = enlargedObjectTime[i];
    uint8_t x = trackingObjectPosX[i];
    uint8_t y = trackingObjectPosY[i];
    //CHSV color = CHSV(trackingObjectHue[i], 255U, 255U);
    //drawPixelXY(x, y, color);
    //drawPixelXYF(x, y, CHSV(trackingObjectHue[i], 255U, trackingObjectSpeedY[i] * 255)); // тут рисуется голова // слишком сложно для простого сложения цветов
    leds[XY(x, y)] += CHSV(trackingObjectHue[i], 255U, trackingObjectSpeedY[i] * 255); // тут рисуется голова

    for (uint8_t m = 0; m < SNAKES_LENGTH; m++) { // 16 бит распаковываем, 14 ещё остаётся без дела в запасе, 2 на хвостик
      x = (WIDTH + x + dx) % WIDTH;
      y = (HEIGHT + y + dy) % HEIGHT;
      //drawPixelXYF(x, y, CHSV(trackingObjectHue[i] + m*4U, 255U, 255U)); // тут рисуется тело // слишком сложно для простого сложения цветов
      //leds[XY(x,y)] += CHSV(trackingObjectHue[i] + m*4U, 255U, 255U); // тут рисуется тело
      leds[XY(x, y)] += CHSV(trackingObjectHue[i] + (m + trackingObjectSpeedY[i]) * 4U, 255U, 255U); // тут рисуется тело

      if (temp & B01) { // младший бит = поворот, старший = направо
        temp = temp >> 1;
        if (temp & B01) { // старший бит = направо
          if (dx == 0) {
            dx = 0 - dy;
            dy = 0;
          }
          else {
            dy = dx;
            dx = 0;
          }
        }
        else { // иначе налево
          if (dx == 0) {
            dx = dy;
            dy = 0;
          }
          else {
            dy = 0 - dx;
            dx = 0;
          }
        }
        temp = temp >> 1;
      }
      else { // если без поворота
        temp = temp >> 2;
      }
    }
    x = (WIDTH + x + dx) % WIDTH;
    y = (HEIGHT + y + dy) % HEIGHT;
    //drawPixelXYF(x, y, CHSV(trackingObjectHue[i] + SNAKES_LENGTH*4U, 255U, (1 - trackingObjectSpeedY[i]) * 255)); // хвостик // слишком сложно для простого сложения цветов
    //leds[XY(x,y)] += CHSV(trackingObjectHue[i] + SNAKES_LENGTH*4U, 255U, (1 - trackingObjectSpeedY[i]) * 255); // хвостик
    leds[XY(x, y)] += CHSV(trackingObjectHue[i] + (SNAKES_LENGTH + trackingObjectSpeedY[i]) * 4U, 255U, (1 - trackingObjectSpeedY[i]) * 255); // хвостик
  }
}

//---------- Эффект "Фейерверк" Салют ---
//адаптация и переписал - kostyamat
//https://gist.github.com/jasoncoon/0cccc5ba7ab108c0a373
//https://github.com/marcmerlin/FastLED_NeoMatrix_SmartMatrix_LEDMatrix_GFX_Demos/blob/master/FastLED/FireWorks2/FireWorks2.ino

// не понравился
/*
  #define MODEL_BORDER (HEIGHT - 4U)  // как далеко за экран может вылетить снаряд, если снаряд вылетает за экран, то всышка белого света (не особо логично)
  #define MODEL_WIDTH  (MODEL_BORDER + WIDTH  + MODEL_BORDER) // не трогать, - матиматика
  #define MODEL_HEIGHT (MODEL_BORDER + HEIGHT + MODEL_BORDER) // -//-
  #define PIXEL_X_OFFSET ((MODEL_WIDTH  - WIDTH ) / 2) // -//-
  #define PIXEL_Y_OFFSET ((MODEL_HEIGHT - HEIGHT) / 2) // -//-

  #define SPARK 8U // максимальное количество снарядов
  #define NUM_SPARKS WIDTH // количество разлетающихся петард (частей снаряда)
  const saccum78 gGravity = 10;
  const fract8  gBounce = 127;
  const fract8  gDrag = 255;

  typedef struct _DOTS_STORE {
    accum88 gBurstx;
    accum88 gBursty;
    saccum78 gBurstxv;
    saccum78 gBurstyv;
    CRGB gBurstcolor;
    bool gSkyburst = false;
  } DOTS_STORE;
  DOTS_STORE store[SPARK];

  class Dot {    // класс для создания снарядов и питард
  public:
  byte    show;
  byte    theType;
  accum88 x;
  accum88 y;
  saccum78 xv;
  saccum78 yv;
  accum88 r;
  CRGB color;

  Dot() {
    show = 0;
    theType = 0;
    x =  0;
    y =  0;
    xv = 0;
    yv = 0;
    r  = 0;
    color.setRGB( 0, 0, 0);
  }

  void Draw()
  {
    if( !show) return;
    byte ix, xe, xc;
    byte iy, ye, yc;
    screenscale( x, MODEL_WIDTH, ix, xe);
    screenscale( y, MODEL_HEIGHT, iy, ye);
    yc = 255 - ye;
    xc = 255 - xe;

    CRGB c00 = CRGB( dim8_video( scale8( scale8( color.r, yc), xc)),
                     dim8_video( scale8( scale8( color.g, yc), xc)),
                     dim8_video( scale8( scale8( color.b, yc), xc))
                     );
    CRGB c01 = CRGB( dim8_video( scale8( scale8( color.r, ye), xc)),
                     dim8_video( scale8( scale8( color.g, ye), xc)),
                     dim8_video( scale8( scale8( color.b, ye), xc))
                     );

    CRGB c10 = CRGB( dim8_video( scale8( scale8( color.r, yc), xe)),
                     dim8_video( scale8( scale8( color.g, yc), xe)),
                     dim8_video( scale8( scale8( color.b, yc), xe))
                     );
    CRGB c11 = CRGB( dim8_video( scale8( scale8( color.r, ye), xe)),
                     dim8_video( scale8( scale8( color.g, ye), xe)),
                     dim8_video( scale8( scale8( color.b, ye), xe))
                     );

    piXY(ix, iy) += c00;
    piXY(ix, iy + 1) += c01;
    piXY(ix + 1, iy) += c10;
    piXY(ix + 1, iy + 1) += c11;
  }

  void Move(byte num, bool Flashing)
  {
    if( !show) return;
    yv -= gGravity;
    xv = scale15by8_local( xv, gDrag);
    yv = scale15by8_local( yv, gDrag);

    if( theType == 2) {
      xv = scale15by8_local( xv, gDrag);
      yv = scale15by8_local( yv, gDrag);
      color.nscale8( 255);
      if( !color) {
        show = 0;
      }
    }
    // if we'd hit the ground, bounce
    if( yv < 0 && (y < (-yv)) ) {
      if( theType == 2 ) {
        show = 0;
      } else {
        yv = -yv;
        yv = scale15by8_local( yv, gBounce);
        if( yv < 500 ) {
          show = 0;
        }
      }
    }
    if (yv < -300) { // && (!(oyv < 0)) ) {
      // pinnacle
      if( theType == 1 ) {

        if( (y > (uint16_t)(0x8000)) && (random8() < 32) && Flashing) {
          // boom
          LEDS.showColor( CRGB::Gray);
          LEDS.showColor( CRGB::Black);
        }

        show = 0;

        store[num].gSkyburst = true;
        store[num].gBurstx = x;
        store[num].gBursty = y;
        store[num].gBurstxv = xv;
        store[num].gBurstyv = yv;
        store[num].gBurstcolor = CRGB(random8(), random8(), random8());
      }
    }
    if( theType == 2) {
      if( ((xv >  0) && (x > xv)) ||
          ((xv < 0 ) && (x < (0xFFFF + xv))) )  {
        x += xv;
      } else {
        show = 0;
      }
    } else {
      x += xv;
    }
    y += yv;

  }

  void GroundLaunch()
  {
    yv = 600 + random16(400 + (25 * HEIGHT));
    if(yv > 1200) yv = 1200;
    xv = (int16_t)random16(600) - (int16_t)300;
    y = 0;
    x = 0x8000;
    color = CHSV(0, 0, 130); // цвет запускаемого снаряда
    show = 1;
  }

  void Skyburst( accum88 basex, accum88 basey, saccum78 basedv, CRGB& basecolor, uint8_t dim)
  {
    yv = (int16_t)0 + (int16_t)random16(1500) - (int16_t)500;
    xv = basedv + (int16_t)random16(2000) - (int16_t)1000;
    y = basey;
    x = basex;
    color = basecolor;
    //EffectMath::makeBrighter(color, 50);
    color *= dim; //50;
    theType = 2;
    show = 1;
  }

  //  CRGB &piXY(byte x, byte y);

  int16_t scale15by8_local( int16_t i, fract8 _scale )
  {
    int16_t result;
    result = (int32_t)((int32_t)i * _scale) / 256;
    return result;
  };

  void screenscale(accum88 a, byte N, byte &screen, byte &screenerr)
  {
    byte ia = a >> 8;
    screen = scale8(ia, N);
    byte m = screen * (256 / N);
    screenerr = (ia - m) * scale8(255, N);
    return;
  };
  };


  uint16_t launchcountdown[SPARK];
  //bool flashing = true; // нахрен эти вспышки прямо в коде false напишу
  Dot gDot[SPARK];
  Dot gSparks[NUM_SPARKS];

  CRGB overrun;
  CRGB& piXY(byte x, byte y) {
  x -= PIXEL_X_OFFSET;
  //x = (x - PIXEL_X_OFFSET) % WIDTH; // зацикливаем поле по иксу
  y -= PIXEL_Y_OFFSET;
  if( x < WIDTH && y < HEIGHT) {
    return leds[XY(x, y)];
  } else
    //return empty; // fixed //  CRGB empty = CRGB(0,0,0);
    return overrun;//CRGB(0,0,0);
  }


  void sparkGen() {
  for (byte c = 0; c < enlargedObjectNUM; c++) { // modes[currentMode].Scale / хз
    if( gDot[c].show == 0 ) {
      if( launchcountdown[c] == 0) {
        gDot[c].GroundLaunch();
        gDot[c].theType = 1;
        launchcountdown[c] = random16(1200 - modes[currentMode].Speed*4) + 1;
      } else {
        launchcountdown[c] --;
      }
    }
   if( store[c].gSkyburst) {
     store[c].gBurstcolor = CHSV(random8(), 200, 100);
     store[c].gSkyburst = false;
     byte nsparks = random8( NUM_SPARKS / 2, NUM_SPARKS + 1);
     for( byte b = 0; b < nsparks; b++) {
       gSparks[b].Skyburst( store[c].gBurstx, store[c].gBursty, store[c].gBurstyv, store[c].gBurstcolor, pcnt);
     }
   }

  }

  //myLamp.blur2d(20);
  }

  void fireworksRoutine()
  {
  if (loadingFlag)
  {
    loadingFlag = false;
    enlargedObjectNUM = (modes[currentMode].Scale - 1U) / 99.0 * (SPARK - 1U) + 1U;
    if (enlargedObjectNUM > SPARK) enlargedObjectNUM = SPARK;

    for (byte c = 0; c < SPARK; c++)
      launchcountdown[c] = 0;
  }

  //random16_add_entropy(analogRead(A0));
  pcnt = beatsin8(100, 20, 100);
  if (hue++ % 10 == 0U){//  EVERY_N_MILLIS(EFFECTS_RUN_TIMER * 10) {
    deltaValue = random8(25, 50);
  }
  //  EVERY_N_MILLIS(10) {//странный интервал
    fadeToBlackBy(leds, NUM_LEDS, deltaValue);
    sparkGen();
    //memset8( leds, 0, NUM_LEDS * 3);

    for (byte a = 0; a < enlargedObjectNUM; a++) { //modes[currentMode].Scale / хз
      gDot[a].Move(a, false);//flashing);
      gDot[a].Draw();
    }
    for( byte b = 0; b < NUM_SPARKS; b++) {
      gSparks[b].Move(0, false);//flashing);
      gSparks[b].Draw();
    }
  //  }  }
*/

// ----------------------------- Жидкая лампа ---------------------
// ----------- Эффект "Лавовая лампа" (c) obliterator
// https://github.com/DmytroKorniienko/FireLamp_JeeUI/commit/9bad25adc2c917fbf3dfa97f4c498769aaf76ebe
// с генератором палитр by SottNick


//аналог ардуино функции map(), но только для float
float fmap(const float x, const float in_min, const float in_max, const float out_min, const float out_max) {
  return (out_max - out_min) * (x - in_min) / (in_max - in_min) + out_min;
}
float mapcurve(const float x, const float in_min, const float in_max, const float out_min, const float out_max, float (*curve)(float, float, float, float)) {
  if (x <= in_min) return out_min;
  if (x >= in_max) return out_max;
  return curve((x - in_min), out_min, (out_max - out_min), (in_max - in_min));
}
float InQuad(float t, float b, float c, float d) {
  t /= d;
  return c * t * t + b;
}
float OutQuart(float t, float b, float c, float d) {
  t = t / d - 1;
  return -c * (t * t * t * t - 1) + b;
}
float InOutQuad(float t, float b, float c, float d) {
  t /= d / 2;
  if (t < 1) return c / 2 * t * t + b;
  --t;
  return -c / 2 * (t * (t - 2) - 1) + b;
}

unsigned MASS_MIN = 10;
unsigned MASS_MAX = 50;

//массивы для метаболов (используем повторно всё подряд)
//uint8_t trackingObjectHue[enlargedOBJECT_MAX_COUNT];
//        float position_x = 0;
//float trackingObjectPosX[enlargedOBJECT_MAX_COUNT];
//        float position_y = 0;
//float trackingObjectPosY[enlargedOBJECT_MAX_COUNT];
//        float speed_x = 0;
//float trackingObjectSpeedX[enlargedOBJECT_MAX_COUNT];
//        float speed_y = 0;
//float trackingObjectSpeedY[enlargedOBJECT_MAX_COUNT];
//        float rad = 0;
//float trackingObjectShift[enlargedOBJECT_MAX_COUNT];
//        float hot = 0;
//float liquidLampHot[enlargedOBJECT_MAX_COUNT];
//        float spf = 0;
//float liquidLampSpf[enlargedOBJECT_MAX_COUNT];
//        int mass = 0;
//uint8_t trackingObjectState[enlargedOBJECT_MAX_COUNT];
//        unsigned mx = 0;
//unsigned liquidLampMX[enlargedOBJECT_MAX_COUNT];
//        unsigned sc = 0;
//unsigned liquidLampSC[enlargedOBJECT_MAX_COUNT];
//        unsigned tr = 0;
//unsigned liquidLampTR[enlargedOBJECT_MAX_COUNT];

void LiquidLampPosition() {
  //bool physic_on = modes[currentMode].Speed & 0x01;
  for (uint8_t i = 0; i < enlargedObjectNUM; i++) {
    liquidLampHot[i] += mapcurve(trackingObjectPosY[i], 0, HEIGHT - 1, 5, -5, InOutQuad) * speedfactor;

    float heat = (liquidLampHot[i] / trackingObjectState[i]) - 1;
    if (heat > 0 && trackingObjectPosY[i] < HEIGHT - 1) {
      trackingObjectSpeedY[i] += heat * liquidLampSpf[i];
    }
    if (trackingObjectPosY[i] > 0) {
      trackingObjectSpeedY[i] -= 0.07;
    }

    if (trackingObjectSpeedY[i]) trackingObjectSpeedY[i] *= 0.85;
    trackingObjectPosY[i] += trackingObjectSpeedY[i] * speedfactor;

    //if (physic_on) {
    if (trackingObjectSpeedX[i]) trackingObjectSpeedX[i] *= 0.7;
    trackingObjectPosX[i] += trackingObjectSpeedX[i] * speedfactor;
    //}

    if (trackingObjectPosX[i] > WIDTH - 1) trackingObjectPosX[i] -= WIDTH - 1;
    if (trackingObjectPosX[i] < 0) trackingObjectPosX[i] += WIDTH - 1;
    if (trackingObjectPosY[i] > HEIGHT - 1) trackingObjectPosY[i] = HEIGHT - 1;
    if (trackingObjectPosY[i] < 0) trackingObjectPosY[i] = 0;
  };
}

void LiquidLampPhysic() {
  for (uint8_t i = 0; i < enlargedObjectNUM; i++) {
    //Particle *p1 = (Particle *)&particles[i];
    // отключаем физику на границах, чтобы не слипались шары
    if (trackingObjectPosY[i] < 3 || trackingObjectPosY[i] > HEIGHT - 1) continue;
    for (uint8_t j = 0; j < enlargedObjectNUM; j++) {
      //Particle *p2 = (Particle *)&particles[j];
      if (trackingObjectPosY[j] < 3 || trackingObjectPosY[j] > HEIGHT - 1) continue;
      float radius = 3;//(trackingObjectShift[i] + trackingObjectShift[j]);
      if (trackingObjectPosX[i] + radius > trackingObjectPosX[j]
          && trackingObjectPosX[i] < radius + trackingObjectPosX[j]
          && trackingObjectPosY[i] + radius > trackingObjectPosY[j]
          && trackingObjectPosY[i] < radius + trackingObjectPosY[j]
         ) {
        //float dist = EffectMath::distance(p1->position_x, p1->position_y, p2->position_x, p2->position_y);
        float dx =  min((float)fabs(trackingObjectPosX[i] - trackingObjectPosX[j]), (float)WIDTH + trackingObjectPosX[i] - trackingObjectPosX[j]); //по идее бесшовный икс
        float dy =  fabs(trackingObjectPosY[i] - trackingObjectPosY[j]);
        float dist = SQRT_VARIANT((dx * dx) + (dy * dy));

        if (dist <= radius) {
          float nx = (trackingObjectPosX[j] - trackingObjectPosX[i]) / dist;
          float ny = (trackingObjectPosY[j] - trackingObjectPosY[i]) / dist;
          float p = 2 * (trackingObjectSpeedX[i] * nx + trackingObjectSpeedY[i] * ny - trackingObjectSpeedX[j] * nx - trackingObjectSpeedY[j] * ny) / (trackingObjectState[i] + trackingObjectState[j]);
          float pnx = p * nx, pny = p * ny;
          trackingObjectSpeedX[i] = trackingObjectSpeedX[i] - pnx * trackingObjectState[i];
          trackingObjectSpeedY[i] = trackingObjectSpeedY[i] - pny * trackingObjectState[i];
          trackingObjectSpeedX[j] = trackingObjectSpeedX[j] + pnx * trackingObjectState[j];
          trackingObjectSpeedY[j] = trackingObjectSpeedY[j] + pny * trackingObjectState[j];
        }
      }
    }
  }
}


/*
  DEFINE_GRADIENT_PALETTE(MBVioletColors_gp){
    0,  255,  0,  0, // red
    1,  46,  123,  87, // seaBlue
    80,  0,  0,  139, // DarkBlue
    150,  128,  0,  128, // purple
    255,  255,  0,  0
  };
*/
// генератор палитр для Жидкой лампы (c) SottNick
static const uint8_t MBVioletColors_arr[5][4] PROGMEM = // та же палитра, но в формате CHSV
{
  {0  , 0  , 255, 255}, //  0, 255,   0,   0, // red
  //  {1  , 108, 161, 122}, //  1,  46, 123,  87, // seaBlue
  {1  , 155, 209, 255}, //  1,  46, 124, 255, // сделал поярче цвет воды
  {80 , 170, 255, 140}, // 80,   0,   0, 139, // DarkBlue
  {150, 213, 255, 128}, //150, 128,   0, 128, // purple
  {255, 0  , 255, 255}  //255, 255,   0,   0  // red again
};

CRGBPalette16 myPal;

void fillMyPal16(uint8_t hue, bool isInvert = false) {
  int8_t lastSlotUsed = -1;
  uint8_t istart8, iend8;
  CRGB rgbstart, rgbend;

  // начинаем с нуля
  if (isInvert)
    //с неявным преобразованием оттенков цвета получаются, как в фотошопе, но для данного эффекта не красиво выглядят
    //rgbstart = CHSV(256 + hue - pgm_read_byte(&MBVioletColors_arr[0][1]), pgm_read_byte(&MBVioletColors_arr[0][2]), pgm_read_byte(&MBVioletColors_arr[0][3])); // начальная строчка палитры с инверсией
    hsv2rgb_spectrum(CHSV(256 + hue - pgm_read_byte(&MBVioletColors_arr[0][1]), pgm_read_byte(&MBVioletColors_arr[0][2]), pgm_read_byte(&MBVioletColors_arr[0][3])), rgbstart);
  else
    //rgbstart = CHSV(hue + pgm_read_byte(&MBVioletColors_arr[0][1]), pgm_read_byte(&MBVioletColors_arr[0][2]), pgm_read_byte(&MBVioletColors_arr[0][3])); // начальная строчка палитры
    hsv2rgb_spectrum(CHSV(hue + pgm_read_byte(&MBVioletColors_arr[0][1]), pgm_read_byte(&MBVioletColors_arr[0][2]), pgm_read_byte(&MBVioletColors_arr[0][3])), rgbstart);
  int indexstart = 0; // начальный индекс палитры
  for (uint8_t i = 1U; i < 5U; i++) { // в палитре @obliterator всего 5 строчек
    int indexend = pgm_read_byte(&MBVioletColors_arr[i][0]);
    if (isInvert)
      //rgbend = CHSV(256 + hue - pgm_read_byte(&MBVioletColors_arr[i][1]), pgm_read_byte(&MBVioletColors_arr[i][2]), pgm_read_byte(&MBVioletColors_arr[i][3])); // следующая строчка палитры с инверсией
      hsv2rgb_spectrum(CHSV(256 + hue - pgm_read_byte(&MBVioletColors_arr[i][1]), pgm_read_byte(&MBVioletColors_arr[i][2]), pgm_read_byte(&MBVioletColors_arr[i][3])), rgbend);
    else
      //rgbend = CHSV(hue + pgm_read_byte(&MBVioletColors_arr[i][1]), pgm_read_byte(&MBVioletColors_arr[i][2]), pgm_read_byte(&MBVioletColors_arr[i][3])); // следующая строчка палитры
      hsv2rgb_spectrum(CHSV(hue + pgm_read_byte(&MBVioletColors_arr[i][1]), pgm_read_byte(&MBVioletColors_arr[i][2]), pgm_read_byte(&MBVioletColors_arr[i][3])), rgbend);
    istart8 = indexstart / 16;
    iend8   = indexend   / 16;
    if ((istart8 <= lastSlotUsed) && (lastSlotUsed < 15)) {
      istart8 = lastSlotUsed + 1;
      if (iend8 < istart8)
        iend8 = istart8;
    }
    lastSlotUsed = iend8;
    fill_gradient_RGB( myPal, istart8, rgbstart, iend8, rgbend);
    indexstart = indexend;
    rgbstart = rgbend;
  }
}

void LiquidLampRoutine(bool isColored) {
  if (loadingFlag)
  {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      //1-9,31-38,46-48,93-99
      //1-17,28-38,44-48,89-99
      uint8_t tmp = random8(28U);
      if (tmp > 9U) tmp += 21U;
      if (tmp > 38U) tmp += 7U;
      if (tmp > 48U) tmp += 44U;
      setModeSettings(isColored ? tmp : 27U + random8(54U), 30U + random8(170U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    speedfactor = modes[currentMode].Speed / 64.0 + 0.1; // 127 БЫЛО

    //setCurrentPalette();
    //FastLED.clear();
    if (isColored) {
      fillMyPal16((modes[currentMode].Scale - 1U) * 2.55, !(modes[currentMode].Scale & 0x01));
      enlargedObjectNUM = enlargedOBJECT_MAX_COUNT / 2U - 2U; //14U;
    }
    else {
      enlargedObjectNUM = (modes[currentMode].Scale - 1U) / 99.0 * (enlargedOBJECT_MAX_COUNT - 1U) + 1U;
      hue = random8();
      deltaHue = random8(2U);
      fillMyPal16(hue, deltaHue);

      //myPal = MBVioletColorsSimple1_gp; // лучшая палитра 1
      //fillMyPal16test((modes[currentMode].Scale - 1U) * 2.55, !(modes[currentMode].Scale & 0x01));
    }
    if (enlargedObjectNUM > enlargedOBJECT_MAX_COUNT) enlargedObjectNUM = enlargedOBJECT_MAX_COUNT;
    else if (enlargedObjectNUM < 2U) enlargedObjectNUM = 2U;

    double minSpeed = 0.2, maxSpeed = 0.8;

    for (uint8_t i = 0 ; i < enlargedObjectNUM ; i++) {
      trackingObjectPosX[i] = random8(WIDTH);
      trackingObjectPosY[i] = 0; //random8(HEIGHT);
      trackingObjectState[i] = random(MASS_MIN, MASS_MAX);
      liquidLampSpf[i] = fmap(trackingObjectState[i], MASS_MIN, MASS_MAX, 0.0015, 0.0005);
      trackingObjectShift[i] = fmap(trackingObjectState[i], MASS_MIN, MASS_MAX, 2, 3);
      liquidLampMX[i] = map(trackingObjectState[i], MASS_MIN, MASS_MAX, 60, 80); // сила возмущения
      liquidLampSC[i] = map(trackingObjectState[i], MASS_MIN, MASS_MAX, 6, 10); // радиус возмущения
      liquidLampTR[i] = liquidLampSC[i]  * 2 / 3; // отсечка расчетов (оптимизация скорости)
    }

  }

  LiquidLampPosition();
  //bool physic_on = modes[currentMode].Speed & 0x01;
  //if (physic_on)
  LiquidLampPhysic;

  if (!isColored) {
    hue2++;
    if (hue2 % 0x10 == 0U) {
      hue++;
      fillMyPal16(hue, deltaHue);
    }
  }

  for (uint8_t x = 0; x < WIDTH; x++) {
    for (uint8_t y = 0; y < HEIGHT; y++) {
      float sum = 0;
      //for (unsigned i = 0; i < numParticles; i++) {
      for (uint8_t i = 0; i < enlargedObjectNUM; i++) {
        //Particle *p1 = (Particle *)&particles[i];
        if (abs(x - trackingObjectPosX[i]) > liquidLampTR[i] || abs(y - trackingObjectPosY[i]) > liquidLampTR[i]) continue;
        //float d = EffectMath::distance(x, y, p1->position_x, p1->position_y);
        float dx =  min((float)fabs(trackingObjectPosX[i] - (float)x), (float)WIDTH + trackingObjectPosX[i] - (float)x); //по идее бесшовный икс
        float dy =  fabs(trackingObjectPosY[i] - (float)y);
        float d = SQRT_VARIANT((dx * dx) + (dy * dy));

        if (d < trackingObjectShift[i]) {
          sum += mapcurve(d, 0, trackingObjectShift[i], 255, liquidLampMX[i], InQuad);
        }
        else if (d < liquidLampSC[i]) {
          sum += mapcurve(d, trackingObjectShift[i], liquidLampSC[i], liquidLampMX[i], 0, OutQuart);
        }
        if (sum >= 255) {
          sum = 255;
          break;
        }
      }
      if (sum < 16) sum = 16;// отрезаем смазанный кусок палитры из-за отсутствия параметра NOBLEND
      CRGB color = ColorFromPalette(myPal, sum); // ,255, NOBLEND
      drawPixelXY(x, y, color);
    }
  }
}

// ----------- Эффект "Попкорн"
// (C) Aaron Gotwalt (Soulmate)
// https://editor.soulmatelights.com/gallery/117
// переосмысление (c) SottNick

//uint8_t NUM_ROCKETS = 10;
//enlargedObjectNUM = (modes[currentMode].Scale - 1U) % 11U / 10.0 * (AVAILABLE_BOID_COUNT - 1U) + 1U;

//    typedef struct
//    {
//        int32_t x, y, xd, yd;
//    } Rocket;
///////float trackingObjectPosX[trackingOBJECT_MAX_COUNT];
///////float trackingObjectPosY[trackingOBJECT_MAX_COUNT];
///////float trackingObjectSpeedX[trackingOBJECT_MAX_COUNT];
///////float trackingObjectSpeedY[trackingOBJECT_MAX_COUNT];

void popcornRestart_rocket(uint8_t r) {
  //deltaHue = !deltaHue; // "Мальчик" <> "Девочка"
  trackingObjectSpeedX[r] = (float)(random(-(WIDTH * HEIGHT + (WIDTH * 2)), WIDTH * HEIGHT + (WIDTH * 2))) / 256.0; // * (deltaHue ? 1 : -1); // Наклон. "Мальчики" налево, "девочки" направо. :)
  if ((trackingObjectPosX[r] < 0 && trackingObjectSpeedX[r] < 0) || (trackingObjectPosX[r] > (WIDTH - 1) && trackingObjectSpeedX[r] > 0)) { // меняем направление только после выхода за пределы экрана
    // leap towards the centre of the screen
    trackingObjectSpeedX[r] = -trackingObjectSpeedX[r];
  }
  // controls the leap height
  trackingObjectSpeedY[r] = (float)(random8() * 8 + HEIGHT * 10) / 256.0;
  trackingObjectHue[r] = random8();
  trackingObjectPosX[r] = random8(WIDTH);
}

void popcornRoutine() {
  if (loadingFlag) {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      setModeSettings(random8(9U) * 11U + 3U + random8(9U), 5U + random8(67U) * 2U + (random8(4U) ? 0U : 1U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    loadingFlag = false;
    speedfactor = fmap((float)modes[currentMode].Speed, 1., 255., 0.25, 1.0);
    //speedfactor = (float)modes[currentMode].Speed / 127.0f + 0.001f;

    setCurrentPalette();
    enlargedObjectNUM = (modes[currentMode].Scale - 1U) % 11U / 10.0 * (enlargedOBJECT_MAX_COUNT - 1U) + 1U;
    if (enlargedObjectNUM > enlargedOBJECT_MAX_COUNT) enlargedObjectNUM = enlargedOBJECT_MAX_COUNT;

    for (uint8_t r = 0; r < enlargedObjectNUM; r++) {
      trackingObjectPosX[r] = random8(WIDTH);
      trackingObjectPosY[r] = random8(HEIGHT);
      trackingObjectSpeedX[r] = 0;
      trackingObjectSpeedY[r] = -1;
      trackingObjectHue[r] = random8();
    }
  }
  float popcornGravity = 0.1 * speedfactor;
  //if (modes[currentMode].Speed & 0x01) // теперь чётностью скорости определяется белый/цветной попкорн, а чётностью яркости больше ничего
  fadeToBlackBy(leds, NUM_LEDS, 60);
  //else FastLED.clear();// fadeToBlackBy(leds, NUM_LEDS, 250);

  //void popcornMove(float popcornGravity) {
  for (uint8_t r = 0; r < enlargedObjectNUM; r++) {
    // add the X & Y velocities to the positions
    trackingObjectPosX[r] += trackingObjectSpeedX[r] ;
    if (trackingObjectPosX[r] > WIDTH - 1)
      trackingObjectPosX[r] = trackingObjectPosX[r] - (WIDTH - 1);
    if (trackingObjectPosX[r] < 0)
      trackingObjectPosX[r] = WIDTH - 1 + trackingObjectPosX[r];
    trackingObjectPosY[r] += trackingObjectSpeedY[r] * speedfactor;

    if (trackingObjectPosY[r] > HEIGHT - 1) {
      trackingObjectPosY[r] = HEIGHT + HEIGHT - 2 - trackingObjectPosY[r];
      trackingObjectSpeedY[r] = -trackingObjectSpeedY[r];
    }


    // bounce off the floor?
    if (trackingObjectPosY[r] < 0 && trackingObjectSpeedY[r] < -0.7) { // 0.7 вычислено в экселе. скорость свободного падения ниже этой не падает. если ниже, значит ещё есть ускорение
      trackingObjectSpeedY[r] = (-trackingObjectSpeedY[r]) * 0.9375;//* 240) >> 8;
      //trackingObjectPosY[r] = trackingObjectSpeedY[r]; чё это значило вообще?!
      trackingObjectPosY[r] = -trackingObjectPosY[r];
    }

    // settled on the floor?
    if (trackingObjectPosY[r] <= -1)
      popcornRestart_rocket(r);

    // bounce off the sides of the screen?
    /*if (rockets[r].x < 0 || rockets[r].x > (int)WIDTH * 256) {
      trackingObjectSpeedX[r] = (-trackingObjectSpeedX[r] * 248) >> 8;
      // force back onto the screen, otherwise they eventually sneak away
      if (rockets[r].x < 0) {
        rockets[r].x = trackingObjectSpeedX[r];
        trackingObjectSpeedY[r] += trackingObjectSpeedX[r];
      } else {
        rockets[r].x = (WIDTH * 256) - trackingObjectSpeedX[r];
      }
      }*/

    // popcornGravity
    trackingObjectSpeedY[r] -= popcornGravity;

    // viscosity
    trackingObjectSpeedX[r] *= 0.875;
    trackingObjectSpeedY[r] *= 0.875;


    //void popcornPaint() {
    // make the acme gray, because why not
    if (-0.004 > trackingObjectSpeedY[r] and trackingObjectSpeedY[r] < 0.004)
      drawPixelXYF(trackingObjectPosX[r], trackingObjectPosY[r], (modes[currentMode].Speed & 0x01) ?
                   ColorFromPalette(*curPalette, trackingObjectHue[r])
                   : CRGB::Pink);
    else
      drawPixelXYF(trackingObjectPosX[r], trackingObjectPosY[r], (modes[currentMode].Speed & 0x01) ?
                   CRGB::Gray
                   : ColorFromPalette(*curPalette, trackingObjectHue[r]));
  }
}

// ============= Эффект Реакция Белоусова-Жаботинского (Осциллятор) ===============
// по наводке https://www.wikiwand.com/ru/%D0%9A%D0%BB%D0%B5%D1%82%D0%BE%D1%87%D0%BD%D1%8B%D0%B9_%D0%B0%D0%B2%D1%82%D0%BE%D0%BC%D0%B0%D1%82
// (c) SottNick

void drawPixelXYFseamless(float x, float y, CRGB color)
{
  uint8_t xx = (x - (int)x) * 255, yy = (y - (int)y) * 255, ix = 255 - xx, iy = 255 - yy;
  // calculate the intensities for each affected pixel
#define WU_WEIGHT(a,b) ((uint8_t) (((a)*(b)+(a)+(b))>>8))
  uint8_t wu[4] = {WU_WEIGHT(ix, iy), WU_WEIGHT(xx, iy),
                   WU_WEIGHT(ix, yy), WU_WEIGHT(xx, yy)
                  };
  // multiply the intensities by the colour, and saturating-add them to the pixels
  for (uint8_t i = 0; i < 4; i++) {
    uint8_t xn = (int8_t)(x + (i & 1)) % WIDTH;
    uint8_t yn = (int8_t)(y + ((i >> 1) & 1)) % HEIGHT;
    CRGB clr = getPixColorXY(xn, yn);
    clr.r = qadd8(clr.r, (color.r * wu[i]) >> 8);
    clr.g = qadd8(clr.g, (color.g * wu[i]) >> 8);
    clr.b = qadd8(clr.b, (color.b * wu[i]) >> 8);
    drawPixelXY(xn, yn, clr);
  }
}
/*
  class oscillatingCell {
  public:
  byte red; // значения 0 или 1
  byte blue; // значения 0 или 1
  byte green; // значения 0 или 1
  byte color; // значения от 0 до 2
  };
  oscillatingCell oscillatingWorld[WIDTH][HEIGHT];

  будем использовать вместо них всех имеющийся в прошивке массив
  uint8_t noise3d[2][WIDTH][HEIGHT];
*/

uint8_t calcNeighbours(uint8_t x, uint8_t y, uint8_t n) {
  return (noise3d[0][(x + 1) % WIDTH][y] == n) +
         (noise3d[0][x][(y + 1) % HEIGHT] == n) +
         (noise3d[0][(x + WIDTH - 1) % WIDTH][y] == n) +
         (noise3d[0][x][(y + HEIGHT - 1) % HEIGHT] == n) +
         (noise3d[0][(x + 1) % WIDTH][(y + 1) % HEIGHT] == n) +
         (noise3d[0][(x + WIDTH - 1) % WIDTH][(y + 1) % HEIGHT] == n) +
         (noise3d[0][(x + WIDTH - 1) % WIDTH][(y + HEIGHT - 1) % HEIGHT] == n) +
         (noise3d[0][(x + 1) % WIDTH][(y + HEIGHT - 1) % HEIGHT] == n);
}

void oscillatingRoutine() {
  if (loadingFlag) {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      uint8_t tmp = random8(6U); // 4 палитры по 6? (0, 1, 6, 7) + цвет + смена цвета
      if (tmp < 4U) {
        if (tmp > 1U) tmp += 4U;
        tmp = tmp * 6U + 1U;
      }
      else if (tmp == 4U)
        tmp = 51U + random8(49U);
      else
        tmp = 100U;
      setModeSettings(tmp, 185U + random8(40U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    step = 0U;
    //setCurrentPalette();
    if (modes[currentMode].Scale > 100U) modes[currentMode].Scale = 100U; // чтобы не было проблем при прошивке без очистки памяти
    if (modes[currentMode].Scale <= 50U)
      curPalette = palette_arr[(uint8_t)(modes[currentMode].Scale / 50.0F * ((sizeof(palette_arr) / sizeof(TProgmemRGBPalette16 *)) - 0.01F))];
    //else
    //curPalette = firePalettes[(uint8_t)((modes[currentMode].Scale - 50)/50.0F * ((sizeof(firePalettes)/sizeof(TProgmemRGBPalette16 *))-0.01F))];


    //случайное заполнение
    for (uint8_t i = 0; i < WIDTH; i++) {
      for (uint8_t j = 0; j < HEIGHT; j++) {
        noise3d[1][i][j] = random8(3);
        noise3d[0][i][j] = noise3d[1][i][j];
      }
    }
  }

  hue++;
  CRGB currColors[3];
  if (modes[currentMode].Scale == 100U) {
    currColors[0U] = CHSV(hue, 255U, 255U);
    currColors[1U] = CHSV(hue, 128U, 255U);
    currColors[2U] = CHSV(hue, 255U, 128U);
  }
  else if (modes[currentMode].Scale > 50U) {
    //uint8_t temp = (modes[currentMode].Scale - 50U) * 1.275;
    currColors[0U] = CHSV((modes[currentMode].Scale - 50U) * 5.1, 255U, 255U);
    currColors[1U] = CHSV((modes[currentMode].Scale - 50U) * 5.1, 128U, 255U);
    currColors[2U] = CHSV((modes[currentMode].Scale - 50U) * 5.1, 255U, 128U);
  }
  else
    for (uint8_t c = 0; c < 3; c++)
      currColors[c] = ColorFromPalette(*curPalette, c * 85U + hue);
  FastLED.clear();

  // расчёт химической реакции и отрисовка мира
  uint16_t colorCount[3] = {0U, 0U, 0U};
  for (uint8_t x = 0; x < WIDTH; x++) {
    for (uint8_t y = 0; y < HEIGHT; y++) {
      if (noise3d[0][x][y] == 0U) {
        colorCount[0U]++;
        if (calcNeighbours(x, y, 1U) > 2U)
          noise3d[1][x][y] = 1U;
      }
      else if (noise3d[0][x][y] == 1U) {
        colorCount[1U]++;
        if (calcNeighbours(x, y, 2U) > 2U)
          noise3d[1][x][y] = 2U;
      }
      else {//if (noise3d[0][x][y] == 2U){
        colorCount[2U]++;
        if (calcNeighbours(x, y, 0U) > 2U)
          noise3d[1][x][y] = 0U;
      }
      drawPixelXYFseamless((float)x + 0.5, (float)y + 0.5, currColors[noise3d[1][x][y]]);
    }
  }

  // проверка зацикливания
  if (colorCount[0] == deltaHue && colorCount[1] == deltaHue2 && colorCount[2] == deltaValue) {
    step++;
    if (step > 10U) {
      if (colorCount[0] < colorCount[1])
        step = 0;
      else
        step = 1;
      if (colorCount[2] < colorCount[step])
        step = 2;
      colorCount[step] = 0U;
      step = 0U;
    }
  }
  else
    step = 0U;

  // вброс хаоса
  if (hue == hue2) { // чтобы не каждый ход
    hue2 += random8(220U) + 36U;
    uint8_t tx = random8(WIDTH);
    deltaHue = noise3d[1][tx][0U] + 1U;
    if (deltaHue > 2U) deltaHue = 0U;
    noise3d[1][tx][0U] = deltaHue;
    noise3d[1][(tx + 1U) % WIDTH][0U] = deltaHue;
    noise3d[1][(tx + 2U) % WIDTH][0U] = deltaHue;
  }

  deltaHue = colorCount[0];
  deltaHue2 = colorCount[1];
  deltaValue = colorCount[2];

  // вброс исчезнувшего цвета
  for (uint8_t c = 0; c < 3; c++)
  {
    if (colorCount[c] < 6U) {
      uint8_t tx = random8(WIDTH);
      uint8_t ty = random8(HEIGHT);
      if (random8(2U)) {
        noise3d[1][tx][ty] = c;
        noise3d[1][(tx + 1U) % WIDTH][ty] = c;
        noise3d[1][(tx + 2U) % WIDTH][ty] = c;
      }
      else {
        noise3d[1][tx][ty] = c;
        noise3d[1][tx][(ty + 1U) % HEIGHT] = c;
        noise3d[1][tx][(ty + 2U) % HEIGHT] = c;
      }
    }
  }

  // перенос на следующий цикл
  for (uint8_t x = 0; x < WIDTH; x++) {
    for (uint8_t y = 0; y < HEIGHT; y++) {
      noise3d[0][x][y] = noise3d[1][x][y];
    }
  }
}

// ============= Огонь 2020 ===============
// (c) SottNick
//сильно по мотивам https://pastebin.com/RG0QGzfK
//Perlin noise fire procedure by Yaroslaw Turbin
//https://www.reddit.com/r/FastLED/comments/hgu16i/my_fire_effect_implementation_based_on_perlin/

#define SPARKLES_NUM  (WIDTH / 8U) // не более чем  enlargedOBJECT_MAX_COUNT (WIDTH * 2)
//float   trackingObjectPosX[SPARKLES_NUM]; // это для искорок. по идее должны быть uint8_t, но были только такие
//float   trackingObjectPosY[SPARKLES_NUM];
//uint8_t shiftHue[HEIGHT];
//uint16_t ff_y, ff_z; используем для сдвига нойза переменные из общих
//uint8_t deltaValue;

void fire2020Routine2() {
  if (loadingFlag) {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      setModeSettings(1U + random8(100U), 195U + random8(40U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    if (modes[currentMode].Scale > 100U) modes[currentMode].Scale = 100U; // чтобы не было проблем при прошивке без очистки памяти
    /*if (modes[currentMode].Scale == 100U)
      deltaValue = random8(9U);
      else
      deltaValue = modes[currentMode].Scale * 0.0899; // /100.0F * ((sizeof(firePalettes)/sizeof(TProgmemRGBPalette16 *))-0.01F))*/
    deltaValue = modes[currentMode].Scale * 0.0899;// /100.0F * ((sizeof(palette_arr) /sizeof(TProgmemRGBPalette16 *))-0.01F));
    if (deltaValue == 3U || deltaValue == 4U)
      curPalette =  palette_arr[deltaValue]; // (uint8_t)(modes[currentMode].Scale/100.0F * ((sizeof(palette_arr) /sizeof(TProgmemRGBPalette16 *))-0.01F))];
    else
      curPalette = firePalettes[deltaValue]; // (uint8_t)(modes[currentMode].Scale/100.0F * ((sizeof(firePalettes)/sizeof(TProgmemRGBPalette16 *))-0.01F))];
    deltaValue = (((modes[currentMode].Scale - 1U) % 11U + 1U) << 4U) - 8U; // ширина языков пламени (масштаб шума Перлина)
    deltaHue = map(deltaValue, 8U, 168U, 8U, 84U); // высота языков пламени должна уменьшаться не так быстро, как ширина
    step = map(255U - deltaValue, 87U, 247U, 4U, 32U); // вероятность смещения искорки по оси ИКС
    for (uint8_t j = 0; j < HEIGHT; j++) {
      shiftHue[j] = (HEIGHT - 1 - j) * 255 / (HEIGHT - 1); // init colorfade table
    }

    for (uint8_t i = 0; i < SPARKLES_NUM; i++) {
      trackingObjectPosY[i] = random8(HEIGHT);
      trackingObjectPosX[i] = random8(WIDTH);
    }
  }
  for (uint8_t i = 0; i < WIDTH; i++) {
    for (uint8_t j = 0; j < HEIGHT; j++) {
      //if (modes[currentMode].Brightness & 0x01)
      //      leds[XY(i,HEIGHT-1U-j)] = ColorFromPalette(*curPalette, qsub8(inoise8(i * deltaValue, (j+ff_y+random8(2)) * deltaHue, ff_z), shiftHue[j]), 255U);
      //else // немного сгладим картинку
      nblend(leds[XY(i, HEIGHT - 1U - j)], ColorFromPalette(*curPalette, qsub8(inoise8(i * deltaValue, (j + ff_y + random8(2)) * deltaHue, ff_z), shiftHue[j]), 255U), 160U);
    }
  }

  //вставляем искорки из отдельного массива
  for (uint8_t i = 0; i < SPARKLES_NUM; i++) {
    //leds[XY(trackingObjectPosX[i],trackingObjectPosY[i])] += ColorFromPalette(*curPalette, random(156, 255));   //trackingObjectHue[i]
    if (trackingObjectPosY[i] > 3U) {
      leds[XY(trackingObjectPosX[i], trackingObjectPosY[i])] = leds[XY(trackingObjectPosX[i], 3U)];
      leds[XY(trackingObjectPosX[i], trackingObjectPosY[i])].fadeToBlackBy( trackingObjectPosY[i] * 2U );
    }
    trackingObjectPosY[i]++;
    if (trackingObjectPosY[i] >= HEIGHT) {
      trackingObjectPosY[i] = random8(4U);
      trackingObjectPosX[i] = random8(WIDTH);
    }
    if (!random8(step))
      trackingObjectPosX[i] = (WIDTH + (uint8_t)trackingObjectPosX[i] + 1U - random8(3U)) % WIDTH;
  }
  ff_y++;
  if (ff_y & 0x01)
    ff_z++;
}

// ============= Эффект Кипение ===============
// (c) SottNick
//по мотивам LDIRKO Ленд - эффект номер 10
//...ldir... Yaroslaw Turbin, 18.11.2020
//https://vk.com/ldirko
//https://www.reddit.com/user/ldirko/

void LLandRoutine() {
  if (loadingFlag) {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      uint8_t tmp = random8(6U);
      if (tmp > 1U) tmp += 3U;
      tmp = tmp * 11U + 4U + random8(8U);
      if (tmp > 97U) tmp = 94U;
      setModeSettings(tmp, 200U + random8(46U)); // масштаб 4-11, палитры 0, 1, 5, 6, 7, 8 (кроме 2, 3, 4)
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    setCurrentPalette();
    //speedfactor = fmap(modes[currentMode].Speed, 1., 255., 20., 1.) / 16.;
    deltaValue = 10U * ((modes[currentMode].Scale - 1U) % 11U + 1U);// значения от 1 до 11
    // значения от 0 до 10 = ((modes[currentMode].Scale - 1U) % 11U)

  }
  hue2 += 32U;
  if (hue2 < 32U)
    hue++;
  //float t = (float)millis() / speedfactor;
  ff_y += 16U;

  for (uint8_t y = 0; y < HEIGHT; y++)
    for (uint16_t x = 0; x < WIDTH; x++)
      //drawPixelXY(x, y, ColorFromPalette (*curPalette, map(inoise8(x * 50, y * 50 - t, 0) - y * 255 / (HEIGHT - 1), 0, 255, 205, 255) + hue, 255));
      drawPixelXY(x, y, ColorFromPalette (*curPalette, map(inoise8(x * deltaValue, y * deltaValue - ff_y, ff_z) - y * 255 / (HEIGHT - 1), 0, 255, 205, 255) + hue, 255));
  ff_z++;
}

// ============= ЭФФЕКТ ПРИТЯЖЕНИЕ ===============
// https://github.com/pixelmatix/aurora/blob/master/PatternAttract.h
// Адаптация (c) SottNick

// используются переменные эффекта Стая. Без него работать не будет.
//#define ASTEROIDS_NUM 5U // количество шариков не должно превышать AVAILABLE_BOID_COUNT = 20U;

void attractRoutine() {
  if (loadingFlag)
  {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      uint8_t tmp = random8(8U);
      if (tmp > 3U) tmp++;
      setModeSettings(tmp * 11U + 3U + random8(9U), 180U + random8(56U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    setCurrentPalette();

    enlargedObjectNUM = (modes[currentMode].Scale - 1U) % 11U + 1U;//(modes[currentMode].Scale - 1U) / 99.0 * (AVAILABLE_BOID_COUNT - 1U) + 1U;
    //if (enlargedObjectNUM > AVAILABLE_BOID_COUNT) enlargedObjectNUM = AVAILABLE_BOID_COUNT;


    for (uint8_t i = 0; i < enlargedObjectNUM; i++) {
      //boids[i] = Boid(random(HEIGHT), 0);
      boids[i] = Boid(random8(WIDTH), random8(HEIGHT));//WIDTH - 1, HEIGHT - i);
      //boids[i].location.x = random8(WIDTH);//CENTER_X_MINOR + (float)random8() / 50.;
      //boids[i].location.y = random8(HEIGHT);//CENTER_Y_MINOR + (float)random8() / 50.;
      boids[i].mass = ((float)random8(33U, 134U)) / 100.; // random(0.1, 2); // сюда можно поставить регулятор разлёта. чем меньше число, тем дальше от центра будет вылет
      //boids[i].velocity.x = ((float) random(40, 50)) / 100.0;
      //boids[i].velocity.x = ((float) random(modes[currentMode].Speed, modes[currentMode].Scale+10)) / 200.0;
      //boids[i].velocity.x = ((float) random8(modes[currentMode].Scale+45, modes[currentMode].Scale+100)) / 500.0;
      boids[i].velocity.x = ((float) random8(46U, 100U)) / 500.0;
      if (random8(2U)) boids[i].velocity.x = -boids[i].velocity.x;
      boids[i].velocity.y = 0;
      boids[i].colorIndex = random8();//i * 32;
      //boids[i].maxspeed = 0.380 * modes[currentMode].Speed /63.5+0.380;
      //boids[i].maxforce = 0.015 * modes[currentMode].Speed /63.5+0.015;
    }
  }
  dimAll(220);
  //FastLED.clear();

  PVector attractLocation = PVector(WIDTH * 0.5, HEIGHT * 0.5);
  //float attractMass = 10;
  //float attractG = .5;
  // перемножаем и получаем 5.

  for (uint8_t i = 0; i < enlargedObjectNUM; i++)
  {
    Boid boid = boids[i];
    //Boid * boid = &boids[i];
    PVector force = attractLocation - boid.location;   // Calculate direction of force // и вкорячиваем сюда регулировку скорости
    float d = force.mag();                              // Distance between objects
    d = constrain(d, 5.0f, HEIGHT * 2.);                      // Limiting the distance to eliminate "extreme" results for very close or very far objects
    force.normalize();                                  // Normalize vector (distance doesn't matter here, we just want this vector for direction)
    float strength = (5. * boid.mass) / (d * d);      // Calculate gravitional force magnitude 5.=attractG*attractMass
    force *= strength;                                  // Get force vector --> magnitude * direction

    boid.applyForce(force);

    boid.update();
    drawPixelXYF(boid.location.x, boid.location.y, ColorFromPalette(*curPalette, boid.colorIndex + hue));

    boids[i] = boid;
  }
  EVERY_N_MILLIS(200) {
    hue++;
  }

}

// ============= ЭФФЕКТ Капли на стекле ===============
// https://github.com/DmytroKorniienko/FireLamp_JeeUI/blob/master/src/effects.cpp
void newMatrixRoutine()
{
  if (loadingFlag)
  {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      setModeSettings(random8(30U) ? (random8(40U) ? 2U + random8(99U) : 1U) : 100U, 12U + random8(68U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    setCurrentPalette();

    //enlargedObjectNUM = (modes[currentMode].Scale - 1U) % 11U + 1U;//(modes[currentMode].Scale - 1U) / 99.0 * (AVAILABLE_BOID_COUNT - 1U) + 1U;
    enlargedObjectNUM = map(modes[currentMode].Speed, 1, 255, 1, trackingOBJECT_MAX_COUNT);
    //speedfactor = modes[currentMode].Speed / 1048.0f + 0.05f;
    speedfactor = 0.136f; // фиксируем хорошую скорость

    for (uint8_t i = 0U; i < enlargedObjectNUM; i++)
    {
      trackingObjectPosX[i] = random8(WIDTH);
      trackingObjectPosY[i] = random8(HEIGHT);
      trackingObjectSpeedY[i] = random8(150, 250) / 100.;
      trackingObjectState[i] = random8(127U, 255U);
      //trackingObjectHue[i] = hue; не похоже, что цвет используется
    }
    hue = modes[currentMode].Scale * 2.55;
  }
  //dimAll(map(modes[currentMode].Speed, 1, 255, 250, 240));
  dimAll(246); // для фиксированной скорости

  CHSV color;

  for (uint8_t i = 0U; i < enlargedObjectNUM; i++)
  {
    trackingObjectPosY[i] -= trackingObjectSpeedY[i] * speedfactor;

    if (modes[currentMode].Scale == 100U) {
      color = rgb2hsv_approximate(CRGB::Gray);
      color.val = trackingObjectState[i];
    } else if (modes[currentMode].Scale == 1U) {
      color = CHSV(++hue, 255, trackingObjectState[i]);
    } else {
      color = CHSV(hue, 255, trackingObjectState[i]);
    }


    drawPixelXYF(trackingObjectPosX[i], trackingObjectPosY[i], color);

#define GLUK 20 // вероятность горизонтального сдвига капли
    if (random8() < GLUK) {
      //trackingObjectPosX[i] = trackingObjectPosX[i] + random(-1, 2);
      trackingObjectPosX[i] = (uint8_t)(trackingObjectPosX[i] + WIDTH - 1U + random8(3U)) % WIDTH ;
      trackingObjectState[i] = random8(196, 255);
    }

    if (trackingObjectPosY[i] < -1) {
      trackingObjectPosX[i] = random8(WIDTH);
      trackingObjectPosY[i] = random8(HEIGHT - HEIGHT / 2, HEIGHT);
      trackingObjectSpeedY[i] = random8(150, 250) / 100.;
      trackingObjectState[i] = random8(127U, 255U);
      //trackingObjectHue[i] = hue; не похоже, что цвет используется
    }
  }
}

//-------- Эффект Дымовые шашки ----------- aka "Детские сны"
// (c) Stepko
// https://editor.soulmatelights.com/gallery/505
// https://github.com/DmytroKorniienko/FireLamp_JeeUI/blob/master/src/effects.cpp

void smokeballsRoutine() {
  if (loadingFlag)
  {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      setModeSettings(random8(9U) * 11U + 3U + random8(9U), 1U + random8(255U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    setCurrentPalette();

    enlargedObjectNUM = enlargedObjectNUM = (modes[currentMode].Scale - 1U) % 11U + 1U;
    speedfactor = fmap(modes[currentMode].Speed, 1., 255., .02, .1); // попробовал разные способы управления скоростью. Этот максимально приемлемый, хотя и сильно тупой.
    //randomSeed(millis());
    for (byte j = 0; j < enlargedObjectNUM; j++) {
      trackingObjectShift[j] =  random((WIDTH * 10) - ((WIDTH / 3) * 20)); // сумма trackingObjectState + trackingObjectShift не должна выскакивать за макс.Х
      //trackingObjectSpeedX[j] = EffectMath::randomf(5., (float)(16 * WIDTH)); //random(50, 16 * WIDTH) / random(1, 10);
      trackingObjectSpeedX[j] = (float)random(25, 80 * WIDTH) / 5.;
      trackingObjectState[j] = random((WIDTH / 2) * 10, (WIDTH / 3) * 20);
      trackingObjectHue[j] = random8();//(9) * 28;
      trackingObjectPosX[j] = trackingObjectShift[j];
    }
  }

  //shiftUp();
  for (byte x = 0; x < WIDTH; x++) {
    for (float y = (float)HEIGHT; y > 0.; y -= speedfactor) {
      drawPixelXY(x, y, getPixColorXY(x, y - 1));
    }
  }

  //dimAll(240); фиксированное число - очень плохо, когда матрицы разной высоты // fadeToBlackBy(leds, NUM_LEDS, 10);
  fadeToBlackBy(leds, NUM_LEDS, 128U / HEIGHT);
  if (modes[currentMode].Speed & 0x01)
    blurScreen(20);
  for (byte j = 0; j < enlargedObjectNUM; j++) {
    trackingObjectPosX[j] = beatsin16((uint8_t)(trackingObjectSpeedX[j] * (speedfactor * 5.)), trackingObjectShift[j], trackingObjectState[j] + trackingObjectShift[j], trackingObjectHue[j] * 256, trackingObjectHue[j] * 8);
    drawPixelXYF(trackingObjectPosX[j] / 10., 0.05, ColorFromPalette(*curPalette, trackingObjectHue[j]));
  }

  EVERY_N_SECONDS(20) {
    for (byte j = 0; j < enlargedObjectNUM; j++) {
      trackingObjectShift[j] += random(-20, 20);
      trackingObjectHue[j] += 28;
    }
  }

  loadingFlag = random8() > 253U;
}

// ------------- Nexus --------------
// (c) kostyamat
// https://github.com/DmytroKorniienko/FireLamp_JeeUI/blob/master/src/effects.cpp

//#define enlargedOBJECT_MAX_COUNT            (WIDTH * 2)          // максимальное количество червяков
//uint8_t enlargedObjectNUM;                                   // выбранное количество червяков
//float trackingObjectPosX[trackingOBJECT_MAX_COUNT]; // тут будет позиция головы
//float trackingObjectPosY[trackingOBJECT_MAX_COUNT]; // тут будет позиция головы
//float trackingObjectSpeedX[trackingOBJECT_MAX_COUNT]; // тут будет скорость червяка
//uint8_t trackingObjectHue[trackingOBJECT_MAX_COUNT]; // тут будет цвет червяка
//uint8_t trackingObjectState[trackingOBJECT_MAX_COUNT]; тут будет направление червяка

void nexusReset(uint8_t i) {
  trackingObjectHue[i] = random8();
  trackingObjectState[i] = random8(4);
  //trackingObjectSpeedX[i] = (255. + random8()) / 255.;
  trackingObjectSpeedX[i] = (float)random8(5, 11) / 70 + speedfactor; // делаем частицам немного разное ускорение и сразу пересчитываем под общую скорость
  switch (trackingObjectState[i]) {
    case B01:
      trackingObjectPosY[i] = HEIGHT;
      trackingObjectPosX[i] = random8(WIDTH);
      break;
    case B00:
      trackingObjectPosY[i] = -1;
      trackingObjectPosX[i] = random8(WIDTH);
      break;
    case B10:
      trackingObjectPosX[i] = WIDTH;
      trackingObjectPosY[i] = random8(HEIGHT);
      break;
    case B11:
      trackingObjectPosX[i] = -1;
      trackingObjectPosY[i] = random8(HEIGHT);
      break;
  }
}

void nexusRoutine() {
  if (loadingFlag)
  {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      setModeSettings(random8(2U) ? 11U + random8(15U) : 26U + random8(55U), 1U + random8(161U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    loadingFlag = false;
    speedfactor = fmap(modes[currentMode].Speed, 1, 255, 0.1, .33);//(float)modes[currentMode].Speed / 555.0f + 0.001f;

    enlargedObjectNUM = (modes[currentMode].Scale - 1U) / 99.0 * (enlargedOBJECT_MAX_COUNT - 1U) + 1U;
    if (enlargedObjectNUM > enlargedOBJECT_MAX_COUNT) enlargedObjectNUM = enlargedOBJECT_MAX_COUNT;
    for (uint8_t i = 0; i < enlargedObjectNUM; i++) {
      trackingObjectPosX[i] = random8(WIDTH);
      trackingObjectPosY[i] = random8(HEIGHT);
      trackingObjectSpeedX[i] = (float)random8(5, 11) / 70 + speedfactor; // делаем частицам немного разное ускорение и сразу пересчитываем под общую скорость
      trackingObjectHue[i] = random8();
      trackingObjectState[i] = random8(4);//     B00           // задаем направление
      // B10     B11
      //     B01
    }
    deltaValue = 255U - map(modes[currentMode].Speed, 1, 255, 11, 33);

  }
  dimAll(deltaValue);

  for (uint8_t i = 0; i < enlargedObjectNUM; i++) {
    switch (trackingObjectState[i]) {
      case B01:
        trackingObjectPosY[i] -= trackingObjectSpeedX[i];
        if (trackingObjectPosY[i] <= -1)
          nexusReset(i);
        break;
      case B00:
        trackingObjectPosY[i] += trackingObjectSpeedX[i];
        if (trackingObjectPosY[i] >= HEIGHT)
          nexusReset(i);
        break;
      case B10:
        trackingObjectPosX[i] -= trackingObjectSpeedX[i];
        if (trackingObjectPosX[i] <= -1)
          nexusReset(i);
        break;
      case B11:
        trackingObjectPosX[i] += trackingObjectSpeedX[i];
        if (trackingObjectPosX[i] >= WIDTH)
          nexusReset(i);
        break;
    }
    drawPixelXYF(trackingObjectPosX[i], trackingObjectPosY[i],  CHSV(trackingObjectHue[i], 255U, 255));
  }
}


// ------------ Эффект "Тихий Океан"
//  "Pacifica" перенос кода kostyamat
//  Gentle, blue-green ocean waves.
//  December 2019, Mark Kriegsman and Mary Corey March.
//  For Dan.
// https://raw.githubusercontent.com/FastLED/FastLED/master/examples/Pacifica/Pacifica.ino
// https://github.com/DmytroKorniienko/FireLamp_JeeUI/blob/master/src/effects.cpp

static const TProgmemRGBPalette16 pacifica_palette_1 FL_PROGMEM =
{ 0x000507, 0x000409, 0x00030B, 0x00030D, 0x000210, 0x000212, 0x000114, 0x000117,
  0x000019, 0x00001C, 0x000026, 0x000031, 0x00003B, 0x000046, 0x14554B, 0x28AA50
};
static const TProgmemRGBPalette16 pacifica_palette_2 FL_PROGMEM =
{ 0x000507, 0x000409, 0x00030B, 0x00030D, 0x000210, 0x000212, 0x000114, 0x000117,
  0x000019, 0x00001C, 0x000026, 0x000031, 0x00003B, 0x000046, 0x0C5F52, 0x19BE5F
};
static const TProgmemRGBPalette16 pacifica_palette_3 FL_PROGMEM =
{ 0x000208, 0x00030E, 0x000514, 0x00061A, 0x000820, 0x000927, 0x000B2D, 0x000C33,
  0x000E39, 0x001040, 0x001450, 0x001860, 0x001C70, 0x002080, 0x1040BF, 0x2060FF
};

// Add one layer of waves into the led array
void pacifica_one_layer(CRGB *leds, const TProgmemRGBPalette16& p, uint16_t cistart, uint16_t wavescale, uint8_t bri, uint16_t ioff)
{
  uint16_t ci = cistart;
  uint16_t waveangle = ioff;
  uint16_t wavescale_half = (wavescale / 2) + 20;
  for ( uint16_t i = 0; i < NUM_LEDS; i++) {
    waveangle += 250;
    uint16_t s16 = sin16( waveangle ) + 32768;
    uint16_t cs = scale16( s16 , wavescale_half ) + wavescale_half;
    ci += cs;
    uint16_t sindex16 = sin16( ci) + 32768;
    uint8_t sindex8 = scale16( sindex16, 240);
    CRGB c = ColorFromPalette( p, sindex8, bri, LINEARBLEND);
    leds[i] += c;
  }
}

// Add extra 'white' to areas where the four layers of light have lined up brightly
void pacifica_add_whitecaps(CRGB *leds)
{
  uint8_t basethreshold = beatsin8( 9, 55, 65);
  uint8_t wave = beat8( 7 );

  for ( uint16_t i = 0; i < NUM_LEDS; i++) {
    uint8_t threshold = scale8( sin8( wave), 20) + basethreshold;
    wave += 7;
    uint8_t l = leds[i].getAverageLight();
    if ( l > threshold) {
      uint8_t overage = l - threshold;
      uint8_t overage2 = qadd8( overage, overage);
      leds[i] += CRGB( overage, overage2, qadd8( overage2, overage2));
    }
  }
}

// Deepen the blues and greens
void pacifica_deepen_colors(CRGB *leds)
{
  for ( uint16_t i = 0; i < NUM_LEDS; i++) {
    leds[i].blue = scale8( leds[i].blue,  145);
    leds[i].green = scale8( leds[i].green, 200);
    leds[i] |= CRGB( 2, 5, 7);
  }
}

void pacificRoutine()
{
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
  if (selectedSettings) {
    setModeSettings(100U, 1U + random8(255U));
  }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

  // Increment the four "color index start" counters, one for each wave layer.
  // Each is incremented at a different speed, and the speeds vary over time.
  static uint16_t sCIStart1, sCIStart2, sCIStart3, sCIStart4;
  static uint32_t sLastms = 0;
  uint32_t ms = GET_MILLIS();
  uint32_t deltams = ms - sLastms;
  sLastms = ms;
  uint16_t speedfactor1 = beatsin16(3, 179, 269);
  uint16_t speedfactor2 = beatsin16(4, 179, 269);
  uint32_t deltams1 = (deltams * speedfactor1) / map(modes[currentMode].Speed, 1, 255, 620, 60);
  uint32_t deltams2 = (deltams * speedfactor2) / map(modes[currentMode].Speed, 1, 255, 620, 60);
  uint32_t deltams21 = (deltams1 + deltams2) / 2;
  sCIStart1 += (deltams1 * beatsin88(1011, 10, 13));
  sCIStart2 -= (deltams21 * beatsin88(777, 8, 11));
  sCIStart3 -= (deltams1 * beatsin88(501, 5, 7));
  sCIStart4 -= (deltams2 * beatsin88(257, 4, 6));

  // Clear out the LED array to a dim background blue-green
  fill_solid( leds, NUM_LEDS, CRGB( 2, 6, 10));

  // Render each of four layers, with different scales and speeds, that vary over time
  pacifica_one_layer(&*leds, pacifica_palette_1, sCIStart1, beatsin16( 3, 11 * 256, 14 * 256), beatsin8( 10, 70, 130), 0 - beat16( 301) );
  pacifica_one_layer(&*leds, pacifica_palette_2, sCIStart2, beatsin16( 4,  6 * 256,  9 * 256), beatsin8( 17, 40,  80), beat16( 401) );
  pacifica_one_layer(&*leds, pacifica_palette_3, sCIStart3, 6 * 256, beatsin8( 9, 10, 38), 0 - beat16(503));
  pacifica_one_layer(&*leds, pacifica_palette_3, sCIStart4, 5 * 256, beatsin8( 8, 10, 28), beat16(601));

  // Add brighter 'whitecaps' where the waves lines up more
  pacifica_add_whitecaps(&*leds);

  // Deepen the blues and greens a bit
  pacifica_deepen_colors(&*leds);
  blurScreen(20);
}

//-------- по мотивам Эффектов Particle System -------------------------
// https://github.com/fuse314/arduino-particle-sys
// https://github.com/giladaya/arduino-particle-sys
// https://www.youtube.com/watch?v=S6novCRlHV8&t=51s
//#include <ParticleSys.h>
//при попытке вытащить из этой библиотеки только минимально необходимое выяснилось, что там очередной (третий) вариант реализации субпиксельной графики.
//ну его нафиг. лучше будет повторить визуал имеющимися в прошивке средствами.

void particlesUpdate2(uint8_t i) {
  //age
  trackingObjectState[i]--; //ttl // ещё и сюда надо speedfactor вкорячить. удачи там!

  //apply acceleration
  //trackingObjectSpeedX[i] = min((int)trackingObjectSpeedX[i]+ax, WIDTH);
  //trackingObjectSpeedY[i] = min((int)trackingObjectSpeedY[i]+ay, HEIGHT);

  //apply velocity
  trackingObjectPosX[i] += trackingObjectSpeedX[i];
  trackingObjectPosY[i] += trackingObjectSpeedY[i];
  if (trackingObjectState[i] == 0 || trackingObjectPosX[i] <= -1 || trackingObjectPosX[i] >= WIDTH || trackingObjectPosY[i] <= -1 || trackingObjectPosY[i] >= HEIGHT)
    trackingObjectIsShift[i] = false;
}

// ============= ЭФФЕКТ ИСТОЧНИК ===============
// (c) SottNick
// выглядит как https://github.com/fuse314/arduino-particle-sys/blob/master/examples/StarfieldFastLED/StarfieldFastLED.ino

void starfield2Emit(uint8_t i) {
  if (hue++ & 0x01)
    hue2++;//counter++;
  //source->update(g); хз зачем это было в оригинале - там только смерть source.isAlive высчитывается, вроде

  trackingObjectPosX[i] = WIDTH * 0.5;//CENTER_X_MINOR;// * RENDERER_RESOLUTION; //  particle->x = source->x;
  trackingObjectPosY[i] = HEIGHT * 0.5;//CENTER_Y_MINOR;// * RENDERER_RESOLUTION; //  // particle->y = source->y;

  //trackingObjectSpeedX[i] = ((float)random8()-127.)/512./0.25*speedfactor; // random(_hVar)-_constVel; // particle->vx
  trackingObjectSpeedX[i] = ((float)random8() - 127.) / 512.; // random(_hVar)-_constVel; // particle->vx
  //trackingObjectSpeedY[i] = SQRT_VARIANT((speedfactor*speedfactor+0.0001)-trackingObjectSpeedX[i]*trackingObjectSpeedX[i]); // SQRT_VARIANT(pow(_constVel,2)-pow(trackingObjectSpeedX[i],2)); // particle->vy зависит от particle->vx - не ошибка
  trackingObjectSpeedY[i] = SQRT_VARIANT(0.0626 - trackingObjectSpeedX[i] * trackingObjectSpeedX[i]); // SQRT_VARIANT(pow(_constVel,2)-pow(trackingObjectSpeedX[i],2)); // particle->vy зависит от particle->vx - не ошибка
  if (random8(2U)) {
    trackingObjectSpeedY[i] = -trackingObjectSpeedY[i];
  }
  trackingObjectState[i] = random8(50, 250); // random8(minLife, maxLife);// particle->ttl
  if (modes[currentMode].Speed & 0x01)
    trackingObjectHue[i] = hue2;// (counter/2)%255; // particle->hue
  else
    trackingObjectHue[i] = random8();
  trackingObjectIsShift[i] = true; // particle->isAlive
}

void starfield2Routine() {
  if (loadingFlag)
  {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      setModeSettings(25U + random8(76U), 185U + random8(30U) * 2U + (random8(6U) ? 0U : 1U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    //speedfactor = (float)modes[currentMode].Speed / 510.0f + 0.001f;
    enlargedObjectNUM = (modes[currentMode].Scale - 1U) / 99.0 * (trackingOBJECT_MAX_COUNT - 1U) + 1U;
    if (enlargedObjectNUM > trackingOBJECT_MAX_COUNT) enlargedObjectNUM = trackingOBJECT_MAX_COUNT;
    //deltaValue = 1; // количество зарождающихся частиц за 1 цикл //perCycle = 1;
    deltaValue = enlargedObjectNUM / (SQRT_VARIANT(CENTER_X_MAJOR * CENTER_X_MAJOR + CENTER_Y_MAJOR * CENTER_Y_MAJOR) * 4U) + 1U; // 4 - это потому что за 1 цикл частица пролетает ровно четверть расстояния между 2мя соседними пикселями
    for (int i = 0; i < enlargedObjectNUM; i++)
      trackingObjectIsShift[i] = false; // particle->isAlive
  }
  step = deltaValue; //счётчик количества частиц в очереди на зарождение в этом цикле
  //renderer.fade(leds); = fadeToBlackBy(128); = dimAll(255-128)
  //dimAll(255-128/.25*speedfactor); ахах-ха. очередной эффект, к которому нужно будет "подобрать коэффициенты"
  dimAll(127);

  //go over particles and update matrix cells on the way
  for (int i = 0; i < enlargedObjectNUM; i++) {
    if (!trackingObjectIsShift[i] && step) {
      //emitter->emit(&particles[i], this->g);
      starfield2Emit(i);
      step--;
    }
    if (trackingObjectIsShift[i]) { // particle->isAlive
      //particles[i].update(this->g);
      particlesUpdate2(i);

      //generate RGB values for particle
      CRGB baseRGB = CHSV(trackingObjectHue[i], 255, 255); // particles[i].hue

      //baseRGB.fadeToBlackBy(255-trackingObjectState[i]);
      baseRGB.nscale8(trackingObjectState[i]);//эквивалент
      drawPixelXYF(trackingObjectPosX[i], trackingObjectPosY[i], baseRGB);
    }
  }
}

// ============= ЭФФЕКТ ФЕЯ ===============
// (c) SottNick
#define FAIRY_BEHAVIOR //типа сложное поведение

void fairyEmit(uint8_t i) //particlesEmit(Particle_Abstract *particle, ParticleSysConfig *g)
{
  if (deltaHue++ & 0x01)
    if (hue++ & 0x01)
      hue2++;//counter++;
  trackingObjectPosX[i] = boids[0].location.x;
  trackingObjectPosY[i] = boids[0].location.y;

  //хотите навставлять speedfactor? - тут не забудьте
  //trackingObjectSpeedX[i] = ((float)random8()-127.)/512./0.25*speedfactor; // random(_hVar)-_constVel; // particle->vx
  trackingObjectSpeedX[i] = ((float)random8() - 127.) / 512.; // random(_hVar)-_constVel; // particle->vx
  //trackingObjectSpeedY[i] = SQRT_VARIANT((speedfactor*speedfactor+0.0001)-trackingObjectSpeedX[i]*trackingObjectSpeedX[i]); // SQRT_VARIANT(pow(_constVel,2)-pow(trackingObjectSpeedX[i],2)); // particle->vy зависит от particle->vx - не ошибка
  trackingObjectSpeedY[i] = SQRT_VARIANT(0.0626 - trackingObjectSpeedX[i] * trackingObjectSpeedX[i]); // SQRT_VARIANT(pow(_constVel,2)-pow(trackingObjectSpeedX[i],2)); // particle->vy зависит от particle->vx - не ошибка
  if (random8(2U)) {
    trackingObjectSpeedY[i] = -trackingObjectSpeedY[i];
  }

  trackingObjectState[i] = random8(20, 80); // random8(minLife, maxLife);// particle->ttl
  trackingObjectHue[i] = hue2;// (counter/2)%255; // particle->hue
  trackingObjectIsShift[i] = true; // particle->isAlive
}

void fairyRoutine() {
  if (loadingFlag)
  {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      setModeSettings(14U + random8(87U), 190U + random8(40U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    //speedfactor = (float)modes[currentMode].Speed / 510.0f + 0.001f;

    deltaValue = 10; // количество зарождающихся частиц за 1 цикл //perCycle = 1;
    enlargedObjectNUM = (modes[currentMode].Scale - 1U) / 99.0 * (trackingOBJECT_MAX_COUNT - 1U) + 1U;
    if (enlargedObjectNUM > trackingOBJECT_MAX_COUNT) enlargedObjectNUM = trackingOBJECT_MAX_COUNT;
    for (int i = 0; i < enlargedObjectNUM; i++)
      trackingObjectIsShift[i] = false; // particle->isAlive

    // лень было придумывать алгоритм для траектории феи, поэтому это будет нулевой "бойд" из эффекта Притяжение
    boids[0] = Boid(random8(WIDTH), random8(HEIGHT));//WIDTH - 1, HEIGHT - 1);
    //boids[0].location.x = random8(WIDTH);
    //boids[0].location.y = random8(HEIGHT);
    boids[0].mass = 0.5;//((float)random8(33U, 134U)) / 100.; // random(0.1, 2); // сюда можно поставить регулятор разлёта. чем меньше число, тем дальше от центра будет вылет
    boids[0].velocity.x = ((float) random8(46U, 100U)) / 500.0;
    if (random8(2U)) boids[0].velocity.x = -boids[0].velocity.x;
    boids[0].velocity.y = 0;
    hue = random8();//boids[0].colorIndex =
#ifdef FAIRY_BEHAVIOR
    deltaHue2 = 1U;
#endif;
  }
  step = deltaValue; //счётчик количества частиц в очереди на зарождение в этом цикле

#ifdef FAIRY_BEHAVIOR
  if (!deltaHue && deltaHue2 && fabs(boids[0].velocity.x) + fabs(boids[0].velocity.y) < 0.15) {
    deltaHue2 = 0U;

    boids[1].velocity.x = ((float)random8() + 255.) / 4080.;
    boids[1].velocity.y = ((float)random8() + 255.) / 2040.;
    if (boids[0].location.x > WIDTH * 0.5) boids[1].velocity.x = -boids[1].velocity.x;
    if (boids[0].location.y > HEIGHT * 0.5) boids[1].velocity.y = -boids[1].velocity.y;
  }
  if (!deltaHue2) {
    step = 1U;

    boids[0].location.x += boids[1].velocity.x;
    boids[0].location.y += boids[1].velocity.y;
    deltaHue2 = (boids[0].location.x <= 0 || boids[0].location.x >= WIDTH - 1 || boids[0].location.y <= 0 || boids[0].location.y >= HEIGHT - 1);
  }
  else
#endif // FAIRY_BEHAVIOR
  {
    PVector attractLocation = PVector(WIDTH * 0.5, HEIGHT * 0.5);
    //float attractMass = 10;
    //float attractG = .5;
    // перемножаем и получаем 5.
    Boid boid = boids[0];
    PVector force = attractLocation - boid.location;      // Calculate direction of force
    float d = force.mag();                                // Distance between objects
    d = constrain(d, 5.0f, HEIGHT);//видео снято на 5.0f  // Limiting the distance to eliminate "extreme" results for very close or very far objects
    //d = constrain(d, modes[currentMode].Scale / 10.0, HEIGHT);

    force.normalize();                                    // Normalize vector (distance doesn't matter here, we just want this vector for direction)
    float strength = (5. * boid.mass) / (d * d);          // Calculate gravitional force magnitude 5.=attractG*attractMass
    //float attractMass = (modes[currentMode].Scale) / 10.0 * .5;
    //strength = (attractMass * boid.mass) / (d * d);
    force *= strength;                                    // Get force vector --> magnitude * direction
    boid.applyForce(force);
    boid.update();

    if (boid.location.x <= -1) boid.location.x = -boid.location.x;
    else if (boid.location.x >= WIDTH) boid.location.x = -boid.location.x + WIDTH + WIDTH;
    if (boid.location.y <= -1) boid.location.y = -boid.location.y;
    else if (boid.location.y >= HEIGHT) boid.location.y = -boid.location.y + HEIGHT + HEIGHT;
    boids[0] = boid;

    //EVERY_N_SECONDS(20)
    if (!deltaHue) {
      if (random8(3U)) {
        d = ((random8(2U)) ? boids[0].velocity.x : boids[0].velocity.y) * ((random8(2U)) ? .2 : -.2);
        boids[0].velocity.x += d;
        boids[0].velocity.y -= d;
      }
      else {
        if (fabs(boids[0].velocity.x) < 0.02)
          boids[0].velocity.x = -boids[0].velocity.x;
        else if (fabs(boids[0].velocity.y) < 0.02)
          boids[0].velocity.y = -boids[0].velocity.y;
      }
    }
  }


  //renderer.fade(leds); = fadeToBlackBy(128); = dimAll(255-128)
  //dimAll(255-128/.25*speedfactor); очередной эффект, к которому нужно будет "подобрать коэффициенты"
  //if (modes[currentMode].Speed & 0x01)
  dimAll(127);
  //else FastLED.clear();

  //go over particles and update matrix cells on the way
  for (int i = 0; i < enlargedObjectNUM; i++) {
    if (!trackingObjectIsShift[i] && step) {
      //emitter->emit(&particles[i], this->g);
      fairyEmit(i);
      step--;
    }
    if (trackingObjectIsShift[i]) { // particle->isAlive
      //particles[i].update(this->g);
      if (modes[currentMode].Scale & 0x01 && trackingObjectSpeedY[i] > -1) trackingObjectSpeedY[i] -= 0.05; //apply acceleration
      particlesUpdate2(i);

      //generate RGB values for particle
      CRGB baseRGB = CHSV(trackingObjectHue[i], 255, 255); // particles[i].hue

      //baseRGB.fadeToBlackBy(255-trackingObjectState[i]);
      baseRGB.nscale8(trackingObjectState[i]);//эквивалент
      drawPixelXYF(trackingObjectPosX[i], trackingObjectPosY[i], baseRGB);
    }
  }
  drawPixelXYF(boids[0].location.x, boids[0].location.y, CHSV(hue, 160U, 255U));//boid.colorIndex + hue


}

// ============= ЭФФЕКТ ЗВЁЗДНЫЕ ВОЙНЫ ===============
// (c) SottNick
/* эффект стрёмный. доделывать не стал
  void starwarsEmit(uint8_t i) //particlesEmit(Particle_Abstract *particle, ParticleSysConfig *g)
  {
    if (deltaHue++ & 0x01)
      if (hue++ & 0x01)
        hue2++;//counter++;
    trackingObjectPosX[i] = boids[1].location.x;
    trackingObjectPosY[i] = boids[1].location.y;

    float dx = boids[0].location.x - boids[1].location.x;
    float dy = boids[0].location.y - boids[1].location.y;
    float dxy = dx*dx+dy*dy;
    if (dxy != 0){
      dxy = SQRT_VARIANT(dxy) / 0.25; // 0.25 пикселя - расстояние, пролетаемое снарядом за 1 цикл
      trackingObjectSpeedX[i] = dx / dxy;
      trackingObjectSpeedY[i] = dy / dxy;
      trackingObjectState[i] = 60;//random8(20, 60); // random8(minLife, maxLife);// particle->ttl
      trackingObjectHue[i] = hue2;// (counter/2)%255; // particle->hue
      trackingObjectIsShift[i] = true; // particle->isAlive

      if (!trackingObjectIsShift[0U] && pcnt){
        trackingObjectPosX[0] = boids[0].location.x;
        trackingObjectPosY[0] = boids[0].location.y;
        trackingObjectSpeedX[0U] = (-4) * trackingObjectSpeedX[i];
        trackingObjectSpeedY[0U] = (-4) * trackingObjectSpeedY[i];
        trackingObjectState[0U] = 255;
        trackingObjectHue[0U] = hue;
        trackingObjectIsShift[0U] = true;
        pcnt--;
      }
    }
  }

  void starwarsRoutine(){
  if (loadingFlag)
  {
    loadingFlag = false;
    //speedfactor = (float)modes[currentMode].Speed / 510.0f + 0.001f;
    deltaValue = 1; // количество зарождающихся частиц за 1 цикл //perCycle = 1;
    enlargedObjectNUM = (modes[currentMode].Scale - 1U) / 99.0 * (trackingOBJECT_MAX_COUNT - 1U) + 1U;
    if (enlargedObjectNUM > trackingOBJECT_MAX_COUNT) enlargedObjectNUM = trackingOBJECT_MAX_COUNT;
    for(int i = 0; i<enlargedObjectNUM; i++)
      trackingObjectIsShift[i] = false; // particle->isAlive

    boids[0].colorIndex = random8();
    boids[1].colorIndex = boids[0].colorIndex + 127U;

    trackingObjectShift[4] = WIDTH / 8;
    trackingObjectShift[5] = HEIGHT / 8;
    trackingObjectShift[0] = 255./(WIDTH-1.-trackingObjectShift[4]-trackingObjectShift[4]);
    trackingObjectShift[1] = 255./(HEIGHT-1.-trackingObjectShift[5]-trackingObjectShift[5]);
    trackingObjectShift[6] = WIDTH / 4;
    trackingObjectShift[7] = HEIGHT / 4;
    trackingObjectShift[2] = 255./(WIDTH-1.-trackingObjectShift[6]-trackingObjectShift[6]);// ((WIDTH>10)?9.:5.));
    trackingObjectShift[3] = 255./(HEIGHT-1.-trackingObjectShift[7]-trackingObjectShift[7]);//- ((HEIGHT>10)?9.:5.));

  }

  //boids[0].location.x = 2 + sin8( millis() / 10) / 22.;
  //boids[0].location.y = 2 + cos8( millis() / 10) / 22.;
  boids[0].location.x = trackingObjectShift[4] + sin8( millis() / 10) / trackingObjectShift[0];// / 22;
  boids[0].location.y = trackingObjectShift[5] + cos8( millis() / 10) / trackingObjectShift[1];// / 22;
  //boids[1].location.x = 4 + sin8( millis() / 46) / 32.;
  //boids[1].location.y = 4 + cos8( millis() / 15) / 32.;
  boids[1].location.x = trackingObjectShift[6] + sin8( millis() / 46) / trackingObjectShift[2];// / 32;
  boids[1].location.y = trackingObjectShift[7] + cos8( millis() / 15) / trackingObjectShift[3];// / 32;

  //step = deltaValue; //счётчик количества частиц в очереди на зарождение в этом цикле
  step = random(2U);

  pcnt = 1U;
  if (modes[currentMode].Speed & 0x01)
  dimAll(127);
  else FastLED.clear();

  //go over particles and update matrix cells on the way
  for(int i = 0; i<enlargedObjectNUM; i++) {
    if (i>0U && !trackingObjectIsShift[i] && step) {
      //emitter->emit(&particles[i], this->g);
      starwarsEmit(i);
      step--;
    }
    if (trackingObjectIsShift[i]){ // particle->isAlive
      //particles[i].update(this->g);
      particlesUpdate2(i);

      //generate RGB values for particle
      CRGB baseRGB = CHSV(trackingObjectHue[i], 255,255); // particles[i].hue

      //baseRGB.fadeToBlackBy(255-trackingObjectState[i]);
      baseRGB.nscale8(trackingObjectState[i]);//эквивалент
      drawPixelXYF(trackingObjectPosX[i], trackingObjectPosY[i], baseRGB);
    }
  }
  drawPixelXYF(boids[0].location.x, boids[0].location.y, CHSV(boids[0].colorIndex, 160U, 255U));
  drawPixelXYF(boids[1].location.x, boids[1].location.y, CHSV(boids[1].colorIndex, 160U, 255U));
  }
*/

// ============= ЭФФЕКТ ИСТОЧНИКИ ===============
// (c) SottNick
/* тоже такое себе зрелище
  void fountainsDrift(uint8_t j){
  //float shift = random8()
  boids[j].location.x += boids[j].velocity.x;
  boids[j].location.y += boids[j].velocity.y;
  if (boids[j].location.x + boids[j].velocity.x < 0){
    //boids[j].location.x = WIDTH - 1 + boids[j].location.x;
    boids[j].location.x = -boids[j].location.x;
    boids[j].velocity.x = -boids[j].velocity.x;
  }
  if (boids[j].location.x > WIDTH - 1){
    //boids[j].location.x = boids[j].location.x + 1 - WIDTH;
    boids[j].location.x = WIDTH + WIDTH - 2 - boids[j].location.x;
    boids[j].velocity.x = -boids[j].velocity.x;
  }
  if (boids[j].location.y < 0){
    //boids[j].location.y = HEIGHT - 1 + boids[j].location.y;
    boids[j].location.y = -boids[j].location.y;
    boids[j].velocity.y = -boids[j].velocity.y;
  }
  if (boids[j].location.y > HEIGHT - 1){
    //boids[j].location.y = boids[j].location.y + 1 - HEIGHT;
    boids[j].location.y = HEIGHT + HEIGHT - 2 - boids[j].location.y;
    boids[j].velocity.y = -boids[j].velocity.y;
  }
  }

  void fountainsEmit(uint8_t i){
  if (hue++ & 0x01)
    hue2++;//counter++;

  uint8_t j = random8(enlargedObjectNUM);
  fountainsDrift(j);
  trackingObjectPosX[i] = boids[j].location.x;
  trackingObjectPosY[i] = boids[j].location.y;

  trackingObjectSpeedX[i] = ((float)random8()-127.)/512.; // random(_hVar)-_constVel; // particle->vx
  trackingObjectSpeedY[i] = SQRT_VARIANT(0.0626-trackingObjectSpeedX[i]*trackingObjectSpeedX[i]); // SQRT_VARIANT(pow(_constVel,2)-pow(trackingObjectSpeedX[i],2)); // particle->vy зависит от particle->vx - не ошибка
  if(random8(2U)) { trackingObjectSpeedY[i]=-trackingObjectSpeedY[i]; }
  trackingObjectState[i] = random8(50, 250); // random8(minLife, maxLife);// particle->ttl
  if (modes[currentMode].Speed & 0x01)
    trackingObjectHue[i] = hue2;// (counter/2)%255; // particle->hue
  else
    trackingObjectHue[i] = boids[j].colorIndex;//random8();
  trackingObjectIsShift[i] = true; // particle->isAlive
  }

  void fountainsRoutine(){
  if (loadingFlag)
  {
    loadingFlag = false;
    enlargedObjectNUM = (modes[currentMode].Scale - 1U) / 99.0 * (AVAILABLE_BOID_COUNT - 1U) + 1U;
    if (enlargedObjectNUM > AVAILABLE_BOID_COUNT) enlargedObjectNUM = AVAILABLE_BOID_COUNT;

    //deltaValue = 10; // количество зарождающихся частиц за 1 цикл
    deltaValue = trackingOBJECT_MAX_COUNT / (SQRT_VARIANT(CENTER_X_MAJOR*CENTER_X_MAJOR + CENTER_Y_MAJOR*CENTER_Y_MAJOR) * 4U) + 1U; // 4 - это потому что за 1 цикл частица пролетает ровно четверть расстояния между 2мя соседними пикселями

    for(int i = 0; i<trackingOBJECT_MAX_COUNT; i++)
      trackingObjectIsShift[i] = false;

    for(int j = 0; j<enlargedObjectNUM; j++){
      boids[j] = Boid(random8(WIDTH), random8(HEIGHT));
      //boids[j].location.x = random8(WIDTH);
      //boids[j].location.y = random8(HEIGHT);
      boids[j].velocity.x = ((float)random8()-127.)/512.;
      boids[j].velocity.y = SQRT_VARIANT(0.0626-boids[j].velocity.x*boids[j].velocity.x) /  8.; // скорость источников в восемь раз ниже, чем скорость частиц
      boids[j].velocity.x                                                        /= 8.; // скорость источников в восемь раз ниже, чем скорость частиц
      if(random8(2U))
        boids[j].velocity.y = -boids[j].velocity.y;
      boids[j].colorIndex = random8();
    }
  }
  step = deltaValue; //счётчик количества частиц в очереди на зарождение в этом цикле
  dimAll(127);

  //go over particles and update matrix cells on the way
  for(int i = 0; i<trackingOBJECT_MAX_COUNT; i++) {
    if (!trackingObjectIsShift[i] && step) {
      //emitter->emit(&particles[i], this->g);
      fountainsEmit(i);
      step--;
    }
    if (trackingObjectIsShift[i]){ // particle->isAlive
      //particles[i].update(this->g);
      particlesUpdate2(i);

      //generate RGB values for particle
      CRGB baseRGB = CHSV(trackingObjectHue[i], 255,255); // particles[i].hue

      //baseRGB.fadeToBlackBy(255-trackingObjectState[i]);
      baseRGB.nscale8(trackingObjectState[i]);//эквивалент
      drawPixelXYF(trackingObjectPosX[i], trackingObjectPosY[i], baseRGB);
    }
  }
  }
*/

// ============= Эффект Цветные драже ===============
// (c) SottNick
//по мотивам визуала эффекта by Yaroslaw Turbin 14.12.2020
//https://vk.com/ldirko программный код которого он запретил брать

void sandRoutine() {
  if (loadingFlag) {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      setModeSettings(1U + random8(100U) , 140U + random8(100U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    //setCurrentPalette();
    pcnt = 0U;// = HEIGHT;
  }

  // если насыпалось уже достаточно, бахаем рандомные песчинки
  uint8_t temp = map8(random8(), modes[currentMode].Scale * 2.55, 255U);
  if (pcnt >= map8(temp, 2U, HEIGHT - 3U)) {
    //temp = 255U - temp + 2;
    //if (temp < 2) temp = 255;
    temp = HEIGHT + 1U - pcnt;
    if (!random8(4U)) // иногда песка осыпается до половины разом
      if (random8(2U))
        temp = 2U;
      else
        temp = 3U;
    //for (uint16_t i = 0U; i < NUM_LEDS; i++)
    for (uint8_t y = 0; y < pcnt; y++)
      for (uint8_t x = 0; x < WIDTH; x++)
        if (!random8(temp))
          leds[XY(x, y)] = 0;
  }

  pcnt = 0U;
  // осыпаем всё, что есть на экране
  for (uint8_t y = 1; y < HEIGHT; y++)
    for (uint8_t x = 0; x < WIDTH; x++)
      if (leds[XY(x, y)])                                                          // проверяем для каждой песчинки
        if (!leds[XY(x, y - 1)]) {                                                 // если под нами пусто, просто падаем
          leds[XY(x, y - 1)] = leds[XY(x, y)];
          leds[XY(x, y)] = 0;
        }
        else if (x > 0U && !leds[XY(x - 1, y - 1)] && x < WIDTH - 1 && !leds[XY(x + 1, y - 1)]) { // если под нами пик
          if (random8(2U))
            leds[XY(x - 1, y - 1)] = leds[XY(x, y)];
          else
            leds[XY(x - 1, y - 1)] = leds[XY(x, y)];
          leds[XY(x, y)] = 0;
          pcnt = y - 1;
        }
        else if (x > 0U && !leds[XY(x - 1, y - 1)]) {                              // если под нами склон налево
          leds[XY(x - 1, y - 1)] = leds[XY(x, y)];
          leds[XY(x, y)] = 0;
          pcnt = y - 1;
        }
        else if (x < WIDTH - 1 && !leds[XY(x + 1, y - 1)]) {                       // если под нами склон направо
          leds[XY(x + 1, y - 1)] = leds[XY(x, y)];
          leds[XY(x, y)] = 0;
          pcnt = y - 1;
        }
        else                                                                       // если под нами плато
          pcnt = y;

  // эмиттер новых песчинок
  if (!leds[XY(CENTER_X_MINOR, HEIGHT - 2)] && !leds[XY(CENTER_X_MAJOR, HEIGHT - 2)] && !random8(3)) {
    temp = random8(2) ? CENTER_X_MINOR : CENTER_X_MAJOR;
    leds[XY(temp, HEIGHT - 1)] = CHSV(random8(), 255U, 255U);
  }
}

// ============= Эффект Плазменная лампа ===============
// эффект Паук (c) stepko
// плюс выбор палитры (c) SottNick

void spiderRoutine() {
  if (loadingFlag) {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      uint8_t tmp = random8(5U);
      if (tmp > 1U) tmp += 3U;
      setModeSettings(tmp * 11U + 3U + random8(7U), 1U + random8(180U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    setCurrentPalette();
    pcnt = (modes[currentMode].Scale - 1U) % 11U + 1U; // количество линий от 1 до 11 для каждой из 9 палитр
    speedfactor = fmap(modes[currentMode].Speed, 1, 255, 20., 2.);
  }
  if (hue2++ & 0x01 && deltaHue++ & 0x01 && deltaHue2++ & 0x01) hue++; // хз. как с 60ю кадрами в секунду скорость замедлять...
  dimAll(205);
  for (uint8_t c = 0; c < pcnt; c++) {
    float xx = 2. + sin8((float)millis() / speedfactor + 6000 * c) / 12.;
    float yy = 2. + cos8((float)millis() / speedfactor + 9000 * c) / 12.;
    //DrawLineF(xx, yy, (float)WIDTH - xx - 1, (float)HEIGHT - yy - 1, CHSV(c * (256 / pcnt), 200, 255)); // так было в оригинале
    //if (modes[currentMode].Speed & 0x01)
    //DrawLineF(xx, yy, (float)WIDTH - xx - 1, (float)HEIGHT - yy - 1, ColorFromPalette(*curPalette, hue + c * (255 / pcnt)).nscale8(200)); // кажется, это не работает, хотя и компилируется
    //else
    DrawLineF(xx, yy, (float)WIDTH - xx - 1, (float)HEIGHT - yy - 1, ColorFromPalette(*curPalette, hue + c * (255 / pcnt)));
  }
}

// --------- Эффект "Северное Сияние"
// (c) kostyamat 05.02.2021
// идеи подсмотрены тут https://www.reddit.com/r/FastLED/comments/jyly1e/challenge_fastled_sketch_that_fits_entirely_in_a/
// особая благодарность https://www.reddit.com/user/ldirko/ Yaroslaw Turbin aka ldirko

// вместо набора палитр в оригинальном эффекте сделан генератор палитр
#define AURORA_COLOR_RANGE 10 // (+/-10 единиц оттенка) диапазон, в котором плавает цвет сияния относительно выбранного оттенка 
#define AURORA_COLOR_PERIOD 2 // (2 раза в минуту) частота, с которой происходит колебание выбранного оттенка в разрешённом диапазоне

// генератор палитр для Северного сияния (c) SottNick
static const uint8_t MBAuroraColors_arr[5][4] PROGMEM = // палитра в формате CHSV
{ //№, цвет, насыщенность, яркость
  {0  , 0 , 255,   0},// black
  {80 , 0 , 255, 255},
  {130, 25, 220, 255},
  {180, 25, 185, 255},
  {255, 25, 155, 255} //245
};
/*
  {
  {0  , 0 , 255,   0},// black
  {60 , 1 , 255, 222},
  {80 , 1 , 210, 255},
  {180, 11, 175, 255},
  {255, 11 ,135, 255} //245
  };
*/
//CRGBPalette16 myPal; уже есть эта переменная в эффекте Жидкая лампа

void fillMyPal16_2(uint8_t hue, bool isInvert = false) {
  // я бы, конечно, вместо копии функции генерации палитры "_2"
  // лучше бы сделал её параметром указатель на массив с базовой палитрой,
  // но я пониятия не имею, как это делается с грёбаным PROGMEM

  int8_t lastSlotUsed = -1;
  uint8_t istart8, iend8;
  CRGB rgbstart, rgbend;

  // начинаем с нуля
  if (isInvert)
    //с неявным преобразованием оттенков цвета получаются, как в фотошопе, но для данного эффекта не красиво выглядят
    //rgbstart = CHSV(256 + hue - pgm_read_byte(&MBAuroraColors_arr[0][1]), pgm_read_byte(&MBAuroraColors_arr[0][2]), pgm_read_byte(&MBAuroraColors_arr[0][3])); // начальная строчка палитры с инверсией
    hsv2rgb_spectrum(CHSV(256 + hue - pgm_read_byte(&MBAuroraColors_arr[0][1]), pgm_read_byte(&MBAuroraColors_arr[0][2]), pgm_read_byte(&MBAuroraColors_arr[0][3])), rgbstart);
  else
    //rgbstart = CHSV(hue + pgm_read_byte(&MBAuroraColors_arr[0][1]), pgm_read_byte(&MBAuroraColors_arr[0][2]), pgm_read_byte(&MBAuroraColors_arr[0][3])); // начальная строчка палитры
    hsv2rgb_spectrum(CHSV(hue + pgm_read_byte(&MBAuroraColors_arr[0][1]), pgm_read_byte(&MBAuroraColors_arr[0][2]), pgm_read_byte(&MBAuroraColors_arr[0][3])), rgbstart);
  int indexstart = 0; // начальный индекс палитры
  for (uint8_t i = 1U; i < 5U; i++) { // в палитре @obliterator всего 5 строчек
    int indexend = pgm_read_byte(&MBAuroraColors_arr[i][0]);
    if (isInvert)
      hsv2rgb_spectrum(CHSV(hue + pgm_read_byte(&MBAuroraColors_arr[i][1]), pgm_read_byte(&MBAuroraColors_arr[i][2]), pgm_read_byte(&MBAuroraColors_arr[i][3])), rgbend);
    else
      hsv2rgb_spectrum(CHSV(256 + hue - pgm_read_byte(&MBAuroraColors_arr[i][1]), pgm_read_byte(&MBAuroraColors_arr[i][2]), pgm_read_byte(&MBAuroraColors_arr[i][3])), rgbend);
    istart8 = indexstart / 16;
    iend8   = indexend   / 16;
    if ((istart8 <= lastSlotUsed) && (lastSlotUsed < 15)) {
      istart8 = lastSlotUsed + 1;
      if (iend8 < istart8)
        iend8 = istart8;
    }
    lastSlotUsed = iend8;
    fill_gradient_RGB( myPal, istart8, rgbstart, iend8, rgbend);
    indexstart = indexend;
    rgbstart = rgbend;
  }
}

unsigned long polarTimer;
//float adjastHeight; // используем emitterX
//uint16_t adjScale; // используем ff_y

void polarRoutine() {
  if (loadingFlag) {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      setModeSettings(random8(3U) ? 1U + random8(99U) : 100U, 1U + random8(170U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    //setCurrentPalette();
    //fillMyPal16_2((modes[currentMode].Scale - 1U) * 2.55);//, !(modes[currentMode].Scale & 0x01)); фиксированная палитра - для слабаков

    //emitterX = fmap((float)HEIGHT, 8, 32, 28, 12); такое работало с горем пополам только для матриц до 32 пикселей в высоту
    //emitterX = 512. / HEIGHT - 0.0001; // это максимально возможное значение
    emitterX = 400. / HEIGHT; // а это - максимум без яркой засветки крайних рядов матрицы (сверху и снизу)

    ff_y = map(WIDTH, 8, 64, 310, 63);
    //ff_z = map(modes[currentMode].Scale, 1, 100, 30, ff_y);
    ff_z = ff_y;
    speedfactor = map(modes[currentMode].Speed, 1, 255, 128, 16); // _speed = map(speed, 1, 255, 128, 16);

  }

  if (modes[currentMode].Scale == 100) {
    if (hue2++ & 0x01 && deltaHue++ & 0x01 && deltaHue2++ & 0x01) hue++; // это ж бред, но я хз. как с 60ю кадрами в секунду можно эффективно скорость замедлять...
    fillMyPal16_2((uint8_t)((modes[currentMode].Scale - 1U) * 2.55) + hue, modes[currentMode].Scale & 0x01);
  }
  else
    fillMyPal16_2((uint8_t)((modes[currentMode].Scale - 1U) * 2.55) + AURORA_COLOR_RANGE - beatsin8(AURORA_COLOR_PERIOD, 0U, AURORA_COLOR_RANGE + AURORA_COLOR_RANGE), modes[currentMode].Scale & 0x01);


  for (byte x = 0; x < WIDTH; x++) {
    for (byte y = 0; y < HEIGHT; y++) {
      polarTimer++;
      //uint16_t i = x*y;
      leds[XY(x, y)] =
        ColorFromPalette(myPal,
                         qsub8(
                           inoise8(polarTimer % 2 + x * ff_z,
                                   y * 16 + polarTimer % 16,
                                   polarTimer / speedfactor
                                  ),
                           fabs((float)HEIGHT / 2 - (float)y) * emitterX
                         )
                        );
      /*
            if (flag == 1) { // Тут я модифицирую стандартные палитры
              CRGB tmpColor = leds[myLamp.getPixelNumber(x, y)];
              leds[myLamp.getPixelNumber(x, y)].g = tmpColor.r;
              leds[myLamp.getPixelNumber(x, y)].r = tmpColor.g;
              leds[myLamp.getPixelNumber(x, y)].g /= 6;
              leds[myLamp.getPixelNumber(x, y)].r += leds[myLamp.getPixelNumber(x, y)].r < 206 ? 48 : 0;;
            } else if (flag == 3) {
              leds[myLamp.getPixelNumber(x, y)].b += 48;
              leds[myLamp.getPixelNumber(x, y)].g += leds[myLamp.getPixelNumber(x, y)].g < 206 ? 48 : 0;
            }
      */
    }
  }
}


// ----------- Эффект "Шары"
// (c) stepko and kostyamat https://wokwi.com/arduino/projects/289839434049782281
// 07.02.2021

float randomf(float min, float max)
{
  return fmap((float)random16(4095), 0.0, 4095.0, min, max);
}

void ballsfill_circle(float cx, float cy, float radius, CRGB col) {
  radius -= 0.5;
  for (int y = -radius; y <= radius; y++) {
    for (int x = -radius; x <= radius; x++) {
      if (x * x + y * y <= radius * radius)
        drawPixelXYF(cx + x, cy + y, col);
    }
  }
}

void spheresRoutine() {

  if (loadingFlag)
  {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      setModeSettings(random8(8U) * 11U + 6U + random8(6U), 1U + random8(255U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    setCurrentPalette();
    speedfactor = fmap(modes[currentMode].Speed, 1, 255, 0.15, 0.5);

    enlargedObjectNUM = (modes[currentMode].Scale - 1U) % 11U + 1U;
    //if (enlargedObjectNUM > AVAILABLE_BOID_COUNT) enlargedObjectNUM = AVAILABLE_BOID_COUNT;
    emitterY = .5 + HEIGHT / 4. / (2. - 1. / enlargedObjectNUM); // radiusMax

    for (uint8_t i = 0; i < enlargedObjectNUM; i++) {
      trackingObjectShift[i] = randomf(0.5, emitterY); // radius[i] = randomf(0.5, radiusMax);
      trackingObjectSpeedX[i] = randomf(0.5, 1.1) * speedfactor; // ball[i][2] =
      trackingObjectSpeedY[i] = randomf(0.5, 1.1) * speedfactor; // ball[i][3] =
      trackingObjectPosX[i] = random8(WIDTH);  // ball[i][0] = random(0, WIDTH);
      trackingObjectPosY[i] = random8(HEIGHT); // ball[i][1] = random(0, HEIGHT);
      trackingObjectHue[i] = random8();        // color[i] = random(0, 255);
    }
  }

  dimAll(255 - map(modes[currentMode].Speed, 1, 255, 5, 20)); //fadeToBlackBy(leds, NUM_LEDS, map(speed, 1, 255, 5, 20));


  for (byte i = 0; i < enlargedObjectNUM; i++) {
    if (trackingObjectIsShift[i]) {  // тут у нас шарики надуваются\сдуваются по ходу движения
      trackingObjectShift[i] += (fabs(trackingObjectSpeedX[i]) > fabs(trackingObjectSpeedY[i]) ? fabs(trackingObjectSpeedX[i]) : fabs(trackingObjectSpeedY[i])) * 0.1 * speedfactor;
      if (trackingObjectShift[i] >= emitterY) {
        trackingObjectIsShift[i] = false;
      }
    } else {
      trackingObjectShift[i] -= (fabs(trackingObjectSpeedX[i]) > fabs(trackingObjectSpeedY[i]) ? fabs(trackingObjectSpeedX[i]) : fabs(trackingObjectSpeedY[i])) * 0.1 * speedfactor;
      if (trackingObjectShift[i] < 1.) {
        trackingObjectIsShift[i] = true;
        trackingObjectHue[i] = random(0, 255);
      }
    }


    //EffectMath::drawCircleF(trackingObjectPosY[i], trackingObjectPosX[i], trackingObjectShift[i], ColorFromPalette(*curPalette, trackingObjectHue[i]), 0.5);
    if (trackingObjectShift[i] > 1)
      ballsfill_circle(trackingObjectPosY[i], trackingObjectPosX[i], trackingObjectShift[i], ColorFromPalette(*curPalette, trackingObjectHue[i]));
    else
      drawPixelXYF(trackingObjectPosY[i], trackingObjectPosX[i], ColorFromPalette(*curPalette, trackingObjectHue[i]));


    if (trackingObjectPosX[i] + trackingObjectShift[i] >= HEIGHT - 1)
      trackingObjectPosX[i] += (trackingObjectSpeedX[i] * ((HEIGHT - 1 - trackingObjectPosX[i]) / trackingObjectShift[i] + 0.005));
    else if (trackingObjectPosX[i] - trackingObjectShift[i] <= 0)
      trackingObjectPosX[i] += (trackingObjectSpeedX[i] * (trackingObjectPosX[i] / trackingObjectShift[i] + 0.005));
    else
      trackingObjectPosX[i] += trackingObjectSpeedX[i];
    //-----------------------
    if (trackingObjectPosY[i] + trackingObjectShift[i] >= WIDTH - 1)
      trackingObjectPosY[i] += (trackingObjectSpeedY[i] * ((WIDTH - 1 - trackingObjectPosY[i]) / trackingObjectShift[i] + 0.005));
    else if (trackingObjectPosY[i] - trackingObjectShift[i] <= 0)
      trackingObjectPosY[i] += (trackingObjectSpeedY[i] * (trackingObjectPosY[i] / trackingObjectShift[i] + 0.005));
    else
      trackingObjectPosY[i] += trackingObjectSpeedY[i];
    //------------------------
    if (trackingObjectPosX[i] < 0.01) {
      trackingObjectSpeedX[i] = randomf(0.5, 1.1) * speedfactor;
      trackingObjectPosX[i] = 0.01;
    }
    else if (trackingObjectPosX[i] > HEIGHT - 1.01) {
      trackingObjectSpeedX[i] = randomf(0.5, 1.1) * speedfactor;
      trackingObjectSpeedX[i] = -trackingObjectSpeedX[i];
      trackingObjectPosX[i] = HEIGHT - 1.01;
    }
    //----------------------
    if (trackingObjectPosY[i] < 0.01) {
      trackingObjectSpeedY[i] = randomf(0.5, 1.1) * speedfactor;
      trackingObjectPosY[i] = 0.01;
    }
    else if (trackingObjectPosY[i] > WIDTH - 1.01) {
      trackingObjectSpeedY[i] = randomf(0.5, 1.1) * speedfactor;
      trackingObjectSpeedY[i] = -trackingObjectSpeedY[i];
      trackingObjectPosY[i] = WIDTH - 1.01;
    }
  }
  blurScreen(48);
}


// ============= Эффект Магма ===============
// (c) SottNick
// берём эффекты Огонь 2020 и Прыгуны:
// хуяк-хуяк - и в продакшен!

void magmaRoutine() {
  //unsigned num = map(scale, 0U, 255U, 6U, sizeof(boids) / sizeof(*boids));
  if (loadingFlag)
  {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      //палитры 0,1,5,6,7
      uint8_t tmp = random8(6U);
      if (tmp > 1U) tmp += 3U;
      setModeSettings(tmp * 11U + 2U + random8(7U) , 185U + random8(48U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    //setCurrentPalette();
    deltaValue = modes[currentMode].Scale * 0.0899;// /100.0F * ((sizeof(palette_arr) /sizeof(TProgmemRGBPalette16 *))-0.01F));
    if (deltaValue == 3U || deltaValue == 4U)
      curPalette =  palette_arr[deltaValue]; // (uint8_t)(modes[currentMode].Scale/100.0F * ((sizeof(palette_arr) /sizeof(TProgmemRGBPalette16 *))-0.01F))];
    else
      curPalette = firePalettes[deltaValue]; // (uint8_t)(modes[currentMode].Scale/100.0F * ((sizeof(firePalettes)/sizeof(TProgmemRGBPalette16 *))-0.01F))];
    //deltaValue = (((modes[currentMode].Scale - 1U) % 11U + 1U) << 4U) - 8U; // ширина языков пламени (масштаб шума Перлина)
    deltaValue = 12U;
    deltaHue = 10U;// map(deltaValue, 8U, 168U, 8U, 84U); // высота языков пламени должна уменьшаться не так быстро, как ширина
    //step = map(255U-deltaValue, 87U, 247U, 4U, 32U); // вероятность смещения искорки по оси ИКС
    for (uint8_t j = 0; j < HEIGHT; j++) {
      shiftHue[j] = (HEIGHT - 1 - j) * 255 / (HEIGHT - 1); // init colorfade table
    }

    //FastLED.clear();
    //enlargedObjectNUM = (modes[currentMode].Scale - 1U) / 99.0 * (enlargedOBJECT_MAX_COUNT - 1U) + 1U;
    enlargedObjectNUM = (modes[currentMode].Scale - 1U) % 11U / 10.0 * (enlargedOBJECT_MAX_COUNT - 1U) + 1U;
    if (enlargedObjectNUM > enlargedOBJECT_MAX_COUNT) enlargedObjectNUM = enlargedOBJECT_MAX_COUNT;
    //if (enlargedObjectNUM < 2U) enlargedObjectNUM = 2U;

    for (uint8_t i = 0 ; i < enlargedObjectNUM ; i++) {
      trackingObjectPosX[i] = random8(WIDTH);
      trackingObjectPosY[i] = random8(HEIGHT);

      //curr->color = CHSV(random(1U, 255U), 255U, 255U);
      trackingObjectHue[i] = 50U; random8();
    }
  }

  //myLamp.dimAll(0); накой хрен делать затухание на 100%?
  //FastLED.clear();
  //dimAll(255U - modes[currentMode].Scale * 2);
  //dimAll(255U - 44U * 2);
  dimAll(181);

  for (uint8_t i = 0; i < WIDTH; i++) {
    for (uint8_t j = 0; j < HEIGHT; j++) {
      //leds[XY(i,HEIGHT-1U-j)] = ColorFromPalette(*curPalette, qsub8(inoise8(i * deltaValue, (j+ff_y+random8(2)) * deltaHue, ff_z), shiftHue[j]), 255U);
      drawPixelXYF(i, HEIGHT - 1U - j, ColorFromPalette(*curPalette, qsub8(inoise8(i * deltaValue, (j + ff_y + random8(2)) * deltaHue, ff_z), shiftHue[j]), 255U));
    }
  }

  for (uint8_t i = 0; i < enlargedObjectNUM; i++) {
    LeapersMove_leaper(i);
    //drawPixelXYF(trackingObjectPosX[i], trackingObjectPosY[i], CHSV(trackingObjectHue[i], 255U, 255U));
    if (trackingObjectPosY[i] >= HEIGHT / 4U)
      drawPixelXYF(trackingObjectPosX[i], trackingObjectPosY[i], ColorFromPalette(*curPalette, trackingObjectHue[i]));
  };

  //blurScreen(20);
  ff_y++;
  if (ff_y & 0x01)
    ff_z++;
}

/*
// ============= Эффект Свеча ===============  Перенесен в файл new_effect.ino  =====================
// https://github.com/mnemocron/FeatherCandle
// адаптация (с) SottNick

#include "data7x15flip.h"           // FeatherCandle animation data
const uint8_t *ptr  = anim;  // Current pointer into animation data
const uint8_t  w    = 7;     // image width
const uint8_t  h    = 15;    // image height
uint8_t        img[w*h];     // Buffer for rendering image

void FeatherCandleRoutine(){

#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      // scale | speed
      setModeSettings(1U + random8(100U), 190U + random8(65U));
    }
#endif
    loadingFlag = false;

    FastLED.clear();
    uint8_t a = pgm_read_byte(ptr++);     // New frame X1/Y1
    if(a >= 0x90) {               // EOD marker? (valid X1 never exceeds 8)
      ptr = anim;                 // Reset animation data pointer to start
      a   = pgm_read_byte(ptr++); // and take first value
    }
    uint8_t x1 = a >> 4;                  // X1 = high 4 bits
    uint8_t y1 = a & 0x0F;                // Y1 = low 4 bits
    a  = pgm_read_byte(ptr++);    // New frame X2/Y2
    uint8_t x2 = a >> 4;                  // X2 = high 4 bits
    uint8_t y2 = a & 0x0F;                // Y2 = low 4 bits

    // Read rectangle of data from anim[] into portion of img[] buffer
    for(uint8_t y=y1; y<=y2; y++)
      for(uint8_t x=x1; x<=x2; x++) { 
        img[y*w + x] = pgm_read_byte(ptr++);
    }
    int i = 0;
    for (uint8_t x=0; x<h; x++) {
      for (uint8_t y=0; y<w; y++) {
        leds[XY(y+5, x)] = CHSV((modes[currentMode].Scale - 1U) * 2.57, 255U, img[i++]);
      }
    }  
}


// =============== Wine ================  Перенесен в файл new_effect.ino  =====================
// ===== плавная смена цвета вина ======
// © SlingMaster | by Alex Dovby
void colorsWine() {
  if (loadingFlag) {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      // scale | speed
      setModeSettings(40U + random8(35U), 225U + random8(20U));
    }
#endif
    loadingFlag = false;
    // minspeed 230 maxspeed 250 ============
    // minscale  40 maxscale  75 ============
    // цвет вроде как не к чему =============
    // красное вино hue > 245U & <= 255 & <=20
    // розовое вино hue > 245U & <= 255 & <=20
    // белое вино   hue > 20U & <= 40
    // шампанское   hue > 40U & <= 60

    deltaValue = 255U - modes[currentMode].Speed + 1U;
    deltaHue2 = 0U;
    step = deltaValue;                      // чтообы при старте эффекта сразу покрасить лампу
    deltaHue = 1U;                          // direction | 0 hue-- | 1 hue++ |
    hue = 55U;                              // Start Color
    hue2 = 65U;                             // Brightness
    pcnt = 0;
  }

  if (step >= deltaValue) {
    step = 0U;
    if (deltaHue == 1U) {
      hue++;
      // возвращаем яркость для перехода к розовому
      if (hue < 20 || hue > 245) {
        hue2++;
      }
    } else {
      hue--;
      // уменьшаем яркость для красного вина
      if (hue < 20 || hue > 245) {
        hue2--;
      }
    }

    // сдвигаем всё вверх -----------
    for (uint8_t x = 0U; x < WIDTH; x++) {
      for (uint8_t y = HEIGHT; y > 0U; y--) {
        drawPixelXY(x, y, getPixColorXY(x, y - 1U));
      }
    }
    if ((hue > 40U) && (hue <= 60U)) {
      // добавляем перляж для шампанского
      pcnt = random(0, WIDTH);
    } else {
      pcnt = 0;
    }

    // заполняем нижнюю строку с учетом перляжа
    deltaHue2 = 0U;
    for (uint8_t x = 0U; x < WIDTH; x++) {
      if ((x == pcnt) && (pcnt > 0)) {
        // с перляжем ------
        drawPixelXY(x, 0U, CHSV(hue, 150U, hue2 * 2 + 20U + random(0, 50U)));
      } else {
        drawPixelXY(x, 0U, CHSV(hue, 255U, hue2 * 2));
        // LOG.printf_P(PSTR("hue = %03d | Direction = %d | Brightness %03d | delta %d\n"), hue, deltaHue, hue2, deltaHue2);
      }
    }
  }

  // меняем направление изменения цвета вина от красного к шампанскому и обратно
  // в двух диапазонах шкалы HUE |0-60|.........|245-255|
  if  (deltaHue == 0U) {
    if  (hue == 1U) {
      hue = 255U;
    }
    if  (hue == 245U) {
      deltaHue = 1U;
    }
  }
  if (deltaHue == 1U) {
    if (hue == 254U) {
      hue = 0U;
    }
    if (hue == 60U) {
      deltaHue = 0U;
    }
  }
  step++;
}
*/


// ============= Эффект Пламя ===============
// (c) SottNick
// По мотивам https://goldenandy.blogspot.com/2021/05/ws2812.html
// by Андрей Локтев

// характеристики языков пламени
//  x, dx; => trackingObjectPosX, trackingObjectSpeedX;
//  y, dy; => trackingObjectPosY, trackingObjectSpeedY;
//  ttl; => trackingObjectState;
//  uint8_t hue; => float   trackingObjectShift
//  uint8_t saturation; => 255U
//  uint8_t value; => trackingObjectHue;

// характеристики изображения CHSV picture[WIDTH][HEIGHT]
//  uint8_t .hue; => noise3d[0][WIDTH][HEIGHT]
//  uint8_t .sat; => shiftValue[HEIGHT] (не хватило двухмерного массива на насыщенность)
//  uint8_t .val; => noise3d[1][WIDTH][HEIGHT]

#define FLAME_MAX_DY        256 // максимальная вертикальная скорость перемещения языков пламени за кадр.  имеется в виду 256/256 =   1 пиксель за кадр
#define FLAME_MIN_DY        128 // минимальная вертикальная скорость перемещения языков пламени за кадр.   имеется в виду 128/256 = 0.5 пикселя за кадр
#define FLAME_MAX_DX         32 // максимальная горизонтальная скорость перемещения языков пламени за кадр. имеется в виду 32/256 = 0.125 пикселя за кадр
#define FLAME_MIN_DX       (-FLAME_MAX_DX)
#define FLAME_MAX_VALUE     255 // максимальная начальная яркость языка пламени
#define FLAME_MIN_VALUE     176 // минимальная начальная яркость языка пламени

//пришлось изобрести очередную функцию субпиксельной графики. на этот раз бесшовная по ИКСу, работающая в цветовом пространстве HSV и без смешивания цветов
void wu_pixel_maxV(int16_t item) {
  //uint8_t xx = trackingObjectPosX[item] & 0xff, yy = trackingObjectPosY[item] & 0xff, ix = 255 - xx, iy = 255 - yy;
  uint8_t xx = (trackingObjectPosX[item] - (int)trackingObjectPosX[item]) * 255, yy = (trackingObjectPosY[item] - (int)trackingObjectPosY[item]) * 255, ix = 255 - xx, iy = 255 - yy;
  // calculate the intensities for each affected pixel
#define WU_WEIGHT(a,b) ((uint8_t) (((a)*(b)+(a)+(b))>>8))
  uint8_t wu[4] = {WU_WEIGHT(ix, iy), WU_WEIGHT(xx, iy),
                   WU_WEIGHT(ix, yy), WU_WEIGHT(xx, yy)
                  };
  // multiply the intensities by the colour, and saturating-add them to the pixels
  for (uint8_t i = 0; i < 4; i++) {
    uint8_t x1 = (int8_t)(trackingObjectPosX[item] + (i & 1)) % WIDTH; //делаем бесшовный по ИКСу
    uint8_t y1 = (int8_t)(trackingObjectPosY[item] + ((i >> 1) & 1));
    if (y1 < HEIGHT && trackingObjectHue[item] * wu[i] >> 8 >= noise3d[1][x1][y1]) {
      noise3d[0][x1][y1] = trackingObjectShift[item];
      shiftValue[y1] = 255U;//saturation;
      noise3d[1][x1][y1] = trackingObjectHue[item] * wu[i] >> 8;
    }
  }
}

void execStringsFlame() { // внимание! эффект заточен на бегунок Масштаб с диапазоном от 0 до 255
  int16_t i, j;
  if (loadingFlag) {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
#ifdef USE_BLYNK
    if (selectedSettings) {
      setModeSettings(1U + random8(100U), 20U + random8(236U)); // у Блинка бегунок Масштаб всегда от 1 до 100
    }
#else
    if (selectedSettings) {
      setModeSettings(1U + random8(255U), 20U + random8(236U)); // на свякий случай пусть будет от 1 до 255, а не от нуля
    }
#endif
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    enlargedObjectNUM = (modes[currentMode].Speed - 1U) / 254.0 * (trackingOBJECT_MAX_COUNT - 1U) + 1U;
    if (enlargedObjectNUM > enlargedOBJECT_MAX_COUNT) enlargedObjectNUM = enlargedOBJECT_MAX_COUNT;
    if (currentMode >= EFF_MATRIX) {
      ff_x = WIDTH * 2.4;
      enlargedObjectNUM = (ff_x > enlargedOBJECT_MAX_COUNT) ? enlargedOBJECT_MAX_COUNT : ff_x;
    }

    hue = map8(myScale8(modes[currentMode].Scale + 3U), 3, 10); // минимальная живучесть/высота языка пламени ...ttl
    hue2 = map8(myScale8(modes[currentMode].Scale + 3U), 6, 31); // максимальная живучесть/высота языка пламени ...ttl
    for (i = 0; i < trackingOBJECT_MAX_COUNT; i++) // чистим массив объектов от того, что не похоже на языки пламени
      if (trackingObjectState[i] > 30U || trackingObjectPosY[i] >= HEIGHT || trackingObjectPosX[i] >= WIDTH || trackingObjectPosY[i] <= 0) {
        trackingObjectHue[i] = 0U;
        trackingObjectState[i] = random8(20);
      }
    for (i = 0; i < WIDTH; i++) // заполняем массив изображения из массива leds обратным преобразованием, которое нихрена не работает
      for (j = 0; j < HEIGHT; j++ ) {
        CHSV tHSV = rgb2hsv_approximate(leds[XY(i, j)]);
        noise3d[0][i][j] = tHSV.hue;
        if (tHSV.val > 100U) { // такая защита от пересвета более-менее достаточна
          shiftValue[j] = tHSV.sat;
          if (tHSV.sat < 100U) // для перехода с очень тусклых эффектов, использующих заливку белым или почти белым светом
            noise3d[1][i][j] = tHSV.val / 3U;
          else
            noise3d[1][i][j] = tHSV.val - 32U;
        }
        else
          noise3d[1][i][j] = 0U;

        //CRGB tRGB = leds[XY(i,j)];
        //if (tRGB.r + tRGB.g + tRGB.b < 100U) // не пригодилось
        //  noise3d[1][i][j] = 0U;
      }
  }

  // угасание предыдущего кадра
  for (i = 0; i < WIDTH; i++)
    for (j = 0; j < HEIGHT; j++ )
      noise3d[1][i][j] = (uint16_t)noise3d[1][i][j] * 237U >> 8;

  // цикл перебора языков пламени
  for (i = 0; i < enlargedObjectNUM; i++) {
    if (trackingObjectState[i]) { // если ещё не закончилась его жизнь
      wu_pixel_maxV(i);

      j = trackingObjectState[i];
      trackingObjectState[i]--;

      trackingObjectPosX[i] += trackingObjectSpeedX[i];
      trackingObjectPosY[i] += trackingObjectSpeedY[i];

      trackingObjectHue[i] = (trackingObjectState[i] * trackingObjectHue[i] + j / 2) / j;

      // если вышел за верхнюю границу или потух, то и жизнь закончилась
      if (trackingObjectPosY[i] >= HEIGHT || trackingObjectHue[i] < 2U)
        trackingObjectState[i] = 0;

      // если вылез за край матрицы по горизонтали, перекинем на другую сторону
      if (trackingObjectPosX[i] < 0)
        trackingObjectPosX[i] += WIDTH;
      else if (trackingObjectPosX[i] >= WIDTH)
        trackingObjectPosX[i] -= WIDTH;
    }
    else { // если жизнь закончилась, перезапускаем
      trackingObjectState[i] = random8(hue, hue2);
      trackingObjectShift[i] = (uint8_t)(254U + modes[currentMode].Scale + random8(20U)); // 254 - это шаг в обратную сторону от выбранного пользователем оттенка (стартовый оттенок диапазона)
      // 20 - это диапазон из градиента цвета от выбранного пользователем оттенка (диапазон от 254 до 254+20)
      trackingObjectPosX[i] = (float)random(WIDTH * 255U) / 255.;
      trackingObjectPosY[i] = -.9;
      trackingObjectSpeedX[i] = (float)(FLAME_MIN_DX + random8(FLAME_MAX_DX - FLAME_MIN_DX)) / 256.;
      trackingObjectSpeedY[i] = (float)(FLAME_MIN_DY + random8(FLAME_MAX_DY - FLAME_MIN_DY)) / 256.;
      trackingObjectHue[i] = FLAME_MIN_VALUE + random8(FLAME_MAX_VALUE - FLAME_MIN_VALUE + 1U);
      //saturation = 255U;
    }
  }

  //выводим кадр на матрицу
  for (i = 0; i < WIDTH; i++)
    for (j = 0; j < HEIGHT; j++)
      //hsv2rgb_spectrum(CHSV(noise3d[0][i][j], shiftValue[j], noise3d[1][i][j] * 1.033), leds[XY(i,j)]); // 1.033 - это коэффициент нормализации яркости (чтобы чутка увеличить яркость эффекта в целом)
      hsv2rgb_spectrum(CHSV(noise3d[0][i][j], shiftValue[j], noise3d[1][i][j]), leds[XY(i, j)]);
}

// ============= Эффект Огонь 2021 ===============
// (c) SottNick
// На основе алгоритма https://editor.soulmatelights.com/gallery/546-fire
// by Stepko

#define FIXED_SCALE_FOR_Y 4U // менять нельзя. корректировка скорости ff_x =... подогнана под него

void Fire2021Routine() {
  if (loadingFlag) {
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      uint8_t tmp = 1U + random8(89U); // пропускаем белую палитру
      if (tmp > 44U) tmp += 11U;
      setModeSettings(tmp, 42U + random8(155U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    loadingFlag = false;
    if (modes[currentMode].Scale > 100U) modes[currentMode].Scale = 100U; // чтобы не было проблем при прошивке без очистки памяти
    deltaValue = modes[currentMode].Scale * 0.0899;// /100.0F * ((sizeof(palette_arr) /sizeof(TProgmemRGBPalette16 *))-0.01F));
    if (deltaValue == 3U || deltaValue == 4U)
      curPalette =  palette_arr[deltaValue]; // (uint8_t)(modes[currentMode].Scale/100.0F * ((sizeof(palette_arr) /sizeof(TProgmemRGBPalette16 *))-0.01F))];
    else
      curPalette = firePalettes[deltaValue]; // (uint8_t)(modes[currentMode].Scale/100.0F * ((sizeof(firePalettes)/sizeof(TProgmemRGBPalette16 *))-0.01F))];
    deltaValue = (modes[currentMode].Scale - 1U) % 11U + 1U;
    if (modes[currentMode].Speed & 0x01) {
      ff_x = modes[currentMode].Speed;
      deltaHue2 = FIXED_SCALE_FOR_Y;
    }
    else {
      if (deltaValue > FIXED_SCALE_FOR_Y)
        speedfactor = .4 * (deltaValue - FIXED_SCALE_FOR_Y) + FIXED_SCALE_FOR_Y;
      else
        speedfactor = deltaValue;
      ff_x = round(modes[currentMode].Speed * 64. / (0.1686 * speedfactor * speedfactor * speedfactor - 1.162 * speedfactor * speedfactor + 3.6694 * speedfactor + 56.394)); // Ааааа! это тупо подбор коррекции. очень приблизитеьный
      deltaHue2 = deltaValue;
    }
    if (ff_x > 255U)
      ff_x = 255U;
    if (ff_x == 0U)
      ff_x = 1U;
    step = map(ff_x * ff_x, 1U, 65025U, (deltaHue2 - 1U) / 2U + 1U, deltaHue2 * 18U + 44);
    pcnt = map(step, 1U, 255U, 20U, 128U); // nblend 3th param
    deltaValue = 0.7 * deltaValue * deltaValue + 31.3; // ширина языков пламени (масштаб шума Перлина)
    deltaHue2 = 0.7 * deltaHue2 * deltaHue2 + 31.3; // высота языков пламени (масштаб шума Перлина)
  }

  ff_y += step; //static uint32_t t += speed;
  for (byte x = 0; x < WIDTH; x++) {
    for (byte y = 0; y < HEIGHT; y++) {
      int16_t Bri = inoise8(x * deltaValue, (y * deltaHue2) - ff_y, ff_z) - (y * (255 / HEIGHT));
      byte Col = Bri;//inoise8(x * deltaValue, (y * deltaValue) - ff_y, ff_z) - (y * (255 / HEIGHT));
      if (Bri < 0)
        Bri = 0;
      if (Bri != 0)
        Bri = 256 - (Bri * 0.2);
      //leds[XY(x, y)] = ColorFromPalette(*curPalette, Col, Bri);
      nblend(leds[XY(x, y)], ColorFromPalette(*curPalette, Col, Bri), pcnt);
    }
  }
  if (!random8())
    ff_z++;
}



// ----------------------------- Эффект Мозайка / Кафель ------------------------------
// (c) SottNick
// на основе идеи Idir
// https://editor.soulmatelights.com/gallery/843-squares-and-dots
/*void squaresNdotsRoutine() {
  if (loadingFlag) {
    #if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
      if (selectedSettings) {
        // scale | speed
        setModeSettings(1U + random8(100U), 1U + random8(255U));
      }
    #endif
    loadingFlag = false;
    shtukX = WIDTH / 3U + 1U;
    shtukY = HEIGHT / 3U + 1U;
    poleX = modes[currentMode].Speed % 3U;
    poleY = modes[currentMode].Speed / 3U % 3U;

    for (uint8_t i = 0; i < shtukX; i++)
      line[i] = random8(3U);
    for (uint8_t i = 0; i < shtukY; i++)
      shiftValue[i] = random8(3U);
  }

  bool type = random8(2U);
  CRGB color = CHSV(random8(), 255U - random8(modes[currentMode].Scale * 2.55), 255U);

  uint8_t i = random8(shtukX);
  uint8_t j = random8(shtukY);
  int16_t x0 = i * 3 + (poleX + ((modes[currentMode].Scale & 0x01) ? line[j] : 0)) % 3 - 2;
  int16_t y0 = j * 3 + (poleY + ((modes[currentMode].Scale & 0x01) ? 0 : shiftValue[i])) % 3 - 2;
  uint8_t hole = 0U;

  for (int16_t x = x0; x < x0 + 3; x++) {
    for (int16_t y = y0; y < y0 + 3; y++) {
      drawPixelXY(x, y, ((hole == 4U) ^ type) ? CRGB::Black : color);
      hole++;
    }
  }
  }
*/


// =============== Эффект Lumenjer ================
// (c) SottNick

#define DIMSPEED (254U - 500U / WIDTH / HEIGHT)

void lumenjerRoutine() {
  if (loadingFlag)
  {
    loadingFlag = false;
#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)
    if (selectedSettings) {
      uint8_t tmp = random8(17U); //= random8(19U);
      if (tmp > 2U) tmp += 2U;
      tmp = (uint8_t)(tmp * 5.556 + 3.);
      if (tmp > 100U) tmp = 100U;
      setModeSettings(tmp, 190U + random8(56U));
    }
#endif //#if defined(USE_RANDOM_SETS_IN_APP) || defined(RANDOM_SETTINGS_IN_CYCLE_MODE)

    if (modes[currentMode].Scale > 100) modes[currentMode].Scale = 100; // чтобы не было проблем при прошивке без очистки памяти
    if (modes[currentMode].Scale > 50)
      curPalette = firePalettes[(uint8_t)((modes[currentMode].Scale - 50) / 50.0F * ((sizeof(firePalettes) / sizeof(TProgmemRGBPalette16 *)) - 0.01F))];
    else
      curPalette = palette_arr[(uint8_t)(modes[currentMode].Scale / 50.0F * ((sizeof(palette_arr) / sizeof(TProgmemRGBPalette16 *)) - 0.01F))];

    deltaHue = -1;
    deltaHue2 = -1;
    //hue = CENTER_X_MAJOR;
    //hue2 = CENTER_Y_MAJOR;
    dimAll(245U);
  }
  //fadeToBlackBy(leds, N_LEDS, 2);
  dimAll(DIMSPEED);

  deltaHue = random8(3) ? deltaHue : -deltaHue;
  deltaHue2 = random8(3) ? deltaHue2 : -deltaHue2;
#if (WIDTH % 2 == 0 && HEIGHT % 2 == 0)
  hue = (WIDTH + hue + deltaHue * (bool)random8(64)) % WIDTH;
#else
  hue = (WIDTH + hue + deltaHue) % WIDTH;
#endif
  hue2 = (HEIGHT + hue2 + deltaHue2) % HEIGHT;

  if (modes[currentMode].Scale == 100U)
    leds[XY(hue, hue2)] += CHSV(random8(), 255U, 255U);
  else
    leds[XY(hue, hue2)] += ColorFromPalette(*curPalette, step++);
}
