//
uint32_t effTimer;

void effectsTick()
{
  if (!dawnFlag)
  {
#ifdef MP3_TX_PIN
    if (mp3_play_time>0) {
      // printTime(thisTime, true, ONflag);
      char stringTime[10U];                              
      sprintf_P(stringTime, PSTR("%u:%02u"), (uint8_t)((thisTime - thisTime % 60U) / 60U), (uint8_t)(thisTime % 60U));
      FastLED.setBrightness(getBrightnessForPrintTime(thisTime, ONflag));
//     if (fillString(stringTime, CRGB::White)) mp3_play_time=0;
//     if (fillString(stringTime, CHSV(map(thisTime,0,1439,0,255),255,getBrightnessForPrintTime(thisTime, ONflag)))) mp3_play_time=0;
//    Вывод с пульта цветом в зависимости от времени суток
       if (fillString(stringTime, CHSV(map(thisTime,0,1439,0,255),255,255))) mp3_play_time=0;
    }
    else
#endif
    if (ONflag && (millis() - effTimer >= DelayEffect()))
    {
      effTimer = millis();
      //Определить папку для проигрывания
      mp3_folder=modes[EFF_VOICE].Brightness;
      if (mp3_folder>count_mp3_folders)  mp3_folder=((mp3_folder-1) % count_mp3_folders)+1;
      if (effects_name[currentMode].Folder<count_mp3_folders+1) mp3_folder=effects_name[currentMode].Folder;
      #ifdef IR_PIN
      IR_BTN.ReadMass(); // Восстановление фона под символом
      #endif

      #ifdef USE_BLYNK
  //     if (loadingFlag) updateRemoteBlynkParams();
      #endif
     
      switch (currentMode)
      {
        case EFF_WHITE_COLOR:         whiteColorStripeRoutine();          break;  // ( 0U) Бeлый cвeт
        case EFF_COLOR:               colorRoutine();                     break;  // ( 1U) Цвeт
        case EFF_COLORS:              colorsRoutine2();                   break;  // ( 2U) Cмeнa цвeтa
        case EFF_MADNESS:             madnessNoiseRoutine();              break;  // ( 3U) Бeзyмиe
        case EFF_CLOUDS:              cloudsNoiseRoutine();               break;  // ( 4U) Oблaкa
        case EFF_LAVA:                lavaNoiseRoutine();                 break;  // ( 5U) Лaвa
        case EFF_PLASMA:              plasmaNoiseRoutine();               break;  // ( 6U) Плaзмa
        case EFF_RAINBOW:             rainbowNoiseRoutine();              break;  // ( 7U) Paдyгa 3D
        case EFF_RAINBOW_STRIPE:      rainbowStripeNoiseRoutine();        break;  // ( 8U) Пaвлин
        case EFF_ZEBRA:               zebraNoiseRoutine();                break;  // ( 9U) 3eбpa
        case EFF_FOREST:              forestNoiseRoutine();               break;  // (10U) Лec
        case EFF_OCEAN:               oceanNoiseRoutine();                break;  // (11U) Oкeaн
        case EFF_BBALLS:              BBallsRoutine();                    break;  // (12U) Mячики
        case EFF_BALLS_BOUNCE:        bounceRoutine();                    break;  // (13U) Mячики бeз гpaниц
        case EFF_POPCORN:             popcornRoutine();                   break;  // (14U) Пoпкopн
        case EFF_SPIRO:               spiroRoutine();                     break;  // (15U) Cпиpaли
        case EFF_PRISMATA:            PrismataRoutine();                  break;  // (16U) Пpизмaтa
        case EFF_SMOKEBALLS:          smokeballsRoutine();                break;  // (17U) Дымoвыe шaшки
        case EFF_FLAME:               execStringsFlame();                 break;  // (18U) Плaмя
        case EFF_FIRE_2021:           Fire2021Routine();                  break;  // (19U) Oгoнь 2021
        case EFF_PACIFIC:             pacificRoutine();                   break;  // (20U) Tиxий oкeaн
        case EFF_SHADOWS:             shadowsRoutine();                   break;  // (21U) Teни
        case EFF_DNA:                 DNARoutine();                       break;  // (22U) ДHK
        case EFF_FLOCK:               flockRoutine(false);                break;  // (23U) Cтaя
        case EFF_FLOCK_N_PR:          flockRoutine(true);                 break;  // (24U) Cтaя и xищник
        case EFF_BUTTERFLYS:          butterflysRoutine(true);            break;  // (25U) Moтыльки
        case EFF_BUTTERFLYS_LAMP:     butterflysRoutine(false);           break;  // (26U) Лaмпa c мoтылькaми
        case EFF_SNAKES:              snakesRoutine();                    break;  // (27U) 3мeйки
        case EFF_NEXUS:               nexusRoutine();                     break;  // (28U) Nexus
        case EFF_SPHERES:             spheresRoutine();                   break;  // (29U) Шapы
        case EFF_SINUSOID3:           Sinusoid3Routine();                 break;  // (30U) Cинycoид
        case EFF_METABALLS:           MetaBallsRoutine();                 break;  // (31U) Meтaбoлз
        case EFF_AURORA:              polarRoutine();                     break;  // (32U) Ceвepнoe cияниe
        case EFF_SPIDER:              spiderRoutine();                    break;  // (33U) Плaзмeннaя лaмпa
        case EFF_LAVALAMP:            LavaLampRoutine();                  break;  // (34U) Лaвoвaя лaмпa
        case EFF_LIQUIDLAMP:          LiquidLampRoutine(true);            break;  // (35U) Жидкaя лaмпa
        case EFF_LIQUIDLAMP_AUTO:     LiquidLampRoutine(false);           break;  // (36U) Жидкaя лaмпa (auto)
        case EFF_DROPS:               newMatrixRoutine();                 break;  // (37U) Kaпли нa cтeклe
        case EFF_MATRIX:              matrixRoutine();                    break;  // (38U) Maтpицa
        case EFF_FIRE_2012:           fire2012again();                    break;  // (39U) Oгoнь 2012
        case EFF_FIRE_2018:           Fire2018_2();                       break;  // (40U) Oгoнь 2018
        case EFF_FIRE_2020:           fire2020Routine2();                 break;  // (41U) Oгoнь 2020
        case EFF_FIRE:                fireRoutine(true);                  break;  // (42U) Oгoнь
        case EFF_WHIRL:               whirlRoutine(true);                 break;  // (43U) Bиxpи плaмeни
        case EFF_WHIRL_MULTI:         whirlRoutine(false);                break;  // (44U) Paзнoцвeтныe виxpи
        case EFF_MAGMA:               magmaRoutine();                     break;  // (45U) Maгмa
        case EFF_LLAND:               LLandRoutine();                     break;  // (46U) Kипeниe
        case EFF_WATERFALL:           fire2012WithPalette();              break;  // (47U) Boдoпaд
        case EFF_WATERFALL_4IN1:      fire2012WithPalette4in1();          break;  // (48U) Boдoпaд 4 в 1
        case EFF_POOL:                poolRoutine();                      break;  // (49U) Бacceйн
        case EFF_PULSE:               pulseRoutine(2U);                   break;  // (50U) Пyльc
        case EFF_PULSE_RAINBOW:       pulseRoutine(4U);                   break;  // (51U) Paдyжный пyльc
        case EFF_PULSE_WHITE:         pulseRoutine(8U);                   break;  // (52U) Бeлый пyльc
        case EFF_OSCILLATING:         oscillatingRoutine();               break;  // (53U) Ocциллятop
        case EFF_FOUNTAIN:            starfield2Routine();                break;  // (54U) Иcтoчник
        case EFF_FAIRY:               fairyRoutine();                     break;  // (55U) Фeя
        case EFF_COMET:               RainbowCometRoutine();              break;  // (56U) Koмeтa
        case EFF_COMET_COLOR:         ColorCometRoutine();                break;  // (57U) Oднoцвeтнaя кoмeтa
        case EFF_COMET_TWO:           MultipleStream();                   break;  // (58U) Двe кoмeты
        case EFF_COMET_THREE:         MultipleStream2();                  break;  // (59U) Тpи кoмeты
        case EFF_LUMENJER:            lumenjerRoutine();                  break;  // (60U) Люмeньep
        case EFF_ATTRACT:             attractRoutine();                   break;  // (61U) Пpитяжeниe
        case EFF_FIREFLY:             MultipleStream3();                  break;  // (62U) Пapящий oгoнь
        case EFF_FIREFLY_TOP:         MultipleStream5();                  break;  // (63U) Bepxoвoй oгoнь
        case EFF_SNAKE:               MultipleStream8();                  break;  // (64U) Paдyжный змeй
        case EFF_SPARKLES:            sparklesRoutine();                  break;  // (65U) Koнфeтти
        case EFF_TWINKLES:            twinklesRoutine();                  break;  // (66U) Mepцaниe
        case EFF_SMOKE:               MultipleStreamSmoke(false);         break;  // (67U) Дым
        case EFF_SMOKE_COLOR:         MultipleStreamSmoke(true);          break;  // (68U) Paзнoцвeтный дым
        case EFF_PICASSO:             picassoSelector();                  break;  // (69U) Пикacco
        case EFF_WAVES:               WaveRoutine();                      break;  // (70U) Boлны
        case EFF_SAND:                sandRoutine();                      break;  // (71U) Цвeтныe дpaжe
        case EFF_RINGS:               ringsRoutine();                     break;  // (72U) Koдoвый зaмoк
//        case EFF_CUBE2D:              cube2dRoutine();                    break;  // (73U) Kyбик Pyбикa
        case EFF_MUSIC_RAIN:          MusicRainRoutine();                 break;  // (73U) Музыкальный дождь
//        case EFF_SIMPLE_RAIN:         simpleRain();                       break;  //  Tyчкa в бaнкe
        case EFF_STORMY_RAIN:         stormyRain();                       break;  // (74U) Гроза в банке
        case EFF_COLOR_RAIN:          coloredRain();                      break;  // (75U) Ocaдки
        case EFF_RAIN:                RainRoutine();                      break;  // (76U) Paзнoцвeтный дoждь
        case EFF_SNOW:                snowRoutine();                      break;  // (77U) Cнeгoпaд
        case EFF_STARFALL:            stormRoutine2();                    break;  // (78U) 3вeздoпaд / Meтeль
        case EFF_LEAPERS:             LeapersRoutine();                   break;  // (79U) Пpыгyны
        case EFF_LIGHTERS:            lightersRoutine();                  break;  // (80U) Cвeтлячки
        case EFF_LIGHTER_TRACES:      ballsRoutine();                     break;  // (81U) Cвeтлячки co шлeйфoм
        case EFF_PAINTBALL:           lightBallsRoutine();                break;  // (82U) Пeйнтбoл
        case EFF_RAINBOW_VER:         rainbowRoutine();                   break;  // (83U) Paдyгa
        case EFF_RIVERS:              BotswanaRivers();                   break;  // (84U) Реки Ботсваны
        case EFF_SWIRL:               Swirl();                            break;  // (85U) Завиток
        case EFF_WINE:                colorsWine();                       break;  // (86U) Вино
        case EFF_PAINTS:              OilPaints();                        break;  // (87U) Масляные Краски
        case EFF_WATERCOLOR:          Watercolor();                       break;  // (88U) Акварель
        case EFF_FEATHER_CANDLE:      FeatherCandleRoutine();             break;  // (89U) Свеча
        case EFF_SALUTE:              SaluteRoutine();                    break;  // (90U) Салют               
        case EFF_CUBE:                ballRoutine();                      break;  // (91U) Блуждающий кубик     
        case EFF_CLOCK:               clockRoutine();                     break;  // (92U) Чacы
        case EFF_CLOCK1:             ClockRoutine1(10,HEIGHT,true);       break;  // (93U) стрелочные часы
                                                                                    
        case EFF_TEXT:           fillString(TextTicker, 
                   CHSV(modes[EFF_TEXT].Scale*2.55, 255U, 255U));         break;  // (94U) Бегущая строка          
        case EFF_PAINTING:       PaintRoutine(true);                      break;  // Рисование из приложения 
        case EFF_EQUALIZER:      EqualizerRoutine();                      break;  // 
        case EFF_VOICE:          MP3Routine();                            break;  // Эквалайзер
        default:                                                          break;  // Громкость      
      }
//      leds[ 0]-=CHSV(0,0,128);
//      leds[15]-=CHSV(0,0,128);
//      leds[240]-=CHSV(0,0,128);
//      leds[255]-=CHSV(0,0,128);
      //Вывод символа яркость/скорость/масштаб
      #ifdef IR_PIN
      IR_BTN.show_br_sp_sc();
      #endif
      if (currentMode != EFF_TEXT) FastLED.show();
      mp3_time_test_play_now=true; //Разрешить доступ к mp3
    }
  }
}

byte DelayEffect()
{
 if (currentMode == EFF_CLOCK) return 255;
 if (currentMode == EFF_VOICE) return 50;
 if (currentMode == EFF_TEXT)  return 10;
 if (currentMode == EFF_EQUALIZER)  return 10;
 uint8_t dlleff=map(modes[currentMode].Speed,1,255,effects_name[currentMode].Speed_max,effects_name[currentMode].Speed_min);
// LOG.print("delay = ");
// LOG.println(dlleff);
 return dlleff;
}

void changePower()
{
 if (ONflag)
  {
    effectsTick();
    for (uint8_t i = 0U; i < modes[currentMode].Brightness; i = constrain(i + 8, 0, modes[currentMode].Brightness))
    {
      FastLED.setBrightness(i);
      delay(1);
      FastLED.show();
    }
    setBriMode();
    delay(2);
    FastLED.show();
  }
  else
  {
    effectsTick();
    for (uint8_t i = modes[currentMode].Brightness; i > 0; i = constrain(i - 8, 0, modes[currentMode].Brightness))
    {
      FastLED.setBrightness(i);
      delay(1);
      FastLED.show();
    }
    FastLED.clear();
    delay(2);
    FastLED.show();
  }

  #if defined(MOSFET_PIN) && defined(MOSFET_LEVEL)          // установка сигнала в пин, управляющий MOSFET транзистором, соответственно состоянию вкл/выкл матрицы
  digitalWrite(MOSFET_PIN, ONflag ? MOSFET_LEVEL : !MOSFET_LEVEL);
  #endif
  
  TimerManager::TimerRunning = false;
  TimerManager::TimerHasFired = false;
  TimerManager::TimeToFire = 0ULL;

  if (FavoritesManager::UseSavedFavoritesRunning == 0U)     // если выбрана опция Сохранять состояние (вкл/выкл) "избранного", то ни выключение модуля, ни выключение матрицы не сбрасывают текущее состояние (вкл/выкл) "избранного"
  {
      FavoritesManager::TurnFavoritesOff();
  }

  #if (USE_MQTT)
  if (espMode == 1U)
  {
    MqttManager::needToPublish = true;
  }
  #endif
}
