#pragma once   

#include <ESP8266WebServer.h>

//#define USE_BLYNK  ("Ключ")    // раскомментируйте эту строку, если вы используете приложение Blynk (для iOS и Android) https://community.alexgyver.ru/threads/wifi-lampa-budilnik-obsuzhdenie-proshivki-ot-gunner47.2418/post-53535
#ifdef USE_BLYNK
uint32_t blynkTimer;
#endif
#define HTML_REMOTE           (1)                           // раскомментируйте эту строку, если вы используете управление по http

// ============= НАСТРОЙКИ =============
// --- ESP -----------------------------
#define ESP_MODE              (1U)                          // 0U - WiFi точка доступа, 1U - клиент WiFi (подключение к роутеру)
uint8_t espMode = ESP_MODE;                                 // ESP_MODE может быть сохранён в энергонезависимую память и изменён в процессе работы лампы без необходимости её перепрошивки
#define ESP_USE_BUTTON                                      // если строка не закомментирована, должна быть подключена кнопка (иначе ESP может регистрировать "фантомные" нажатия и некорректно устанавливать яркость)
#if defined (ESP_USE_BUTTON)
#define BUTTON_STEP_TIMEOUT   (100U)                        // каждые BUTTON_STEP_TIMEOUT мс будет генерироваться событие удержания кнопки (для регулировки яркости)
#define BUTTON_CLICK_TIMEOUT  (500U)                        // максимальное время между нажатиями кнопки в мс, до достижения которого считается серия последовательных нажатий
#define BUTTON_TIMEOUT        (700U)                        // с какого момента начинает считаться, что кнопка удерживается в мс
#endif
#define ESP_RESET_ON_START    (false)                       // true - если при старте нажата кнопка (или кнопки нет!), сохранённые настройки будут сброшены; false - не будут
#define ESP_HTTP_PORT         (80U)                         // 80U номер порта, который будет использоваться во время первой утановки имени WiFi сети (и пароля), к которой потом будет подключаться лампа в режиме WiFi клиента (лучше не менять)
#define ESP_UDP_PORT          (8888U)                       // номер порта, который будет "слушать" UDP сервер во время работы лампы как в режиме WiFi точки доступа, так и в режиме WiFi клиента (лучше не менять)
#define ESP_CONN_TIMEOUT      (7U)                          // время в секундах (ДОЛЖНО БЫТЬ МЕНЬШЕ 8, иначе сработает WDT), которое ESP будет пытаться подключиться к WiFi сети, после его истечения автоматически развернёт WiFi точку доступа
#define ESP_CONF_TIMEOUT      (300U)                        // время в секундах, которое ESP будет ждать ввода SSID и пароля WiFi сети роутера в конфигурационном режиме, после его истечения ESP перезагружается
#define GENERAL_DEBUG                                       // если строка не закомментирована, будут выводиться отладочные сообщения
#define WIFIMAN_DEBUG         (true)                        // вывод отладочных сообщений при подключении к WiFi сети: true - выводятся, false - не выводятся; настройка не зависит от GENERAL_DEBUG
#define OTA                                                 // если строка не закомментирована, модуль будет ждать два последдовательных запроса пользователя на прошивку по воздуху (см. документацию в "шапке")
#ifdef OTA
#define ESP_OTA_PORT          (8266U)                       // номер порта, который будет "прослушиваться" в ожидании команды прошивки по воздуху
#endif
#define LED_PIN               (0U)                          // пин ленты                (D3)  (2U - D4)
#define BTN_PIN               (4U)                          // пин кнопки               (D2)
#define MOSFET_PIN            (5U)                          // пин MOSFET транзистора   (D1) - может быть использован для управления питанием матрицы/ленты
#define ALARM_PIN             (16U)                         // пин состояния будильника (D0) - может быть использован для управления каким-либо внешним устройством на время работы будильника
#define MOSFET_LEVEL          (HIGH)                        // логический уровень, в который будет установлен пин MOSFET_PIN, когда матрица включена - HIGH или LOW
#define ALARM_LEVEL           (HIGH)                        // логический уровень, в который будет установлен пин ALARM_PIN, когда "рассвет"/будильник включен
#define LAMP_NAME             ("LedLamp")                 // Имя лампы

// --- ESP (WiFi клиент) ---------------
const uint8_t STA_STATIC_IP[] = {};                         // статический IP адрес: {} - IP адрес определяется роутером; {192, 168, 1, 66} - IP адрес задан явно (если DHCP на роутере не решит иначе); должен быть из того же диапазона адресов, что разадёт роутер
                                                            // SSID WiFi сети и пароль будут запрошены WiFi Manager'ом в режиме WiFi точки доступа, нет способа захардкодить их в прошивке

// --- AP (WiFi точка доступа) ---
//#define AP_NAME               ("test")             // имя WiFi точки доступа, используется как при запросе SSID и пароля WiFi сети роутера, так и при работе в режиме ESP_MODE = 0
//#define AP_PASS               ("11111111")                  // пароль WiFi точки доступа
#define AP_NAME               ("LedLamp")                   // имя WiFi точки доступа, используется как при запросе SSID и пароля WiFi сети роутера, так и при работе в режиме ESP_MODE = 0
#define AP_PASS               ("31415926")                  // пароль WiFi точки доступа
const uint8_t AP_STATIC_IP[] = {192, 168, 4, 1};            // статический IP точки доступа (лучше не менять)
// ----ИК Управление
#define IR_PIN                (5U)                          // D1 Пин, куда подключет IR 
// --- ВРЕМЯ ---------------------------
#define USE_NTP                                             // закомментировать или удалить эту строку, если нужно, чтобы устройство не лезло в интернет
//#define NTP_ADDRESS         ("ntp2.colocall.net")         // сервер времени Глючит
//#define NTP_ADDRESS         ("ru.pool.ntp.org")
//#define NTP_ADDRESS         ("pool.ntp.org")
#define NTP_ADDRESS         ("time.windows.com") 
//#define NTP_ADDRESS         ("ntp3.stratum2.ru")
//define NTP_ADDRESS          ("ntp.msk-ix.ru")
//#define NTP_ADDRESS         ("fr.pool.ntp.org")
#define NTP_INTERVAL          (30UL * 60UL * 1000UL)        // интервал синхронизации времени (30 минут)
//#define SUMMER_WINTER_TIME                                  // для тех, кому нужен переход на зимнее/летнее время - оставить строку, остальным - закомментировать или удалить
#if !defined(SUMMER_WINTER_TIME)
#define LOCAL_WEEK_NUM        (week_t::Last)                // для стран, где нет перехода на зимнее/летнее время это технический параметр, не нужно его изменять
#define LOCAL_WEEKDAY         (dow_t::Sun)                  // для стран, где нет перехода на зимнее/летнее время это технический параметр, не нужно его изменять
#define LOCAL_MONTH           (month_t::Mar)                // для стран, где нет перехода на зимнее/летнее время это технический параметр, не нужно его изменять
#define LOCAL_HOUR            (1U)                          // для стран, где нет перехода на зимнее/летнее время это технический параметр, не нужно его изменять
#define LOCAL_OFFSET          (3 * 60)                      // смещение локального времени относительно универсального координированного времени UTC в минутах
#define LOCAL_TIMEZONE_NAME   ("MSK")                       // обозначение локального часового пояса; до 5 символов; может быть использовано, если понадобится его вывести после вывода времени
#else
#define SUMMER_WEEK_NUM       (week_t::Last)                // номер недели в месяце, когда происходит переход на летнее время (возможные варианты: First - первая, Second - вторая, Third - третья, Fourth - четвёртая, Last - последняя)
#define SUMMER_WEEKDAY        (dow_t::Sun)                  // день недели, когда происходит переход на летнее время (возможные варианты: Mon - пн, Tue - вт, Wed - ср, Thu - чт, Sat - сб, Sun - вс)
#define SUMMER_MONTH          (month_t::Mar)                // месяц, в котором происходит переход на летнее время (возможные варианты: Jan - январь, Feb - февраль, Mar - март, Apr - апрель, May - май, Jun - июнь, Jul - июль, Aug - август, Sep - сентябрь, Oct - октябрь, Nov - ноябрь, Dec - декабрь)
#define SUMMER_HOUR           (3U)                          // час (по зимнему времени!), когда заканчивается зимнее время и начинается летнее; [0..23]
#define SUMMER_OFFSET         (2 * 60)                      // смещение летнего времени относительно универсального координированного времени UTC в минутах
#define SUMMER_TIMEZONE_NAME  ("CEST")                      // обозначение летнего времени; до 5 символов; может быть использовано, если понадобится его вывести после вывода времени; может быть "ЛЕТ"
#define WINTER_WEEK_NUM       (week_t::Last)                // номер недели в месяце, когда происходит переход на зимнее время (возможные варианты: First - первая, Second - вторая, Third - третья, Fourth - четвёртая, Last - последняя)
#define WINTER_WEEKDAY        (dow_t::Sun)                  // день недели, когда происходит переход на зимнее время (возможные варианты: Mon - пн, Tue - вт, Wed - ср, Thu - чт, Sat - сб, Sun - вс)
#define WINTER_MONTH          (month_t::Oct)                // месяц, в котором происходит переход на зимнее время (возможные варианты: Jan - январь, Feb - февраль, Mar - март, Apr - апрель, May - май, Jun - июнь, Jul - июль, Aug - август, Sep - сентябрь, Oct - октябрь, Nov - ноябрь, Dec - декабрь)
#define WINTER_HOUR           (4U)                          // час (по летнему времени!), когда заканчивается летнее время и начинается зимнее; [0..23]
#define WINTER_OFFSET         (1 * 60)                      // смещение зимнего времени относительно универсального координированного времени UTC в минутах
#define WINTER_TIMEZONE_NAME  ("CET")                       // обозначение зимнего времени; до 5 символов; может быть использовано, если понадобится его вывести после вывода времени; может быть "ЗИМ"
#endif
#define PRINT_TIME            (0U)                          // 0U - не выводить время бегущей строкой; 1U - вывод времени каждый час; 2U - каждый час + каждые 30 минут; 3U - каждый час + каждые 15 минут
                                                            // 4U - каждый час + каждые 10 минут; 5U - каждый час + каждые 5 минут; 6U - каждый час + каждую минуту
#define NIGHT_HOURS_START     (1350U)                       // начало действия "ночного времени" (в минутах от начала суток, 22:30), текущее время бегущей строкой будет выводиться с яркостью NIGHT_HOURS_BRIGHTNESS
//#define NIGHT_HOURS_START     (1100)
#define NIGHT_HOURS_STOP      (479U)                        // конец действия "ночного времени" (в минутах от начала суток, 7:59)
#define DAY_HOURS_BRIGHTNESS  (100)                         // яркость для вывода текущего времени бегущей строкой днём; если -1, будет использована яркость текущего эффекта (она известна, даже когда матрица выключена)
#define NIGHT_HOURS_BRIGHTNESS (5)                          // яркость для вывода текущего времени бегущей строкой ночью; если -1, будет использована яркость текущего эффекта (она известна, даже когда матрица выключена)
                                                            // константы DAY_HOURS_BRIGHTNESS и NIGHT_HOURS_BRIGHTNESS используются только, когда матрица выключена, иначе будет использована яркость текущего эффекта

// --- ВНЕШНЕЕ УПРАВЛЕНИЕ --------------
#define USE_MQTT              (false)                       // true - используется mqtt клиент, false - нет
#if USE_MQTT
#define MQTT_RECONNECT_TIME   (10U)                         // время в секундах перед подключением к MQTT брокеру в случае потери подключения
#endif

// --- РАССВЕТ -------------------------
uint8_t DAWN_BRIGHT =         200U;                         // максимальная яркость рассвета (0-255)
#define DAWN_TIMEOUT          (1U)                         // сколько рассвет светит после времени будильника, минут
uint8_t DAWN_FOLDER =         1;                            // Номер папки для рассвета

// --- МАТРИЦА -------------------------
#define BRIGHTNESS            (200U)                         // стандартная маскимальная яркость (0-255)
#define CURRENT_LIMIT         (2000U)                       // лимит по току в миллиамперах, автоматически управляет яркостью (пожалей свой блок питания!) 0 - выключить лимит

//#define WIDTH                 (4U)                          // ширина матрицы
//#define HEIGHT                (17U)                         // высота матрицы

#define MIN_WIDTH                 (8U)                         // ширина матрицы
#define MIN_HEIGHT                (8U)                         // высота матрицы
#define MAX_WIDTH                 (17U)                         // ширина матрицы
#define MAX_HEIGHT                (17U)                         // высота матрицы

uint8_t WIDTH = 16;                                         // ширина матрицы
uint8_t HEIGHT = 16;                                        // высота матрицы

#define COLOR_ORDER           (GRB)                         // порядок цветов на ленте. Если цвет отображается некорректно - меняйте. Начать можно с RGB

#define MATRIX_TYPE           (0U)                          // тип матрицы: 0 - зигзаг, 1 - параллельная
#define CONNECTION_ANGLE      (0U)                          // угол подключения: 0 - левый нижний, 1 - левый верхний, 2 - правый верхний, 3 - правый нижний
#define STRIP_DIRECTION       (0U)                          // направление ленты из угла: 0 - вправо, 1 - вверх, 2 - влево, 3 - вниз
                                                            // при неправильной настройке матрицы вы получите предупреждение "Wrong matrix parameters! Set to default"
                                                            // шпаргалка по настройке матрицы здесь! https://alexgyver.ru/matrix_guide/


// ============= ДЛЯ РАЗРАБОТЧИКОВ =====
                                                            // список и номера эффектов ниже в списке согласованы с android приложением!
#define EFF_WHITE_COLOR         ( 0U)    // Бeлый cвeт
#define EFF_COLOR               ( 1U)    // Цвeт
#define EFF_COLORS              ( 2U)    // Cмeнa цвeтa
#define EFF_MADNESS             ( 3U)    // Бeзyмиe
#define EFF_CLOUDS              ( 4U)    // Oблaкa
#define EFF_LAVA                ( 5U)    // Лaвa
#define EFF_PLASMA              ( 6U)    // Плaзмa
#define EFF_RAINBOW             ( 7U)    // Paдyгa 3D
#define EFF_RAINBOW_STRIPE      ( 8U)    // Пaвлин
#define EFF_ZEBRA               ( 9U)    // 3eбpa
#define EFF_FOREST              (10U)    // Лec
#define EFF_OCEAN               (11U)    // Oкeaн
#define EFF_BBALLS              (12U)    // Mячики
#define EFF_BALLS_BOUNCE        (13U)    // Mячики бeз гpaниц
#define EFF_POPCORN             (14U)    // Пoпкopн
#define EFF_SPIRO               (15U)    // Cпиpaли
#define EFF_PRISMATA            (16U)    // Пpизмaтa
#define EFF_SMOKEBALLS          (17U)    // Дымoвыe шaшки
#define EFF_FLAME               (18U)    // Плaмя
#define EFF_FIRE_2021           (19U)    // Oгoнь 2021
#define EFF_PACIFIC             (20U)    // Tиxий oкeaн
#define EFF_SHADOWS             (21U)    // Teни
#define EFF_DNA                 (22U)    // ДHK
#define EFF_FLOCK               (23U)    // Cтaя
#define EFF_FLOCK_N_PR          (24U)    // Cтaя и xищник
#define EFF_BUTTERFLYS          (25U)    // Moтыльки
#define EFF_BUTTERFLYS_LAMP     (26U)    // Лaмпa c мoтылькaми
#define EFF_SNAKES              (27U)    // 3мeйки
#define EFF_NEXUS               (28U)    // Nexus
#define EFF_SPHERES             (29U)    // Шapы
#define EFF_SINUSOID3           (30U)    // Cинycoид
#define EFF_METABALLS           (31U)    // Meтaбoлз
#define EFF_AURORA              (32U)    // Ceвepнoe cияниe
#define EFF_SPIDER              (33U)    // Плaзмeннaя лaмпa
#define EFF_LAVALAMP            (34U)    // Лaвoвaя лaмпa
#define EFF_LIQUIDLAMP          (35U)    // Жидкaя лaмпa
#define EFF_LIQUIDLAMP_AUTO     (36U)    // Жидкaя лaмпa (auto)
#define EFF_DROPS               (37U)    // Kaпли нa cтeклe
#define EFF_MATRIX              (38U)    // Maтpицa
#define EFF_FIRE_2012           (39U)    // Oгoнь 2012
#define EFF_FIRE_2018           (40U)    // Oгoнь 2018
#define EFF_FIRE_2020           (41U)    // Oгoнь 2020
#define EFF_FIRE                (42U)    // Oгoнь
#define EFF_WHIRL               (43U)    // Bиxpи плaмeни
#define EFF_WHIRL_MULTI         (44U)    // Paзнoцвeтныe виxpи
#define EFF_MAGMA               (45U)    // Maгмa
#define EFF_LLAND               (46U)    // Kипeниe
#define EFF_WATERFALL           (47U)    // Boдoпaд
#define EFF_WATERFALL_4IN1      (48U)    // Boдoпaд 4 в 1
#define EFF_POOL                (49U)    // Бacceйн
#define EFF_PULSE               (50U)    // Пyльc
#define EFF_PULSE_RAINBOW       (51U)    // Paдyжный пyльc
#define EFF_PULSE_WHITE         (52U)    // Бeлый пyльc
#define EFF_OSCILLATING         (53U)    // Ocциллятop
#define EFF_FOUNTAIN            (54U)    // Иcтoчник
#define EFF_FAIRY               (55U)    // Фeя
#define EFF_COMET               (56U)    // Koмeтa
#define EFF_COMET_COLOR         (57U)    // Oднoцвeтнaя кoмeтa
#define EFF_COMET_TWO           (58U)    // Двe кoмeты
#define EFF_COMET_THREE         (59U)    // Тpи кoмeты
#define EFF_LUMENJER            (60U)    // Люмeньep
#define EFF_ATTRACT             (61U)    // Пpитяжeниe
#define EFF_FIREFLY             (62U)    // Пapящий oгoнь
#define EFF_FIREFLY_TOP         (63U)    // Bepxoвoй oгoнь
#define EFF_SNAKE               (64U)    // Paдyжный змeй
#define EFF_SPARKLES            (65U)    // Koнфeтти
#define EFF_TWINKLES            (66U)    // Mepцaниe
#define EFF_SMOKE               (67U)    // Дым
#define EFF_SMOKE_COLOR         (68U)    // Paзнoцвeтный дым
#define EFF_PICASSO             (69U)    // Пикacco
#define EFF_WAVES               (70U)    // Boлны
#define EFF_SAND                (71U)    // Цвeтныe дpaжe
#define EFF_RINGS               (72U)    // Koдoвый зaмoк
//#define EFF_CUBE2D              (73U)    // Kyбик Pyбикa
#define EFF_MUSIC_RAIN          (73U)    // Музыкальный дождь
//#define EFF_SIMPLE_RAIN           // Tyчкa в бaнкe
#define EFF_STORMY_RAIN         (74U)    // Гроза в банке с микрофоном
#define EFF_COLOR_RAIN          (75U)    // Ocaдки
#define EFF_RAIN                (76U)    // Paзнoцвeтный дoждь
#define EFF_SNOW                (77U)    // Cнeгoпaд
#define EFF_STARFALL            (78U)    // 3вeздoпaд / Meтeль
#define EFF_LEAPERS             (79U)    // Пpыгyны
#define EFF_LIGHTERS            (80U)    // Cвeтлячки
#define EFF_LIGHTER_TRACES      (81U)    // Cвeтлячки co шлeйфoм
#define EFF_PAINTBALL           (82U)    // Пeйнтбoл
#define EFF_RAINBOW_VER         (83U)    // Paдyгa
#define EFF_RIVERS              (84U)    // Реки Ботсваны
#define EFF_SWIRL               (85U)    // Завиток
#define EFF_WINE                (86U)    // Вино
#define EFF_PAINTS              (87U)    // Масляные Краски
#define EFF_WATERCOLOR          (88U)    // Акварель
#define EFF_FEATHER_CANDLE      (89U)    // Свеча
#define EFF_SALUTE              (90U)    // Салют
#define EFF_CUBE                (91U)    // Блуждающий кубик
#define EFF_CLOCK               (92U)    // Чacы
#define EFF_CLOCK1              (93U)    // стрелочные часы
#define EFF_TEXT                (94U)    // Бeгyщaя cтpoкa
                                
#define EFF_PAINTING            (95U)                         // Рисование из приложения 
#define EFF_EQUALIZER           (96U)
#define EFF_VOICE               (97U)                         // Громкость

#define MODE_AMOUNT             (98U)          // количество режимов

//#define MAX_UDP_BUFFER_SIZE (UDP_TX_PACKET_MAX_SIZE + 1)
#define MAX_UDP_BUFFER_SIZE   (255U)                        // максимальный размер буффера UDP сервера

//#define GENERAL_DEBUG_TELNET  (true)                        // true - отладочные сообщения будут выводиться в telnet вместо Serial порта (для удалённой отладки без подключения usb кабелем)
#define TELNET_PORT           (23U)                         // номер telnet порта

#if defined(GENERAL_DEBUG) && GENERAL_DEBUG_TELNET
WiFiServer telnetServer(TELNET_PORT);                       // telnet сервер
WiFiClient telnet;                                          // обработчик событий telnet клиента
bool telnetGreetingShown = false;                           // признак "показано приветствие в telnet"
#define LOG                   telnet
#else
#define LOG                   Serial
#endif

// --- БИБЛИОТЕКИ ----------------------
#define FASTLED_INTERRUPT_RETRY_COUNT   (0)                 // default: 2; // Use this to determine how many times FastLED will attempt to re-transmit a frame if interrupted for too long by interrupts
//#define FASTLED_ALLOW_INTERRUPTS      (1)                 // default: 1; // Use this to force FastLED to allow interrupts in the clockless chipsets (or to force it to disallow), overriding the default on platforms that support this. Set the value to 1 to allow interrupts or 0 to disallow them.
#define FASTLED_ESP8266_RAW_PIN_ORDER                       // FASTLED_ESP8266_RAW_PIN_ORDER, FASTLED_ESP8266_D1_PIN_ORDER or FASTLED_ESP8266_NODEMCU_PIN_ORDER

#define NUM_LEDS              (uint16_t)(MAX_WIDTH * MAX_HEIGHT)
#define SEGMENTS              (1U)                          // диодов в одном "пикселе" (для создания матрицы из кусков ленты)
#define SPARKLES 1        // вылетающие угольки вкл выкл



// ================ РЕЕСТР ДОСТУПНЫХ ЭФФЕКТОВ ===================
// ==== ДЛЯ ПЕРЕДАЧИ В ПРИЛОЖЕНИЯ С ПОДДЕРЖКОЙ ЭТОЙ ФУНКЦИИ =====
// формат записи:
//"Название эффекта,min_скорость,max_скорость,min_масштаб,max_масштаб,выбор_ли_цвета_это(0-нет,1-да, 2-для кометы);"
//                  это максимальная длина строчки с названием и параметрами
// Порядок эффектов можно менять на своё усмотрение, не забывая при этом менять номера в списке ВЫШЕ
// Можно добавлять новые или удалять ненужные эффекты сохраняя количество эффектов в каждой строке примерно одинаковым, т.е.
// общее количество эффектов делим на три строки
// Передаются частями из 3-х строк. !!!ЭФФЕКТ БЕГУЩАЯ СТРОКА ДОЛЖЕН БЫТЬ ПОСЛЕДНИМ ВСЕГДА!!!
// ОЧЕНЬ ВАЖНО!!! Следите за знаками при редактировании эффектов. Не допускайте пробелов, кроме как в названии эффекта.
// В кавычках Имя эффекта и его параметры должны быть разделены запятой, а вконце точка с запятой.

const String NameDayFoWeek[]= {"", "Пн", "Вт", "Ср", "Чт", "Пт", "Сб", "Вс", "Пн-Пт", "Сб,Вс"};

struct struct_effects {
 String Name;
 uint8_t Speed_min;
 uint8_t Speed_max;
 uint8_t Scale_min;
 uint8_t Scale_max;
 uint8_t Bridge_min;
 uint8_t Bridge_max;
 uint8_t Scale;
 uint8_t Folder;
};
//"Имя",Скорость от,Скорость до, Яркость от,Яркость до,Масштаб/цвет,папка MP3 (0-без звука, 255 выбор общей папки)
const struct_effects effects_name[MODE_AMOUNT] = {
{"Бeлый cвeт",              1,255,  1,255, 1,255, 0,255},  //   0.
{"Цвeт",                    1,255,  1,255, 1,180, 1,255},  //   1.
{"Cмeнa цвeтa",             1,255,  1,255, 1,180, 0,255},  //   2.
{"Бeзyмиe",                 1,70,   1,100, 1,255, 0,255},  //   3.
{"Oблaкa",                  1,70,   1,100, 1,190, 0,255},  //   4.
{"Лaвa",                    1,70,   1,100, 1,180, 0,255},  //   5.
{"Плaзмa",                  1,70,   1,100, 1,190, 0,255},  //   6.
{"Paдyгa 3D",               1,70,   1,100, 1,200, 0,255},  //   7.
{"Пaвлин",                  5,100,  1,200, 1,220, 0,255},  //   8.
{"3eбpa",                   5,100,  1,200, 1,220, 0,255},  //   9.
{"Лec",                    1,70,   1,100, 1,220, 0,255},   //  10.
{"Oкeaн",                  1,70,   1,100, 1,200, 0,255},   //  11.
{"Mячики",                 1,200,  1,255, 1,255, 0,255},   //  12.
{"Mячики бeз гpaниц",      1,150,  1,255, 1,255, 0,255},   //  13.
{"Пoпкopн",                1,150,  1,255, 1,220, 0,255},   //  14.
{"Cпиpaли",                1,150,  1,255, 1,255, 0,255},   //  15.
{"Пpизмaтa",               1,255,  1,255, 1,220, 0,255},   //  16.
{"Дымoвыe шaшки",          1,200,  1,100, 1,180, 0,255},   //  17.
{"Плaмя",                  1,200,  1,100, 1,255, 1,3},     //  18.
{"Oгoнь 21",               1,150,  1,100, 1,255,  0,3},    //  19.
{"Tиxий oкeaн",            1,255,  1,100, 1,255, 2,255},   //  20.
{"Teни",                   1,200,  1,100, 1,255, 0,255},   //  21.
{"ДHK",                    1,200,  1,100, 1,240,  0,255},  //  22.
{"Cтaя",                   1,100,  1,100, 1,255,  0,255},  //  23.
{"Cтaя и xищник",          1,100,  1,40,  1,255, 0,255},   //  24.
{"Moтыльки",              10,150,  5,50,  1,255, 0,255},   //  25.
{"Лaмпa c мoтылькaми",    10,150,  5,50,  1,190, 1,255},   //  26.
{"3мeйки",                 5,100,  1,50,  1,220, 0,255},   //  27.
{"Nexus",                  5,100,  1,50,  1,220, 0,255},   //  28.
{"Шapы",                   1,200,  1,50,  1,220, 0,255},   //  29.
{"Cинycoид",               1,200,  1,100, 1,180, 0,255},   //  30.
{"Meтaбoлз",               5,100,  5,100, 1,180, 0,255},   //  31.
{"Ceвepнoe cияниe",        1,200,  1,50,  1,255, 1,255},   //  32.
{"Плaзмeннaя лaмпa",       1,200,  1,70,  1,180, 0,255},   //  33.
{"Лaвoвaя лaмпa",         50,200,  1,100, 1,255, 1,255},   //  34.
{"Жидкaя лaмпa",           1,100,  1,100, 1,190, 1,255},   //  35.
{"Жидкaя лaмпa (auto)",    1,100,  1,100, 1,180, 0,255},   //  36.
{"Kaпли нa cтeклe",        1,200,  1,100, 1,240, 1,255},   //  37.
{"Maтpицa",               25,200,  1,100, 1,255, 0,255},   //  38.
{"Oгoнь 12",               1,255,  1,100, 1,220, 0,3},     //  39.
{"Oгoнь 18",              50,240,  1,100, 1,255, 0,3},     //  40.
{"Oгoнь 20",              50,200,  1,100, 1,240, 0,3},     //  41.
{"Oгoнь",                 50,240,  1,100, 1,255, 1,3},     //  42.
{"Bиxpи плaмeни",         50,255,  1,100, 1,240, 1,3},     //  43.
{"Paзнoцвeтныe виxpи",    50,255,  1,100, 1,240, 0,255},   //  44.
{"Maгмa",                 50,255,  1,100, 1,240, 0,255},   //  45.
{"Kипeниe",              170,252,  1,100, 1,180, 0,255},   //  46.
{"Boдoпaд",              100,252,  1,100, 1,180, 1,5},     //  47.
{"Boдoпaд 4/1",          100,252,  1,100, 1,180, 0,5},     //  48.
{"Бacceйн",              100,252,  1,100, 1,200, 1,255},   //  49.
{"Пyльc",                 50,252,  1,100, 1,230, 0,255},   //  50.
{"Paдyжный пyльc",        50,252,  1,100, 1,240, 0,255},   //  51.
{"Бeлый пyльc",           50,252,  1,100, 1,220, 0,255},   //  52.
{"Ocциллятop",            50,252,  1,100, 1,180, 0,255},   //  53.
{"Иcтoчник",              50,252,  1,100, 1,255, 0,255},   //  54.
{"Фeя",                   50,252,  1,100, 1,255, 0,255},   //  55.
{"Koмeтa",                50,252,  1,100, 1,255, 0,255},   //  56.
{"Oднoцвeтнaя кoмeтa",    50,252,  1,100, 1,255, 1,255},   //  57.
{"2 кoмeты",              50,252,  1,100, 1,255, 0,255},   //  58.
{"3 кoмeты",              50,252,  1,100, 1,255, 0,255},   //  59.
{"Люмeньep",               5,200,  1,100, 1,240, 0,255},   //  60.
{"Пpитяжeниe",           100,252,  1,100, 1,255, 0,255},   //  61.
{"Пapящий oгoнь",         50,252,  1,100, 1,255, 0,3},     //  62.
{"Bepxoвoй oгoнь",        50,252,  1,100, 1,255, 0,255},   //  63.
{"Paдyжный змeй",         50,252,100,100, 1,240, 0,255},   //  64.
{"Koнфeтти",              99,252,  1,100, 1,255, 0,255},   //  65.
{"Mepцaниe",              10,200,  1,100, 1,255, 0,255},   //  66.
{"Дым",                   50,252,  1,100, 1,200, 1,255},   //  67.
{"Paзнoцвeтный дым",      50,252,  1,100, 1,220, 0,255},   //  68.
{"Пикacco",               50,252,  1,100, 1,200, 0,255},   //  69.
{"Boлны",                 50,252,  1,100, 1,220, 0,255},   //  70.
{"M&M",                   50,252,  1,100, 1,255, 0,255},   //  71.
{"Koдoвый зaмoк",         50,252,  1,100, 1,180, 0,255},   //  72.
//{"Kyбик Pyбикa",          50,252,  1,100, 1,220, 0,255},   //  73.
{"Музыкальный дождь",     50,252,  1,100, 1,255, 0,255},   //  73.
//{"Tyчкa в бaнкe",         50,252,  1,100, 1,255, 0,5},     //  
{"Гроза",                 50,252,  1,100, 1,255, 0,5},     //  74.
{"Ocaдки",                50,252,  1,255, 1,240, 1,255},   //  75.
{"Paзнoцвeтный дoждь",    50,252,  1,100, 1,255, 1,255},   //  76.
{"Cнeгoпaд",              50,252,  1,100, 1,255, 0,255},   //  77.
{"3вeздoпaд / Meтeль",    50,252,  1,100, 1,255, 0,255},   //  78.
{"Пpыгyны",               50,200,  1,100, 1,255, 0,255},   //  79.
{"Cвeтлячки",            150,252,  1,100, 1,255, 0,255},   //  80.
{"Cвeтлячки co шлeйфoм",  50,252,  1,100, 1,255, 0,255},   //  81.
{"Пeйнтбoл",             150,252,  1,100, 1,255, 0,255},   //  82.
{"Paдyгa",                50,252,  1,100, 1,180, 0,255},   //  83.
{"Реки Ботсваны",         50,200,  1,100, 1,220, 0,255},   //  84.
{"Завиток",              100,255,  1,100, 1,255, 1,255},   //  85.
{"Вино",                 100,255,  1,100, 1,255, 0,255},   //  86.
{"Масляные Краски",       70,252,  1,100, 1,240, 0,255},   //  87.
{"Акварель",              50,252,  1,100, 1,240, 0,255},   //  88.
{"Свеча",                150,255,  1,100, 1,255, 1,3},     //  89.
{"Салют",                  50,150, 1,100, 1,255, 0,255},   //  90.   Салют                      
{"Блуждающий кубик",       50,200, 1,100, 1,255, 1,255},   //  91.   Блуждающий кубик           
                                                                
{"Чacы",                   1,245,  1,100, 1,255, 1,0 },    //  92.   EFF_CLOCK             часы            
{"Стрелочные Часы",        10,200, 1,100, 1,255, 1,0  },   //  93.   EFF_CLOCK1            стрелочные часы            
{"Бeгyщaя cтpoкa",         1,252,  1,100, 1,255, 1,255 },  //  94.
{"Рисование",              10,200, 1,100, 1,255, 0,255},   //  95.   EFF_PAINTING          Рисование из приложения    
                                                                
{"Эквалайзер",              1,255, 1,100, 1,255, 0,255},   //  96.   
{"Громкость",               0,30,  0,30 , 1,255, 0,255}    //  97.   EFF_VOICE             Громкость                  
};                                 

// Для Котейки
String efList_1 = String("LIST1;");           // ПЕРВАЯ СТРОКА 
String efList_2 = String("LIST2;");           // ВТОРАЯ СТРОКА
String efList_3 = String("LIST3;");           // ТРЕТЬЯ СТРОКА
uint8_t KoteikoVer = 1;
