## Где взять
На данный момент "приложением" GyverHub можно пользоваться:
- На официальном сайте: [HTTP версия](http://hub.gyver.ru/), [HTTPS версия](https://hub.gyver.ru/), зеркало на [GitHub Pages](https://gyverlibs.github.io/GyverHub) (только HTTPS)
- Android приложение: [Google Play](https://play.google.com/store/apps/details?id=ru.alexgyver.GyverHub), [скачать APK](https://github.com/GyverLibs/GyverHub/raw/main/app/GyverHub.apk)
- Сайт можно установить как веб-приложение (PWA) на любое устройство (Android/iOS/Windows/Linux...)
- Можно [скачать сайт](https://github.com/GyverLibs/GyverHub/raw/main/web/local/GyverHub.html) (правой кнопкой - *сохранить ссылку как*) и открыть его в браузере (localhost)
- Из памяти ESP8266/32
- Из [Телеграм-бота](https://t.me/GyverHUB_bot)

### Режимы в разных версиях
| Источник / режим | WS    | MQTT | Serial | Bluetooth |
|------------------|-------|------|--------|-----------|
| Android          |   ✔   |   ✔  |       |           |
| ESP              |   ✔   |      |        |           |
| Telegram         |       |   ✔  |        |           |
| Сайт HTTPS       |       |   ✔  |        |           |
| Сайт HTTP        |   ✔*  |   ✔  |        |           |
| PWA HTTPS        |       |   ✔   |       |           |
| PWA HTTP**       |   ✔*  |   ✔  |        |           |
| localhost        |   ✔   |   ✔  |        |           |

- \* - Режим WS работает после [настройки браузера]()
- \*\* - Для установки PWA с HTTP версии сайта нужно [добавить сайт в список доверенных]()

## Android приложение
- Начиная примерно с 10 версии Android при включенной тёмной теме в приложении искажаются цвета. Отключите тёмную тему для приложения (*Настройки/Экран/Параметры тёмного режима*, снять галочку около GyverHub)
- На Android младше 10 версии не работает WebSocket (временно)
- Если нужно найти устройство по WS при смене точки WiFi, то нужно запускать приложение после подключения к другой точке, иначе приложение не сможет корректно получить свой IP адрес, который нужен для поиска. Пример: esp в режиме AP. Сначала подключаемся к точке, потом запускаем приложение

## Запуск из ESP
Сайт может работать из памяти ESP8266/32, в библиотеке для этого уже настроен веб-сервер. Если зайти на IP адрес ESP в локальной сети - GyverHub откроется из памяти ESP, точно так же как в библиотеке [GyverPortal](https://github.com/GyverLibs/GyverPortal).

### Из файлов
Для работы сайта нужно загрузить в файловую систему esp файлы из `/web/esp/` в папке с библиотекой. Это можно сделать через плагин для Arduino IDE, через встроенный инструмент в PlatformIO, а также через файловый менеджер в приложении GyverHub. Файлы должны располагаться в памяти по пути:
- `/hub/index.html.gz`
- `/hub/script.js.gz`
- `/hub/style.css.gz`

### Из программы
Если объявить дефайн `GH_INCLUDE_PORTAL` перед подключением библиотеки
```cpp
#define GH_INCLUDE_PORTAL
#include <GyverHub.h>
```
то необходимые для работы сайта файлы будут включены в программу в бинарном виде и прибавят к весу прошивки около 35 кБ. Больше ничего делать не нужно, GyverHub доступен по IP адресу ESP в локальной сети.

### Особенности ESP версии
- Убраны модули MQTT, Bluetooth, Serial
- Убрана возможность установить как веб-приложение
- Убран Test билдер
- Вшиты только системные иконки

## Сайт GyverHub
### Настройка для режима WS
Современные браузеры запрещают слать запросы на локальные адреса "в целях безопасности". Нужно:
- Отключить настройку **Block insecure private network requests** в браузере, для этого перейти по адресу `chrome://flags/#block-insecure-private-network-requests` (адрес настройки для вашей версии браузера будет указан в настройках GyverHub)
- Зайти на [http версию](http://hub.gyver.ru/) сайта GyverHub: *на https версии режим WS работать не будет*
- Указать локальный IP адрес устройства, на котором открыт сайт (телефон, ПК) в поле *My IP*, цифра **1** на картинке ниже, это нужно для поиска ESP в той же сети:
    - Достаточно указать адрес основного шлюза (адрес роутера), у большинства роутеров это будет `192.168.1.1`. Можно посмотреть в настройках роутера
    - Можно узнать адрес средствами сервиса GyverHub (кнопка обновить в окошке ввода IP адреса, цифра **2** на картинке ниже), для этого нужно опять же отключить настройку **Anonymize local IPs exposed by WebRTC** в браузере: `chrome://flags/#enable-webrtc-hide-local-ips-with-mdns`

![image](https://user-images.githubusercontent.com/84599917/236942206-83a337ff-d388-4bd2-80ab-e9f573952d53.png)  
![image](https://user-images.githubusercontent.com/84599917/236978360-0ae4d8f7-8b98-4265-8373-db36db41a1f3.png)

## Веб-приложение (PWA)
### HTTPS версия
Сайт GyverHub можно "установить" на любое устройство (Windows, Linux, Android, iOS...) как веб-приложение (PWA). Браузер сам предложит вам это сделать на [https](https://hub.gyver.ru/) версии сайта. На этой версии будет работать MQTT, Serial, Bluetooth, но WS работать не будет:

![image](https://user-images.githubusercontent.com/84599917/236978702-d6c25585-f645-4ed9-9407-4a7effcd5d50.png)

### HTTP версия
Для установки [http](http://hub.gyver.ru/) версии приложения нужно включить настройку `chrome://flags/#unsafely-treat-insecure-origin-as-secure` (адрес настройки для вашего браузера указан в настройках GyverHub) и добавить `http://hub.gyver.ru` в список доверенных сайтов. После этого можно будет установить PWA приложение по кнопке HTTP и пользоваться им в локальном режиме:

![image](https://user-images.githubusercontent.com/84599917/236947391-f645347d-ed6c-4911-a8ce-fb8fb1518864.png)  
![image](https://user-images.githubusercontent.com/84599917/236947679-7d7f8fe6-c71e-4d55-8717-e63034e11267.png)  

## Экран устройства
На главном экране устройства доступны:
1. Обновить интерфейс (запросить с устройства)
2. Файловый менеджер
3. Экран информации

![image](https://user-images.githubusercontent.com/84599917/236951402-bfa84a76-3e66-4e13-8b43-3075530677c5.png)

## Экран информации
На экране информации отображается различная информация с устройства, а также доступны некоторые действия:
1. Открыть/закрыть консоль (см. ниже)
2. Удалить устройство из списка
3. Открыть IP адрес устройства в новой вкладке
4. Перезагрузить устройство
5. Убрать стиль "виджетов" (см. ниже)

![image](https://user-images.githubusercontent.com/84599917/236951741-5facff8d-7204-48ff-9153-18eaf9ea6ee4.png)

### Стиль виджетов
По умолчанию виджеты отображаются как виджеты. Можно отключить этот стиль, тогда все компоненты будут выстроены вертикальным списком. Это позволяет сделать например широкий интерфейс для большого экрана (увеличить ширину интерфейса в основных настройках приложения), а со смартфона использовать это же устройство без виджетов.
![image](https://user-images.githubusercontent.com/84599917/236952312-ae8cedc6-7aad-4b9b-8d8b-7c043440b33c.png)

### Консоль
На экране информации есть кнопка, переключающая консоль. Также включить и выключить консоль можно на клавишу `~`. Консоль позволяет отправлять текст на устройство и принимать текст с него в целях отладки.

![image](https://user-images.githubusercontent.com/84599917/236951294-7c9b8473-6537-46a7-bead-1465e303a1c3.png)

В программе достаточно подключить обработчик, а для отправки обратно использовать `print()` в любом месте программы (в области видимости объекта GyverHub)
```cpp
hub.onCLI([](String& s) {
    Serial.println(s);  // вывести в порт
    hub.print(s);       // отправить эхо
});
```

## Файловый менеджер
1. Загрузить файл на устройство по указанному пути
2. Обновление прошивки. Поддерживаются файлы `.bin` и `.gz`. Примечание - для загрузки сжатых .gz файлов нужно сделать `#define ATOMIC_FS_UPDATE` в начале кода прошивки
3. Обновление файловой системы. Поддерживаются файлы `.bin` и `.gz`. Примечание - для загрузки сжатых .gz файлов нужно сделать `#define ATOMIC_FS_UPDATE` в начале кода прошивки
4. Папка. При нажатии путь к папке будет отображён в пути Upload для загрузки файлов в эту папку
5. Файлы. При нажатии на файл откроется меню файла

![image](https://user-images.githubusercontent.com/84599917/236975684-b9d90237-7b61-4f6e-9990-2351031e46fa.png)

### Меню файла
1. Переименовать файл. Это также может перенести его в "другую папку" (в файловой системе ESPxxx нет папок, это просто путь)
2. Удалить файл
3. Скачать файл. Файл будет загружен в оперативную память, после чего появятся ещё две кнопки
4. Сохранить файл
5. Открыть файл в новой вкладке

![image](https://user-images.githubusercontent.com/84599917/236976165-d1f1b237-8c76-412a-ac25-e1c147d195c5.png)  
![image](https://user-images.githubusercontent.com/84599917/236976504-4645c154-fe6a-4937-a395-f8ebbcd63e39.png)

## Экран настроек

### Блок поиска
1. Поиск устройств
2. Очистить список устройств
3. Префикс сети. Только английские буквы, цифры, без пробелов

![image](https://user-images.githubusercontent.com/84599917/236977243-da9bd231-e8eb-466f-b4ef-efe6ec1fcb42.png)

### Прочее
1. Тёмная тема
2. Цветовая схема
3. Ширина колонки интерфейса в пикселях
4. Использовать ПИН-код на открытие приложения
5. ПИН код (только цифры)
6. Импорт и экспорт настроек для переноса между приложениями. *Примечание: Export - настройки будут скопированы в буфер обмена в виде текстового шифра. Его можно передать на другое устройство, там снова скопировать в буфер обмена, и при нажатии на кнопку Import настройки вставятся и применятся.*

![image](https://user-images.githubusercontent.com/84599917/236976667-d4ba9b90-e4e6-4084-9d5c-07ea9aecb85d.png)