// структура для хранения данных
struct Data {
  char val = 'H';
  char str[15] = "ello kitty!";
};
Data data;  // переменная, с которой мы работаем в программе

#include <FSManager.h>  // подключаем либу
FSManager memory(data,"data.dat"); // Связываем нашу переменную с файлом "data.dat"

// можно задать таймаут обновления, по умолч. 5 секунд (5000мс)
//FSManager memory(data, "data.dat", 1000);

void setup() {
  Serial.begin(115200);

  success = SPIFFS.begin(); // подключаем файловую систему 
  /*
    Запускаем менеджер, 
    - Проверяем наличие фала, если файл отсутствует, записываем значение переменной
    - Иначе считываем
  */
  byte stat = memory.begin();
 
  /*
    Коды возврата:
    0 - Файл существует, данные прочитаны из файла
    1 - Файл отсутствует (первый запуск), данные записаны в файл
  */
  Serial.println(stat);
  if (!stat) {
     Serial.print(data.val);
     Serial.println(data.str);
  }
  data.val = random(33,128);     // изменим данные в переменной на случайный символ
  memory.update();    // отложим обновление

  // примечание: Для каждого блока (переменной) используется отдельный файл
}

void loop() {
  // в лупе вызываем tick(), в нём по таймеру произойдёт обновление
  // функция вернёт true, когда это случится
  if (memory.tick()) Serial.println("Updated!");


 
  delay(1000);    // чилим
}
