void parseUDP()
{
  int32_t packetSize = Udp.parsePacket();

  if (packetSize)
  {
    int16_t n = Udp.read(packetBuffer, MAX_UDP_BUFFER_SIZE);
    packetBuffer[n] = '\0';
    strcpy(inputBuffer, packetBuffer);
    if (Udp.remoteIP() == WiFi.localIP()) return; 
    DEBUG(F("Inbound UDP packet: "));
    DEBUGLN(inputBuffer);
    String strBuffer=String(inputBuffer);
    String strCommand=getValue(strBuffer,' ',0);
    DEBUG(F("Command: "));
    DEBUGLN(strCommand);
    
//----------------------------------
    if (strCommand=="DISCOVER") {
       Udp.beginPacket(Udp.remoteIP(), Udp.remotePort());
       char send_udp[25];
       sprintf_P(send_udp, (const char *)F(DISCOVER), WiFi.localIP()[0], WiFi.localIP()[1], WiFi.localIP()[2], WiFi.localIP()[3], ESP_UDP_PORT);
       Udp.write(send_udp);
       Udp.endPacket();
    }
//----------------------------------
    if (!strncmp_P(inputBuffer, PSTR("GET"), 3)) reply_GET_UDP();
//----------------------------------
    if (strCommand=="P_ON") {
      rele=true;
      reply_GET_UDP();
    }
//----------------------------------
    if (strCommand=="P_OFF") {
      rele=false;
      reply_GET_UDP();
    }
//----------------------------------
    if (strCommand=="ALARM") {
     String argBuffer=getValue(strBuffer,' ',1);
     int i=argBuffer.toInt();
     if (i<MAX_ALARMS) {
       argBuffer=getValue(strBuffer,' ',2);
       alarms[i].on_off=(argBuffer.toInt()==1);
       argBuffer=getValue(strBuffer,' ',3);
       alarms[i].cmd=(argBuffer.toInt()==1);
       argBuffer=getValue(strBuffer,' ',4);
       String strh=getValue(argBuffer,':',0);
       String strm=getValue(argBuffer,':',1);
       alarms[i].alarm_time=(strh.toInt()*60+strm.toInt())*60;
       argBuffer=getValue(strBuffer,' ',5);

       FOR_j(0,7) {
        if (argBuffer[j]=='1') alarms[i].flags.set(j,1);
           else alarms[i].flags.set(j,0);
       }
       hub.sendUpdate("on_off"+String(i), String(alarms[i].on_off));
       hub.sendUpdate("cmd"+String(i), String(alarms[i].cmd));
       hub.sendUpdate("alarm"+String(i), String(alarms[i].alarm_time));
       hub.sendUpdate("flag"+String(i), String(alarms[i].flags.flags));
       reply_GET_UDP();
       eeprom_flag=true;
     }
    }
  }
}


//----------------------------------
void reply_GET_UDP() {
   Udp.beginPacket(Udp.remoteIP(), Udp.remotePort());
   char send_udp[25];
   sprintf_P(send_udp, (const char *)F("CURR 0 0 0 0 %d 0 0 0 0 %d:%d:00 0"), rele,hour,minute);
   Udp.write(send_udp);
   Udp.endPacket();
}

//----------------------------------
String getValue(String data, char separator, int index)
{
    int found = 0;
    int strIndex[] = {0, -1};
    int maxIndex = data.length()-1;
    for(int i=0; i<=maxIndex && found<=index; i++){
      if(data.charAt(i)==separator || i==maxIndex){
          found++;
          strIndex[0] = strIndex[1]+1;
          strIndex[1] = (i == maxIndex) ? i+1 : i;
      }
    }
    return found>index ? data.substring(strIndex[0], strIndex[1]) : "";
}
