void parseUDP()
{
  int32_t packetSize = Udp.parsePacket();
  char buff[MAX_UDP_BUFFER_SIZE], *endToken = NULL;

  if (packetSize)
  {
    int16_t n = Udp.read(packetBuffer, MAX_UDP_BUFFER_SIZE);
    packetBuffer[n] = '\0';
    strcpy(inputBuffer, packetBuffer);
    if (Udp.remoteIP() == WiFi.localIP()) return; 
    Serial.print(F("Inbound UDP packet: "));
    Serial.println(inputBuffer);
    String strBuffer=String(inputBuffer);
    String strCommand=getValue(strBuffer,' ',0);
    Serial.print(F("Command: "));
    Serial.println(strCommand);
    
//----------------------------------
    if (strCommand=="DISCOVER") {
       Udp.beginPacket(Udp.remoteIP(), Udp.remotePort());
       char send_udp[25];
       sprintf_P(send_udp, (const char *)F(DISCOVER), WiFi.localIP()[0], WiFi.localIP()[1], WiFi.localIP()[2], WiFi.localIP()[3], ESP_UDP_PORT);
       Udp.write(send_udp);
       Udp.endPacket();
    }
//----------------------------------
    if (!strncmp_P(inputBuffer, PSTR("GET"), 3)) reply_GET_UDP();
//----------------------------------
    if (strCommand=="P_ON") {
      ONflag=true;
      hub_update();
      reply_GET_UDP();
    }
//----------------------------------
    if (strCommand=="P_OFF") {
      ONflag=false;
      hub_update();
      reply_GET_UDP();
    }
//----------------------------------
    if (!strncmp_P(inputBuffer, PSTR("EFF"), 3)) {
      memcpy(buff, &inputBuffer[3], strlen(inputBuffer));   // взять подстроку, состоящую последних символов строки inputBuffer, начиная с символа 4
      EFFECT = (uint8_t)atoi(buff);
      if (EFFECT>MAX_EFFECT) EFFECT=0;
      hub_update();
      reply_GET_UDP();
    }
//----------------------------------
    if (!strncmp_P(inputBuffer, PSTR("BRI"), 3)) {
      memcpy(buff, &inputBuffer[3], strlen(inputBuffer));   // взять подстроку, состоящую последних символов строки inputBuffer, начиная с символа 4
      MAX_BRIGHT = (uint8_t)atoi(buff);
      hub_update();
      reply_GET_UDP();
    }
//----------------------------------
    if (!strncmp_P(inputBuffer, PSTR("SPD"), 3)) {
      memcpy(buff, &inputBuffer[3], strlen(inputBuffer));   // взять подстроку, состоящую последних символов строки inputBuffer, начиная с символа 4
      FIRE_DELAY = 255-(uint8_t)atoi(buff);
      hub_update();
      reply_GET_UDP();
    }
//----------------------------------
    if (!strncmp_P(inputBuffer, PSTR("SCA"), 3)) {
      memcpy(buff, &inputBuffer[3], strlen(inputBuffer));   // взять подстроку, состоящую последних символов строки inputBuffer, начиная с символа 4
      HUE_START = (uint8_t)atoi(buff);
      hub_update();
      reply_GET_UDP();
    }
//----------------------------------
  }
}
// END parseUDP()

//----------------------------------
void reply_GET_UDP() {
   Udp.beginPacket(Udp.remoteIP(), Udp.remotePort());
   char send_udp[25];
   sprintf_P(send_udp, (const char *)F("CURR %d %d %d %d %d 0 0 0 0 %d:%d:00 0"),
   EFFECT, MAX_BRIGHT, 255-FIRE_DELAY, HUE_START, ONflag, hour, minute);
   Udp.write(send_udp);
   Udp.endPacket();
}

//----------------------------------
String getValue(String data, char separator, int index)
{
    int found = 0;
    int strIndex[] = {0, -1};
    int maxIndex = data.length()-1;
    for(int i=0; i<=maxIndex && found<=index; i++){
      if(data.charAt(i)==separator || i==maxIndex){
          found++;
          strIndex[0] = strIndex[1]+1;
          strIndex[1] = (i == maxIndex) ? i+1 : i;
      }
    }
    return found>index ? data.substring(strIndex[0], strIndex[1]) : "";
}
