//Имя и адрес точки доступа
#define AP_SSID "***********"
#define AP_PASS "***********"
#define DI_PIN          2            // пин, к которому подключена лента GPIO2
#define IR_PIN          0            // IR Датчик       GPIO0
#define ESP_UDP_PORT    (8888U)      // номер порта, который будет "слушать" UDP сервер во время работы лампы как в режиме WiFi точки доступа, так и в режиме WiFi клиента (лучше не менять)
#define MAX_UDP_BUFFER_SIZE   (255U) // максимальный размер буффера UDP сервера

#define NUM_LAMP  8                  // Число фонариков
#define LAMP_LEDS 8                  // Число светодиодов в фонарике
#define MAX_EFFECT 26                // Максимальное количество эффектов 
#define col_alarms 15                //


#define WIDTH NUM_LAMP
#define HEIGHT LAMP_LEDS
#define NUM_LEDS NUM_LAMP*LAMP_LEDS  // число светодиодов в ленте

#define TYPE_LED_2811        // 2811 - WS2811 12V при использовании WS2812 5V закоментировать
#define CURRENT_LIMIT 1000    // лимит по току в миллиамперах, автоматически управляет яркостью (пожалей свой блок питания!) 0 - выключить лимит

#define DISCOVER "IP %d.%d.%d.%d:%d:Crystall_2"

//#define IP_STATIC                        // Если нужен статический IP, раскоментируйте

#if defined (IP_STATIC)
IPAddress ip(192,168,100,220);  //Node static IP
IPAddress gateway(192,168,100,1);
IPAddress subnet(255,255,255,0);
#endif

//WiFiServer server(80);

char packetBuffer[MAX_UDP_BUFFER_SIZE];                     // buffer to hold incoming packet
char inputBuffer[MAX_UDP_BUFFER_SIZE];

//EEManager EEwifi(portalCfg);
IPAddress myIP;
GyverHub hub("MyDevices", "Гирлянда", "💥");

IRrecv irrecv(IR_PIN);

decode_results results;
uint64_t IR_last_press;
uint64_t IR_press;
String IR_str="IR";
bool pressed;
int WiFiRelalmode;

uint8_t counter = 0;

const long utcOffsetInSeconds = 10800;

CRGB leds[NUM_LEDS];  // создаём ленту

uint16_t localPort = ESP_UDP_PORT;

WiFiUDP Udp;
WiFiUDP ntpUDP;

uint32_t timer_off = 0;      // таймер для автоматического отключения
byte power_on=0;              // Включено 
bool power_on_hub=false;
boolean ONflag = false;
boolean OFFflag = true;
int hour = 1;
int minute = 0;
int dayofweek=0;

uint64_t ntp_update_time=0;

NTPClient timeClient(ntpUDP, "pool.ntp.org", utcOffsetInSeconds);
bool eeprom_flag=false;
String serial_str;


// настройки пламени
#define HUE_GAP 21      // заброс по hue
#define HUE_COEF 0.7    // коэффициент цвета огня (чем больше - тем дальше заброс по цвету)
#define SMOOTH_K 0.15   // коэффициент плавности огня

uint8_t FIRE_STEP = 5;     // шаг огня 15
uint8_t HUE_START = 0;     // начальный цвет огня (0 красный, 80 зелёный, 140 молния, 190 розовый)
uint8_t MIN_BRIGHT = 70;   // мин. яркость огня 70
uint8_t MAX_BRIGHT = 255;  // макс. яркость огня 255
uint8_t MIN_SAT = 245;     // мин. насыщенность
uint8_t MAX_SAT = 255;     // макс. насыщенность
uint8_t FIRE_DELAY = 10;   // макс. насыщенность
uint8_t EFFECT=0;          // эффект
uint8_t SHOW_EFFECT=1;     // эффект
uint8_t AUTO_OFF = 5;      // Автоотключение

bool loadingFlag = true;


class cl_alarm {
  public:
    bool on_off=false;
    uint32_t alarm_time=0;
    uint16_t alarm_action=0;
    GHflags flags;
    void alarm_start(uint8_t h,uint8_t m);
    void alarm_set(uint8_t h,uint8_t m);
    
// 0 выключить лампу
// 10 выключить автоотключение
// 11 включить автоотключение
// 1000-1013 включить эффект
// 2000-2255 установить цвет 
// 3000-3255 установить яркость

};

cl_alarm alarms[col_alarms];

void cl_alarm::alarm_start(uint8_t h,uint8_t m)
{
 if (on_off)
  if (flags.get(dayofweek))
   if (h*60+m==round(alarm_time/60))
   {
     switch (alarm_action) {
      case 0: 
        ONflag=false;
       break;
      case 10: 
         OFFflag=false;
       break;
      case 11: 
         OFFflag=true;
       break;
      case 1000 ... 1000+MAX_EFFECT: 
       ONflag=true;
       EFFECT=alarm_action-1000;
       break;
      case 2000 ... 2255: 
       HUE_START=alarm_action-2000;
       break;
      case 3000 ... 3255: 
       MAX_BRIGHT=alarm_action-3000;
       break;
     }
   }
}

#define select_effect "\
Микс 1 мин,\
Цвeт,\
Cмeнa цвeтa,\
Бeзyмиe,\
Oблaкa,\
Лaвa,\
Плaзмa,\
Paдyгa 3D,\
Пaвлин,\
3eбpa,\
Лec,\
Oкeaн,\
Огненные искры,\
Холодные искры,\
Цвет и искры,\
Радужный огонь и искры,\
Радужные искры,\
Радуга из центра,\
Пламя,\
Oгoнь 2012,\
Радуга,\
Радужный огонь,\
Смена цвета и искры,\
Радуга из центра искры,\
Paзнoцвeтный дoждь,\
Снег,\
Радужный дoждь\
"
